ObjScreen = Obj:new()

-- e: effect key
-- w, h
function ObjScreen:new(o, c)
    o = o or Obj:new(o, nil, c.x,c.z, true)
    setmetatable(o, self)
    self.__index = self
    o.effectKey = c.e
    o.dims = dPMakeS(c.w,c.h)
    return o
end

function ObjScreen:setEffectKey(key)
    Obj.update(self)
    self.effectKey = key
end

function ObjScreen:update()
    Obj.update(self)
end

function ObjScreen:blank(scrPTL,dims)
    dRectF(scrPTL,dims, 2)
end

function ObjScreen:curve(scrPTL,dims)
    local hx,hy,iw,ih = dims.x/2,dims.y/2,dims.x*.4,dims.y*.4
    dRectF(scrPTL,dims, 0)
    for i=0,20 do
        local a=(self.tAlive + i)*.01
        local x,y=hx+sin(a)*iw,hy+cos(a*.3)*ih
        dPixSet(dPAdd(scrPTL,x, y), i)
    end
end

function ObjScreen:plasma(scrPTL,dims)
    local s = PLATFORM == 'p' and 2 or 1
    local alive=self.tAlive*.01
    for y=0,dims.y-1,s do
        local ySin=sin(y/50+alive)+sin(y/20)
        for x=0,dims.x-1,s do
            local c=sin(x/50+alive)+ySin
            dPixSet(dPAdd(scrPTL,x,y),dFloor(c*8)%16)
        end
    end
end

function ObjScreen:tunnel(scrPTL,dims)
    local s = PLATFORM == 'p' and 2 or 1
    local alive=self.tAlive*.1
    for y=0,dims.y-1,s do
        for x=0,dims.x-1,s do
            local ex,ey = x-dims.x/2,y-dims.y/2
            local a = (atan2(ey,ex))*16
            local d = 100/sqrt(ex*ex+ey*ey+1)+alive
            dPixSet(dPAdd(scrPTL,x,y),dFloor(a+d)%16)
        end
    end
end

function ObjScreen:_draw(scrPos)
    local scrPTL = dPAdd(scrPos,-self.dims.x/2,-self.dims.y/2)
    if scrPTL.x>SCRW or scrPTL.x+self.dims.x<0 then
        return
    end

    dRectF(dPAdd(scrPTL,-2,-2),dPAdd(self.dims,4,8), 0)    -- stretch out monitor border
    if self.effectKey == 'curve' then
        self:curve(scrPTL,self.dims)
    elseif self.effectKey == 'plasma' then
        self:plasma(scrPTL,self.dims)
    elseif self.effectKey == 'tunnel' then
        self:tunnel(scrPTL,self.dims)
    else
        self:blank(scrPTL,self.dims)
    end
end
