ObjActor = Obj:new()

function ObjActor:new(o,c)
    o = o or Obj:new(o, prims, c.x,c.z, true)
    setmetatable(o, self)
    o.speech = nil
    o.t = c.t
    o.ela,o.eld=0,0
    o.era,o.erd=0,0
    self.__index = self
    return o
end

function ObjActor:speak(text, duration)
    self.speech = {
        text=text,
        duration=duration,
        lastChirp=0,
    }
end

-- a: {ela=0,eld=1,era,erd},
function ObjActor:anim(a)
    self.ela=(a.ela ~= nil and a.ela or self.ela)
    self.eld=(a.eld ~= nil and a.eld or self.eld)
    self.era=(a.era ~= nil and a.era or self.era)
    self.erd=(a.erd ~= nil and a.erd or self.erd)
end

function ObjActor:update()
    Obj.update(self)
    if self.speech then
        self.speech.duration = self.speech.duration - 1
        if self.speech.duration <= 0 then
            self.speech = nil
        end
    end
end

function ObjActor:_draw(pScrO)
    self.postDraw = nil

    local m=self.speech and self.speech.duration or 0
    local c={
        m=(.5+sin(m/40)*.6)+(.5+sin(m/15)*.4)/2,
        ela=self.ela,eld=self.eld,era=self.era,erd=self.erd
    }
    local prims=getPrimsActor(self.t,c)
    drawPrims(prims, pScrO)

    if self.speech then
        if self.speech.lastChirp == 0 and self.speech.duration>15 then
            dSfxChirp(self.t)
            self.speech.lastChirp = random(3,4)
        else
            self.speech.lastChirp = self.speech.lastChirp-1
        end
        local mlText=MLText:new(self.speech.text, SCRW*.6, 2)
        self.postDraw = function()
            drawSpeechBubble(mlText, 4,3, pScrO)
        end
    end
end

function drawSpeechBubble(mlText, mX,mY, pActor)
    local bW = mX + mlText:getW() + mX
    local bH = mY + mlText:getH() + mY
    local bX=pActor.x
    local bY=pActor.y-60
    local xIdeal,scrMX=30,8
    local scrMY=8
    if bX <= SCRWH then -- print to the right
        bX=bX+xIdeal
        if bX+bW>SCRW-scrMX then
            bX=SCRW-scrMX-bW
        end
        t1x,t1y = pActor.x + 10, pActor.y - 20
        t2x,t2y = bX + 5, bY + bH
        t3x,t3y = bX + 15, bY + bH
    else -- print to the left
        bX=bX-xIdeal-mlText:getW()
        if bX<scrMX then
            bX=scrMX
        end
        t1x,t1y = pActor.x - 10, pActor.y - 20
        t2x,t2y = bX + bW - 5, bY + bH
        t3x,t3y = bX + bW - 15, bY + bH           
    end

    if bY<scrMY then
        bY=scrMY
    end

    local bP=dPMake(bX,bY)
    dRectF(dPAdd(bP, -1,-1), dPMake(bW, bH), 13)
    dTriF(dPMake(t1x+1,t1y), dPMake(t2x+1,t2y), dPMake(t3x+1,t3y), 14)
    dRectF(dPAdd(bP, 1,1), dPMake(bW, bH), 14)
    dTriF(dPMake(t1x,t1y), dPMake(t2x,t2y), dPMake(t3x,t3y), 12)

    dRectF(bP, dPMake(bW,bH), 12)
    mlText:print(dPAdd(bP, mX,mY), 0, -1)
end
