Camera = {}
Camera.__index = Camera

function Camera:new(x)
    local o = {}
    setmetatable(o, Camera)
    o.pos = {x=x}
    o.movement = nil
    return o
end

function Camera:set(x)
    self.movement = nil
    self.pos.x = x
end

function Camera:get()
    return {x=self.pos.x}
end

function Camera:move(x, d)
    self.movement = {
        t=0,
        duration=d,
        fromPos={x=self.pos.x},
        toPos={x=x},
    }
end

function Camera:update()
    if self.movement then
        self.movement.t=self.movement.t+1
        local fr = self.movement.t/self.movement.duration
        self.pos.x = self.movement.fromPos.x + (self.movement.toPos.x - self.movement.fromPos.x) * fr

        if self.movement.t >= self.movement.duration then
            self.movement = nil
        end
    end
end
