                    !cpu 6510

DEBUG = 0
RELEASE = 1
; ==============================================================================
ENABLE              = 0x20
ENABLE_JMP          = 0x4C
DISABLE             = 0x2C

BLACK               = 0x00
WHITE               = 0x01
RED                 = 0x02
CYAN                = 0x03
PURPLE              = 0x04
GREEN               = 0x05
BLUE                = 0x06
YELLOW              = 0x07
ORANGE              = 0x08
BROWN               = 0x09
PINK                = 0x0A
DARK_GREY           = 0x0B
GREY                = 0x0C
LIGHT_GREEN         = 0x0D
LIGHT_BLUE          = 0x0E
LIGHT_GREY          = 0x0F
; ------------------------------------------------------------------------------
;                   BADLINEs (0xD011 default)
;                   -------------------------
;                   00 : 0x33
;                   01 : 0x3B
;                   02 : 0x43
;                   03 : 0x4B
;                   04 : 0x53
;                   05 : 0x5B
;                   06 : 0x63
;                   07 : 0x6B
;                   08 : 0x73
;                   09 : 0x7B
;                   10 : 0x83
;                   11 : 0x8B
;                   12 : 0x93
;                   13 : 0x9B
;                   14 : 0xA3
;                   15 : 0xAB
;                   16 : 0xB3
;                   17 : 0xBB
;                   18 : 0xC3
;                   19 : 0xCB
;                   20 : 0xD3
;                   21 : 0xDB
;                   22 : 0xE3
;                   23 : 0xEB
;                   24 : 0xF3
; ------------------------------------------------------------------------------
IRQ_LINE00          = 0x00
IRQ_LINE01          = 0x2A
IRQ_LINE02          = 0x66
IRQ_LINE03          = 0xF8
; ==============================================================================
zp_start            = 0x02
flag_irqready_top   = zp_start
flag_irqready_bot   = flag_irqready_top+1
savea               = flag_irqready_bot+1
savex               = savea+1
savey               = savex+1
save1               = savey+1
frame_ct_0          = save1+1
frame_ct_1          = frame_ct_0+1
frame_ct_2          = frame_ct_1+1

; ==============================================================================
KEY_CRSRUP          = 0x91
KEY_CRSRDOWN        = 0x11
KEY_CRSRLEFT        = 0x9D
KEY_CRSRRIGHT       = 0x1D
KEY_RETURN          = 0x0D
KEY_STOP            = 0x03

getin               = 0xFFE4
keyscan             = 0xEA87
; ==============================================================================
vicbank0            = 0x0000
vicbank1            = 0x4000
bitmap0             = vicbank1+0x0000
charset0            = vicbank0+0x1000
vidmem0             = vicbank0+0x0400
vidmem1             = vicbank1+0x2C00
sprite_data         = vicbank1+0x2000
sprite_base         = <((sprite_data-vicbank1)/0x40)
sprite_data0        = vicbank0+0x0E80
sprite_base0        = <((sprite_data0-vicbank0)/0x40)
dd00_val0           = <!(vicbank0/0x4000) & 3
d018_val0           = <(((vidmem0-vicbank0)/0x400) << 4)+ <(((charset0-vicbank0)/0x800) << 1)
dd00_val1           = <!(vicbank1/0x4000) & 3
d018_val1           = <(((vidmem1-vicbank1)/0x400) << 4)+ <(((bitmap0-vicbank1)/0x800) << 1)
music_init          = 0x1000
music_play          = music_init+3
data_start0         = vicbank0+0x3400
data_start1         = vicbank1+0x3000
irqs_start          = 0x0900
; ==============================================================================
                    !macro flag_set .flag {
                        lda #1
                        sta .flag
                    }
                    !macro flag_clear .flag {
                        lda #0
                        sta .flag
                    }
                    !macro flag_get .flag {
                        lda .flag
                    }
; ==============================================================================
                    *= sprite_data0
                    !bin "gfx/santa.spr"
                    *= music_init
                    !bin "sid/everybody_hates_this_song.mus"
music_end:
code_start          = music_end
                    *= bitmap0
bitmap_src:         !bin "gfx/xmas.bmp"
                    *= sprite_data
sprites_src:        !fi 4*64, 0
sprites_end:
; ==============================================================================
                    * = irqs_start
                    !zone IRQ
                    NUM_IRQS = 0x04
                    !align 255, 0, 0
irq:                sta savea               ; 03  10  (07+03)
                    stx savex               ; 03  13
                    sty savey               ; 03  16
                    lda 0x01                ; 03  19
                    sta save1               ; 03  22
                    lda #<.irq_timing       ; 02  24
                    sta 0xFFFE              ; 04  26
                    lda #>.irq_timing       ; 02  28
                    sta 0xFFFF              ; 04  32
                    inc 0xD012              ; 06  38
                    asl 0xD019              ; 06  44
                    tsx                     ; 02  46
                    cli                     ; 02  48
                    !fi 8, 0xEA             ; 02  64  (08*02)
.irq_timing:        txs
                    ldx #0x08
-                   dex
                    bne -
                    bit 0xEA
                    nop
irq_plus_cmp:       lda #<IRQ_LINE00+1
                    cmp 0xD012
                    beq irq_next
irq_next:           jmp irq00
; ------------------------------------------------------------------------------
irq_end:            lda 0xD012
-                   cmp 0xD012
                    beq -
.irq_index:         ldx #0x00
                    lda irq_tab_lo,x
                    sta irq_next+1
                    lda irq_tab_hi,x
                    sta irq_next+2
                    lda irq_lines,x
                    sta 0xD012
                    sta irq_plus_cmp+1
                    inc irq_plus_cmp+1
                    inc .irq_index+1
                    lda .irq_index+1
                    cmp #NUM_IRQS
                    bne +
                    lda #0x00
                    sta .irq_index+1
+                   lda #<irq
                    sta 0xFFFE
                    lda #>irq
                    sta 0xFFFF
                    asl 0xD019
                    lda save1
                    sta 0x01
                    lda savea
                    ldx savex
                    ldy savey
                    rti
irq_tab_lo:         !byte <irq00, <irq01, <irq02, <irq03
irq_tab_hi:         !byte >irq00, >irq01, >irq02, >irq03
irq_lines:          !byte IRQ_LINE00, IRQ_LINE01, IRQ_LINE02, IRQ_LINE03
; ------------------------------------------------------------------------------
                    !align 255, 0, 0
irq00:              lda #0x3B
                    sta 0xD011
                    lda #0x18
                    sta 0xD016
                    lda #dd00_val1
                    sta 0xDD00
                    lda #d018_val1
                    sta 0xD018
                    jsr frame_counter
                    +flag_set flag_irqready_top
                    jmp irq_end
; ------------------------------------------------------------------------------
irq01:              ldx #0x09
-                   dex
                    bpl -
                    ldx #0x05
--                  lda tab_top_bar,x
                    sta 0xD020
                    ldy #0x08
-                   dey
                    bpl -
                    nop
                    nop
                    dex
                    bpl --
                    sta 0xD021
enable_music:       jsr music_play
                    jmp irq_end
; ------------------------------------------------------------------------------
irq02:              jsr sprites_set
                    jsr sprites_col
                    jsr sprites_rot_coltab
enable_scroller:    bit scroller
                    jmp irq_end
; ------------------------------------------------------------------------------
irq03:              ldx #0x09
-                   dex
                    bpl -
                    ldx #0x05
--                  lda tab_bot_bar,x
                    sta 0xD020
                    ldy #0x08
-                   dey
                    bpl -
                    nop
                    nop
                    dex
                    bpl --
                    +flag_set flag_irqready_bot
                    jmp irq_end
; ==============================================================================
                    !zone BASICFADE
basicfade:          lda 0xD020
                    cmp 0xD021
                    bne +
                    lda 0xD021
                    eor #(BLUE XOR LIGHT_BLUE)
                    sta 0xD020
+                   sta .d020_sav
                    ldy #0x09
--                  jsr .wait_bottom_long
                    ldx #0x27
-                   lda #0xA0
.dst_vid1:          sta vidmem0,x
.dst_vid2:          sta vidmem0+(24*40),x
                    lda .d020_sav
.dst_col1:          sta 0xD800,x
.dst_col2:          sta 0xD800+(24*40),x
                    dex
                    bpl -
                    clc
                    lda .dst_vid1+1
                    adc #0x28
                    sta .dst_vid1+1
                    sta .dst_col1+1
                    bcc +
                    inc .dst_vid1+2
                    inc .dst_col1+2
+                   sec
                    lda .dst_vid2+1
                    sbc #0x28
                    sta .dst_vid2+1
                    sta .dst_col2+1
                    bcs +
                    dec .dst_vid2+2
                    dec .dst_col2+2
+                   dey
                    bpl --
                    ; make sure middle lines are empty
                    lda #0x20
                    ldx #0x27
-                   !for i, 0, 4 {
                        sta vidmem0+(40*(10+i)),x
                    }
                    dex
                    bpl -
                    ; sprites setup
                    lda .d020_sav
                    sta 0xD027
                    sta 0xD028
                    sta 0xD029
                    sta 0xD02A
                    sta 0xD02B
                    ldx #0x8A
                    !for i, 0, 4 {
                        stx 0xD001+2*i
                        lda #0x58+(i*24)
                        sta 0xD000+2*i
                    }
                    lda #0x00
                    !for i, 5, 7 {
                        sta 0xD000+2*i
                    }
                    ldx #sprite_base0+2
                    stx vidmem0+0x3F8
                    inx
                    stx vidmem0+0x3F9
                    inx
                    stx vidmem0+0x3FA
                    inx
                    stx vidmem0+0x3FB
                    lda #sprite_base0
                    sta vidmem0+0x3FC
                    lda #0x00
                    sta 0xD017
                    sta 0xD01B
                    sta 0xD01C
                    sta 0xD01D
                    lda #0x1F
                    sta 0xD010
                    sta 0xD015
                    ; little spriteloop
.spriteloop:        jsr .wait_bottom
                    jsr .sprite_move
                    jsr .sprite_anim0
                    jsr .sprite_anim1
.check:             lda #0
                    bne +
                    jmp .spriteloop
                    ; fill rest from right to left
+                   ldy #0x27
-                   jsr .wait_bottom
                    lda .d020_sav
                    sta 0xD800+(10*40),y
                    sta 0xD800+(11*40),y
                    sta 0xD800+(12*40),y
                    sta 0xD800+(13*40),y
                    sta 0xD800+(14*40),y
                    lda #0xA0
                    sta vidmem0+(10*40),y
                    sta vidmem0+(11*40),y
                    sta vidmem0+(12*40),y
                    sta vidmem0+(13*40),y
                    sta vidmem0+(14*40),y
                    dey
                    bpl -
                    lda #0x0B
                    sta 0xD011
                    ldy #0x00
-                   jsr .wait_top_long
                    lda .colfade_tab,y
                    bmi +
                    sta 0xD020
                    iny
                    jmp -
+                   sta 0xD021
                    rts
.d020_sav:          !byte 0x00
.colfade_tab:       !byte 0x0E, 0x03, 0x0D, 0x01, 0x0D, 0x03, 0x0C, 0x04
                    !byte 0x02, 0x09, 0x00, 0xF0
; ------------------------------------------------------------------------------
                    SPR_MOV_SPEED = 0x01
.sprite_move:       lda #SPR_MOV_SPEED
                    beq +
                    dec .sprite_move+1
                    rts
+                   lda #SPR_MOV_SPEED
                    sta .sprite_move+1
                    ldy #0x0E
                    ldx #0x07
-                   clc
                    lda .xpos_tab,x
                    asl
                    sta 0xD000,y
                    rol 0xD010
                    dec .xpos_tab,x
                    dey
                    dey
                    dex
                    bpl -
                    lda .xpos_tab+4
                    cmp #0xF8
                    bne +
                    lda #1
                    sta .check+1
+                   rts
.xpos_tab:          !for i, 0, 3 {
                        !byte <0xAC+(i*12)
                    }
                    !byte 0xDD
                    !for i, 5, 7 {
                        !byte 0x00
                    }
; ------------------------------------------------------------------------------
                    SPR_ANIM0_SPEED = 0x05
.sprite_anim0:      lda #SPR_ANIM0_SPEED
                    beq +
                    dec .sprite_anim0+1
                    rts
+                   lda #SPR_ANIM0_SPEED
                    sta .sprite_anim0+1
                    ldx #0x03
-                   inc vidmem0+0x3F8,x
                    lda vidmem0+0x3F8,x
                    cmp #sprite_base0+6
                    bne +
                    lda #sprite_base0+2
                    sta vidmem0+0x3F8,x
+                   dex
                    bpl -
                    rts
; ------------------------------------------------------------------------------
                    SPR_ANIM1_SPEED = 0x03
.sprite_anim1:      lda #SPR_ANIM1_SPEED
                    beq +
                    dec .sprite_anim1+1
                    rts
+                   lda #SPR_ANIM1_SPEED
                    sta .sprite_anim1+1
                    lda vidmem0+0x3FC
                    eor #(sprite_base0 XOR sprite_base0+1)
                    sta vidmem0+0x3FC
                    rts
; ------------------------------------------------------------------------------
.wait_bottom_long:  ldx #0x06
-                   jsr .wait_top
                    jsr .wait_bottom
                    dex
                    bpl -
                    rts
; ------------------------------------------------------------------------------
.wait_top_long:     ldx #0x04
-                   jsr .wait_top
                    dex
                    bpl -
                    rts
; ------------------------------------------------------------------------------
.wait_bottom:       lda #0xFF
-                   cmp 0xD012
                    bne -
                    lda 0xD012
-                   cmp 0xD012
                    beq -
                    rts
; ------------------------------------------------------------------------------
.wait_top:          bit 0xD011
                    bpl .wait_top
-                   bit 0xD011
                    bmi -
                    rts
; ==============================================================================
; lib_vidmemfill
; ------------+-----------------------------------------------------------------
; depends on: | -
; ------------+-----------------------------------------------------------------
; uses:       | A, X
; ------------+-----------------------------------------------------------------
; preserves:  | A
; ------------+---+-------------------------------------------------------------
; input:      | A | fill value
;             | X | highbyte vidmem startaddress
; ------------+---+-------------------------------------------------------------
; output:     | - |
; ------------+---+-------------------------------------------------------------
                    !zone LIB_VIDMEMFILL
lib_vidmemfill:     stx .mod1+2
                    inx
                    stx .mod2+2
                    inx
                    stx .mod3+2
                    stx .mod4+2
                    ldx #0x00
.mod1:              sta 0x0000,x
.mod2:              sta 0x0000,x
.mod3:              sta 0x0000,x
.mod4:              sta 0x00E8,x
                    inx
                    bne .mod1
                    rts
; ==============================================================================
                    !zone FRAME_COUNT
frame_counter:      clc
                    lda frame_ct_0
                    adc #1
                    sta frame_ct_0
                    lda frame_ct_1
                    adc #0
                    sta frame_ct_1
                    lda frame_ct_2
                    adc #0
                    sta frame_ct_2
                    rts
; ==============================================================================
                    !zone BITMAP_ANIM
                    BITMAP_ANIM_SPEED = 0x0C
anim_bitmap:        lda #BITMAP_ANIM_SPEED+0x0C
                    beq +
                    dec anim_bitmap+1
                    rts
+                   lda #BITMAP_ANIM_SPEED
                    sta anim_bitmap+1
.toggle:            lda #0x00
                    beq +
                    jsr xmas_step2_bmp_to_xmas_bmp
                    jsr xmas_step2_col_to_xmas_col
                    jsr xmas_step2_scr_to_xmas_scr
                    lda #0x00
                    sta .toggle+1
                    rts
+                   jsr xmas_bmp_to_xmas_step2_bmp
                    jsr xmas_col_to_xmas_step2_col
                    jsr xmas_scr_to_xmas_step2_scr
                    lda #0x01
                    sta .toggle+1
                    rts
; ==============================================================================
                    !zone INIT
; ------------------------------------------------------------------------------
init_irq:           lda irq_lines
                    sta 0xD012
                    sta irq_plus_cmp+1
                    inc irq_plus_cmp+1
                    lda #<irq
                    sta 0xFFFE
                    lda #>irq
                    sta 0xFFFF
                    lda 0x0B
                    sta 0xD011
                    lda #0x01
                    sta 0xD019
                    sta 0xD01A
                    rts
; ------------------------------------------------------------------------------
init_music:         lda #0x00
                    tax
                    tay
                    jsr music_init
fake:               rts
; ------------------------------------------------------------------------------
init_nmi:           lda #<nmi
                    sta 0x0318
                    sta 0xFFFA
                    lda #>nmi
                    sta 0x0319
                    sta 0xFFFB
                    rts
; ------------------------------------------------------------------------------
init_vic:           lda #dd00_val0
                    sta 0xDD00
                    lda #d018_val0
                    sta 0xD018
                    lda #0x00
                    ldx #0xD8
                    jsr lib_vidmemfill
                    rts
; ------------------------------------------------------------------------------
init_zp:            lda #0x00
                    ldx #zp_start
-                   sta 0x00,x
                    inx
                    bne -
                    rts
; ==============================================================================
                    !zone NMI
nmi:                lda #0x37               ; restore 0x01 standard value
                    sta 0x01
                    lda #0                  ; if AR/RR present
                    sta 0xDE00              ; reset will lead to menu
                    jmp 0xFCE2              ; reset
; ==============================================================================
                    !zone WAIT
wait_irq_top:       +flag_clear flag_irqready_top
-                   +flag_get flag_irqready_top
                    beq -
                    rts
; ------------------------------------------------------------------------------
wait_irq_bot:       +flag_clear flag_irqready_bot
-                   +flag_get flag_irqready_bot
                    beq -
                    rts
; ==============================================================================
block_before_music_end:
; ==============================================================================
                    !zone CODE_START
                    *= code_start
                    lda #0x7F
                    sta 0xDC0D
                    lda #0x35
                    sta 0x01
                    lda #0x1B
                    sta 0xD011
; ==============================================================================
init_code:          jsr init_nmi
                    jsr init_zp
                    jsr init_music
                    jsr basicfade
                    jsr init_vic
                    jsr init_irq
; ==============================================================================
                    !zone MAINLOOP
mainloop:           ldx #0x2F
-                   jsr wait_irq_bot
                    dex
                    bpl -
                    ; fade in logo
                    ldy #0x0A
--                  ldx #0x14
.src_vid1:          lda bitmap_vid+(1*40),x
.dst_vid1:          sta vidmem1+(1*40),x
.src_col1:          lda bitmap_col+(1*40),x
.dst_col1:          sta 0xD800+(1*40),x
                    dex
                    bne .src_vid1
                    clc
                    lda .src_vid1+1
                    adc #0x28
                    sta .src_vid1+1
                    sta .dst_vid1+1
                    sta .src_col1+1
                    sta .dst_col1+1
                    bcc +
                    inc .src_vid1+2
                    inc .dst_vid1+2
                    inc .src_col1+2
                    inc .dst_col1+2
+                   ldx #0x4
-                   jsr wait_irq_bot
                    dex
                    bpl -
                    dey
                    bpl --
                    ldx #0x3F
-                   jsr wait_irq_bot
                    dex
                    bpl -
                    ; fade in rest
                    ldy #0x18
--                  ldx #0x27
.src_vid2:          lda bitmap_vid+(24*40),x
.dst_vid2:          sta vidmem1+(24*40),x
.src_col2:          lda bitmap_col+(24*40),x
.dst_col2:          sta 0xD800+(24*40),x
                    dex
                    bpl .src_vid2
                    sec
                    lda .src_vid2+1
                    sbc #0x28
                    sta .src_vid2+1
                    sta .dst_vid2+1
                    sta .src_col2+1
                    sta .dst_col2+1
                    bcs +
                    dec .src_vid2+2
                    dec .dst_vid2+2
                    dec .src_col2+2
                    dec .dst_col2+2
+                   ldx #0x04
-                   jsr wait_irq_bot
                    dex
                    bpl -
                    dey
                    bpl --
                    ; wait some time
-                   lda frame_ct_1
                    cmp #0x02
                    bne -
-                   lda frame_ct_0
                    cmp #0x6F
                    bne -
                    ; delete xmas meeting
                    jsr wait_irq_bot
                    ldy #0x14
--                  lda #0x00
                    sta vidmem1+(8*40),y
                    sta 0xD800+(8*40),y
                    ldx #0x05
-                   jsr wait_irq_bot
                    dex
                    bpl -
                    dey
                    bne --
                    jsr wait_irq_bot
                    lda #ENABLE
                    sta enable_scroller
-                   jsr wait_irq_bot
                    jsr anim_bitmap
                    jmp -
; ==============================================================================
                    !zone SCROLLER
scroller:           lda #0x07
                    beq +
                    dec scroller+1
                    jsr .scroll
                    rts
+                   lda #0x07
                    sta scroller+1
                    jsr .get_text
                    jsr .fill_buf
                    jsr .scroll
                    rts
; ------------------------------------------------------------------------------
.get_text:
.pt_scrolltext:     lda scrolltext
                    cmp #0xFF
                    beq .text_reset
                    tay
                    clc
                    lda .pt_scrolltext+1
                    adc #0x01
                    sta .pt_scrolltext+1
                    lda .pt_scrolltext+2
                    adc #0x00
                    sta .pt_scrolltext+2
                    tya
                    rts
; ------------------------------------------------------------------------------
.text_reset:        lda #<scrolltext
                    sta .pt_scrolltext+1
                    lda #>scrolltext
                    sta .pt_scrolltext+2
                    lda #' '
                    rts
; ------------------------------------------------------------------------------
.scroll:            !for j, 0, 7 {
                        rol scrollchar+j
                        rol sprite_data+(3*64)+3+(j*3)
                        !for i, 2, 0 {
                            rol sprite_data+(i*64)+3+2+(j*3)
                            rol sprite_data+(i*64)+3+1+(j*3)
                            rol sprite_data+(i*64)+3+0+(j*3)
                        }
                    }
                    rts
; ------------------------------------------------------------------------------
.fill_buf:          clc
                    rol
                    rol
                    rol
                    sta .char_point+1
                    bcc +
                    inc .char_point+2
+                   ldx #0x07
.char_point:        lda charset_src,x
                    sta scrollchar,x
                    dex
                    bpl .char_point
                    lda #(<charset_src)
                    sta .char_point+1
                    lda #(>charset_src)
                    sta .char_point+2
                    rts
scrollchar:         !fi 8, 0
; ==============================================================================
                    !zone SPRITES
                    !align 255, 0, 0
sprites_col:        ldx #0x0A
-                   dex
                    bpl -
                    nop
                    ldx #0x00
--                  lda sprites_coltab,x
                    sta 0xD027
                    sta 0xD028
                    sta 0xD029
                    sta 0xD02A
                    ldy #0x03
-                   dey
                    bpl -
                    nop
                    nop
                    inx
                    cpx #0x06
                    bne --
                    lda sprites_coltab,x
                    sta 0xD027
                    sta 0xD028
                    sta 0xD029
                    sta 0xD02A
                    inx
                    lda sprites_coltab,x
                    nop
                    nop
                    sta 0xD027
                    sta 0xD028
                    sta 0xD029
                    sta 0xD02A
                    inx
                    ldy #0x02
-                   dey
                    bpl -
--                  lda sprites_coltab,x
                    sta 0xD027
                    sta 0xD028
                    sta 0xD029
                    sta 0xD02A
                    ldy #0x03
-                   dey
                    bpl -
                    nop
                    nop
                    inx
                    cpx #0x0E
                    bne --
                    lda sprites_coltab,x
                    sta 0xD027
                    sta 0xD028
                    sta 0xD029
                    sta 0xD02A
                    inx
                    lda sprites_coltab,x
                    nop
                    nop
                    sta 0xD027
                    sta 0xD028
                    sta 0xD029
                    sta 0xD02A
                    rts
sprites_coltab:     !byte 0x00, 0x06, 0x0B, 0x0E
                    !byte 0x0C, 0x0F, 0x03, 0x01
                    !byte 0x01, 0x01, 0x03, 0x0F
                    !byte 0x0C, 0x0E, 0x0B, 0x06
sprites_coltab_sav: !byte 0x00
; ------------------------------------------------------------------------------
                    SPRCOL_ROTATE_SPEED = 0x03
sprites_rot_coltab: lda #SPRCOL_ROTATE_SPEED
                    beq +
                    dec sprites_rot_coltab+1
                    rts
+                   lda #SPRCOL_ROTATE_SPEED
                    sta sprites_rot_coltab+1
                    lda sprites_coltab
                    sta sprites_coltab_sav
                    ldx #0x00
-                   lda sprites_coltab+1,x
                    sta sprites_coltab,x
                    inx
                    cpx #0x10
                    bne -
                    rts
; ------------------------------------------------------------------------------
sprites_set:        ldx #sprite_base
                    stx vidmem1+0x3F8
                    inx
                    stx vidmem1+0x3F9
                    inx
                    stx vidmem1+0x3FA
                    inx
                    stx vidmem1+0x3FB

                    lda #0x6B
                    sta 0xD001
                    sta 0xD003
                    sta 0xD005
                    sta 0xD007

                    lda #0x20
                    sta 0xD000
                    lda #0x20+(1*48)
                    sta 0xD002
                    lda #0x20+(2*48)
                    sta 0xD004
                    lda #0x20+(3*48)
                    sta 0xD006

                    lda #WHITE
                    sta 0xD027
                    sta 0xD028
                    sta 0xD029
                    sta 0xD02A

                    lda #0x00
                    sta 0xD010
                    sta 0xD01B
                    sta 0xD01C

                    lda #0x0F
                    sta 0xD017
                    sta 0xD01D

                    lda #0x0F
                    sta 0xD015
                    rts
; ==============================================================================
                    !zone SPEEDCODE
                    !src "inc/bitmap_speedcode0.asm"
                    !src "inc/bitmap_speedcode1.asm"
                    !src "inc/colram_speedcode0.asm"
                    !src "inc/colram_speedcode1.asm"
                    !src "inc/vidmem_speedcode0.asm"
                    !src "inc/vidmem_speedcode1.asm"
speedcode_end:
; ==============================================================================
                    !zone DATA
                    *= data_start0
                    !align 1023, 0, 0
bitmap_col:         !bin "gfx/xmas.col"
                    !align 1023, 0, 0
charset_src:        !bin "gfx/charset.chr"
                    *= data_start1
bitmap_vid:         !bin "gfx/xmas.scr"
                    !byte 0xFF
tab_bot_bar:        !byte 0x02, 0x04, 0x0A, 0x0F, 0x0A, 0x04
tab_top_bar:        !byte 0x00, 0x04, 0x0A, 0x0F, 0x0A, 0x04
scrolltext:         !src "scrolltext.asm"
                    !byte 0xFF
scrolltext_end:
                    *= scrolltext_end-1
; ==============================================================================
code_end:
