import ddf.minim.*;

Minim minim;
AudioPlayer player;

int cols, rows;
int scl = 15;
int w = 2200;
int h = 1600;
PImage frames;
float flying = 0;
float[][] terrain;

Drop[] drops  = new Drop[500];

PVector[][] globe;
int total = 8;
float phase = 0;
float speed = 0.01;
float xoff = 0;

float rdm;
int x_th = 1;
int y_th = 1;
boolean xbig = false;
float colour = random (255);

int flicker = 0;
PImage frameStart;
PImage frameEnd;

float a_ml = 380;
PFont KanitExtraBold;
PFont KanitRegular;
PFont KanitFrame;
int gloomFrameCount = 0;

Ball b;
Strokes s;
speedlines sl;


void setup() {
  size(800, 800, P3D);
  smooth(2);
  cols = w / scl;
  rows = h / scl;
  terrain = new float[cols][rows];
  globe = new PVector[total+1][total+1];
  frames = loadImage("frameNoTextNoShapes01.png");
  frameStart = loadImage("startframe02.png");
  frameEnd = loadImage("endframe06.png");

  KanitExtraBold = createFont("Kanit-ExtraBold.ttf", 180);
  KanitFrame = createFont("Kanit-ExtraBold.ttf", 158);
  KanitRegular = createFont("Kanit-Regular.ttf", 20);
  minim = new Minim(this);
  player = minim.loadFile("Gloomy_song3.mp3");
  player.play();

  b = new Ball();
  s = new Strokes();
  sl = new speedlines();
  
  frameRate(60);

  for (int i = 0; i < drops.length; i++) {
    drops[i] = new Drop();
  }
}

void glitch() {
  int xImg = int(frameStart.width);
  int yImg = int(frameStart.height);
  color imgColor = frameStart.get(xImg, yImg);

  noStroke();
  fill(imgColor, 50);
  rect(xImg, yImg, 300, 100);
}


void glitch2() {
  int xImg = int(width);
  int yImg = int(height);
  color imgColor = frameStart.get(xImg, yImg);

  noStroke();
  stroke(imgColor);

  if (random(1) < 0.5) {
    line(0, yImg, width, yImg);
  } else {
    line(xImg, 0, xImg, height);
  }
}

void glitch3() {
  int xImg = int(random(width));
  int yImg = int(random(height));


  stroke(255, 57, 0);
  
  if (random(1) < 0.5) {
    line(0, yImg, width, yImg);
  } else {
    line(xImg, 0, xImg, height);
  }
}


int counter = 10;


void draw() {
  int xImg = int(random(frameStart.width));
  int yImg = int(random(frameStart.height));
  color imgColor = frameStart.get(xImg, yImg);

  counter = counter+ 5;

  if (frameCount <= 340) {
    image(frameStart, 0, 0);
    noStroke();
    fill(imgColor, 250);
    rect(xImg, yImg, 30+counter, 50+counter);
    sl.display();
  }

  if (frameCount == 340) {
    background(0);
  }

  if (frameCount >= 340 && frameCount < 3300) {

    flying -= 0.01;

    pushMatrix();
    pointLight(248, 102, 1, width/3, height, 300);
    pointLight(121, 58, 190, 2*width/3, -height, 300);


    float yoff = flying;
    for (int y = 0; y < rows; y++) {
      float xoff = 0;
      for (int x = 0; x < cols; x++) {
        terrain[x][y] = map(noise(xoff, yoff), 0, 1, -100, 250) + 750* exp(abs(map(x, 0, cols, -1.1, 1.1)));
        xoff += 0.15;
      }
      yoff += 0.15;
    }

    //background(0);
    stroke(0);
    strokeWeight(1);
    fill(255, 255, 255);
    translate(width/2+80, height+700);
    rotateX(PI/2.9);

    glitch3();
    translate(-w/2, -h/2);
    for (int y = 0; y < rows-1; y++) {
      beginShape(TRIANGLE_STRIP);
      for (int x = 0; x < cols; x++) {
        vertex(x*scl, y*scl, terrain[x][y]);
        vertex(x*scl, (y+1)*scl, terrain[x][y+1]);
      }

      endShape();
    }

    //glitch();
    popMatrix();

    if (frameCount > 1300 && frameCount < 3300) {
      pushMatrix();

      float rdm = random (7);
      stroke(204+x_th, 102, 0+x_th);

      noFill();

      if (xbig == false) {
        x_th++;
        if (x_th == 300 ) {
          xbig = true;
        }
      } else if (xbig == true ) {
        y_th++;

        if (y_th == 300) {
          xbig = false;
        }
      }

      for (int i = 0; i < 300; i += 20) {
        pushMatrix();
        stroke(204+x_th, 102, 34+i);
        strokeWeight(rdm);

        rotateY(30+i);
        rotateX(50);
        bezier(colour+x_th+i, 500+x_th+i, 300+x_th+i, 20+i, 360+y_th, 45+y_th, 900+y_th, 320+y_th);

        popMatrix();
      }

      popMatrix();
    }


    lights();
    camera();
    hint(DISABLE_DEPTH_TEST);
    frames();
    s.display();
    b.display();
    GloomText();
    years();



    pushMatrix();

    for (int i = 0; i < drops.length; i++) {
      drops[i].fall();
      drops[i].show();
    }

    translate(730, 700, 0);
    // Some rotation for animation
    rotateX(phase/2);
    rotateY(phase/2);
    rotateZ(phase/2);
    //noFill();
    glitch();
    stroke(0);
    float r = 50;

    for (int i = 0; i < total+1; i++) {
      float lat = map(i, 0, total, 0, PI);

      beginShape(TRIANGLE_STRIP);

      for (int j = 0; j < total+1; j++) {
        float lon = map(j, 0, total, 0, TWO_PI);

        float x = r * sin(lat) * cos(lon);
        float y = r * sin(lat) * sin(lon);
        float z = r * cos(lat);
        globe[i][j] = new PVector(x, y, z);


        if (i!=0) {
          PVector v1 = globe[i-1][j];
          PVector v2 = globe[i][j];

          // Draw triangle with vertex
          vertex(v1.x, v1.y, v1.z);
          vertex(v2.x, v2.y, v2.z);
        }
      }
      endShape();
    }

    phase += speed;

    popMatrix();
  }

  if ((frameCount > 2300) && (frameCount < 3300)) {
    pushMatrix();
    gloomFrameCount += 1;
    if (gloomFrameCount < 100 || gloomFrameCount > 200) {
      GloomBG();
      Gloom();
    } else {
      GloomBG2();
      Gloom();
    }

    if (gloomFrameCount == 200) {
      gloomFrameCount = 0;
    }

    popMatrix();
  }
  if (frameCount == 3300) {
    background(0);
  }

  if (frameCount >= 3300) {
    background(0);
    image(frameEnd, 0, 0);
    glitch3();
    
  }

  if (frameCount > 4000) {
    exit();
  }
}



void Gloom() {
  textSize(180);
  textFont(KanitExtraBold);
  fill(#ffffff);
  text("GLOOM", 170, a_ml, 0);
  a_ml = a_ml -0.2;
  glitch3();
}

void GloomBG() {
  fill(#F44E03);
  textSize(180);
  textFont(KanitExtraBold);
  //fill(#6B53BB, 30);
  text("GLOOM", 170, a_ml, 0);
  a_ml = a_ml -0.2;
}

void GloomBG2() {
  //fill(#410190);
  fill(#8B38F2);
  textSize(180);
  textFont(KanitExtraBold);
  //fill(#B174EF, 30);
  text("GLOOM", 170, a_ml, 0);
  a_ml = a_ml -0.2;
}

void frames() {
  image(frames, 0, 0);
}

void GloomText() {
  textSize(158);
  textFont(KanitFrame);
  fill(#F44E03, random(225, 255));
  text("GLOOM", 42, 783);
}

void years() {
  textSize(20);
  textFont(KanitRegular);
  fill(#F44E03, random(225, 255));
  text("est. 2023", 578, 783);
}
