// modified from https://github.com/anissen/ld34/blob/master/web/assets/shaders/sepia.glsl

#version 130

precision mediump float;

uniform sampler2D currentTexture;
varying vec2 tcoord;

uniform vec3 greyscaleConversion;
uniform vec3 sepiaColor;
uniform float amount;

void main() {
	vec4 fragColor = texture2D(currentTexture, gl_TexCoord[0]);
	float grey = dot(fragColor.rgb, greyscaleConversion);
	gl_FragColor = vec4(mix(fragColor.rgb, vec3(grey) * sepiaColor, amount), fragColor.a);
}
