#%%
import math
from math import sin, cos
import numpy as np


palette = "█░ "
width = 80
height = 30


def scene(pos, i):
    pos = np.array(pos)

    rot_x = 2.4 + i * 0.0
    rot_y = 1.3 + i * -0.2
    
    matrix_x = np.array([
        [1, 0, 0],
        [0, cos(rot_x), -sin(rot_x)],
        [0, sin(rot_x), cos(rot_x)]
    ])

    matrix_y = np.array([
        [cos(rot_y), 0, sin(rot_y)],
        [0, 1, 0],
        [-sin(rot_y), 0, cos(rot_y)]
    ])

    pos = np.matmul(pos, matrix_x)
    pos = np.matmul(pos, matrix_y)

    cs = 0.2
    cube = np.maximum(np.minimum(pos, np.array([cs, cs, cs])), np.array([-cs, -cs, -cs]))
    
    diff = pos - cube

    mag = np.sqrt(diff.dot(diff))
    return mag


def shader(x, y):
    uv_x = x / width - 0.5
    uv_y = y / height - 0.5

    ray_start = np.array([uv_x, uv_y, 10.0])
    ray_dir = np.array([0., 0., -1.])
    dist = 0.0
    position = np.array([uv_x, uv_y, 10.0])
    total_dist = 0.0
    
    for i in range(100):

        # ldist = 99999999.0
        # for x in range(3):
        #     for y in range(3):
        #         pos_2 = position + np.array([x - 1, y - 1, 0.0]) * 0.3
        #         ldist = min(ldist, scene(pos_2, x * 3 + y))

        # dist = ldist

        dist = scene(position, 1)

        total_dist += dist
        position += dist * ray_dir
        if dist > 10000:
            break

    # if dist < 0.1 and total_dist < 100.0:
    #     print(f"dist: {total_dist:.2f}")

    alpha = 1. - (total_dist * 0.03)
    character = palette[0] if alpha > 0.7 else palette[1] if alpha > 0.0 else palette[2]
    return character


result = ""

for y in range(height):
    for x in range(width):
        result += shader(x, y)
    result += "\n"

with open("output.txt", "w") as f:
    f.write(result)