comment +

 888888888888
        ,88'     8I          256 byte DOS-intro "Mercury"
      ,88"       8I          Code:    bitl/7dump  (2023)
     ,88'        8I          mailto:  aleks_gs@yahoo.com
  aaa888aa       8I
   ,8P     ,gggg,8I  gg      gg   ,ggg,,ggg,,ggg,   gg,gggg,
  ,88     dP"  "Y8I  I8      8I  ,8" "8P" "8P" "8,  I8P"  "Yb
  88'    i8'    ,8I  I8,    ,8I  I8   8I   8I   8I  I8'    ,8i
  88    ,d8,   ,d8b,,d8b,  ,d8b,,dP   8I   8I   Yb,,I8 _  ,d8'
  88    P"Y8888P"`Y88P'"Y88P"`Y88P'   8I   8I   `Y8PI8 YY88888P
                                                    I8
   GrEeTiNgS  & ReSpEct:                            I8
   baze, sensenstahl, TomCat/Abaddon, iONic, y0bi   I8
   wbcbz7,  p01,  pestis, Asato, rrrola,  Optimus   I8
   superogue, Kuemmel, Digimind, Manwe, LBi, JinX   I8
                                                    I8
   For compilation  use   Turbo  Assembler 2.02     I8
   tasm /m2 mercury.asm   tlink /t mercury.obj      I8

comment end! +

mode60  = 0  ; extended version (midi-sound and 60hz vga-mode)
CAMERA_HEIGHT = 4
NUM_OBJECTS = 15

xtr  = 0
v128 = 2
v16  = 4
v30  = 6
ytr  = 8
q    = 10
hei  = 12

.model tiny
.data
_xtr    DW 0a000h    ;0
_v128   DW 128       ;2
_v16    DW 16        ;4
_v30    DW 32*256    ;6


IF mode60
vga60    dw 0b06h, 3e07h, 0c310h, 8c11h, 8f12h, 9015h, 0b16h
midi     db 0c0h,  126, 90h, 15, 45, 0,  0c1h, 122
midi2    db 81h, 44, 45, 0, 0,  91h, 44, 45, 0, 0
midi_off db 0b0h,  123, 123, 0b1h, 123, 123
ENDIF

.code
.486
org 0100h

start:

mov al,13h
int 10h

add dh, al                 ; cs + 1300h
mov fs, dx                 ; segment for texture
add dh, al
mov es, dx
mov gs, dx


;**********************************************************************
; TEXTURES AND PALETTE GENERATOR
;**********************************************************************

mov bx, 0ff00h+NUM_OBJECTS

@texture:
lodsw
mov dh, al
and dh, bh   ;size
xchg ax,di   ;offset

xor cx, cx
@l1:
   mov al, cl
   imul al
   xchg ax, bp
   mov al, ch
   imul al
   add ax, bp
   cmp ax, dx
   ja @skip
      mov al,bh
      inc ax
      imul ax, ax, 12
      mov byte ptr fs:[di], al
   @skip:

   mov ax, cx

   pusha
   mov dx,3c8h
   out dx, al
   inc dx
   shr al, 2
   out dx, al
   out dx, al
   out dx, al
   popa

   shl ax, 1
   xor al, ah
   shr al, 2
   stosb
loop @l1

mov bh, 3
dec bl
jnz @texture


IF mode60
pusha
mov dx, 3d4h               ; Set tweaked 60hz VGA mode 320x200
push dx
mov al, 11h
out dx, al
inc dx
in al, dx
and al, 7fh
out dx, al
mov dx, 3C2h
mov al, 0e3h
out dx, al
pop dx
lea si, vga60
mov cx, 7
rep outsw

mov al, 3Fh   ; set UART mode - command
mov dx, 331h  ; MIDI Control Port
out dx, al
dec dx
lea si, midi
mov cx, 8
rep outsb     ; start noise sound
popa
ENDIF


lea si, _xtr                    ; set SI to DATA-offset
mov es, ds:[si]


fninit

;**********************************************************************
; MAIN LOOP
;**********************************************************************
@mainloop:
push ds
mov ds, di
mov ax, ds:[46Ch]
pop ds

IF mode60
test al, 127  ; play seashore effect
jnz @skip_play_midi
pusha
lea si, midi2
mov cx, 10
mov dx, 330h
rep outsb
popa
@skip_play_midi:
ENDIF

mov ds:[si+q], ax

mov di, 319
@maindraw: ;for x:=0 to 319 do begin
  push di

  ;Tcos := round(cos(q/128)*128);  Tsin := round(sin(q/128)*128);
  fild word ptr ds:[si+v16]
  fild word ptr ds:[si+v128]            ;   128  |
  fild word ptr ds:[si+q]               ;    q   |  128
  fdiv st(0), st(1)                     ;  q/128 |  128
  fsincos                               ;  cos   |  sin   |  128
  fld st(2)                             ;  128   |  cos   |  sin  |  128
  fmul st(1), st(0)                     ;  128   |  Tcos  |  sin  |  128
  fmulp st(2), st(0)                    ;  Tcos  |  Tsin  |  128

  ; (x-160)
  mov ds:[si+xtr], di
  sub word ptr ds:[si+xtr], 160

  ;sx:=Tcos*(x-160);
  fld st                                ;  Tcos  |  Tcos   |  Tsin  |  128
  fimul word ptr ds:[si+xtr]            ;   sx   |  Tcos   |  Tsin  |  128

  ;ytr:= sx - Tsin*128;
  fld st(3)                             ;   128  |   sx    |  Tcos  |  Tsin  |  128
  fmul st(0), st(3)                     ;Tsin*128|   sx    |  Tcos  |  Tsin  |  128
  fsubp st(1), st(0)                    ;   ytr  |  Tcos   |  Tsin  |  128
  fistp word ptr ds:[si+ytr]            ;  Tcos  |  Tsin   |  128   |

  ;cx:=Tsin*(x-160); xtr:= cx + Tcos*128;
  fmulp st(2), st(0)                    ;  Tsin  | Tcos*128|
  fimul word ptr ds:[si+xtr]            ;   cx   | Tcos*128|
  faddp st(1), st(0)                    ;  xtr   |
  fist word ptr ds:[si+xtr]

  ;hei:=round(cos(q/16+xtr/(30*256))*16+16);
  fidiv word ptr ds:[si+v30]            ; xtr/v30 | v16   }
  fild word ptr ds:[si+q]               ;   q     | xtr/v |  v16   }
  fdiv st(0),st(2)                      ;  q/v16  | xtr/v |  v16   }
  faddp st(1), st(0)                    ;  q+xtr  |  v16  }
  fcos                                  ;  cos    |  v16  }
  fmul st(0),st(1)                      ; cos*v16 |  v16  }
  faddp st(1), st(0)                    ;  hei    }
  fistp word ptr ds:[si+hei]

  mov cx, 0c814h
  xor bp, bp
  @draw_column:
      add bp, CAMERA_HEIGHT
      mov ax, ds:[si+xtr]
      cwd
      idiv bp
      sub ax, word ptr ds:[si+q]
      xchg ax, bx

      mov ax, ds:[si+ytr]
      cwd
      idiv bp
      add ax, word ptr ds:[si+q]

      add bh, al
      mov al, fs:[bx]

      test al, al ; if col=0 then begin
      jnz @not_zero

          cmp cl, 32  ; if col2 > 32 then col:=mem[vaddr3:word(xt+(col2+yt)*256)]+col2*2;}
          jbe @overwater
             add bh, cl
             mov al, gs:[bx]
          @overwater:
             add al, cl
             add al, cl
             sbb dl, dl
             or al, dl

             inc cx  ;inc(col2);
             jmp @draw
      @not_zero:

          mov cl, ds:[si+hei]     ; else col2:=hei;

      @draw:
      stosb    ; mem[vaddr:vdi]:=byte(col);
      add di, 319

  dec ch
  jnz @draw_column

pop di
dec di
jnz @maindraw


in al, 60h               ; wait for any key
das

jp @mainloop             ; none received, start over


;**********************************************************************
; EXIT
;**********************************************************************
IF mode60
lea si, midi_off
mov cx, 6                ; Stop all sound
mov dx, 330h
rep outsb

mov ax, 3                ; back to text
int 10h                  ; mode
ENDIF
ret
end start

