// Sketch uses 1564 bytes (4%) of program storage space. Maximum is 32256 bytes.
// Global variables use 192 bytes (9%) of dynamic memory, leaving 1856 bytes for local variables. Maximum is 2048 bytes.
// This sketch uses 1564 - 1456 (for an empty nearly sketch) = 108 Bytes of code

void setup() {
  Serial.begin(115200);
}

// As the star is symmetrical, we only have to calculate the quadrant I and use abs() for the point coordinates
// I try both, calculating the dots and calulating the spaces. Dots is round about 36 bytes smaller.
void loop() {
  // This is the y-coordinate, as the Terminal runs from top to botton, the order is 8..-8
  for (int8_t y = 8; y >= -8; y--) {
    byte ay = abs(y);
    // this is the x-ccordinate
    for (int8_t x = -8; x <= 8; x++) {
      byte ax = abs(x);
      if ((ax <= 4) && (ay <= 4)) {
        // the middle quader
        Serial.print("*");
        continue;
      } else if (((ax <= 4) && (ay > 4)) || ((ay <= 4) && (ax > 4))) {
        if (abs(ax - ay) <= 4) {
          // the rays
          Serial.print("*");
          continue;
        }
      }
      Serial.print(" ");
    }
    Serial.println();
  }
  while (true)
    ;
}
