 ; Xmas Star for Atari 8-bit. Contains *no* executable code, just data.
 ; Takes full advantage of the Atari multi-segmented binary load format.

 .include "atari.inc"
 .include "xex.inc"
 .macpack atari ; for the scrcode macro

 ; Sadly, this has to be different for 400/800 and XL/XE, because it's
 ; not a documented part of the OS API, and Atari changed it between
 ; the old 400/800 OS and the new XL/XE one.
 .ifndef kgetch
 kgetch = $f2fd ; XL/XE only; on 400/800, use $f6e2 (works for OS A or B).
 .endif

 .out .sprintf("Using $%04x for kgetch", kgetch)

 color_white   = $0e ; max luminance, chroma 0 (black)
 enable_screen = $22 ; goes in SDMCTL

 ; Everything fits in Page 6.
 dlist       = $0600
 screendata  = $0630
 screenlimit = $06ff

 DL_GR1 = DL_CHR20x8x2 ; cc65 name for "GR.1" is hard to read.

 ; Load the screen data first, so the display list can use it.
 xex_org screendata,screenlimit

 ; Each of these lines is exactly 20 bytes (decimal). l1 through
 ; l9 get displayed in order, then l8 through l1 in reverse order.
l1: scrcode "     *       *      "
l2: scrcode "     **     **      "
l3: scrcode "     ***   ***      "
l4: scrcode "     **** ****      "
l5: scrcode " *****************  "
l6: scrcode "  ***************   "
l7: scrcode "   *************    "
l8: scrcode "    ***********     "
l9: scrcode "     *********      "

 ; Load the display list.
 xex_org dlist,screendata

 ; Normal DL starts with 7 DL_BLK8's, we have 4 extra to center the image.
 .repeat 7
  .byte DL_BLK8
 .endrep

 ; First 9 lines:
 .byte DL_GR1 | DL_LMS
 .word l1
 .repeat 8 ; l2 to l9
  .byte DL_GR1
 .endrep

 ; Remaining 8 lines (reverse order):
 lineaddr .set l8
 .repeat 8 ; l8 to l1
  .byte DL_GR1 | DL_LMS
  .word lineaddr
  lineaddr .set lineaddr - 20 ; back up one line
 .endrepeat

 ; End of DL:
 .byte DL_JVB
 .word dlist

 ; Turn off ANTIC screen display.
 xex_org SDMCTL
 .word 0

 ; Set text color to bright white.
 xex_org COLOR0
 .byte color_white

 ; Tell ANTIC to use our display list.
 xex_org SDLSTL
 .word dlist

 ; Main screen turn on!
 xex_org SDMCTL
 .word enable_screen

 ; Wait for a keypress.
 xex_init kgetch

 ; Done, pretend user pressed System Reset.
 xex_run WARMSV
