	org	1BEEH	; load address

	; Initial register state
	;
	; a  = 0ch	; cassette control bits
	; hl = 1c0ah	; start address
	; bc = 0000h	; left zero from ldir
	; de = 1c2ah	; end address

	; size = 28
	defb	-25,-7,-5,-3,-1,0	; width values, inverse (negative, reverse order) and cursor end position
	defb	-1,-3,-5,-7,0		; width values, inverse (negative, reverse order)
	defb	-9,-9,-9,-9,-17,-15,-13,-11,-9,-11,-13,-15,-17,-9,-9,-9,-9  ; width values (negative, reverse order)

	call	segment	; write segment

	ld	e,' '	; write spaces
	ld	b,0	; reset cursor to line 0

	call	segment	; clear parts

	ld	b,13	; set cursor to line 13

segment:
	dec	hl	; point to last width value / find next width value
	ld	a,(hl)	; store current width value in A (HL contains start address)
	rrca		; halve width value
	add	d	; center by value of H (= 20 decimal)
	ret	nc	; stop on non negative width values (expect zeros before width table)
	ld	c,a	; column
	inc	b	; row
	ld	(0b7a0h),bc ; set cursor position

row:
	ld	a,e	; store ascii value for star in A (parameter value for system routine call that follows)
	call	0e329h	; call system routine "CRT"
	inc	(hl)	; inc width toward zero
	jr	nz,row	; repeat until zero
	jr	segment
