/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import processing.core.PException;
import processing.core.PMIDlet;
import processing.core.PRequest;

public class PClient {
    protected PMIDlet midlet;
    protected String server;
    protected int port;
    protected String authorization;
    static final char[] charTab = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();

    public PClient(PMIDlet pMIDlet, String string) {
        this(pMIDlet, string, 80);
    }

    public PClient(PMIDlet pMIDlet, String string, int n) {
        this.midlet = pMIDlet;
        this.server = string;
        this.port = n;
    }

    public void setAuthorization(String string, String string2) {
        String string3 = string + ":" + string2;
        this.authorization = "Basic " + PClient.encode(string3.getBytes());
    }

    public static String urlencode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isDigit(c) || Character.isLowerCase(c) || Character.isUpperCase(c)) {
                stringBuffer.append(c);
                continue;
            }
            if (c == ' ') {
                stringBuffer.append('+');
                continue;
            }
            stringBuffer.append('%');
            if (c < '\u0010') {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toHexString(c));
        }
        return stringBuffer.toString();
    }

    public PRequest GET(String string) {
        return this.request(string, null, null);
    }

    public PRequest GET(String string, String[] stringArray, String[] stringArray2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("?");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(stringArray[i]);
            stringBuffer.append("=");
            stringBuffer.append(PClient.urlencode(stringArray2[i]));
            if (i >= n - 1) continue;
            stringBuffer.append("&");
        }
        return this.GET(stringBuffer.toString());
    }

    public PRequest POST(String string, String[] stringArray, String[] stringArray2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                printStream.print("&");
            }
            printStream.print(PClient.urlencode(stringArray[i]));
            printStream.print("=");
            printStream.print(PClient.urlencode(stringArray2[i]));
        }
        return this.request(string, "application/x-www-form-urlencoded", byteArrayOutputStream.toByteArray());
    }

    public PRequest POST(String string, String[] stringArray, Object[] objectArray) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                printStream.print("--BOUNDARY_185629\r\n");
                printStream.print("Content-Disposition: form-data; name=\"");
                printStream.print(stringArray[i]);
                if (objectArray[i] instanceof String) {
                    printStream.print("\"\r\n");
                    printStream.print("\r\n");
                    printStream.print((String)objectArray[i]);
                    printStream.print("\r\n");
                    continue;
                }
                if (!(objectArray[i] instanceof byte[])) continue;
                byte[] byArray = (byte[])objectArray[i];
                printStream.print("\"; filename=\"");
                printStream.print(stringArray[i]);
                printStream.print("\"\r\n");
                printStream.print("Content-Type: application/octet-stream\r\n");
                printStream.print("Content-Transfer-Encoding: binary\r\n\r\n");
                ((OutputStream)printStream).write(byArray);
                printStream.print("\r\n");
            }
            printStream.print("--BOUNDARY_185629--\r\n\r\n");
            return this.request(string, "multipart/form-data; boundary=BOUNDARY_185629", byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new PException(iOException);
        }
    }

    protected PRequest request(String string, String string2, byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("http://");
        stringBuffer.append(this.server);
        if (this.port != 80) {
            stringBuffer.append(":");
            stringBuffer.append(this.port);
        }
        stringBuffer.append(string);
        PRequest pRequest = new PRequest(this.midlet, stringBuffer.toString(), string2, byArray, this.authorization);
        Thread thread = new Thread(pRequest);
        thread.start();
        return pRequest;
    }

    public static String encode(byte[] byArray) {
        return PClient.encode(byArray, 0, byArray.length, null).toString();
    }

    public static StringBuffer encode(byte[] byArray, int n, int n2, StringBuffer stringBuffer) {
        int n3;
        int n4;
        if (stringBuffer == null) {
            stringBuffer = new StringBuffer(byArray.length * 3 / 2);
        }
        int n5 = n2 - 3;
        int n6 = 0;
        for (n4 = n; n4 <= n5; n4 += 3) {
            n3 = (byArray[n4] & 0xFF) << 16 | (byArray[n4 + 1] & 0xFF) << 8 | byArray[n4 + 2] & 0xFF;
            stringBuffer.append(charTab[n3 >> 18 & 0x3F]);
            stringBuffer.append(charTab[n3 >> 12 & 0x3F]);
            stringBuffer.append(charTab[n3 >> 6 & 0x3F]);
            stringBuffer.append(charTab[n3 & 0x3F]);
            if (n6++ < 14) continue;
            n6 = 0;
            stringBuffer.append("\r\n");
        }
        if (n4 == n + n2 - 2) {
            n3 = (byArray[n4] & 0xFF) << 16 | (byArray[n4 + 1] & 0xFF) << 8;
            stringBuffer.append(charTab[n3 >> 18 & 0x3F]);
            stringBuffer.append(charTab[n3 >> 12 & 0x3F]);
            stringBuffer.append(charTab[n3 >> 6 & 0x3F]);
            stringBuffer.append("=");
        } else if (n4 == n + n2 - 1) {
            n3 = (byArray[n4] & 0xFF) << 16;
            stringBuffer.append(charTab[n3 >> 18 & 0x3F]);
            stringBuffer.append(charTab[n3 >> 12 & 0x3F]);
            stringBuffer.append("==");
        }
        return stringBuffer;
    }
}

