
//Lisenssi: HYKKEOHL1, kts. tiedosto KOPIOINTI

//Tss projektissa on painotettu tyskentelyn nopeutta ja tuloksena oli sitten tylsti muokattavaa purkkakoodia
//Peli on kehitetty ikkuna-tilaan, fullscreen on buginen
//Tekstidataa on peitelty sen verran, ett lhdekoodia voi lukea ilman spoilereita

#include <iostream>
#include <string>
#include <vector>
#include <unistd.h>
#include <cmath>
#include <stdexcept>
#include <pthread.h>

#include <SDL2/SDL.h>
#include <SDL2/SDL_image.h>
#include <SDL2/SDL_ttf.h>
#include <SDL2/SDL_mixer.h>

#define INTRO 0
#define ALKURUUTU 1
#define VALINTARUUTU 2
#define PELI 3
#define HISCORE 4
#define SIIRRYTAAN_PELIIN 5
#define TAKAISIN_ALKURUUTUUN 6

#define PELI_LOPPUI 1
#define PELI_ALKAA 2
#define KYSYMYKSEN_LUONTI 3
#define SEURAAVA_KYSYMYS 4
#define LAATIKKO_ISONTUU 5
#define KYSYMYKSEN_RENDAUS 6
#define KYSYMYKSEN_KYSYMINEN 7
#define OIKEIN 8
#define VAARIN 9
#define VOITTO 10
#define HAHMONVAIHTO 11
#define KILPAILIJAN_TAPPAMINEN 12
#define EI_PELISSA 13

#define PISTOOLI 0
#define HAPPO 1
#define TULI 2
#define KIRVES 3
#define PUMPPU 4
#define TYHJA 5

using namespace std;

const int RUUDUNLEVEYS = 680;
const int RUUDUNKORKEUS = 480;
const int ALPHA_POHJA = 10;

Mix_Music *ostinato = NULL;
Mix_Music *alkumusiikki = NULL;
Mix_Music *hiscomusiikki = NULL;
Mix_Music *peliohi = NULL;
Mix_Music *voittoaani = NULL;
Mix_Chunk *oikeinaani = NULL;
Mix_Chunk *vaarinaani = NULL;
Mix_Chunk *kploppu = NULL;
Mix_Chunk *aihevalinta = NULL;
Mix_Chunk *pelialkaa = NULL;
Mix_Chunk *kursoribeep = NULL;
Mix_Chunk *sekuntibeep = NULL;
Mix_Chunk *loiskisaani = NULL;
Mix_Chunk *pumppuaani = NULL;
Mix_Chunk *pistooliaani = NULL;
Mix_Chunk *valinta1 = NULL;
Mix_Chunk *valinta2 = NULL;
Mix_Chunk *kirjain = NULL;
Mix_Chunk *luku = NULL;
Mix_Chunk *uuskys = NULL;
Mix_Chunk *aikapiip = NULL;
Mix_Chunk *aikameni = NULL;
Mix_Chunk *kirveshuuto = NULL;
Mix_Chunk *tuliaani = NULL;
Mix_Chunk *vipuaani = NULL;
Mix_Chunk *luukkuaani = NULL;
int soita_aani;
int soita_musa;

int ohjelmantila;
int pelinvaihe;
int vaihecounter;
int vaihecounter2;
int heilutus;

char valinta = '0';
string kysymysteksti;
string vaihtoehto1;
string vaihtoehto2;
string vaihtoehto3;
string vaihtoehto4;
char paikat[5];
string oikea_vastaus;
string selitys;
int kystekstix = 150;
int kystekstiy = 85;
char kumpi;
char kumpioli;
bool deaktivoidut_laatikot[3];
int kirjainkountteri = 0;
int pituus2;
int pituus3;
int pituus4;
int pituus5;
const int LISAVALI = 5;
bool katkaisu = false;
int reuna = 30;
int reuna2 = 70;
string pelaaja1;
string pelaaja2;
SDL_Surface *pelaaja1_s;
SDL_Surface *pelaaja2_s;
SDL_Texture *pelaaja1_t;
SDL_Texture *pelaaja2_t;
long long p1_pisteet;
int p1_oikeinlaskuri;
long long p2_pisteet;
int p2_oikeinlaskuri;
bool kaksinpeli;
char p1_vastaukset[10];
char p2_vastaukset[10];

int aani;

vector<string> kysymysvec;
vector<string> vastvec1;
vector<string> vastvec2;
vector<string> vastvec3;
vector<string> vastvec4;
vector<string> selitysvec;

struct kysymys {
  vector<int> kysym;
  vector<int> vast1;
  vector<int> vast2;
  vector<int> vast3;
  vector<int> vast4;
  bool luk1 = false;
  bool luk2 = false;
  bool luk3 = false;
  bool luk4 = false;
  uint8_t oikea = 1;
  uint16_t k_luku = 0;
  vector<int> selitys;
};

kysymys kysymyspohja;
uint8_t k_luku;

vector<uint16_t> kysytyt;
vector<kysymys> kysymystietokantavec;
vector<kysymys>::iterator k_iter;

bool quit = false;
bool fullscreen = false;
bool kys_rendattu = false;

SDL_Color tekstivari = {240, 240, 240};
SDL_Color tekstivari_h = {200, 200, 200};
SDL_Color kyslaatvari = {182, 0, 0};

const int MERKINPITUUS = 9;
const int MERKINKORKEUS = 18;
const int RIVIVALI = 0;

TTF_Font* fontti;
TTF_Font* fontti2;
SDL_Surface* pinta2;
SDL_Texture* tekstuuri2;
const int RIVINPITUUS = 40;

SDL_Texture *oikeinteksti;
SDL_Texture *vaarinteksti;
SDL_Texture *loppuiteksti;
SDL_Texture *loppuiteksti2;
SDL_Texture *loppukehotus;
SDL_Texture *tasateksti;
SDL_Texture *enem1_teksti;
SDL_Texture *enem2_teksti;
SDL_Texture *aikateksti;
SDL_Texture *voittoteksti;
SDL_Texture *kakpellopteksti;
SDL_Texture *painateksti;
SDL_Texture *entteriateksti;

struct kokstruct {
  int x = 20+140;
  double y = 281.0;
  double kerroin = 0.7;
  int counter = 0;
};

struct kokstruct2 {
  int x;
  int y;
};

bool tekstiskrolli = false;
int skrollausarvo = 0;

bool init();
bool lataamedia();
void sammutus();

SDL_Window* ikkuna = NULL;
SDL_Renderer* piirturi = NULL;


class tekstuuriluokka {
  int leveys;
  int korkeus;
public:
  SDL_Texture* tekstuuri;
  tekstuuriluokka();
  ~tekstuuriluokka();
  bool tiedostonlataus(string filename);
  void erase();
  void renderfunktio(int x, int y, SDL_Rect* temprect = NULL, int flip = 0, double kulmaa = 0.0);
  int haeleveys();
  int haekorkeus();
  void aseta_blend(SDL_BlendMode blend_arvo);
  void alphafunktio(Uint8 alpha_arvo);
};

int hahmoja = 0;
bool ilmeet = true;
SDL_Rect spurdo_arkki[27];
SDL_Rect gooby_arkki[26];
SDL_Rect dolan_arkki[6];
SDL_Rect pistooliarkki[10];
SDL_Rect kirvesarkki[8];
SDL_Rect vipuarkki[25];
SDL_Rect pumppuarkki[13];
SDL_Rect deyes_arkki[2];
SDL_Rect dolblink_arkki[2];
SDL_Rect spblink_arkki[2];
SDL_Rect diginum_arkki[16];
SDL_Rect kyy_arkki[10];
SDL_Rect naps_arkki[4];
SDL_Rect splash_arkki[9];
SDL_Rect hurme_arkki[4];
SDL_Rect hurme2_arkki[8];
SDL_Rect aspurdo_arkki[14];
SDL_Rect adolan_arkki[4];

tekstuuriluokka taustakuva;
tekstuuriluokka kulma;
tekstuuriluokka palkki;
tekstuuriluokka palkki2;
tekstuuriluokka tekstilogo;
tekstuuriluokka tuli;
tekstuuriluokka kirvesteks;
tekstuuriluokka viputeks;
tekstuuriluokka led;
tekstuuriluokka kok;
tekstuuriluokka doleyes;
tekstuuriluokka dolblinkteks;
tekstuuriluokka spblinkteks;
tekstuuriluokka gblinkteks;
tekstuuriluokka blaatikko;
tekstuuriluokka v_laatikko;
tekstuuriluokka t_laatikko;
tekstuuriluokka alusta;
tekstuuriluokka lehti;
tekstuuriluokka tyhjalehti;
tekstuuriluokka valintapallo;
tekstuuriluokka sivu;
tekstuuriluokka vaakasivu;
tekstuuriluokka sk_laatikko;
tekstuuriluokka pimee;
tekstuuriluokka kysymystausta;
tekstuuriluokka valintatausta;
tekstuuriluokka alkutausta;
tekstuuriluokka valintaruutu3;
tekstuuriluokka valintaruutu4;
tekstuuriluokka hiscokuva;
tekstuuriluokka biojate;
tekstuuriluokka es;
tekstuuriluokka spurdoteks;
tekstuuriluokka goobyteks;
tekstuuriluokka dolanteks;
tekstuuriluokka pistooliteks;
tekstuuriluokka pumpputeks;
tekstuuriluokka diginumteks;
tekstuuriluokka kyyteks;
tekstuuriluokka napsteks;
tekstuuriluokka splashteks;
tekstuuriluokka hurmeteks;
tekstuuriluokka hurme2teks;
tekstuuriluokka aspurdoteks;
tekstuuriluokka adolanteks;
tekstuuriluokka aarteks;

tekstuuriluokka::tekstuuriluokka() {
  tekstuuri = NULL;
  leveys = 0;
  korkeus = 0;
}

tekstuuriluokka::~tekstuuriluokka() {
  erase();
}

bool tekstuuriluokka::tiedostonlataus(string filename) {
  erase();
  SDL_Texture* uusitekstuuri = NULL;
  SDL_Surface* pinta = IMG_Load(filename.c_str());
  if(pinta == NULL) cerr << "Image load fail: " << filename.c_str() << " " << IMG_GetError() << endl;
  else {
    SDL_SetColorKey(pinta, SDL_TRUE, SDL_MapRGB(pinta->format, 0, 0xFF, 0xFF));
    uusitekstuuri = SDL_CreateTextureFromSurface(piirturi, pinta);
    if(uusitekstuuri == NULL) cerr << "Texture creation fail - " << SDL_GetError << endl;
    else {
      leveys = pinta->w;
      korkeus = pinta->h;
    }
    SDL_FreeSurface(pinta);
  }
  tekstuuri = uusitekstuuri;
  return tekstuuri != NULL;
}

void tekstuuriluokka::erase() {
  if(tekstuuri != NULL) {
    SDL_DestroyTexture(tekstuuri);
    tekstuuri = NULL;
    leveys = 0;
    korkeus = 0;
  }
}

void tekstuuriluokka::renderfunktio(int x, int y, SDL_Rect* temprect, int flip, double kulmaa) {
  SDL_Rect rendnelio = {x, y, leveys, korkeus};
  if(temprect != NULL) {
    rendnelio.w = temprect->w;
    rendnelio.h = temprect->h;
  }

  SDL_RenderCopyEx(piirturi, tekstuuri, temprect, &rendnelio, kulmaa, NULL,
  		   (flip > 0 ? (flip > 1 ? (flip > 2 ? (static_cast<SDL_RendererFlip>(SDL_FLIP_HORIZONTAL | SDL_FLIP_VERTICAL))
					    : SDL_FLIP_VERTICAL) : SDL_FLIP_HORIZONTAL) : SDL_FLIP_NONE));
}

void tekstuuriluokka::aseta_blend(SDL_BlendMode blend_arvo) {
  SDL_SetTextureBlendMode(tekstuuri, blend_arvo);
}

void tekstuuriluokka::alphafunktio(Uint8 alpha_arvo) {
  SDL_SetTextureAlphaMod(tekstuuri, alpha_arvo);
}

int tekstuuriluokka::haeleveys() {return leveys;}
int tekstuuriluokka::haekorkeus() {return korkeus;}

class hahmoluokka {
public:
  int x;
  int y;
  int frame;
  tekstuuriluokka *spritet;
  SDL_Rect *hahmorect;
  hahmoluokka();
  ~hahmoluokka();
  void yhdista_tekstuuri(tekstuuriluokka*);
  void yhdista_rect(SDL_Rect *rect, int, unsigned int);
  void arkit();
};

vector<hahmoluokka*> hahmovektori;

void hahmoluokka::yhdista_tekstuuri(tekstuuriluokka *olio) {spritet = olio;}

hahmoluokka::hahmoluokka():
  frame(3), spritet(NULL) {
  hahmovektori.push_back(this);
}

hahmoluokka::~hahmoluokka() {
  delete[] hahmorect;
}

void hahmoluokka::yhdista_rect(SDL_Rect *rect, int arraynpituus, unsigned int arraynkoko) {
  hahmorect = new SDL_Rect[arraynkoko];
  for(int counter = 0; counter != arraynpituus; counter++) {
    hahmorect[counter] = rect[counter];
  }
}

void hahmoluokka::arkit() {

  for(int i = 0; i != 12; i += 3) {
    spurdo_arkki[i].x = 0;
    spurdo_arkki[i+1].x = 266;
    spurdo_arkki[i+2].x = 532;
  }
  for(int i = 0, y = 0; i != 21; i += 3) {
    spurdo_arkki[i].y = y;
    spurdo_arkki[i+1].y = y;
    spurdo_arkki[i+2].y = y;
    y += 137;
  }
  for(int i =  0; i != 12; i++) {spurdo_arkki[i].w = 264;}
  for(int i = 22; i != 27; i++) {spurdo_arkki[i].w = 264;}
  for(int i =  0; i != 27; i++) {spurdo_arkki[i].h = 135;}
  for(int i = 12; i != 22; i++) {spurdo_arkki[i].w = 318;}
  for(int i = 12; i != 21; i += 3) {
    spurdo_arkki[i].x = 0;
    spurdo_arkki[i+1].x = 320;
    spurdo_arkki[i+2].x = 640;
  }
  spurdo_arkki[21].x = 0;
  spurdo_arkki[21].y = 959;

  for(int i = 22; i != 25; i++) spurdo_arkki[i].y = 1096;
  for(int i = 22; i != 25; i++) spurdo_arkki[i].x = (i-22)*267;

  spurdo_arkki[25].x = 0;
  spurdo_arkki[26].x = 267;
  spurdo_arkki[25].y = 1233;
  spurdo_arkki[26].y = 1233;
  
  dolan_arkki[0].x = 0;
  dolan_arkki[0].y = 0;
  dolan_arkki[0].w = 356;
  dolan_arkki[0].h = 215;
  dolan_arkki[1].x = 358;
  dolan_arkki[1].y = 0;
  dolan_arkki[1].w = 356;
  dolan_arkki[1].h = 215;
  dolan_arkki[2].x = 716;
  dolan_arkki[2].y = 0;
  dolan_arkki[2].w = 356;
  dolan_arkki[2].h = 215;
  dolan_arkki[3].x = 0;
  dolan_arkki[3].y = 217;
  dolan_arkki[3].w = 356;
  dolan_arkki[3].h = 215;
  dolan_arkki[4].x = 358;
  dolan_arkki[4].y = 217;
  dolan_arkki[4].w = 356;
  dolan_arkki[4].h = 215;
  dolan_arkki[5].x = 716;
  dolan_arkki[5].y = 217;
  dolan_arkki[5].w = 356;
  dolan_arkki[5].h = 215;

  int j = 0;
  for(int i = 0; i != 5; i++) {
    pistooliarkki[i].y = j;
    pistooliarkki[i+5].y = j;
    j += 103;
  }
  for(int i = 0; i != 5; i++) pistooliarkki[i].x = 0;
  for(int i = 5; i != 10; i++) pistooliarkki[i].x = 169;
  for(int i = 0; i != 10; i++) {pistooliarkki[i].w = 167; pistooliarkki[i].h = 101;}

  for(int i = 0; i != 13; i++) {
    pumppuarkki[i].x = 0;
    pumppuarkki[i].w = 230;
    pumppuarkki[i].h = 110;
    pumppuarkki[i].y = i*112;
  }

  deyes_arkki[0].x = 0;
  deyes_arkki[0].y = 0;
  deyes_arkki[0].w = 115;
  deyes_arkki[0].h = 42;
  deyes_arkki[1].x = 115;
  deyes_arkki[1].y = 0;
  deyes_arkki[1].w = 115;
  deyes_arkki[1].h = 42;

  dolblink_arkki[0].x = 0;
  dolblink_arkki[0].y = 0;
  dolblink_arkki[0].w = 113;
  dolblink_arkki[0].h = 42;
  dolblink_arkki[1].x = 115;
  dolblink_arkki[1].y = 0;
  dolblink_arkki[1].w = 113;
  dolblink_arkki[1].h = 42;

  spblink_arkki[0].x = 0;
  spblink_arkki[0].y = 0;
  spblink_arkki[0].w = 63;
  spblink_arkki[0].h = 15;
  spblink_arkki[1].x = 68;
  spblink_arkki[1].y = 0;
  spblink_arkki[1].w = 63;
  spblink_arkki[1].h = 15;

  for(int i = 0; i != 9; i++) gooby_arkki[i].w = 264;
  for(int i = 9; i != 21; i++) gooby_arkki[i].w = 274;
  for(int i = 0; i != 21; i++) gooby_arkki[i].h = 175;

  for(int i = 0; i != 9; i += 3) {
    gooby_arkki[i].x = 0;
    gooby_arkki[i+1].x = 266;
    gooby_arkki[i+2].x = 532;
  }
  for(int i = 9; i != 21; i += 3) {
    gooby_arkki[i].x = 0;
    gooby_arkki[i+1].x = 276;
    gooby_arkki[i+2].x = 552;
  }

  for(int i = 0, y = 0; i != 21; i += 3) {
    gooby_arkki[i].y = y;
    gooby_arkki[i+1].y = y;
    gooby_arkki[i+2].y = y;
    y += 177;
  }

  for(int i = 21; i != 24; i++) {
    gooby_arkki[i].y = 1239;
    gooby_arkki[i].w = 264;
    gooby_arkki[i].h = 175;
    gooby_arkki[i].x = (i-21)*266;
  }

  gooby_arkki[24].x = 0;
  gooby_arkki[24].y = 1416;
  gooby_arkki[24].w = 264;
  gooby_arkki[24].h = 175;
  gooby_arkki[25].x = 266;
  gooby_arkki[25].y = 1416;
  gooby_arkki[25].w = 264;
  gooby_arkki[25].h = 175;

  for(int i = 0; i != 10; i++) diginum_arkki[i].y = 0;
  for(int i = 0; i != 10; i++) diginum_arkki[i].h = 47;
  for(int i = 0, j = -30; i != 10; i++) diginum_arkki[i].x = (j += 30);
  for(int i = 0; i != 10; i++) diginum_arkki[i].w = 30;

  for(int i = 10; i != 16; i++) {
    diginum_arkki[i].x = (i-10)*30+300;
    diginum_arkki[i].y = 0;
    diginum_arkki[i].h = 47;
    diginum_arkki[i].w = 30;
  }

  for(int i = 0, j = -60; i != 10; i++) kyy_arkki[i].x = (j += 60);
  for(int i = 0; i != 10; i++) {kyy_arkki[i].y = 0; kyy_arkki[i].h = 97; kyy_arkki[i].w = 58;}

  naps_arkki[0].x = 1;
  naps_arkki[0].y = 0;
  naps_arkki[0].w = 44;
  naps_arkki[0].h = 122;
  naps_arkki[1].x = 46;
  naps_arkki[1].y = 0;
  naps_arkki[1].w = 44;
  naps_arkki[1].h = 122;
  naps_arkki[2].x = 91;
  naps_arkki[2].y = 0;
  naps_arkki[2].w = 44;
  naps_arkki[2].h = 122;
  naps_arkki[3].x = 136;
  naps_arkki[3].y = 0;
  naps_arkki[3].w = 44;
  naps_arkki[3].h = 122;
  
  splash_arkki[0].x = 0;
  splash_arkki[0].y = 0;
  for(int i = 0; i != 9; i++) {
    splash_arkki[i].w = 327;
    splash_arkki[i].h = 152;
  }
  splash_arkki[1].x = 330;
  splash_arkki[1].y = 0;
  splash_arkki[2].x = 659;
  splash_arkki[2].y = 0;
  for(int i = 3; i != 6; i++) {
    splash_arkki[i].x = (i-3)*331;
    splash_arkki[i].y = 154;
  }
  splash_arkki[6].y = 308;
  splash_arkki[6].x = 0;

  for(int i = 0; i != 7; i++) {
    kirvesarkki[i].x = 0;
    kirvesarkki[i].y = i*216;
    kirvesarkki[i].w = 230;
    kirvesarkki[i].h = 214;
  }
  kirvesarkki[7].x = 232;
  kirvesarkki[7].y = 0;
  kirvesarkki[7].w = 341-232;
  kirvesarkki[7].h = 50;
    
  for(int i = 0; i != 4; i++) {
    hurme_arkki[i].x = 0;
    hurme_arkki[i].y = i*51;
    hurme_arkki[i].w = 102;
    hurme_arkki[i].h = 49;
  }
  for(int i = 0; i != 8; i++) {
    hurme2_arkki[i].x = i*67;
    hurme2_arkki[i].y = 0;
    hurme2_arkki[i].w = 65;
    hurme2_arkki[i].h = 36;
  }

  for(int i = 0; i != 25; i++) {
    vipuarkki[i].x = 0;
    vipuarkki[i].y = i*63;
    vipuarkki[i].w = 131;
    vipuarkki[i].h = 61;
  }
  for(int i = 0; i != 7; i++) {
    aspurdo_arkki[i].x = 0;
    aspurdo_arkki[i].y = i*229;
    aspurdo_arkki[i].w = 100;
    aspurdo_arkki[i].h = 227;
  }
  for(int i = 7; i != 14; i++) {
    aspurdo_arkki[i].x = 113;
    aspurdo_arkki[i].y = (i-7)*229;
    aspurdo_arkki[i].w = 100;
    aspurdo_arkki[i].h = 227;
  }
  for(int i = 0; i != 4; i++) {
    adolan_arkki[i].x = 0;
    adolan_arkki[i].y = 1+i*197;
    adolan_arkki[i].w = 131;
    adolan_arkki[i].h = 195;
  }
}

hahmoluokka spurdo;
hahmoluokka gooby;
hahmoluokka dolan;
hahmoluokka deyes;
hahmoluokka dolblink;
hahmoluokka spblink;
hahmoluokka pistooli;
hahmoluokka pumppu;
hahmoluokka kirves;
hahmoluokka vipu;
hahmoluokka diginums;
hahmoluokka kyy;
hahmoluokka naps;
hahmoluokka splash;
hahmoluokka aspurdo;
hahmoluokka adolan;
hahmoluokka hurme;
hahmoluokka hurme2;

bool init() {
  bool toimiiko = true;
  if(SDL_Init(SDL_INIT_VIDEO)<0) {
    cerr << "SDL:n initialisointivirhe - " << SDL_GetError() << endl;
    toimiiko = false;
  }
  else {
    if(!SDL_SetHint(SDL_HINT_RENDER_SCALE_QUALITY, "1")) cerr << "Lineaarinen filtterinti eponnistui" << endl;

    ikkuna = SDL_CreateWindow("Spurdo 2000", SDL_WINDOWPOS_UNDEFINED, SDL_WINDOWPOS_UNDEFINED, RUUDUNLEVEYS, RUUDUNKORKEUS, SDL_WINDOW_SHOWN | ( fullscreen ? SDL_WINDOW_FULLSCREEN : 0 ) );
    if(ikkuna == NULL) {
      cerr << "Ikkunanluomisvirhe - " << SDL_GetError() << endl;
      toimiiko = false;
    }
    else {
      SDL_SetHint(SDL_HINT_RENDER_VSYNC, "1");
      piirturi = SDL_CreateRenderer(ikkuna, -1, SDL_RENDERER_SOFTWARE);
      if(piirturi == NULL) {
	cout << "Yritetn hardware-kiihdytetty piirturia." << endl;
	piirturi = SDL_CreateRenderer(ikkuna, -1, SDL_RENDERER_ACCELERATED);
	if(piirturi == NULL) {
	  cerr << "Piirturivirhe - " << SDL_GetError() << endl;
	  toimiiko = false;
	}
      }
      SDL_RenderSetLogicalSize(piirturi, RUUDUNLEVEYS, RUUDUNKORKEUS);
      SDL_RendererInfo piirturi_info;
      SDL_GetRendererInfo(piirturi, &piirturi_info);
      SDL_SetRenderDrawColor(piirturi, 0xFF, 0xFF, 0xFF, 0xFF);
      int imgFlags = IMG_INIT_PNG;
      if(!(IMG_Init(imgFlags)&imgFlags)) {
	cerr << "Virhe: SDL_image - " << IMG_GetError() << endl;
	toimiiko = false;
      }
      else {
	if(TTF_Init() == -1) cerr << "TTF Init fail" << TTF_GetError() << endl;
      }
    }
  }

  if(SDL_Init(SDL_INIT_AUDIO)<0) {
    cerr << "SDL init fail - " << SDL_GetError() << endl;
    toimiiko = false;
  }
  else {
    if(Mix_OpenAudio(44100, MIX_DEFAULT_FORMAT, 2, 2048)<0) {
      cerr << "Mixer init fail - " << Mix_GetError() << endl;
    }
  }
  
  return toimiiko;
}


bool lataamedia() {
  bool toimiiko = true;
  if(!kysymystausta.tiedostonlataus("data/tausta.png")) {
    cerr << "png load fail" << endl;
    toimiiko = false;
  }
  if(!valintatausta.tiedostonlataus("data/tausta_dark.png")) {
    cerr << "png load fail" << endl;
    toimiiko = false;
  }
  if(!alkutausta.tiedostonlataus("data/alkutausta.png")) {
    cerr << "png load fail" << endl;
    toimiiko = false;
  }
  if(!valintaruutu3.tiedostonlataus("data/valintaruutu3.png")) {
    cerr << "png load fail" << endl;
    toimiiko = false;
  }
  if(!valintaruutu4.tiedostonlataus("data/valintaruutu4.png")) {
    cerr << "png load fail" << endl;
    toimiiko = false;
  }
  if(!biojate.tiedostonlataus("data/biojate6.png")) {
    cerr << "png load fail" << endl;
    toimiiko = false;
  }
  if(!es.tiedostonlataus("data/es.png")) {
    cerr << "png load fail" << endl;
    toimiiko = false;
  }
  if(!sk_laatikko.tiedostonlataus("data/sk_laatikko.png")) {
    cerr << "png load fail" << endl;
    toimiiko = false;
  }
  if(!vaakasivu.tiedostonlataus("data/vaakasivu.png")) {
    cerr << "png load fail" << endl;
    toimiiko = false;
  }
  if(!palkki.tiedostonlataus("data/palkki.png")) {
    cerr << "png load fail" << endl;
    toimiiko = false;
  }
  if(!aarteks.tiedostonlataus("data/aarteks.png")) {
    cerr << "aarteks load fail" << endl;
    toimiiko = false;
  }
  if(!palkki2.tiedostonlataus("data/palkki2.png")) {
    cerr << "png load fail" << endl;
    toimiiko = false;
  }
    if(!tekstilogo.tiedostonlataus("data/tekstilogo.png")) {
    cerr << "png tekstilogo fail" << endl;
    toimiiko = false;
  }
  if(!tuli.tiedostonlataus("data/tuli5.png")) {
    cerr << "png load fail" << endl;
    toimiiko = false;
  }
  if(!led.tiedostonlataus("data/led.png")) {
    cerr << "png load fail" << endl;
    toimiiko = false;
  }
  if(!hiscokuva.tiedostonlataus("data/hiscore.png")) {
    cerr << "png load fail" << endl;
    toimiiko = false;
  }
  if(!kok.tiedostonlataus("data/kok2.png")) {
    cerr << "png load fail" << endl;
    toimiiko = false;
  }
  if(!doleyes.tiedostonlataus("data/doleyes.png")) {
    cerr << "png load fail" << endl;
    toimiiko = false;
  }
  if(!dolblinkteks.tiedostonlataus("data/dolblink.png")) {
    cerr << "png load fail" << endl;
    toimiiko = false;
  }
  if(!spblinkteks.tiedostonlataus("data/spblink.png")) {
    cerr << "png load fail" << endl;
    toimiiko = false;
  }
  if(!gblinkteks.tiedostonlataus("data/gblink.png")) {
    cerr << "png load fail" << endl;
    toimiiko = false;
  }
  if(!blaatikko.tiedostonlataus("data/blaatikko.png")) {
    cerr << "png load fail" << endl;
    toimiiko = false;
  }
  if(!v_laatikko.tiedostonlataus("data/v_laatikko.png")) {
    cerr << "png load fail" << endl;
    toimiiko = false;
  }
  if(!t_laatikko.tiedostonlataus("data/t_laatikko.png")) {
    cerr << "png load fail" << endl;
    toimiiko = false;
  }
  if(!alusta.tiedostonlataus("data/alusta.png")) {
    cerr << "png alusta load fail" << endl;
    toimiiko = false;
  }
  if(!lehti.tiedostonlataus("data/lehti.png")) {
    cerr << "png load fail" << endl;
    toimiiko = false;
  }
  if(!tyhjalehti.tiedostonlataus("data/tyhjalehti.png")) {
    cerr << "png load fail" << endl;
    toimiiko = false;
  }
  if(!valintapallo.tiedostonlataus("data/vp.png")) {
    cerr << "png load fail" << endl;
    toimiiko = false;
  }
  if(!spurdoteks.tiedostonlataus("data/spurdo.png")) {
    cerr << "png load fail" << endl;
    toimiiko = false;
  }
  if(!goobyteks.tiedostonlataus("data/gooby.png")) {
    cerr << "png load fail" << endl;
    toimiiko = false;
  }
  if(!kyyteks.tiedostonlataus("data/kyy.png")) {
    cerr << "png load fail" << endl;
    toimiiko = false;
  }
  if(!dolanteks.tiedostonlataus("data/dolan.png")) {
    cerr << "png load fail" << endl;
    toimiiko = false;
  }
  if(!diginumteks.tiedostonlataus("data/diginums2.png")) {
    cerr << "png load fail" << endl;
    toimiiko = false;
  }
  if(!pistooliteks.tiedostonlataus("data/gun.png")) {
    cerr << "gun load fail" << endl;
    toimiiko = false;
  }
  if(!pumpputeks.tiedostonlataus("data/pumppu.png")) {
    cerr << "pumppu load fail" << endl;
    toimiiko = false;
  }
  if(!kirvesteks.tiedostonlataus("data/kirves.png")) {
    cerr << "kirves load fail" << endl;
    toimiiko = false;
  }
  if(!viputeks.tiedostonlataus("data/vipu.png")) {
    cerr << "vipu load fail" << endl;
    toimiiko = false;
  }
  if(!hurmeteks.tiedostonlataus("data/hurme.png")) {
    cerr << "hurme load fail" << endl;
    toimiiko = false;
  }
  if(!hurme2teks.tiedostonlataus("data/hurme2.png")) {
    cerr << "hurme2 load fail" << endl;
    toimiiko = false;
  }
  if(!kulma.tiedostonlataus("data/kulma.png")) {
    cerr << "kulma load fail" << endl;
    toimiiko = false;
  }
  if(!sivu.tiedostonlataus("data/sivu.png")) {
    cerr << "png load fail" << endl;
    toimiiko = false;
  }
  if(!aspurdoteks.tiedostonlataus("data/alkuspurdo.png")) {
    cerr << "aspurdo load fail" << endl;
    toimiiko = false;
  }
  if(!adolanteks.tiedostonlataus("data/adolan.png")) {
    cerr << "adolan load fail" << endl;
    toimiiko = false;
  }
  if(!napsteks.tiedostonlataus("data/snap.png")) {
    cerr << "png load fail" << endl;
    toimiiko = false;
  }
  if(!splashteks.tiedostonlataus("data/splash.png")) {
    cerr << "png load fail" << endl;
    toimiiko = false;
  }
  ostinato = Mix_LoadMUS("data/ostinato.wav");
  if(ostinato == NULL) {
    cerr << "Music load fail";
    toimiiko = false;
  }
  alkumusiikki = Mix_LoadMUS("data/alkumusiikki.wav");
  if(alkumusiikki == NULL) {
    cerr << "Music load fail";
    toimiiko = false;
  }
  valinta1 = Mix_LoadWAV("data/valinta1.wav");
  if(valinta1 == NULL) {
    cerr << "valinta1 load fail";
    toimiiko = false;
  }
  valinta2 = Mix_LoadWAV("data/valinta2.wav");
  if(valinta2 == NULL) {
    cerr << "valinta2 load fail";
    toimiiko = false;
  }
  kirjain = Mix_LoadWAV("data/kirjain.wav");
  if(kirjain == NULL) {
    cerr << "kirjain load fail";
    toimiiko = false;
  }
  luku = Mix_LoadWAV("data/luku2.wav");
  if(luku == NULL) {
    cerr << "luku2 load fail";
    toimiiko = false;
  }
  uuskys = Mix_LoadWAV("data/uuskys.wav");
  if(uuskys == NULL) {
    cerr << "uuskys load fail";
    toimiiko = false;
  }
  aikapiip = Mix_LoadWAV("data/aikapiip.wav");
  if(aikapiip == NULL) {
    cerr << "aikapiip load fail";
    toimiiko = false;
  }
  aikameni = Mix_LoadWAV("data/aikameni.wav");
  if(aikameni == NULL) {
    cerr << "aikameni load fail";
    toimiiko = false;
  }
  pelialkaa = Mix_LoadWAV("data/pelialkaa.wav");
  if(pelialkaa == NULL) {
    cerr << "pelialkaa load fail";
    toimiiko = false;
  }
  oikeinaani = Mix_LoadWAV("data/oikeinaani.wav");
  if(oikeinaani == NULL) {
    cerr << "oikeinaani load fail";
    toimiiko = false;
  }
  vaarinaani = Mix_LoadWAV("data/vaarinaani.wav");
  if(vaarinaani == NULL) {
    cerr << "vaarinaani load fail";
    toimiiko = false;
  }
  kploppu = Mix_LoadWAV("data/kploppu.wav");
  if(kploppu == NULL) {
    cerr << "kploppu load fail";
    toimiiko = false;
  }
  loiskisaani = Mix_LoadWAV("data/loiskisaani.wav");
  if(loiskisaani == NULL) {
    cerr << "loiskisaani load fail";
    toimiiko = false;
  }
  pumppuaani = Mix_LoadWAV("data/pumppu4.wav");
  if(pumppuaani == NULL) {
    cerr << "pumppu4 load fail";
    toimiiko = false;
  }
  pistooliaani = Mix_LoadWAV("data/pistooli3.wav");
  if(pistooliaani == NULL) {
    cerr << "pistooli3 load fail";
    toimiiko = false;
  }
  vipuaani = Mix_LoadWAV("data/vipuaani.wav");
  if(vipuaani == NULL) {
    cerr << "vipuaani load fail";
    toimiiko = false;
  }
  luukkuaani = Mix_LoadWAV("data/luukku.wav");
  if(luukkuaani == NULL) {
    cerr << "luukku load fail";
    toimiiko = false;
  }
  tuliaani = Mix_LoadWAV("data/tuliaani.wav");
  if(tuliaani == NULL) {
    cerr << "tuliaani load fail";
    toimiiko = false;
  }
  peliohi = Mix_LoadMUS("data/peliohi.wav");
  if(peliohi == NULL) {
    cerr << "peliohi load fail";
    toimiiko = false;
  }
  kirveshuuto = Mix_LoadWAV("data/bar2.wav");
  if(kirveshuuto == NULL) {
    cerr << "bar2 load fail";
    toimiiko = false;
  }
  voittoaani = Mix_LoadMUS("data/voittoaani.wav");
  if(voittoaani == NULL) {
    cerr << "voittoaani load fail";
    toimiiko = false;
  }
  aihevalinta = Mix_LoadWAV("data/aihevalinta.wav");
  if(aihevalinta == NULL) {
    cerr << "Sound load fail";
    toimiiko = false;
  }
  return toimiiko;
}

void sammutus() {
  taustakuva.erase();
  kulma.erase();
  sivu.erase();
  palkki.erase();
  palkki2.erase();
  aarteks.erase();
  tekstilogo.erase();
  tuli.erase();
  led.erase();
  kok.erase();
  doleyes.erase();
  dolblinkteks.erase();
  spblinkteks.erase();
  gblinkteks.erase();
  blaatikko.erase();
  v_laatikko.erase();
  t_laatikko.erase();
  alusta.erase();
  lehti.erase();
  tyhjalehti.erase();
  valintapallo.erase();
  spurdoteks.erase();
  goobyteks.erase();
  kyyteks.erase();
  dolanteks.erase();
  diginumteks.erase();
  pistooliteks.erase();
  pumpputeks.erase();
  kirvesteks.erase();
  viputeks.erase();
  vaakasivu.erase();
  sk_laatikko.erase();
  napsteks.erase();
  splashteks.erase();
  aspurdoteks.erase();
  adolanteks.erase();
  hurmeteks.erase();
  hurme2teks.erase();

  SDL_DestroyRenderer(piirturi);
  SDL_DestroyWindow(ikkuna);
  ikkuna = NULL;
  piirturi = NULL;
  IMG_Quit();

  Mix_FreeMusic(hiscomusiikki);
  Mix_FreeMusic(peliohi);
  Mix_FreeMusic(voittoaani);
  Mix_FreeChunk(oikeinaani);
  Mix_FreeChunk(vaarinaani);
  Mix_FreeChunk(kploppu);
  Mix_FreeChunk(aihevalinta);
  Mix_FreeChunk(pelialkaa);
  Mix_FreeChunk(kursoribeep);
  Mix_FreeChunk(sekuntibeep);
  Mix_FreeChunk(loiskisaani);
  Mix_FreeChunk(pumppuaani);
  Mix_FreeChunk(pistooliaani);
  Mix_FreeChunk(kirveshuuto);
  Mix_FreeChunk(tuliaani);
  Mix_FreeChunk(vipuaani);
  Mix_FreeChunk(luukkuaani);
  Mix_FreeChunk(valinta1);
  Mix_FreeChunk(valinta2);
  Mix_FreeChunk(kirjain);
  Mix_FreeChunk(luku);
  Mix_FreeChunk(uuskys);
  Mix_FreeChunk(aikapiip);
  Mix_FreeChunk(aikameni);
  Mix_FreeMusic(ostinato);
  Mix_FreeMusic(alkumusiikki);
  Mix_FreeMusic(hiscomusiikki);
  
  hiscomusiikki = NULL;
  peliohi = NULL;
  voittoaani = NULL;
  oikeinaani = NULL;
  vaarinaani = NULL;
  kploppu = NULL;
  aihevalinta = NULL;
  pelialkaa = NULL;
  kursoribeep = NULL;
  sekuntibeep = NULL;
  loiskisaani = NULL;
  pumppuaani = NULL;
  pistooliaani = NULL;
  kirveshuuto = NULL;
  tuliaani = NULL;
  vipuaani = NULL;
  luukkuaani = NULL;
  valinta1 = NULL;
  valinta2 = NULL;
  kirjain = NULL;
  luku = NULL;
  uuskys = NULL;
  aikapiip = NULL;
  aikameni = NULL;
  ostinato = NULL;
  alkumusiikki = NULL;

  Mix_Quit();
  TTF_Quit();
  SDL_Quit();
}

vector<string> tekstinkatkaisu(vector<string> vektori, int kirjainmaara) {
  vector<string> uusivektori;
  for(vector<string>::iterator kys_iter = vektori.begin(); kys_iter != vektori.end(); ++kys_iter) {
    string tempstring = *kys_iter;
    if(tempstring.length() <= kirjainmaara) {
      uusivektori.push_back(tempstring);
      kirjainmaara -= tempstring.length();
    }
    else {
      string newtempstring = "";
      newtempstring.assign(tempstring, 0, kirjainmaara);
      uusivektori.push_back(newtempstring);
      break;
    }
  }
  return uusivektori;
}

int tekstivektorin_pituus(vector<string> vektori) {
  int pituus = 0;
  for(vector<string>::iterator kys_iter = vektori.begin(); kys_iter != vektori.end(); ++kys_iter) {
    string tempstring = *kys_iter;
    pituus += tempstring.length();
  }
  return pituus;
}

void tekstirend(int tx, int ty, int moneskorivi, string teksti, TTF_Font* kirjaisinlaji, bool extravali = false, bool sisennys = false, int vari = 0) {

  if(teksti == "") cerr << "Tekstirend-funktioon sytetty tyhj string" << endl;
  int extra = 0;
  if(extravali) extra = LISAVALI;
  int rivinasetus = (5+((moneskorivi-1)*MERKINKORKEUS));
  if(sisennys) teksti = "   " + teksti;
  SDL_Color tvari = tekstivari;
  if(vari == 1) tvari = tekstivari_h;
  if(vari == 2) tvari = {0, 0, 0};
  SDL_Surface *pinta2 = TTF_RenderText_Solid(kirjaisinlaji, teksti.c_str(), tvari);
  int tekstinleveys = pinta2->w;
  SDL_Texture *tekstuuri2 = SDL_CreateTextureFromSurface(piirturi, pinta2);
  SDL_Rect tekstinelio = {tx+5, ty+rivinasetus-skrollausarvo+extra+RIVIVALI*(moneskorivi-1), tekstinleveys, MERKINKORKEUS};
  SDL_RenderCopy(piirturi, tekstuuri2, NULL, &tekstinelio);
  SDL_FreeSurface(pinta2);
  SDL_DestroyTexture(tekstuuri2);
}

string kr(vector<int> numteks) {
  if(numteks.size() == 0) return "";
  string merkkijono = "";
  vector<int>::iterator kriter;

  int counter = 0;
  for(kriter = numteks.begin(); kriter != numteks.end(); kriter++) {
    merkkijono.append(".");
    merkkijono[counter] = *kriter-k_luku;
    if(merkkijono[counter] == 0x3c) merkkijono[counter] = 228;
    else if(merkkijono[counter] == 0x3e) merkkijono[counter] = 196;
    else if(merkkijono[counter] == 0x5b) merkkijono[counter] = 214;
    else if(merkkijono[counter] == 0x5d) merkkijono[counter] = 246;
    else if(merkkijono[counter] == 0x7c) merkkijono[counter] = 197;
    else if(merkkijono[counter] == 0x40) merkkijono[counter] = 235;
    else if(merkkijono[counter] == 0x24) merkkijono[counter] = 233;
    else if(merkkijono[counter] == 0x2a) merkkijono[counter] = 229;
    counter++;
  }

  return merkkijono;
}

vector<string> autowrap(int RIVINPITUUS, string tekstiarg) {
  vector<string> tempvec;
  string tempstring;

  if(tekstiarg.length() <= RIVINPITUUS) {
    tempvec.push_back(tekstiarg);
    return tempvec;
  }
  
  int marker = 0;
  for(int m = tekstiarg.length(); marker == 0;  m--) {
    if(tekstiarg[m] == ' ') marker = tekstiarg.length()-m;
  }
  for(int i = RIVINPITUUS; tekstiarg.length() > marker; i--) {
    if(tekstiarg[i] == ' ') {
      tempstring = "";
      for(int j = 0; j <= i; j++) tempstring += tekstiarg[j];
      tempvec.push_back(tempstring);
      for(int k = 0; k <= i; k++) tekstiarg.erase(0,1);
      i = RIVINPITUUS;
    }
  }
  if(tekstiarg != "" or tekstiarg != " ") {
    vector<string>::iterator iter = --tempvec.end();
    if((*iter).length() + tekstiarg.length() <= RIVINPITUUS) *iter += tekstiarg;
    else tempvec.push_back(tekstiarg);
  }
  return tempvec;
}

void kysymys_init() {
  uint16_t kountteri = 1;
  for(;;) {
    kysymystietokantavec.push_back(kysymyspohja);
    vector<kysymys>::iterator k_it = kysymystietokantavec.end()-1;

    if(kountteri == 1) {
      k_it->k_luku = 80;
      k_it->kysym = {-101,-59,-69,-79,112,-61,-75,-59,-62,-79,-79,-58,-71,-61,-60,-79,112,-61,-59,-65,-67,-79,-68,-79,-71,-61,-71,-61,-60,-79,112,-72,-75,-66,-69,-71,-68,-83,-71,-61,-60,-116,112,-65,-68,-71,112,-71,-66,-61,-64,-71,-62,-79,-79,-60,-71,-65,-66,112,-68,-116,-72,-76,-75,112,-69,-65,-59,-68,-59,-79,-67,-64,-59,-70,-79,112,-96,-75,-69,-69,-79,125,-107,-62,-71,-77,112,-111,-59,-58,-71,-61,-75,-68,-68,-75,-113};
      k_it->vast1 = {-96,-75,-66,-60,-60,-71,112,-100,-71,-66,-69,-65,-68,-79};
      k_it->vast2 = {-96,-75,-69,-69,-79,112,-93,-71,-71,-60,-65,-71,-66};
      k_it->vast3 = {-93,-71,-67,-65,112,-104,-116,-55,-72,-116};
      k_it->vast4 = {-102,-79,-62,-71,112,-93,-79,-62,-79,-61,-58,-59,-65};
      k_it->luk4 = true;
    }

    if(kountteri == 2) {
      k_it->k_luku = 0;
      k_it->kysym = {77,105,110,110,101,32,115,107,105,116,115,111,102,114,101,110,105,110,101,110,32,106,111,117,107,107,111,115,117,114,109,97,97,106,97,32,83,97,110,110,97,32,83,105,108,108,97,110,112,60,60,32,108,60,104,116,105,32,97,109,109,117,116,116,117,97,97,110,32,107,111,108,109,101,32,109,105,101,115,116,60,32,72,101,108,115,105,110,103,105,110,32,107,101,115,107,117,115,116,97,115,115,97,32,115,105,106,97,105,110,110,101,101,108,108,97,32,97,109,112,117,109,97,114,97,100,97,108,108,97,32,118,117,111,110,110,97,32,49,57,57,57,63};
      k_it->vast1 = {76,101,110,116,111,107,101,110,116,60,108,108,101};
      k_it->vast2 = {82,97,117,116,97,116,105,101,97,115,101,109,97,108,108,101};
      k_it->vast3 = {76,97,105,118,97,116,101,114,109,105,110,97,97,108,101,105,108,108,101};
      k_it->vast4 = {83,97,117,110,97,97,110};
      k_it->luk4 = true;
    }

    if(kountteri == 3) {
      k_it->k_luku = 84;
      k_it->kysym = {-95,-67,-56,-71,-62,116,-60,-75,-64,-65,-65,-75,-63,-55,-58,-68,-75,-75,-66,-75,116,-66,-75,116,-60,-75,-62,-65,-65,-67,-58,-51,-79,-57,-56,-112,-66,-112,116,-99,-64,-60,-61,116,-96,-75,-58,-68,-75,-62,116,-60,-67,-67,-58,-67,-56,-51,-57,-56,-67,-64,-75,-62,-62,-71,116,-64,-75,-55,-65,-71,-57,-67,116,-96,-75,-68,-72,-71,-57,-57,-75,116,-54,-55,-61,-62,-62,-75,116,-123,-115,-115,-120,-109};
      k_it->vast1 = {-95,-55,-55,-56,116,-75,-57,-55,-62,-62,-61,-57,-57,-75,116,-61,-64,-64,-71,-71,-56,116,-68,-71,-62,-65,-67,-64,-79,-56,116,-60,-75,-65,-71,-62,-67,-54,-75,-56,116,-66,-75,116,-96,-75,-58,-68,-75,116,-75,-63,-60,-55,-67,116,-67,-56,-57,-71,-62,-57,-112};
      k_it->vast2 = {-96,-75,-58,-68,-75,116,-75,-64,-61,-67,-56,-56,-67,116,-56,-55,-64,-67,-56,-75,-67,-57,-56,-71,-64,-55,-62,116,-60,-61,-64,-67,-67,-57,-67,-71,-62,116,-65,-75,-62,-57,-57,-75,116,-66,-75,116,-57,-75,-67,116,-57,-55,-58,-63,-75,-62,-57,-75,116,-60,-61,-64,-67,-67,-57,-67,-62,116,-64,-55,-61,-72,-67,-57,-56,-75};
      k_it->vast3 = {-96,-75,-58,-68,-75,116,-75,-63,-60,-55,-67,116,-63,-55,-55,-56,116,-75,-57,-55,-62,-62,-61,-57,-57,-75,116,-61,-64,-64,-71,-71,-56,116,-68,-71,-62,-65,-67,-64,-79,-56,116,-66,-75,116,-67,-56,-57,-71,-62,-57,-112};
      k_it->vast4 = {-96,-75,-58,-68,-75,116,-60,-112,-112,-57,-67,116,-60,-75,-65,-61,-61,-62,116,-58,-75,-68,-61,-66,-71,-62,116,-65,-75,-62,-57,-57,-75,116,-66,-75,116,-64,-112,-68,-56,-67,116,-99,-74,-67,-50,-75,-64,-64,-71};
      k_it->luk4 = true;
    }

    if(kountteri == 4) {
      k_it->k_luku = 88;
      k_it->kysym = {-91,-63,-61,-108,120,-57,-58,120,-53,-67,-61,-53,-51,-71,-71,-60,-63,-53,-67,-58,120,-61,-71,-58,-53,-53,-71,-61,-108,-47,-59,-63,-53,-67,-58,120,-53,-51,-57,-62,-71,-63,-61,-108,-54,-71,-62,-71,120,-85,-51,-57,-59,-67,-53,-53,-71,-105};
      k_it->vast1 = {-119,-114,120,-61,-51,-52,-67,-58,120,-82,-67,-58,-108,-62,-108,-60,-60,-108};
      k_it->vast2 = {-119,-115,120,-61,-51,-52,-67,-58,120,-86,-51,-57,-52,-53,-63,-53,-53,-71};
      k_it->vast3 = {-119,-116,120,-61,-51,-52,-67,-58,120,-85,-71,-61,-53,-71,-53,-53,-71};
      k_it->vast4 = {-119,-117,120,-61,-51,-52,-67,-58,120,-94,-71,-56,-71,-58,-63,-53,-53,-71};
      k_it->luk4 = true;
    }

    if(kountteri == 5) {
      k_it->k_luku = 62;
      k_it->kysym = {-117,-89,-90,-89,-84,94,-82,122,-89,-90,-78,-93,-93,-79,-93,-93,-84,94,-122,-97,-84,-83,-89,94,-112,-83,-95,-87,-79,94,107,-73,-90,-78,-73,-93,-93,-84,94,-84,-89,-85,-89,94,-76,-89,-89,-78,-78,-97,-97,125};
      k_it->vast1 = {-122,-93,-80,-83,-89,-89,-84,-89,-89,-84};
      k_it->vast2 = {-119,-83,-87,-97,-89,-89,-84,-89,-89,-84};
      k_it->vast3 = {127,-85,-92,-93,-78,-97,-85,-89,-89,-84,-89,-89,-84};
      k_it->vast4 = {-119,-97,-90,-76,-89,-89,-84};
      k_it->luk4 = true;
    }

    if(kountteri == 6) {
      k_it->k_luku = 0;
      k_it->kysym = {77,105,107,60,32,111,110,32,116,97,110,115,115,105,106,97,32,84,117,117,114,101,32,66,111,101,108,105,117,107,115,101,110,32,115,101,107,115,117,97,97,108,105,110,101,110,32,115,117,117,110,116,97,117,116,117,109,105,110,101,110,63};
      k_it->vast1 = {72,111,109,111,115,101,107,115,117,97,97,108,105,115,117,117,115};
      k_it->vast2 = {72,101,116,101,114,111,115,101,107,115,117,97,97,108,105,115,117,117,115};
      k_it->vast3 = {66,105,115,101,107,115,117,97,97,108,105,115,117,117,115};
      k_it->vast4 = {80,97,110,115,101,107,115,117,97,97,108,105,115,117,117,115};
    }

    if(kountteri == 7) {
      k_it->k_luku = 36;
      k_it->kysym = {113,-115,-113,96,68,-109,-110,68,-108,-123,-106,-123,-105,-104,-123,68,-116,-103,-103,-111,-119,-104,-104,-123,99};
      k_it->vast1 = {108,-103,-103,-111,-119,-119,-104};
      k_it->vast2 = {105,-112,96,-111,96};
      k_it->vast3 = {116,-99,-116,96,68,-116,-119,-110,-113,-115};
      k_it->vast4 = {108,-103,-111,-108,-108,-123};
      k_it->luk4 = true;
    }

    if(kountteri == 8) {
      k_it->k_luku = 44;
      k_it->kysym = {121,-107,-105,104,76,-101,-104,-107,76,-100,-98,-111,-97,-107,-112,-111,-102,-96,-96,-107,76,121,-115,-95,-102,-101,76,119,-101,-107,-94,-107,-97,-96,-101,-102,76,-103,-107,-111,-104,-111,-107,-97,-107,-102,76,-94,-107,-112,-111,-101,-100,-111,-104,-107,107};
      k_it->vast1 = {117,-113,-111,76,111,-104,-107,-103,-114,-111,-98};
      k_it->vast2 = {127,-95,-100,-111,-98,76,-126,-101,-104,-104,-111,-91,-114,-115,-104,-104};
      k_it->vast3 = {126,-115,-107,-112,76,-101,-94,-111,-98,76,121,-101,-97,-113,-101,-93};
      k_it->vast4 = {120,-111,-115,-96,-108,-111,-98,76,115,-101,-112,-112,-111,-97,-97,-111,-97,76,-101,-110,76,124,-108,-101,-114,-101,-97};
      k_it->luk4 = true;
    }

    if(kountteri == 9) {
      k_it->k_luku = 21;
      k_it->kysym = {96,-118,-128,118,53,-127,81,125,122,-119,-119,126,53,-117,-118,-124,-125,-125,118,53,70,78,78,69,53,-119,118,-120,118,66,118,-121,-117,-124,118,-120,126,118,126,-125,53,-125,122,-118,-117,-124,-119,-119,122,-127,-118,-128,-118,-125,-125,118,-125,53,122,-121,126,-128,-124,126,-120,-119,-118,-119,-128,126,127,118,-127,-127,122,53,-128,-124,125,-118,118,53,118,126,125,122,-118,-119,-119,118,-125,122,122,-125,53,55,-128,126,-128,-128,122,-127,126,-128,-124,-121,-119,126,-125,55,84};
      k_it->vast1 = {95,-124,-121,-126,118,53,103,122,126,-125,126};
      k_it->vast2 = {95,-118,125,118,-125,126,53,104,118,-127,-124,-125,126,-118,-120};
      k_it->vast3 = {94,-127,-128,-128,118,53,96,118,-125,122,-121,-117,118};
      k_it->vast4 = {88,125,-121,126,-120,-119,-124,123,123,122,-121,53,105,118,-115,122,-127,-127};
      k_it->selitys = {95,-124,-121,-126,118,53,103,122,126,-125,126,53,-124,-127,126,53,-114,-128,-120,126,53,-128,-124,-121,-119,126,-125,53,-127,81,125,122,-119,-119,81,-125,122,126,-120,-119,81,53,-119,-114,114,-126,118,-121,-128,-128,126,-125,118,127,-124,125,-119,118,127,126,-120,-119,118,67};
    }

    if(kountteri == 10) {
      k_it->k_luku = 88;
      k_it->kysym = {-91,-63,-53,-53,-108,120,-56,-108,-108,-59,-63,-58,-63,-53,-52,-67,-54,-63,120,-91,-71,-52,-52,-63,120,-82,-71,-58,-64,-71,-58,-67,-58,120,-50,-108,-63,-52,-52,-63,120,-52,-71,-50,-71,-58,-58,-67,-67,-58,-53,-71,120,-58,-71,-63,-53,-47,-53,-52,-108,-50,-108,-58,-53,-108,120,-85,-51,-53,-71,-58,120,-93,-51,-54,-57,-53,-67,-58,-105};
      k_it->vast1 = {-95,-61,-67,-71,-53,-53,-71};
      k_it->vast2 = {-85,-52,-57,-69,-61,-59,-71,-58,-58,-63,-60,-60,-71};
      k_it->vast3 = {-93,-67,-53,-57,-63,-60,-63,-60,-60,-71};
      k_it->vast4 = {-85,-67,-54,-67,-58,-71,-53,-53,-71};
      k_it->luk4 = true;
      k_it->selitys = {-84,-57,-52,-51,-51,-53,-110,120,-85,-51,-57,-59,-63,-118,-116,-122,-66,-63,120,-123,-53,-63,-50,-51,-53,-52,-57,-58,120,-68,-67,-63,-52,-52,-63,-56,-71,-60,-53,-52,-71,-60,-60,-71};
    }

    if(kountteri == 11) {
      k_it->k_luku = 40;
      k_it->kysym = {115,-99,-109,-119,72,-95,-112,-100,-115,-111,-101,-109,-99,-106,-100,-119,-100,-111,-115,-100,-115,-111,-108,-111,-110,100,72,-119,-111,-112,-115,-99,-100,-100,-111,72,-109,-105,-112,-99,-119,72,-98,100,-111,-100,-100,100,-107,100,-108,-108,100,72,-119,-114,-102,-111,-109,-109,-119,-108,-119,-111,-101,-100,-115,-106,72,-105,-108,-115,-98,-119,-106,72,-100,-95,-112,-107,-111,100,103};
      k_it->vast1 = {124,-119,-100,-99,72,126,-119,-106,-112,-119,-106,-115,-106};
      k_it->vast2 = {114,86,120,86,72,122,-105,-105,-101};
      k_it->vast3 = {114,-119,-102,-111,72,109,-112,-102,-106,-102,-105,-105,-100,-112};
      k_it->vast4 = {105,-100,-100,-115,72,115,-119,-108,-115,-98,-119};
    }

    if(kountteri == 12) {
      k_it->k_luku = 4;
      k_it->kysym = {79,121,109,114,111,101,36,113,115,114,120,101,36,119,121,111,112,101,101,112,105,122,125,64,36,116,115,112,109,109,119,109,36,112,97,125,119,109,36,78,101,113,113,121,36,87,109,112,120,101,122,121,115,118,105,114,36,110,64,64,111,101,101,116,109,119,120,101,67};
      k_it->vast1 = {55,52,52};
      k_it->vast2 = {53,52};
      k_it->vast3 = {57,52};
      k_it->vast4 = {53,52,52};
      k_it->luk4 = true;
    }

    if(kountteri == 13) {
      k_it->k_luku = 28;
      k_it->kysym = {103,-111,-121,125,60,-121,125,-118,-113,125,-118,-127,-128,-111,-113,-112,125,-122,125,60,-121,88,-107,-112,-112,-123,60,-127,-128,-111,-113,-121,-111,-118,-118,125,-113,-113,125,60,-110,-111,-117,-118,-118,125,60,78,76,76,80,60,-114,-123,-118,-112,125,-119,-127,-114,-121,-121,-123,88,72,60,-122,-117,-113,-113,125,60,-120,-111,-121,-123,60,62,114,-123,-112,-112,-111,60,-124,125,-123,-113,-127,-127,60,-124,-107,-110,88,-120,-112,88,62,91};
      k_it->vast1 = {110,-117,-113,125,60,105,-127,-114,-123,-120,88,-123,-118,-127,-118};
      k_it->vast2 = {101,-114,-123,-118,125,60,103,-114,-117,-124,-118};
      k_it->vast3 = {105,-127,-114,-123,-121,-111,-121,-121,125,60,98,-117,-114,-113,-123,-111,-113};
      k_it->vast4 = {101,-120,-121,-121,125,60,103,125,-118,-127,-114,-110,125};
      k_it->luk4 = true;
    }

    if(kountteri == 14) {
      k_it->k_luku = 91;
      k_it->kysym = {-90,-48,-58,-68,123,-58,-68,-55,-50,-68,-55,-64,-65,-48,-50,-49,-68,-59,-68,123,-50,-68,-60,123,-64,-65,-48,-50,-58,-48,-55,-55,-68,-55,123,-53,-48,-61,-64,-56,-60,-64,-61,-64,-57,-49,-105,123,-55,-48,-61,-49,-64,-64,-49,123,-47,-48,-54,-55,-55,-68,123,-115,-117,-117,-117,123,-55,-105,-44,-49,-64,-49,-49,-44,-105,-105,-55,123,-58,-64,-50,-58,-60,-50,-54,-51,-56,-64,-68,123,-47,-68,-57,-49,-60,-54,-47,-68,-51,-68,-60,-55,-56,-60,-55,-60,-50,-49,-64,-51,-60,123,-82,-68,-48,-57,-60,123,-87,-60,-60,-55,-60,-50,-49,-72,-57,-57,-64,-102};
      k_it->vast1 = {-100,-55,-55,-60,123,-82,-60,-55,-55,-64,-56,-105,-58,-60};
      k_it->vast2 = {-83,-68,-60,-56,-54,123,-79,-60,-50,-49,-67,-68,-66,-58,-68};
      k_it->vast3 = {-91,-68,-68,-58,-58,-54,123,-89,-68,-68,-58,-50,-54};
      k_it->vast4 = {-86,-50,-56,-54,123,-82,-54,-60,-55,-60,-55,-47,-68,-68,-51,-68};
      k_it->luk4 = true;
    }

    if(kountteri == 15) {
      k_it->k_luku = 9;
      k_it->kysym = {84,126,116,106,41,116,106,119,124,106,119,110,109,126,124,125,106,115,106,41,124,106,106,121,126,114,41,127,126,120,119,119,106,41,59,57,58,59,41,125,106,124,106,127,106,117,117,106,119,41,121,123,110,124,114,109,110,119,125,125,114,41,92,106,126,117,114,41,87,114,114,119,114,124,125,102,119,41,127,114,123,116,106,106,119,106,124,125,126,115,106,114,124,114,114,119,41,114,117,118,106,119,41,116,123,106,127,106,125,125,114,106,72};
      k_it->vast1 = {86,114,116,106,110,117,41,83,126,119,112,119,110,123};
      k_it->vast2 = {86,114,116,116,120,41,74,117,106,125,106,117,120};
      k_it->vast3 = {89,106,106,127,120,41,74,123,113,114,119,118,69,116,114};
      k_it->vast4 = {83,106,119,114,41,93,120,114,127,120,117,106};
    }

    if(kountteri == 16) {
      k_it->k_luku = 43;
      k_it->kysym = {120,-108,-103,-106,103,75,-92,-109,-97,-92,-112,-112,-103,75,-104,-96,-98,-108,-108,-106,-106,-108,-116,75,-98,-116,-97,-116,-103,-108,-98,-97,-108,75,117,-116,-99,-103,-102,75,112,-105,-110,75,-107,-116,75,-104,-96,-96,-97,75,115,-92,-95,-108,-103,-106,103,103,-103,75,92,100,100,99,75,-101,-116,-105,-102,-108,-97,-97,-112,-105,-96,-104,-96,-99,-109,-116,-103,75,-97,-112,-106,-108,-107,103,-97,75,-106,-96,-96,-103,-97,-112,-105,-108,-95,-116,-97,75,-104,-96,-99,-109,-116,-97,-92,-120,-97,103,75,-97,-112,-109,-113,-112,-98,-98,103,103,-103,106};
      k_it->vast1 = {108,-103,-114,-108,-112,-103,-97};
      k_it->vast2 = {109,-102,-99,-106,-103,-116,-110,-116,-99};
      k_it->vast3 = {126,-97,-96,-99,-104,-110,-112,-108,-98,-97};
      k_it->vast4 = {-126,89,108,89,126,89,123,89};
      k_it->luk4 = true;
    }

    if(kountteri == 17) {
      k_it->k_luku = 16;
      k_it->kysym = {93,121,-124,76,48,122,-123,127,125,113,113,48,88,-119,-122,121,126,123,76,76,124,124,76,48,65,73,73,72,48,-128,113,124,127,121,-124,-124,117,124,-123,125,-123,-126,120,113,126,48,-124,117,120,126,-119,-124,48,-125,113,-124,113,126,121,-125,-124,121,48,90,113,-126,126,127,48,85,124,119,48,122,113,48,120,76,126,117,126,48,-126,121,123,127,-125,-124,127,-122,117,-126,121,126,-125,113,48,122,127,121,-122,113,-124,48,117,126,126,117,126,48,-125,-123,-126,125,113,-124,-119,109,-124,76,79};
      k_it->vast1 = {91,121,124,122,-123,113};
      k_it->vast2 = {91,127,-125,123,117,126,123,127,-126,-122,113,113};
      k_it->vast3 = {87,113,125,114,121,126,113,113};
      k_it->vast4 = {92,113,-128,121,126,48,91,-123,124,-124,113,113};
      k_it->luk4 = true;
    }

    if(kountteri == 18) {
      k_it->k_luku = 26;
      k_it->kysym = {103,-125,-123,86,58,-121,127,-114,123,-122,-122,-125,-109,-126,-114,-109,127,58,-114,-119,-125,-121,-125,58,106,-119,-116,-112,-119,-119,-120,58,-114,-113,-119,-121,-125,-119,-123,-125,-116,-123,-119,-120,58,-112,-113,-119,-120,-120,123,58,76,74,74,80,58,-118,-119,-122,-114,-114,123,-120,127,127,-120,58,-116,-113,-121,-118,123,-122,-125,-120,58,127,-115,-125,-123,-113,-112,123,-120,123,89};
      k_it->vast1 = {92,-113,-116,-108,-113,-121};
      k_it->vast2 = {109,123,-114,-109,-116,-125,125,-119,-120};
      k_it->vast3 = {103,123,-116,126,-113,-123};
      k_it->vast4 = {98,99,103};
      k_it->luk4 = true;
    }

    if(kountteri == 19) {
      k_it->k_luku = 95;
      k_it->kysym = {-84,-56,-57,-56,-51,127,-54,-64,-44,-49,-44,-51,-54,-56,-56,-51,127,-78,-44,-51,-51,-40,127,-94,-64,-47,127,-94,-60,-51,-45,-60,-47,127,-50,-53,-56,127,-45,-64,-47,-54,-50,-56,-45,-44,-46,127,-47,-64,-54,-60,-51,-45,-64,-64,-98};
      k_it->vast1 = {-89,-101,-52,-60,-60,-51,-53,-56,-51,-51,-64,-64,-51};
      k_it->vast2 = {-85,-64,-57,-45,-60,-60,-51};
      k_it->vast3 = {-85,-64,-49,-49,-60,-60,-51,-47,-64,-51,-45,-64,-64,-51};
      k_it->vast4 = {-91,-50,-47,-46,-46,-64,-64,-51};
    }

    if(kountteri == 20) {
      k_it->k_luku = 67;
      k_it->kysym = {-112,-84,-82,127,99,-82,-92,-72,-77,-77,-92,-82,-88,-73,-83,-72,99,-78,-74,-73,-84,99,-106,-72,-79,-79,-68,99,-122,-92,-75,99,-122,-88,-79,-73,-88,-75,-84,-79,99,-73,-78,-81,-77,-92,-79,-126};
      k_it->vast1 = {-114,127,-75,-82,-82,127,-84,-79,-88,-79};
      k_it->vast2 = {-117,-92,-81,-77,-92,-117,-92,-81,-81,-84};
      k_it->vast3 = {-112,-78,-73,-78,-79,-88,-73};
      k_it->vast4 = {-105,-78,-82,-80,-92,-79,-79,-84};
    }

    if(kountteri == 21) {
      k_it->k_luku = 99;
      k_it->kysym = {-80,-52,-53,-52,-47,-125,-50,-60,-47,-42,-60,-47,-56,-57,-40,-42,-41,-60,-51,-60,-125,-51,-60,-125,-56,-40,-43,-46,-45,-60,-43,-49,-60,-48,-56,-47,-41,-60,-60,-43,-52,-50,-50,-46,-125,-81,-60,-40,-43,-60,-125,-85,-40,-53,-41,-60,-42,-60,-60,-43,-52,-125,-40,-42,-50,-46,-46,-94};
      k_it->vast1 = {-82,-43,-56,-60,-41,-52,-46,-47,-52,-42,-48,-52,-52,-47};
      k_it->vast2 = {-81,-52,-41,-41,-56,-97,-97,-47,-125,-48,-60,-60,-53,-60,-47};
      k_it->vast3 = {-88,-56,-41,-41,-56,-43,-52,-45,-36,-64,-43,-41,-56,-52,-42,-52,-52,-47};
      k_it->vast4 = {-87,-49,-46,-54,-52,-42,-41,-46,-47,-52,-52,-47};
    }

    if(kountteri == 22) {
      k_it->k_luku = 58;
      k_it->kysym = {-123,-101,-88,-83,-101,-88,-97,-98,-81,-83,-82,-101,-92,-101,90,-124,-101,-89,-97,-83,90,-126,-93,-84,-80,-93,-83,-101,-101,-84,-93,90,-97,-84,-87,-82,-97,-82,-82,-93,-93,-88,90,-118,-97,-84,-81,-83,-83,-81,-87,-89,-101,-90,-101,-93,-83,-93,-83,-82,-101,90,-80,-81,-87,-88,-88,-101,90,108,106,107,109,90,-94,118,-88,-97,-88,90,-91,-81,-82,-83,-81,-82,-82,-81,-101,-101,-88,90,-101,-91,-82,-93,-80,-93,-83,-82,-93,90,-115,-97,-86,-86,-87,90,-122,-97,-94,-98,-87,-88,90,127,-98,-81,-83,-91,-81,-88,-82,-101,-82,-101,-90,-87,-87,-88,104,90,-121,-93,-82,-97,-88,90,-122,-97,-94,-82,-87,90,-87,-90,-93,90,-91,118,-77,-82,-82,118,-77,-82,-77,-88,-77,-82,90,127,-98,-81,-83,-91,-81,-88,-82,-101,-82,-101,-90,-87,-83,-83,-101,121};
      k_it->vast1 = {-114,-97,-91,-93,90,-88,-101,-82,-83,-93,-82,-97,-84,-80,-97,-94,-98,-77,-91,-83,-97,-88};
      k_it->vast2 = {-126,-81,-81,-83,-93,90,-84,-101,-83,-93,-83,-82,-93,-83,-93,-101,90,-93,-83,-91,-81,-90,-101,-81,-83,-97,-93,-82,-101};
      k_it->vast3 = {-120,118,-77,-82,-82,-93,90,-91,-97,-83,-91,-93,-83,-87,-84,-89,-97,-101};
      k_it->vast4 = {-118,-101,-90,-92,-101,-83,-82,-93,90,-82,-101,-91,-101,-86,-81,-87,-90,-97,-88,-83,-101};
    }

    if(kountteri == 23) {
      k_it->k_luku = 39;
      k_it->kysym = {116,-112,-110,99,71,-102,-116,-100,-103,-120,-120,-99,-112,-102,-101,-120,71,-116,-112,71,-106,-109,-109,-100,-101,71,-102,-100,-106,-108,-120,-109,-120,-112,-107,-116,-107,71,-102,-120,-99,-100,-110,-116,-108,-116,-103,-110,-110,-112,102};
      k_it->vast1 = {119,-116,-107,-101,-101,-112};
      k_it->vast2 = {109,-106,-103,-108};
      k_it->vast3 = {114,-109,-100,-119,-112};
      k_it->vast4 = {105,-103,-120,-113,-116};
    }

    if(kountteri == 24) {
      k_it->k_luku = 55;
      k_it->kysym = {-126,-100,-91,-100,-91,87,-85,-90,-96,-86,-100,-91,87,115,115,-87,-96,-90,-96,-94,-100,-96,-86,-85,-90,-93,-104,-96,-86,-100,-91,87,-104,-94,-85,-96,-83,-96,-86,-85,-96,-91,87,-94,-104,-91,-86,-86,-104,87,-118,-100,-89,-89,-90,87,-125,-100,-97,-85,-90,87,-94,115,-83,-96,87,89,-85,-90,-85,-104,-104,-93,-96,-86,-100,-91,-104,87,-86,-90,-85,-104,-91,-104,89,87,-85,-84,-91,-91,-100,-85,-84,-91,87,-89,-96,-85,-94,115,-91,87,-95,-104,87,-87,-96,-96,-85,-104,-96,-86,-104,-91,87,-83,-96,-100,-86,-85,-96,-85,-85,-100,-93,-80,-91,87,-128,-91,-85,-100,-87,-91,-100,-85,-96,-86,-86,115,118};
      k_it->vast1 = {-126,-93,-104,-84,-86,87,-127,-84,-84,-85,-96,-93,-104,-96,-86,-100,-91};
      k_it->vast2 = {-121,-100,-94,-94,-104,87,-118,-96,-96,-85,-90,-96,-92,-100,-91};
      k_it->vast3 = {-122,-93,-104,-83,-96,87,-124,115,-100,-91,-89,115,115,-91};
      k_it->vast4 = {-124,-104,-87,-102,-90,87,-101,-100,87,-114,-96,-85,-96,-91};
    }

    if(kountteri == 25) {
      k_it->k_luku = 98;
      k_it->kysym = {-81,-53,-51,-98,-126,-47,-50,-53,-126,-51,-47,-41,-50,-41,-61,-49,-46,-41,-52,-61,-126,-78,-57,-51,-51,-61,-113,-89,-44,-53,-59,-126,-93,-41,-40,-53,-43,-57,-48,-126,-42,-57,-47,-48,-126,-49,-47,-42,-53,-53,-40,-53,-95};
      k_it->vast1 = {-75,-47,-43,-53,-61,-61,-50,-53,-58,-61,-44,-40,-53,-48,-53,-43,-49,-53};
      k_it->vast2 = {-83,-61,-48,-43,-61,-50,-50,-53,-43,-43,-47,-43,-53,-61,-50,-53,-43,-49,-53};
      k_it->vast3 = {-82,-37,-43,-57,-48,-51,-47,-50,-61,-53,-43,-41,-41,-43};
      k_it->vast4 = {-75,-47,-43,-53,-61,-61,-50,-53,-46,-57,-58,-61,-55,-47,-55,-53,-53,-51,-51,-61};
      k_it->luk4 = true;
    }

    if(kountteri == 26) {
      k_it->k_luku = 53;
      k_it->kysym = {-128,-102,-93,-102,-95,-87,113,85,-85,-106,-106,-95,-98,-96,-106,-86,-103,-102,-93,85,103,101,102,106,98,103,101,102,110,85,-96,-106,-93,-88,-106,-93,-102,-103,-86,-88,-87,-106,-97,-106,-95,-87,-106,85,-92,-93,85,-91,-102,-89,113,-98,-88,-98,-93,85,-95,-102,-93,-87,113,-85,113,85,-95,-106,-86,-88,-102,85,87,-93,-86,-88,-88,-98,-87,-87,-86,-93,-106,85,-93,-86,-96,-96,-86,-98,-88,-98,-87,85,-91,-106,-89,-102,-94,-94,-98,-93,87,116};
      k_it->vast1 = {-119,-92,-98,-94,-98,85,-128,-106,-93,-96,-106,-106,-93,-93,-98,-102,-94,-102,-95,-87,113};
      k_it->vast2 = {-120,-102,-91,-91,-92,85,-128,113,113,-89,-98,113,-98,-88,-102,-95,-87,113};
      k_it->vast3 = {126,-95,-96,-96,-106,85,-128,-106,-93,-102,-89,-85,-106,-95,-87,-106};
      k_it->vast4 = {118,-93,-93,-106,85,-128,-92,-93,-87,-86,-95,-106,-95,-87,-106};
    }

    if(kountteri == 27) {
      k_it->k_luku = 36;
      k_it->kysym = {113,-115,-104,-119,-110,68,-103,-106,-116,-119,-115,-112,-115,-114,-123,68,-114,-123,68,-108,-109,-112,-115,-115,-104,-115,-113,-113,-109,68,120,-109,-110,-99,68,108,-123,-112,-111,-119,68,-108,-119,-106,-103,-105,-104,-119,-112,-115,68,-116,-103,-103,-111,-119,-115,-120,-119,-110,68,-113,96,-99,-104,-104,-127,96,96,-110,99};
      k_it->vast1 = {108,-103,-103,-111,-119,-115,-105,-104,-123,68,-104,-103,-112,-119,-119,68,-106,-123,-103,-116,-123,-112,-112,-115,-110,-119,-110,68,-109,-112,-109};
      k_it->vast2 = {122,-115,-115,-110,-123,68,-111,-123,-115,-105,-104,-103,-103,68,-108,-123,-116,-123,-112,-112,-119};
      k_it->vast3 = {108,-103,-103,-111,-119,-119,-104,68,-110,-109,-105,-104,-123,-102,-123,-104,68,-105,-103,-109,-106,-115,-104,-103,-105,-113,-99,-113,-99,96};
      k_it->vast4 = {108,-103,-103,-111,-119,-115,-112,-112,-123,68,-105,-123,-123,68,-99,-116,-104,-119,-99,-120,-119,-110,68,-114,-103,-111,-123,-112,-123,-123,-110};
    }

    if(kountteri == 28) {
      k_it->k_luku = 32;
      k_it->kysym = {109,-119,-117,92,64,-113,-114,64,-127,-119,-117,-107,-119,-109,-123,-114,64,-119,-120,-115,-119,-109,-123,-114,64,-112,-123,-110,92,-109,-107,-113,-116,-123,-114,64,-112,-119,-108,-107,-107,-109,95};
      k_it->vast1 = {81,82,77,81,85,64,-125,-115};
      k_it->vast2 = {86,77,81,80,64,-125,-115};
      k_it->vast3 = {82,82,77,83,80,64,-125,-115};
      k_it->vast4 = {83,82,77,83,88,64,-125,-115};
    }

    if(kountteri == 29) {
      k_it->k_luku = 54;
      k_it->kysym = {-123,-84,-105,-86,-95,-91,86,-97,-98,-93,-97,-87,-101,-92,86,-90,-101,-88,114,-87,-85,-91,-94,-101,-92,86,-87,-85,-94,-95,-97,-96,-105,-94,-97,-98,-105,-95,-87,-101,-86,86,-95,-91,-92,-86,-88,-91,-94,-94,-91,-97,-86,-105,-84,-97,-87,-87,-105,86,-86,-105,-98,-102,-91,-92,-105,-94,-105,-97,-87,-101,-87,-86,-97,117};
      k_it->vast1 = {-116,-105,-97,-92,86,-85,-94,-91,-93,-90,-97,86,-87,-85,-94,-95,-97,-96,-105,-94,-97,-98,-105,-87,86,-91,-92,86,-95,-91,-92,-86,-88,-91,-94,-94,-91,-97,-86,-105,-84,-97,-87,-87,-105};
      k_it->vast2 = {-116,-105,-97,-92,86,-87,-97,-87,-101,-93,-90,-97,86,-87,-85,-94,-95,-97,-96,-105,-94,-97,-98,-105,-87,86,-91,-92,86,-95,-91,-92,-86,-88,-91,-94,-94,-91,-97,-86,-105,-84,-97,-87,-87,-105};
      k_it->vast3 = {-125,-91,-94,-101,-93,-93,-105,-86,86,-87,-85,-94,-95,-97,-96,-105,-94,-97,-98,-105,-95,-87,-101,-86,86,-91,-84,-105,-86,86,-95,-91,-92,-86,-88,-91,-94,-94,-91,-97,-86,-105,-84,-97,-87,-87,-105};
      k_it->vast4 = {-127,-85,-93,-90,-97,-95,-105,-105,-92,86,-87,-85,-94,-95,-97,-96,-105,-94,-97,-98,-105,-87,86,-101,-97,86,-91,-94,-101,86,-95,-91,-92,-86,-88,-91,-94,-94,-91,-97,-86,-105,-84,-97,-87,-87,-105};
      k_it->luk4 = true;
    }

    if(kountteri == 30) {
      k_it->k_luku = 65;
      k_it->kysym = {-114,-86,-84,125,97,-76,-90,-74,-77,-94,-94,-73,-86,-76,-75,-94,97,-80,-81,97,-76,-94,-83,-83,-86,-75,-75,-74,-94,97,-117,-90,-87,-80,-73,-94,-81,97,-75,-80,-91,-86,-76,-75,-94,-85,-86,-83,-83,-90,-128};
      k_it->vast1 = {-116,-80,-81,-91,-80,-82,-86,-81,97,-84,125,-70,-75,-75,-98};
      k_it->vast2 = {-105,-90,-77,-86,-83,-90,-75,-75,-74,-85,-90,-81,97,-76,-70,-98,-82,-86,-81,-90,-81};
      k_it->vast3 = {-107,-74,-79,-94,-84,-80,-86,-81,-75,-86};
      k_it->vast4 = {-126,-81,-94,-94,-83,-86,-76,-90,-84,-76,-86};
    }

    if(kountteri == 31) {
      k_it->k_luku = 69;
      k_it->kysym = {-110,-82,-80,-127,101,-72,-86,-70,-73,-90,-90,-69,-82,-72,-71,-90,101,-90,-72,-82,-76,-82,-72,-71,-90,101,-76,-77,101,-79,-90,-82,-71,-76,-77,-71,-90,101,-104,-70,-76,-78,-86,-72,-72,-90,-124};
      k_it->vast1 = {-103,-82,-86,-71,-71,-66,-81,-86,-77,101,-72,-82,-86,-77,-82,-79,-90,-81,-82,-86,-77,101,-72,-66,-94,-78,-82,-77,-86,-77,101,-78,-86,-71,-72,-127,-72,-71,-127};
      k_it->vast2 = {-115,-90,-78,-75,-70,-77,101,-78,-66,-66,-78,-82,-77,-86,-77,101,-80,-90,-70,-75,-90,-72,-72,-90};
      k_it->vast3 = {-112,-82,-79,-81,-70,-77,101,-69,-90,-79,-78,-82,-72,-71,-90,-78,-82,-77,-86,-77,101,-80,-76,-71,-76,-77,-90};
      k_it->vast4 = {-104,-86,-80,-72,-82,-77,101,-78,-66,-66,-78,-82,-77,-86,-77,101,-114,-77,-71,-86,-73,-77,-86,-71,-82,-72,-72,-127};
    }

    if(kountteri == 32) {
      k_it->k_luku = 86;
      k_it->kysym = {-93,-65,-63,-110,118,-59,-62,-65,118,-63,-59,-53,-62,-53,-73,-61,-58,-53,-64,-73,118,-90,-69,-63,-63,-73,-125,-101,-56,-65,-71,118,-105,-53,-52,-65,-55,-69,-60,118,-63,-110,-49,-54,-54,-110,-61,-110,118,-73,-55,-69,-107};
      k_it->vast1 = {-87,-97,-99,118,-87,-73,-53,-69,-56,118,-93,-59,-55,-57,-53,-65,-54,-59};
      k_it->vast2 = {-96,-73,-54,-65,-61,-73,-54,-65,-71};
      k_it->vast3 = {-93,-73,-53,-55,-69,-56,118,-103,-113,-116};
      k_it->vast4 = {-103,-59,-62,-54,118,-93,-121,-113,-121,-121};
    }

    if(kountteri == 33) {
      k_it->k_luku = 17;
      k_it->kysym = {94,122,124,-124,122,49,124,122,-124,-124,114,49,-125,77,77,124,-118,-118,49,-122,-124,118,122,127,49,-127,114,-125,122,-123,118,125,125,118,-124,-124,114,114,127,80};
      k_it->vast1 = {92,122,-124,-124,114,127,49,-127,118,127,122,124,-124,118,127,49,123,-122,-128,126,-122,-123,49,114,122,121,118,-122,-123,-123,114,-121,114,-123,49,124,122,-127,-122,114,49,-121,114,120,122,127,114,-124,-124,114};
      k_it->vast2 = {92,122,-124,-124,114,-123,49,-125,114,114,-127,122,-121,114,-123,49,-123,-128,122,-124,122,114,114,127,49,-127,114,-125,122,-123,-123,118,125,-122,127,49,114,122,124,114,127,114};
      k_it->vast3 = {92,122,-124,-124,114,49,122,125,126,114,122,-124,118,118,49,126,122,118,125,122,121,-118,-121,77,77,49,-125,77,77,124,-118,126,77,125,125,77};
      k_it->vast4 = {99,77,77,124,-118,126,122,127,118,127,49,-128,127,49,124,122,-124,-124,114,127,49,-124,-128,122,117,122,127,125,114,-122,125,-122};
    }

    if(kountteri == 34) {
      k_it->k_luku = 53;
      k_it->kysym = {-126,-92,-93,-87,-106,85,-96,-102,-89,-87,-106,-106,85,-123,-106,-106,-85,-92,85,-117,113,-82,-89,-82,-93,-102,-93,85,-92,-93,85,-92,-95,-95,-86,-87,85,-91,-89,-102,-88,-98,-103,-102,-93,-87,-87,-98,-102,-99,-103,-92,-96,-96,-106,-106,-93,-106,85,93,-85,-86,-92,-87,-102,-102,-93,85,103,101,103,102,85,-94,-102,-93,-93,-102,-88,-88,113,94,116};
      k_it->vast1 = {-125,-102,-95,-97,113};
      k_it->vast2 = {-128,-106,-96,-88,-98};
      k_it->vast3 = {-128,-92,-95,-94,-102};
      k_it->vast4 = {-117,-98,-98,-88,-98};
    }

    if(kountteri == 35) {
      k_it->k_luku = 74;
      k_it->kysym = {-105,-77,-75,-122,106,-71,-74,-77,106,-67,-61,-61,-72,-122,106,-67,-77,-77,-78,-81,-72,118,106,-81,-66,-66,-122,106,-75,-65,-64,-85,-66,-85,-77,-66,-81,-77,-74,-77,-76,-85,106,-100,-85,-75,-81,-74,106,-106,-77,-81,-75,-75,-77,106,-70,-122,-122,-66,-61,-77,106,-70,-71,-68,-72,-71,-72,-122,-61,-66,-66,-81,-74,-77,-76,-122,-75,-67,-77,-119};
      k_it->vast1 = {-98,-85,-77,-66,-81,-81,-74,-74,-77,-72,-81,-72,106,-75,-71,-75,-81,-77,-74,-65,-72,-78,-85,-74,-65};
      k_it->vast2 = {-100,-85,-78,-85,-72,106,-70,-65,-65,-66,-81};
      k_it->vast3 = {-107,-65,-65,-74,-65,-77,-67,-65,-65,-82,-81,-72,106,-78,-85,-75,-81,-73,-77,-72,-81,-72};
      k_it->vast4 = {-98,-61,-89,-64,-71,-77,-73,-85,-66,-71,-77,-73,-77,-67,-66,-71,-72,106,-67,-65,-71,-67,-77,-66,-65,-67};
    }

    if(kountteri == 36) {
      k_it->k_luku = 79;
      k_it->kysym = {-100,-72,-67,-70,-117,111,-56,-73,-61,-56,-76,-76,-67,111,-68,-60,-62,-72,-72,-70,-70,-72,-59,-72,-77,-76,-66,-69,-69,-80,111,-70,-60,-59,-80,-61,-80,-72,-61,-76,-72,-69,-72,-71,-80,111,-71,-80,111,-65,-66,-63,-67,-66,-67,-117,-56,-61,-61,-76,-69,-72,-71,-117,111,-95,-80,-70,-76,-69,111,-101,-72,-76,-70,-70,-72,111,-66,-67,111,-76,-62,-72,-72,-67,-61,-56,-67,-56,-61,-114};
      k_it->vast1 = {-104,-68,-65,-80,-69,-76,-77,111,-99,-80,-55,-80,-63,-76,-67,-76};
      k_it->vast2 = {-95,-80,-77,-72,-66,-65,-60,-73,-76,-69,-72,-68,-76,-61};
      k_it->vast3 = {-97,-100,-100,-97};
      k_it->vast4 = {-95,-56,-61,-68,-72,-73,-117,-72,-63,-72,-84};
      k_it->selitys = {-102,-80,-65,-65,-80,-69,-76,-76,-67,111,113,-105,-80,-63,-77,-79,-66,-72,-69,-76,-77,111,-80,-67,-77,111,-94,-61,-72,-69,-69,111,-105,-76,-69,-69,-79,-66,-60,-67,-77,113,111,-59,-72,-77,-76,-66,-69,-69,-80};
    }

    if(kountteri == 37) {
      k_it->k_luku = 6;
      k_it->kysym = {81,123,113,103,38,112,123,117,116,121,111,38,89,123,104,90,92,64,116,38,88,66,121,127,118,117,113,113,103,38,51,117,110,112,107,114,115,103,103,38,46,56,54,54,56,51,56,54,54,57,47,69};
      k_it->vast1 = {80,103,103,112,117,38,82,111,116,116,117,116,115,103,103};
      k_it->vast2 = {78,107,111,113,113,111,38,86,103,103,121,117,116,107,116};
      k_it->vast3 = {86,107,120,122,122,111,38,89,103,114,117,120,103,116,122,103};
      k_it->vast4 = {80,107,122,110,120,117,38,88,117,121,122,107,106,122};
    }

    if(kountteri == 38) {
      k_it->k_luku = 11;
      k_it->kysym = {88,116,118,71,43,122,121,43,80,94,43,56,112,121,112,125,114,116,108,117,-128,122,120,108,121,43,118,71,-124,127,127,104,126,-128,122,126,116,127,-128,126,74,43,51,64,59,59,43,120,119,43,127,104,119,118,118,116,52};
      k_it->vast1 = {80,121,116,121,127,71,71,121,43,118,108,118,126,116,43,127,104,119,118,118,116,71,43,-127,-128,122,125,122,118,108,-128,111,112,126,126,108};
      k_it->vast2 = {80,121,116,121,127,71,71,121,43,-124,118,126,116,43,127,104,119,118,118,116,43,-127,-128,122,125,122,118,108,-128,111,112,126,126,108};
      k_it->vast3 = {80,121,116,121,127,71,71,121,43,121,112,119,117,71,43,127,104,119,118,118,116,71,43,-127,-128,122,125,122,118,108,-128,111,112,126,126,108};
      k_it->vast4 = {80,121,116,121,127,71,71,121,43,118,108,115,111,112,118,126,108,121,43,127,104,119,118,118,116,71,43,-127,-128,122,125,122,118,108,-128,111,112,126,126,108};
    }

    if(kountteri == 39) {
      k_it->k_luku = 75;
      k_it->kysym = {-104,-76,-74,-121,107,-70,-73,-76,107,-67,-84,-75,-64,-76,-73,-73,-84,107,-66,-84,-84,-67,-71,-70,-76,-73,-73,-84,-84,-71,107,-108,-71,-65,-80,-67,-71,-80,-65,-76,-66,-66,-121,107,-77,-64,-70,-72,-76,-70,-65,-84,107,-77,-80,-67,-121,-65,-65,-121,-71,-80,-80,-71,107,-69,-84,-66,-65,-70,-67,-76,107,-95,-80,-73,-76,107,-98,-84,-84,-67,-76,-74,-84,-73,-73,-80,-71,107,-66,-80,-64,-67,-84,-74,-64,-71,-65,-84,-118};
      k_it->vast1 = {-98,-84,-71,-84,107,-75,-84,107,-92,-73,-76,-66,-65,-60,-66};
      k_it->vast2 = {-106,-70,-65,-76,-66,-80,-64,-67,-84,-74,-64,-71,-65,-84,-73,-76,-76,-74,-80};
      k_it->vast3 = {-112,-73,-121,-72,-121,-71,107,-98,-84,-71,-84};
      k_it->vast4 = {-104,-84,-76,-65,-70,-83,-84,-84,-67,-76};
    }

    if(kountteri == 40) {
      k_it->k_luku = 27;
      k_it->kysym = {104,-124,-122,87,59,-118,-121,-124,59,-114,-108,-108,-119,87,59,-114,-124,-124,-125,-128,-119,71,59,-128,-113,-113,87,59,-117,-118,-115,-119,-118,-119,87,-108,-113,-113,-128,-121,-124,-123,87,59,99,-128,-119,-115,-108,59,110,124,124,-115,-124,59,-123,87,-124,59,-113,-108,120,-122,-108,-111,-108,-113,-113,120,-120,-108,-108,-114,-128,-121,87,-122,-122,-128,-128,-121,-121,-128,59,-111,-112,-118,-119,-119,124,59,77,75,75,78,90};
      k_it->vast1 = {107,-118,-121,-111,-124,-111,124,-120,-120,124};
      k_it->vast2 = {110,-108,-121,-124,-127,-124,-114};
      k_it->vast3 = {110,-128,-121,-122,87,-111,124,-120,-120,124};
      k_it->vast4 = {98,-128,-119,-124,-113,124,124,-121,-124,-125,-128,-115,-117,-128,-114};
    }

    if(kountteri == 41) {
      k_it->k_luku = 99;
      k_it->kysym = {-80,-52,-50,-97,-125,-50,-46,-52,-41,-40,-52,-125,-49,-60,-40,-49,-60,-51,-60,-125,-92,-50,-52,-125,-74,-52,-43,-50,-56,-42,-60,-49,-46,-47,-125,-50,-46,-53,-41,-60,-49,-46,-50,-42,-52,-94};
      k_it->vast1 = {-73,-42,-40,-47,-60,-48,-52};
      k_it->vast2 = {-73,-43,-46,-48,-59,-52};
      k_it->vast3 = {-73,-60,-52,-55,-40,-40,-47,-52};
      k_it->vast4 = {-86,-46,-57,-35,-52,-49,-49,-60};
      k_it->luk4 = true;
    }

    if(kountteri == 42) {
      k_it->k_luku = 68;
      k_it->kysym = {-111,-83,-81,-128,100,-73,-87,-71,-74,-91,-91,-70,-83,-73,-72,-91,100,-74,-83,-81,-77,-81,-73,-83,-73,-72,-91,100,-77,-78,100,-72,-71,-77,-78,-71,-72,100,-79,-71,-71,-73,-83,-81,-81,-77,100,-82,-91,100,-76,-77,-80,-83,-83,-72,-83,-81,-81,-77,100,-111,-83,-81,-81,-77,100,-123,-80,-91,-72,-91,-80,-77,-80,-80,-87,100,-72,-71,-77,-79,-83,-77,-78,-125};
      k_it->vast1 = {-116,-71,-71,-79,-87,-83,-88,-87,-78,100,-81,-128,-67,-72,-72,-95};
      k_it->vast2 = {-99,-80,-83,-78,-77,-76,-87,-71,-73};
      k_it->vast3 = {-104,-95,-74,-81,-87,-128,100,-80,-83,-83,-81,-87,-78,-72,-87,-87,-78,100,-70,-91,-91,-74,-91,-78,-72,-91,-79,-83,-78,-87,-78};
      k_it->vast4 = {-106,-91,-84,-91,-78,-81,-87,-74,-128,-67,-73,-74,-83,-81,-77,-73};
    }

    if(kountteri == 43) {
      k_it->k_luku = 84;
      k_it->kysym = {-97,-71,-56,-112,116,-57,-71,-55,-58,-75,-75,-54,-67,-57,-56,-75,116,-60,-61,-64,-67,-67,-56,-67,-65,-61,-67,-57,-56,-75,116,-71,-67,116,-61,-64,-71,116,-56,-55,-61,-63,-67,-56,-56,-55,116,124,-54,-55,-61,-56,-71,-71,-62,116,-122,-124,-122,-123,116,-63,-71,-62,-62,-71,-57,-57,-112,125,116,-65,-67,-67,-68,-61,-56,-56,-75,-63,-67,-57,-71,-57,-56,-75,116,-65,-75,-62,-57,-75,-62,-58,-51,-68,-63,-112,-112,116,-54,-75,-57,-56,-75,-75,-62,-109};
      k_it->vast1 = {-95,-67,-65,-75,116,-94,-67,-67,-65,-65,-61};
      k_it->vast2 = {-98,-55,-57,-57,-67,116,-100,-75,-64,-64,-75,-127,-107,-68,-61};
      k_it->vast3 = {-98,-75,-63,-71,-57,116,-100,-67,-58,-54,-67,-57,-75,-75,-58,-67};
      k_it->vast4 = {-89,-71,-74,-75,-57,-56,-67,-75,-62,116,-88,-51,-62,-65,-65,-51,-62,-71,-62};
    }

    if(kountteri == 44) {
      k_it->k_luku = 27;
      k_it->kysym = {102,-112,-122,124,59,-114,-128,-112,-115,124,124,-111,-124,-114,-113,124,59,-122,124,-119,-114,124,-119,-128,127,-112,-114,-113,124,-123,-124,-114,-113,124,59,-118,-119,59,-113,-112,-118,-120,-124,-113,-113,-112,59,-121,-112,-111,124,-113,-113,-118,-120,124,-119,59,-117,124,127,-118,-119,59,-115,124,-122,-128,-119,-113,124,-120,-124,-114,-128,-114,-113,124,90};
      k_it->vast1 = {106,-114,-120,-118,59,110,-118,-124,-119,-124,-119,-111,124,124,-115,124};
      k_it->vast2 = {112,-121,-127,59,110,-112,-119,127,-116,-111,-124,-114,-113};
      k_it->vast3 = {111,-128,-112,-111,-118,59,99,124,-122,-122,124,-115,124,-124,-119,-128,-119};
      k_it->vast4 = {102,124,-112,-122,-118,59,101,-112,-125,124,-119,-113,124,-121,-118};
      k_it->selitys = {111,-128,-122,-118,59,-121,-124,-124,-113,-113,-108,-124,59,102,-118,-124,-123,87,-115,-111,-124,72,-121,-124,-124,-122,-122,-128,-128,-119,59,-113,-118,-124,-120,-124,-119,-113,124,124,-119};
    }

    if(kountteri == 45) {
      k_it->k_luku = 59;
      k_it->kysym = {-120,-92,-81,-96,-87,91,-82,-80,-80,-83,-92,91,-86,-82,-80,-80,-82,91,-90,119,-82,-92,-97,-96,-82,-92,-82,-81,119,91,-86,-87,91,-100,-89,-90,-86,-93,-86,-89,-92,-100,91,99,-79,119,-93,-92,-87,-81,119,119,-87,100,122};
      k_it->vast1 = {113,107,91,96};
      k_it->vast2 = {109,91,96};
      k_it->vast3 = {108,107,91,96};
      k_it->vast4 = {116,107,91,96};
    }

    if(kountteri == 46) {
      k_it->k_luku = 93;
      k_it->kysym = {-88,-46,-56,-66,125,-56,-66,-53,-48,-66,-53,-62,-63,-46,-48,-47,-66,-57,-66,125,-47,-62,-56,-58,125,-45,-46,-52,-53,-53,-66,125,-114,-106,-106,-107,125,-56,-42,-48,-42,-54,-42,-56,-48,-62,-53,125,-79,-62,-55,-62,-47,-66,-51,-58,-47,125,-118,-52,-59,-57,-62,-55,-54,-66,-53,125,-48,-52,-51,-58,-45,-46,-46,-63,-62,-48,-47,-66,125,-55,-66,-51,-48,-58,-55,-55,-62,-100};
      k_it->vast1 = {-80,-46,-55,-52,125,-98,-58,-47,-47,-52,-53,-58,-62,-54,-58};
      k_it->vast2 = {-83,-103,-58,-45,-58,125,-81,-103,-48,-103,-53,-62,-53};
      k_it->vast3 = {-81,-66,-58,-54,-52,125,-77,-58,-48,-47,-65,-66,-64,-56,-66};
      k_it->vast4 = {-80,-58,-49,-56,-56,-66,-118,-87,-58,-58,-48,-66,125,-98,-53,-47,-47,-58,-55,-66};
    }

    if(kountteri == 47) {
      k_it->k_luku = 22;
      k_it->kysym = {97,-117,127,-124,-127,119,54,-125,-123,-124,-118,119,54,-119,-117,-123,-125,119,-126,119,127,-119,-118,119,54,126,127,127,126,-118,82,-128,82,82,54,-128,82,127,54,-127,127,127,-124,-124,127,54,122,-123,-122,127,-124,125,127,-119,-118,119,54,98,119,126,122,123,-124,54,99,99,67,126,127,127,126,122,-123,127,-119,-119,119,54,-116,-117,-123,-124,-124,119,54,72,70,70,71,85};
      k_it->vast1 = {97,-117,-117,-119,127};
      k_it->vast2 = {108,127,127,-119,127};
      k_it->vast3 = {100,123,-126,-128,82};
      k_it->vast4 = {97,-123,-126,-125,123};
    }

    if(kountteri == 48) {
      k_it->k_luku = 76;
      k_it->kysym = {-105,-63,-73,-83,108,-73,-75,-66,-74,-69,-75,-64,-64,-75,108,-65,-83,-70,-83,-64,108,-97,-75,-71,-69,108,-97,-83,-72,-71,-75,-65,-79,-70,108,110,-100,-69,-66,-70,-69,-72,-83,-63,-72,-63,-63,-70,110,-117};
      k_it->vast1 = {-106,-63,-73,-73,-83,108,-94,-75,-66,-64,-83,-70,-79,-70};
      k_it->vast2 = {-96,-83,-66,-71,-69,108,-103,-83,-70,-70,-75};
      k_it->vast3 = {-97,-68,-79,-80,-79,108,-100,-83,-65,-83,-70,-79,-70};
      k_it->vast4 = {-94,-79,-60,-75,108,-97,-83,-72,-71,-75};
    }

    if(kountteri == 49) {
      k_it->k_luku = 19;
      k_it->kysym = {96,124,-121,79,51,119,-126,-125,124,-127,122,116,124,-127,120,-121,-121,116,51,95,116,123,119,120,-127,51,96,96,64,123,124,124,123,119,-126,124,-122,-122,116,51,-119,-120,-126,-127,-127,116,51,69,67,67,68,51,126,124,124,-127,-127,124,125,79,79,-127,-127,120,120,-121,51,-122,-120,-126,-128,116,127,116,124,-122,120,-121,51,126,79,-116,-121,-121,124,-119,79,-121,82};
      k_it->vast1 = {91,-116,119,-123,-126,126,-122,124,120,-121,-116,-116,127,124,-121,79,-123,126,126,120,127,-116,-122,-121,79};
      k_it->vast2 = {103,120,-121,-123,116,123,-116,119,-123,-126,122,120,-122,-121,-123,124,-127,-126,-127,124,116};
      k_it->vast3 = {88,-123,-116,-121,-123,-126,-125,-126,124,120,-121,124,124,-127,124,116};
      k_it->vast4 = {97,-126,-123,117,-126,127,120,-121,-126,-127,124,116};
      k_it->selitys = {103,-120,-126,-121,120,-127,124,-128,120,127,-121,79,79,-127,51,91,120,-128,-126,123,120,-122};
    }

    if(kountteri == 50) {
      k_it->k_luku = 69;
      k_it->kysym = {-110,-82,-77,-80,-127,101,-72,-86,-70,-73,-90,-90,-69,-82,-72,-71,-90,101,-107,-90,-90,-69,-76,101,-101,-127,-66,-73,-66,-77,-86,-77,101,-76,-77,101,-73,-90,-80,-86,-77,-77,-70,-71,-71,-90,-77,-70,-71,-124};
      k_it->vast1 = {-112,-82,-73,-80,-76,-77};
      k_it->vast2 = {-112,-90,-73,-71,-90,-77,-76,-77};
      k_it->vast3 = {-105,-82,-72,-71,-86,-82,-79,-82,-81,-127,-90,-79,-70,-80,-72,-86,-77};
      k_it->vast4 = {-107,-86,-72,-127,-75,-90,-79,-79,-76,-90,-73,-86,-86,-77,-90,-77};
    }

    if(kountteri == 51) {
      k_it->k_luku = 95;
      k_it->kysym = {-84,-56,-45,-101,127,-52,-44,-46,-56,-56,-54,-54,-56,-54,-64,-49,-49,-64,-53,-60,-45,-45,-64,127,-54,-50,-44,-53,-44,-64,-52,-49,-44,-55,-64,127,-81,-60,-54,-54,-64,-116,-92,-47,-56,-62,127,-96,-44,-43,-56,-51,-60,-51,127,-54,-101,-40,-45,-45,-56,127,-56,-46,-54,-44,-46,-45,-64,-64,-51,127,-54,-60,-47,-45,-50,-43,-64,-51,127,-72,-50,-44,-77,-44,-63,-60,-116,-43,-56,-61,-60,-50,-51,127,-45,-64,-44,-46,-45,-64,-53,-53,-64,-98};
      k_it->vast1 = {-86,-84,-91,-93,-84,127,-116,127,-78,-45,-47,-64,-40,127,-95,-44,-53,-53,-60,-45};
      k_it->vast2 = {-91,-47,-50,-51,-45,127,-111,-109,-111,127,-116,127,-89,-60,-64,-61,-57,-44,-51,-45,-60,-47,127,-43,-110,-115,-113};
      k_it->vast3 = {-83,-56,-45,-39,-60,-47,127,-92,-63,-63,127,-116,127,-75,-56,-50,-53,-60,-51,-45,127,-81,-53,-64,-40,-58,-47,-50,-44,-51,-61};
      k_it->vast4 = {-92,-47,-56,-62,127,-94,-53,-64,-49,-45,-50,-51,127,-116,127,-74,-50,-51,-61,-60,-47,-59,-44,-53,127,-77,-50,-51,-56,-58,-57,-45};
      k_it->luk4 = true;
    }

    if(kountteri == 52) {
      k_it->k_luku = 70;
      k_it->kysym = {-111,-69,-79,-89,102,-71,-85,-69,-72,-89,-89,-68,-81,-71,-70,-89,102,-84,-81,-78,-75,-71,-75,-84,-85,-81,-71,-70,-89,102,-79,-81,-81,-76,-76,-75,-71,-70,-81,102,-85,-72,-81,-70,-65,-81,-71,-85,-71,-70,-81,102,-79,-75,-69,-78,-69,-89,-77,-74,-69,-80,-89,102,-106,-85,-79,-79,-89,115,-117,-72,-81,-87,102,-121,-69,-68,-81,-71,-70,-89,-123};
      k_it->vast1 = {-116,-72,-81,-85,-86,-72,-81,-87,-82,102,-108,-81,-85,-70,-64,-71,-87,-82,-85};
      k_it->vast2 = {-109,-89,-72,-79,-81,-81,-71,-81,102,-86,-85,102,-103,-89,-86,-85};
      k_it->vast3 = {-109,-89,-72,-70,-81,-76,102,-114,-85,-81,-86,-85,-83,-83,-85,-72};
      k_it->vast4 = {-121,-65,-76,102,-104,-89,-76,-86};
    }

    if(kountteri == 53) {
      k_it->k_luku = 27;
      k_it->kysym = {104,-124,-122,87,59,-118,-121,-124,59,113,124,-119,-113,124,124,-119,59,-122,124,-112,-117,-117,124,-122,-128,-114,-122,-112,-114,59,104,-108,-108,-115,-120,124,-119,-119,-124,-119,59,-111,-112,-118,127,-128,-119,59,77,75,75,77,59,-117,-118,-120,-120,-124,72,-124,-114,-122,-112,-119,59,-113,-128,-122,-124,-123,87,-119,59,-120,-118,-113,-124,-124,-111,-124,90};
      k_it->vast1 = {104,-118,-113,-124,-124,-111,-124,59,-128,-124,59,-114,-128,-121,-111,-124,-119,-119,-108,-113};
      k_it->vast2 = {104,-124,-114,124,-119,-113,-115,-118,-117,-124,124};
      k_it->vast3 = {102,124,-119,-114,124,-121,-121,-124,-114,-120,-124,-128,-121,-124,-114,-108,-108,-114};
      k_it->vast4 = {107,124,-122,-122,-118,-114,-128,-121,-124,125,124,124,-113,-113,-124};
    }

    if(kountteri == 54) {
      k_it->k_luku = 87;
      k_it->kysym = {-92,-64,-59,-62,-109,119,-59,-64,-60,-64,-54,-68,-61,-61,-109,119,-96,-59,-53,-68,-55,-59,-68,-53,-64,-59,119,-62,-68,-54,-62,-52,-54,-53,-68,-61,-52,-67,-58,-58,-55,-52,-60,-64,-61,-61,-72,119,-83,-72,-59,-53,-72,-72,-59,119,-62,-72,-52,-57,-57,-72,-62,-68,-54,-62,-52,-54,119,-92,-48,-48,-55,-60,-72,-59,-59,-64,-59,119,-51,-52,-58,-69,-68,-59,119,-119,-121,-121,-119,119,-57,-58,-60,-60,-64,-124,-64,-54,-62,-52,-59,119,-53,-68,-62,-64,-63,-109,119,-58,-61,-64,119,-58,-61,-61,-52,-53,119,-72,-62,-53,-64,-64,-51,-64,-59,-68,-59,-106};
      k_it->vast1 = {-94,-58,-53,-64,-62,-68,-60,-64,-72};
      k_it->vast2 = {-97,-58,-60,-60,-72,-67,-58,-55,-52,-60};
      k_it->vast3 = {-90,-60,-72,-55,-109,-63,-109,-65,-69,-68};
      k_it->vast4 = {-100,-64,-59,-54,-53,-68,-64,-59,-67,-58,-55,-52,-60};
    }

    if(kountteri == 55) {
      k_it->k_luku = 25;
      k_it->kysym = {102,-126,-115,85,57,-117,85,-125,85,-127,125,-110,-116,122,-126,-121,126,-115,-115,122,57,111,122,-121,-115,122,122,-121,57,-124,122,-114,-119,-119,122,-124,126,-116,-124,-114,-116,57,102,-110,-110,-117,-122,122,-121,-121,-126,-121,57,-113,-114,-120,125,126,-121,57,75,73,73,75,57,-119,-120,-122,-122,-126,70,-126,-116,-124,-114,-116,-116,122,57,-124,85,-110,-115,126,-115,-115,-126,-126,-121,88};
      k_it->vast1 = {90,103,103,102};
      k_it->vast2 = {97,103,98,112};
      k_it->vast3 = {105,94,109,103};
      k_it->vast4 = {109,103,109};
    }

    if(kountteri == 56) {
      k_it->k_luku = 26;
      k_it->kysym = {103,-125,-122,-122,-119,-125,-120,58,127,-120,127,-116,-127,-125,123,-124,-113,-119,-121,-125,-115,-115,123,58,-109,-122,127,-125,-115,127,-115,-114,-125,58,-123,86,-109,-114,127,-114,-114,-109,58,-114,123,-113,-116,-125,-125,-120,-125,58,-115,123,-122,-122,-125,-114,-114,-125,-125,-120,58,109,-113,-119,-121,127,-115,-115,123,89};
      k_it->vast1 = {75,83,83,82};
      k_it->vast2 = {75,83,82,82};
      k_it->vast3 = {76,74,74,82};
      k_it->vast4 = {75,83,81,82};
      k_it->selitys = {109,123,-122,-122,-125,-114,-114,-125,-125,-120,58,95,111,84,-120,58,-118,123,-125,-120,-119,-115,-114,-113,-123,-115,127,-115,-114,123};
    }

    if(kountteri == 57) {
      k_it->k_luku = 92;
      k_it->kysym = {-87,-59,-49,-48,-104,124,-63,-54,-63,-50,-61,-59,-67,-58,-47,-53,-55,-59,-63,-54,124,-67,-54,-48,-67,-55,-67,124,-63,-54,-63,-50,-61,-59,-67,124,-63,-54,-59,-55,-55,-104,-57,-49,-63,-63,-54,124,-48,-47,-56,-63,-63,-101};
      k_it->vast1 = {-81,-53,-57,-63,-50,-59,-49,-48,-67};
      k_it->vast2 = {-89,-53,-62,-63,-59,-59,-54,-59,-49,-48,-67};
      k_it->vast3 = {-80,-67,-47,-50,-59,-59,-54,-59,-49,-48,-67};
      k_it->vast4 = {-93,-47,-67,-50,-67,-54,-67,-49,-48,-67};
    }

    if(kountteri == 58) {
      k_it->k_luku = 13;
      k_it->kysym = {90,118,120,73,45,124,123,45,-125,110,123,117,118,123,45,-128,-126,124,122,110,121,110,118,123,114,123,45,114,123,114,127,116,118,110,119,-126,124,122,110,122,114,127,120,120,118,76};
      k_it->vast1 = {99,118,-127,110,45,91,124,-125,110};
      k_it->vast2 = {97,114,117,124};
      k_it->vast3 = {82,81};
      k_it->vast4 = {79,110,-127,-127,114,127,-122};
      k_it->selitys = {62,70,68,61,58,121,-126,-125,-126,121,-127,110};
    }

    if(kountteri == 59) {
      k_it->k_luku = 10;
      k_it->kysym = {87,115,117,70,42,121,120,42,79,93,42,55,111,120,111,124,113,115,107,116,127,121,119,107,120,42,-128,107,118,119,115,125,126,127,125,119,107,107,73};
      k_it->vast1 = {75,118,107,120,117,121,119,107,107,126};
      k_it->vast2 = {85,107,120,107,110,107};
      k_it->vast3 = {93,127,121,119,115};
      k_it->vast4 = {93,107,117,125,107};
    }

    if(kountteri == 60) {
      k_it->k_luku = 46;
      k_it->kysym = {123,-105,-103,106,78,-95,-109,-93,-96,-113,-113,-92,-105,-95,-94,-113,78,-113,-105,-100,-109,-105,-95,-94,-113,78,-109,-105,78,-95,-105,-95,106,-102,-102,-89,78,115,-127,78,91,-109,-100,-109,-96,-107,-105,-113,-104,-93,-99,-101,-113,-113,-100,109};
      k_it->vast1 = {123,-113,-102,-94,-99,-110,-109,-103,-95,-94,-96,-105,-105,-100,-105};
      k_it->vast2 = {119,-100,-99,-95,-105,-94,-99,-102,-105};
      k_it->vast3 = {-126,-113,-93,-96,-105,-105,-100,-105};
      k_it->vast4 = {117,-102,-93,-103,-93,-96,-99,-100,-99,-102,-113,-103,-94,-99,-100,-105};
    }

    if(kountteri == 61) {
      k_it->k_luku = 30;
      k_it->kysym = {107,-121,-116,-116,-125,62,104,-109,-112,127,-111,-125,62,110,127,-112,-119,62,75,-110,-125,-125,-117,127,-114,-109,-121,-111,-110,-115,127,62,-111,-109,-109,-116,-116,-121,-110,-125,-118,-110,-121,-121,-116,62,-114,-125,-112,-109,-111,-110,-125,-110,-110,127,-108,127,-119,-111,-121,93};
      k_it->vast1 = {116,127,-116,-110,127,127,-116,62,105,-125,-121,-117,-115,-118,127,127,-116};
      k_it->vast2 = {99,-111,-114,-115,-115,-116,62,113,-109,-115,-117,-125,-116,-115,-120,127,127,-116};
      k_it->vast3 = {116,127,-116,-110,127,127,-116,62,105,-115,-112,-111,-115,-115,-116};
      k_it->vast4 = {99,-111,-114,-115,-115,-116,-118,127,-122,-110,-125,-125,-116};
    }

    if(kountteri == 62) {
      k_it->k_luku = 80;
      k_it->kysym = {-99,-71,-61,-60,-116,112,-67,-79,-79,-61,-60,-79,112,-102,-59,-62,-79,-61,-75,112,-96,-79,-62,-69,112,125,-72,-79,-66,-69,-69,-75,-75,-66,112,-62,-79,-72,-65,-71,-60,-59,-69,-61,-75,-66,112,-65,-68,-71,112,-75,-66,-71,-67,-67,-116,-69,-61,-75,-75,-66,112,-60,-79,-62,-69,-65,-71,-60,-59,-61,112,-60,-59,-68,-68,-79,-113};
      k_it->vast1 = {-101,-71,-71,-66,-79,-61,-60,-79};
      k_it->vast2 = {-87,-72,-76,-55,-61,-58,-79,-68,-68,-65,-71,-61,-60,-79};
      k_it->vast3 = {-90,-75,-66,-116,-70,-116,-68,-60,-116};
      k_it->vast4 = {-92,-79,-66,-61,-69,-79,-61,-60,-79};
    }

    if(kountteri == 63) {
      k_it->k_luku = 32;
      k_it->kysym = {109,-119,-117,92,64,-109,-123,-107,-110,-127,-127,-106,-119,-109,-108,-127,64,-123,-119,64,-113,-116,-116,-107,-108,64,106,-107,-110,-127,-109,-123,64,112,-127,-110,-117,-119,-119,-114,64,-117,-127,-127,-106,-127,-119,-116,-108,-107,64,-117,-113,-120,-124,-123,95};
      k_it->vast1 = {100,-119,-114,-113,77,-121,-113,-116,-122,-110,-127,-108,-127};
      k_it->vast2 = {97,-110,-117,-123,-113,-116,-113,-121,-119,-114,-123,-114,64,-117,-127,-119,-106,-127,-107,-109,-127,-116,-107,-123};
      k_it->vast3 = {116,-110,-113,-113,-112,-112,-119,-114,-123,-114,64,-112,-107,-107,-108,-127,-110,-120,-127};
      k_it->vast4 = {115,-107,-113,-115,-123,-114,64,-109,-107,-107,-110,-119,-114,64,-110,-127,-106,-119,-114,-108,-113,-116,-127,-108,-123,-110,-127,-109,-109,-119};
    }

    if(kountteri == 64) {
      k_it->k_luku = 47;
      k_it->kysym = {122,-92,-104,-99,-102,-112,79,-100,-98,-99,-93,-112,79,-104,-105,-100,-104,-94,-93,107,79,-94,-112,-104,79,-95,-104,-102,-98,-94,-93,-92,-98,-100,-104,-98,-99,79,-91,-92,-98,-109,-108,-99,79,96,104,104,103,79,-97,-108,-94,107,-97,-112,-101,-101,-98,-99,79,-94,-98,-97,-92,-97,-108,-101,-104,-94,-102,-112,-99,-109,-112,-112,-101,-104,-94,-94,-112,110};
      k_it->vast1 = {98,95};
      k_it->vast2 = {98};
      k_it->vast3 = {98,95,95};
      k_it->vast4 = {98,95,95,95};
    }

    if(kountteri == 65) {
      k_it->k_luku = 85;
      k_it->kysym = {-94,-66,-64,-111,117,-56,-70,-54,-57,-74,-74,-53,-66,-56,-55,-74,117,-59,-70,-56,-111,-59,-74,-63,-63,-60,-65,-60,-54,-64,-64,-54,-70,-66,-56,-55,-74,117,-70,-66,117,-63,-66,-66,-55,-55,-50,-61,-50,-55,117,-53,-54,-60,-71,-70,-61,117,-122,-114,-114,-115,117,-56,-60,-59,-54,-59,-70,-63,-66,-56,-64,-74,-61,-71,-74,-74,-63,-66,-66,-61,-108};
      k_it->vast1 = {-91,-74,-55,-55,-66,-65,-60,-70,-61,117,-86,-57,-67,-70,-66,-63,-66,-65,-74,-55};
      k_it->vast2 = {-96,-74,-66,-56,-74,-61,-66,-70,-62,-70,-61,117,-87,-66,-66,-64,-70,-57,-66,-55};
      k_it->vast3 = {-88,-70,-66,-61,-111,-65,-60,-70,-61,117,-94,-74,-66,-63,-74,-126,-97,-54,-56,-56,-66,-55};
      k_it->vast4 = {-92,-54,-63,-54,-61,117,-95,-66,-59,-59,-60};
    }

    if(kountteri == 66) {
      k_it->k_luku = 6;
      k_it->kysym = {81,123,111,116,113,103,38,118,103,114,112,117,116,38,92,107,111,113,113,103,123,121,38,85,127,64,116,38,103,120,124,111,117,111,122,111,111,116,38,110,66,124,111,116,116,107,107,116,38,120,103,110,103,103,38,118,107,121,66,118,103,114,114,117,116,38,124,123,117,106,107,116,38,55,63,63,62,38,121,113,103,116,106,103,103,114,111,111,116,38,114,111,111,122,122,127,124,111,107,116,38,121,117,124,111,122,122,123,112,107,116,38,118,107,114,111,107,116,38,124,123,117,113,121,111,69};
      k_it->vast1 = {55,58,38,115,111,114,112,117,117,116,103,103,38,115,103,120,113,113,103,103};
      k_it->vast2 = {58,54,54,38,54,54,54,38,115,103,120,113,113,103,103};
      k_it->vast3 = {58,54,38,54,54,54,38,115,103,120,113,113,103,103};
      k_it->vast4 = {55,58,54,38,115,111,114,112,117,117,116,103,103,38,115,103,120,113,113,103,103};
    }

    if(kountteri == 67) {
      k_it->k_luku = 79;
      k_it->kysym = {-100,-72,-69,-69,-66,-72,-67,111,-73,-76,-63,-66,-72,-72,-67,-72,-67,111,-68,-56,-56,-67,-61,-72,111,-69,-66,-65,-65,-60,-72,111,-59,-72,-63,-80,-69,-69,-72,-62,-76,-62,-61,-72,111,-94,-60,-66,-68,-76,-67,111,-80,-65,-61,-76,-76,-70,-76,-72,-62,-62,-80,-114};
      k_it->vast1 = {-128,-120,-124,-122};
      k_it->vast2 = {-128,-120,-126,-122};
      k_it->vast3 = {-128,-120,-128,-122};
      k_it->vast4 = {-128,-120,-122,-122};
      k_it->selitys = {-102,-117,-56,-61,-117,-67,-67,-84,-62,-62,-117,111,-68,-56,-56,-67,-61,-72,111,-66,-69,-72,111,-73,-72,-72,-65,-60,-67,-60,-61,111,-71,-66,111,-80,-72,-76,-68,-68,-72,-67,125};
    }

    if(kountteri == 68) {
      k_it->k_luku = 91;
      k_it->kysym = {-88,-60,-58,-105,123,-50,-64,-48,-51,-68,-68,-47,-60,-50,-49,-68,123,-68,-60,-55,-64,-60,-50,-49,-68,123,-64,-60,123,-58,-48,-48,-57,-48,-55,-48,-49,123,-82,-48,-54,-56,-64,-55,123,-51,-60,-55,-49,-68,-56,-68,-50,-68,-60,-51,-68,-68,-57,-68,-55,123,-47,-68,-57,-60,-58,-54,-60,-56,-60,-60,-55,123,-81,-54,-60,-50,-64,-55,123,-56,-68,-68,-60,-57,-56,-68,-55,-50,-54,-65,-68,-55,123,-68,-60,-58,-68,-55,-68,-102};
      k_it->vast1 = {-99,-64,-55,-49,-50,-54,-65,-60,-68,-49,-50,-64,-53,-60,-60,-55,-60};
      k_it->vast2 = {-93,-64,-51,-54,-60,-60,-55,-60};
      k_it->vast3 = {-86,-54,-53,-60,-48,-56,-60};
      k_it->vast4 = {-88,-64,-49,-68,-56,-63,-64,-49,-68,-56,-60,-60,-55,-60};
      k_it->selitys = {-82,-48,-54,-56,-64,-55,123,-60,-49,-50,-64,-55,-105,-60,-50,-44,-44,-50,123,-53,-64,-51,-48,-50,-49,-48,-48,123,-61,-48,-48,-56,-64,-60,-50,-60,-60,-55,-119};
    }

    if(kountteri == 69) {
      k_it->k_luku = 69;
      k_it->kysym = {-110,-82,-79,-79,-90,-82,-77,-86,-77,101,-72,-80,-82,-71,-72,-76,-85,-73,-86,-77,-82,-77,-86,-77,101,-83,-90,-73,-83,-90,-80,-70,-69,-82,-71,-86,-79,-78,-90,101,-69,-70,-76,-77,-77,-90,101,118,126,126,126,101,-80,-76,-79,-78,-86,101,-78,-82,-86,-72,-71,-127,101,-90,-78,-75,-70,-77,-86,-86,-79,-79,-90,101,-104,-90,-77,-77,-90,101,-104,-82,-79,-79,-90,-77,-75,-127,-127,-79,-79,-127,101,-76,-79,-82,-124};
      k_it->vast1 = {-118,-71,-71,-127,101,-83,-127,-77,-86,-77,101,-78,-82,-86,-83,-86,-77,-72,-127,101,-76,-79,-82,101,-72,-70,-73,-78,-90,-71,-71,-70,115};
      k_it->vast2 = {-118,-71,-71,-127,101,-83,-127,-77,-86,-77,101,-69,-86,-79,-81,-86,-77,-72,-127,101,-76,-79,-82,101,-72,-90,-90,-77,-70,-71,101,-75,-76,-71,-80,-70,-71,115};
      k_it->vast3 = {-118,-71,-71,-127,101,-83,-127,-77,-86,-77,101,-72,-82,-72,-80,-76,-77,-72,-90,101,-76,-79,-82,101,-72,-82,-86,-75,-90,-71,-71,-70,115};
      k_it->vast4 = {-118,-71,-71,-127,101,-83,-127,-77,-86,-77,101,-80,-82,-72,-72,-90,-77,-72,-90,101,-76,-79,-82,101,-79,-76,-75,-86,-71,-86,-71,-71,-70,115};
      k_it->selitys = {-115,-127,-77,101,-79,-70,-70,-79,-82,101,-76,-79,-79,-86,-86,-77,-72,-90,101,-77,-90,-82,-78,-82,-72,-82,-72,-72,-90,101,-72,-70,-73,-78,-90,-71,-70,-77,101,-117,-121,-114,114,-90,-84,-86,-77,-71,-82,-77,101,-80,-90,-77,-72,-72,-90,101,-81,-90,101,-83,-90,-79,-70,-72,-82,101,-80,-76,-72,-71,-90,-90,115};
    }

    if(kountteri == 70) {
      k_it->k_luku = 54;
      k_it->kysym = {-127,-85,-97,-92,-95,-105,86,-95,-105,-85,-105,-92,86,-128,-85,-93,-105,-94,-105,-92,86,-86,-101,-105,-86,-86,-101,-88,-97,-92,86,-84,-85,-91,-92,-92,-105,86,103,111,110,109,86,-87,-95,-105,-92,-102,-105,-105,-94,-97,-92,86,-105,-97,-98,-101,-85,-86,-86,-105,-92,-85,-86,86,-101,-87,-97,-86,-81,-87,86,-95,-101,-87,-86,-97,117};
      k_it->vast1 = {-127,-105,-95,-87,-97,86,-93,-97,-92,-85,-85,-86,-86,-97,-105};
      k_it->vast2 = {104,102,86,-93,-97,-92,-85,-85,-86,-86,-97,-105};
      k_it->vast3 = {-127,-105,-95,-87,-97,86,-86,-85,-92,-86,-97,-105};
      k_it->vast4 = {103,104,86,-93,-97,-92,-85,-85,-86,-86,-97,-105};
    }

    if(kountteri == 71) {
      k_it->k_luku = 71;
      k_it->kysym = {-108,-80,-78,-125,103,-74,-75,103,-125,-125,-71,-80,-74,-80,-78,-84,-80,-70,-69,-74,-77,-88,-80,-70,-84,-75,103,-75,-84,-69,-69,-80,-88,-78,-69,-80,-67,-80,-70,-69,-80,103,-102,-84,-73,-73,-74,103,-109,-84,-81,-85,-74,-75,103,-78,-74,-69,-80,-78,-88,-68,-73,-68,-75,-78,-80,-122};
      k_it->vast1 = {-101,-88,-76,-73,-84,-71,-84};
      k_it->vast2 = {-101,-68,-71,-78,-68};
      k_it->vast3 = {-111,-74,-84,-75,-70,-68,-68};
      k_it->vast4 = {-111,-64,-67,-125,-70,-78,-64,-77,-125};
    }

    if(kountteri == 72) {
      k_it->k_luku = 20;
      k_it->kysym = {97,125,127,80,52,127,117,-119,-124,-119,-126,127,125,52,-120,-119,-126,-126,121,-120,-120,125,125,-126,52,69,77,77,68,65,-128,-119,-118,-119,-128,-128,117,52,-121,127,125,-126,124,121,117,120,121,125,-121,-120,117,117,-126,83};
      k_it->vast1 = {94,-125,121,-126,-121,-119,-119};
      k_it->vast2 = {104,117,-127,-124,121,-122,121};
      k_it->vast3 = {99,-119,-128,-119};
      k_it->vast4 = {95,117,126,117,117,-126,125};
    }

    if(kountteri == 73) {
      k_it->k_luku = 74;
      k_it->kysym = {-105,-77,-66,-122,106,-108,-65,-73,-85,-74,-85,-72,106,-66,-81,-85,-66,-66,-81,-68,-77,-67,-67,-85,106,-78,-81,-77,-66,-81,-66,-66,-77,-77,-72,106,-61,-74,-81,-77,-67,-89,-72,106,-70,-122,-122,-74,-74,-81,-119};
      k_it->vast1 = {-97,-74,-71,-67,-66,-81,-66,-66,-85};
      k_it->vast2 = {-97,-68,-81,-66,-85,-85,-72,-77,-85};
      k_it->vast3 = {-108,-65,-79,-65,-68,-66,-66,-77,-85};
      k_it->vast4 = {-106,-85,-67,-77,-64,-77,-74,-74,-85,-85};
    }

    if(kountteri == 74) {
      k_it->k_luku = 55;
      k_it->kysym = {-124,-96,-94,115,87,-86,-100,-84,-87,-104,-104,-83,-96,-86,-85,-104,87,-100,-96,87,-90,-93,-100,87,-77,-94,-100,-86,-90,-99,-85,-96,-91,87,-89,-100,-93,-96,118};
      k_it->vast1 = {122,-80,-103,-100,-87,87,120,-91,-85,-100,-87,-90};
      k_it->vast2 = {-128,-91,-83,-104,-85,-104,-81,-96};
      k_it->vast3 = {-118,-90,-94,-94,-90,-92,-104,-85,-90};
      k_it->vast4 = {121,-100,-89,-104,87,-120,-84,-100,-86,-85};
    }

    if(kountteri == 75) {
      k_it->k_luku = 48;
      k_it->kysym = {123,-91,-101,-111,80,-101,-111,-98,-93,-111,-98,-107,-108,-91,-93,-92,-111,-102,-111,80,-97,-98,80,-93,-111,-111,-98,-91,-92,80,-96,-91,-104,-107,-99,-103,-107,-104,-107,-100,-92,108,80,-104,-91,-97,-99,-111,-91,-92,-91,-101,-93,-107,-98,80,-104,-111,-92,-91,-98,80,-101,108,-87,-92,-92,108,-99,-103,-93,-107,-93,-92,108,80,-103,-93,-92,-91,-98,-92,-97,-93,-111,-100,-103,-93,-93,-111,111};
      k_it->vast1 = {-122,-107,-100,-92,-92,-97,80,-122,-103,-94,-92,-111,-98,-107,-98};
      k_it->vast2 = {-126,-97,-93,-111,80,125,-107,-94,-103,-100,108,-103,-98,-107,-98};
      k_it->vast3 = {122,-87,-94,-101,-103,80,122,94,122,94,80,123,-111,-93,-90,-103};
      k_it->vast4 = {125,-103,-101,-111,-107,-100,80,122,-91,-98,-105,-98,-107,-94};
    }

    if(kountteri == 76) {
      k_it->k_luku = 34;
      k_it->kysym = {109,-105,-115,-125,66,-115,-125,-112,-107,-125,-112,-121,-122,-105,-107,-106,-125,-116,-125,66,-107,-125,-117,66,-121,-122,-105,-107,-115,-105,-112,-112,-125,-112,66,-110,-105,-118,-121,-113,-117,-121,-118,-121,-114,-106,94,66,-118,-105,-111,-113,-125,-105,-106,-105,-115,-107,-121,-112,66,-104,-105,-111,-112,-112,-125,66,84,82,83,86,66,-118,-121,-117,-106,-121,-114,-106,-101,94,94,-112,66,-110,-125,-110,-121,-108,-117,-112,-107,-125,66,-101,-113,-110,94,-108,-117,66,-117,-107,-106,-105,-112,-106,-111,-107,-125,-114,-117,-125,66,-116,-125,66,-110,-111,-117,-107,-106,-105,-106,-106,-105,-125,-125,-112,66,-106,-121,-125,-106,-108,-125,-125,-114,-117,-107,-121,-107,-106,-117,66,-110,-125,-117,-115,-125,-114,-106,-125,97};
      k_it->vast1 = {120,-121,-114,-106,-106,-111,66,120,-117,-108,-106,-125,-112,-121,-112};
      k_it->vast2 = {108,-105,-106,-106,-125,66,119,-108,-110,-117,-114,-125,-117,-112,-121,-112};
      k_it->vast3 = {117,-125,-112,-112,-117,66,105,-108,-125,-118,-112,79,110,-125,-125,-107,-111,-112,-121,-112};
      k_it->vast4 = {113,-107,-113,-111,66,117,-111,-117,-112,-117,-112,-104,-125,-125,-108,-125};
      k_it->selitys = {120,-117,-108,-106,-125,-112,-121,-112,66,-111,-114,-117,66,-115,-101,-114,-114,94,-107,-106,-101,-112,-101,-106,66,-107,-117,-117,-118,-121,-112,78,66,-121,-106,-106,-121,-117,66,-107,-125,-125,-112,-105,-106,66,-110,-105,-118,-121,-113,-117,-121,-118,-121,-114,-106,94,66,-110,-105,-118,-121,-121,-112,-104,-105,-111,-108,-111,-125,80};
    }

    if(kountteri == 77) {
      k_it->k_luku = 0;
      k_it->kysym = {77,105,116,101,110,32,74,117,109,97,108,97,110,32,116,101,97,116,116,101,114,105,110,32,101,115,105,116,116,60,106,60,116,32,115,111,118,105,116,116,105,118,97,116,32,101,115,105,116,121,107,115,101,115,116,60,60,110,32,115,101,117,114,97,110,110,101,101,110,32,114,97,97,115,116,117,118,97,110,111,105,107,101,117,100,101,110,32,116,117,111,109,105,111,110,63};
      k_it->vast1 = {84,121,93,115,105,105,114,116,111,108,97,115,115,97};
      k_it->vast2 = {75,117,114,105,116,117,115,104,117,111,110,101,101,115,115,97};
      k_it->vast3 = {65,118,111,118,97,110,107,105,108,97,115,115,97};
      k_it->vast4 = {89,104,100,121,115,107,117,110,116,97,112,97,108,118,101,108,117,110,97};
    }

    if(kountteri == 78) {
      k_it->k_luku = 22;
      k_it->kysym = {99,127,-126,-126,-123,127,-124,54,97,-123,-119,-127,123,-124,-127,-123,-120,-116,119,54,-118,-117,-126,127,54,-125,-113,-113,-124,-118,127,127,-124,85};
      k_it->vast1 = {71,79,75,73};
      k_it->vast2 = {71,79,74,73};
      k_it->vast3 = {71,79,73,73};
      k_it->vast4 = {71,79,72,73};
    }

    if(kountteri == 79) {
      k_it->k_luku = 62;
      k_it->kysym = {-119,-83,-79,-87,-93,-84,-87,-83,-80,-76,-97,-84,94,-82,122,122,-97,-79,-89,-97,-86,-86,-89,-84,-93,-84,94,-80,-97,-97,-87,-97,107,-97,-89,-84,-93,94,-83,-84,94,-84,-73,-87,-73,122,122,-84,94,-83,-90,-80,-97,106,94,-85,-77,-78,-78,-97,94,-85,-89,-79,-78,122,94,-79,-93,94,-97,-86,-77,-84,94,-82,-93,-80,-89,-84,94,-78,-93,-90,-78,-89,-89,-84,125};
      k_it->vast1 = {-114,-93,-80,-77,-84,-97,-79,-78,-97};
      k_it->vast2 = {-112,-77,-87,-89,-89,-79,-78,-97};
      k_it->vast3 = {-108,-93,-90,-84,122,-79,-78,122};
      k_it->vast4 = {-117,-97,-89,-79,-79,-89,-79,-78,-97};
    }

    if(kountteri == 80) {
      k_it->k_luku = 19;
      k_it->kysym = {96,124,-122,-121,79,51,126,116,-120,-125,-120,-127,122,124,-122,-121,116,51,86,-126,118,116,64,86,-126,127,116,-127,51,125,-120,-126,-128,124,-122,120,-127,51,120,-127,-127,79,-121,-116,-122,-121,79,51,88,-127,-127,79,-121,-116,-122,-121,120,123,119,116,-122,51,64,-126,123,125,120,127,-128,116,-122,-122,116,51,-116,-123,124,-121,-121,79,-127,-116,-121,51,98,127,127,124,51,91,-126,126,126,116,-127,120,-127,51,-126,127,124,51,126,-126,-121,-126,124,-122,124,-127,82};
      k_it->vast1 = {96,124,126,126,120,127,124,-122,-121,79};
      k_it->vast2 = {93,-126,120,-127,-122,-120,-120,-122,-121,116};
      k_it->vast3 = {102,116,-119,-126,-127,127,124,-127,-127,116,-122,-121,116};
      k_it->vast4 = {92,-128,116,-121,-123,116,127,-121,116};
    }

    if(kountteri == 81) {
      k_it->k_luku = 92;
      k_it->kysym = {-89,-47,-59,-54,-57,-67,124,-55,-53,-54,-48,-67,124,-56,-67,-49,-59,-67,124,-97,-53,-65,-67,-119,-97,-53,-56,-67,-67,124,-85,-56,-56,-59,124,-92,-53,-57,-57,-67,-54,-63,-54,124,-49,-67,-59,124,-58,-47,-53,-48,-47,-67,124,-95,-54,-54,-104,-48,-43,-49,-48,-63,-60,-64,-67,-49,124,-119,-53,-60,-58,-63,-56,-55,-67,-49,-49,-67,124,-46,-47,-53,-54,-54,-67,124,-114,-116,-116,-110,-101,124,-88,-67,-49,-63,-58,-67,124,-53,-56,-59,124,-49,-63,-59,-48,-49,-63,-55,-104,-54,-120,124,-58,-53,-59,-49,-49,-67,124,-43,-60,-48,-63,-63,-54,-49,-104,124,-115,-120,-111,124,-56,-59,-48,-50,-67,-67,124,-58,-47,-53,-48,-67,-46,-67,-67,-118};
      k_it->vast1 = {-89,-53,-56,-55,-63};
      k_it->vast2 = {-89,-67,-57,-49,-59};
      k_it->vast3 = {-86,-63,-56,-58,-104};
      k_it->vast4 = {-78,-59,-59,-49,-59};
    }

    if(kountteri == 82) {
      k_it->k_luku = 9;
      k_it->kysym = {86,114,125,110,119,41,124,126,121,110,123,111,120,120,109,54,106,109,127,120,116,106,106,125,125,114,41,88,117,117,114,41,89,120,124,125,114,41,127,69,114,125,125,114,41,114,125,124,110,41,113,-126,102,125,-126,119,110,110,119,124,69,41,124,126,121,110,123,111,120,120,109,114,124,125,106,72};
      k_it->vast1 = {95,69,114,125,125,114,41,121,106,123,106,119,125,126,119,110,110,119,124,106,41,86,92,54,125,106,126,109,114,124,125,106};
      k_it->vast2 = {95,69,114,125,125,114,41,121,106,123,106,119,125,126,119,110,110,119,124,106,41,117,110,126,116,110,118,114,106,124,125,106};
      k_it->vast3 = {95,69,114,125,125,114,41,124,106,106,119,110,110,119,124,106,41,119,69,116,102,116,-126,116,-126,119,124,69,41,125,106,116,106,114,124,114,119};
      k_it->vast4 = {95,69,114,125,125,114,41,121,69,69,124,124,110,110,119,124,69,41,114,123,125,114,41,125,126,121,106,116,106,124,125,106};
    }

    if(kountteri == 83) {
      k_it->k_luku = 90;
      k_it->kysym = {-89,-61,-50,-106,122,-51,-65,-49,-52,-69,-69,-48,-61,-51,-50,-69,122,-51,-61,-65,-56,-61,-51,-50,-106,122,-57,-69,-52,-59,-59,-61,-56,-55,-61,-50,-61,-61,-56,122,-116,-118,-118,-118,-121,122,-60,-69,122,-116,-118,-117,-118,-121,-58,-49,-59,-49,-60,-65,-56,122,-48,-69,-61,-62,-50,-65,-65,-56,122,-51,-49,-54,-65,-52,-64,-55,-55,-66,-121,-68,-49,-49,-57,-61,-56,122,-69,-61,-59,-55,-61,-62,-61,-56,122,-51,-49,-54,-65,-52,-52,-49,-55,-59,-69,-56,-69,-103};
      k_it->vast1 = {-86,-69,-59,-49,-52,-61,-59,-106,-106,-54,-106};
      k_it->vast2 = {-84,-61,-49,-59,-49,-59,-106,-106,-54,-106};
      k_it->vast3 = {-91,-69,-58,-48,-69,-51,-48,-69,-62,-48,-65,-52,-55};
      k_it->vast4 = {-90,-65,-62,-50,-55,-48,-69,-62,-48,-65,-52,-55};
    }

    if(kountteri == 84) {
      k_it->k_luku = 71;
      k_it->kysym = {-108,-80,-69,-125,103,-70,-84,-68,-71,-88,-88,-67,-80,-70,-69,-88,103,-76,-88,-71,-79,-74,-80,-70,-69,-88,103,-76,-88,-71,-78,-78,-80,-75,-74,-80,-69,-80,-80,-75,103,121,119,119,119,116,103,-79,-88,103,121,119,120,119,116,-77,-68,-78,-68,-79,-84,-75,103,-67,-88,-80,-81,-69,-84,-84,-75,103,-70,-68,-73,-84,-71,-83,-74,-74,-85,116,-87,-68,-68,-76,-80,-75,103,-88,-80,-78,-74,-80,-81,-80,-75,103,-70,-68,-73,-84,-71,-71,-68,-74,-78,-88,-75,-88,-122};
      k_it->vast1 = {-114,-74,-79,-80,116,-76,-88,-71,-79,-88};
      k_it->vast2 = {-110,-88,-68,-75,-74,-73,-80,-81,-77,-88,-79,-88};
      k_it->vast3 = {-99,-88,-71,-80,-78,-70,-84,-75,-76,-88,-71,-79,-88};
      k_it->vast4 = {-113,-74,-73,-84,-88,-73,-68,-81,-67,-84,-77,-80,-75,-76,-88,-71,-79,-88};
    }

    if(kountteri == 85) {
      k_it->k_luku = 96;
      k_it->kysym = {-83,-55,-50,-53,-100,-128,-44,-49,-55,-45,-59,-50,-128,-46,-39,-56,-51,-55,-44,-44,-39,-51,-100,-50,-128,-53,-63,-50,-45,-45,-63,-128,-45,-43,-48,-59,-46,-58,-49,-49,-60,-115,-63,-60,-42,-49,-53,-63,-63,-44,-55,-44,-128,-49,-52,-55,-42,-63,-44,-128,-52,-39,-67,-44,-44,-100,-39,-44,-39,-50,-59,-59,-44,-128,-52,-100,-56,-59,-55,-45,-59,-45,-44,-55,-128,-39,-56,-44,-59,-59,-50,-128,-110,-112,-111,-112,-115,-52,-43,-42,-43,-50,-128,-63,-52,-43,-45,-45,-63,-97};
      k_it->vast1 = {-88,-49,-48,-59,-63,-45,-55,-54,-49,-55,-44,-44,-63,-54,-63,-44};
      k_it->vast2 = {-74,-43,-49,-53,-46,-63,-50,-63,-50,-44,-63,-54,-63,-44};
      k_it->vast3 = {-90,-46,-55,-45,-62,-59,-59,-57,-49,-52,-58,-63,-63,-54,-63,-44};
      k_it->vast4 = {-80,-63,-52,-45,-44,-63,-42,-55,-52,-54,-59,-52,-55,-54,-100,-44};
    }

    if(kountteri == 86) {
      k_it->k_luku = 67;
      k_it->kysym = {-112,-84,-79,-82,127,99,-79,-84,-80,-84,-74,-88,-79,99,-73,-84,-88,-73,-78,-82,-78,-79,-88,-85,-92,-75,-75,-92,-74,-73,-92,-83,-84,-88,-79,99,-75,-68,-85,-80,127,-79,99,-74,-88,-84,-82,-82,-92,-84,-81,-72,-84,-74,-73,-92,99,-82,-88,-75,-73,-78,-78,99,-100,-78,-72,-105,-72,-91,-88,112,-74,-92,-75,-83,-92,99,-109,-122,112,-113,-92,-80,-88,-75,-84,-73,-126};
      k_it->vast1 = {-122,115,115,-113,-88,-106,99,-102,-92,-107,-88,-99,99,-104,-111,-84,-110,-111};
      k_it->vast2 = {-120,-69,-78,-73,-84,-90,99,-112,-88,-79};
      k_it->vast3 = {-119,-72,-73,-72,-75,-88,99,-122,-75,-88,-70};
      k_it->vast4 = {-123,-92,-80,-84,-86,-92,99,-106,-88,-90,-73,-78,-75,99,-110,-79,-88};
    }

    if(kountteri == 87) {
      k_it->k_luku = 49;
      k_it->kysym = {126,-102,-91,109,81,123,-90,-98,-110,-99,-110,-97,81,-91,-106,-110,-91,-91,-106,-93,-102,-97,81,-97,109,-86,-91,-91,-106,-99,-102,-101,-114,-102,-99,-99,109,81,-96,-99,-102,81,-95,109,109,-99,-99,109,109,-97,81,-106,-92,-102,-102,-97,-91,-86,-98,-102,-92,-106,-97,81,-110,-102,-100,-110,-97,-110,112};
      k_it->vast1 = {118,-102,81,-98,-102,-91,109,109,-97};
      k_it->vast2 = {126,-110,-110,-92,-91,-96,-95,-90,-89,-90,-91};
      k_it->vast3 = {126,109,-93,-100,109,-95,-90,-89,-90,-91};
      k_it->vast4 = {126,-90,-97,-100,-100,-102,-106,-97,81,-100,-110,-110,-89,-90,-91};
    }

    if(kountteri == 88) {
      k_it->k_luku = 88;
      k_it->kysym = {-93,-67,-52,-61,-108,120,-61,-71,-58,-53,-71,-58,-67,-68,-51,-53,-52,-71,-62,-71,-52,120,-62,-108,-52,-52,-63,-50,-108,-52,120,-50,-51,-57,-58,-58,-71,120,-118,-120,-119,-116,120,-59,-63,-58,-63,-53,-52,-67,-54,-63,-60,-60,-67,120,-61,-63,-54,-62,-71,-60,-60,-63,-53,-67,-58,120,-61,-47,-53,-47,-59,-47,-61,-53,-67,-58,120,-84,-57,-59,120,-57,-66,120,-98,-63,-58,-60,-71,-58,-68,120,-123,-56,-57,-53,-52,-63,-59,-67,-54,-61,-67,-63,-53,-52,-108,-124,120,-62,-57,-63,-68,-67,-58,120,-64,-67,120,-61,-71,-52,-53,-57,-63,-50,-71,-52,120,-67,-53,-63,-59,-67,-54,-61,-63,-61,-53,-63,120,-50,-71,-64,-63,-58,-65,-57,-63,-52,-52,-71,-50,-71,-58,120,-85,-51,-57,-59,-63,-123,-61,-51,-50,-71,-71,-105};
      k_it->vast1 = {-84,-67,-51,-50,-57,120,-96,-71,-61,-61,-71,-54,-71,-63,-58,-67,-58,120,-62,-71,120,-91,-63,-61,-71,120,-90,-63,-63,-61,-61,-57};
      k_it->vast2 = {-88,-108,-63,-50,-63,120,-86,-108,-53,-108,-58,-67,-58,120,-62,-71,120,-88,-67,-52,-67,-54,120,-77,-53,-52,-59,-71,-58};
      k_it->vast3 = {-94,-51,-64,-71,120,-85,-63,-56,-63,-60,-108,120,-62,-71,120,-91,-63,-61,-61,-57,120,-85,-71,-50,-57,-60,-71};
      k_it->vast4 = {-84,-63,-59,-57,120,-85,-57,-63,-58,-63,120,-62,-71,120,-88,-67,-58,-52,-52,-63,120,-89,-63,-58,-57,-58,-67,-58};
    }

    if(kountteri == 89) {
      k_it->k_luku = 33;
      k_it->kysym = {110,-118,-115,-115,93,65,-112,-107,-108,-118,-116,-112,-115,-115,-126,65,106,-113,-107,-122,-109,-113,-122,-107,78,-111,-122,-109,-108,-112,-112,-113,-126,65,111,-118,-118,-115,-112,65,113,-126,-126,-108,-118,-105,-118,-109,-107,-126,65,-116,-118,-109,-117,-112,-118,-107,-107,-118,65,-108,-118,-105,-106,-118,-115,-115,-122,-122,-113,65,-111,-126,-116,-118,-113,-112,-118,-107,-126,-126,-113,96};
      k_it->vast1 = {112,-118,-116,-122,-126,-107,65,110,-118,-122,-115,-118,-111,-118,-107,-122,-122,-107};
      k_it->vast2 = {116,-106,-112,-109,-126,-107,65,116,-126,-113,-126,-107};
      k_it->vast3 = {108,-112,-109,-116,-122,-118,-113,65,117,-112,-107,-106,-106,-108};
      k_it->vast4 = {103,-126,-116,-107,-112,-117,-122,-113,65,110,-126,-126,-118,-115,-114,-126};
    }

    if(kountteri == 90) {
      k_it->k_luku = 60;
      k_it->kysym = {-119,-91,-89,120,92,-80,-79,-86,-80,-79,-91,92,-78,-79,-85,-86,-86,-99,92,110,108,109,110,92,-121,-85,-89,-85,-85,-87,-79,-81,-86,-79,-85,-82,-80,-95,-86,92,-78,-99,-82,-99,-84,-79,-92,-95,-95,-86,-90,-85,-92,-80,-99,-90,-99,-86,92,-87,-91,-95,-88,-95,-81,-80,120,92,-85,-86,-93,-95,-88,-87,-99,-88,-88,-91,-81,-95,-88,-80,-99,104,92,-89,-85,-81,-89,-99,92,-81,-95,92,-80,-79,-89,-95,-95,92,94,-92,-95,-91,-89,-85,-87,-87,-99,-86,92,-99,-91,-86,-95,-89,-81,-95,-86,94,92,-88,-91,-81,120,120,-86,-80,-75,-87,-91,-81,-80,120,123};
      k_it->vast1 = {-120,-99,-84,-81,-91,-88,-91,-81,120,-80};
      k_it->vast2 = {-123,-88,-87,-99,-91,-86,-95,-86,92,-84,-95,-82,-79,-81,-89,-85,-79,-88,-79,-80,-79,-81};
      k_it->vast3 = {-123,-81,-75,-75,-81,-78,-99,-84,-99,-99,-80};
      k_it->vast4 = {122,-91,-80,-91,-75,-81,-84,-99,-89,-89,-99,-79,-89,-81,-95,-80};
    }

    if(kountteri == 91) {
      k_it->k_luku = 86;
      k_it->kysym = {-95,-69,-60,-69,-62,-62,-110,118,-55,-69,-53,-56,-73,-73,-52,-65,-55,-54,-73,118,-63,-73,-60,-55,-73,-60,-69,-70,-53,-55,-54,-73,-64,-65,-55,-54,-73,118,-59,-60,118,-54,-59,-70,-69,-54,-54,-53,118,-58,-59,-62,-65,-65,-55,-65,-60,118,-54,-59,-65,-61,-69,-55,-54,-73,118,-63,-59,-56,-63,-69,-65,-60,118,-49,-62,-65,-60,-59,-58,-69,-53,-55,118,-62,-65,-65,-63,-69,-60,-54,-69,-69,-55,-55,-110,-107};
      k_it->vast1 = {-90,-69,-54,-56,-65,118,-87,-73,-62,-59};
      k_it->vast2 = {-93,-73,-56,-65,-73,118,-99,-53,-48,-69,-60,-65,-60,-73};
      k_it->vast3 = {-86,-69,-53,-52,-59,118,-98,-73,-63,-63,-73,-56,-73,-65,-60,-69,-60};
      k_it->vast4 = {-93,-73,-56,-63,-63,-53,118,-101,-69,-55,-54,-65,-62,-110};
      k_it->selitys = {-121,-119,-114,118,-63,-61,-123,-66,118,-60,-59,-58,-69,-53,-55,118,-114,-122,118,-63,-61,-123,-66,118,-73,-62,-53,-69,-69,-62,-62,-73};
    }

    if(kountteri == 92) {
      k_it->k_luku = 63;
      k_it->kysym = {-116,-88,-86,123,95,-82,-85,-88,95,-96,-88,-83,-82,-96,95,-92,-93,-76,-78,-86,-76,-83,-77,-96,-81,-76,-82,-85,-76,-92,107,95,-87,-82,-86,-96,95,-92,-88,95,-75,-76,-82,-83,-83,-96,95,113,111,112,120,95,-82,-77,-77,-96,-83,-76,-77,95,-86,-96,-83,-77,-96,-96,95,-86,-96,-83,-78,-96,-85,-96,-88,-78,-96,-85,-82,-88,-77,-77,-92,-92,-78,-92,-92,-83,95,-86,-96,-83,-83,-96,-95,-88,-86,-78,-92,-83,95,-86,123,-72,-77,-100,-83,95,-79,-96,-83,-90,-96,-88,-78,-77,-96,-75,-76,-76,-93,-92,-83,95,-81,-82,-88,-78,-77,-96,-84,-88,-78,-92,-86,-78,-88,126};
      k_it->vast1 = {-107,-96,-78,-92,-84,-84,-88,-78,-77,-82,-85,-88,-88,-77,-77,-82};
      k_it->vast2 = {-107,-88,-89,-79,-92,123,-77};
      k_it->vast3 = {-118,-92,-78,-86,-76,-78,-77,-96};
      k_it->vast4 = {-110,-125,-113};
    }

    if(kountteri == 93) {
      k_it->k_luku = 40;
      k_it->kysym = {117,-111,-109,100,72,-107,-119,-100,-109,-119,-104,-119,-112,-105,-111,-106,-98,-105,-111,-106,-100,-111,-111,-106,72,-107,-95,-95,-100,100,-98,100,72,-108,100,100,-109,-115,72,-101,-111,-101,100,-108,-100,100,100,72,-112,-119,-108,-108,-99,-101,-111,-106,-119,-119,-100,-111,-105,-111,-100,-119,72,-110,-119,72,-112,-95,-98,100,-106,-105,-108,-105,-106,-100,-99,-106,-106,-115,-100,-100,-119,72,-119,-111,-112,-115,-99,-100,-100,-119,-98,-119,-119,72,-101,-95,-109,-108,-111,-100,-101,-111,-111,-106,-111,100,103};
      k_it->vast1 = {117,-119,-102,-94,-111,-106,-115};
      k_it->vast2 = {105,-100,-119,-102,-119,-96};
      k_it->vast3 = {116,-115,-102,-113,-111,-113,-119,-106};
      k_it->vast4 = {123,-115,-102,-115,-106,-119,-101,-115};
    }

    if(kountteri == 94) {
      k_it->k_luku = 18;
      k_it->kysym = {95,123,126,126,78,50,115,126,125,-127,122,-127,126,123,124,-121,-127,127,115,126,126,115,50,-127,-128,50,119,-124,123,-122,-117,123,-123,115,-123,119,127,115,50,127,119,-122,115,126,126,123,-117,122,-122,-117,119,50,100,-117,-122,127,123,122,78,123,-124,123,111,-128,50,125,115,-126,-126,115,126,119,123,118,119,-128,50,-123,115,-128,-127,123,-122,-121,125,-123,123,-123,-123,115,81};
      k_it->vast1 = {89,115,127,116,123,-128,115};
      k_it->vast2 = {85,115,127,-126,115,-124,123};
      k_it->vast3 = {84,-121,118,-119,119,123,-123,119,-124};
      k_it->vast4 = {101,127,123,-124,-128,-127,120,120};
    }

    if(kountteri == 95) {
      k_it->k_luku = 63;
      k_it->kysym = {-116,-88,-78,-77,123,95,-84,-96,-96,-78,-77,-96,95,-110,-76,-83,-83,-72,95,-126,-96,-79,95,-126,-92,-83,-77,-92,-79,-88,-83,95,-82,-85,-88,95,-77,-96,-79,-86,-82,-88,-77,-76,-78,95,-78,-96,-96,-93,-96,95,-79,-96,-89,-82,-88,-77,-76,-78,-77,-96,126};
      k_it->vast1 = {-110,-96,-84,-95,-88,-96};
      k_it->vast2 = {-118,-88,-88,-83,-96};
      k_it->vast3 = {-115,-88,-90,-92,-79,-88,-96};
      k_it->vast4 = {-110,-96,-76,-93,-88,108,-128,-79,-96,-95,-88,-96};
      k_it->selitys = {-110,-96,-84,-95,-88,-96,-85,-96,-88,-83,-92,-83,95,-79,-96,-89,-82,-88,-77,-77,-96,-87,-96,95,-82,-78,-82,-88,-77,-77,-96,-76,-77,-76,-88,95,-83,-92,-77,-77,-88,-89,-76,-88,-87,-96,-79,-88,-86,-78,-88};
    }

    if(kountteri == 96) {
      k_it->k_luku = 25;
      k_it->kysym = {102,-126,-115,85,57,108,-114,-121,-121,-110,57,92,122,-117,57,92,126,-121,-115,126,-117,-126,-121,57,-120,-123,-126,57,-115,122,-117,-124,-120,-126,-115,-114,-116,57,-120,-123,-123,122,88};
      k_it->vast1 = {94,-114,-117,-120,-120,-119,122,-121,57,-116,-114,-114,-117,-126,-121,57,122,-114,-115,-120,-124,122,-114,-119,-119,122};
      k_it->vast2 = {102,122,122,-126,-123,-122,122,-121,57,-116,-114,-114,-117,-126,-121,57,122,-114,-115,-120,-124,122,-114,-119,-119,122};
      k_it->vast3 = {105,-120,-127,-125,-120,-126,-116,-122,122,-126,125,126,-121,57,-116,-114,-114,-117,-126,-121,57,122,-114,-115,-120,-124,122,-114,-119,-119,122};
      k_it->vast4 = {108,-114,-120,-122,126,-121,57,-116,-114,-114,-117,-126,-121,57,122,-114,-115,-120,-124,122,-114,-119,-119,122};
      k_it->selitys = {90,-123,-124,-114,-119,126,-117,85,-126,-116,126,-116,-116,85,57,-116,-114,-114,-121,-121,-126,-115,126,-123,-122,122,-116,-116,122,57,-120,-123,-126,57,-124,122,-127,125,126,-124,-116,122,-121,57,-124,126,-117,-117,-120,-116,-115,122};
    }

    if(kountteri == 97) {
      k_it->k_luku = 77;
      k_it->kysym = {-102,-74,-63,-119,109,-64,-78,-62,-65,-82,-82,-61,-74,-64,-63,-82,109,-73,-119,-119,-72,-74,-78,-72,-72,-68,-73,-68,-62,-72,-72,-62,-78,-74,-64,-63,-82,109,-96,-62,-69,-69,-58,109,-112,-82,-65,109,-112,-78,-69,-63,-78,-65,109,-78,-74,109,-64,-67,-68,-69,-64,-68,-65,-68,-74,-69,-62,-63,-116};
      k_it->vast1 = {-95,-82,-67,-67,-82,-65,-82};
      k_it->vast2 = {-106,-71,-61,-78,-64};
      k_it->vast3 = {-105,-68,-72,-78,-65,-74,-63};
      k_it->vast4 = {-107,-99,-104};
    }

    if(kountteri == 98) {
      k_it->k_luku = 42;
      k_it->kysym = {117,-97,-107,-117,74,-99,-97,-103,-105,-117,-106,-117,-109,-104,-113,-104,74,-102,-103,-106,-109,-109,-99,-109,74,-98,-97,-104,-104,-113,-98,-109,-109,-104,74,-99,-103,-99,-109,-117,-117,-106,-109,-99,-113,-99,-99,-117,74,-105,-113,-114,-109,-117,-99,-99,-117,74,-98,-103,-109,-105,-109,-104,-113,-113,-104,-117,74,-104,-113,-98,-98,-109,-102,-103,-106,-109,-109,-99,-109,-104,-117,105};
      k_it->vast1 = {119,-117,-100,-107,-103,74,112,-103,-100,-99,-99};
      k_it->vast2 = {126,-103,-105,74,122,-117,-115,-107,-117,-106,78,-104};
      k_it->vast3 = {119,-109,-107,-107,-103,74,122,-117,-117,-98,-113,-100,-103};
      k_it->vast4 = {126,-110,-103,-105,-117,-99,74,111,-106,-112,-111,-100,-113,-104};
      k_it->selitys = {118,-113,-105,-102,-109,-104,-109,-105,-113,-106,-98,102,102,-104,74,112,-103,-116,-116,-117};
    }

    if(kountteri == 99) {
      k_it->k_luku = 69;
      k_it->kysym = {-110,-82,-80,-127,101,-72,-70,-76,-78,-90,-79,-90,-82,-77,-86,-77,101,-89,-79,-90,-88,-80,101,-78,-86,-71,-90,-79,101,114,-66,-83,-71,-66,-86,101,-72,-90,-82,101,-83,-70,-76,-78,-82,-76,-71,-90,101,-86,-72,-82,-82,-77,-77,-66,-71,-71,-66,-127,-127,-77,101,-75,-127,-82,-83,-71,-66,-77,-86,-86,-77,-127,101,-104,-71,-86,-86,-79,-85,-86,-72,-71,101,114,-85,-86,-72,-71,-82,-69,-90,-90,-79,-86,-82,-79,-79,-90,101,-69,-70,-76,-77,-77,-90,101,119,117,118,124,-124};
      k_it->vast1 = {-122,-65,-90,-65,-86,-79};
      k_it->vast2 = {-122,-77,-90,-79,101,-121,-79,-90,-72,-75,-83,-86,-78,-66};
      k_it->vast3 = {-121,-86,-83,-86,-73,-82,-71};
      k_it->vast4 = {-121,-90,-73,-90,-71,-83,-73,-70,-78};
    }

    if(kountteri == 100) {
      k_it->k_luku = 46;
      k_it->kysym = {121,-93,-103,-113,78,-96,-113,-98,91,-113,-96,-94,-105,-95,-94,-105,78,-113,-100,-94,-99,-105,78,-92,-113,-102,-99,-103,-93,-92,-113,-102,-102,-113,-113,-100,78,-103,-113,-95,-92,-99,-94,78,120,-99,-100,-100,-109,91,-101,-109,-109,-101,-105,-102,-102,-109,109};
      k_it->vast1 = {111,-94,-94,-109,78,-126,-99,-105,-103,-103,-113};
      k_it->vast2 = {125,-94,-94,-99,78,121,-113,-102,-102,-105,-99,-105,-100,-109,-100};
      k_it->vast3 = {120,-113,-100,-100,-109,78,-124,-113,-103,-103,-105,-102,-113,-105,-100,-109,-100};
      k_it->vast4 = {-127,-113,-101,-105,78,118,-109,-102,-102,-109};
    }

    if(kountteri == 101) {
      k_it->k_luku = 48;
      k_it->kysym = {125,-103,-101,108,80,-97,-103,-94,-107,-87,-104,-92,-87,-99,108,80,-90,-111,-103,-90,-111,-111,80,-93,-91,-97,-93,-103,-92,-92,-91,-102,-111,80,-119,-97,-91,-124,-91,-110,-107,93,-90,-103,-108,-107,-97,-103,-92,-111,80,-92,-107,-104,-98,-87,-92,-92,108,80,-123,-98,-109,-100,-107,-125,-111,-99,-128,-111,-92,-94,-103,-97,-92,-103,-111,111};
      k_it->vast1 = {-124,-97,-91,-94,-107,-92,-92,-107,-98,80,-97,-103,-94,-107,-87,-104,-92,-87,-99,108};
      k_it->vast2 = {116,-97,-89,-98,-103,-98,80,-97,-103,-94,-107,-87,-104,-92,-87,-99,108};
      k_it->vast3 = {-128,-97,-104,-102,-97,-103,-98,-107,-98,80,-107,-96,-103,-100,-107,-96,-93,-103,-111};
      k_it->vast4 = {-128,-111,-100,-100,-103,-93,-92,-107,-94,93,123,-103,-100,-100,-103,-111,-98,-103,-98,80,-97,-103,-94,-107,-87,-104,-92,-87,-99,108};
    }

    if(kountteri == 102) {
      k_it->k_luku = 92;
      k_it->kysym = {-87,-59,-54,-57,-104,124,-47,-50,-60,-63,-59,-56,-47,-56,-67,-58,-59,-54,124,-60,-67,-50,-50,-67,-49,-48,-67,-58,-67,-54,-67,124,-49,-47,-53,-49,-59,-48,-48,-47,-58,-67,124,-75,-53,-47,-80,-47,-66,-63,-119,-46,-59,-64,-63,-53,-59,-48,-67,124,-48,-63,-60,-54,-43,-48,124,-79,-54,-65,-56,-63,-81,-67,-55,-84,-67,-48,-50,-59,-53,-48,124,-48,-47,-54,-54,-63,-48,-67,-67,-54,-101};
      k_it->vast1 = {-86,-43,-50,-57,-57,-63,-59,-56,-43};
      k_it->vast2 = {-84,-67,-59,-54,-59};
      k_it->vast3 = {-80,-67,-63,-57,-45,-53,-54,-64,-53};
      k_it->vast4 = {-90,-47,-64,-53};
    }

    if(kountteri == 103) {
      k_it->k_luku = 19;
      k_it->kysym = {96,124,-121,79,51,-121,124,120,-121,-126,126,-126,-127,120,-125,120,127,124,79,51,125,-126,-127,-127,120,125,120,-127,51,-126,-127,51,-120,-122,126,-126,-121,-121,-120,51,-125,120,127,116,116,-119,116,-127,82};
      k_it->vast1 = {86,-126,-120,-127,-121,120,-123,64,102,-121,-123,124,126,120};
      k_it->vast2 = {101,116,124,-127,117,-126,-118,51,102,124,-117};
      k_it->vast3 = {86,116,127,127,51,-126,121,51,87,-120,-121,-116};
      k_it->vast4 = {102,116,-127,-123,124,-126,51,86,116,-123,-127,124,-119,116,127};
    }

    if(kountteri == 104) {
      k_it->k_luku = 23;
      k_it->kysym = {100,-128,-118,-117,83,55,-117,124,-122,-126,-118,124,-118,-117,120,55,-122,-117,124,-117,-117,-116,55,-126,120,-121,-121,120,-125,124,55,-118,-122,-128,55,96,-123,-117,124,-119,-123,124,-117,68,-124,124,124,-124,-128,-126,-118,-128,55,-124,-116,-122,123,-122,-118,-117,-116,-123,124,124,-123,55,107,-122,-123,-123,-128,-123,55,-118,124,-117,124,-125,-128,55,68,-118,-126,124,-117,-118,-128,-123,55,-117,120,-116,-118,-117,120,-125,-125,120,86};
      k_it->vast1 = {106,120,-128,-123,-117,68,106,120,87,-123,-118,55,68,55,92,-125,83,-128,-123,-117,124,-123,55,-126,120,-119,-123,124,-115,120,120,-125,-128};
      k_it->vast2 = {89,-119,120,127,-124,-118,55,68,55,106,124,-125,-125,-122,-118,-122,-123,120,120,-117,-117,-128,55,-123,-119,69,55,72};
      k_it->vast3 = {107,-118,127,120,-128,-126,-122,-115,-118,-126,-128,55,68,55,97,-122,-116,-117,-118,124,-123,-125,120,-124,-121,-128};
      k_it->vast4 = {91,124,121,-116,-118,-118,-112,55,68,55,99,120,-118,-117,124,-123,-123,-116,-119,-126,-126,120,-116,-118};
      k_it->selitys = {107,124,-122,-126,-118,124,-123,55,-122,-118,120,55,72,74,67,55,97,-122,-116,-117,-118,124,-123};
    }

    if(kountteri == 105) {
      k_it->k_luku = 47;
      k_it->kysym = {124,-104,-93,107,79,-98,-94,-93,-108,-93,-112,-112,-99,79,120,-99,-93,-108,-95,-99,-108,-93,92,-100,-108,-108,-100,-104,-102,-94,-104,79,-100,-92,-98,-109,-98,-94,-93,-92,-99,-108,-108,-94,-94,-112,79,-125,-98,-99,-99,-104,-99,79,-94,-108,-93,-108,-101,-104,79,92,-94,-102,-108,-93,-94,-104,-94,-94,107,110};
      k_it->vast1 = {122,-112,-105,-91,-104,79,-103,-112,79,-91,-98,-105,-91,-108,-101,-104};
      k_it->vast2 = {124,-108,-105,-92,79,-103,-112,79,-97,-92,-101,-101,-112};
      k_it->vast3 = {-125,-108,-108,-93,107,79,-103,-112,79,-102,-112,-102,-102,-92,-112};
      k_it->vast4 = {119,-104,-104,-91,-112,-112,79,-103,-112,79,-94,-98,-102,-108,-95,-104,-112};
      k_it->luk4 = true;
    }

    if(kountteri == 106) {
      k_it->k_luku = 19;
      k_it->kysym = {94,-120,126,116,51,-122,120,-120,-123,116,116,-119,124,-122,-121,116,51,-123,116,-121,-121,124,125,-120,-126,-125,-120,-128,-120,126,-122,120,-122,-121,116,51,-121,-120,-126,-128,124,-121,-120,124,-122,-121,116,51,126,116,-127,-122,116,-127,120,119,-120,-122,-121,116,125,124,-122,-121,116,51,-125,-120,123,116,127,-122,124,51,126,-126,-123,126,120,124,-128,-128,116,-121,51,-125,-123,-126,-128,124,127,127,120,127,-120,126,120,-128,116,-121,82,51,59,94,-126,-123,126,120,124,-128,-128,116,-121,63,51,-128,124,-121,79,51,-121,124,120,119,79,-128,-128,120,51,126,116,-127,-122,116,-127,120,119,-120,-122,-121,116,125,116,-127,51,126,-126,-122,126,116,116,-127,51,-125,-120,123,116,127,-121,116,-127,120,120,-127,60};
      k_it->vast1 = {105,120,124,126,126,-126,51,93,65,51,101,-116,-121,126,112,-127,120,-127};
      k_it->vast2 = {102,124,127,-119,124,116,51,96,-126,119,124,122};
      k_it->vast3 = {104,-127,-121,-126,51,105,116,127,-125,116,-122};
      k_it->vast4 = {103,116,-127,125,116,51,94,116,-123,-125,120,127,116};
      k_it->selitys = {68,63,74,51,-125,-123,-126,-128,124,127,127,120,116,51,-119,-120,-126,-127,-127,116,51,68,76,75,70,51,101,116,-120,-121,116,-119,116,116,-123,116,127,127,116,63,51,102,87,94,95,77,-127,51,120,119,-120,-122,-121,116,125,116};
    }

    if(kountteri == 107) {
      k_it->k_luku = 9;
      k_it->kysym = {86,114,117,117,69,41,106,124,110,110,117,117,106,41,116,120,125,116,106,117,106,114,119,110,119,41,86,114,116,106,41,86,126,123,106,119,110,119,41,124,126,120,123,114,125,125,114,41,116,106,116,124,114,41,113,126,113,125,114,116,126,126,124,124,106,41,58,66,66,61,41,125,110,116,110,118,69,124,125,69,69,119,41,116,120,117,118,110,124,125,106,41,124,126,123,118,106,124,125,106,72};
      k_it->vast1 = {83,106,117,116,106,115,120,126,124,110,117,117,106};
      k_it->vast2 = {81,114,117,121,106,123,114,117,117,106};
      k_it->vast3 = {95,114,121,126,116,110,114,113,69,69,117,117,69};
      k_it->vast4 = {89,110,123,113,120,124,127,110,114,125,124,110,117,117,69};
    }

    if(kountteri == 108) {
      k_it->k_luku = 47;
      k_it->kysym = {124,-104,-102,107,79,-98,-101,-104,79,-102,-98,-101,-100,-108,79,-104,-105,-100,-104,-94,-93,107,79,122,-98,-93,-102,-112,-94,-94,-112,79,-91,-92,-98,-99,-99,-112,79,96,104,104,99,79,-94,-92,-95,-100,-112,-99,-99,-108,-108,-99,79,124,-104,-102,-112,79,124,-92,-95,-112,-94,-108,-99,79,-93,-108,-98,-99,79,-100,-98,-93,-104,-104,-91,-104,110};
      k_it->vast1 = {125,-112,-112,-97,-92,-95,-104,-95,-104,-104,-109,-112,-93};
      k_it->vast2 = {109,-102,-104,-101,-101,-104,-99,-108,-99,79,-97,107,107,-105,107,-99,-97,-104,-94,-93,-98};
      k_it->vast3 = {120,-105,-100,-104,-94,-91,-104,-105,-112};
      k_it->vast4 = {-126,-102,-104,-93,-94,-98,-107,-95,-108,-99,-104,-94,-108,-93,79,-105,-112,-95,-105,-112,-93};
    }

    if(kountteri == 109) {
      k_it->k_luku = 41;
      k_it->kysym = {118,-110,-108,101,73,-104,-107,-110,73,110,-100,-103,-104,-104,-105,73,-108,-118,-98,-103,-103,-118,-108,-114,-100,-108,-98,-100,73,124,-114,-107,-107,-104,-105,73,-98,-98,-115,-114,-105,-97,-98,-104,-115,-114,-105,-118,-118,-99,-104,-105,73,91,89,89,98,73,-118,-106,-103,-98,-106,-118,-97,101,-107,-110,-108,-104,-111,-99,-118,-98,-108,-100,-114,-105,73,-99,-114,-108,-110,-109,101,-105,73,-104,-107,-114,-99,-114,-99,-99,-98,73,-106,-104,-99,-110,-110,-97,-110,104};
      k_it->vast1 = {114,-111,-106,-110,-100,-100,-98,-111,-115,-114,-104,-105,-112,-114,-107,-106,-118,-99};
      k_it->vast2 = {103,101,-101,-110,-98,-100,-108,-104,-105,-105,-104,-107,-107,-110,-100,-98,-98,-100};
      k_it->vast3 = {124,-108,-110,-99,-100,-104,-113,-101,-114,-105,-110,-100,-114,-99,73,-111,-118,-101,-111,-118,-99};
      k_it->vast4 = {113,-98,-98,-106,-114,-101,-110,-110,-115,-118,-99};
    }

    if(kountteri == 110) {
      k_it->k_luku = 71;
      k_it->kysym = {-108,-80,-77,-77,-74,-80,-75,103,-78,-68,-71,-80,-69,-68,-70,-81,-68,-74,-75,-84,-84,-78,-70,-80,103,-78,-68,-69,-70,-68,-69,-68,-75,103,-71,-88,-75,-82,-88,-80,-70,-69,-68,-70,-76,-68,-74,-85,-74,-75,103,-78,-125,-64,-69,-69,-92,103,-77,-74,-73,-84,-69,-84,-69,-69,-80,-80,-75,103,-102,-68,-74,-76,-84,-70,-70,-88,-122};
      k_it->vast1 = {120,-128,126,124};
      k_it->vast2 = {120,-128,124,124};
      k_it->vast3 = {120,-128,125,124};
      k_it->vast4 = {120,-128,127,124};
    }

    if(kountteri == 111) {
      k_it->k_luku = 18;
      k_it->kysym = {93,-121,125,115,50,-127,122,124,115,-123,123,50,52,122,-121,-121,127,119,127,-117,111,-128,-122,119,123,-123,-117,-117,118,119,-128,52,50,-120,-121,-127,125,-123,123,50,126,115,-126,-123,123,126,-122,115,50,124,115,50,-128,-121,-127,-124,123,126,-122,115,50,125,123,119,126,126,119,-122,-117,-128,50,118,-127,125,-121,127,119,-128,-122,-122,123,120,123,126,127,123,-128,50,52,100,119,123,-128,118,119,119,-124,-123,-126,-127,-122,-122,123,-128,121,50,63,50,-126,115,125,-127,50,124,-127,-121,126,-121,127,115,115,-123,-122,115,52,81};
      k_it->vast1 = {92,-127,-127,-128,115,-123,50,96,119,-121,-120,-127,-128,119,-128};
      k_it->vast2 = {102,123,127,-127,50,93,-127,123,-120,-121,-123,115,126,-127};
      k_it->vast3 = {102,-121,-121,125,125,115,50,102,119,127,-127,-128,119,-128};
      k_it->vast4 = {102,123,127,-127,50,104,-121,-127,-124,119,-128,-123,-127,126,115};
    }

    if(kountteri == 112) {
      k_it->k_luku = 85;
      k_it->kysym = {-94,-66,-55,-111,117,-67,-54,-54,-62,-74,-54,-56,-74,-66,-61,-70,-55,-55,-74,117,-89,-70,-66,-61,-71,-70,-70,-57,-56,-59,-60,-55,-55,-66,-61,-68,117,-126,-70,-63,-60,-64,-54,-53,-74,-56,-56,-74,117,-63,-111,-67,-71,-70,-55,-111,-111,-61,117,-67,-74,-64,-70,-62,-74,-74,-61,117,-91,-74,-57,-66,-66,-56,-66,-56,-55,-74,117,-74,-56,-55,-66,-108};
      k_it->vast1 = {-105,-54,-59,-57,-70,-61,-60,-57,-69,-66,-66,-61,-66};
      k_it->vast2 = {-87,-70,-73,-74,-66,-66,-61,-66};
      k_it->vast3 = {-94,-70,-56,-64,-74,-63,-66,-66,-61,-66};
      k_it->vast4 = {-94,-70,-55,-74,-71,-60,-61,-66};
      k_it->selitys = {-87,-54,-60,-55,-70,-61,-66,-62,-70,-63,-55,-111,-111,-61,117,-88,-54,-73,-54,-55,-70,-51};
    }

    if(kountteri == 113) {
      k_it->k_luku = 32;
      k_it->kysym = {107,-107,-117,-127,64,-120,-127,-107,-109,-117,-107,-107,-108,-108,-119,64,105,-114,-108,-123,-110,-114,-123,-108,-119,-114,64,-117,92,-103,-108,-108,92,-118,-119,92,64,-103,-117,-109,-119,-108,-103,-119,-109,-117,-113,-120,-108,-127,-119,-109,-123,-116,-116,-127,64,-116,-107,-117,-119,-113,-116,-127,-119,-109,-108,-123,-114,64,109,97,111,108,77,-108,-127,-107,-116,-107,-117,-117,-113,-117,-119,-110,-118,-127,-114,64,-108,-123,-117,-109,-108,-119,-127,-109,-107,-127,64,-117,-113,-109,-117,-123,-106,-127,-116,-116,-127,64,-117,-110,-119,-108,-119,-119,-117,-119,-116,-116,92,92,-114,95};
      k_it->vast1 = {106,-107,-117,-117,-127,64,107,-113,-110,-112,-123,-116,-127};
      k_it->vast2 = {110,-119,-119,-116,-113,64,112,-127,-127,-109,-119,-106,-119,-110,-108,-127};
      k_it->vast3 = {106,-107,-120,-127,-112,-123,-117,-117,-127,64,116,-113,-116,-106,-127,-114,-123,-114};
      k_it->vast4 = {112,-123,-108,-108,-123,-110,-119,64,106,92,-110,-106,-119,-114,-123,-114};
    }

    if(kountteri == 114) {
      k_it->k_luku = 60;
      k_it->kysym = {-119,-91,-86,120,92,-78,-79,-85,-86,-86,-99,92,-123,-114,127,105,-93,-99,-88,-88,-95,-82,-91,-99,92,-99,-78,-99,-79,-80,-79,-91,123};
      k_it->vast1 = {110,108,108,108};
      k_it->vast2 = {109,117,117,113};
      k_it->vast3 = {110,108,108,113};
      k_it->vast4 = {110,108,109,108};
    }

    if(kountteri == 115) {
      k_it->k_luku = 57;
      k_it->kysym = {-124,-82,-92,-102,89,-84,-98,-82,-85,-102,-102,-81,-94,-84,-83,-102,89,-92,-102,-89,-84,-102,-89,-98,-99,-82,-84,-83,-102,-93,-94,-84,-83,-102,89,-88,-89,89,-83,-82,-88,-90,-94,-83,-83,-82,89,-93,-82,-91,-92,-94,-84,-85,-102,-82,-95,-102,-89,89,-85,-94,-92,-92,-88,-90,-94,-84,-98,-84,-83,-102,120};
      k_it->vast1 = {-119,-102,-102,-81,-88,89,122,-85,-95,-94,-89,-90,117,-92,-94};
      k_it->vast2 = {-120,-84,-90,-88,89,-116,-88,-94,-89,-94,-89,-81,-102,-102,-85,-102};
      k_it->vast3 = {-115,-98,-82,-81,-88,89,-127,-102,-92,-92,-102,-85,-102,-94,-89,-98,-89};
      k_it->vast4 = {-115,-94,-90,-88,89,-127,-102,-85,-102,-92,-92,-102};
      k_it->selitys = {-115,-98,-92,-88,89,-91,-94,-94,-83,-83,-78,-94,89,-120,-91,-92,-94,-91,-82,-88,-99,-88,-89,89,-78,-99,-94,-89,-81,-88,-94,-90,-102,-91,-102,-89,89,-102,-91,-82,-98,-98,-91,-91,-102,89,-87,-94,-99,-98,-83,-83,-78,-78,-89,89,-90,-94,-98,-91,-98,-89,-88,-84,-88,-94,-83,-82,-92,-84,-98,-98,-89};
    }

    if(kountteri == 116) {
      k_it->k_luku = 29;
      k_it->kysym = {106,-122,-120,89,61,-116,-119,-122,61,101,-106,-109,-122,-117,-120,89,89,-117,61,-109,-110,-116,-127,-126,-117,61,79,77,78,79,61,-120,126,-120,-112,-122,61,-122,-123,-118,-122,-112,-111,89,61,-111,126,-115,-115,126,-117,-126,-126,-117,61,-121,126,61,-112,-126,-122,-111,-112,-126,-118,89,89,61,-123,126,126,-109,-116,-122,-111,-111,126,-117,-126,-126,-117,61,-120,-122,-109,89,89,-113,-122,126,-118,-118,-110,-112,-120,-126,-119,-122,-121,126,-117,61,-111,-126,-116,-117,61,-112,-106,-106,92};
      k_it->vast1 = {109,126,-122,-117,-122,-116,-111,-111,-126,-119,-110,-117,61,-123,89,-109,-122,89,-118,-122,-112,-126,-112,-111,89,61,126,-119,-120,126,-117,-126,-126,-111,61,126,-124,-124,-113,-126,-112,-112,-122,-116,-111};
      k_it->vast2 = {109,126,-113,-120,-120,-122,-112,126,-120,-116,-117,61,-112,126,126,-118,-122,-112,-126,-112,-111,126,61,126,-119,-120,126,-117,-126,-126,-111,61,126,-124,-124,-113,-126,-112,-112,-122,-116,-111};
      k_it->vast3 = {109,89,89,-117,61,-112,-122,-112,89,-119,-111,89,61,-120,-110,-110,-119,-110,-117,-126,-122,-127,-126,-117,61,89,89,-117,-122,-126,-117,61,-111,-116,-111,-111,-126,-119,-126,-118,-122,-117,-126,-117};
      k_it->vast4 = {99,126,-128,-126,127,-116,-116,-120,-122,-112,-112,126,61,126,-117,-117,-126,-111,-111,-110,-121,-126,-117,61,-120,89,-112,-120,-106,-121,-126,-117,61,-111,-116,-111,-111,-126,-119,-126,-118,-122,-117,-126,-117};
    }

    if(kountteri == 117) {
      k_it->k_luku = 80;
      k_it->kysym = {-99,-71,-61,-60,-116,112,-61,-79,-60,-59,-72,-79,-72,-67,-65,-61,-60,-79,112,-69,-75,-62,-60,-65,-71,112,-101,-71,-58,-71,-66,-65,-69,-79,-66,112,-69,-75,-61,-116,-60,-75,-79,-60,-60,-75,-62,-71,-66,112,-66,-116,-55,-60,-75,-68,-67,-116,124,112,-70,-65,-69,-79,112,-61,-59,-59,-60,-59,-60,-60,-71,112,-101,-62,-71,-61,-60,-79,-68,-68,-71,-64,-59,-65,-68,-59,-75,-75,-66,112,-70,-116,-61,-75,-66,-75,-60,112,-62,-65,-69,-65,-60,-75,-67,-55,-83,-66,-60,-75,-71,-61,-55,-55,-76,-75,-68,-68,-116,-116,-66,-113};
      k_it->vast1 = {-91,-64,-64,-65,125,-98,-79,-68,-68,-75};
      k_it->vast2 = {-96,-59,-64,-59,112,-92,-59,-64,-59,-66,-79};
      k_it->vast3 = {-94,-71,-61,-60,-65,112,-94,-116,-64,-64,-116,-116,-70,-116};
      k_it->vast4 = {-90,-79,-79,-72,-60,-75,-62,-79,-67,-116,-75,-66,112,-107,-75,-67,-75,-68,-71};
    }

    if(kountteri == 118) {
      k_it->k_luku = 58;
      k_it->kysym = {-121,-93,-82,118,90,-89,-81,-83,-93,-93,-91,-93,-88,-82,-77,-77,-90,-93,118,90,123,-76,-101,-76,-97,-90,90,103,-77,-94,-82,-77,-97,-97,-88,90,-122,-87,-84,-98,90,-115,-101,-82,-101,-88,-101,-99,-94,-93,-101,90,-93,-90,-89,-87,-93,-82,-82,-93,90,-80,-93,-94,-101,-101,-80,-101,-88,-83,-101,90,-98,-87,-91,-81,-89,-97,-88,-82,-82,-93,-96,-93,-90,-89,-93,-83,-83,118,90,-122,-87,-86,-81,-82,-87,-88,90,-127,-97,-94,-97,-88,-88,-101,-88,90,-122,-93,-97,-91,-91,-93,121};
      k_it->vast1 = {-118,-81,-88,-91};
      k_it->vast2 = {-116,-97,-95,-95,-101,-97};
      k_it->vast3 = {-112,-101,-86,-87,-84,-79,-101,-80,-97};
      k_it->vast4 = {-120,-81,90,-89,-97,-82,-101,-90};
    }

    if(kountteri == 119) {
      k_it->k_luku = 69;
      k_it->kysym = {-112,-70,-80,-90,101,-72,-86,-70,-73,-90,-90,-69,-82,-72,-71,-90,101,-86,-82,101,-76,-79,-79,-70,-71,101,-98,-94,-79,-82,-77,-81,-90,101,114,-73,-90,-87,-82,-76,114,-76,-83,-81,-86,-79,-78,-90,-77,101,-69,-90,-80,-82,-76,-72,-76,-82,-71,-71,-90,-81,-90,-124};
      k_it->vast1 = {-122,-83,-79,-74,-69,-82,-72,-71,101,-105,-90,-70,-78,-90,-79,-71,-90};
      k_it->vast2 = {-107,-86,-71,-73,-82,101,-122,-77,-81,-90,-79,-90,-77,-80,-76,-72,-80,-86,-79,-71,-90};
      k_it->vast3 = {-105,-90,-77,-72,-71,-90,-80,-90,-77,101,-82,-72,-127,-77,-71,-127};
      k_it->vast4 = {-112,-79,-70,-77,-72,-72,-82,-79,-90,101,-105,-76,-69,-90,-77,-82,-86,-78,-86,-79,-71,-127};
    }

    if(kountteri == 120) {
      k_it->k_luku = 65;
      k_it->kysym = {-114,-86,-81,125,97,-73,-74,-80,-81,-81,-94,97,-102,-98,-83,-86,-81,-85,-94,97,110,-77,-94,-91,-86,-80,110,-80,-87,-85,-90,-83,-82,-94,-81,97,-76,125,125,-81,-81,-98,-83,-83,-86,-76,-90,-75,97,-83,125,-87,-90,-75,-70,-84,-76,-90,-75,97,-83,-80,-79,-79,-74,-86,-73,-94,-75,-128};
      k_it->vast1 = {115,113,113,115};
      k_it->vast2 = {114,122,122,120};
      k_it->vast3 = {115,113,113,118};
      k_it->vast4 = {115,113,113,122};
    }

    if(kountteri == 121) {
      k_it->k_luku = 18;
      k_it->kysym = {95,123,-128,125,78,50,-124,115,118,123,-127,125,115,-128,115,-120,115,-128,50,-127,122,124,119,126,127,123,-123,-122,-127,-127,-128,50,107,111,126,123,-128,124,115,50,63,-127,122,124,119,126,127,115,50,125,-121,-121,126,-121,123,50,-120,123,123,127,119,123,-123,119,-122,50,-120,123,123,-123,123,50,-120,-121,-127,-122,-122,115,115,-128,81};
      k_it->vast1 = {100,115,118,123,-127,50,101,-121,-127,127,123};
      k_it->vast2 = {100,115,118,123,-127,50,85,123,-122,-117};
      k_it->vast3 = {93,123,-123,-123,50,88,95};
      k_it->vast4 = {100,115,118,123,-127,50,95,115,120,123,115};
      k_it->selitys = {83,126,-121,-128,50,-126,119,-124,123,-128,50,100,115,118,123,-127,50,85,123,-122,-117,-128,50,-127,122,124,119,126,127,115};
    }

    if(kountteri == 122) {
      k_it->k_luku = 8;
      k_it->kysym = {97,84,77,118,40,85,87,92,53,119,112,114,109,116,117,105,118,40,117,109,124,105,116,116,113,117,125,123,113,113,115,115,113,105,40,114,105,40,123,105,105,124,105,118,105,118,120,105,116,126,119,118,124,105,105,40,115,68,123,113,124,124,109,116,109,126,68,123,123,68,40,114,105,115,123,119,123,123,105,40,115,105,125,112,113,123,124,109,116,124,113,113,118,40,115,105,120,120,105,116,109,109,118,40,42,94,113,124,125,124,125,115,123,109,118,40,117,125,116,124,113,112,125,113,120,109,118,118,125,123,42,40,123,105,118,119,113,124,125,115,123,113,105,54,40,85,113,115,68,40,-127,112,124,-127,109,40,109,123,113,124,124,113,40,115,-127,123,109,113,123,109,118,40,115,105,120,120,105,116,109,109,118,71};
      k_it->vast1 = {81,117,120,105,116,109,108,40,86,105,-126,105,122,109,118,109};
      k_it->vast2 = {83,-127,-127,122,113,105};
      k_it->vast3 = {74,109,112,109,122,113,124};
      k_it->vast4 = {80,119,122,118,105};
    }

    if(kountteri == 123) {
      k_it->k_luku = 28;
      k_it->kysym = {105,-123,-121,88,60,-117,-116,-116,-123,60,-117,-120,-123,60,-121,-127,-113,-121,-127,-123,-113,-127,-113,-113,88,60,125,-113,-127,-119,125,-113,-113,125,60,-110,-111,-117,-113,-123,-118,125,60,77,85,85,80,73,78,76,76,77,60,-112,-117,-123,-119,-123,-118,-127,-127,-118,60,104,-111,-117,-118,-118,-117,-118,-120,125,-123,-118,60,-116,-111,-117,-120,-111,-127,-127,-118,60,125,125,-112,-127,-119,125,125,-123,-120,-119,125,-113,-113,125,91};
      k_it->vast1 = {112,-114,125,-118,-113,-113,-127,-118,-128,-127,-118,-112,-112,-123,-118,-127,-118,60,-119,-127,-128,-123,-112,125,125,-112,-123,-117};
      k_it->vast2 = {98,125,-120,-111,-118,60,99,-117,-118,-125};
      k_it->vast3 = {100,125,-114,-127,60,103,-114,-123,-113,-124,-118,125};
      k_it->vast4 = {112,125,-118,-112,-114,125};
    }

    if(kountteri == 124) {
      k_it->k_luku = 10;
      k_it->kysym = {87,115,118,118,121,115,120,42,83,120,126,111,124,120,111,126,115,120,42,-128,115,124,126,127,107,107,118,115,119,107,107,115,118,119,107,42,82,107,108,108,121,42,82,121,126,111,118,42,107,-128,107,127,126,127,115,73};
      k_it->vast1 = {60,58,58,58};
      k_it->vast2 = {59,67,67,63};
      k_it->vast3 = {60,58,58,63};
      k_it->vast4 = {60,58,59,58};
      k_it->selitys = {75,118,127,117,125,115,42,120,115,119,111,118,118,70,42,82,121,126,111,118,118,115,42,85,127,118,126,107,117,107,118,107};
    }

    if(kountteri == 125) {
      k_it->k_luku = 26;
      k_it->kysym = {103,-125,-114,-123,86,58,-119,-122,-125,-112,123,-114,58,109,-113,-119,-121,127,-120,58,98,123,124,124,-119,58,98,-119,-114,127,-122,-125,-120,58,123,-113,-123,-125,-119,-122,-119,123,-124,123,-114,89};
      k_it->vast1 = {81,84,74,74,71,74,84,74,74};
      k_it->vast2 = {74,84,74,74,71,82,84,74,74};
      k_it->vast3 = {83,84,74,74,71,76,76,84,74,74};
      k_it->vast4 = {75,76,84,74,74,71,75,83,84,74,74};
      k_it->selitys = {91,-113,-123,-125,-119,-122,-119,123,-124,123,-114,58,-118,-119,-125,-115,-114,127,-114,-114,-125,-125,-120,58,-112,-113,-119,-120,-120,123,58,76,74,75,81};
    }

    if(kountteri == 126) {
      k_it->k_luku = 91;
      k_it->kysym = {-88,-60,-58,-105,123,-54,-55,123,-90,-54,-50,-58,-64,-55,-58,-54,-51,-47,-68,-55,123,-68,-57,-58,-54,-61,-54,-57,-60,-53,-60,-49,-54,-60,-50,-48,-48,-50,-102};
      k_it->vast1 = {-114,-109,123,-128};
      k_it->vast2 = {-115,-109,123,-128};
      k_it->vast3 = {-113,-109,123,-128};
      k_it->vast4 = {-112,-109,123,-128};
    }

    if(kountteri == 127) {
      k_it->k_luku = 88;
      k_it->kysym = {-91,-63,-58,-61,-108,120,-56,-51,-57,-60,-51,-67,-67,-58,120,-67,-64,-68,-57,-61,-61,-71,-71,-58,-71,120,-52,-63,-67,-52,-57,-52,-67,-61,-58,-63,-63,-61,-71,-58,120,-71,-53,-63,-71,-58,-52,-51,-58,-52,-63,-62,-71,120,-88,-67,-52,-52,-67,-54,-63,120,-94,-108,-54,-50,-63,-58,-67,-58,120,-57,-60,-63,120,-67,-68,-51,-53,-61,-51,-58,-52,-71,-50,-71,-71,-60,-67,-63,-53,-53,-71,120,-50,-51,-57,-58,-58,-71,120,-118,-120,-119,-119,-105};
      k_it->vast1 = {-93,-57,-61,-57,-57,-59,-51,-61,-53,-67,-58};
      k_it->vast2 = {-82,-63,-64,-54,-67,-63,-68,-67,-58};
      k_it->vast3 = {-88,-67,-54,-51,-53,-53,-51,-57,-59,-71,-60,-71,-63,-53,-52,-67,-58};
      k_it->vast4 = {-85,-57,-53,-63,-71,-71,-60,-63,-68,-67,-59,-57,-61,-54,-71,-71,-52,-52,-63,-67,-58};
    }

    if(kountteri == 128) {
      k_it->k_luku = 55;
      k_it->kysym = {-126,-84,-96,-91,-94,-104,87,-92,-90,-91,-85,-104,87,-89,-87,-90,-86,-100,-91,-85,-85,-96,-104,87,-86,-84,-90,-92,-104,-93,-104,-96,-86,-96,-86,-85,-104,87,-91,-104,-96,-86,-96,-86,-85,-104,87,-89,-96,-85,115,115,87,-104,-91,-104,-104,-93,-96,-80,-97,-101,-80,-91,-85,115,115,87,-89,-100,-87,-83,-100,-87,-86,-86,-96,-91,115,87,-85,-104,-96,87,-86,-104,-96,-87,-104,-104,-91,-104,118,87,95,-83,-84,-90,-101,-100,-91,87,105,103,104,108,87,-85,-96,-93,-104,-86,-85,-90,96};
      k_it->vast1 = {106,110,87,92};
      k_it->vast2 = {104,110,87,92};
      k_it->vast3 = {108,110,87,92};
      k_it->vast4 = {110,110,87,92};
    }

    if(kountteri == 129) {
      k_it->k_luku = 85;
      k_it->kysym = {-96,-54,-66,-61,-64,-74,117,-62,-60,-61,-55,-74,117,-59,-57,-60,-56,-70,-61,-55,-55,-66,-74,117,-56,-54,-60,-62,-74,-63,-74,-66,-56,-66,-56,-55,-74,117,-61,-74,-66,-56,-66,-56,-55,-74,117,-59,-66,-55,-111,-111,117,-53,-74,-59,-74,-74,-55,-74,117,-56,-70,-64,-56,-66,-111,117,-59,-70,-57,-53,-70,-57,-56,-56,-66,-61,-111,117,-55,-74,-66,117,-56,-74,-66,-57,-74,-74,-61,-74,-108,117,125,-53,-54,-60,-71,-70,-61,117,-121,-123,-122,-118,117,-55,-66,-63,-74,-56,-55,-60,126};
      k_it->vast1 = {-120,-118,117,122};
      k_it->vast2 = {-122,-118,117,122};
      k_it->vast3 = {-118,-118,117,122};
      k_it->vast4 = {-116,-118,117,122};
    }

    if(kountteri == 130) {
      k_it->k_luku = 57;
      k_it->kysym = {-124,-82,-94,-89,-92,-102,89,-90,-88,-89,-83,-102,89,-87,-85,-88,-84,-98,-89,-83,-83,-94,-102,89,-84,-82,-88,-90,-102,-91,-102,-94,-84,-94,-84,-83,-102,89,-89,-102,-94,-84,-94,-84,-83,-102,89,-87,-94,-83,117,117,89,-84,-102,-99,-88,-90,-102,-84,-88,-92,-94,-84,-90,-94,-102,89,-87,-98,-85,-81,-98,-85,-84,-84,-94,-89,117,89,-83,-102,-94,89,-84,-102,-94,-85,-102,-102,-89,-102,120,89,97,-81,-82,-88,-99,-98,-89,89,107,105,106,110,89,-83,-94,-91,-102,-84,-83,-88,98};
      k_it->vast1 = {110,113,89,94};
      k_it->vast2 = {108,113,89,94};
      k_it->vast3 = {112,113,89,94};
      k_it->vast4 = {106,113,89,94};
    }

    if(kountteri == 131) {
      k_it->k_luku = 54;
      k_it->kysym = {-127,-85,-97,-92,-95,-105,86,-93,-91,-92,-86,-105,86,-90,-88,-91,-87,-101,-92,-86,-86,-97,-105,86,-87,-85,-91,-93,-105,-94,-105,-97,-87,-97,-87,-86,-105,86,-93,-97,-101,-98,-97,-87,-86,114,86,-90,-97,-86,114,114,86,-98,-91,-93,-91,99,86,-96,-105,86,-104,-97,-87,-101,-95,-87,-85,-105,-105,-94,-97,-87,-85,-85,-86,-86,-105,86,-90,-101,-88,-84,-101,-88,-87,-87,-97,-92,114,86,-86,-105,-97,86,-87,-105,-97,-88,-105,-105,-92,-105,117,86,94,-84,-85,-91,-102,-101,-92,86,104,102,103,107,86,-86,-97,-94,-105,-87,-86,-91,95};
      k_it->vast1 = {104,111,86,91};
      k_it->vast2 = {106,111,86,91};
      k_it->vast3 = {108,111,86,91};
      k_it->vast4 = {111,86,91};
    }

    if(kountteri == 132) {
      k_it->k_luku = 34;
      k_it->kysym = {111,-117,-115,94,66,-111,-112,66,-106,-105,-118,-111,-117,-107,-117,-112,66,-107,-111,-106,-125,79,-125,-116,-125,-112,66,-116,94,-114,-115,-121,-121,-112,66,-106,-121,-118,-106,-101,66,-118,-101,127,-115,-115,94,-101,-107,66,117,-105,-111,-113,-121,-107,-107,-125,97};
      k_it->vast1 = {109,-125,-105,-118,-125,-116,-111,-121,-112,66,-115,-111,-105,-114,-105,-125,-113,-113,-105,-107,-115,-121,-114,-105};
      k_it->vast2 = {108,-111,-115,-121,-114,-125,-112,66,-115,-111,-105,-114,-105,-125,-113,-113,-105,-107,-115,-121,-114,-105};
      k_it->vast3 = {109,-125,-105,-110,-110,-125,-115,-121,-107,-115,-105,-107,66,111,-101,-101,-108,-113,-125,-112,-112,-117,-112,66,-110,-111,-113,-113,-117,79,-117,-107,-115,-105};
      k_it->vast4 = {109,-125,-105,-110,-110,-125,-115,-121,-107,-115,-105,-107,66,117,-121,-114,-114,-111,-112,66,-125,-113,-113,-105,-107,-115,-121,-114,-105};
      k_it->luk4 = true;
      k_it->selitys = {83,83,66,-105,-118,-108,-117,-125,66,74,-113,-105,-115,-125,-125,-112,66,-114,-105,-115,-117,-121,-112,66,-106,-121,-115,-117,-116,94,75};
    }

    if(kountteri == 133) {
      k_it->k_luku = 49;
      k_it->kysym = {126,-102,-97,109,81,-89,-90,-96,-97,-97,-110,81,123,-110,-99,-99,-90,81,-110,-99,-100,-96,-102,81,-102,-99,-98,-106,-92,-91,-86,109,112};
      k_it->vast1 = {98,106,102,100};
      k_it->vast2 = {98,106,102,105};
      k_it->vast3 = {98,106,103,100};
      k_it->vast4 = {98,106,103,105};
    }

    if(kountteri == 134) {
      k_it->k_luku = 73;
      k_it->kysym = {-106,-78,-75,-75,-72,-78,-73,105,-76,-82,-68,-76,-78,-72,-75,-66,-67,105,-67,-66,-75,-78,105,-69,-66,-72,-76,-86,-76,-86,-66,-71,-71,-72,-78,-79,-78,-73,-120};
      k_it->vast1 = {122,-126,127,-126};
      k_it->vast2 = {122,-126,127,123};
      k_it->vast3 = {122,-126,126,127};
      k_it->vast4 = {122,-126,-128,125};
    }

    if(kountteri == 135) {
      k_it->k_luku = 57;
      k_it->kysym = {-122,-94,-92,117,89,-88,-91,-94,89,-83,-78,-106,-94,-92,117,-94,-84,-83,-98,-89,89,97,106,110,102,111,109,89,102,-81,-82,-88,-83,-94,-102,-102,-83,98,89,-84,-82,-88,-90,-102,-91,-102,-94,-84,-83,-98,-89,89,-78,-91,-98,-94,-84,-94,-89,89,-92,-82,-88,-91,-94,-89,-84,-78,-78,89,-81,-82,-88,-89,-89,-102,89,107,105,106,114,120};
      k_it->vast1 = {-124,-102,-84,-81,-102,-94,-90,-98,-83};
      k_it->vast2 = {122,-91,-92,-88,-95,-88,-91,-94};
      k_it->vast3 = {-126,-83,-84,-98,-90,-82,-85,-95,-102,-83};
      k_it->vast4 = {-113,-98,-85,-98,-89,-92,-94,-98,-85,-83,-88,-98,-91,-94,-89,-83,-98,-89,89,-84,-102,-94,-85,-102,-82,-99,-98,-83};
    }

    if(kountteri == 136) {
      k_it->k_luku = 48;
      k_it->kysym = {125,-103,-93,-93,108,80,-99,-111,-111,-101,-91,-98,-98,-111,-93,-93,-111,80,-99,-87,-87,-92,-103,-103,-98,80,-107,-98,-103,-92,-107,-98,80,-111,-100,-101,-97,-104,-97,-100,-103,-111,80,-111,-93,-91,-101,-111,-93,-92,-111,80,-101,-97,-104,-108,-107,-98,80,-90,-91,-97,-98,-98,-111,80,98,96,98,96,111};
      k_it->vast1 = {124,-111,-96,-103,-93,-93,-111};
      k_it->vast2 = {117,-92,-107,-100,108,93,-125,-111,-90,-97,-93,-93,-111};
      k_it->vast3 = {-123,-91,-108,-107,-100,-100,-111,-99,-111,-111,-100,-100,-111};
      k_it->vast4 = {123,-111,-103,-98,-91,-91,-93,-93,-111};
    }

    if(kountteri == 137) {
      k_it->k_luku = 92;
      k_it->kysym = {-89,-47,-59,-54,-57,-67,124,-55,-53,-54,-48,-67,124,-99,-56,-57,-53,-54,124,-55,-43,-43,-55,-104,-56,-104,-104,124,-81,-47,-53,-55,-63,-49,-49,-67,124,-53,-56,-59,124,-46,-47,-53,-54,-54,-67,124,-114,-116,-114,-116,-101};
      k_it->vast1 = {-113,-110,-111};
      k_it->vast2 = {-109,-110,-111};
      k_it->vast3 = {-115,-116,-110,-111};
      k_it->vast4 = {-115,-110,-111};
    }

    if(kountteri == 138) {
      k_it->k_luku = 18;
      k_it->kysym = {95,123,-128,125,78,126,115,123,-123,119,-128,50,-126,-123,-117,-117,125,125,123,-123,119,-128,50,-120,115,123,125,-121,-122,-121,125,-123,119,-128,50,-122,-121,-126,115,125,115,-128,-126,-127,126,-122,-122,115,127,123,-128,119,-128,50,115,123,122,119,-121,-122,-122,115,115,81};
      k_it->vast1 = {90,-117,-120,78,-128,-127,126,-127,-128,-122,-121,-128,-122,119,119,-128};
      k_it->vast2 = {98,115,-128,123,123,125,123,-128};
      k_it->vast3 = {95,119,126,115,-128,125,-127,126,123,115,-128};
      k_it->vast4 = {83,122,118,123,-123,-122,-121,125,-123,119,-128};
    }

    if(kountteri == 139) {
      k_it->k_luku = 47;
      k_it->kysym = {124,-104,-99,-102,107,79,-88,-95,-104,-93,-88,-102,-94,-108,-99,79,-105,-112,-101,-101,-104,-93,-92,-102,-94,-108,-99,79,-103,107,-94,-108,-99,-108,-99,107,79,-93,-104,-108,-93,-98,-102,-104,-95,-103,-112,-104,-101,-104,-103,-112,79,127,-108,-93,-93,-108,-95,-104,79,121,107,-95,-91,-104,-99,-108,-99,79,-103,-98,-92,-93,-92,-104,79,-91,-92,-98,-94,-104,-108,-99,79,-98,-104,-102,-108,-92,-109,-108,-99,-102,107,-88,-99,-93,-104,-102,-104,-108,-95,-93,-108,-108,-94,-108,-108,-99,110};
      k_it->vast1 = {121,-104,-97,-97,-104,-104,79,118,-95,-98,-92,-97};
      k_it->vast2 = {-126,-98,-99,-108,-95,-112};
      k_it->vast3 = {-122,-112,-97,-104,-93};
      k_it->vast4 = {-125,121,79,118,-95,-98,-92,-97};
      k_it->selitys = {121,107,-95,-91,-104,-99,-108,-99,79,-91,-112,-97,-112,-92,-93,-92,-104,79,-101,-98,-97,-92,-101,-93,-112,79,-94,-88,-88,-93,-93,-108,-104,-94,-93,107};
    }

    if(kountteri == 140) {
      k_it->k_luku = 85;
      k_it->kysym = {-96,-54,-66,-61,-64,-74,117,-62,-60,-61,-55,-74,117,-61,-54,-60,-57,-55,-74,117,-60,-56,-74,-63,-63,-66,-56,-55,-54,-66,117,-92,-54,-63,-54,-61,117,-64,-57,-66,-56,-55,-74,-63,-63,-66,-50,-78,-61,-111,117,-55,-54,-61,-61,-70,-55,-55,-54,-54,-61,117,-53,-111,-64,-66,-53,-74,-63,-55,-74,-66,-56,-70,-70,-61,117,-62,-70,-63,-63,-74,-64,-74,-74,-61,117,-53,-54,-60,-71,-70,-61,117,-122,-114,-114,-123,117,-70,-63,-60,-64,-54,-54,-56,-56,-74,-108};
      k_it->vast1 = {-93,-60,-66,-61,117,-55,-54,-67,-74,-55};
      k_it->vast2 = {-93,-60,-66,-61,117,-56,-74,-55,-74};
      k_it->vast3 = {-94,-54,-54,-55,-74,-62,-66,-74,117,-56,-74,-55,-60,-65,-74};
      k_it->vast4 = {-94,-54,-54,-55,-74,-62,-74,117,-64,-50,-62,-62,-70,-61,-55,-111};
    }

    if(kountteri == 141) {
      k_it->k_luku = 41;
      k_it->kysym = {118,-110,-108,101,73,-104,-107,-110,73,120,-98,-107,-98,-105,73,-108,-101,-110,-100,-99,-118,-107,-107,-110,-94,-122,-105,101,73,-99,-98,-105,-105,-114,-99,-98,-105,73,-97,-98,-104,-115,-114,-105,73,90,98,98,89,73,-114,-107,-104,-108,-98,-98,-100,-100,-118,73,-99,-118,-103,-118,-111,-99,-98,-105,-114,-114,-105,73,-105,-98,-104,-101,-110,-100,-104,-106,-114,-107,-107,-118,-108,-118,-105,73,-118,-107,-108,-98,-100,-94,-94,104};
      k_it->vast1 = {119,-98,-104,-101,-114,-99,73,-97,-118,-100,-99,-98,-100,-99,-110,-97,-118,-99,73,-108,-118,-107,-109,-118,-97,-118,-101,-108,-118,-118,-105,73,-103,-110,-115,101,-99,-94,-100,-99,101};
      k_it->vast2 = {121,-104,-107,-110,-110,-100,-110,73,-118,-109,-104,-110,73,-105,-98,-104,-101,-114,-99,73,-103,-104,-110,-100,73,-100,-94,-105,-118,-112,-104,-104,-112,-118,-105,73,-114,-115,-114,-100,-99,101};
      k_it->vast3 = {125,-118,-103,-103,-114,-107,-98,73,116,-104,-100,-108,-114,-107,-118,-105,73,-109,-118,73,118,-94,-107,-107,-94,-104,-109,-118,-105,73,-109,-114,-105,-112,-110,-114,-105,73,-97,101,-107,-110,-107,-107,101};
      k_it->vast4 = {121,-104,-107,-110,-110,-100,-110,73,-99,-118,-108,-118,-97,-118,-101,-110,-108,-104,-110,73,-97,-110,-101,-110,-99,-114,-99,-94,-105,73,-106,-104,-103,-104,-105};
    }

    if(kountteri == 142) {
      k_it->k_luku = 65;
      k_it->kysym = {-114,-86,-81,125,97,-73,-74,-80,-81,-81,-94,97,-111,-90,-75,-75,-90,-77,-86,97,-117,125,-77,-73,-86,-81,-90,-81,97,-85,-74,-83,-84,-94,-86,-76,-86,97,-90,-81,-76,-86,-82,-82,125,-86,-76,-90,-81,97,-75,-86,-90,-75,-80,-84,-80,-81,-90,-90,-81,-84,125,-70,-75,-75,-98,125,97,-84,125,-76,-86,-75,-75,-90,-83,-90,-73,125,-81,97,-84,-86,-77,-85,-94,-81,-76,-94,-128};
      k_it->vast1 = {114,122,121,119};
      k_it->vast2 = {114,122,121,122};
      k_it->vast3 = {114,122,122,114};
      k_it->vast4 = {114,122,122,117};
      k_it->selitys = {-107,-74,-80,-83,-83,-80,-86,-81,97,-86,-83,-82,-90,-76,-75,-70,-86,-73,125,-75,97,-84,-86,-77,-85,-94,-75,97,99,-116,-80,-75,-86,-82,-86,-84,-77,-80,-75,99,97,-85,-94,97,99,-111,-124,110,-84,125,-70,-75,-75,125,-85,125,-81,97,-84,125,-76,-86,-84,-86,-77,-85,-94,99};
    }

    if(kountteri == 143) {
      k_it->k_luku = 71;
      k_it->kysym = {-108,-80,-69,-125,103,-112,-76,-88,-69,-71,-88,-77,-77,-88,103,-79,-74,-68,-77,-68,-78,-68,-68,-70,-70,-88,103,121,119,120,125,103,-78,-74,-77,-76,-84,103,-75,-88,-80,-70,-69,-88,103,-70,-88,-69,-69,-68,-76,-88,-75,-67,-88,-71,-88,-80,-70,-84,-70,-69,-80,103,-88,-76,-73,-68,-75,-68,-69,103,-76,-80,-84,-77,-84,-75,-67,-80,-78,-88,-80,-75,-84,-75,103,-76,-80,-84,-70,103,-78,-84,-71,-69,-74,-80,103,-88,-77,-68,-75,103,-73,-84,-71,-80,-75,103,-69,-84,-74,-75,103,-70,-64,-64,-78,-70,-80,-122};
      k_it->vast1 = {-101,-88,-71,-78,-74,-80,-69,-68,-70,103,-74,-77,-80,103,-73,-125,-125,-70,-69,-125,103,-73,-74,-77,-80,-80,-70,-80,-73,-68,-69,-78,-88,-88,-75,103,-69,-68,-71,-67,-88,-88,-75};
      k_it->vast2 = {-101,-88,-71,-78,-74,-80,-69,-68,-70,103,-74,-77,-80,103,-88,-76,-73,-68,-88,103,-118,-112,-120,-127,-75,103,-88,-82,-84,-75,-69,-80,-69};
      k_it->vast3 = {-101,-88,-71,-78,-74,-80,-69,-68,-70,103,-74,-77,-80,103,-71,-64,-92,-70,-69,-125,-125,103,-68,-81,-71,-84,-80,-77,-69,-88,103,-71,-88,-81,-88,-69,103,-69,-68,-73,-88,-78,-78,-88,-88,-75};
      k_it->vast4 = {-101,-88,-71,-78,-74,-80,-69,-68,-70,103,-74,-77,-80,103,-81,-125,-76,-125,-69,-125,103,-73,-74,-77,-80,-80,-70,-80,-88,103,-79,-88,103,-69,-84,-81,-85,-125,103,-67,-88,-71,-70,-80,-75,-88,-80,-75,-84,-75,103,-71,-80,-78,-74,-70,103,-76,-68,-68,-88,-77,-77,-88};
      k_it->selitys = {-101,-84,-78,-80,-79,-125,103,-68,-70,-78,-74,-80,103,-73,-88,-77,-78,-78,-88,-76,-68,-71,-81,-88,-88,-79,-88,-75,103,-74,-77,-84,-67,-88,-75,103,-73,-84,-71,-125,-70,-70,-125,-125,-75,117};
    }

    if(kountteri == 144) {
      k_it->k_luku = 73;
      k_it->kysym = {-106,-78,-76,-123,105,-72,-75,-78,105,-74,-86,-69,-69,-86,-68,-76,-66,-66,-68,-68,-86,105,-65,-66,-72,-73,-73,-86,105,123,121,122,121,105,-68,-86,-67,-67,-66,-73,-82,-82,-73,105,-77,-86,105,-76,-72,-75,-74,-82,-73,105,-78,-79,-74,-78,-68,-82,-73,105,-79,-82,-73,-80,-82,-73,105,-65,-86,-86,-67,-78,-73,-82,-82,-73,105,-99,-86,-74,-71,-82,-69,-82,-82,-73,105,-103,-78,-61,-61,-82,-69,-78,-86,105,-109,-66,-75,-78,-82,-67,-78,-73,105,-67,-66,-79,-72,-71,-72,-75,-67,-72,-73,105,-74,-72,-67,-78,-78,-65,-78,-120};
      k_it->vast1 = {-97,-86,-76,-66,-66,-67,-66,-68,-71,-82,-67,-72,-68};
      k_it->vast2 = {-101,-86,-68,-78,-68,-74,-78};
      k_it->vast3 = {-103,-62,-69,-72,-74,-86,-73,-78,-86};
      k_it->vast4 = {-108,-72,-68,-67,-72,105,-67,-62,-90,-73,-86,-73,-67,-86,-77,-86,-75,-75,-82};
    }

    if(kountteri == 145) {
      k_it->k_luku = 78;
      k_it->kysym = {-101,-73,-71,-118,110,-69,-73,-77,-70,-77,-68,-62,-77,-64,-60,-77,-57,-78,-77,-70,-70,-73,-68,-77,-68,110,-67,-68,-75,-77,-70,-69,-81,110,-62,-67,-78,-77,-62,-62,-73,-73,-68,110,-60,-61,-67,-63,-73,-68,-81,110,-128,126,126,-125,123,-128,126,127,-127,110,-60,-73,-73,-63,-73,110,-60,-81,-63,-62,-81,-63,-57,-68,-62,-57,-68,-57,-62,-62,-118,110,-70,-81,-63,-62,-81,-81,-68,110,-63,-61,-64,-69,-81,-68,-68,-77,-77,-70,-70,-81,110,-67,-61,-70,-61,-70,-81,-73,-63,-77,-70,-70,-81,110,-68,-81,-73,-63,-77,-70,-70,-81,-115};
      k_it->vast1 = {-95,-77,-71,-81,-69,-61,-67,-62,-67,-73,-68,-77,-68,110,-66,-77,-64,-63,-67,-67,-68,-81,-70,-70,-73,-63,-61,-61,-63,-74,-118,-73,-64,-73,-85};
      k_it->vast2 = {-106,-81,-64,-74,-81,-70,-61,-61,-70,-67,-73,-63,-61,-61,-63,-74,-118,-73,-64,-73,-85};
      k_it->vast3 = {-95,-71,-73,-62,-63,-67,-81,-76,-76,-77,-71,-62,-73,-73,-60,-73,-68,-77,-68,110,-66,-77,-64,-63,-67,-67,-68,-81,-70,-70,-73,-63,-61,-61,-63,-74,-118,-73,-64,-73,-85};
      k_it->vast4 = {-109,-66,-118,-60,-81,-71,-81,-81,110,-66,-77,-64,-63,-67,-67,-68,-81,-70,-70,-73,-63,-61,-61,-63,-74,-118,-73,-64,-73,-85};
    }

    if(kountteri == 146) {
      k_it->k_luku = 80;
      k_it->kysym = {-99,-79,-60,-60,-71,112,-98,-55,-69,-116,-66,-75,-66,112,-79,-68,-69,-65,-71,112,-60,-55,-83,-61,-69,-75,-66,-66,-75,-68,-68,-116,112,-61,-60,-62,-71,-64,-60,-75,-79,-61,-75,125,-60,-79,-66,-61,-61,-71,-70,-79,-66,-79,112,-58,-59,-65,-66,-66,-79,112,-127,-119,-119,-120,126,112,-99,-71,-66,-69,-116,112,-69,-79,-59,-64,-59,-66,-73,-71,-66,112,-69,-79,-61,-71,-66,-65,112,-65,-68,-71,112,-72,-116,-66,-75,-66,112,-60,-55,-83,-64,-79,-71,-69,-69,-79,-66,-61,-79,-113};
      k_it->vast1 = {-102,-116,-62,-58,-75,-66,-64,-116,-116};
      k_it->vast2 = {-102,-55,-58,-116,-61,-69,-55,-68,-116};
      k_it->vast3 = {-100,-79,-72,-60,-71};
      k_it->vast4 = {-99,-71,-69,-69,-75,-68,-71};
    }

    if(kountteri == 147) {
      k_it->k_luku = 54;
      k_it->kysym = {-125,-105,-86,-86,-97,86,-124,-81,-95,114,-92,-101,-92,86,-84,-105,-94,-97,-86,-86,-97,-97,-92,86,-84,-85,-91,-92,-92,-105,86,103,111,111,108,86,-117,-85,-88,-105,-97,-87,-86,-101,-92,86,-95,-85,-92,-92,-105,-92,-84,-105,-94,-86,-85,-85,-87,-86,-91,-91,-92,86,-122,-101,-88,-85,-87,-87,-85,-91,-93,-105,-94,-105,-97,-87,-86,-101,-92,86,-101,-102,-85,-87,-86,-105,-96,-105,-92,-105,100,86,-127,-85,-97,-92,-95,-105,86,-93,-91,-92,-101,-87,-87,-105,86,-84,-105,-94,-86,-85,-85,-87,-86,-91,-92,86,-97,-87,-86,-85,-92,-92,-91,-87,-87,-105,86,-124,-81,-95,114,-92,-101,-92,86,-95,114,-84,-97,117};
      k_it->vast1 = {-127,-105,-98,-102,-101,-87,-87,-105};
      k_it->vast2 = {-124,-101,-94,-96,114,-87,-87,114};
      k_it->vast3 = {-127,-85,-85,-102,-101,-87,-87,-105};
      k_it->vast4 = {-113,-98,-102,-101,-87,-87,114};
    }

    if(kountteri == 148) {
      k_it->k_luku = 10;
      k_it->kysym = {87,115,120,117,70,42,122,127,121,118,127,111,111,120,42,111,114,110,121,117,117,107,107,120,107,42,87,107,126,126,115,42,88,-125,117,70,120,111,120,42,121,125,107,118,118,115,125,126,127,115,42,111,110,127,125,117,127,120,126,107,-128,107,107,118,111,115,114,115,120,42,-128,127,121,120,120,107,42,59,67,67,63,73};
      k_it->vast1 = {93,87,90};
      k_it->vast2 = {88,127,121,124,125,127,121,119,107,118,107,115,125,111,126};
      k_it->vast3 = {99,114,126,111,115,125,-128,107,125,126,127,127,42,122,127,121,118,127,111};
      k_it->vast4 = {85,111,125,117,127,125,126,107};
    }

    if(kountteri == 149) {
      k_it->k_luku = 38;
      k_it->kysym = {113,-101,-111,-121,70,-103,-117,-101,-104,-121,-121,-100,-113,-103,-102,-121,70,-112,-107,-101,-104,-108,-121,-110,-113,-103,-102,-117,-113,-103,-102,-121,70,-102,-107,-113,-109,-113,70,115,-121,-102,-102,-113,70,116,-97,-111,98,-103,-117,-110,-110,-117,70,-114,98,-108,-117,-108,70,-100,-121,-113,-114,-117,-113,-103,-102,-121,-121,-108,70,-104,-121,-106,-107,-104,-102,-107,-113,-108,-117,-117,-108,-121,70,72,-110,-101,-107,-102,-102,-107,-102,-107,-113,-109,-113,-102,-102,-121,-112,-121,-108,-121,72,101};
      k_it->vast1 = {111,-103,-102,-107,70,114,-97,-103,-109,98};
      k_it->vast2 = {122,-107,-113,-100,-107,70,103,-110,-121,-100,-113,-104,-102,-121};
      k_it->vast3 = {112,-101,-103,-103,-113,70,107,-104,-107,-108,-117,-108};
      k_it->vast4 = {112,-97,-104,-111,-113,70,103,-110,-111,-113,-107};
    }

    if(kountteri == 150) {
      k_it->k_luku = 24;
      k_it->kysym = {99,-115,-127,-122,-125,121,56,-123,-121,-122,-116,121,56,-125,125,-118,-116,121,121,56,101,121,-116,-116,-127,56,102,-111,-125,84,-122,125,-122,56,-123,125,-122,-127,56,-122,121,-127,-123,-127,-117,-127,-127,-122,87};
      k_it->vast1 = {99,-115,-115,-117,-127};
      k_it->vast2 = {110,-127,-127,-117,-127};
      k_it->vast3 = {102,125,-124,-126,84};
      k_it->vast4 = {99,-121,-124,-123,125};
      k_it->selitys = {98,-121,-127,-117,-116,121,56,-125,121,-125,-117,-127,56,-125,125,-118,-116,121,121,56,101,125,-118,-114,-127,56,108,121,-120,-121,-124,121,-122,56,-125,121,-122,-117,-117,121};
    }

    if(kountteri == 151) {
      k_it->k_luku = 75;
      k_it->kysym = {-104,-76,-74,-121,107,-70,-71,107,-63,-64,-70,-81,-80,-66,-65,-84,107,125,123,124,-124,107,-84,-73,-74,-84,-80,-71,107,-73,-84,-74,-76,-66,-121,-121,-65,-80,-76,-71,-80,-71,107,-60,-73,-121,-67,-84,-75,-84,107,-72,-80,-65,-84,-71,-70,-73,-76,-73,-73,-80,107,-69,-84,-76,-71,-70,-69,-67,-70,-66,-80,-71,-65,-65,-80,-76,-71,-84,107,-69,-80,-66,-64,-71,-80,-66,-65,-80,-80,-71,107,-66,-76,-66,-121,-73,-73,-88,-66,-65,-121,-118};
      k_it->vast1 = {123,119,-127,107,112};
      k_it->vast2 = {-127,107,112};
      k_it->vast3 = {124,123,119,-127,123,107,112};
      k_it->vast4 = {-127,123,107,112};
    }

    if(kountteri == 152) {
      k_it->k_luku = 9;
      k_it->kysym = {86,114,119,116,69,41,125,120,114,124,110,119,41,124,106,118,106,119,117,106,114,124,125,106,41,106,117,116,120,113,120,117,114,116,126,117,125,125,126,126,123,114,106,41,120,118,106,106,127,106,119,41,78,94,54,118,106,106,119,41,116,106,119,124,124,106,41,92,126,120,118,114,41,120,119,41,106,115,106,119,126,125,41,118,110,125,106,119,120,117,114,106,41,124,114,124,69,117,125,69,127,114,110,119,41,117,106,124,114,119,121,110,124,126,119,110,124,125,110,114,109,110,119,41,123,106,115,120,114,125,126,124,125,106,41,78,94,67,124,124,106,72};
      k_it->vast1 = {89,126,120,117,106};
      k_it->vast2 = {94,119,116,106,123,114};
      k_it->vast3 = {93,106,119,124,116,106};
      k_it->vast4 = {91,106,119,124,116,106};
      k_it->luk4 = true;
    }

    if(kountteri == 153) {
      k_it->k_luku = 84;
      k_it->kysym = {-95,-67,-65,-112,116,-68,-75,-66,-55,-54,-71,-57,-67,116,-61,-62,116,-57,-55,-61,-57,-67,-56,-56,-55,116,-63,-51,-79,-57,116,-65,-61,-58,-54,-67,-65,-71,-75,-64,-65,-61,-68,-61,-64,-67,-62,-75,-109};
      k_it->vast1 = {-97,-79,-64,-62,-67,-62,116,-54,-71,-57,-67};
      k_it->vast2 = {-105,-68,-75,-62,-71,-64,116,-119};
      k_it->vast3 = {-90,-55,-55,-57,-55,-54,-71,-57,-67};
      k_it->vast4 = {-106,-64,-75,-73,-65,116,-89,-56,-75,-58};
    }

    if(kountteri == 154) {
      k_it->k_luku = 3;
      k_it->kysym = {78,120,110,100,35,115,100,111,109,100,118,119,108,35,121,120,114,113,113,100,35,52,60,60,53,35,112,108,113,108,118,119,104,117,108,35,78,100,120,110,114,35,77,120,107,100,113,119,100,111,114,113,35,119,100,121,114,108,119,104,111,111,104,104,113,35,107,104,113,110,108,111,96,110,114,107,119,100,108,118,119,100,35,104,119,120,100,35,121,100,111,119,108,114,113,35,124,117,108,119,124,118,117,100,107,114,108,119,120,118,119,100,35,109,63,117,109,104,118,119,63,104,118,118,63,63,113,66};
      k_it->vast1 = {70,107,117,108,118,119,114,115,107,104,117,35,90,104,106,104,111,108,120,118};
      k_it->vast2 = {77,100,102,114,101,35,86,96,103,104,117,112,100,113};
      k_it->vast3 = {72,118,110,114,35,68,107,114};
      k_it->vast4 = {77,120,107,100,113,108,35,85,108,108,110,114,113,104,113};
      k_it->selitys = {90,104,106,104,111,108,120,118,35,119,114,108,112,108,35,119,120,114,111,111,114,108,113,35,86,78,82,83,48,117,124,107,112,63,113,35,109,114,107,119,100,109,100,113,100};
    }

    if(kountteri == 155) {
      k_it->k_luku = 19;
      k_it->kysym = {96,124,123,124,-127,51,-122,120,-120,-123,116,116,-119,124,-122,-121,116,51,-121,-120,-126,-121,120,-128,120,-123,126,120,124,-122,-121,79,51,-128,-126,117,124,124,127,124,-125,120,127,124,-116,123,-121,124,112,51,101,124,-126,-121,51,88,-127,-121,120,-123,-121,116,124,-127,-128,120,-127,-121,51,120,124,51,-126,-128,116,-127,-127,-120,-121,51,127,124,-122,120,-127,-122,-122,124,79,82};
      k_it->vast1 = {91,116,-123,-123,-116,51,99,-126,-121,-121,120,-123};
      k_it->vast2 = {101,-116,123,-128,79,64,107};
      k_it->vast3 = {103,116,-123,-120,51,102,-126,-123,-128,-120,-122,-121,120,-127,51,91,120,-123,-123,116,-122,-121,116};
      k_it->vast4 = {85,-123,124,119,122,120,-121,51,93,-126,-127,120,-122};
    }

    if(kountteri == 156) {
      k_it->k_luku = 10;
      k_it->kysym = {87,115,126,117,70,42,121,118,115,-128,107,126,42,94,115,119,121,42,94,56,42,75,56,42,87,115,117,117,121,125,111,120,42,111,126,127,120,115,119,111,126,73};
      k_it->vast1 = {94,115,119,121,42,94,121,124,125,126,115,42,75,120,126,111,124,121};
      k_it->vast2 = {94,115,119,121,42,94,127,127,117,117,107,42,75,107,122,111,118,115};
      k_it->vast3 = {94,115,119,121,42,94,107,124,119,121,42,75,120,125,111,118,119,115};
      k_it->vast4 = {94,115,119,121,42,94,127,121,119,121,42,75,118,111,117,125,115};
    }

    if(kountteri == 157) {
      k_it->k_luku = 47;
      k_it->kysym = {124,-104,-102,107,79,-88,-105,-93,-88,-108,79,-108,-94,-104,-104,-99,-93,-88,-104,79,-127,-104,-98,-93,92,116,-99,-93,-108,-95,-93,-112,-104,-99,-100,-108,-99,-93,79,92,-88,-95,-104,-93,-88,-102,-94,-108,-99,79,124,-108,-95,-104,92,-125,-108,-104,-103,-98,-94,-94,-112,79,-103,107,-95,-103,-108,-94,-93,-88,-104,-94,-94,107,79,-103,-92,-105,-101,-104,-94,-94,-112,110};
      k_it->vast1 = {125,-108,-98,-99,79,97};
      k_it->vast2 = {-125,-105,-108,79,114,-92,-95,-108};
      k_it->vast3 = {-125,-105,-108,79,127,-95,-98,-109,-104,-106,-88};
      k_it->vast4 = {-127,-112,-109,-104,-98,-105,-108,-112,-109};
    }

    if(kountteri == 158) {
      k_it->k_luku = 7;
      k_it->kysym = {84,112,111,112,117,39,123,104,121,114,118,112,123,124,114,122,108,108,117,39,114,118,114,104,112,112,117,112,104,39,114,67,-128,123,108,123,67,67,117,39,90,124,118,116,108,122,122,104,39,115,104,112,115,115,112,122,108,122,123,112,70};
      k_it->vast1 = {87,124,124,107,124,123,124,114,122,108,108,117};
      k_it->vast2 = {82,112,119,124,115,67,67,114,114,108,108,117,67};
      k_it->vast3 = {87,122,-128,114,118,118,122,112,115,67,67,114,114,108,108,117,67};
      k_it->vast4 = {83,104,114,122,104,123,112,112,125,112,117,104};
    }

    if(kountteri == 159) {
      k_it->k_luku = 18;
      k_it->kysym = {95,123,126,126,78,50,125,78,-117,-122,-122,111,-122,115,-120,115,126,126,115,50,-120,-127,123,50,-128,-127,-126,119,123,127,127,123,-128,50,125,-127,125,119,115,50,125,-127,125,115,123,123,-128,123,-128,50,-120,115,123,125,-121,-122,-121,125,-123,119,-122,81};
      k_it->vast1 = {90,119,-128,121,123,-122,-122,78,127,78,126,126,78};
      k_it->vast2 = {96,115,-123,115,115,126,123,-123,119,-123,-122,123};
      k_it->vast3 = {91,-128,124,119,125,-122,-127,123,127,115,126,126,115};
      k_it->vast4 = {98,-121,-124,119,-123,125,119,126,119,127,115,126,126,115};
    }

    if(kountteri == 160) {
      k_it->k_luku = 32;
      k_it->kysym = {109,-119,-117,92,64,-113,-114,64,101,-108,-123,-116,92,77,97,-115,-123,-110,-119,-117,-127,-114,64,-127,-116,-117,-107,-112,-123,-110,92,-119,-109,-117,-127,-114,-109,-113,-118,-123,-114,64,-109,-107,-113,-109,-119,-115,-127,64,-108,-127,-112,-127,64,-117,92,-103,-108,-108,92,92,64,-117,-113,-117,-127,-119,-119,-114,-119,-127,95};
      k_it->vast1 = {112,-107,-110,-123,-109,-117,-123,-116,-123,-115,-127,-116,-116,-127};
      k_it->vast2 = {104,-123,-114,-121,-119,-108,-108,92,-115,92,-116,-116,92};
      k_it->vast3 = {105,-114,-118,-123,-117,-108,-113,-119,-115,-127,-116,-116,-127};
      k_it->vast4 = {110,-127,-109,-127,-127,-116,-119,-109,-123,-109,-108,-119};
    }

    if(kountteri == 161) {
      k_it->k_luku = 16;
      k_it->kysym = {93,121,126,123,76,48,120,-123,-123,125,113,-123,-125,113,121,126,117,117,126,48,124,117,-122,121,-124,-124,76,125,121,-125,117,-125,-124,76,48,-126,113,-128,61,113,-126,-124,121,-125,-124,121,48,96,121,123,123,-123,48,87,48,-124,-123,127,125,121,-124,-124,121,121,126,48,-125,113,123,123,127,121,120,121,126,79};
      k_it->vast1 = {91,127,123,113,121,121,126,121,126};
      k_it->vast2 = {93,113,-126,121,120,-123,113,126,113,126};
      k_it->vast3 = {88,117,-126,127,121,121,126,121,126};
      k_it->vast4 = {81,125,118,117,-124,113,125,121,121,126,121,126};
    }

    if(kountteri == 162) {
      k_it->k_luku = 24;
      k_it->kysym = {101,-127,-125,84,56,125,-124,84,-127,-122,56,121,-117,-115,-127,56,106,-127,-121,-116,69,93,-122,-116,125,-118,-116,121,-127,-122,-123,125,-122,-116,56,69,-123,-121,122,-127,-127,-124,-127,-120,125,-124,-127,-111,-118,-127,-116,-111,-125,-117,125,-122,56,-116,-121,-127,-123,-127,-117,-116,-121,-117,-117,121,87};
      k_it->vast1 = {97,127,-115,121,-122,121};
      k_it->vast2 = {110,121,-118,121,121,-122,-127};
      k_it->vast3 = {103,-124,-123,-127};
      k_it->vast4 = {90,121,-117,-127,-124,-127,-117,-125,-127};
    }

    if(kountteri == 163) {
      k_it->k_luku = 18;
      k_it->kysym = {95,123,126,126,78,50,-122,119,125,-128,123,-123,119,126,126,78,50,-122,119,-124,127,123,126,126,78,50,98,103,83,63,122,115,-124,-124,115,-123,-122,115,124,115,-122,50,58,-126,123,117,125,63,-121,-126,50,115,-124,-122,123,-123,-122,-123,62,50,-126,119,126,123,127,123,119,122,119,-122,59,50,125,-121,-122,-123,-121,-120,115,-122,50,-128,115,123,-123,119,-128,50,125,115,-128,-123,-123,115,50,-123,-121,125,-121,-126,-121,-127,126,123,-117,122,118,-117,-128,-122,78,78,-128,50,-126,78,78,-123,119,127,123,-123,-122,78,81};
      k_it->vast1 = {88,-121,126,126,63,117,126,-127,-123,119};
      k_it->vast2 = {102,-127,-122,115,126,63,-119,123,-128};
      k_it->vast3 = {95,115,-118,63,-123,117,-127,-124,119};
      k_it->vast4 = {83,126,-126,122,115,63,120,119,115,-122};
    }

    if(kountteri == 164) {
      k_it->k_luku = 65;
      k_it->kysym = {114,122,115,113,110,-83,-74,-73,-74,-81,97,-119,-90,-83,-76,-86,-81,-84,-86,-86,-81,97,-76,-86,-85,-80,-86,-75,-75,-74,-73,-94,-76,-76,-94,97,-114,-86,-84,-94,97,-104,-94,-83,-75,-94,-77,-86,-81,97,-90,-76,-86,-84,-80,-86,-76,-77,-80,-82,-94,-94,-81,-86,-76,-76,-94,97,99,-108,-74,-74,-77,-86,97,-118,-83,-83,-74,-76,-86,-80,-81,-86,99,97,-75,-80,-86,-81,-90,-81,97,-79,125,125,-87,-90,-81,-84,-86,-83,-98,97,-84,-90,-77,-75,-80,-80,97,-94,-86,-81,-90,-90,-76,-75,-94,109,97,-85,-80,-81,-84,-94,97,-94,-73,-74,-83,-83,-94,97,-73,-80,-86,97,-75,-74,-81,-75,-90,-94,97,-80,-83,-90,-73,-94,-81,-76,-94,97,99,125,-83,-70,-84,125,-76,109,97,-73,-80,-86,-82,-94,-84,-94,-76,109,97,-81,-74,-80,-77,-86,109,97,-73,125,-76,-70,-82,125,-75,-98,-81,109,97,-79,-74,-87,-91,-94,-76,97,-85,-94,97,-73,-86,-94,-75,-80,-81,99,111,97,-114,-86,-76,-75,125,97,-94,-86,-81,-90,-90,-76,-75,-94,97,-80,-81,97,-84,-70,-76,-90,-128};
      k_it->vast1 = {-116,-80,-84,-94,-86,-86,-81,-86};
      k_it->vast2 = {-112,-80,-79,-86,-74,-82,-86};
      k_it->vast3 = {-114,-94,-77,-86,-87,-74,-94,-81,-94};
      k_it->vast4 = {-114,-80,-77,-89,-86,-86,-81,-86};
    }

    if(kountteri == 165) {
      k_it->k_luku = 97;
      k_it->kysym = {-82,-54,-49,-52,-99,-127,-51,-58,-55,-59,-58,-49,-127,-43,-48,-54,-50,-54,-43,-42,-44,-47,-99,-99,-51,-51,-54,-52,-52,-66,-49,-99,-127,-43,-38,-66,-44,-52,-58,-49,-43,-58,-51,-54,-127,-84,-38,-42,-42,-127,-90,-43,-42,-45,-62,-42,-43,-43,-54,-96};
      k_it->vast1 = {-85,-62,-47,-62,-49,-127,-79,-48,-47};
      k_it->vast2 = {-75,-99,-55,-43,-54,-41,-62,-58,-51,-43,-62,-53,-62};
      k_it->vast3 = {-82,-62,-56,-42,-44};
      k_it->vast4 = {-81,-54,-49,-43,-58,-49,-59,-48,-114,-51,-58,-55,-43,-54};
      k_it->selitys = {-87,-99,-49,-127,-48,-51,-54,-127,-50,-38,-66,-44,-127,-94,-49,-54,-50,-58,-127,-114,-51,-58,-55,-59,-58,-49,-127,-43,-48,-54,-50,-54,-43,-42,-44,-47,-99,-99,-51,-51,-54,-52,-52,-66};
    }

    if(kountteri == 166) {
      k_it->k_luku = 27;
      k_it->kysym = {104,-124,-114,-114,87,59,-120,124,124,-114,-114,124,59,-118,-119,59,-114,-108,-119,-113,-108,-119,-108,-113,59,-120,124,124,-125,124,-119,-120,-112,-112,-113,-113,-118,-122,-115,-124,-124,-113,-113,-124,-119,-128,-119,59,-122,124,-119,-114,124,-121,124,-124,-114,124,-122,-113,-124,-111,-124,-114,-113,-124,59,101,-112,-119,-128,-114,59,103,-118,-122,-122,124,90};
      k_it->vast1 = {104,124,-115,-118,-122,-118,-114,-114,124};
      k_it->vast2 = {96,-126,-108,-117,-113,-124,-114,-114,87};
      k_it->vast3 = {110,-118,-120,124,-121,-124,124,-114,-114,124};
      k_it->vast4 = {111,-112,-119,-124,-114,-124,124,-114,-114,124};
    }

    if(kountteri == 167) {
      k_it->k_luku = 65;
      k_it->kysym = {-114,-86,-83,-83,125,97,-73,-74,-80,-76,-86,-84,-70,-82,-82,-90,-81,-90,-83,-83,125,97,-102,-87,-91,-70,-76,-73,-94,-83,-83,-80,-86,-76,-76,-94,97,-73,-74,-80,-81,-81,-94,97,114,122,117,121,97,-79,-90,-77,-74,-76,-75,-90,-75,-75,-74,97,-82,-80,-80,-75,-75,-80,-77,-86,-79,-70,-98,-77,125,-84,-90,-77,-87,-80,97,-119,-90,-83,-73,-90,-75,-86,-81,97,-122,-81,-84,-90,-83,-86,-75,97,-94,-83,-84,-80,-86,97,-75,-80,-86,-82,-86,-94,97,-108,-74,-80,-82,-90,-76,-76,-94,-128};
      k_it->vast1 = {114,122,122,113,110,-83,-74,-73,-74,-83,-83,-94};
      k_it->vast2 = {114,122,120,113,110,-83,-74,-73,-74,-83,-83,-94};
      k_it->vast3 = {114,122,121,113,110,-83,-74,-73,-74,-83,-83,-94};
      k_it->vast4 = {114,122,119,113,110,-83,-74,-73,-74,-83,-83,-94};
    }

    if(kountteri == 168) {
      k_it->k_luku = 41;
      k_it->kysym = {118,-110,-99,101,73,-118,-100,-114,-99,-99,-118,73,-97,-98,-104,-105,-105,-118,73,91,89,90,98,73,-107,-104,-108,-118,-108,-98,-98,-100,-100,-118,73,116,-98,-104,-103,-110,-104,-100,-100,-118,73,-100,-110,-109,-118,-110,-99,-100,-114,-97,-118,-118,-105,73,124,-118,-97,-104,-105,73,106,-106,-106,-118,-99,-99,-110,-104,-103,-110,-100,-99,-104,-104,-105,73,-111,-94,-122,-108,101,-105,-105,-94,-99,73,-109,-118,73,-94,-111,-115,-114,-105,73,-111,-114,-105,-112,-114,-105,73,-100,-98,-101,-106,-118,-105,-105,-98,-99,73,-106,-110,-114,-100,73,-108,101,-94,-99,-99,-110,104};
      k_it->vast1 = {121,-110,-99,-108,101,-106,-110,-114,-108,-108,-118,-118};
      k_it->vast2 = {124,-118,-103,-114,-107,-110,-118};
      k_it->vast3 = {117,-114,-97,-114,101,-106,-110,-114,-108,-108,-118,-118};
      k_it->vast4 = {116,-118,-111,-115,-114,-105,-108,101,-115,-114,-105,-106,-110,-114,-108,-108,-118,-118};
      k_it->selitys = {125,-114,-108,-110,-109,101,-107,-107,101,73,-104,-107,-110,73,-106,-98,-108,-118,-105,-118,-118,-105,73,-106,-94,-122,-100,73,-110,-107,-106,-118,-103,-110,-100,-99,-104,-104,-107,-110};
    }

    if(kountteri == 169) {
      k_it->k_luku = 45;
      k_it->kysym = {120,-94,-106,-101,-104,-114,77,-102,-100,-101,-95,-114,-114,77,-113,-106,-95,-112,-100,-106,-101,-106,-114,77,125,-96,-90,-104,-100,-95,-110,-97,-114,-99,-106,-114,-104,-110,-96,-104,-94,-96,77,-125,-114,-96,-95,-114,-114,-102,-100,-100,-101,77,-95,-106,-110,-95,-100,-102,-94,-97,-97,-100,-101,77,-95,-110,-107,-101,-90,-95,77,-104,-106,-97,-106,-96,-95,105,-105,105,77,-93,-114,-114,-95,-106,77,-94,-107,-97,-110,-106,-103,-95,-114,-114,-101,108};
      k_it->vast1 = {97,93};
      k_it->vast2 = {97,93,93};
      k_it->vast3 = {97,93,93,93};
      k_it->vast4 = {97};
      k_it->selitys = {122,105,105,-97,105,77,-93,-114,-96,-95,-114,-96,-106,77,-95,-94,-100,-103,-103,-100,-106,-101,77,-101,-100,-106,-101,77,97,98,93,77,93,93,93,77,-110,-94,-97,-100,-114};
    }

    if(kountteri == 170) {
      k_it->k_luku = 12;
      k_it->kysym = {89,117,122,119,72,44,122,117,121,117,127,113,113,122,44,126,-123,116,121,117,-128,-128,-123,121,72,72,122,44,119,-127,-127,120,-127,117,-126,109,-128,44,-126,-127,123,112,113,122,44,62,60,62,60,44,116,113,117,122,72,119,-127,-127,127,127,109,44,124,113,126,-127,127,127,-127,123,121,109,120,109,117,127,113,122,44,124,123,120,117,117,-128,117,119,123,122,44,92,113,119,119,109,44,87,109,-128,109,118,109,122,44,121,-127,126,116,109,109,44,-123,126,117,-128,-128,72,122,113,113,-128,44,119,109,119,127,117,44,121,117,113,127,-128,72,75};
      k_it->vast1 = {87,109,122,127,109,120,120,117,127,121,117,113,120,117,122,113,122,44,120,117,117,-128,-128,123,-127,121,109};
      k_it->vast2 = {95,-127,123,121,113,122,44,-126,109,127,-128,109,126,117,122,-128,109,120,117,117,119,113};
      k_it->vast3 = {95,-127,123,121,117,44,113,122,127,117,122};
      k_it->vast4 = {85,-128,127,113,122,72,117,127,113,122,44,95,-127,123,121,113,122,44,119,109,122,127,109,120,120,117,122,113,122,44,-128,109,117,127,-128,113,120,-127,126,117,122,-128,109,121,109};
      k_it->luk4 = true;
    }

    if(kountteri == 171) {
      k_it->k_luku = 26;
      k_it->kysym = {103,-125,-122,-122,127,58,-122,127,-126,126,127,-122,-122,127,58,-118,-119,-122,-125,-125,-114,-125,-123,-123,-119,58,92,127,-120,58,116,-109,-115,-123,-119,-111,-125,125,-108,58,123,-120,-114,-119,-125,58,-112,-113,-119,-120,-120,123,58,75,83,83,83,58,-126,123,123,-115,-114,123,-114,-114,127,-122,-113,-120,70,58,-121,-113,-114,-114,123,58,-123,-125,127,-122,-115,-125,58,-115,127,-120,58,-124,-113,-122,-123,123,-125,-115,-113,-120,58,-112,86,-125,-114,-114,86,127,-120,70,58,127,-114,-114,127,-125,58,-119,-122,-122,-113,-114,58,-114,-125,127,-120,-120,-109,-114,70,58,-121,-125,-120,-123,86,-122,123,-125,-115,127,-115,-114,123,58,-122,127,-126,126,127,-115,-114,86,58,-119,-120,58,-123,-109,-115,127,89};
      k_it->vast1 = {98,-113,-115,-114,-122,127,-116};
      k_it->vast2 = {108,123,-114,-114,-119};
      k_it->vast3 = {101,123,-122,-122,127};
      k_it->vast4 = {98,123,-122,-119,-119};
    }

    if(kountteri == 172) {
      k_it->k_luku = 86;
      k_it->kysym = {-84,-73,-62,-54,-65,-59,-60,-54,-73,-62,-59,-53,-70,-69,-60,118,-54,-73,-56,-63,-73,-55,-54,-53,-55,-52,-65,-56,-73,-55,-54,-59,-60,118,-58,-110,-110,-64,-59,-66,-54,-73,-64,-73,118,-86,-49,-54,-54,-65,118,-81,-62,-65,-125,-84,-65,-65,-63,-73,-56,-65,118,-63,-73,-60,-54,-59,-65,118,-53,-55,-69,-65,-60,118,-64,-59,-54,-73,-65,-60,118,-63,-65,-56,-64,-73,-73,118,-61,-53,-63,-73,-60,-73,-73,-60,-126,118,-63,-53,-60,118,-66,-110,-60,-69,-69,-60,118,-63,-59,-66,-70,-65,-55,-54,-53,-60,-69,-65,-54,-73,118,-69,-58,-110,-65,-62,-49,-64,-110,118,-52,-110,-110,-56,-65,-60,-63,-110,-49,-54,-77,-63,-55,-65,-55,-54,-110,118,-63,-110,-55,-65,-54,-69,-62,-54,-65,-65,-60,118,-69,-70,-53,-55,-63,-53,-60,-60,-73,-55,-55,-73,118,-54,-73,-65,118,-59,-65,-63,-69,-53,-70,-69,-55,-55,-73,-124,118,-93,-65,-54,-110,118,-63,-65,-56,-64,-73,-73,118,-55,-69,-53,-56,-73,-73,-52,-65,-55,-54,-73,118,-66,-110,-60,118,-69,-65,118,-63,-73,-60,-54,-73,-60,-53,-54,118,-61,-53,-63,-73,-60,-73,-73,-60,-107};
      k_it->vast1 = {-98,-69,-67,-69,-62,-126,118,120,-94,-59,-67,-65,-65,-63,-73,-60,118,-54,-65,-69,-70,-69,120};
      k_it->vast2 = {-90,-62,-53,-54,-73,-56,-63,-66,-59,-55,-126,118,120,-93,-65,-69,-62,-69,-60,118,-54,-49,-49,-60,-69,-49,-70,-69,-55,-54,-110,120};
      k_it->vast3 = {-87,-73,-73,-70,-65,-126,118,120,-88,-53,-53,-55,-53,-54,-73,-56,-66,-73,120};
      k_it->vast4 = {-91,-62,-62,-65,118,-87,-65,-60,-65,-52,-73,-73,-56,-73,-126,118,120,-90,-53,-53,-54,120};
    }

    if(kountteri == 173) {
      k_it->k_luku = 30;
      k_it->kysym = {105,-109,-121,-116,-119,127,62,-111,-109,-109,-112,-121,62,-115,-111,127,62,-117,-121,-125,-122,-121,-111,-110,90,62,-111,127,-121,-112,127,-111,-110,-109,-109,62,-119,-121,-108,-125,-119,-111,-125,-116,62,-119,-121,-125,-112,-110,-105,-117,-121,-111,-125,-125,-116,93};
      k_it->vast1 = {104,-115,-119,127,62,-116,-125,-118,-120,90,-111,-110,-109,-122,127,-116,-116,-125,-111};
      k_it->vast2 = {104,-115,-119,127,62,-119,-105,-117,-117,-125,-116,-125,-111,-110,-109,-122,127,-116,-116,-125,-111};
      k_it->vast3 = {104,-115,-119,127,62,-116,-125,-118,-120,90,-111,-111,127,-126,127,-111};
      k_it->vast4 = {104,-115,-119,127,62,-119,-105,-117,-117,-125,-116,-125,-111};
    }

    if(kountteri == 174) {
      k_it->k_luku = 49;
      k_it->kysym = {126,-102,-91,109,81,-98,-102,-106,-92,-91,-106,-97,-99,-106,-103,-91,-106,109,81,-96,-97,81,-98,-86,-86,-91,-86,81,-92,-110,-89,-96,-97,81,-98,-90,-93,-91,-106,-106,-99,-99,-106,81,-100,109,109,-97,-97,-106,-91,-91,-86,-97,109,112};
      k_it->vast1 = {121,-90,-92,-91,-99,-106,-93};
      k_it->vast2 = {-127,-99,-110,-86,-109,-96,-86};
      k_it->vast3 = {118,-93,-96,-91,-102,-102,-100,-110,-97,81,126,-110,-110,-102,-99,-98,-110};
      k_it->vast4 = {123,-110,-99,-99,-90};
      k_it->selitys = {122,-99,-98,-106,-92,-91,-86,-102,81,-100,-106,-92,109,-99,-99,109,81,98,106,106,106};
    }

    if(kountteri == 175) {
      k_it->k_luku = 60;
      k_it->kysym = {-121,-95,-86,-95,-86,92,-87,-79,-79,-81,-91,-89,-85,-86,92,-92,-95,-86,-89,-91,-78,-99,-82,-80,-91,-90,-99,-86,-99,92,-112,-85,-86,-75,92,-124,-99,-88,-87,-95,92,-80,-75,-103,-81,-89,-95,-86,-80,-95,-88,-91,123};
      k_it->vast1 = {-125,-95,-86,-95,92,-113,-91,-87,-87,-85,-86,-81};
      k_it->vast2 = {-112,-95,-96,92,-118,-79,-93,-95,-86,-80};
      k_it->vast3 = {-113,-99,-87,-87,-75,92,-124,-99,-93,-99,-82};
      k_it->vast4 = {-118,-85,-80,-85,-82,-91,-85,-79,-81,92,126,106,-123,106,-125,106};
    }

    if(kountteri == 176) {
      k_it->k_luku = 60;
      k_it->kysym = {-121,-95,-86,-95,-86,92,-81,-79,-85,-87,-99,-88,-99,-91,-81,-95,-86,92,-80,-78,105,-89,-99,-81,-78,-85,-86,92,-86,-91,-87,-95,120,92,-89,-99,-86,-80,-99,-78,-99,92,-123,-86,-80,-95,-82,-86,-95,-80,-91,-86,92,-81,-95,-89,-81,-91,-99,-91,-92,-95,-91,-86,-95,-86,92,-79,-79,-80,-91,-81,-82,-75,-92,-87,120,92,-84,-95,-82,-79,-81,-80,-95,-80,-80,-91,-91,-86,92,109,117,117,108,105,-88,-79,-78,-79,-88,-88,-99,123};
      k_it->vast1 = {125,-86,-86,-99,105,-121,-99,-91,-81,-99,92,-124,-95,-82,-87,-79,-86,-95,-86};
      k_it->vast2 = {-112,-99,-82,-79,92,-110,-99,-88,-89,-95,-99,-84,120,120};
      k_it->vast3 = {-113,-91,-82,-84,-99,92,-110,-91,-88,-90,-99,-87,-99,-99};
      k_it->vast4 = {-120,-95,-95,-86,-99,92,-121,-99,-81,-89,-95,-88,-99};
      k_it->selitys = {-99,-88,-80,106,-81,-95,-76,106,-94,-95,-80,-91,-81,-92,106,-92,-95,-82,-87,-79,-86,-95,-86};
    }

    if(kountteri == 177) {
      k_it->k_luku = 29;
      k_it->kysym = {106,-122,-119,-119,89,61,-112,-110,-116,-118,126,-119,126,-122,-112,-126,-119,-119,126,61,-115,-116,-113,-117,-116,-119,-126,-123,-127,-126,-119,-119,89,61,-116,-119,-122,61,-126,-117,-112,-122,-118,-118,89,-122,-112,-126,-117,89,61,-112,-122,-109,-110,-111,61,102,-117,-111,-126,-113,-117,-126,-111,-122,-112,-112,89,61,-109,-110,-116,-117,-117,126,61,78,86,86,81,92};
      k_it->vast1 = {101,126,-119,-116,-116};
      k_it->vast2 = {103,126,-119,-119,-110};
      k_it->vast3 = {98,-113,-116,-111,-122,-122,-120,126,-117,61,-118,126,126,-122,-119,-118,126};
      k_it->vast4 = {98,-113,-116,-111,-122,-128,126,-111,-112};
    }

    if(kountteri == 178) {
      k_it->k_luku = 66;
      k_it->kysym = {-115,-73,-83,-93,98,-79,-82,-85,98,-93,-85,-80,-73,-74,98,-72,-93,-75,-89,-81,-81,-85,-75,-74,-79,-78,-73,-79,-82,-73,-89,-85,-90,-89,-80,98,-83,-93,-80,-75,-93,-80,-89,-90,-73,-75,-74,-93,-84,-93,110,98,-84,-79,-83,-93,98,-93,-75,-89,-74,-74,-73,-85,98,-72,-93,-75,-74,-73,-75,-74,-93,-81,-93,-93,-80,98,-72,-73,-79,-90,-89,-80,98,115,123,122,121,98,-72,-85,-90,-89,-79,-82,-93,-83,-85,-93,110,98,-84,-79,-75,-75,-93,98,-83,-85,-89,-82,-82,-89,-74,-74,-85,-85,-80,98,-115,111,115,122,98,111,-72,-85,-90,-89,-79,-85,-90,-89,-80,98,-82,-89,-72,-85,-74,-74,126,-81,-85,-80,-89,-80,98,-83,-79,-83,-79,-80,-93,-93,-80,-127};
      k_it->vast1 = {-125,-76,-84,-93,98,-125,-82,-86,-79};
      k_it->vast2 = {-123,-82,-93,-89,-75,98,-125,-80,-90,-89,-76,-75,-75,-79,-80};
      k_it->vast3 = {-108,-89,-85,-80,-79,98,-110,-93,-93,-75,-85,-82,-85,-80,-80,-93};
      k_it->vast4 = {-107,-85,-80,-85,-83,-83,-93,98,-113,-97,-80,-83,126,-76,-89};
    }

    if(kountteri == 179) {
      k_it->k_luku = 70;
      k_it->kysym = {-109,-81,-70,-126,102,-75,-76,-83,-85,-78,-77,-89,-78,-78,-81,-71,-70,-89,102,-71,-81,-71,-126,-78,-70,-93,-126,102,-79,-89,-76,-71,-89,-76,-85,-86,-69,-71,-70,-89,-80,-89,102,-106,-126,-81,-68,-81,102,-104,-126,-71,-126,-71,-85,-76,102,-74,-81,-70,-126,-77,-126,-76,102,-85,-86,-69,-71,-79,-69,-76,-70,-89,-74,-69,-82,-85,-85,-76,102,-77,-69,-79,-89,-89,-76,102,-78,-93,-65,-70,-65,-65,102,126,115,119,120,102,115,-68,-69,-75,-70,-81,-89,-81,-78,-78,-85,102,-71,-69,-69,-76,-76,-89,-70,-69,-71,-70,-89,102,-118,-72,-89,-83,-75,-76,102,-120,-89,-78,-78,102,115,-71,-89,-72,-80,-89,-79,-69,-68,-89,-71,-70,-89,-123};
      k_it->vast1 = {-110,-89,-74,-71,-81,-74,-75,-72,-76,-75,-89};
      k_it->vast2 = {-114,-75,-77,-75,-71,-85,-79,-71,-69,-89,-89,-78,-81,-71,-69,-69,-70,-70,-89};
      k_it->vast3 = {-117,-78,-126,-81,-76,-74,-75,-72,-76,-75,-89};
      k_it->vast4 = {-103,-89,-86,-75,-77,-89,-71,-75,-79,-81,-71,-77,-81,-89};
      k_it->selitys = {-103,-89,-76,-75,-81,102,-77,-65,-93,-82,-85,-77,-77,-81,-76,114,102,-85,-70,-70,-85,-81,102,-75,-78,-78,-69,-70,102,-81,-70,-71,-85,102,-76,-126,-82,-76,-65,-70,102,-79,-65,-71,-85,-81,-71,-70,-126,102,-71,-89,-72,-80,-89,-79,-69,-68,-89,-89,116};
    }

    if(kountteri == 180) {
      k_it->k_luku = 20;
      k_it->kysym = {95,-119,127,117,52,127,117,-126,-121,117,-126,121,120,-119,-121,-120,117,126,117,52,-120,121,127,125,52,121,120,-119,-121,127,-119,-126,-120,117,127,-115,-121,-115,-127,-115,127,-121,121,-126,52,-124,-125,-122,-126,-125,127,-121,125,52,-118,80,125,-120,121,-120,-115,-121,-120,80,52,88,-122,117,123,-125,-126,52,86,117,-128,-128,52,65,-121,117,-122,126,117,127,-119,-118,117,-121,-120,117,52,-118,-119,-125,-126,-126,117,52,70,68,68,71,83};
      k_it->vast1 = {103,-119,-121,117,-126,-126,117,52,102,117,124,127,-125,-126,121,-126,64,52,103,88,100};
      k_it->vast2 = {86,126,117,-122,-126,121,52,95,117,-128,-128,125,-121,64,52,95,96};
      k_it->vast3 = {103,-119,-128,-125,52,85,125,-120,-120,-125,-126,125,121,-127,125,64,52,103,97,100};
      k_it->vast4 = {103,-119,-118,125,52,96,125,-126,120,56,-126,64,52,95,99,95};
      k_it->selitys = {103,117,-126,-125,125,52,-127,-115,113,124,121,-127,-127,125,-126,64,52,121,-120,-120,121,125,52,-125,-128,-128,-119,-120,52,125,-120,-121,121,52,-126,80,124,-126,-115,-120,52,127,-115,-121,121,125,-121,-120,80,52,-121,117,-122,126,117,127,-119,-118,117,117,66};
    }

    if(kountteri == 181) {
      k_it->k_luku = 90;
      k_it->kysym = {-89,-61,-56,-106,122,-48,-49,-55,-56,-56,-69,122,-45,-58,-61,122,-117,-110,-121,-48,-49,-55,-50,-61,-69,-61,-58,-58,-65,122,-51,-49,-49,-56,-56,-69,-50,-50,-49,-60,-65,-56,122,-65,-58,-55,-59,-49,-48,-61,-65,-56,122,-65,-56,-56,-69,-59,-59,-55,-50,-69,-52,-59,-69,-51,-50,-69,-57,-61,-56,-65,-56,122,-60,-69,122,-69,-61,-59,-49,-61,-51,-51,-65,-56,-51,-49,-49,-52,-61,122,-58,-55,-54,-54,-49,-61,122,-83,-49,-55,-57,-65,-51,-51,-69,-103};
      k_it->vast1 = {-116,-118,-118,-117};
      k_it->vast2 = {-116,-118,-117,-117};
      k_it->vast3 = {-117,-109,-109,-117};
      k_it->vast4 = {-117,-109,-110,-117};
    }

    if(kountteri == 182) {
      k_it->k_luku = 45;
      k_it->kysym = {122,-106,-104,105,77,-103,-110,-107,-95,-106,77,-105,-94,-103,-104,-114,-106,-96,-106,77,-99,105,105,-102,-106,-101,-106,-96,-95,-110,-97,-106,77,122,-114,-95,-95,-106,77,-125,-114,-101,-107,-114,-96,-110,-101,77,-101,-114,-106,-96,-90,-96,-95,105,-93,105,-101,105,77,-95,-94,-101,-101,-110,-95,-94,-101,77,-128,-94,-96,-114,-101,77,120,-94,-97,-100,-96,-110,-101,77,-114,-103,-114,-96,-95,-100,-101,-104,-94,-93,-114,-95,108};
      k_it->vast1 = {117,-90,-102,-90};
      k_it->vast2 = {118,-103,-95,-114,-103,-110,-107,-95,-106};
      k_it->vast3 = {110,-99,-94};
      k_it->vast4 = {121,-100,-103,-103,-100};
      k_it->luk4 = true;
    }

    if(kountteri == 183) {
      k_it->k_luku = 29;
      k_it->kysym = {106,-122,-120,89,61,-112,-120,-126,-111,-112,-122,-123,126,-123,-118,-116,61,-126,-112,-122,-122,-117,-111,-106,-122,61,-118,-122,-126,-112,-111,-126,-117,-119,-126,-123,-111,-122,-126,-117,61,-126,-113,-122,61,-120,-110,-112,-111,126,-117,-111,126,-121,-122,-126,-117,61,-106,-123,-111,-126,-122,-112,-126,-112,-112,89,61,-118,126,-122,-117,-116,-112,-120,126,-118,-115,126,-117,-121,126,-112,-112,126,61,78,86,85,77,74,-119,-110,-109,-110,-117,61,-119,-116,-115,-110,-112,-112,126,92};
      k_it->vast1 = {101,-126,-113,-113,126,61,81,84};
      k_it->vast2 = {104,126,-117,-111,-113,-122,74,103,-106,-113,-122};
      k_it->vast3 = {109,126,-112,-111,-116,-113,-122,61,112,-122,-119,-119,-122};
      k_it->vast4 = {106,-113,75,61,100,-113,126,-117,126,-127,126};
      k_it->selitys = {98,-112,-122,-111,-111,89,-121,89,-117,89,61,109,-122,-113,-120,-120,126,74,109,-126,-120,-120,126,61,109,-126,-111,-126,-119,-122,-110,-112,75};
    }

    if(kountteri == 184) {
      k_it->k_luku = 26;
      k_it->kysym = {103,-125,-122,-122,-119,-125,-120,58,-112,-125,-125,-121,127,-125,-115,127,-114,58,-112,123,-120,-126,123,-114,58,-115,-113,-119,-121,123,-122,123,-125,-115,127,-114,58,-118,-119,-116,-120,-119,-122,127,-126,126,127,-114,58,101,123,-122,-122,127,58,-124,123,58,100,123,-122,-122,-113,58,-122,-119,-118,127,-114,127,-114,-114,-125,-125,-120,89};
      k_it->vast1 = {76,74,75,79};
      k_it->vast2 = {76,74,74,79};
      k_it->vast3 = {76,74,74,74};
      k_it->vast4 = {76,74,75,74};
      k_it->selitys = {110,-113,-119,-122,-122,-119,-125,-120,58,-121,127,-120,-125,58,-123,-119,-120,-123,-113,-116,-115,-115,-125,-125,-120,58,106,-116,127,-115,-115,58,103,123,-115,-114,127,-116,-115,58,-123,-113,-115,-114,123,-120,-120,-113,-115,-109,-126,-114,-125,119,72};
    }

    if(kountteri == 185) {
      k_it->k_luku = 48;
      k_it->kysym = {125,-103,-100,-100,-97,-103,-98,80,-111,-90,-103,-97,-100,-103,-103,-92,-97,-98,80,-91,-100,-101,-97,-96,-91,-97,-100,-103,-93,-107,-98,80,-93,-107,-101,-93,-103,-98,80,-101,-103,-107,-100,-92,108,-90,108,80,-100,-111,-101,-103,80,-101,-91,-99,-97,-92,-92,-103,-103,-98,80,-125,-91,-97,-99,-107,-93,-93,-111,111};
      k_it->vast1 = {97,105,98,102};
      k_it->vast2 = {97,105,100,102};
      k_it->vast3 = {97,105,96,102};
      k_it->vast4 = {97,104,104,102};
      k_it->selitys = {124,-111,-101,-103,-111,80,-107,-103,80,-97,-100,-92,-91,80,-101,108,-87,-92,108,-98,-98,-115,-93,-93,108,80,-93,-97,-90,-107,-100,-100,-107,-92,-92,-91,80,-107,-98,108,108,80,97,105,96,96,93,-100,-91,-90,-91,-100,-100,-111};
    }

    if(kountteri == 186) {
      k_it->k_luku = 48;
      k_it->kysym = {125,-103,-100,-100,-97,-103,-98,80,-111,-90,-103,-97,-94,-103,-101,-97,-93,80,-96,-97,-103,-93,-92,-107,-92,-92,-103,-103,-98,80,-125,-91,-97,-99,-107,-98,80,-94,-103,-101,-97,-93,-100,-111,-103,-93,-92,-111,111};
      k_it->vast1 = {97,105,100,104};
      k_it->vast2 = {97,105,98,104};
      k_it->vast3 = {97,105,102,104};
      k_it->vast4 = {97,105,96,104};
    }

    if(kountteri == 187) {
      k_it->k_luku = 89;
      k_it->kysym = {-92,-50,-62,-57,-60,-70,121,-52,-50,-50,-53,-66,-59,-59,-70,121,-56,-52,-70,-59,-59,-70,121,-115,-119,-122,-112,-119,-122,-49,-50,-56,-51,-62,-70,-62,-52,-51,-70,121,-58,-62,-66,-63,-62,-52,-51,-107,121,-56,-57,121,-66,-53,-66,-60,-51,-62,-56,-63,-107,-62,-53,-62,-74,-104};
      k_it->vast1 = {-92,-56,-59,-58,-70,-52,-56,-52,-70,-59,-59,-70};
      k_it->vast2 = {-87,-50,-56,-59,-66,-59,-59,-70};
      k_it->vast3 = {-89,-66,-59,-61,-107,-52,-56,-52,-70,-59,-59,-70};
      k_it->vast4 = {-81,-62,-62,-67,-66,-52,-56,-52,-70,-59,-59,-70};
    }

    if(kountteri == 188) {
      k_it->k_luku = 47;
      k_it->kysym = {124,-104,-102,107,79,-94,-92,-98,-100,-112,-101,-112,-104,-94,-104,-94,-93,-112,79,-97,-98,-95,-99,-98,-101,-108,-105,-109,-104,-94,-93,107,79,-98,-101,-104,79,-97,-112,-95,-104,-94,-102,-92,-99,-99,-104,-101,-101,-108,79,-94,-92,-92,-99,-99,-112,-93,-93,-92,110};
      k_it->vast1 = {119,-112,-101,-98,-98};
      k_it->vast2 = {125,-112,-97,-112,-102,-88,-100,-97,-97,-104};
      k_it->vast3 = {116,-95,-98,-93,-104,-110,-112,-93,-94};
      k_it->vast4 = {116,-95,-98,-93,-104,-104,-102,-112,-99,79,124,-112,-112,-104,-101,-100,-112};
    }

    if(kountteri == 189) {
      k_it->k_luku = 8;
      k_it->kysym = {94,125,119,118,118,105,40,57,65,65,59,40,120,105,113,115,105,116,116,113,123,109,124,40,120,125,112,109,116,113,118,116,105,113,124,119,115,123,109,124,40,117,125,119,108,119,123,124,113,126,105,124,40,-127,112,124,109,109,118,116,113,113,124,124,-127,117,68,118,52,40,114,119,115,105,40,117,105,112,108,119,116,116,113,123,124,113,40,80,88,97,66,116,116,109,40,123,109,115,123,113,120,125,112,109,116,113,118,120,105,116,126,109,116,125,113,108,109,118,40,126,68,116,113,124,124,68,117,113,123,109,118,40,-127,117,120,68,122,113,40,91,125,119,117,109,105,40,114,105,40,105,116,119,113,124,124,113,40,105,116,105,118,40,106,125,125,117,113,118,54,40,85,113,116,116,68,40,118,113,117,109,116,116,68,40,124,68,117,68,40,125,125,123,113,40,126,109,122,115,115,119,40,124,125,118,118,109,124,124,113,113,118,71};
      k_it->vast1 = {83,105,125,115,119,126,109,122,115,115,119,40,97,123,113};
      k_it->vast2 = {83,105,125,115,119,116,113,118,114,105,40,94,113,113,123};
      k_it->vast3 = {86,119,116,116,105,123,105,124,105,123,105,124,105};
      k_it->vast4 = {92,109,116,109,122,113,118,115,113,40,57,56};
    }

    if(kountteri == 190) {
      k_it->k_luku = 7;
      k_it->kysym = {84,112,123,67,39,115,124,118,114,114,104,104,39,118,115,112,39,122,108,114,122,112,119,124,111,108,115,112,117,119,104,115,125,108,115,124,112,107,108,117,39,115,112,112,114,108,125,104,112,111,123,118,39,90,124,118,116,108,122,122,104,39,56,64,64,55,52,115,124,125,124,117,39,119,104,121,111,104,112,117,104,39,125,124,118,122,112,117,104,70};
      k_it->vast1 = {59,55,55,39,116,112,115,113,118,118,117,104,104,39,116,104,121,114,114,104,104};
      k_it->vast2 = {59,55,39,116,112,115,113,118,118,117,104,104,39,116,104,121,114,114,104,104};
      k_it->vast3 = {59,39,116,112,115,113,118,118,117,104,104,39,116,104,121,114,114,104,104};
      k_it->vast4 = {59,39,116,112,115,113,104,121,107,112,104,39,116,104,121,114,114,104,104};
    }

    if(kountteri == 191) {
      k_it->k_luku = 32;
      k_it->kysym = {109,-119,-117,92,64,-113,-116,-119,64,-114,-119,-115,-123,-116,-108,92,92,-114,64,104,-123,-116,-109,-119,-114,-121,-119,-114,64,112,-107,-120,-123,-116,-119,-114,-103,-120,-108,-119,125,-114,64,-106,-127,-116,-108,-127,-117,-107,-114,-114,-127,-116,-116,-119,-114,-123,-114,64,-108,-119,-123,-108,-113,-106,-123,-110,-117,-117,-113,76,64,-118,-113,-109,-109,-127,64,-112,-103,-109,-108,-103,-119,64,81,89,89,80,77,-116,-107,-106,-107,-116,-116,-127,64,-115,-115,78,64,-120,-113,-119,-108,-127,-115,-127,-127,-114,64,-112,-127,-114,-117,-117,-119,-127,-109,-119,-113,-119,-108,-127,64,-118,-127,64,-112,-123,-116,-127,-127,-115,-127,-127,-114,64,-123,-110,-113,-113,-108,-108,-119,-109,-119,-127,64,-108,-123,-117,-109,-108,-119,-112,-123,-116,-123,-118,92,76,64,-117,-107,-108,-123,-114,64,66,106,125,-110,-114,64,100,-113,-114,-114,-123,-110,64,-112,-119,-116,-106,-123,-114,-112,-119,-119,-110,-108,92,-118,92,-114,64,-120,-119,-109,-109,-119,-109,-109,92,66,95};
      k_it->vast1 = {105,-114,-122,-113,-108,-123,-116};
      k_it->vast2 = {116,-123,-116,-123,-109,-127,-115,-112,-113};
      k_it->vast3 = {116,-123,-116,-123,-110,-119,-114,-121};
      k_it->vast4 = {116,-123,-116,-114,-123,-108};
    }

    if(kountteri == 192) {
      k_it->k_luku = 24;
      k_it->kysym = {101,-127,-117,-116,84,56,125,124,-115,-117,-125,-115,-122,-116,121,-120,-115,-121,-124,-115,125,125,-117,-116,121,56,97,-122,-116,125,-118,-122,125,-116,-127,-117,-117,84,56,-120,-118,-121,126,125,-116,-121,-127,-114,121,121,56,-117,121,121,-118,-122,121,-123,-127,125,-117,56,98,-121,-115,-125,-121,56,104,-127,-128,-121,121,56,125,-127,56,-121,-124,125,56,-128,125,-127,-116,125,-116,-116,-111,56,-120,-121,-127,-117,87};
      k_it->vast1 = {104,125,-118,-115,-117,-117,-115,-121,-123,121,-124,121,-127,-117,125,-116};
      k_it->vast2 = {99,-118,-127,-117,-116,-127,-124,-124,-127,-117,124,125,-123,-121,-125,-118,121,121,-116,-127,-116};
      k_it->vast3 = {99,125,-117,-125,-115,-117,-116,121};
      k_it->vast4 = {99,-121,-125,-121,-121,-123,-115,-117};
      k_it->selitys = {104,125,-118,-115,-117,-117,-115,-121,-123,121,-124,121,-127,-117,125,-116,56,125,-127,-114,84,-116,56,-121,-116,-116,121,-122,125,125,-116,56,104,-127,-128,-121,121,56,125,124,125,-117,56,-126,84,-117,125,-122,125,-125,-117,-127};
    }

    if(kountteri == 193) {
      k_it->k_luku = 31;
      k_it->kysym = {108,-120,-115,91,63,-107,-108,-114,-115,-115,-128,63,-118,91,-104,-109,-109,91,-119,-120,-124,-115,63,-114,-116,-120,-128,63,-128,-117,-128,-110,-109,-114,-115,-118,-108,-107,-120,-128,63,-124,-110,-120,-109,-109,-124,-117,-124,-107,91,63,-128,-117,-128,-110,-109,-114,-115,-110,-108,-114,-116,-120,77,-126,-114,-116,63,76,-110,-120,-107,-108,-110,-109,-114,63,-128,-107,-128,-109,-109,-120,-120,-115,94};
      k_it->vast1 = {81,79,79,86};
      k_it->vast2 = {81,79,79,82};
      k_it->vast3 = {81,79,80,81};
      k_it->vast4 = {80,88,88,88};
    }

    if(kountteri == 194) {
      k_it->k_luku = 50;
      k_it->kysym = {127,-101,-98,-98,-95,-101,-96,82,-90,-89,-98,-101,82,-88,-95,-101,-97,-109,-109,-96,82,-98,-109,-99,-101,-97,-89,-89,-90,-95,-91,94,82,-100,-95,-99,-109,82,-90,-105,-99,-101,82,-92,-109,-96,-103,-109,-101,-91,-90,-109,-88,-109,-99,-91,-101,82,-91,-105,-99,-91,-101,-94,-109,-98,-88,-105,-98,-89,-101,-106,-105,-96,82,-97,-109,-92,-99,-99,-101,-96,-95,-101,-96,-96,-101,-96,82,-100,-109,82,-100,-95,-102,-90,-101,82,-91,-105,-99,-91,-101,-96,-97,-85,-85,-96,-90,-101,95,-101,-98,-97,-95,-101,-90,-89,-91,-90,-105,-96,82,-94,-95,-101,-91,-90,-89,-97,-101,-91,-105,-105,-96,82,-91,-89,-95,-97,-109,-98,-109,-101,-91,-101,-91,-90,-109,82,-98,-105,-102,-106,-101,-91,-90,110,113};
      k_it->vast1 = {100,98,98,102};
      k_it->vast2 = {99,107,107,107};
      k_it->vast3 = {99,107,107,102};
      k_it->vast4 = {99,107,106,107};
    }

    if(kountteri == 195) {
      k_it->k_luku = 42;
      k_it->kysym = {119,-109,-107,102,74,-104,-113,-98,-98,-109,-99,-109,-96,-97,-99,-98,-103,74,-108,-103,-97,-98,-97,-109,74,-107,-113,-99,-107,-97,-99,-100,-109,-107,-103,-99,-102,-103,-106,-109,-109,-99,-109,-104,74,-106,-117,-102,-99,-109,-102,-103,-100,-104,-103,-104,74,-113,-99,-98,-103,-106,-109,-99,-98,-117,-106,-106,-113,74,-96,-97,-103,-104,-104,-117,74,92,90,90,98,105};
      k_it->vast1 = {126,-110,-117,-109,-105,-117,-117,-104,74,-102,-100,-109,-104,-99,-113,-99,-99,-117,-104,74,-105,-97,-109,-99,-98,-103,-99,-109,-96,-97,-98};
      k_it->vast2 = {116,-117,-102,-117,-104,-109,-106,-117,-109,-99,-113,-99,-98,-117,74,-107,-109,-99,-99,-103,-108,-113,-104,74,-99,-117,-117,-100,-113,-99,-98,-117,74,-107,-113,-100,-98,-103,-96,-117,-98,74,-99,-109,-96,-97,-98};
      k_it->vast3 = {107,-107,-97,74,107,-104,-107,-107,-117,74,87,-102,-109,-109,-100,-98,102,-108,102,74,110,-103,-104,74,124,-103,-99,-117,-104,74,-107,-103,-98,-109,-99,-109,-96,-97,-98};
      k_it->vast4 = {122,-97,-103,-106,-117,-106,-117,-109,-99,-113,-104,74,-106,-109,-110,-117,-107,-117,-97,-102,-117,-104,74,-99,-109,-96,-97,-98};
    }

    if(kountteri == 196) {
      k_it->k_luku = 80;
      k_it->kysym = {-99,-71,-66,-69,-116,-68,-79,-71,-61,-60,-79,112,-67,-59,-59,-60,-79,112,-67,-79,-60,-75,-62,-71,-79,-79,-68,-71,-79,112,-67,-71,-66,-71,-61,-60,-75,-62,-71,-60,112,-75,-72,-76,-65,-60,-60,-71,-58,-79,-60,112,-69,-75,-61,-69,-59,-61,-62,-71,-69,-65,-61,-64,-65,-68,-71,-71,-61,-71,-66,112,-71,-66,-60,-75,-62,-66,-75,-60,125,-61,-71,-58,-59,-70,-75,-66,112,-75,-61,-60,-65,-68,-71,-61,-60,-79,-68,-68,-75,112,-68,-79,-64,-61,-71,-64,-65,-62,-66,-65,-66,112,-68,-71,-61,-116,-69,-61,-71,124,112,-69,-59,-66,112,-68,-71,-61,-60,-79,112,-64,-75,-62,-59,-61,-60,-75,-60,-60,-71,-71,-66,-113};
      k_it->vast1 = {-98,-75,-60,-60,-71,-64,-65,-69,-75,-62,-71,-61,-71,-58,-59,-60};
      k_it->vast2 = {-104,-59,-59,-67,-75,-69,-79,-59,-64,-64,-71,-79,-71,-76,-75,-66,112,-61,-71,-58,-59,-60};
      k_it->vast3 = {-114,-116,-62,-71,-65,-71,-69,-75,-71,-61,-60,-65,-68,-79,-71,-61,-75,-60,112,-61,-71,-58,-59,-60};
      k_it->vast4 = {-94,-116,-70,-116,-72,-60,-75,-71,-76,-75,-66,112,-58,-79,-68,-67,-71,-61,-60,-59,-61,-60,-79,112,-69,-116,-61,-71,-60,-60,-75,-68,-75,-58,-116,-60,112,-61,-71,-58,-59,-60};
    }

    if(kountteri == 197) {
      k_it->k_luku = 30;
      k_it->kysym = {105,-109,-119,127,62,-105,-118,-118,90,-114,-121,-110,90,90,62,-108,-125,-112,-119,-119,-115,-111,-125,-116,-111,-109,-109,-112,-121,127,62,-119,90,-111,-121,-110,-110,-125,-118,-125,-108,90,90,62,-118,127,-114,-111,-121,-114,-115,-112,-116,-115,76,-121,-116,-124,-115,62,75,-111,-121,-108,-109,-111,-110,-115,127,93};
      k_it->vast1 = {107,127,-110,-110,-121,62,108,-121,-119,-119,-121};
      k_it->vast2 = {96,-125,-116,-120,127,-117,-121,-116,62,113,90,-112,-119,-119,90};
      k_it->vast3 = {116,-121,-118,-118,-125,62,109,-119,-111,127,-116,-125,-116};
      k_it->vast4 = {110,-125,-110,-112,-109,-111,62,110,-125,-116,-116,127,-116,-125,-116};
    }

    if(kountteri == 198) {
      k_it->k_luku = 7;
      k_it->kysym = {84,112,117,114,67,39,117,112,116,112,122,108,122,122,67,39,123,124,114,111,118,115,116,104,115,104,112,122,108,122,122,104,39,111,118,116,118,105,104,104,121,112,122,122,104,39,93,112,111,121,108,112,107,108,117,39,119,124,111,108,108,117,113,118,111,123,104,113,104,39,91,118,124,114,118,39,72,104,115,123,118,39,114,124,125,104,123,123,112,112,117,39,125,124,118,117,117,104,39,57,55,56,63,39,115,67,119,122,112,116,67,122,122,67,39,116,112,108,122,123,67,39,123,104,114,104,116,124,114,122,108,108,117,39,112,115,116,104,117,39,119,104,112,123,104,104,70};
      k_it->vast1 = {82,112,117,110,39,82,118,117,110};
      k_it->vast2 = {74,111,118,114,115,104,107,114,118,119,119,108,117};
      k_it->vast3 = {74,115,124,105,39,73,104,106,114,107,118,118,121};
      k_it->vast4 = {91,111,108,39,90,108,106,121,108,123,39,78,104,121,107,108,117};
    }

    if(kountteri == 199) {
      k_it->k_luku = 21;
      k_it->kysym = {105,-118,-119,-128,126,127,118,53,98,122,-121,127,118,53,93,122,-121,-126,-124,-125,122,-125,53,-127,-118,-124,-128,126,-119,-119,122,-127,122,122,53,-128,-124,-127,-126,122,53,-126,122,-119,118,-127,-127,126,-126,-118,-120,126,126,-128,126,-125,53,-128,-124,-125,-120,122,-121,-119,122,126,-120,-120,118,53,-128,81,-114,-117,126,122,-125,53,-125,118,126,-120,-119,122,-125,53,-123,-118,-128,122,-118,-119,-118,-126,126,-120,-119,-114,-114,-127,126,81,53,-117,-118,-124,-120,126,-127,-119,118,53,70,78,78,78,66,71,69,69,69,67,53,98,126,-128,81,53,122,126,53,-128,-118,-118,-127,-118,53,127,-124,-118,-128,-128,-124,-124,-125,84};
      k_it->vast1 = {101,126,-126,122,-125,-119,-124,125,118,-127,-119,126,118};
      k_it->vast2 = {87,118,119,-114,-127,-124,-125,126,-125,53,125,-118,-124,-121,118};
      k_it->vast3 = {103,-124,-126,118,-125,-119,-119,126,-125,122,-125,53,124,-124,-124,-119,-119,126,-125,-124,126,-119,118};
      k_it->vast4 = {98,122,-119,118,-127,-127,126,-120,-124,-119,-118,-121,126};
    }

    if(kountteri == 200) {
      k_it->k_luku = 27;
      k_it->kysym = {104,-124,-119,-122,87,59,-114,-124,-123,124,-119,59,102,-124,-122,-122,124,59,-114,124,124,-111,-112,-113,-113,-124,59,-111,-112,-118,127,-128,-119,59,76,84,84,75,59,110,-108,-122,-114,-108,-119,59,-114,87,-111,-128,-121,59,72,-122,-124,-121,-117,124,-124,-121,-112,-114,-114,124,59,-122,124,-117,-117,124,-121,-128,-128,-121,-121,124,59,61,110,-112,-122,-122,-112,-121,124,59,113,-128,-119,-112,-122,-114,-128,-128,-119,61,90};
      k_it->vast1 = {102,-118,-121,-120,124,-119,-119,-128,-119};
      k_it->vast2 = {96,-119,-114,-124,-120,-120,87,-124,-114,-128,-119};
      k_it->vast3 = {111,-118,-124,-114,-128,-119};
      k_it->vast4 = {105,-128,-121,-123,87,-119,-119,-128,-119};
    }

    if(kountteri == 201) {
      k_it->k_luku = 72;
      k_it->kysym = {-109,-67,-77,-87,104,-108,-79,-86,-83,-70,-87,-87,-76,-79,-74,104,-77,-87,-74,-69,-87,-74,-72,-67,-73,-76,-67,-83,-83,-74,104,-83,-80,-84,-73,-77,-87,-69,104,-80,-83,-70,-124,-68,-68,-79,104,-77,-73,-80,-67,-87,104,-66,-67,-73,-84,-83,-74,104,122,120,120,123,104,-83,-84,-67,-69,-77,-67,-74,-68,-87,-66,-87,-87,-76,-79,-83,-74,104,-87,-76,-76,-87,104,-77,-87,-74,-74,-87,-68,-68,-87,-75,-87,-76,-76,-87,104,106,-66,-87,-72,-87,-87,-83,-80,-68,-73,-79,-69,-83,-74,104,-72,-83,-84,-73,-82,-79,-76,-79,-87,-74,106,104,-78,-87,104,-76,-87,-72,-69,-79,-72,-73,-70,-74,-73,-74,104,-76,-87,-79,-76,-76,-79,-69,-68,-87,-75,-79,-69,-68,-87,-121};
      k_it->vast1 = {-107,-87,-68,-68,-79,104,-108,-79,-74,-74,-87,-74,-66,-67,-73,-70,-79};
      k_it->vast2 = {-101,-79,-75,-73,104,-101,118,104,-112,-124,-75,-124,-76,-124,-79,-74,-83,-74};
      k_it->vast3 = {-101,-87,-75,-72,-73,104,-101,-63,-70,-83,-83,-74,-79};
      k_it->vast4 = {-111,-76,-77,-77,-87,104,-111,-74,-74,-87,-75,-87,-87};
    }

    if(kountteri == 202) {
      k_it->k_luku = 99;
      k_it->kysym = {-82,-40,-50,-60,-125,-50,-60,-47,-42,-60,-47,-56,-57,-40,-42,-41,-60,-51,-60,-125,-46,-47,-125,-52,-49,-48,-46,-52,-41,-41,-60,-47,-40,-41,-125,-50,-60,-47,-47,-60,-41,-41,-60,-39,-60,-47,-42,-60,-125,-52,-47,-42,-56,-42,-41,-52,-47,-125,-49,-60,-52,-49,-49,-52,-42,-41,-60,-48,-52,-42,-41,-60,-94};
      k_it->vast1 = {-92,-47,-47,-60,-125,-82,-46,-47,-41,-40,-49,-60};
      k_it->vast2 = {-78,-43,-60,-42,-125,-73,-36,-47,-50,-50,-36,-47,-56,-47};
      k_it->vast3 = {-84,-49,-50,-50,-60,-125,-82,-60,-47,-56,-43,-39,-60};
      k_it->vast4 = {-75,-46,-42,-60,-125,-80,-56,-43,-52,-49,-97,-52,-47,-56,-47};
    }

    if(kountteri == 203) {
      k_it->k_luku = 14;
      k_it->kysym = {81,119,-126,-121,59,122,115,118,-126,119,46,121,-125,-126,-127,-125,119,46,64,62,63,63,46,115,114,-125,-127,121,-125,124,-126,111,-124,111,111,122,119,115,124,46,111,122,122,111,46,126,74,74,121,111,-125,126,-125,124,121,119,-127,115,-125,114,-125,124,46,111,122,122,115,46,65,67,59,-124,-125,125,-126,119,111,119,-126,111,46,115,118,114,125,121,121,111,119,-126,111,46,111,122,111,-127,-126,125,124,121,-125,-124,119,119,124,58,46,120,125,-126,121,111,46,120,-125,122,121,111,119,-127,-126,119,119,124,46,122,115,118,114,115,-127,-127,74,60,46,91,119,124,121,74,46,126,-125,125,122,-125,115,115,124,46,115,118,114,125,121,121,111,119,-126,111,46,-126,-125,122,119,46,115,124,119,-126,115,124,46,123,-125,121,111,111,124,77};
      k_it->vast1 = {94,119,-128,111,111,-126,-126,119,126,-125,125,122,-125,115};
      k_it->vast2 = {100,111,-127,115,123,123,119,-127,-126,125,122,119,119,-126,-126,125};
      k_it->vast3 = {94,115,-128,-125,-127,-127,-125,125,123,111,122,111,119,-127,115,-126};
      k_it->vast4 = {100,119,118,-128,115,74,46,122,119,119,-126,-126,125};
      k_it->selitys = {92,115,122,120,74,46,126,119,-128,111,111,-126,115,119,-127,-126,111,58,46,121,125,122,123,115,46,100,111,-127,115,123,123,119,-127,-126,125,122,119,119,-126,125,-127,-126,111,58,46,-121,121,-127,119,46,-124,119,118,-128,115,119,-127,-126,74};
    }

    if(kountteri == 204) {
      k_it->k_luku = 2;
      k_it->kysym = {77,119,109,99,34,117,103,119,116,99,99,120,107,117,118,99,34,103,107,34,113,110,110,119,118,34,79,123,116,109,109,123,34,47,110,103,106,102,103,112,34,120,99,109,107,113,106,99,106,111,113,65};
      k_it->vast1 = {77,99,116,107,34,73,107,105,105,103,110,117,113,112};
      k_it->vast2 = {79,123,123,112,118,107,111,107,103,117,34,79,123,112,118,118,107,112,103,112};
      k_it->vast3 = {84,113,101,109,123};
      k_it->vast4 = {82,103,116,99,34,82,103,116,120,113};
    }

    if(kountteri == 205) {
      k_it->k_luku = 49;
      k_it->kysym = {126,-102,-97,-100,109,-98,-110,-110,-99,-110,-102,-92,-106,-97,81,-99,-106,-103,-107,-106,-97,81,-92,-90,-96,-98,-110,-99,-110,-102,-97,-106,-97,81,-89,-106,-93,-92,-102,-96,81,-96,-99,-102,81,-110,-99,-110,-95,109,109,-103,-90,-90,-98,-96,-93,-102,-92,-91,-110,-110,-97,81,-91,-90,-97,-97,-106,-91,-91,-90,81,126,-86,-93,-100,-100,-86,112};
      k_it->vast1 = {127,-96,-93,-101,-110,-99,-110,-102,-92,-106,-97};
      k_it->vast2 = {115,-106,-99,-104,-102,-110,-99,-110,-102,-92,-106,-97};
      k_it->vast3 = {121,-96,-99,-99,-110,-97,-91,-102,-99,-110,-102,-92,-106,-97};
      k_it->vast4 = {-124,-110,-100,-92,-110,-99,-110,-102,-92,-106,-97};
      k_it->selitys = {-124,-90,-96,-98,-110,-99,-110,-102,-97,-106,-97,81,-89,-106,-93,-92,-102,-96,81,-97,-96,-93,-101,-110,-99,-110,-102,-92,-106,-92,-91,-110,81,-127,-86,-91,-96,-97,81,94,-99,-106,-103,-107,-106,-92,-91,109};
    }

    if(kountteri == 206) {
      k_it->k_luku = 26;
      k_it->kysym = {103,-125,-115,-115,86,58,-115,-123,127,-114,-115,-125,-119,-126,-124,127,-122,-121,123,-115,-115,123,58,-120,86,-126,-114,-125,-125,-120,58,-126,123,-126,-121,-119,58,109,127,-123,-115,-125,-118,-113,-126,127,-122,-125,-120,58,103,123,-116,-124,123,-114,-114,123,89};
      k_it->vast1 = {101,-113,-121,-121,127,-122,-125};
      k_it->vast2 = {102,123,-118,-125,-120,-122,123,-126,126,127,-120,58,102,-125,-120,-120,-113,-114};
      k_it->vast3 = {112,-125,-120,-114,-125,119,-114};
      k_it->vast4 = {110,123,124,-113};
    }

    if(kountteri == 207) {
      k_it->k_luku = 62;
      k_it->kysym = {-117,-89,-79,-79,122,94,-79,-87,-93,-78,-79,-89,-83,-90,-88,-93,-86,-85,-97,-79,-79,-97,94,-97,-84,-84,-93,-78,-78,-89,-89,-84,94,-76,-89,-84,-87,-87,-93,-88,122,94,-84,-97,-85,-77,-79,-93,-78,122,-84,122,94,-78,-83,-89,-85,-89,-85,-89,-79,-93,-93,-84,125};
      k_it->vast1 = {-118,-97,-82,-89,-84,-86,-97,-90,-94,-93,-84,94,-118,-89,-84,-84,-77,-78};
      k_it->vast2 = {-116,-93,-77,-80,-83,-76,-89,-79,-89,-83};
      k_it->vast3 = {-110,-97,-96,-77};
      k_it->vast4 = {-111,-83,-89,-94,-89,-84,-85,-93,-84,-83,-78};
    }

    if(kountteri == 208) {
      k_it->k_luku = 78;
      k_it->kysym = {-103,-61,-71,-81,110,-71,-81,-68,-63,-81,-68,-77,-78,-61,-63,-62,-81,-72,-81,110,-62,-77,-71,-73,110,-60,-61,-67,-68,-68,-81,110,-128,126,126,127,110,-71,-73,-64,-72,-81,-70,-70,-73,-63,-77,-68,110,-71,-57,-63,-57,-69,-57,-71,-63,-77,-68,110,112,-81,-70,-81,123,-81,-64,-60,-67,-73,-63,-73,-63,-62,-81,110,-72,-61,-70,-71,-81,-73,-63,-61,-73,-63,-62,-81,112,110,-69,-81,-73,-68,-73,-62,-77,-68,110,-77,-63,-73,-69,-77,-64,-71,-73,-71,-63,-73,110,-101,-57,-64,-71,-71,-57,123,-70,-77,-74,-78,-77,-68,122,110,-72,-67,-71,-81,110,112,-81,-68,-62,-81,-81,110,-68,-61,-67,-64,-73,-70,-70,-77,110,-81,-73,-60,-81,-68,110,-60,-118,-118,-64,-118,-68,-70,-81,-73,-63,-77,-68,110,-71,-61,-60,-81,-68,110,-63,-77,-71,-63,-61,-81,-81,-70,-73,-63,-61,-61,-78,-77,-63,-62,-81,112,-115};
      k_it->vast1 = {-102,-77,-77,-68,-81,110,-96,-81,-61,-74,-81,-70,-81};
      k_it->vast2 = {-95,-61,-70,-67,110,-113,-73,-62,-62,-67,-68,-73,-77,-69,-73};
      k_it->vast3 = {-103,-73,-69,-69,-67,110,-103,-73,-70,-72,-61,-68,-77,-68};
      k_it->vast4 = {-102,-77,-77,-81,110,-106,-73,-70,-62,-61,-68,-77,-68};
      k_it->selitys = {-106,-118,-68,-77,-68,110,-66,-61,-67,-70,-61,-77,-77,-68,-63,-81,110,-67,-70,-73,110,-103,-64,-73,-63,-62,-73,-70,-70,-73,-68,-77,-68,110,-70,-73,-73,-62,-62,-67};
    }

    if(kountteri == 209) {
      k_it->k_luku = 92;
      k_it->kysym = {-87,-59,-49,-49,-104,124,-55,-59,-63,-49,-48,-63,-54,-56,-63,-60,-64,-63,-49,-49,-104,124,-53,-56,-59,124,-63,-50,-59,-57,-49,-63,-63,-54,124,-60,-53,-55,-53,-59,-56,-56,-63,124,-48,-67,-50,-57,-53,-59,-48,-63,-48,-48,-47,124,-56,-59,-59,-48,-63,-101};
      k_it->vast1 = {-89,-67,-56,-56,-63};
      k_it->vast2 = {-90,-67,-56,-56,-47};
      k_it->vast3 = {-95,-50,-53,-48,-59,-59,-57,-67,-54,124,-55,-67,-67,-59,-56,-55,-67};
      k_it->vast4 = {-92,-67,-56,-53,-53};
    }

    if(kountteri == 210) {
      k_it->k_luku = 84;
      k_it->kysym = {-95,-67,-56,-112,116,-68,-55,-55,-63,-71,-56,-56,-75,116,-57,-55,-61,-63,-75,-64,-75,-67,-57,-71,-56,116,-61,-54,-75,-56,116,-65,-61,-65,-71,-67,-64,-64,-71,-71,-56,116,-56,-61,-67,-57,-71,-65,-57,-67,116,-55,-57,-71,-67,-63,-63,-67,-62,116,-65,-75,-62,-62,-75,-74,-67,-65,-57,-71,-62,116,-66,-112,-64,-65,-71,-71,-62,-109,116,124,-122,-124,-123,-116,116,-56,-67,-64,-75,-57,-56,-61,125};
      k_it->vast1 = {-90,-75,-55,-68,-61,-67,-56,-56,-75,-54,-75,-56,116,-64,-112,-112,-65,-65,-71,-71,-56};
      k_it->vast2 = {-107,-63,-70,-71,-56,-75,-63,-67,-67,-62,-67};
      k_it->vast3 = {-97,-61,-65,-75,-67,-67,-62,-67};
      k_it->vast4 = {-103,-65,-57,-56,-75,-75,-57,-67};
    }

    if(kountteri == 211) {
      k_it->k_luku = 98;
      k_it->kysym = {-81,-53,-51,-98,-126,-47,-50,-53,-40,-61,-42,-126,-40,-41,-47,-48,-48,-61,-126,-108,-110,-108,-110,-126,-93,-50,-51,-47,-48,-126,-42,-47,-53,-49,-53,-42,-41,-43,-52,-47,-54,-42,-61,-52,-61,-48,-126,-51,-41,-41,-51,-61,-41,-43,-53,-61,-48,-43,-53,-47,-42,-126,-118,-46,-61,-50,-51,-51,-61,-126,-60,-47,-48,-41,-51,-43,-53,-48,-57,-57,-48,-117,-95};
      k_it->vast1 = {-107,-105,-126,-110,-110,-110,-126,-57,-41,-44,-47,-61};
      k_it->vast2 = {-104,-105,-126,-110,-110,-110,-126,-57,-41,-44,-47,-61};
      k_it->vast3 = {-101,-105,-126,-110,-110,-110,-126,-57,-41,-44,-47,-61};
      k_it->vast4 = {-109,-105,-126,-110,-110,-110,-126,-57,-41,-44,-47,-61};
      k_it->selitys = {-106,-108,-110,-126,-110,-110,-110,-126,-57,-41,-44,-47,-61,-126,-40,-41,-47,-58,-57,-43,-43,-61};
    }

    if(kountteri == 212) {
      k_it->k_luku = 35;
      k_it->kysym = {110,-104,-116,-111,-114,-124,67,-112,-110,-111,-120,-111,-124,67,-103,-104,-110,-121,-120,-111,67,-115,-104,-117,-113,-124,-109,95,-116,-103,95,-111,95,67,100,-113,-114,-110,67,-110,-111,67,-114,-116,-116,-111,-111,-116,67,75,85,83,85,84,76,98,67};
      k_it->vast1 = {91};
      k_it->vast2 = {88};
      k_it->vast3 = {84,83};
      k_it->vast4 = {84,85};
    }

    if(kountteri == 213) {
      k_it->k_luku = 29;
      k_it->kysym = {104,-110,-122,-117,-120,126,61,-112,-110,-110,-113,-122,61,-116,-112,126,61,79,82,74,80,81,74,-109,-110,-116,-111,-122,126,-122,-112,-111,126,61,-112,-110,-116,-118,126,-119,126,-122,-112,-122,-112,-111,126,61,-116,-117,61,-120,-116,-120,-126,-122,-119,-119,-110,-111,61,-120,126,-117,-117,126,127,-122,-112,-111,126,92,61,69,79,77,78,85,61,-111,-122,-119,126,-112,-111,-116,70};
      k_it->vast1 = {81,81,61,66};
      k_it->vast2 = {80,81,61,66};
      k_it->vast3 = {83,81,61,66};
      k_it->vast4 = {84,81,61,66};
    }

    if(kountteri == 214) {
      k_it->k_luku = 79;
      k_it->kysym = {-102,-60,-72,-67,-70,-80,111,-62,-60,-60,-63,-72,111,-66,-62,-80,111,-62,-60,-66,-68,-80,-69,-80,-72,-62,-72,-62,-61,-80,111,-66,-67,111,-70,-66,-70,-76,-72,-69,-69,-60,-61,111,-76,-70,-62,-61,-80,-80,-62,-72,-80,-114,111,119,-127,127,-128,-121,111,-61,-72,-69,-80,-62,-61,-66,120};
      k_it->vast1 = {-124,111,116};
      k_it->vast2 = {-127,111,116};
      k_it->vast3 = {-120,111,116};
      k_it->vast4 = {-128,-122,111,116};
    }

    if(kountteri == 215) {
      k_it->k_luku = 61;
      k_it->kysym = {-122,-85,-79,-94,-81,-85,-94,-79,106,-83,-94,-81,-80,-84,-84,-85,-98,93,-89,-98,93,-80,-98,-98,-81,-85,-98,-98,-89,-98,93,-121,-84,-78,-88,-84,93,-115,-90,-91,-84,93,-84,-85,93,-98,-85,-79,-98,-85,-78,-79,93,-86,-84,-85,-90,-98,93,-83,-81,-84,-93,-94,-79,-90,-84,-90,-79,-98,107,93,-118,-90,-88,121,93,-80,-94,-78,-81,-98,-98,-77,-90,-80,-79,-98,93,-94,-90,93,-84,-87,-94,93,-91,121,-85,-94,-85,93,-83,-81,-84,-93,-94,-79,-90,-98,-85,-80,-98,124};
      k_it->vast1 = {-111,-98,-86,-83,-94,-81,-94,-94,-80,-79,-98,93,-79,-78,-87,-94,-94,93,-83,121,121,-88,-98,-78,-83,-78,-85,-88,-90};
      k_it->vast2 = {-112,-78,-78,-81,106,-112,-78,-84,-86,-90,93,-80,-74,-85,-79,-74,-74};
      k_it->vast3 = {-127,-84,-85,-98,-87,-95,93,-111,-81,-78,-86,-83,93,-83,121,121,-80,-94,-94,93,-106,-91,-95,-74,-80,-77,-98,-87,-79,-98,-90,-85,93,-83,-81,-94,-80,-90,-95,-94,-85,-79,-90,-88,-80,-90,93,-79,-84,-90,-80,-94,-87,-87,-94,93,-88,-98,-78,-95,-94,-87,-87,-94};
      k_it->vast4 = {-118,-90,-88,-98,93,-123,121,-88,-88,-90,-85,-94,-85,93,-77,-84,-90,-79,-79,-98,-98,93,-125,-84,-81,-86,-78,-87,-98,93,110,93,106,-86,-94,-80,-79,-98,-81,-78,-78,-95,-94,-85};
    }

    if(kountteri == 216) {
      k_it->k_luku = 29;
      k_it->kysym = {106,-122,-112,-112,89,61,114,112,94,87,-117,61,109,-119,126,-106,127,-116,-106,-117,61,-117,-110,-118,-126,-113,-116,-112,-112,126,61,104,126,-111,126,61,104,89,-113,-120,-120,89,-122,-117,-126,-117,61,-116,-119,-122,61,-120,-110,-110,-120,126,-110,-127,-126,-117,61,-115,-119,126,-106,-118,126,-111,-126,-117,126,92};
      k_it->vast1 = {78,86,85,85,61,-121,-116,-110,-119,-110,-120,-110,-110};
      k_it->vast2 = {78,86,85,86,61,-121,-116,-110,-119,-110,-120,-110,-110};
      k_it->vast3 = {78,86,85,84,61,-126,-119,-116,-120,-110,-110};
      k_it->vast4 = {78,86,86,77,61,-126,-119,-116,-120,-110,-110};
    }

    if(kountteri == 217) {
      k_it->k_luku = 28;
      k_it->kysym = {105,-123,-118,-121,88,60,-113,-111,-111,-114,-111,-111,-113,-120,-111,-117,-121,125,-118,60,-113,-111,-119,-119,125,60,-114,125,-124,125,125,60,68,-119,125,-114,-121,-117,-123,-121,-113,-123,60,-119,-111,-111,-118,-118,-127,-112,-112,-111,-118,125,69,60,103,125,-112,125,60,103,88,-114,-121,-121,88,-123,-113,-127,-120,-120,-127,60,-119,125,-121,-113,-127,-112,-112,-123,-123,-118,60,125,-123,-121,125,-118,125,125,-118,60,113,111,93,86,-118,60,108,-120,125,-107,126,-117,-107,-118,60,-121,-127,-113,-121,-123,125,-111,-121,-127,125,-119,125,-121,-111,-110,-123,-113,-112,125,91};
      k_it->vast1 = {77,76,76,60,76,76,76,60,-119,125,-114,-121,-121,125,125};
      k_it->vast2 = {77,60,76,76,76,60,76,76,76,60,-119,125,-114,-121,-121,125,125};
      k_it->vast3 = {81,76,60,76,76,76,60,-119,125,-114,-121,-121,125,125};
      k_it->vast4 = {81,76,76,60,76,76,76,60,-119,125,-114,-121,-121,125,125};
    }

    if(kountteri == 218) {
      k_it->k_luku = 50;
      k_it->kysym = {127,-101,-99,-91,-101,82,125,-109,-90,-109,82,125,110,-92,-99,-99,110,-101,-96,-105,-96,82,-88,-101,-105,-90,-101,-101,-96,82,-91,-109,-101,-92,-109,-109,-98,-109,-109,-96,82,-126,-98,-109,-85,-108,-95,-85,95,-98,-105,-102,-106,-105,-96,82,-95,-97,-101,-91,-90,-109,-100,-109,-96,82,122,-89,-103,-102,82,122,-105,-104,-96,-105,-92,-101,-96,82,-99,-109,-92,-90,-109,-96,-95,-98,-90,-109,113};
      k_it->vast1 = {115,-94,-101,-96,-109,82,-94,-89,-92,-101};
      k_it->vast2 = {-126,-109,-94,-89,-99,-109,-101,-100,-109,82,-96,110,-85,-99,-99,110,-91,-101};
      k_it->vast3 = {125,-101,-91,-91,-109,82,-92,-109,-109,-90,-105,-98,-101};
      k_it->vast4 = {122,-105,-88,-95,-96,-105,-96,82,-94,-95,-90,-99,-109,-101,-91,-101};
    }

    if(kountteri == 219) {
      k_it->k_luku = 77;
      k_it->kysym = {-102,-74,-72,-119,109,-68,-71,-74,109,-93,-78,-74,-72,-72,-82,-62,-64,109,-100,-58,-121,-69,109,-75,-82,-73,-82,-64,-74,-73,-68,-74,-63,-78,-63,-63,-62,-73,-78,-69,109,-67,-78,-71,-74,-82,-62,-63,-68,-70,-82,-82,-63,-63,-74,-78,-69,109,-70,-119,-119,-65,-119,109,-61,-62,-68,-79,-78,-69,109,127,125,126,-122,109,-71,-68,-67,-62,-64,-64,-82,121,109,-73,-68,-69,-72,-82,109,-73,-119,-71,-72,-78,-78,-69,109,-69,-74,-74,-63,-119,109,-82,-71,-78,-63,-63,-74,-74,-69,109,-61,-119,-75,-78,-69,-63,-119,-119,-116};
      k_it->vast1 = {126,-123,109,-126,125,125};
      k_it->vast2 = {-123,109,-126,125,125};
      k_it->vast3 = {127,109,-126,125,125};
      k_it->vast4 = {126,127,109,-126,125,125};
    }

    if(kountteri == 220) {
      k_it->k_luku = 88;
      k_it->kysym = {-93,-51,-61,-71,120,-62,-51,-57,-58,-53,-63,120,-85,-67,-48,-57,-68,-51,-53,120,-123,-57,-64,-62,-67,-60,-59,-71,-71,120,-58,-67,-60,-57,-53,-61,-71,-58,-71,-50,-71,-60,-60,-71,-105};
      k_it->vast1 = {-86,-71,-63,-62,-71,120,-103,-51,-67,-54,-61,-57,-53,-61,-63};
      k_it->vast2 = {-91,-63,-54,-62,-71,120,-89,-62,-71,-54,-67,-53};
      k_it->vast3 = {-96,-71,-58,-58,-67,-60,-67,120,-84,-71,-63,-58,-63,-57};
      k_it->vast4 = {-88,-63,-71,120,-81,-67,-53,-52,-67,-54,-65,-126,-54,-68};
    }

    if(kountteri == 221) {
      k_it->k_luku = 9;
      k_it->kysym = {86,114,117,117,120,114,119,41,92,126,120,118,110,119,41,84,106,119,119,106,107,114,124,-126,113,109,114,124,125,-126,124,41,121,110,123,126,124,125,110,125,125,114,114,119,72};
      k_it->vast1 = {58,66,66,58};
      k_it->vast2 = {58,66,65,58};
      k_it->vast3 = {58,66,64,58};
      k_it->vast4 = {59,57,57,58};
    }

    if(kountteri == 222) {
      k_it->k_luku = 61;
      k_it->kysym = {-120,-78,-88,-98,93,-79,-90,-94,-79,-84,-79,-94,-88,-85,-90,-90,-88,-98,-85,93,-98,-86,-86,-98,-79,-79,-90,-87,-98,-90,-85,-94,-85,93,-84,-85,93,-84,-87,-87,-78,-79,93,-112,-78,-84,-86,-94,-85,93,-120,-98,-85,-85,-98,-97,-90,-80,-74,-91,-95,-90,-80,-79,-74,-88,-80,-94,-85,93,-83,-90,-79,-88,121,-98,-90,-88,-98,-90,-85,-94,-85,93,-83,-78,-91,-94,-94,-85,-89,-84,-91,-79,-98,-89,-98,124};
      k_it->vast1 = {-111,-90,-86,-84,93,-119,-98,-81,-86,-94,-87,-98};
      k_it->vast2 = {-118,-90,-88,-88,-84,93,-123,-74,-83,-83,-102,-85,-94,-85};
      k_it->vast3 = {126,-81,-90,93,-119,-94,-86,-86,-88,-94};
      k_it->vast4 = {-111,-98,-79,-78,93,-106,-87,-102,-85,-94,-85};
    }

    if(kountteri == 223) {
      k_it->k_luku = 12;
      k_it->kysym = {89,117,127,-128,72,44,109,127,-128,117,44,120,72,72,119,72,126,117,-128,44,123,-126,109,-128,44,95,-127,123,121,113,127,127,109,44,-126,123,117,122,113,113,-128,44,121,72,72,126,72,-128,72,44,119,109,122,122,109,110,117,127,-128,109,75};
      k_it->vast1 = {62,60,60,68};
      k_it->vast2 = {62,60,61,68};
      k_it->vast3 = {62,60,61,64};
      k_it->vast4 = {62,60,60,64};
    }

    if(kountteri == 224) {
      k_it->k_luku = 40;
      k_it->kysym = {117,-111,-108,-108,100,72,-98,-99,-105,-101,-111,-109,-95,-107,-107,-115,-106,-115,-108,-108,100,72,-109,-119,-106,-106,-119,-118,-111,-101,72,-98,-119,-109,-111,-111,-106,-100,-99,-111,72,123,-99,-105,-107,-115,-101,-101,-119,72,-95,-112,-116,-115,-109,-101,-111,72,-109,-115,-101,-109,-115,-111,-101,-111,-101,-100,100,72,-104,100,-111,-112,-100,-115,-111,-101,-100,100,103};
      k_it->vast1 = {89,97,94,88,85,-108,-99,-98,-99,-108,-108,-119};
      k_it->vast2 = {89,97,93,88,85,-108,-99,-98,-99,-108,-108,-119};
      k_it->vast3 = {89,97,91,88,85,-108,-99,-98,-99,-108,-108,-119};
      k_it->vast4 = {89,97,96,88,85,-108,-99,-98,-99,-108,-108,-119};
    }

    if(kountteri == 225) {
      k_it->k_luku = 63;
      k_it->kysym = {-118,-76,-88,-83,-86,-96,95,-84,-82,-83,-92,-83,95,-92,-86,-78,-77,-96,-96,-78,-88,-77,-96,-95,-85,-92,-77,-88,-83,95,-89,-96,-85,-85,-76,-78,-78,-96,-81,-88,-93,-82,-78,-77,-96,95,-82,-89,-87,-92,-88,-78,-77,-92,-77,-96,-96,-83,95,-96,-83,-77,-96,-84,-96,-96,-83,95,-75,-96,-83,-86,-92,-76,-78,-79,-96,-83,-90,-96,-88,-78,-77,-76,-78,126};
      k_it->vast1 = {115,111};
      k_it->vast2 = {115};
      k_it->vast3 = {115,111,111};
      k_it->vast4 = {115,111,111,111};
    }

    if(kountteri == 226) {
      k_it->k_luku = 54;
      k_it->kysym = {-127,-85,-97,-92,-95,-105,86,-93,-91,-92,-101,-92,86,-126,-119,122,99,-105,-92,-92,-91,-95,-87,-101,-92,86,-98,-105,-94,-94,-85,-87,-87,-105,-90,-97,-102,-91,-87,-86,-105,86,-91,-98,-96,-101,-97,-87,-86,-101,-86,-105,-105,-92,86,-105,-92,-86,-105,-93,-105,-105,-92,86,-84,-105,-92,-95,-101,-85,-87,-88,-105,-92,-99,-105,-97,-87,-86,-85,-87,117};
      k_it->vast1 = {106,102};
      k_it->vast2 = {106,102,102,102,102};
      k_it->vast3 = {106,102,102};
      k_it->vast4 = {106,102,102,102};
    }

    if(kountteri == 227) {
      k_it->k_luku = 72;
      k_it->kysym = {-109,-67,-79,-74,-77,-87,104,-75,-73,-74,-83,-74,104,-80,-83,-70,-73,-79,-79,-74,-79,117,-81,-70,-87,-75,-75,-87,-74,104,-80,-87,-76,-76,-67,-69,-69,-87,-72,-79,-68,-73,104,-77,-87,-68,-69,-73,-68,-87,-87,-74,104,-63,-76,-83,-83,-74,-69,-124,104,-68,-91,-70,-77,-83,-124,-77,-69,-79,104,-80,-67,-67,-75,-87,-67,-69,-87,-79,-74,-83,-70,-79,-77,-73,-77,-69,-83,-77,-69,-79,-121};
      k_it->vast1 = {121,125};
      k_it->vast2 = {121,120,120};
      k_it->vast3 = {125,120};
      k_it->vast4 = {125};
    }

    if(kountteri == 228) {
      k_it->k_luku = 93;
      k_it->kysym = {-86,-58,-53,-56,-103,125,-48,-46,-52,-54,-66,-55,-66,-58,-48,-62,-53,125,-51,-52,-49,-53,-52,-55,-62,-59,-63,-62,-53,125,-56,-52,-55,-54,-52,-48,-53,-46,-54,-62,-49,-52,125,-52,-55,-58,125,-45,-66,-49,-46,-48,-47,-62,-47,-47,-46,125,-59,-66,-57,-46,-55,-55,-66,125,-57,-66,125,-66,-58,-59,-62,-46,-47,-47,-58,125,-56,-58,-52,-48,-56,-62,-58,-55,-55,-66,125,-48,-46,-46,-49,-62,-53,125,-52,-48,-47,-52,-49,-42,-53,-47,-103,-42,-56,-48,-62,-53,-100};
      k_it->vast1 = {-94,-49,-52,-47,-58,-64,-66};
      k_it->vast2 = {-81,-66,-47,-47,-52};
      k_it->vast3 = {-78,-49,-56,-56,-58};
      k_it->vast4 = {-87,-52,-55,-55,-52};
    }

    if(kountteri == 229) {
      k_it->k_luku = 14;
      k_it->kysym = {89,-125,121,111,46,-125,-125,-126,119,-127,-126,115,124,122,-125,121,119,120,111,46,-127,111,119,46,-124,-125,125,124,124,111,46,64,62,63,62,46,126,125,-126,121,-125,-126,46,103,90,83,122,-126,74,46,-124,119,122,111,-125,-126,115,-126,-126,-125,111,111,124,46,125,122,-125,-126,126,-125,122,122,125,111,46,115,124,117,122,111,124,124,119,124,121,119,115,122,119,-127,-126,115,124,46,-125,-125,-126,119,-127,-126,115,124,46,-127,-125,125,-128,111,-127,-127,111,46,122,74,118,115,-126,-121,121,-127,115,-127,-127,74,77};
      k_it->vast1 = {89,119,123,123,125,46,101,119,122,-127,121,111};
      k_it->vast2 = {86,115,119,121,121,119,46,90,-125,121,119,124,123,111,111};
      k_it->vast3 = {83,-127,121,125,46,98,125,123,123,125,122,111};
      k_it->vast4 = {79,-128,-126,125,46,92,-125,-128,123,119};
    }

    if(kountteri == 230) {
      k_it->k_luku = 45;
      k_it->kysym = {120,-94,-106,-101,-104,-114,77,-99,-114,-103,-105,-100,-101,77,-106,-107,-102,-106,-96,-106,105,77,-104,-94,-100,-103,-106,77,-128,-94,-100,-102,-110,-101,77,-96,-94,-94,-97,-106,-101,-114,77,-101,105,-103,-104,105,-93,-94,-100,-96,-106,-101,-114,77,94,101,99,99,90,94,101,99,101,108};
      k_it->vast1 = {94,98,93,77,93,93,93};
      k_it->vast2 = {97,98,93,77,93,93,93};
      k_it->vast3 = {101,93,93,77,93,93,93};
      k_it->vast4 = {101,93,77,93,93,93};
    }

    if(kountteri == 231) {
      k_it->k_luku = 21;
      k_it->kysym = {98,126,125,126,-125,53,-123,81,126,125,-119,122,122,-120,122,122,-125,53,107,122,-120,118,66,98,118,-119,-119,126,53,97,-124,126,-121,126,-125,53,-117,-118,-124,-125,-125,118,53,70,78,76,70,53,126,-127,-126,122,-120,-119,-114,-125,122,122,-125,53,121,122,119,-114,-114,-119,-119,126,-127,122,-117,-114,-125,53,55,73,64,71,69,55,53,-125,126,-126,126,53,-117,126,126,-119,-119,118,118,84};
      k_it->vast1 = {96,118,-125,-125,118,119,126,-128,-120,122,122,-125};
      k_it->vast2 = {86,-127,-128,-124,125,-124,-127,126,126,-125};
      k_it->vast3 = {86,-126,123,122,-119,118,-126,126,126,-125,126,126,-125};
      k_it->vast4 = {96,-124,-128,118,126,126,-125,126,126,-125};
      k_it->selitys = {96,122,-127,-127,-124,-125,118,126,-128,118,53,73,79,71,69,53,-123,-126,65,53,127,-124,-127,-127,-124,126,-125,53,-126,118,-121,126,125,-118,118,-125,118,66,-120,81,-119,-128,81,-119,53,-126,122,122,-126,126,-125,53,-126,-118,-128,118,118,-125,53,-120,-114,-119,-114,-119,122,-119,81,81,-125};
    }

    if(kountteri == 232) {
      k_it->k_luku = 86;
      k_it->kysym = {-95,-53,-63,-73,118,-62,-69,-52,-49,-54,-54,-65,118,-52,-53,-59,-60,-60,-73,118,-121,-113,-115,-114,118,-63,-73,-58,-58,-73,-62,-69,-69,-60,118,120,-90,-65,-62,-52,-69,-69,118,-58,-65,-62,-52,-69,-69,120,-107};
      k_it->vast1 = {-96,-53,-65,-71,-69,118,-94,-69,-55,-63,-65,-60,-69,-60};
      k_it->vast2 = {-102,-73,-52,-69,118,-94,-65,-60,-70,-66,-59,-62,-61};
      k_it->vast3 = {-86,-53,-59,-61,-73,-56,-65,118,-92,-53,-56,-61,-65,-59};
      k_it->vast4 = {-95,-73,-56,-65,118,-90,-69,-65,-54,-55,-73,-61,-59};
    }

    if(kountteri == 233) {
      k_it->k_luku = 45;
      k_it->kysym = {120,-110,-101,-110,-101,77,-103,-110,-93,-90,-95,-95,105,-102,105,77,-104,-114,-99,-99,-114,-103,-110,77,-100,-101,77,79,117,-114,-102,-99,-99,-94,-104,-114,-94,-99,-94,-101,-104,-106,79,108};
      k_it->vast1 = {120,-114,-99,-95,-110,-110,-101,-106,77,107,90,-101,-106};
      k_it->vast2 = {-128,-100,-94,-103,77,112,-114,-99,-95,-114,-106,-101,77,111,-114,-101,-111};
      k_it->vast3 = {123,-100,-99,-96,-114,-105,-114,-103,-104,-114};
      k_it->vast4 = {119,-94,-104,-104,-114,77,125,-100,-106,-104,-114,77,-105,-114,77,120,-100,-102,-99,-100,-96,-95,-106,-104,-100,-99,-103,-114};
    }

    if(kountteri == 234) {
      k_it->k_luku = 87;
      k_it->kysym = {-94,-52,-62,-72,119,-86,-52,-58,-60,-68,-59,119,-60,-52,-54,-64,-64,-62,-62,-64,-68,-61,-109,-60,-109,-59,119,-54,-52,-52,-55,-64,-54,-53,-72,119,-51,-72,-64,-62,-52,-53,-53,-72,-63,-64,-54,-53,-72,119,-62,-68,-55,-53,-58,-64,119,-72,-64,-62,-72,-59,-72,-72,-59,119,-61,-68,-65,-69,-64,-54,-54,-109,119,-54,-109,-51,-68,-61,-53,-109,-51,-109,-59,-54,-109,119,-63,-72,119,-54,-58,-64,-53,-53,-72,-51,-72,-59,-54,-72,119,-52,-54,-68,-64,-59,119,-60,-72,-55,-64,-65,-52,-72,-59,-72,-59,119,-51,-72,-64,-62,-52,-53,-52,-62,-54,-68,-59,119,-72,-61,-72,-64,-54,-68,-59,-72,-106};
      k_it->vast1 = {-97,-68,-59,-55,-64,-62,119,-90,-53,-53,-58,119,-101,-58,-59,-59,-68,-55};
      k_it->vast2 = {-90,-54,-54,-64,119,-87,-52,-59,-59,-68};
      k_it->vast3 = {-90,-61,-61,-64,119,-104,-65,-51,-68,-59,-61,-72,-65,-53,-64};
      k_it->vast4 = {-89,-68,-62,-62,-72,119,-98,-55,-58,-59,-58,-50};
    }

    if(kountteri == 235) {
      k_it->k_luku = 88;
      k_it->kysym = {-94,-57,-51,-60,-51,-61,-51,-51,-53,-53,-71,120,-119,-111,-111,-113,120,-56,-57,-60,-63,-63,-53,-63,120,-52,-67,-61,-63,120,-95,-52,-108,-61,-67,-53,-61,-51,-61,-53,-67,-53,-53,-71,120,-53,-63,-62,-71,-63,-58,-58,-67,-67,-53,-67,-67,-58,120,-67,-54,-57,-52,-63,-63,-61,-61,-71,-60,-63,-63,-61,-61,-67,-67,-53,-67,-67,-58,120,-54,-71,-52,-53,-63,-71,-58,-124,120,-62,-57,-53,-53,-71,120,-52,-71,-61,-71,-50,-71,-54,-63,-61,-57,-63,-52,-63,-63,-58,120,-113,120,-120,-120,-120,120,-50,-63,-68,-67,-57,-66,-63,-60,-59,-63,-108,-122,120,-91,-63,-61,-108,120,-57,-60,-63,120,-61,-47,-53,-67,-63,-53,-67,-58,120,-60,-63,-63,-61,-61,-67,-67,-58,120,-58,-63,-59,-63,-105};
      k_it->vast1 = {-96,-57,-52,120,-92,-63,-56,-53};
      k_it->vast2 = {-103,-58,-52,-63,-85,-64,-57,-56};
      k_it->vast3 = {-93,-71,-71,-60,-63,-59,-71,-52,-57};
      k_it->vast4 = {-93,-67,-60,-52,-71,-63,-58,-67,-58,120,-86,-51,-51,-53,-51};
      k_it->selitys = {-91,-47,-75,-64,-67,-59,-59,-63,-58,120,-56,-57,-60,-63,-63,-53,-63,120,-56,-71,-60,-71,-51,-52,-52,-63,120,-50,-63,-68,-67,-57,-52,-122};
    }

    if(kountteri == 236) {
      k_it->k_luku = 94;
      k_it->kysym = {-85,-57,-47,-47,-102,126,-88,-69,-48,-52,126,-94,-51,-52,-52,-61,-48,-57,-52,126,-61,-54,-51,-55,-45,-44,-65,-47,-47,-65,126,-52,-102,-58,-62,-102,-102,-52,126,-47,-45,-51,-53,-65,-54,-65,-57,-47,-61,-52,126,-61,-54,-51,-55,-45,-44,-65,-58,-57,-47,-46,-51,-48,-57,-65,-52,126,-61,-52,-47,-57,-53,-53,-102,-57,-52,-61,-52,126,-61,-48,-61,-55,-46,-57,-51,-99};
      k_it->vast1 = {-84,-65,-57,-47,-61,-52,-55,-45,-44,-57,-65};
      k_it->vast2 = {-79,-57,-42,-46,-41,-52,-57,-52,-61,126,-108,-105};
      k_it->vast3 = {-85,-45,-47,-46,-65,-65,126,-44,-65,-54,-55,-51,-57,-47,-61,-54,-54,-65};
      k_it->vast4 = {-97,-52,-52,-65};
    }

    if(kountteri == 237) {
      k_it->k_luku = 65;
      k_it->kysym = {-114,-86,-84,125,97,-80,-81,97,-117,-98,-77,-81,97,-123,-80,-81,-81,-90,-77,-86,-81,97,-90,-76,-86,-75,-75,125,-82,125,-81,97,-77,-80,-80,-83,-86,-87,-94,-87,-82,-80,-81,97,-94,-82,-82,-94,-75,-75,-86,97,-87,125,-81,-90,-81,97,-84,125,-76,-86,-84,-86,-77,-85,-80,-86,-75,-75,-94,-82,-94,-76,-76,-94,-94,-81,97,-85,-94,97,-80,-87,-85,-94,-94,-82,-94,-76,-76,-94,-94,-81,97,-90,-83,-80,-84,-74,-73,-94,-76,-76,-94,97,99,-108,-86,-71,-75,-70,-81,-86,-81,-90,97,119,122,99,-128};
      k_it->vast1 = {-120,-70,-81,-90,-84,-80,-83,-80,-88,-86};
      k_it->vast2 = {-111,-74,-75,-84,-86,-82,-86,-90,-76};
      k_it->vast3 = {-114,-70,-70,-81,-75,-86,-82,-86,-90,-76};
      k_it->vast4 = {-107,-80,-86,-82,-86,-75,-74,-76,-85,-80,-87,-75,-94,-85,-94};
    }

    if(kountteri == 238) {
      k_it->k_luku = 2;
      k_it->kysym = {79,107,109,62,34,117,103,119,116,99,99,120,107,117,118,99,34,117,110,99,112,105,107,47,117,99,112,113,107,117,118,99,34,103,107,34,120,107,107,118,118,99,99,34,109,99,112,112,99,100,107,109,117,103,103,112,65};
      k_it->vast1 = {85,114,62,105,62};
      k_it->vast2 = {85,114,110,107,104,104,107};
      k_it->vast3 = {70,62,112,109,109,107};
      k_it->vast4 = {79,95,123,106,123};
      k_it->selitys = {88,107,107,118,118,99,99,34,109,113,109,99,107,107,112,107,107,112};
    }

    if(kountteri == 239) {
      k_it->k_luku = 24;
      k_it->kysym = {101,-127,-125,84,56,-116,121,-128,-121,56,-114,121,-117,-116,121,-117,-127,56,-117,-115,-121,-123,121,-124,121,-127,-117,-116,125,-122,56,-120,-121,-118,-122,-121,-124,125,-128,-116,-127,125,-122,56,-114,-115,-121,-117,-127,-125,-111,-123,-123,125,-122,-127,84,56,-126,121,-116,-125,-115,-122,125,125,-117,-116,121,56,-125,-115,-114,121,-117,125,-122,-117,-115,-115,-118,-127,-117,-116,121,68,56,-126,-121,-117,-117,121,56,-123,84,84,-118,-127,-116,125,-124,-116,-127,-127,-122,68,56,-123,-127,-116,84,56,-124,125,-128,124,-127,-117,-117,84,56,-117,121,-127,56,-122,84,-125,-111,84,87};
      k_it->vast1 = {106,121,-115,-116,121,-125,-127,-118,-126,121};
      k_it->vast2 = {103,-127,-125,125,-115,-117,-123,-127,-122,-127,-117,-116,125,-118,-127,117};
      k_it->vast3 = {98,-115,-124,-125,-127,-117,125,-122,56,-117,121,-122,121,-122,56,-122,125,-115,-114,-121,-117,-116,-121};
      k_it->vast4 = {99,125,-117,-125,-115,-117,-118,-127,-125,-121,-117,-120,-121,-124,-127,-127,-117,-127};
      k_it->selitys = {100,125,-128,-116,-127,125,-122,56,-126,121,-125,125,-124,-115,-117,-116,121,56,-114,121,-117,-116,121,-122,-122,-115,-116,56,-111,-118,-127,-116,-111,-117,56,-116,-121,-116,125,-115,-116,-116,-127,56,-117,125,-122,-117,-115,-115,-118,-127,-122,56,-127,-116,-117,125};
    }

    if(kountteri == 240) {
      k_it->k_luku = 57;
      k_it->kysym = {-122,-94,-89,-92,117,89,-91,-102,-93,-94,-89,89,-90,-88,-89,-94,-89,-92,-98,-85,-83,-102,-94,-89,-98,-89,89,-84,-82,-88,-90,-98,-89,-90,-98,-84,-83,-102,-85,-94,89,-124,-94,-90,89,-123,-102,-102,-92,-84,-88,-89,-98,-89,89,-92,117,-85,-78,-84,-94,89,-92,-88,-92,-102,-94,-94,-89,-94,-84,-83,-102,89,-81,-82,-88,-89,-89,-102,89,107,105,107,106,120};
      k_it->vast1 = {123,-94,-91,-93,-102,-85,-99,-94,-89};
      k_it->vast2 = {-128,-88,-91,-97,-94,-89};
      k_it->vast3 = {-116,-82,-91,-92,-102,-87,-102,-91,-91,-88,-89};
      k_it->vast4 = {-116,-86,-82,-102,-84,-95,-94,-89};
    }

    if(kountteri == 241) {
      k_it->k_luku = 86;
      k_it->kysym = {-93,-65,-62,-62,-59,-65,-60,118,-63,-65,-56,-64,-59,-65,-54,-69,-54,-54,-65,-65,-60,118,-87,-53,-59,-61,-69,-60,118,-69,-60,-55,-65,-61,-61,-110,-65,-60,-69,-60,118,-87,-53,-72,-53,-54,-69,-50,-125,-56,-69,-55,-69,-58,-54,-65,-107};
      k_it->vast1 = {-121,-113,-114,-117};
      k_it->vast2 = {-121,-113,-113,-117};
      k_it->vast3 = {-120,-122,-122,-117};
      k_it->vast4 = {-120,-122,-121,-117};
    }

    if(kountteri == 242) {
      k_it->k_luku = 75;
      k_it->kysym = {-104,-76,-74,-121,107,-70,-71,107,-60,-66,-74,-121,-71,-73,-121,-121,-74,-80,107,-99,-80,-66,-76,-73,-84,-67,-76,-71,107,-63,-84,-76,-74,-64,-65,-65,-84,-63,-84,107,-84,-76,-71,-80,-118};
      k_it->vast1 = {-113,-80,-74,-66,-65,-67,-70,-72,-80,-65,-70,-67,-79,-84,-84,-71,-76};
      k_it->vast2 = {-113,-80,-74,-66,-65,-67,-70,-67,-79,-84,-84,-71,-76};
      k_it->vast3 = {-113,-80,-74,-66,-65,-67,-84,-84,-71,-76,-66,-64,-74,-67,-84,-84,-66,-76};
      k_it->vast4 = {-113,-80,-74,-66,-84,-72,-79,-80,-65,-84,-72,-76,-76,-71,-76};
    }

    if(kountteri == 243) {
      k_it->k_luku = 44;
      k_it->kysym = {121,-107,-104,-104,104,76,-103,-111,-102,-111,-96,-111,-104,-103,104,-104,-104,104,76,-94,-101,-107,-96,76,-111,-98,-101,-96,-96,-115,-115,76,126,-111,-97,-107,-104,-115,-98,76,89,-91,-97,-105,104,-102,-104,104,104,-105,-105,-111,-111,-97,-96,104,76,-112,-111,-105,-97,-96,-98,-101,-98,-110,-115,-115,-102,-107,-115,107};
      k_it->vast1 = {-127,-95,-96,-96,-115,-103,-115,-104,-104,-115};
      k_it->vast2 = {116,-115,-107,-108,-112,-95,-96,-96,-115,-103,-115,-104,-104,-115};
      k_it->vast3 = {-128,-107,-97,-104,-115,-115,-103,-115,-104,-104,-115};
      k_it->vast4 = {127,-95,-101,-112,-115,-96,-96,-115,-103,-115,-104,-104,-115};
    }

    if(kountteri == 244) {
      k_it->k_luku = 67;
      k_it->kysym = {-112,-84,-73,127,99,-81,-92,-82,-74,-92,-73,-84,-84,-71,-84,-74,-73,-92,99,-80,-92,-82,-88,-72,-73,-72,-74,-92,-84,-79,-88,-73,-73,-92,99,-74,-84,-74,127,-81,-73,-68,-68,99,-110,-75,-84,-78,-79,-84,-79,99,-107,-88,-74,-84,-81,-92,-75,99,112,-68,-74,-82,127,-79,-81,127,127,-82,-82,-88,-88,-74,-88,-88,-79,-126};
      k_it->vast1 = {-106,-78,-75,-91,-84,-73,-78,-81,-84};
      k_it->vast2 = {-106,-72,-82,-75,-92,-81,-78,-78,-74,-84};
      k_it->vast3 = {-112,-92,-81,-73,-84,-73,-78,-81,-84};
      k_it->vast4 = {-124,-74,-77,-92,-75,-73,-92,-92,-80,-84};
    }

    if(kountteri == 245) {
      k_it->k_luku = 54;
      k_it->kysym = {-127,-85,-95,-105,86,-94,114,114,-95,114,-88,-97,86,-93,-101,-92,-101,-86,-86,-97,86,-86,-91,-97,-93,-97,-94,-85,-90,-105,-92,-87,-105,86,-96,-105,86,-96,-91,-85,-86,-85,-97,86,-84,-105,-92,-95,-97,-94,-105,-105,-92,86,-86,-91,-97,-93,-97,-86,-101,-86,-86,-85,-105,-105,-92,86,-92,-105,-88,-95,-91,-93,-105,-105,-92,-101,-97,-94,-94,-101,86,-119,-85,-104,-85,-86,-101,-82,-97,-105,86,-101,-90,114,-84,-97,-88,-105,-94,-94,-97,-87,-86,-105,86,-86,-97,-101,-86,114,117};
      k_it->vast1 = {-122,-101,-92,-86,-86,-97,86,-127,-105,-88,-84,-91,-92,-101,-92};
      k_it->vast2 = {-120,-97,-87,-86,-91,86,-122,-101,-94,-95,-91,-92,-101,-92};
      k_it->vast3 = {-125,-97,-95,-95,-91,86,-122,-105,-85,-92,-97,-91};
      k_it->vast4 = {119,-95,-97,86,126,-97,-92,-86,-87,-105};
    }

    if(kountteri == 246) {
      k_it->k_luku = 58;
      k_it->kysym = {-121,-93,-88,-91,118,90,-94,-81,-81,-89,-97,-97,-88,90,-77,-90,-97,-93,-83,-82,-77,-89,-93,-88,-97,-88,90,-115,-81,-87,-89,-97,-83,-83,-101,90,-92,-87,-94,-82,-93,90,107,115,115,106,103,-90,-81,-80,-81,-88,90,-101,-90,-81,-83,-83,-101,90,-90,-101,-101,-92,-101,-88,90,-86,-101,-88,-91,-91,-93,-84,-77,-105,-83,-82,-105,-92,-97,-88,90,-101,-101,-90,-82,-87,-87,-88,102,90,-91,-81,-88,90,-80,-101,-88,-95,-93,-82,90,-92,-87,-81,-82,-81,-93,-80,-101,-82,90,-89,-101,-91,-83,-101,-89,-101,-101,-88,90,-94,-81,-81,-89,-97,-80,-97,-90,-91,-87,-92,-101,-101,-88,121};
      k_it->vast1 = {123,-89,-96,-97,-82,-101,-89,-93,-93,-88,-93};
      k_it->vast2 = {-115,-81,-100,-81,-82,-97,-78};
      k_it->vast3 = {-123,-87,-91,-101,-93,-93,-88,-93};
      k_it->vast4 = {127,-91,-83,-82,-101,-101,-83,-93};
    }

    if(kountteri == 247) {
      k_it->k_luku = 96;
      k_it->kysym = {-83,-55,-50,-53,-100,-128,-48,-100,-55,-56,-44,-59,-59,-50,-128,-53,-100,-39,-44,-67,-50,-128,-46,-63,-50,-57,-63,-55,-45,-44,-63,-42,-63,-53,-45,-55,-128,-44,-43,-52,-59,-51,-55,-50,-59,-50,-128,-48,-100,-100,-44,-59,-44,-44,-55,-55,-50,-128,-42,-43,-49,-50,-50,-63,-128,-111,-103,-105,-110,-128,-59,-60,-43,-45,-53,-43,-50,-50,-63,-50,-128,-45,-43,-43,-46,-59,-45,-45,-63,-128,-42,-63,-52,-55,-49,-53,-43,-50,-50,-63,-45,-45,-63,-128,-63,-46,-42,-63,-52,-52,-63,-128,-100,-100,-50,-44,-59,-50,-128,-51,-59,-50,-50,-59,-45,-45,-100,-128,-44,-63,-45,-63,-50,-97};
      k_it->vast1 = {-85,-63,-50,-50,-63,-62,-55,-45};
      k_it->vast2 = {-84,-77,-92};
      k_it->vast3 = {-95,-51,-58,-59,-44,-63,-51,-55,-55,-50,-55};
      k_it->vast4 = {-82,-43,-43,-45,-53,-63};
    }

    if(kountteri == 248) {
      k_it->k_luku = 34;
      k_it->kysym = {109,-105,-117,-112,-115,-125,66,-113,-111,-112,-106,-125,66,-110,-121,-122,-111,-120,-117,-117,-114,-117,94,66,117,-105,-111,-113,-121,-107,-107,-125,66,-125,-108,-104,-117,-111,-117,-122,-125,-125,-112,66,-111,-114,-121,-104,-125,-112,97};
      k_it->vast1 = {86,82,66,82,82,82};
      k_it->vast2 = {86,82,82,82};
      k_it->vast3 = {86,82,82};
      k_it->vast4 = {86,82,82,66,82,82,82};
    }

    if(kountteri == 249) {
      k_it->k_luku = 8;
      k_it->kysym = {85,113,116,116,68,40,115,105,108,125,116,116,105,40,124,105,118,123,115,105,116,105,113,118,109,118,40,-127,112,108,109,115,123,68,118,115,109,122,124,105,113,118,109,118,40,120,105,118,115,115,113,122,-127,101,123,124,68,114,68,40,91,124,109,109,118,40,75,112,122,113,123,124,109,118,123,109,118,40,105,117,120,125,113,40,115,105,115,123,113,40,120,119,116,113,113,123,113,105,40,126,125,119,118,118,105,40,57,65,65,63,71};
      k_it->vast1 = {92,109,112,124,105,105,118,115,105,108,125,116,116,105};
      k_it->vast2 = {92,105,122,115,115,47,105,117,120,125,114,105,118,115,105,108,125,116,116,105};
      k_it->vast3 = {81,123,119,40,90,119,119,106,109,122,124,113,118,115,105,108,125,116,116,105};
      k_it->vast4 = {73,116,106,109,122,124,113,118,115,105,108,125,116,116,105};
      k_it->selitys = {92,109,112,124,105,105,118,53,40,114,105,40,83,105,120,124,109,109,118,113,118,115,105,108,125,118,40,122,113,123,124,109,-127,115,123,109,123,123,68,54};
    }

    if(kountteri == 250) {
      k_it->k_luku = 25;
      k_it->kysym = {102,-126,-123,-123,-120,-126,-121,57,126,-123,85,-126,-122,-126,-126,-121,-116,126,-124,122,122,-121,-115,-114,-122,-126,-121,126,-121,57,-123,122,-126,-123,-123,-126,-116,-115,126,-115,-115,-126,-126,-121,57,108,-114,-120,-122,126,-116,-116,122,88};
      k_it->vast1 = {74,82,80,74};
      k_it->vast2 = {74,82,79,74};
      k_it->vast3 = {74,82,81,74};
      k_it->vast4 = {74,82,82,74};
    }

    if(kountteri == 251) {
      k_it->k_luku = 22;
      k_it->kysym = {99,127,-126,-126,-123,127,-124,54,-127,127,-126,-128,-117,-124,54,-116,119,-126,-125,127,-119,-118,119,-125,127,-124,123,-124,54,-127,-123,-118,-123,-124,119,54,-126,119,127,-126,-126,127,-119,-118,123,-118,-118,127,127,-124,54,105,-117,-123,-125,123,-119,-119,119,85};
      k_it->vast1 = {72,70,71,78};
      k_it->vast2 = {71,79,78,78};
      k_it->vast3 = {71,79,76,78};
      k_it->vast4 = {71,79,73,78};
    }

    if(kountteri == 252) {
      k_it->k_luku = 70;
      k_it->kysym = {-109,-81,-79,-126,102,-71,-85,-69,-72,-89,-89,-68,-81,-71,-70,-89,102,-75,-78,-81,102,-113,-75,-72,102,-120,-75,-87,-79,-81,-76,102,-71,-69,-75,-71,-81,-77,-89,102,-74,-126,-81,-82,-86,-85,-123};
      k_it->vast1 = {-111,-89,-76,-76,-89,-88,-81,-71};
      k_it->vast2 = {-110,-103,-118};
      k_it->vast3 = {-117,-79,-71,-70,-89,-89,-71,-81};
      k_it->vast4 = {-111,-126,-72,-74,-126,-71,-71,-81,-85,-76,-81};
    }

    if(kountteri == 253) {
      k_it->k_luku = 86;
      k_it->kysym = {-93,-65,-63,-110,118,-66,-69,-56,-110,-54,-49,-55,-63,-56,-65,-55,-54,-65,-62,-62,-65,-60,-69,-60,118,-64,-110,-56,-64,-69,-55,-54,-77,118,-49,-56,-65,-54,-54,-65,118,-66,-69,-56,-110,-54,-54,-110,-110,118,-59,-65,-63,-69,-53,-55,-62,-110,-110,-63,-69,-54,-65,-69,-54,-69,-69,-62,-62,-65,-55,-69,-55,-55,-110,118,-55,-110,-65,-62,-49,-54,-69,-54,-54,-49,-110,118,-73,-65,-52,-59,-54,-59,-60,-54,-73,118,-56,-53,-53,-61,-65,-55,-54,-73,118,-66,-69,-60,-63,-65,-65,-60,118,-49,-62,-65,118,-54,-53,-60,-60,-65,-60,118,-63,-69,-55,-54,-110,-60,-69,-69,-55,-55,-110,118,-61,-73,-60,-73,-73,-61,-65,-55,-54,-73,-58,-73,-66,-54,-53,-61,-73,-55,-55,-73,118,-52,-53,-59,-60,-60,-73,118,-120,-122,-121,-121,-107};
      k_it->vast1 = {-92,-59,-63,-65,-73,-125,-61,-65,-55,-55,-65,-59};
      k_it->vast2 = {-87,-73,-60,-73,118,-64,-73,118,-81,-62,-65,-55,-54,-49,-55};
      k_it->vast3 = {-101,-62,-110,-61,-110,-60,118,-87,-73,-60,-73};
      k_it->vast4 = {-93,-73,-65,-54,-59,-72,-73,-73,-56,-65};
    }

    if(kountteri == 254) {
      k_it->k_luku = 87;
      k_it->kysym = {-94,-52,-62,-72,119,-51,-64,-64,-60,-68,119,-51,-52,-58,-54,-64,-62,-48,-60,-60,-68,-59,-53,-68,-59,119,-62,-55,-64,-54,-53,-64,-61,-61,-64,-54,-64,-54,-53,-109,119,-54,-72,-72,-55,-59,-72,-72,-63,-64,-54,-53,-72,119,-51,-72,-54,-53,-72,-54,-64,119,-65,-109,-59,-53,-109,119,-72,-55,-51,-58,-54,-53,-68,-61,-61,-68,-64,-61,-61,-68,119,-60,-72,-61,-53,-64,-61,-61,-64,-54,-68,-60,-60,-64,-61,-61,-68,119,-57,-72,-54,-53,-58,-55,-68,-64,-61,-61,-68,-125,119,-68,-53,-53,-109,119,-65,-68,119,-58,-51,-72,-53,119,-69,-68,-60,-58,-59,-68,-64,-69,-68,-59,119,-51,-72,-61,-61,-72,-54,-54,-72,-106};
      k_it->vast1 = {-83,-68,-61,-64,119,-86,-72,-72,-55,-64,-62,-72,-61,-61,-68};
      k_it->vast2 = {-87,-64,-62,-52,119,-87,-64,-59,-59,-68};
      k_it->vast3 = {-92,-72,-55,-62,-62,-52,119,-94,-58,-64,-51,-64,-54,-53,-58};
      k_it->vast4 = {-85,-72,-57,-72,-59,-64,119,-94,-58,-64,-51,-52,-59,-64,-68,-60,-64};
    }

    if(kountteri == 255) {
      k_it->k_luku = 62;
      k_it->kysym = {-119,-77,-87,-97,94,-76,-89,-89,-85,-93,94,-76,-77,-83,-79,-89,-87,-73,-85,-85,-93,-84,-78,-93,-84,94,-90,-93,-80,122,-78,-73,-79,-87,-80,-89,-79,-78,-89,-86,-86,-89,-79,-89,-79,-78,122,94,-88,-83,-90,-78,-97,-88,-89,-79,-78,-97,94,-76,-97,-97,-78,-89,94,-79,-93,-77,-80,-97,-97,-88,-89,-86,-78,-97,-97,-84,94,-78,-89,-93,-78,-78,-73,-88,-93,-84,94,-82,-97,-89,-84,-83,-89,-84,-94,-93,-87,-79,-89,-93,-84,94,-84,-83,-77,-94,-97,-78,-78,-97,-85,-89,-79,-78,-97,125};
      k_it->vast1 = {-110,-97,-82,-97,-84,-89,94,-119,-83,-89,-76,-77,-84,-89,-93,-85,-89};
      k_it->vast2 = {-108,-93,-86,-89,94,-111,-97,-97,-80,-89,-87,-97,-86,-86,-93};
      k_it->vast3 = {-117,-97,-80,-87,-87,-77,94,-119,-83,-89,-76,-89,-79,-78,-83};
      k_it->vast4 = {-112,-89,-87,-77,94,-112,-89,-84,-84,-93};
    }

    if(kountteri == 256) {
      k_it->k_luku = 50;
      k_it->kysym = {125,-89,-99,-109,82,-88,-101,-101,-97,-105,82,-109,-101,-99,-95,-100,-105,-96,82,-102,-105,-92,110,-90,-85,-91,-99,-92,-101,-91,-90,-101,-98,-98,-101,-91,-85,-85,-106,-105,-96,82,-90,-89,-96,-96,-105,-90,-89,-101,-97,-97,-101,-91,-90,-109,82,-102,-109,-102,-97,-95,-101,-91,-90,-109,82,-91,-109,-109,-92,-96,-109,-91,-101,82,-102,-95,-97,-95,-91,-105,-99,-91,-89,-109,-109,-98,-101,-91,-89,-89,-90,-90,-109,82,-88,-109,-91,-90,-109,-109,-96,94,82,-97,-89,-90,-90,-109,82,-100,110,-101,82,-99,-101,-101,-96,-96,-101,82,-97,-101,-105,-91,-102,-105,-96,-99,-101,-98,-113,-101,-106,-105,-96,82,-91,-105,-99,-91,-89,-109,-109,-98,-101,-91,-105,-91,-90,-109,82,-109,-102,-106,-101,-91,-90,-105,-98,-89,-91,-90,-109,113};
      k_it->vast1 = {127,-109,-92,-99,-99,-89,82,125,-95,-101,-88,-101,-91,-90,-95};
      k_it->vast2 = {-120,-105,-98,-101,82,-123,-109,-109,-92,-101,-99,-109,-98,-98,-105};
      k_it->vast3 = {-122,-109,-94,-109,-96,-101,82,125,-95,-101,-88,-89,-96,-101,-105,-97,-101};
      k_it->vast4 = {-124,-101,-99,-89,82,-124,-101,-96,-96,-105};
    }

    if(kountteri == 257) {
      k_it->k_luku = 93;
      k_it->kysym = {-86,-58,-53,-56,-103,125,-53,-58,-54,-58,-48,-62,-53,125,-51,-62,-48,-46,-66,-58,-53,-62,-62,-53,125,-47,-62,-55,-62,-45,-58,-48,-58,-52,-54,-66,-58,-53,-52,-56,-48,-62,-48,-48,-66,125,-90,-52,-49,125,-97,-52,-64,-56,125,-47,-66,-53,-48,-48,-58,125,-114,-106,-108,-115,-118,-55,-46,-45,-46,-53,125,-66,-55,-46,-48,-48,-66,-100};
      k_it->vast1 = {-96,-52,-49,-66,-55};
      k_it->vast2 = {-98,-49,-58,-62,-55};
      k_it->vast3 = {-97,-58,-52,125,-87,-46,-45,-58,-55};
      k_it->vast4 = {-84,-54,-52};
    }

    if(kountteri == 258) {
      k_it->k_luku = 35;
      k_it->kysym = {110,-104,-116,-111,-114,-124,67,-109,-116,-105,-114,95,67,-110,-113,-116,67,109,-124,-112,-112,-104,67,118,-116,-113,-105,-124,-103,-104,-110,-107,-120,-111,67,-105,-120,-110,-116,-106,-105,-124,-124,-111,67,-106,-100,-100,-111,-105,-124,-114,-120,-120,-105,-105,-110,-112,-124,-111,-124,67,-106,-124,-124,-112,-124,67,-103,-124,-111,-114,-120,-104,-106,-105,-104,-110,-112,-116,-110,98};
      k_it->vast1 = {84,88,67,-103,-104,-110,-105,-105,-124};
      k_it->vast2 = {84,83,67,-103,-104,-110,-105,-105,-124};
      k_it->vast3 = {85,83,67,-103,-104,-110,-105,-105,-124};
      k_it->vast4 = {88,67,-103,-104,-110,-105,-105,-124};
      k_it->selitys = {119,-104,-110,-112,-116,-110,-111,67,-115,95,-113,-114,-120,-120,-111,67,-115,-110,-104,-105,-104,-116,67,-115,95,95,-112,95,95,-111,67,-109,-124,-114,-114,-110,-117,-110,-116,-105,-110,-110,-111};
    }

    if(kountteri == 259) {
      k_it->k_luku = 95;
      k_it->kysym = {-84,-56,-45,-101,127,-46,-56,-45,-45,-60,-52,-52,-56,-51,127,-57,-44,-44,-52,-60,-60,-54,-46,-56,127,-53,-44,-50,-54,-56,-45,-60,-53,-45,-44,-64,127,-64,-56,-51,-60,-45,-45,-64,127,-50,-53,-56,127,-46,-50,-45,-56,-60,-51,127,-64,-56,-54,-64,-64,-51,127,-78,-44,-50,-52,-60,-51,127,-47,-56,-51,-45,-64,-52,-64,-53,-53,-64,127,-54,-101,-40,-45,-60,-45,-45,-40,127,-55,-64,127,-89,-56,-45,-53,-60,-47,-56,-51,-54,-56,-51,127,-54,-101,-40,-45,-45,-101,-52,-101,127,-81,-60,-47,-43,-56,-45,-56,-51,-98};
      k_it->vast1 = {-84,-60,-45,-64,-52,-59,-60,-45,-64,-52,-56,-56,-51,-56,-64};
      k_it->vast2 = {-96,-52,-59,-60,-45,-64,-52,-56,-56,-51,-56,-64};
      k_it->vast3 = {-93,-60,-54,-46,-64,-52,-59,-60,-45,-64,-52,-56,-56,-51,-56,-64};
      k_it->vast4 = {-85,-60,-43,-50,-64,-52,-59,-60,-45,-64,-52,-56,-56,-51,-56,-64};
    }

    if(kountteri == 260) {
      k_it->k_luku = 7;
      k_it->kysym = {84,112,123,67,39,119,112,122,123,118,118,115,112,104,39,82,104,124,111,104,113,118,108,117,39,114,118,124,115,124,104,116,119,124,113,104,39,84,104,123,123,112,39,90,104,104,121,112,39,114,67,-128,123,123,112,70};
      k_it->vast1 = {94,104,115,123,111,108,121,39,87,57,57};
      k_it->vast2 = {90,112,110,39,90,104,124,108,121,39,87,57,60,55};
      k_it->vast3 = {89,124,110,108,121,39,84,82,39,80,80,80};
      k_it->vast4 = {85,104,110,104,117,123,39,84,56,63,64,60};
    }

    if(kountteri == 261) {
      k_it->k_luku = 80;
      k_it->kysym = {-99,-71,-69,-116,112,-65,-68,-71,112,-101,-79,-59,-72,-79,-70,-65,-75,-66,112,-69,-65,-59,-68,-59,-79,-67,-64,-59,-70,-79,112,-99,-79,-60,-60,-71,112,-93,-79,-79,-62,-75,-66,112,-68,-116,-116,-69,-71,-60,-55,-61,-113};
      k_it->vast1 = {-93,-93,-94,-103};
      k_it->vast2 = {-93,-98,-94,-103};
      k_it->vast3 = {-99,-71,-62,-60,-79,-60,-61,-79,-64,-71,-71,-66,-71};
      k_it->vast4 = {-110,-59,-64,-62,-65,-64,-71,-65,-66,-71};
      k_it->selitys = {-100,-71,-61,-116,-69,-61,-71,112,-78,-75,-66,-60,-61,-65,-76,-71,-79,-60,-61,-75,-64,-71,-71,-66,-71,-60,112,-79,-72,-76,-71,-61,-60,-59,-61,-69,-65,-72,-60,-79,-59,-69,-61,-71,-71,-66};
    }

    if(kountteri == 262) {
      k_it->k_luku = 68;
      k_it->kysym = {-111,-83,-80,-80,-77,-83,-78,100,-76,-91,-81,-91,-78,-91,113,-91,-83,-81,-77,-82,-87,-78,100,-73,-71,-77,-79,-91,-80,-91,-83,-73,-83,-80,-80,-91,100,-77,-80,-83,100,-122,-77,-89,-81,-83,-78,100,-76,-87,-74,-84,-87,-87,-78,100,-73,-91,-91,-85,-91,-78,100,-79,-71,-81,-91,-91,-78,100,-70,-71,-77,-72,-71,-83,-78,-87,-78,100,-73,-83,-83,-72,-72,-128,-79,-83,-73,-76,-128,-83,-70,-128,-125};
      k_it->vast1 = {-114,-71,-84,-91,-78,-78,-71,-81,-73,-87,-78,-91};
      k_it->vast2 = {-114,-77,-71,-80,-71,-78,-91};
      k_it->vast3 = {-113,-87,-81,-74,-83,-78,-128};
      k_it->vast4 = {-113,-91,-74,-84,-71,-78,-76,-128,-83,-70,-128,-78,-128};
    }

    if(kountteri == 263) {
      k_it->k_luku = 93;
      k_it->kysym = {-83,-62,-56,-56,-66,125,-80,-58,-58,-47,-52,-58,-53,125,-57,-46,-55,-56,-66,-58,-48,-58,125,-45,-46,-52,-53,-53,-66,125,-114,-106,-107,-109,125,-54,-46,-48,-58,-58,-56,-56,-58,-66,-55,-65,-46,-54,-58,-53,125,127,-85,-66,-46,-49,-66,-45,-66,-47,125,-85,-66,-47,-48,-58,-47,127,-119,125,-57,-52,-48,-48,-66,125,-59,-103,-53,125,-47,-52,-58,-54,-58,-58,125,-58,-47,-48,-62,125,-55,-66,-46,-55,-66,-57,-66,-53,-66,-117,125,-86,-58,-53,-56,-103,-47,-42,-42,-55,-58,-48,-62,-48,-47,-103,125,-54,-46,-48,-58,-58,-56,-58,-48,-47,-66,125,-52,-53,125,-56,-42,-48,-62,-100};
      k_it->vast1 = {-89,-52,-47,-66,-58,-53,125,-52,-54,-58,-47,-46,-58,-48,-47,-66,125,-48,-62,-56,-52,-58,-55,-46,-66};
      k_it->vast2 = {-91,-46,-54,-51,-51,-66};
      k_it->vast3 = {-86,-66,-49,-48,-48,-58,-54,-46,-48,-58,-58,-56,-56,-58};
      k_it->vast4 = {-80,-42,-53,-47,-59,125,-51,-52,-51};
    }

    if(kountteri == 264) {
      k_it->k_luku = 25;
      k_it->kysym = {100,-114,-124,122,57,-116,-114,-120,-122,122,-123,122,-126,-121,126,-121,57,-122,-114,-117,-127,122,122,-125,122,57,-120,-121,57,-124,85,-110,-115,-115,85,-121,-110,-115,57,-122,-114,-117,-127,122,122,-122,-126,-116,126,-121,57,-113,85,-123,-126,-121,126,126,-121,85,57,-116,-114,-124,-124,122,-127,-120,-114,-116,-114,-125,122,88};
      k_it->vast1 = {102,-126,124,-127,122,126,-123,57,105,126,-121,-115,-115,-126,-123,85};
      k_it->vast2 = {90,-126,-121,-120,57,103,-110,-124,-120,-119,-119,70,100,-120,-116,-124,-126};
      k_it->vast3 = {99,-114,-127,122,57,111,122,-123,-125,122,-124,-124,122,-123,122};
      k_it->vast4 = {111,-126,-117,-119,-126,57,91,-114,-115,-115};
    }

    if(kountteri == 265) {
      k_it->k_luku = 7;
      k_it->kysym = {84,112,111,112,117,39,104,112,117,108,108,122,108,108,117,39,119,108,121,124,122,111,118,112,123,104,113,104,117,104,39,123,-128,100,122,114,108,117,117,108,115,115,-128,123,39,122,104,121,113,104,116,124,121,111,104,104,113,104,39,72,112,117,118,39,85,-128,114,118,119,119,52,82,118,122,114,112,39,118,115,112,39,122,108,114,118,112,123,123,104,117,124,123,39,119,118,123,112,115,104,104,115,115,108,39,104,117,123,104,116,104,117,122,104,39,115,67,67,114,114,108,108,123,51,39,114,124,117,39,111,67,117,39,125,124,118,117,117,104,39,57,55,55,64,39,113,67,112,39,114,112,112,117,117,112,70};
      k_it->vast1 = {81,124,110,124,121,123,123,112,112,117};
      k_it->vast2 = {84,104,114,122,104,115,104,104,123,112,114,114,118,118,117};
      k_it->vast3 = {87,108,121,124,117,104,116,124,124,122,112,112,117};
      k_it->vast4 = {84,124,122,123,112,114,114,104,114,108,112,123,123,118,118,117};
    }

    if(kountteri == 266) {
      k_it->k_luku = 33;
      k_it->kysym = {110,-118,-115,-115,93,65,-126,-118,-113,-122,-122,-115,-115,-126,65,-108,-126,-118,-109,-126,-126,-113,-119,-112,-118,-107,-126,-117,-126,65,108,-126,-107,-126,-109,-118,-118,-113,-126,65,113,-126,-113,-107,-118,-115,-126,65,-114,-106,-109,-119,-126,-108,-118,65,-105,-106,-112,-113,-113,-126,65,83,81,81,88,65,-102,-115,126,-117,93,-109,-105,-122,-115,93,-118,-108,-122,-113,65,-116,-122,-119,-118,-107,-102,-108,-105,-126,-114,-114,-126,-118,-108,-122,-113,65,-105,-126,-113,-119,-106,-116,-108,-122,-113,96};
      k_it->vast1 = {106,-113,-108,-106,-115,-118,-118,-113,-118,-115,-115,-126};
      k_it->vast2 = {98,-109,-108,-122,-122,-113,-118,-115,-115,-126};
      k_it->vast3 = {103,-112,-109,-114,-126,-115,-123,-122,-119,-102,-123,-118,-115,-115,93};
      k_it->vast4 = {115,-112,-107,-126,-113,-114,-102,-109,-116,-102,-115,-115,93};
    }

    if(kountteri == 267) {
      k_it->k_luku = 71;
      k_it->kysym = {-108,-80,-78,-125,103,-81,-84,-75,-82,-84,-77,-77,-80,-75,-84,-75,103,-77,-80,-80,-78,-84,103,-67,-88,-80,-78,-68,-69,-69,-80,103,-70,-64,-67,-125,-70,-69,-80,103,-105,-84,-78,-78,-88,103,-102,-80,-80,-69,-74,-80,-76,-84,-75,103,-88,-79,-88,-69,-69,-84,-77,-68,-68,-75,-122};
      k_it->vast1 = {-120,-75,-69,-71,-74,-73,-74,-70,-74,-83,-80,-88};
      k_it->vast2 = {-98,-80,-86,-86,-88};
      k_it->vast3 = {-99,-88,-73,-88,-88,-76,-68,-68,-71,-88,-71,-80,-68,-70};
      k_it->vast4 = {-120,-85,-67,-84,-75,-69,-80,-70,-76,-80};
    }

    if(kountteri == 268) {
      k_it->k_luku = 72;
      k_it->kysym = {-107,-79,-74,-77,-124,104,-68,-67,-73,-68,-68,-83,-83,-74,104,-79,-75,-72,-72,-87,-87,-75,-79,-69,-83,-74,104,-76,-83,-80,-84,-83,-68,104,-70,-87,-72,-73,-70,-68,-73,-79,-66,-87,-68,104,-74,-73,-67,-69,-83,-83,-74,104,-75,-67,-73,-68,-79,117,-79,-76,-75,-79,-91,-77,-69,-79,104,-110,-63,-66,-124,-69,-77,-63,-76,-124,-74,104,-69,-83,-67,-84,-67,-76,-76,-87,104,-66,-67,-73,-74,-74,-87,104,122,120,120,-128,-121};
      k_it->vast1 = {-116,-83,-73,-84,-73,-70,-87,-74,-68,-68,-79,-83,-74};
      k_it->vast2 = {-109,-83,-70,-75,-87,-66,-87,-87,-80,-68,-73,-72,-67,-70,-77,-77,-79,-83,-74};
      k_it->vast3 = {-101,-72,-70,-87,-63,-75,-87,-87,-76,-79,-83,-74};
      k_it->vast4 = {-107,-67,-73,-66,-79,-76,-79,-79,-75,-73,-78,-83,-74};
      k_it->selitys = {-101,-79,-69,-124,-76,-68,-124,-66,-124,-68,104,-86,-67,-68,-87,-87,-74,-79,-87};
    }

    if(kountteri == 269) {
      k_it->k_luku = 35;
      k_it->kysym = {112,-116,-105,95,67,-124,-116,-111,-120,-105,-105,-124,67,-103,-110,-116,67,-116,-112,-109,-124,-105,-124,67,-114,-100,-111,-106,-116,-113,-124,-114,-124,-111,-109,-104,-117,-121,-116,-106,-105,-104,-106,-124,-116,-111,-120,-116,-106,-105,-124,67,-115,-124,67,-109,-120,-107,-112,-124,-111,-120,-111,-105,-105,-116,-120,-111,67,-112,-120,-107,-114,-114,-124,-104,-106,-114,-100,-111,-116,-106,-105,95,98};
      k_it->vast1 = {100,-106,-120,-105,-110,-111,-116,-124};
      k_it->vast2 = {113,-116,-105,-107,-116,-116,-105,-105,-116,95};
      k_it->vast3 = {119,-110,-113,-104,-120,-120,-111,-116,-124};
      k_it->vast4 = {105,-113,-104,-110,-107,-116,-117,-116,-116,-113,-105,95};
    }

    if(kountteri == 270) {
      k_it->k_luku = 96;
      k_it->kysym = {-83,-55,-44,-100,-128,-63,-55,-50,-59,-44,-44,-63,-128,-55,-51,-48,-63,-44,-63,-63,-50,-128,-44,-43,-48,-63,-53,-63,-50,-45,-39,-44,-39,-44,-44,-55,-51,-55,-45,-44,-100,-97};
      k_it->vast1 = {-94,-43,-44,-63,-63,-50,-55,-63};
      k_it->vast2 = {-95,-45,-59,-44,-49,-50,-55,-63};
      k_it->vast3 = {-85,-45,-39,-52,-59,-59,-50,-55,-100};
      k_it->vast4 = {-94,-59,-50,-44,-45,-59,-59,-50,-55,-100};
    }

    if(kountteri == 271) {
      k_it->k_luku = 82;
      k_it->kysym = {-97,-69,-64,-67,-114,114,-67,-69,-73,-66,-73,-64,114,-69,-64,-64,-63,-67,-77,-59,114,-70,-77,-60,-60,-77,-59,-58,-77,-68,-77,114,-76,-66,-63,-71,-77,-77,-68,-77,114,-94,-77,-64,-57,114,-102,-81,-71,-66,-57,-64,-74,114,-63,-64,-111};
      k_it->vast1 = {-101,-69,-60,-69,-64,114,-67,-69,-73,-66,-73,-64};
      k_it->vast2 = {-99,-53,-65,-60,-69,-64,114,-67,-69,-73,-66,-73,-64};
      k_it->vast3 = {-108,-60,-73,-58,-63,-64,-69,-64,114,-67,-69,-73,-66,-73,-64};
      k_it->vast4 = {-97,-77,-64,-67,-59,-69,-64,114,-67,-69,-73,-66,-73,-64};
    }

    if(kountteri == 272) {
      k_it->k_luku = 73;
      k_it->kysym = {-106,-78,-67,-82,-73,105,-109,-66,-79,-86,105,-97,-86,-75,-77,-86,-76,-76,-86,-75,-86,105,-77,-86,105,-79,-123,-73,-82,-73,105,-68,-66,-69,-74,-86,-86,-74,-86,-76,-68,-82,-82,-73,105,-77,-72,-66,-67,-66,-73,-82,-82,-67,105,-71,-72,-79,-77,-72,-78,-68,-69,-66,-72,-67,-68,-86,-75,-86,-78,-68,-82,-73,105,-71,-82,-69,-79,-82,-82,-73,105,-77,-123,-68,-82,-73,-82,-67,105,-72,-75,-78,-65,-86,-67,105,-77,-72,-66,-67,-66,-73,-82,-82,-67,105,-76,-72,-73,-81,-75,-78,-76,-67,-78,-78,-73,-120};
      k_it->vast1 = {-97,-86,-75,-77,-86,-76,-76,-86,-75,-86,105,-72,-75,-78,105,-65,-86,-69,-86,-68,-67,-86,-73,-66,-67,105,-71,-82,-69,-79,-82,-82,-75,-67,-123,105,-71,-72,-75,-76,-66,-71,-62,-90,-69,-123,-73};
      k_it->vast2 = {-97,-86,-75,-77,-86,-76,-76,-86,-75,-86,105,-72,-75,-78,105,-77,-66,-72,-65,-66,-76,-68,-78,-68,-68,-86,105,-69,-78,-76,-76,-72,-73,-66,-67,105,-71,-82,-69,-79,-82,-82,-73,105,-86,-66,-67,-72,-68,-67,-86,105,-67,-66,-66,-75,-78,-75,-86,-68,-78,-73};
      k_it->vast3 = {-103,-82,-69,-79,-82,-82,-73,-77,-123,-68,-82,-73,-82,-67,105,-65,-86,-75,-78,-67,-67,-78,-65,-86,-67,105,-97,-86,-75,-77,-86,-76,-76,-86,-75,-86,-75,-75,-82,105,-74,-82,-67,-82,-75,-90,-78,-73,-73,-78,-68,-67,-123,105,-75,-82,-78,-69,-78,-73,-67,-123,-86,-75,-66,-82,-82,-75,-75,-86};
      k_it->vast4 = {-103,-82,-69,-79,-82,-82,-73,-77,-123,-68,-82,-73,-82,-67,105,-82,-78,-65,-123,-67,105,-68,-66,-72,-68,-67,-66,-73,-82,-82,-67,105,-75,-86,-78,-73,-86,-86,-74,-86,-86,-73,105,-97,-86,-75,-77,-86,-76,-76,-86,-75,-86,-75,-75,-82,105,-68,-72,-66,-67,-66,-65,-82,-73,-82,-67,-67,-123,-123,-73};
    }

    if(kountteri == 273) {
      k_it->k_luku = 23;
      k_it->kysym = {100,-128,-126,83,55,-122,-123,55,-121,124,-125,-128,-117,-122,-128,-124,-128,-117,-117,120,-127,120,55,101,-128,-126,-122,55,101,-128,-119,-115,-128,-123,55,127,120,-119,-119,120,-118,-117,-116,-118,86};
      k_it->vast1 = {90,127,-128,-125,-128,-117};
      k_it->vast2 = {106,-123,-122,-122,-126,124,-119};
      k_it->vast3 = {105,-122,-117,120,-117};
      k_it->vast4 = {103,120,-128,-123,-117,121,120,-125,-125};
    }

    if(kountteri == 274) {
      k_it->k_luku = 26;
      k_it->kysym = {103,-125,-122,-122,-119,-125,-120,58,91,-122,-125,124,-125,58,71,-122,127,-126,-114,-125,58,123,-122,-123,-119,-125,58,-125,-122,-121,127,-115,-114,-109,86,89};
      k_it->vast1 = {75,83,81,83};
      k_it->vast2 = {75,83,82,83};
      k_it->vast3 = {75,83,80,83};
      k_it->vast4 = {75,83,79,83};
    }

    if(kountteri == 275) {
      k_it->k_luku = 40;
      k_it->kysym = {117,-111,-109,100,72,-100,-105,-111,-106,-115,-106,72,-115,-116,-99,-101,-109,-99,-106,-100,-119,-104,-99,-105,-108,-99,-115,72,115,-102,-111,-101,-100,-111,-108,-108,-111,-101,-116,-115,-107,-105,-109,-102,-119,-119,-100,-100,-111,-115,-106,72,-108,-111,-101,100,-109,-101,-111,72,-109,-119,-106,-106,-119,-100,-100,-119,-119,72,-101,-115,-109,-101,-111,-106,72,-105,-101,-100,-119,-107,-111,-101,-115,-106,72,-100,100,-95,-101,-109,-111,-115,-108,-100,-105,-119,72,-98,-99,-105,-106,-106,-119,72,90,88,90,88,103};
      k_it->vast1 = {122,115,120};
      k_it->vast2 = {123,108,120};
      k_it->vast3 = {126,-119,-101,-115,-107,-107,-111,-101,-100,-105,-108,-111,-111,-100,-100,-105};
      k_it->vast4 = {115,-115,-101,-109,-99,-101,-100,-119};
    }

    if(kountteri == 276) {
      k_it->k_luku = 29;
      k_it->kysym = {104,-110,-122,-117,-120,126,61,-115,-122,-111,-120,89,-117,61,-109,126,-117,-120,-122,-119,126,-111,-110,-116,-118,-122,-116,-117,61,113,-116,-113,74,-109,-126,-113,-120,-116,-117,61,112,-122,-115,-110,-119,-122,-120,126,-117,126,-109,126,-120,-112,-122,61,-120,-110,-111,-112,-110,-111,-110,-117,61,-120,-126,-112,-120,-110,-112,-111,-126,-119,-110,-125,-116,-116,-113,-110,-118,-122,-117,61,-106,-119,-119,89,-115,-122,-111,89,-121,89,61,-112,126,-122,61,-109,-110,-116,-117,-117,126,61,79,77,79,79,61,-125,-116,-116,-113,-110,-118,-122,-119,-119,126,61,-111,-126,-123,-127,-106,-122,-112,-111,89,61,-123,-110,-110,-118,-126,-120,126,-110,-115,-116,-122,-112,-111,126,73,61,-121,-116,-122,-123,-122,-117,61,-123,89,-117,61,-126,-122,61,-122,-111,-112,-126,61,-116,-112,126,-119,-119,-122,-112,-111,-110,-117,-110,-111,92,61};
      k_it->vast1 = {115,-122,-122,-112,-122,61,-109,-110,-116,-111,-111,126};
      k_it->vast2 = {115,-122,-122,-112,-122,61,-120,-110,-110,-120,126,-110,-111,-111,126};
      k_it->vast3 = {104,126,-120,-112,-122,61,-109,-110,-116,-111,-111,126};
      k_it->vast4 = {104,126,-120,-112,-122,61,-120,-110,-110,-120,126,-110,-111,-111,126};
      k_it->selitys = {115,-122,-122,-112,-122,61,-121,126,61,-115,-110,-116,-119,-122,61,-109,-110,-116,-111,-111,126};
    }

    if(kountteri == 277) {
      k_it->k_luku = 84;
      k_it->kysym = {-97,-55,-65,-75,116,-68,-51,-60,-60,-112,-57,-67,116,-65,-51,-63,-63,-71,-62,-71,-57,-56,-112,116,-63,-71,-56,-58,-67,-57,-56,-112,116,-54,-75,-56,-57,-75,-64,-64,-71,-71,-62,-109};
      k_it->vast1 = {-89,-67,-63,-61,116,-89,-75,-64,-63,-67,-62,-71,-62};
      k_it->vast2 = {-98,-75,-62,-67,116,-89,-67,-71,-54,-67,-62,-71,-62};
      k_it->vast3 = {-107,-64,-71,-52,-75,-62,-72,-71,-58,116,-89,-56,-55,-74,-74};
      k_it->vast4 = {-87,-58,-68,-61,116,-97,-71,-65,-65,-61,-62,-71,-62};
    }

    if(kountteri == 278) {
      k_it->k_luku = 37;
      k_it->kysym = {114,-114,-112,-104,-114,69,121,-108,-105,82,-109,-118,-103,-114,-104,-104,97,69,-103,-108,-114,-110,-114,-109,-118,-118,-109,69,105,-108,-102,-107,-107,-114,-112,-122,-102,-107,-122,-109,69,-98,-111,-111,97,-107,-114,-103,97,-113,97,69,-108,-111,-114,69,-122,-111,-112,-122,-109,-102,-103,69,-110,-98,-98,-110,97,97,-109,69,-115,-102,-102,-110,-118,-114,-103,-122,100};
      k_it->vast1 = {117,97,-114,-115,-119,-118,-107,-108,-111,-114,-114,-103,-103,-114,-104,-114,-104,-103,-122,69,-104,-98,-114,-104,-103,97};
      k_it->vast2 = {121,-114,-118,-109,-122,-103,-122,-112,-104,-118,-118,-109,69,-107,-122,-111,-113,-108,-109,69,-105,-122,-115,-122,-122};
      k_it->vast3 = {121,-118,-115,-119,97,-112,-104,-118,-118,-109,69,-113,-108,-103,-122,-114,-109,69,-113,97,-109,-109,-114,-103,-103,97,-101,97,97};
      k_it->vast4 = {120,-122,-122,-119,-122,-112,-104,-118,-118,-109,69,-112,97,-103,-118,-101,97,-104,-103,-114,69,-115,-102,-102,-110,-118,-114,-103,-122,69,-114,-103,-104,-118,-111,-111,-118,-118,-109,-112,-114,-109};
    }

    if(kountteri == 279) {
      k_it->k_luku = 64;
      k_it->kysym = {-115,-87,-85,124,96,-77,-91,-75,-78,-95,-95,-74,-87,-77,-76,-95,96,-77,-75,-81,-83,-95,-84,-95,-87,-77,-87,-77,-76,-95,96,-76,-87,-91,-76,-81,-85,-81,-82,-91,-88,-95,-78,-78,-95,-77,-76,-95,-86,-87,-91,-82,96,-78,-71,-88,-83,-87,-77,-76,124,96,-91,-87,96,-86,-75,-84,-85,-95,-87,-77,-77,-75,-76,96,-85,-95,-75,-80,-95,-84,-84,-87,-77,-76,-91,-82,96,-80,-91,-84,-87,-91,-82,96,-80,-87,-78,-95,-95,-76,-76,-87,-74,-91,-78,-77,-87,-81,-87,-76,-95,127};
      k_it->vast1 = {-113,-78,-95,-82,-89,-91};
      k_it->vast2 = {-127,-93,-93,-91,-77,-77,-87,-81,-82};
      k_it->vast3 = {-126,-71,-76,-91,-78,-95,-80,-91,-78,-77};
      k_it->vast4 = {-123,-72,-76,-91,-82,-92};
    }

    if(kountteri == 280) {
      k_it->k_luku = 45;
      k_it->kysym = {122,-106,-104,105,77,-110,-103,-106,-101,-95,-114,-97,-93,-106,-104,-110,-95,-110,-100,-103,-103,-106,-96,-94,-94,-111,-110,-101,77,-90,-97,-106,-95,-90,-96,77,-107,-90,-118,-111,-90,-101,-96,-106,77,-104,-114,-107,-111,-110,-101,77,-104,-106,-103,-100,-101,77,-96,-106,-106,-104,-114,77,90,-102,-110,-110,-102,-106,105,77,-102,-114,-106,-101,-100,-101,-101,-114,-96,-96,-114,-114,-101,108};
      k_it->vast1 = {110,-95,-97,-106,-114};
      k_it->vast2 = {-128,-114,-114,-97,-106,-100,-106,-101,-110,-101};
      k_it->vast3 = {119,-114,-103,-100,-96,-95,-114,-105,-114};
      k_it->vast4 = {122,-90,-103,-103,-90,-101,77,125,-114,-97,-114,-96};
    }

    if(kountteri == 281) {
      k_it->k_luku = 14;
      k_it->kysym = {91,119,121,74,46,125,122,119,46,124,115,-126,-126,119,123,115,115,123,119,121,-127,119,46,123,-125,125,114,125,-127,-126,-125,124,115,115,124,46,48,121,111,118,114,115,124,46,121,119,122,125,124,46,-127,119,119,121,111,124,48,46,126,-125,124,124,119,-126,-126,-125,46,126,111,119,124,125,77};
      k_it->vast1 = {63,58,68,70,68,46,121,117};
      k_it->vast2 = {68,70,68,46,117};
      k_it->vast3 = {64,58,68,70,68,46,121,117};
      k_it->vast4 = {65,58,68,70,68,46,121,117};
    }

    if(kountteri == 282) {
      k_it->k_luku = 38;
      k_it->kysym = {115,-113,-103,-102,98,70,-103,-97,-97,-102,-102,-117,-117,-103,-102,98,70,72,-104,-113,-103,-101,-109,-113,-117,-114,-117,-108,72,70,127,-107,-101,122,-101,-120,-117,-108,70,-100,-113,-118,-117,-107,-108,70,-111,-101,-100,-121,-108,-108,-101,-102,70,-109,-113,-117,-103,70,-103,-121,-113,70,87,93,86,86,70,-117,-101,-104,-107,-108,70,-103,-121,-111,-107,-102,101};
      k_it->vast1 = {127,-111,-103,-113,-102,-97,-113,-103,-117,-110,98,-109,98,98,70,-110,-107,-101,-111,-111,-121,-121,-100,-121,-108,70,-102,-113,-117,-118,-107,-108,70,-110,-117,-100,-113,-102,-102,98,-109,-113,-108,-117,-108};
      k_it->vast2 = {113,-101,-108,-108,-113,-121,-108,-110,-107,-101,-111,-111,-121,-101,-103};
      k_it->vast3 = {124,-121,-113,-108,-107,-121,-109,-113,-108,-117,-108};
      k_it->vast4 = {121,-121,-110,-121,-111,-121,-102,-103,-117,-110,-101};
    }

    if(kountteri == 283) {
      k_it->k_luku = 15;
      k_it->kysym = {92,120,122,75,47,-126,116,-124,-127,112,112,-123,120,-126,-125,112,47,112,-127,-125,120,-126,-125,116,120,-126,-125,112,47,116,120,47,126,123,116,47,-125,116,119,125,-120,-125,47,122,112,127,127,112,123,116,-125,-125,112,47,119,116,123,123,-124,125,-125,112,123,112,120,-126,-126,112,112,-127,125,112,112,121,112,47,93,120,120,123,126,47,104,123,120,60,101,112,120,125,120,126,-126,-125,112,78};
      k_it->vast1 = {98,123,116,116,127,-120,47,98,123,116,116,127,116,-127,-126};
      k_it->vast2 = {101,116,123,-125,-125,126,47,101,120,-127,-125,112,125,116,125};
      k_it->vast3 = {84,127,127,-124,47,93,126,-127,124,112,112,123,120};
      k_it->vast4 = {84,123,75,122,116,123,75,120,-126,116,-125};
    }

    if(kountteri == 284) {
      k_it->k_luku = 1;
      k_it->kysym = {76,118,108,98,33,112,106,108,102,118,116,110,106,111,106,116,117,102,115,102,106,116,117,61,110,110,102,33,117,112,115,107,118,106,33,119,118,112,111,111,98,33,51,49,49,57,33,102,113,61,106,109,122,117,33,108,118,111,117,98,119,98,98,109,106,102,111,33,113,106,102,109,102,102,111,33,110,102,111,111,102,102,111,33,116,61,105,108,94,106,116,102,111,33,61,61,111,102,116,117,122,108,116,102,111,33,112,111,104,102,109,110,106,116,117,98,33,102,111,111,98,109,117,98,33,108,118,117,116,118,102,111,33,111,106,106,117,61,33,35,116,100,106,102,111,100,102,46,103,106,100,117,106,112,111,106,108,116,106,35,64};
      k_it->vast1 = {85,118,106,107,98,33,67,115,98,121};
      k_it->vast2 = {66,111,111,98,46,78,98,107,98,33,73,102,111,115,106,108,116,112,111};
      k_it->vast3 = {77,102,102,111,98,33,77,118,105,117,98,111,102,111};
      k_it->vast4 = {75,112,105,98,111,111,102,116,33,76,112,116,108,106,111,102,111};
    }

    if(kountteri == 285) {
      k_it->k_luku = 25;
      k_it->kysym = {102,-126,-124,85,57,-110,-127,-115,-126,118,57,-113,122,-116,-115,122,-116,-126,57,-113,-114,-120,125,126,-121,57,75,73,73,81,57,-124,-114,-121,-115,122,-113,122,122,-123,126,-126,-116,-116,122,57,-124,-120,-124,126,-126,-123,-123,-114,-116,-115,122,57,-116,85,-127,-124,118,-126,-116,126,-121,57,85,85,-121,126,-116,-115,85,-122,-126,-116,126,-121,57,-115,126,-124,-121,-120,-123,-120,-128,-126,122,-116,-115,122,88};
      k_it->vast1 = {109,-126,126,-115,-120,94,-121,122,-115,-120,-117};
      k_it->vast2 = {103,-120,-124,-126,122};
      k_it->vast3 = {98,-121,127,-120,-116,-110,-116};
      k_it->vast4 = {93,-126,-128,-126,122};
    }

    if(kountteri == 286) {
      k_it->k_luku = 77;
      k_it->kysym = {-102,-74,-72,-119,109,-64,-78,-62,-65,-82,-82,-61,-74,-64,-63,-82,109,-73,-82,-72,-78,-74,-64,-63,-82,109,-78,-74,109,-64,-74,-64,-119,-71,-71,-58,109,-95,-74,-78,-63,-68,109,122,-58,-75,-63,-74,-86,-69,109,111,-93,-82,-71,-62,-78,109,-77,-68,-65,109,-103,-74,-77,-78,111,109,122,-71,-82,-62,-71,-62,-62,-69,-116};
      k_it->vast1 = {-97,-68,-81,-68,-63,-64,109,-81,-65,-74,-69,-76,109,-68,-62,-65,109,-64,-75,-68,-67,-67,-74,-69,-76,109,-81,-82,-76,-64,121,109,-60,-78,-71,-80,-68,-70,-78,109,-63,-68,109,-63,-75,-78,109,-77,-62,-63,-62,-65,-78};
      k_it->vast2 = {-96,-63,-82,-65,-63,122,-62,-67,109,-80,-62,-71,-63,-62,-65,-78,109,-78,-61,-78,-65,-58,-60,-75,-78,-65,-78,121,109,-60,-74,-69,-69,-78,-65,-64,109,-63,-82,-72,-78,109,-74,-63,109,-82,-71,-71};
      k_it->vast3 = {-96,-68,-68,-69,109,-81,-62,-74,-71,-79,-74,-69,-76,-64,109,-63,-75,-74,-69,-72,109,-63,-75,-78,-70,-64,-78,-71,-61,-78,-64,121,109,-80,-82,-65,-64,109,-79,-65,-74,-61,-78,109,-68,-69,109,-63,-75,-78,-74,-65,109,-68,-60,-69};
      k_it->vast4 = {-112,-71,-68,-80,-72,122,-64,-67,-78,-78,-79,109,-74,-64,109,-77,-82,-64,-63,121,109,-81,-62,-63,109,-60,-78,116,-71,-71,109,-64,-62,-65,-61,-74,-61,-78};
    }

    if(kountteri == 287) {
      k_it->k_luku = 3;
      k_it->kysym = {80,108,110,63,35,118,104,120,117,100,100,121,108,118,119,100,35,110,108,117,109,100,113,110,120,118,119,100,113,119,100,112,114,108,118,119,100,35,104,108,35,114,111,104,35,118,100,100,113,120,119,35,86,110,104,115,118,108,118,35,117,124,61,113,35,107,120,120,107,100,100,48,115,100,111,110,108,113,119,114,100,66};
      k_it->vast1 = {87,100,112,112,108};
      k_it->vast2 = {90,86,82,92};
      k_it->vast3 = {82,119,100,121,100};
      k_it->vast4 = {88,120,118,108,35,119,108,104};
    }

    if(kountteri == 288) {
      k_it->k_luku = 19;
      k_it->kysym = {96,124,127,127,-126,124,-127,51,126,116,-120,-125,116,127,127,124,-122,-121,120,-127,51,-121,124,120,-121,-126,126,-126,-127,120,-126,123,125,120,127,-128,124,120,-127,51,126,-126,-125,124,-126,124,-127,-121,124,51,59,-128,-116,112,-122,51,-116,126,-122,124,-121,-116,124,-122,120,120,-127,51,126,79,-116,-121,-121,112,112,-127,60,51,126,124,120,127,127,120,-121,-121,124,124,-127,51,127,116,124,127,127,116,51,102,-120,-126,-128,120,-122,-122,116,82};
      k_it->vast1 = {68,76,76,70};
      k_it->vast2 = {68,76,75,75};
      k_it->vast3 = {68,76,76,75};
      k_it->vast4 = {68,76,75,72};
    }

    if(kountteri == 289) {
      k_it->k_luku = 64;
      k_it->kysym = {-115,-87,-85,124,96,-81,-82,96,-85,-95,-82,-77,-95,-87,-82,-74,124,-84,-87,-77,-91,-84,-84,124,96,-76,-95,-77,-81,-84,-84,-95,96,-91,-82,-87,-76,-91,-82,96,-74,-87,-84,-86,-91,-84,-76,-71,96,-80,-77,-87,-84,-81,-77,-71,-94,-87,-87,-82,-87,124,96,-77,-87,-77,124,-84,-76,124,-74,124,96,-77,-87,-91,-82,-87,127};
      k_it->vast1 = {-120,-75,-75,-78,-75,-83,-95,-92,-81,-82,-84,-95,-85,-85,-87};
      k_it->vast2 = {-109,-75,-87,-80,-80,-75,-83,-95,-92,-81,-82,-84,-95,-85,-85,-87};
      k_it->vast3 = {-110,-91,-75,-82,-75,-77,-85,-87,-78,-86,-81,-88,-91,-84,-76,-76,-95};
      k_it->vast4 = {-109,-87,-82,-87,-76,-71,-74,-87,-85,-75,-75,-80,-87,-85,-85,-95};
    }

    if(kountteri == 290) {
      k_it->k_luku = 50;
      k_it->kysym = {127,-101,-98,-98,-95,-101,-96,82,-94,-91,-101,-98,-95,-91,-85,-108,-101,-101,-96,-101,-91,-101,-105,-96,-90,-105,-96,82,-88,-101,-98,-100,-105,-98,-85,82,-99,-101,-105,-98,-98,-105,-90,-90,-101,-101,-96,82,-105,-92,-101,-99,-91,-105,-105,-96,82,-123,-89,-95,-97,-105,-96,82,-98,-109,-101,-91,-91,-109,113};
      k_it->vast1 = {100,98,98,106};
      k_it->vast2 = {99,107,107,106};
      k_it->vast3 = {99,107,105,106};
      k_it->vast4 = {99,107,104,106};
    }

    if(kountteri == 291) {
      k_it->k_luku = 26;
      k_it->kysym = {103,-125,-122,-122,-119,-125,-120,58,-115,-113,-125,-118,-118,-113,-121,123,126,-119,-120,-122,123,-123,-123,-125,127,-120,58,-123,123,-115,-112,-113,-123,123,-113,-115,-125,58,123,-122,-123,123,123,89};
      k_it->vast1 = {95,-122,-119,-123,-113,-113,-120,58,-118,-113,-119,-122,-125,-112,86,-122,-125,-115,-115,86};
      k_it->vast2 = {109,-109,-109,-115,-123,-113,-113,-120,58,123,-122,-113,-115,-115,123};
      k_it->vast3 = {98,127,-125,-120,86,-123,-113,-113,-120,58,-122,-119,-118,-113,-115,-115,123};
      k_it->vast4 = {109,-109,-109,-115,-123,-113,-113,-120,58,-122,-119,-118,-113,-115,-115,123};
    }

    if(kountteri == 292) {
      k_it->k_luku = 45;
      k_it->kysym = {122,-106,-104,105,77,-96,-110,-94,-97,-114,-114,-93,-106,-96,-95,-114,77,-114,-103,-94,-110,-95,-90,-90,-99,-110,-106,-96,-95,105,77,-100,-101,77,-103,-94,-99,-114,-114,-93,-106,-101,77,-96,-94,-106,-99,-99,-94,-102,-114,-111,-100,-101,-103,-114,-104,-104,-106,-110,-101,77,-103,-118,-90,-95,105,-102,-106,-96,-110,-110,-101,108};
      k_it->vast1 = {-128,105,-107,-104,-118,-103,-106,-101,-105,-100,-105,-110,-101,77,-114,-103,-114,-106,-96,-110,-95,77,-97,-94,-100,-107,-106,-104,-100,-95};
      k_it->vast2 = {110,-93,-100,-96,-94,-100,-95};
      k_it->vast3 = {120,-94,-106,-93,-114,-95,77,-101,-94,-97,-102,-106,-114,-103,-94,-110,-110,-95,77,-105,-114,77,-107,-110,-106,-101,-106,-104,-100,-95};
      k_it->vast4 = {120,105,-90,-95,-118,-96,-96,105,77,-100,-103,-110,-93,-114,-95,77,-99,-110,-103,-103,-100,-95};
    }

    if(kountteri == 293) {
      k_it->k_luku = 19;
      k_it->kysym = {96,124,126,79,51,-122,120,-120,-123,116,116,-119,124,-122,-121,116,51,-126,-127,51,-121,79,-123,126,120,79,51,-122,-120,124,-125,-125,-120,-128,116,119,-126,-127,127,116,126,124,-127,51,124,-127,119,124,126,116,116,-121,-121,-126,-123,124,126,116,-122,-119,124,82};
      k_it->vast1 = {97,-120,-123,-128,124,127,116,-120,123,116};
      k_it->vast2 = {99,120,127,-121,-126,127,-120,-126,123,-126};
      k_it->vast3 = {94,-126,124,-123,116,-127,123,120,124,-127,79};
      k_it->vast4 = {93,-120,-120,-123,-121,-126,-127,-120,-123,-128,124,126,126,116};
    }

    if(kountteri == 294) {
      k_it->k_luku = 20;
      k_it->kysym = {97,125,127,80,52,-125,-128,125,52,103,-119,-125,-127,121,-126,52,121,-126,-121,125,-127,-127,80,125,-126,121,-126,52,124,-125,-127,-125,118,117,117,-122,125,83};
      k_it->vast1 = {91,117,-115,52,91,117,-127,118,-122,125,-126,125};
      k_it->vast2 = {97,125,-116,121,125};
      k_it->vast3 = {94,117,119,127,59,-121,52,58,52,97,125,127,121,59,-121};
      k_it->vast4 = {88,-125,-126,59,-120,52,104,121,-128,-128,52,97,117,-127,117};
      k_it->selitys = {85,-118,117,-120,-120,125,125,-126,52,92,121,-128,-121,125,-126,123,125,-121,-121,80,52,-118,-119,-125,-126,-126,117,52,69,77,76,72};
    }

    if(kountteri == 295) {
      k_it->k_luku = 22;
      k_it->kysym = {99,127,-127,82,54,-119,123,-117,-120,119,119,-116,127,-119,-118,119,54,126,-123,-125,-123,120,119,119,-120,123,127,-119,-118,119,54,-118,119,127,54,67,-113,115,-127,123,-120,126,-123,127,-119,-118,119,54,123,127,54,-119,127,-128,119,127,-124,-124,-117,-118,54,94,123,-126,-119,127,-124,125,127,-119,-119,82,85};
      k_it->vast1 = {111,115,126,-117,127,-127,-127,119};
      k_it->vast2 = {94,123,-120,121,-117,-126,123,-119};
      k_it->vast3 = {92,119,127,-120,-113,54,106,119,-126,123};
      k_it->vast4 = {94,-117,125,-123,61,-119,54,104,-123,-123,-125};
      k_it->selitys = {105,127,-128,119,127,-118,-119,127,54,101,-117,-126,-117,-119,-119,119};
    }

    if(kountteri == 296) {
      k_it->k_luku = 78;
      k_it->kysym = {-103,-61,-71,-81,110,127,-121,-122,126,123,-70,-61,-60,-61,-68,110,-81,-70,-61,-63,-63,-81,110,-69,-73,-68,-73,-63,-62,-77,-64,-73,-68,-118,110,-62,-67,-73,-69,-73,-68,-61,-62,110,-74,-77,-68,-71,-73,-70,-85,110,-81,-73,-74,-77,-61,-62,-62,-73,110,-60,-61,-67,-68,-68,-81,110,-128,126,126,127,110,-66,-81,-74,-77,-71,-63,-61,-68,-62,-81,-81,110,-71,-77,-64,-62,-67,-69,-81,-70,-70,-81,122,110,-77,-62,-62,-118,110,127,-121,-124,126,123,-70,-61,-60,-61,-70,-70,-81,110,-70,-118,-118,-71,-77,-62,-73,-77,-62,-77,-77,-70,-70,-73,-63,-77,-77,-68,110,-102,-95,-110,123,-62,-61,-62,-71,-73,-69,-61,-71,-63,-77,-77,-68,110,-67,-63,-81,-70,-70,-73,-63,-62,-61,-69,-73,-68,-77,-68,110,-67,-70,-73,110,-69,-73,-77,-70,-77,-68,-71,-73,-73,-68,-62,-67,-73,-63,-62,-81,-115};
      k_it->vast1 = {-92,-81,-66,-66,-61,110,-94,-81,-73,-66,-81,-70,-77};
      k_it->vast2 = {-103,-81,-81,-64,-73,-68,-81,110,-95,-61,-67,-68,-73,-67};
      k_it->vast3 = {-109,-77,-60,-81,110,-103,-61,-61,-63,-71,-67,-63,-71,-73};
      k_it->vast4 = {-98,-73,-64,-71,-71,-67,110,-94,-57,-85,-70,-118,-72,-118,-64,-60,-73};
      k_it->selitys = {-95,-67,-63,-73,-81,-81,-70,-73,123,110,-72,-81,110,-62,-77,-64,-60,-77,-57,-63,-69,-73,-68,-73,-63,-62,-77,-64,-73,110,127,-121,-122,-128,123,127,-121,-122,-127};
    }

    if(kountteri == 297) {
      k_it->k_luku = 5;
      k_it->kysym = {80,122,110,115,112,102,37,117,102,113,111,116,115,37,122,113,116,120,121,106,121,121,102,37,114,110,106,109,106,115,37,112,106,109,116,37,120,122,122,119,110,115,117,110,110,119,121,106,110,115,37,121,122,116,121,121,102,102,37,126,109,105,106,120,120,65,37,117,65,110,123,65,120,120,65,68};
      k_it->vast1 = {57,58,53,37,108,119,102,114,114,102,102};
      k_it->vast2 = {54,58,53,37,108,119,102,114,114,102,102};
      k_it->vast3 = {57,49,58,37,112,110,113,116,102};
      k_it->vast4 = {54,49,58,37,112,110,113,116,102};
    }

    if(kountteri == 298) {
      k_it->k_luku = 94;
      k_it->kysym = {-85,-57,-55,-102,126,-41,-48,-57,-46,-41,-47,126,-46,-51,-46,-61,-45,-46,-46,-57,126,-97,-50,-51,-46,-46,-57,-117,-50,-51,-46,-57,-54,-65,-47,-46,-57,-61,-46,-51,-56,-102,-48,-56,-61,-47,-46,-61,-54,-53,-102,-52,-99};
      k_it->vast1 = {-93,-50,-57,-63,126,-79,-41,-47,-46,-61,-53,-47};
      k_it->vast2 = {-95,-91,-89};
      k_it->vast3 = {-78,-57,-61,-46,-51};
      k_it->vast4 = {-79,-61,-48,-44,-61,-54,-61,-63};
    }

    if(kountteri == 299) {
      k_it->k_luku = 51;
      k_it->kysym = {-128,-100,-89,111,83,-101,-84,-87,-100,-95,83,-87,-108,-95,-101,-108,-108,83,-94,-101,-99,-104,-97,-96,-94,-100,-95,-89,-100,-98,-100,-104,-97,-89,111,83,116,-93,-94,-89,-89,-100,96,-93,-94,-89,-100,-97,-108,-90,-89,-100,-104,-89,-94,-99,111,-91,-99,-104,-90,-89,-104,-97,-96,111,-90,-90,111,83,-94,-95,83,-98,111,-84,-89,-104,-89,-89,-84,114,83};
      k_it->vast1 = {-128,-120,-128,-125,-122};
      k_it->vast2 = {116,127,122,-126,127};
      k_it->vast3 = {118,-126,117,-126,127};
      k_it->vast4 = {-125,120,116,-123,127};
      k_it->selitys = {-128,-108,-90,-90,-108,-106,-101,-88,-90,-104,-89,-89,-90,83,122,-104,-95,-104,-91,-108,-97,83,123,-94,-90,-93,-100,-89,-108,-97,83,-120,-89,-100,-97,-100,-89,-84,83,-128,-88,-97,-89,-100,96,-125,-91,-94,-102,-91,-108,-96,-96,-100,-95,-102,83,-122,-84,-90,-89,-104,-96,95,83,-87,-88,-94,-105,-104,-97,-89,-108,83,100,108,105,105};
    }

    if(kountteri == 300) {
      k_it->k_luku = 93;
      k_it->kysym = {-86,-58,-56,-103,125,-48,-62,-46,-49,-66,-66,-45,-58,-48,-47,-66,125,-51,-103,-58,-59,-47,-62,-58,-48,-47,-103,125,-56,-46,-46,-55,-46,-46,125,-48,-52,-48,-58,-66,-66,-55,-58,-48,-46,-46,-47,-47,-66,125,-55,-58,-48,-103,-103,-45,-58,-58,-53,125,-62,-54,-51,-66,-47,-52,-60,-62,-62,-53,-62,-58,-59,-58,-53,-100};
      k_it->vast1 = {-86,-95,-86,-98};
      k_it->vast2 = {-79,-62,-65,-66,-58,-58,-53,-58};
      k_it->vast3 = {-88,-66,-59,-45,-58};
      k_it->vast4 = {-92,-66,-54,-54,-66};
    }

    if(kountteri == 301) {
      k_it->k_luku = 42;
      k_it->kysym = {119,-109,-98,102,74,-110,-97,-97,-105,-113,-98,-98,-117,74,-107,102,-93,-98,-113,-98,102,102,-104,74,125,-97,-103,-105,-113,-99,-99,-117,74,-106,102,102,-107,-107,-113,-113,-104,102,74,-106,-109,-110,-117,-99,-108,102,-104,-98,-113,-93,-114,-113,-104,74,-107,-117,-98,-103,-117,-105,-109,-99,-113,-113,-104,74,-113,-106,-109,74,-107,-117,-98,-117,-102,-106,-113,-107,-99,-109,-117,-117,-104,105};
      k_it->vast1 = {113,-117,-105,-105,-117};
      k_it->vast2 = {108,-97,-102,-100,-103,-102,-109,-103,-104,-109};
      k_it->vast3 = {119,-113,-99,-107,-117,-106,-109,-109,-104,-109};
      k_it->vast4 = {126,-113,-116,-117,-109,-109,-104,-109};
      k_it->selitys = {-126,-93,-100,-113,-105,74,87,-104,-109,-105,-109,-104,-113,-104,74,-106,102,102,-107,-113};
    }

    if(kountteri == 302) {
      k_it->k_luku = 33;
      k_it->kysym = {110,-118,-107,-122,-113,65,-120,-126,-114,-114,-126,-126,65,-102,-115,-122,-118,-108,-118,-114,-114,-118,-113,65,-116,93,-102,-107,-122,-107,93,93,-113,96};
      k_it->vast1 = {112,-109,-126,-126,-115,-118,-108,-122,-108,-107,-118};
      k_it->vast2 = {106,-113,-117,-122,-116,-107,-112,-118,-114,-126,-115,-115,-126};
      k_it->vast3 = {113,-106,-109,-122,-108,-116,-122,-115,-122,-114,-126,-115,-115,-126};
      k_it->vast4 = {111,-126,-108,-126,-126,-115,-118,-108,-122,-108,-107,-118};
    }

    if(kountteri == 303) {
      k_it->k_luku = 66;
      k_it->kysym = {-113,-85,-83,126,98,-79,-80,98,-75,-79,-78,-85,-72,-93,98,-82,126,-86,-74,-97,-93,-80,-80,-79,-75,98,-89,-83,-75,-74,-93,-93,-75,-85,-93,98,106,-113,-122,-113,-125,107,98,121,114,98,-83,-85,-82,-79,-85,-75,-89,-82,-82,-89,98,-86,-89,-80,-83,-85,-82,-97,-82,-82,-89,98,-72,-85,-85,-86,-90,-89,-83,126,-69,-74,-74,-97,-97,-80,-127};
      k_it->vast1 = {115,116,114,98,-81,-85,-82,-82,-85,-87,-76,-93,-81,-81,-93,-93};
      k_it->vast2 = {115,110,116,98,-87,-76,-93,-81,-81,-93,-93};
      k_it->vast3 = {115,116,98,-87,-76,-93,-81,-81,-93,-93};
      k_it->vast4 = {115,116,98,-81,-85,-82,-82,-85,-87,-76,-93,-81,-81,-93,-93};
      k_it->selitys = {-110,-93,-85,-80,-79,98,106,-83,-87,107,98,109,98,119,114,98,127,98,-93,-80,-80,-79,-75,98,-81,-85,-82,-82,-85,-87,-76,-93,-81,-81,-79,-85,-80,-93,112};
    }

    if(kountteri == 304) {
      k_it->k_luku = 17;
      k_it->kysym = {94,122,124,77,49,-128,127,49,-124,-128,-127,122,-121,114,49,127,118,-124,-123,118,-118,-123,-118,124,-124,118,127,49,-123,114,-124,-128,61,49,124,-122,127,49,-123,114,127,-124,-124,122,-123,114,114,127,49,-125,114,-121,118,62,-123,114,-127,114,121,-123,-122,126,114,-124,-124,114,49,118,124,-124,-123,114,114,-124,122,127,49,57,94,85,94,82,58,49,-121,114,122,124,-122,-123,-122,124,-124,118,127,49,114,125,114,122,-124,118,127,114,49,57,-123,114,-121,114,127,-128,126,114,122,-124,118,-124,-124,114,49,-124,122,-124,77,125,77,126,-127,110,-123,122,125,114,-124,-124,114,58,80};
      k_it->vast1 = {93,114,-124,122,125,125,122,127,118,127,49,-121,118,-123,-123,77,49,-123,-122,127,127,122,-124,-124,114};
      k_it->vast2 = {93,114,-124,122,125,125,122,127,118,127,49,-121,118,-123,-123,77,49,124,77,-118,-123,-123,110,124,118,-125,-123,114,114,49,124,-128,121,117,118,127};
      k_it->vast3 = {93,114,-124,122,125,125,122,127,118,127,49,-121,118,-123,-123,77,49,-127,118,-125,49,124,-128,125,126,118,49,-123,-122,127,-123,122,114};
      k_it->vast4 = {92,-128,125,126,118,49,125,114,-124,122,114,49,-121,118,-123,-123,77,49,124,77,-118,-123,-123,110,124,118,-125,-123,114,114,49,124,-128,121,117,118,127};
    }

    if(kountteri == 305) {
      k_it->k_luku = 11;
      k_it->kysym = {88,116,118,71,43,126,112,-128,125,108,108,-127,116,126,127,108,43,122,121,43,112,125,116,127,-124,116,126,112,121,43,126,-128,122,126,116,127,112,119,127,108,-127,108,43,117,-128,122,120,108,43,112,121,121,112,121,43,117,108,43,117,71,119,118,112,112,121,43,125,112,116,-127,108,108,120,116,126,112,121,43,112,118,126,127,108,108,126,116,108,43,51,88,79,88,76,52,43,118,71,-124,127,112,127,127,71,112,126,126,71,74};
      k_it->vast1 = {76,123,123,112,119,126,116,116,121,116,120,112,115,-128};
      k_it->vast2 = {88,108,116,127,122};
      k_it->vast3 = {95,112,112};
      k_it->vast4 = {88,116,121,112,125,108,108,119,116,-127,112,126,116};
      k_it->selitys = {78,56,-127,116,127,108,120,116,116,121,116,108,43,118,71,-124,127,112,127,71,71,121,43,126,112,125,122,127,122,121,116,116,121,116,121,127,-128,122,127,108,121,127,122,122,121,55,43,117,122,127,112,121,43,126,112,43,108,-128,127,127,108,108,43,119,108,126,118,112,-128,127,-128,120,116,126,-127,108,116,115,112,112,126,126,108};
    }

    if(kountteri == 306) {
      k_it->k_luku = 59;
      k_it->kysym = {-111,-100,-87,-81,-100,-100,-87,91,-117,119,-93,-90,-92,-87,119,-83,-92,-87,-81,-96,-96,-82,-82,119,91,-82,-92,-91,-100,-92,-87,-87,-96,-92,-82,-82,-100,91,-90,-96,-83,-93,-86,-81,-92,-89,-86,-92,-82,-82,-100,91,-81,-100,-85,-100,-93,-81,-80,-92,91,-79,-80,-86,-87,-87,-100,91,109,107,108,108,91,-90,-100,-90,-82,-92,91,-88,-80,-83,-93,-100,-100,91,-91,-100,91,-76,-90,-82,-92,91,-91,-86,-80,-90,-90,-86,-83,-100,-92,-82,-90,-100,-80,-82,105,91,-120,-92,-90,119,91,-90,-96,-83,-93,-86,91,-86,-89,-92,91,-90,-76,-82,-96,-96,-82,-82,119,122};
      k_it->vast1 = {-112,-87,-92,-81,-96,-97,91,125,-83,-86,-81,-93,-96,-83,-93,-86,-86,-97};
      k_it->vast2 = {-115,-86,-94,-80,-96,-82,91,-126,-100,-89,-89,-96,-83,-76};
      k_it->vast3 = {126,-100,-87,-87,-86,-87,-99,-100,-89,-89,91,-120,126};
      k_it->vast4 = {-120,-118,-115,-128};
    }

    if(kountteri == 307) {
      k_it->k_luku = 46;
      k_it->kysym = {123,-105,-94,-109,-100,78,-96,-105,-103,-99,-102,-102,-105,-95,-109,-94,78,-89,-96,-105,-94,-94,-105,-92,106,-94,78,-94,-113,-98,-98,-113,-113,78,-106,-93,-93,-101,-109,-98,-99,-102,-105,-105,-95,-105,78,120,-113,-96,-105,78,111,-113,-96,-100,-105,-99,-100,78,-92,-93,-99,-100,-100,-113,78,95,103,103,100,109};
      k_it->vast1 = {121,106,-95,-105,-103,-96,-113,-100,-113,-113,-94,-105,-102,-102,-113};
      k_it->vast2 = {121,-105,-92,106,106,-96,-105,-102,-102,106};
      k_it->vast3 = {123,-89,-96,-103,-89,-94,-94,106,-101,106,-102,-102,106};
      k_it->vast4 = {126,-93,-93,-103,-99,-94,-94,-113,-101,-113,-102,-102,-113};
      k_it->selitys = {121,-96,-113,-100,-113,-113,-94,-94,-105,78,-102,-109,-100,-95,-105,78,111,-113,-96,-100,-105,-99,-100,78,-103,-99,-94,-105,-98,-105,-106,-113,-102,-102,-109};
    }

    if(kountteri == 308) {
      k_it->k_luku = 48;
      k_it->kysym = {123,-107,-92,-101,108,80,-92,-107,-101,-103,-90,108,-92,80,-90,-91,-97,-98,-98,-111,80,97,105,105,102,80,117,-93,-96,-97,-97,-93,-93,-111,80,-107,-96,108,-97,-98,-98,-103,-93,-92,-91,-98,-107,-107,-98,80,-101,-94,-111,-98,-111,-111,-92,-92,-103,93,-103,-93,-101,-91,-98,92,80,-102,-97,-93,-93,-111,80,-100,-97,-91,-101,-101,-111,-111,-98,-92,-91,-103,80,-101,-111,-101,-93,-103,80,-103,-93,-101,-91,-98,80,-92,-107,-101,-103,-102,108,108,92,80,-99,-91,-94,-93,-101,-111,-92,-107,-98,80,-92,-97,-103,-93,-107,-100,-92,-111,80,-101,108,-108,-107,-98,111};
      k_it->vast1 = {114,-111,-98,-108,-103,-108,-97,-93,-103,-92};
      k_it->vast2 = {120,-107,-100,-90,-107,-92,-103,-98,80,117,-98,-101,-107,-100,-103,-92};
      k_it->vast3 = {-122,-103,-94,-97,-100,-111,-103,-93,-107,-92,80,-96,-111,-94,-103,-92,-92,-111,-102,-111,-92};
      k_it->vast4 = {126,-111,-92,-91,-94,-111,-100,80,114,-97,-94,-98,80,123,-103,-100,-100,-107,-94,-93};
      k_it->selitys = {123,-97,-104,-92,-107,-107,-98,-111,80,-97,-100,-103,80,120,-107,-100,-90,-107,-92,-103,-98,80,117,-98,-101,-107,-100,-107,-103,-108,-107,-98,80,-101,-107,-94,-104,-97,-92,-103,-100,-111,-92};
    }

    if(kountteri == 309) {
      k_it->k_luku = 48;
      k_it->kysym = {125,-103,-98,-101,108,80,-87,-104,-92,-87,-107,-107,-98,80,-100,-111,-91,-100,-111,-102,-111,80,-102,-111,80,-110,-111,-93,-103,-93,-92,-103,80,-97,-100,-103,80,114,-111,-98,-108,-103,-108,-97,-93,-103,-111,80,97,105,105,96,93,-100,-91,-90,-91,-100,-100,-111,80,-102,-97,-104,-92,-111,-98,-91,-92,80,125,-111,-94,-101,-97,80,120,-103,-94,-93,-99,-111,111};
      k_it->vast1 = {114,-111,-109,-101,-93,-100,-103,-108,-107,-94,-93};
      k_it->vast2 = {124,-97,-91,-108,-105,-91,-98,-93};
      k_it->vast3 = {119,-94,-107,-111,-93,-107,80,120,-107,-100,-99,-107,-92};
      k_it->vast4 = {-126,-91,-93,-92,80,-98,87,80,-126,-111,-105,-107};
    }

    if(kountteri == 310) {
      k_it->k_luku = 10;
      k_it->kysym = {85,111,120,111,120,42,111,125,115,-128,107,118,126,107,107,42,111,110,127,125,126,107,120,111,111,120,42,114,111,120,117,115,118,103,120,42,119,103,117,115,120,42,124,115,117,121,118,118,115,125,111,126,42,122,121,118,126,126,115,-128,107,126,42,95,127,110,111,120,119,107,107,120,42,76,124,121,119,107,124,-128,115,125,125,107,42,-128,127,121,120,120,107,42,59,67,67,64,73};
      k_it->vast1 = {93,-125,-125,126,126,70,116,70,42,92,115,126,-128,107,42,93,107,120,126,107,-128,127,121,124,111,120};
      k_it->vast2 = {82,127,127,119,111,122,121,118,115,115,125,115,120,42,122,70,70,118,118,115,117,117,103,42,84,107,124,115,42,75,107,124,120,115,121,120};
      k_it->vast3 = {89,115,117,111,127,125,119,115,120,115,125,126,111,124,115,42,85,107,124,115,42,82,70,117,70,119,115,111,114,111,120};
      k_it->vast4 = {92,115,117,121,125,-125,118,115,117,121,119,115,125,107,124,115,121,42,94,121,124,125,126,115,42,85,121,125,117,115,125,111,120};
    }

    if(kountteri == 311) {
      k_it->k_luku = 93;
      k_it->kysym = {-86,-58,-53,-56,-103,125,-49,-58,-56,-52,-55,-55,-58,-48,-57,-103,-49,-57,-62,-48,-47,-70,-53,125,-57,-103,-48,-62,-53,125,-66,-54,-51,-46,-58,125,-45,-46,-52,-53,-53,-66,125,-114,-106,-106,-110,125,-56,-58,-55,-51,-66,-58,-55,-62,-45,-66,-53,125,-57,-62,-53,-60,-58,-53,125,-47,-58,-55,-52,-57,-66,125,-48,-58,-53,-60,-52,-55,-55,-66,-100};
      k_it->vast1 = {-97,-66,-53,-63,-58,-63,-52,-48,-58,-62,-53};
      k_it->vast2 = {-91,-62,-55,-45,-62,-47,-58,-53,125,-94,-53,-56,-62,-55,-62,-58,-63,-62,-53};
      k_it->vast3 = {-78,-53,-63,-62,-49,-47,-66,-56,-62,-49,-48,-58,-53};
      k_it->vast4 = {-86,-96,125,-96,-66,-53,-53,-52,-53,-65,-66,-55,-55,-48,-58,-62,-53};
      k_it->selitys = {-88,-52,-59,-47,-62,-62,-53,-66,125,-91,-62,-55,-45,-62,-47,-58,-53,125,-94,-53,-56,-62,-55,-58,-47,-119,125,-46,-59,-49,-62,-58,-55,-47,-66,125,-48,-103,-103,-48,-47,-42,-47,-47,-58,-58,-53,-117};
    }

    if(kountteri == 312) {
      k_it->k_luku = 62;
      k_it->kysym = {-119,-77,-87,-97,94,-111,-77,-83,-85,-93,-84,94,112,110,110,110,107,-86,-77,-76,-77,-84,94,-97,-86,-77,-84,94,-80,-89,-87,-83,-86,-86,-89,-79,-82,-83,-85,-83,-89,-79,-78,-97,94,-79,-77,-77,-84,-84,-89,-78,-78,-93,-86,-89,94,-90,-77,-77,-85,-93,-79,-73,-73,-78,-78,122,-88,122,94,-112,-89,-78,-76,-97,94,-111,-97,-84,-78,-97,-76,-77,-83,-80,-93,-84,94,-97,-85,-82,-77,-85,-89,-79,-78,-97,94,-80,-73,-84,-84,122,-87,-87,-101,-87,-89,-76,122,122,-80,-89,-86,-86,122,94,127,-97,-85,-77,107,-110,-108,120,-84,94,-79,-77,-83,-80,-97,-79,-79,-97,94,-86,122,-90,-93,-78,-73,-87,-79,-93,-79,-79,122,125};
      k_it->vast1 = {-118,-97,-77,-80,-89,94,-120,-83,-90,-97,-84,-79,-79,-83,-84};
      k_it->vast2 = {-119,-93,-89,-88,-83,94,-108,-89,-86,-90,-77,-84,-93,-84};
      k_it->vast3 = {-110,-97,-80,-87,-89,94,-119,-97,-84,-91,-97,-79};
      k_it->vast4 = {-110,-97,-82,-89,-83,94,-119,-93,-87,-87,-83,-84,-93,-84};
      k_it->selitys = {-108,-89,-86,-90,-77,-84,-93,-84,94,-82,-89,-78,-89,94,-87,-77,-89,-78,-93,-84,-87,-89,-84,94,-97,-88,-97,-78,-77,-79,-78,-97,94,-90,-77,-83,-84,-83,-84,-97,108};
    }

    if(kountteri == 313) {
      k_it->k_luku = 1;
      k_it->kysym = {78,106,108,61,33,112,109,106,33,102,105,117,112,111,98,33,119,118,112,111,111,98,33,50,58,58,58,33,113,102,115,118,116,117,102,117,118,111,33,79,98,117,118,115,98,109,33,67,112,115,111,33,76,106,109,109,102,115,116,33,46,115,106,108,112,109,109,106,116,107,61,115,107,102,116,117,94,111,33,107,61,116,102,111,122,122,101,102,111,33,116,98,98,110,106,116,102,108,116,106,64};
      k_it->vast1 = {73,102,111,108,106,115,106,108,112,116};
      k_it->vast2 = {76,122,110,110,102,111,102,111,117,118,105,98,111,111,102,111,33,110,98,115,108,98,111,33,107,61,116,102,111,110,98,108,116,118};
      k_it->vast3 = {87,98,111,108,106,109,98,117,118,112,110,106,112};
      k_it->vast4 = {52,49,49,33,104,115,98,110,110,98,98,33,98,110,103,102,117,98,110,106,106,111,106,98};
    }

    if(kountteri == 314) {
      k_it->k_luku = 60;
      k_it->kysym = {-119,-91,-89,120,92,-85,-88,-91,92,-95,-92,-80,-85,-86,-99,92,-118,-99,-80,-79,-82,-99,-88,92,126,-85,-82,-86,92,-121,-91,-88,-88,-95,-82,-81,92,105,-82,-91,-89,-85,-88,-88,-91,-81,-90,120,-82,-90,-95,-81,-80,-103,-81,-80,120,92,-95,-82,-85,-99,-87,-91,-81,-95,-88,-88,-95,123};
      k_it->vast1 = {-113,-85,-82,-87,-95,-86,92,-87,-95,-86,-95,-80,-75,-81};
      k_it->vast2 = {-121,-91,-78,-95,-89,-81,-95,-86,92,-87,-95,-86,-95,-80,-75,-81};
      k_it->vast3 = {-110,-99,-82,-84,-99,-99,-86,92,-87,-95,-86,-95,-80,-75,-81};
      k_it->vast4 = {-121,-85,-82,-78,-99,-86,92,-87,-95,-86,-95,-80,-75,-81};
    }

    if(kountteri == 315) {
      k_it->k_luku = 15;
      k_it->kysym = {101,-124,126,125,125,112,47,65,63,63,63,47,123,112,119,-125,116,123,112,120,-126,116,-126,-126,112,47,122,116,113,112,113,60,127,112,120,122,112,-126,-126,112,47,-125,112,127,112,119,-125,-124,125,-124,-125,47,-125,116,123,126,120,-125,-124,-126,-125,-120,-120,123,120,125,116,125,47,122,126,123,124,126,120,-126,124,-124,-127,119,112,47,126,125,47,126,123,123,-124,-125,47,98,-124,126,124,116,125,47,-127,120,122,126,123,123,120,-126,121,116,125,118,120,116,125,47,-123,75,123,120,-126,116,125,47,-123,75,122,120,-123,112,123,123,112,125,47,119,-124,120,127,116,125,-125,-124,124,112,61,47,92,120,125,122,75,47,121,75,-127,121,116,-126,-125,108,125,47,119,120,123,121,112,-125,-125,112,120,125,47,82,112,125,125,126,125,113,112,123,123,120,-126,-125,112,47,116,-127,126,125,125,116,116,-125,47,124,-124,-127,119,112,-125,-120,108,125,47,-125,116,122,120,121,75,-125,47,127,116,-127,-124,-126,-125,120,-123,112,-125,47,124,-120,108,119,116,124,124,120,125,78};
      k_it->vast1 = {97,126,118,-124,116,-126,47,86,112,123,123,116,-127,-120};
      k_it->vast2 = {100,125,120,-125,116,115,47,81,-127,126,-125,119,116,-127,119,126,126,115};
      k_it->vast3 = {92,94,97,84};
      k_it->vast4 = {93,112,-125,-124,-127,112,123,47,81,126,-127,125,47,90,120,123,123,116,-127,-126};
      k_it->selitys = {90,126,119,-125,116,116,125,112,47,126,123,120,47,81,112,125,115,120,115,126,-126,120,125,47,121,112,47,81,123,112,114,122,47,97,119,120,125,126,-126,120,125,47,121,75,-126,116,125,120,75,61};
    }

    if(kountteri == 316) {
      k_it->k_luku = 26;
      k_it->kysym = {103,-125,-120,-123,86,58,-121,-119,-119,-114,-114,-119,-116,-125,-118,-109,119,-116,86,-123,127,-116,-126,-119,-120,58,-124,86,-115,127,-120,127,-114,58,123,-121,-118,-113,-125,-112,123,-114,58,-112,-113,-119,-120,-120,123,58,76,74,74,75,58,127,-120,-114,-125,-115,127,-120,58,-124,-119,-126,-114,123,-124,123,-120,-115,123,70,58,-124,-119,-123,123,58,-109,-116,-125,-114,-114,-125,58,-118,123,-116,-126,123,-125,-122,-122,123,123,-120,58,-114,-113,-119,126,123,58,105,-113,-114,-122,123,-111,-115,58,71,-124,127,-120,-127,-125,86,58,109,-113,-119,-121,127,127,-120,89};
      k_it->vast1 = {92,123,-120,126,-125,126,-119,-115};
      k_it->vast2 = {98,127,-122,-112,127,-114,-125,-120,58,95,-120,-123,127,-122,-125,-114};
      k_it->vast3 = {93,123,-120,-120,-119,-120,124,123,-122,-122};
      k_it->vast4 = {92,123,126,58,103,123,125,-126,-125,-120,127};
    }

    if(kountteri == 317) {
      k_it->k_luku = 89;
      k_it->kysym = {-90,-62,-60,-107,121,-58,-56,-56,-51,-51,-56,-53,-62,-55,-46,-74,-53,-107,-60,-66,-53,-63,-56,121,-60,-62,-59,-55,-70,-62,-59,-62,121,-118,-110,-110,-119,-122,-59,-50,-49,-50,-59,-59,-70,121,-88,-49,-66,-53,-60,-62,-59,-59,121,-90,-100,-109,-57,121,-60,-70,-57,-52,-52,-70,121,-52,-70,-70,-67,-70,-60,-52,-66,-66,-57,121,-84,-50,-56,-58,-66,-57,121,-95,-66,-59,-49,-66,-51,-62,-57,121,-98,-57,-60,-66,-59,-66,-62,-67,-66,-57,121,-52,-51,-70,-51,-50,-60,-52,-66,-57,-104};
      k_it->vast1 = {-94,-53,-56,-57,121,-95,-56,-64,-52};
      k_it->vast2 = {-101,-70,-67,121,-90,-70,-68,-63,-62,-57,-66};
      k_it->vast3 = {-88,-49,-66,-53,-51,-70,-60,-66,-53,-52};
      k_it->vast4 = {-101,-70,-53,-59,-66,-46};
    }

    if(kountteri == 318) {
      k_it->k_luku = 18;
      k_it->kysym = {95,123,-128,125,78,50,124,78,-124,124,119,-123,-122,111,-128,50,115,127,120,119,-122,115,127,123,123,-128,123,63,116,123,-123,-128,119,125,-123,119,-128,50,-124,115,122,-127,123,-122,-121,125,-123,119,-123,-122,115,50,-122,-121,-127,126,126,-127,123,-128,50,97,-121,126,-121,-128,50,93,78,-124,-126,123,-123,-123,78,50,-126,119,126,115,-128,-128,-121,-122,50,92,119,-124,119,50,93,115,-124,115,126,115,122,-122,123,50,-123,115,123,50,119,122,118,-127,126,126,123,-123,-122,119,-128,50,-120,115,-128,125,119,-121,-123,-122,-121,-127,127,123,-127,-128,81};
      k_it->vast1 = {84,115,-128,118,123,118,-127,-123};
      k_it->vast2 = {90,119,126,-120,119,-122,123,-128,50,87,-128,125,119,126,123,-122};
      k_it->vast3 = {85,115,-128,-128,-127,-128,116,115,126,126};
      k_it->vast4 = {100,-127,121,-121,119,-123,50,89,115,126,126,119,-124,-117};
      k_it->selitys = {95,-117,111,-123,50,122,78,-128,119,-128,50,-117,122,-122,119,-117,125,-123,123,-123,-122,78,78,-128,50,85,115,-128,-128,-127,-128,116,115,126,126,123,123,-128,50,-127,-128,50,-121,-121,-122,123,-123,-127,123,-122,-121};
    }

    if(kountteri == 319) {
      k_it->k_luku = 97;
      k_it->kysym = {-82,-54,-43,-58,-49,-127,-54,-44,-48,-127,-47,-38,-66,-45,-99,-127,-87,-58,-51,-41,-58,-43,-54,-49,-127,-90,-49,-52,-58,-51,-54,-58,-49,-127,-53,-99,-44,-58,-49,-58,-51,-51,-99,-127,-47,-54,-43,-99,-99,-127,-41,-99,-55,-54,-49,-43,-99,-99,-49,-127,-48,-51,-51,-62,-127,-119,-47,-48,-51,-54,-54,-44,-54,-49,-127,-109,-111,-110,-108,-127,-90,-44,-47,-48,-48,-44,-43,-62,-127,-43,-62,-52,-62,-41,-62,-45,-54,-52,-48,-54,-50,-54,-58,-49,-127,-50,-62,-43,-58,-45,-54,-62,-62,-51,-54,-58,-49,-127,-47,-58,-45,-42,-44,-43,-58,-58,-51,-51,-62,-118,-96};
      k_it->vast1 = {-104,-106,-111,-127,-60,-60};
      k_it->vast2 = {-108,-105,-111,-127,-60,-60};
      k_it->vast3 = {-110,-110,-111,-111,-127,-60,-60};
      k_it->vast4 = {-102,-111,-111,-127,-60,-60};
    }

    if(kountteri == 320) {
      k_it->k_luku = 54;
      k_it->kysym = {-125,-97,-87,-86,114,86,121,-105,-92,-92,-91,-92,-104,-105,-94,-94,86,-125,121,112,-87,-87,114,86,-86,-91,-97,-93,-97,-92,-85,-86,86,-128,-105,-92,-92,-101,86,88,-124,-105,-103,-103,-97,88,86,-118,-88,-105,-92,-104,-101,-88,-99,86,-87,-105,-97,86,-94,-101,-93,-90,-97,-92,-97,-93,-101,-92,-87,114,117};
      k_it->vast1 = {119,-96,-91,-97,86,-105,-85,-86,-91,-94,-94,-105,86,-90,114,-97,-92,86,-92,-105,-95,-95,-97,-95,-97,-91,-87,-95,-97,-92,86,-96,-91,-92,-91,-105};
      k_it->vast2 = {119,-87,-101,-101,-92,-95,114,-87,-97,-86,-86,-101,-94,-81,-86,-105,-97,-102,-91,-97,-87,-86,-105,-105,-92};
      k_it->vast3 = {-126,-101,-97,-95,-95,-105,-87,-97,86,-93,-85,-97,-94,-86,-105,86,-88,-97,-95,-91,-94,-94,-97,-87,-97,-94,-86,-105,86,-87,-91,-88,-93,-97,-105};
      k_it->vast4 = {-118,-91,-97,86,-92,-105,-95,-95,-101,-96,-105,86,-95,-101,-88,-98,-91,-86,-97,-94,-105,-92,86,-88,-85,-91,-95,-105,-90,-109,-81,-86,114,114,-92};
    }

    if(kountteri == 321) {
      k_it->k_luku = 21;
      k_it->kysym = {98,126,-128,81,53,127,81,-121,127,122,-120,-119,114,53,127,118,-128,-124,126,53,-117,-118,-124,-125,-125,118,53,71,69,70,78,53,127,-124,-118,-127,-118,-128,126,-125,-128,-128,-118,127,118,53,93,122,-127,-120,126,-125,124,126,-125,53,98,-114,-127,-127,-114,-123,-118,-121,-124,-125,53,-127,122,126,-123,81,127,-124,-125,-124,-120,-120,118,84};
      k_it->vast1 = {88,118,-125,-125,-124,-125,119,118,-127,-127};
      k_it->vast2 = {93,122,-127,-117,122,-119,126,-125,53,90,-125,-128,122,-127,126,-119};
      k_it->vast3 = {87,118,-125,121,126,121,-124,-120};
      k_it->vast4 = {100,-118,-119,-127,118,-116,-120};
      k_it->selitys = {104,122,-127,-117,126,-120,126,65,53,122,-119,-119,122,126,53,-128,126,-125,-128,-128,-118,127,118,53,-124,-127,-119,-118,53,-126,118,-128,-120,122,-119,-119,-118,65,53,-126,126,-128,81,53,127,-124,125,-119,126,53,-123,-124,-127,126,126,-120,126,-119,-118,-119,-128,126,-125,-119,118,118,-125};
    }

    if(kountteri == 322) {
      k_it->k_luku = 76;
      k_it->kysym = {-103,-75,-64,-120,108,-68,-120,-75,-76,-80,-79,-64,-64,-120,108,-73,-120,-59,-64,-79,-64,-120,-120,-70,108,-66,-83,-73,-79,-64,-64,-75,-71,-69,-69,-64,-64,-69,-66,-79,-75,-65,-65,-83,-117};
      k_it->vast1 = {-107,-72,-69,-73,-83,-83,-65,-63};
      k_it->vast2 = {-114,-63,-64,-83,-83,-70,-75};
      k_it->vast3 = {-114,-79,-70,-64,-65,-79,-79,-70,-75};
      k_it->vast4 = {-115,-65,-79,-64,-69,-70,-75};
    }

    if(kountteri == 323) {
      k_it->k_luku = 51;
      k_it->kysym = {-128,-100,-95,111,83,-87,-88,-94,-95,-95,-108,83,-122,-88,-94,-96,-104,-90,-90,-108,83,-89,-88,-97,-100,83,-97,-108,-100,-97,-97,-100,-90,-104,-98,-90,-100,83,-98,-104,-101,-94,-89,-89,-108,-108,83,-100,-101,-96,-100,-90,-100,111,83,-101,-94,-96,-94,-90,-104,-98,-90,-88,-108,-108,-97,-100,-90,-100,-100,-95,83,-89,-104,-98,-94,-100,-101,-100,-95,114};
      k_it->vast1 = {100,108,108,108};
      k_it->vast2 = {100,108,107,108};
      k_it->vast3 = {100,108,106,108};
      k_it->vast4 = {101,99,99,108};
    }

    if(kountteri == 324) {
      k_it->k_luku = 92;
      k_it->kysym = {-87,-59,-56,-56,-53,-59,-54,124,-48,-50,-67,-54,-49,-46,-63,-49,-48,-59,-49,-55,-59,-54,124,-48,-67,-47,-48,-59,-56,-47,-53,-57,-59,-48,-47,-49,124,-52,-53,-59,-49,-48,-63,-48,-48,-59,-59,-54,124,-81,-47,-53,-55,-63,-49,-49,-67,-101};
      k_it->vast1 = {-114,-116,-115,-115};
      k_it->vast2 = {-114,-116,-116,-115};
      k_it->vast3 = {-115,-107,-107,-115};
      k_it->vast4 = {-115,-107,-108,-115};
      k_it->selitys = {-81,-67,-55,-67,-56,-56,-67,124,-55,-43,-71,-49,124,-49,-67,-64,-53,-55,-67,-49,-53,-57,-59,-49,-55,-59,-54,124,-58,-67,124,-62,-63,-48,-59,-49,-59,-49,-55,-59,-54};
    }

    if(kountteri == 325) {
      k_it->k_luku = 48;
      k_it->kysym = {125,-103,-92,108,80,-92,-91,-97,-92,-107,-92,-92,-111,80,-97,-98,80,-97,-93,-92,-107,-92,-92,-91,80,-93,-107,-98,80,-93,-103,-93,108,-100,-92,108,-99,108,-98,80,-103,-100,-97,-101,-111,-111,-93,-91,-98,80,-92,-111,-101,-103,-111,111};
      k_it->vast1 = {123,-107,-94,-99,-111,-90,-111,-111,-104,-92,-97,-96,-91,-94,-101,-101,-107,-102,-111};
      k_it->vast2 = {125,-111,-111,-100,-103,-98,-96,-97,-103,-93,-92,-97,-111,-103,-98,-107,-103,-92,-111};
      k_it->vast3 = {-125,-96,-94,-111,-87,-99,-111,-111,-100,-107,-102,-111};
      k_it->vast4 = {125,-91,-97,-90,-103,-100,-103,-103,-99,-97,-102,-111};
    }

    if(kountteri == 326) {
      k_it->k_luku = 73;
      k_it->kysym = {-106,-78,-67,-82,-73,105,-76,-86,-66,-86,-73,105,-62,-79,-83,-82,-73,105,-78,-75,-72,-76,-86,-86,-68,-66,-86,-73,-73,-72,-76,-68,-82,-73,105,-71,-123,-78,-79,-83,-62,-67,-67,-123,-65,-123,105,-65,-86,-78,-76,-66,-67,-66,-68,105,-76,-82,-68,-67,-123,-123,-120};
      k_it->vast1 = {-103,-86,-69,-78,105,-74,-78,-73,-66,-66,-67,-67,-78,-86};
      k_it->vast2 = {-97,-86,-69,-67,-78,-73};
      k_it->vast3 = {-99,-66,-73,-73,-78,-73};
      k_it->vast4 = {-105,-82,-75,-77,-123,105,-67,-66,-73,-67,-78,-86};
    }

    if(kountteri == 327) {
      k_it->k_luku = 70;
      k_it->kysym = {-109,-81,-79,-126,102,-74,-126,-81,-82,-86,-85,102,115,102,-89,-78,-79,-75,-82,-75,-78,-81,-76,102,-78,-81,-71,-126,-79,-71,-81,102,115,102,-75,-76,102,-78,-81,-81,-70,-85,-70,-70,-65,102,-103,-69,-75,-77,-85,-71,-71,-89,102,-68,-89,-74,-69,-76,102,-80,-69,-82,-78,-81,-76,-70,-89,-89,-76,-123};
      k_it->vast1 = {-113,-78,-75,-79,-89,-89,-71,-69};
      k_it->vast2 = {-111,-75,-79,-89,-81,-81,-76,-81};
      k_it->vast3 = {-120,-69,-70,-89,-89,-76,-81};
      k_it->vast4 = {-115,-89,-77,-77,-89};
      k_it->selitys = {-113,-78,-75,-79,-89,-89,-71,-69,-89,102,-68,-75,-81,102,-82,-85,-76,-83,-81,-70,-70,-126,-126,102,-81,-78,-77,-89,-74,-89,-78,-78,-75,-81,-71,-70,-89};
    }

    if(kountteri == 328) {
      k_it->k_luku = 53;
      k_it->kysym = {-126,-98,-96,113,85,-87,-106,-99,-92,85,-97,113,-89,-97,-102,-88,-87,-98,85,-85,-86,-92,-93,-93,-106,85,103,101,101,106,85,-87,-102,-94,-91,-106,-86,-96,-88,-102,-93,97,85,-97,-92,-88,-88,-106,85,-91,-82,-88,-87,-82,-98,85,-85,-106,-98,-99,-87,-106,-94,-106,-106,-93,85,-121,-106,-106,-94,-106,-87,-87,-86,-93,-88,-106,85,-91,-92,-89,-93,-92,-95,-102,-99,-87,-98,-98,-93,116};
      k_it->vast1 = {125,-102,-95,-88,-98,-93,-100,-98,-93,85,-85,-106,-91,-106,-106,98,-106,-97,-106,-87,-87,-102,-95,-98,-97,-106,-87};
      k_it->vast2 = {-119,-102,-96,-93,-98,-95,-95,-98,-88,-102,-93,85,-96,-92,-89,-96,-102,-106,-96,-92,-86,-95,-86,-93,85,-88,113,-99,-96,-110,-98,-93,-88,-98,-93,-110,-110,-89,-98,-96,-98,-95,-87,-106};
      k_it->vast3 = {-120,-102,-83,-91,-92,98,-88,113,113,-87,-98,-110};
      k_it->vast4 = {-126,-98,-102,-88,-87,-102,-93,-95,-102,-99,-87,-98,-102,-93,85,-97,-86,-95,-96,-106,-98,-88,-98,-97,-106,85,-123,-89,-102,-88,-88,85,-126,-106,-88,-87,-102,-89,-88};
    }

    if(kountteri == 329) {
      k_it->k_luku = 19;
      k_it->kysym = {94,-120,124,-127,126,116,51,-122,-120,-120,-123,124,51,-126,-122,116,51,71,67,64,73,67,64,-119,-120,-126,-121,124,116,124,-122,-121,116,51,-122,-120,-126,-128,116,127,116,124,-122,-127,116,124,-122,124,-122,-121,116,51,126,79,-123,-122,124,124,51,-119,124,-123,-121,-122,116,-127,126,116,-123,126,116,124,127,-120,-122,-121,116,82};
      k_it->vast1 = {69,67,51,56};
      k_it->vast2 = {68,67,51,56};
      k_it->vast3 = {70,67,51,56};
      k_it->vast4 = {71,67,51,56};
    }

    if(kountteri == 330) {
      k_it->k_luku = 21;
      k_it->kysym = {96,-118,-128,118,53,-125,81,-114,-119,-119,122,-127,126,127,81,53,-123,-124,126,-120,-119,122,-119,-119,126,126,-125,53,-127,126,-125,-125,118,-125,127,-118,125,-127,126,-120,-119,118,53,127,-118,-124,-123,-118,-125,122,122,-125,118,53,-117,-118,-124,-125,-125,118,53,70,78,77,72,84};
      k_it->vast1 = {96,118,-121,126,53,107,81,81,-125,81,-125,122,-125};
      k_it->vast2 = {98,118,-119,-119,126,53,101,122,-127,-127,-124,-125,-123,81,81};
      k_it->vast3 = {90,-120,-128,-124,53,104,118,-127,-126,126,-125,122,-125};
      k_it->vast4 = {86,118,-121,-121,122,53,96,118,-121,57,-125};
    }

    if(kountteri == 331) {
      k_it->k_luku = 46;
      k_it->kysym = {121,-93,-105,-100,-103,-113,78,-95,-93,-93,-96,-109,-102,-102,-113,78,-99,-95,-113,-102,-102,-113,78,-100,-113,-105,-95,-105,-95,-94,-113,78,-109,-95,-105,-105,-100,-94,-89,-89,78,-96,-105,-98,-93,-102,-105,-113,78,-103,-93,-93,-103,-113,-93,-94,-105,-95,-94,-109,-100,78,-113,-105,-103,-113,-100,-113,109};
      k_it->vast1 = {96,102,78,83};
      k_it->vast2 = {98,102,78,83};
      k_it->vast3 = {102,78,83};
      k_it->vast4 = {101,102,78,83};
    }

    if(kountteri == 332) {
      k_it->k_luku = 13;
      k_it->kysym = {90,118,120,73,45,-128,114,-126,127,110,110,-125,118,-128,-127,110,45,-122,117,113,118,-128,-127,114,121,122,118,-128,-127,73,45,124,123,45,122,110,-127,110,121,110,123,45,127,118,-128,120,118,123,45,-128,114,120,110,120,73,-122,-127,-127,106,73,76};
      k_it->vast1 = {88,114,-127,110,122,118,118,123,118,45,119,110,45,114,120,-128,-127,110,110,-128,118};
      k_it->vast2 = {88,114,-127,110,122,118,118,123,118,45,119,110,45,110,121,120,124,117,124,121,118};
      k_it->vast3 = {92,125,118,124,118,113,118,-127,45,119,110,45,111,114,123,-127,-128,124,113,118,110,-127,-128,114,125,118,118,123,118};
      k_it->vast4 = {92,125,118,124,118,113,118,-127,45,119,110,45,81,101,90};
    }

    if(kountteri == 333) {
      k_it->k_luku = 6;
      k_it->kysym = {83,111,113,66,38,121,107,123,120,103,103,124,111,121,122,103,38,127,110,106,111,121,122,107,114,115,111,121,122,66,38,117,116,38,115,103,122,103,114,103,116,38,120,111,121,113,111,116,38,121,107,113,103,113,66,127,122,122,99,66,69};
      k_it->vast1 = {82,89,74,38,112,103,38,104,107,116,122,121,117,106,111,103,122,121,107,118,111,111,116,111};
      k_it->vast2 = {82,89,74,38,112,103,38,122,120,103,115,103,106,117,114,111};
      k_it->vast3 = {71,114,113,117,110,117,114,111,38,112,103,38,122,120,103,115,103,106,117,114,111};
      k_it->vast4 = {71,114,113,117,110,117,114,111,38,112,103,38,113,107,122,103,115,111,111,116,111};
    }

    if(kountteri == 334) {
      k_it->k_luku = 13;
      k_it->kysym = {88,-126,120,110,45,114,121,124,120,-126,-125,110,124,117,119,110,110,119,110,45,119,110,45,-128,118,121,121,124,118,123,114,123,45,99,118,117,127,114,118,113,114,123,45,120,-126,123,123,110,121,121,118,-128,-125,110,121,-127,-126,-126,-127,114,-127,-127,-126,45,120,118,127,119,124,118,-127,-127,118,45,111,121,124,116,118,-128,-128,110,110,123,45,-127,-126,123,-127,114,-125,110,123,-128,110,45,47,73,118,113,118,121,121,118,-128,118,73,45,-127,-126,123,-127,114,118,-127,110,47,45,117,73,123,114,123,45,120,110,123,-128,-128,110,110,123,45,113,114,111,110,-127,124,118,123,114,118,-127,110,45,93,118,127,110,110,-127,-127,118,125,-126,124,121,-126,114,114,123,45,119,73,-128,114,123,118,73,45,120,124,117,-127,110,110,123,76};
      k_it->vast1 = {88,110,118,-128,110,45,95,110,-128,-127,118,122,124};
      k_it->vast2 = {89,110,-126,127,110,45,85,-122,125,125,106,123,114,123};
      k_it->vast3 = {89,118,118,-128,110,45,85,114,121,122,118,123,114,123};
      k_it->vast4 = {88,110,118,119,110,45,87,-126,-126,127,118,120,120,110,121,110};
      k_it->selitys = {85,73,123,45,-128,118,118,127,-127,-122,118,45,122,-122,106,117,114,122,122,118,123,45,96,81,93,71,117,114,123};
    }

    if(kountteri == 335) {
      k_it->k_luku = 30;
      k_it->kysym = {105,-109,-121,-116,-119,127,62,-117,-115,-116,-110,127,62,-114,-105,-122,90,90,62,-111,-105,-117,-128,-115,-118,-121,127,62,-115,-116,62,-119,-121,-112,-120,127,-121,-118,-110,-109,-116,127,62,-110,-125,-117,-114,-114,-125,-118,-121,-123,127,-112,-117,-125,-116,-110,-110,-121,-121,-116,62,-125,-118,-121,62,-117,-115,-112,-117,-115,-116,-121,-125,-116,62,-119,90,-105,-110,-110,90,-117,90,90,-116,62,-109,-111,-119,-115,-116,-116,-115,-118,-118,-121,-111,-125,-125,-116,62,127,-118,-109,-111,-108,127,127,-110,-110,-125,-125,-111,-125,-125,-116,93};
      k_it->vast1 = {108,-125,-118,-120,90};
      k_it->vast2 = {105,127,-119,-111,-121,-110,-115,-121,-111,-110,127};
      k_it->vast3 = {113,-125,-121,-110,-111,-125,-117,90,-116};
      k_it->vast4 = {119,-122,-126,-125,-119,-111,90,-116};
    }

    if(kountteri == 336) {
      k_it->k_luku = 18;
      k_it->kysym = {95,123,-128,125,78,50,-121,-123,125,-127,-128,-128,-127,126,126,123,-123,119,-128,50,-122,-127,123,127,123,-122,-121,125,-123,119,-128,50,124,78,126,125,119,119,-128,50,127,-127,-124,127,-127,-128,123,115,50,125,119,122,-127,-122,119,-122,115,115,-128,50,125,78,-117,-122,-122,78,127,78,78,-128,50,-121,-123,125,-127,-128,-128,-127,126,126,123,-123,-122,115,50,115,126,-121,-123,-120,115,115,-122,119,-122,-122,115,50,119,126,123,50,-122,119,127,-126,-126,119,126,123,121,115,-124,127,119,-128,-122,-122,123,115,50,125,119,126,126,-127,-128,50,-117,127,-126,78,-124,123,81};
      k_it->vast1 = {87,-128,118,115,-121,127,119,-128,-122,123,-128};
      k_it->vast2 = {83,-120,123,-127,126,123,123,-122,-122,-127,-127,-128,50,-120,123,122,125,123,127,123,-123,119,-128};
      k_it->vast3 = {98,115,-126,-126,123,-123,-120,123,122,125,123,127,-117,125,-123,119,-128};
      k_it->vast4 = {93,-127,-128,120,123,-124,127,115,115,-122,123,-127,-128};
    }

    if(kountteri == 337) {
      k_it->k_luku = 24;
      k_it->kysym = {101,-127,-125,84,56,-117,125,-115,-118,121,121,-114,-127,-117,-116,121,56,-126,-115,-121,-123,-127,-117,-116,121,56,-121,-122,56,-125,-127,125,-124,-124,125,-116,-116,-111,56,-123,-121,-118,-123,-121,-122,125,-127,-124,-116,121,87};
      k_it->vast1 = {108,125,125};
      k_it->vast2 = {91,-121,123,121,69,91,-121,-124,121};
      k_it->vast3 = {99,121,121,-125,121,-121};
      k_it->vast4 = {93,-115,-118,-121,-117,-128,-121,-120,-120,125,-118,56,125,-122,125,-118,127,-127,121,-126,-115,-121,-123,121};
      k_it->selitys = {99,-121,-117,-125,125,125,56,-114,121,-127,-122,56,-116,125,125,-125,121,-117,-114,-127,-117,-116,121,56,-114,121,-124,-123,-127,-117,-116,125,-116,-116,121,-114,121,121,56,-116,125,125,-116,84};
    }

    if(kountteri == 338) {
      k_it->k_luku = 29;
      k_it->kysym = {106,-122,-119,-119,-116,-122,-117,61,-120,-110,-118,-116,-111,-111,-122,-122,-117,61,104,74,78,85,74,-109,-122,-127,-126,-116,-122,-127,-126,-117,61,-119,-126,-109,-122,-111,-111,89,-118,-122,-112,-126,-117,61,-120,-122,-126,-119,-111,89,-117,-106,-111,61,-109,-122,-127,-126,-116,-119,126,-120,-122,73,61,-121,-116,-120,126,61,-116,-119,-122,61,-116,-119,-119,-110,-111,61,-126,-112,-111,-126,-126,-117,89,61,-112,-110,-116,-118,126,-119,126,-122,-112,-126,-119,-119,-126,61,-115,-116,-113,-117,-116,-126,-119,-116,-120,-110,-109,126,-111,-126,-116,-119,-119,-122,-112,-110,-110,-127,-126,-119,-119,-126,92};
      k_it->vast1 = {79,77,77,77};
      k_it->vast2 = {78,86,86,82};
      k_it->vast3 = {78,86,85,82};
      k_it->vast4 = {78,86,85,77};
      k_it->selitys = {105,126,-120,-122,61,-116,-119,-122,61,-109,-116,-122,-118,126,-112,-112,126,61,78,86,85,85,74,79,77,77,77,75};
    }

    if(kountteri == 339) {
      k_it->k_luku = 66;
      k_it->kysym = {-115,-89,-80,-89,-80,98,-74,-93,-85,-74,-89,-85,-82,-85,-84,-93,-80,98,-74,-89,-79,-75,98,-79,-80,98,-72,-73,-79,-80,-80,-93,98,115,123,121,118,98,-84,-73,-81,-93,-82,-93,-80,-78,-85,-82,-83,-93,-75,-74,-93,98,-75,-93,-83,-79,-74,98,-74,-73,-79,-74,-74,-93,-80,-73,-74,98,-84,-93,98,-72,-73,-79,-80,-80,-93,98,116,114,115,121,98,-89,-90,-73,-75,-83,-73,-80,-80,-93,-75,-75,-93,98,-83,-85,-76,-84,-93,-82,-82,-85,-75,-89,-80,98,-83,-69,-75,-69,-81,-69,-83,-75,-89,-80,98,-93,-85,-86,-89,-73,-74,-74,-93,-80,-73,-74,98,100,-107,-85,-83,-93,-81,-89,-75,-75,-85,-93,-75,100,-127};
      k_it->vast1 = {-118,-93,-76,-76,-79,98,-115,-79,-75,-83,-85,-75,-89,-80};
      k_it->vast2 = {-116,-73,-86,-79,98,-115,-93,-80,-89,-76,-72,-79,-80};
      k_it->vast3 = {-115,-93,-85,-84,-73,98,-118,-93,-93,-80,-78,126,126,-80};
      k_it->vast4 = {-117,-85,-72,-93,-76,-85,98,-118,-79,-80,-83,-79,-82,-93,-80};
    }

    if(kountteri == 340) {
      k_it->k_luku = 72;
      k_it->kysym = {-107,-79,-68,-83,-74,104,-72,-79,-68,-77,-124,-74,104,-66,-87,-74,-77,-79,-76,-87,-68,-67,-73,-75,-79,-73,-74,104,-68,-73,-79,-66,-87,-68,104,-107,-87,-68,-68,-79,-78,-67,-80,-87,-74,-79,104,-109,-73,-72,-73,-69,-83,-76,-76,-83,104,-80,-124,-74,-83,-74,104,-68,-87,-79,-84,-83,-72,-83,-70,-82,-73,-70,-75,-87,-74,-69,-69,-79,-79,-74,-69,-87,104,-77,-67,-67,-76,-67,-74,-67,-68,104,-74,-124,-63,-68,-83,-76,-68,-63,104,-63,-80,-84,-63,-74,-68,-124,104,-69,-83,-77,-124,104,-70,-67,-74,-73,-74,-76,-87,-67,-69,-67,-74,-68,-87,104,-87,-76,-87,-69,-68,-79,104,-66,-67,-73,-74,-74,-87,104,121,-127,126,-128,-121};
      k_it->vast1 = {-101,-83,-79,-68,-69,-83,-75,-124,-74,104,-77,-67,-67,-77,-87,-67,-68,-68,-87};
      k_it->vast2 = {-101,-83,-79,-68,-69,-83,-75,-124,-74,104,-68,-67,-74,-68,-79,-87};
      k_it->vast3 = {-101,-83,-79,-68,-69,-83,-75,-124,-74,104,-66,-67,-73,-68,-68,-87};
      k_it->vast4 = {-101,-83,-79,-68,-69,-83,-75,-124,-74,104,-72,-124,-79,-66,-124,-124};
      k_it->selitys = {-104,-83,-70,-82,-73,-70,-75,-87,-74,-69,-69,-79,-69,-68,-87,104,-66,-79,-79,-69,-79,104,-77,-67,-67,-77,-87,-67,-68,-68,-87,116,104,-70,-67,-74,-73,-74,-76,-87,-67,-69,-67,-74,-74,-87,-69,-68,-87,104,-77,-87,-77,-69,-79,104,-77,-67,-67,-77,-87,-67,-68,-68,-87};
    }

    if(kountteri == 341) {
      k_it->k_luku = 39;
      k_it->kysym = {114,-100,-112,-107,-110,-120,71,-108,-106,-107,-116,-109,-109,-120,71,-105,-103,-106,-102,-116,-107,-101,-112,-109,-109,-120,71,122,-100,-106,-108,-116,-102,-102,-120,71,-116,-109,99,-99,-112,-107,99,71,-102,-96,-107,-101,-96,-107,-116,-112,-102,-101,99,71,-109,-120,-105,-102,-112,-102,-101,-120,71,-106,-107,71,-116,-105,99,-108,-100,-106,-117,-106,-102,-101,-100,-108,-112,-120,102,71,79,89,87,88,94,71,-101,-112,-109,-120,-102,-101,-106,80};
      k_it->vast1 = {92,71,76};
      k_it->vast2 = {88,87,71,76};
      k_it->vast3 = {89,71,76};
      k_it->vast4 = {88,92,71,76};
    }

    if(kountteri == 342) {
      k_it->k_luku = 11;
      k_it->kysym = {86,-128,116,121,118,108,43,120,122,121,112,119,119,108,43,123,125,122,126,112,121,127,116,119,119,108,43,94,-128,122,120,112,126,126,108,43,118,-128,122,119,119,112,116,121,108,43,126,-124,121,127,-124,121,112,116,126,127,71,43,119,108,123,126,116,126,127,108,43,122,121,43,112,123,71,120,-128,122,111,122,126,127,-128,120,116,108,74,43,51,61,59,60,66,43,127,116,119,108,126,127,122,52};
      k_it->vast1 = {60,67,43,48};
      k_it->vast2 = {62,67,43,48};
      k_it->vast3 = {64,67,43,48};
      k_it->vast4 = {66,67,43,48};
    }

    if(kountteri == 343) {
      k_it->k_luku = 34;
      k_it->kysym = {109,-105,-117,-112,-115,-125,66,-113,-111,-112,-106,-125,66,-114,-125,-107,-106,-125,66,-107,-125,-117,-108,-125,-107,-106,-105,-105,66,117,-105,-111,-113,-121,-107,-107,-125,66,-104,-105,-111,-107,-117,-106,-106,-125,-117,-112,66,-107,-101,127,-110,94,94,-112,97};
      k_it->vast1 = {112,-111,-117,-112,66,83,87,82};
      k_it->vast2 = {112,-111,-117,-112,66,83,87};
      k_it->vast3 = {112,-111,-117,-112,66,83,87,82,82};
      k_it->vast4 = {112,-111,-117,-112,66,83,87,82,82,82};
    }

    if(kountteri == 344) {
      k_it->k_luku = 92;
      k_it->kysym = {-87,-59,-57,-104,124,-53,-54,124,-56,-67,-49,-48,-63,-54,124,-43,-56,-63,-59,-49,-59,-54,124,-49,-43,-71,-52,-104,-101};
      k_it->vast1 = {-88,-63,-47,-57,-63,-55,-59,-67};
      k_it->vast2 = {-99,-59,-46,-53,-57,-67,-49,-46,-67,-59,-54};
      k_it->vast3 = {-91,-55,-47,-49,-53,-56,-55,-47,-57,-63,-49,-43,-71,-52,-104};
      k_it->vast4 = {-78,-67,-48,-49,-67,-49,-43,-71,-52,-104};
    }

    if(kountteri == 345) {
      k_it->k_luku = 23;
      k_it->kysym = {100,-128,-123,-126,83,55,124,-118,-128,-123,124,124,-123,55,-124,-122,-122,-117,-117,-122,-119,-128,-121,-112,116,-119,83,-121,-122,-125,-128,-128,-118,-128,55,-125,116,-112,-118,-128,55,97,120,-119,-128,55,106,-128,-125,-125,120,-123,-121,83,83,-123,55,120,-116,-117,-122,-118,-117,120,55,95,124,-125,-118,-128,-123,126,-128,-123,55,-126,124,-118,-126,-116,-118,-117,120,-118,-118,120,55,72,73,69,55,-118,-112,-112,-118,-126,-116,-116,-117,120,55,-115,-116,-122,-123,-123,120,55,73,71,72,78,86};
      k_it->vast1 = {99,120,-118,-128,-121,-128,-128,-121,-116,-123};
      k_it->vast2 = {96,-123,-127,124,-126,-117,-128,-122,-123,124,-116,-125,120,-123};
      k_it->vast3 = {99,-116,-118,-128,-126,120,-123};
      k_it->vast4 = {107,-128,-123,120,-121,120,-121,124,-119,-128,120};
    }

    if(kountteri == 346) {
      k_it->k_luku = 2;
      k_it->kysym = {79,107,118,62,34,118,103,116,111,107,62,34,114,113,110,107,107,118,107,109,109,113,34,84,107,107,118,118,99,34,87,113,117,119,109,99,107,112,103,112,34,109,62,123,118,118,107,34,117,119,109,119,114,119,113,110,107,103,110,107,111,107,117,118,62,62,112,34,120,119,113,112,112,99,34,51,59,59,56,34,109,113,106,119,99,34,99,107,106,103,119,118,118,99,112,103,103,117,117,99,34,109,107,116,108,99,117,117,99,99,112,34,78,107,103,106,119,120,99,34,110,107,103,109,107,112,120,99,116,117,107,65};
      k_it->vast1 = {84,103,120,62};
      k_it->vast2 = {84,95,111,114,117,62};
      k_it->vast3 = {86,119,106,103,116,113};
      k_it->vast4 = {78,103,118,118,119};
    }

    if(kountteri == 347) {
      k_it->k_luku = 19;
      k_it->kysym = {96,124,-127,126,79,51,126,-126,126,-126,124,-127,120,-127,51,-126,-127,51,123,-116,-119,79,51,95,102,87,77,-127,51,116,127,-126,124,-121,-120,-122,116,-127,-127,-126,-122,51,-119,124,124,123,119,120,64,51,-121,116,124,51,124,-127,-121,-123,-126,-122,-125,120,126,-121,124,124,-119,124,-122,120,120,-127,51,126,79,-116,-121,-121,112,112,-127,82};
      k_it->vast1 = {70,67,64,71,67,51,-128,124,126,-123,-126,122,-123,116,-128,-128,116,116};
      k_it->vast2 = {72,64,68,67,51,-128,124,126,-123,-126,122,-123,116,-128,-128,116,116};
      k_it->vast3 = {68,67,67,64,69,67,67,51,-128,124,126,-123,-126,122,-123,116,-128,-128,116,116};
      k_it->vast4 = {73,67,67,64,75,67,67,51,-128,124,126,-123,-126,122,-123,116,-128,-128,116,116};
    }

    if(kountteri == 348) {
      k_it->k_luku = 64;
      k_it->kysym = {-115,-87,-85,124,96,-91,-84,124,-87,-82,-88,-95,-88,-83,-81,96,-95,-84,-91,-76,-76,-87,-87,-82,96,113,121,121,112,109,-84,-75,-74,-75,-84,-84,-95,96,-71,-88,-92,-87,-77,-76,124,-83,124,124,-82,96,-116,-109,-124,109,-84,-95,-80,-80,-75,-87,-88,-87,-82,108,96,-86,-81,-87,-77,-77,-95,96,-77,-91,-82,96,-85,-75,-74,-95,96,-75,-77,-91,-87,-82,96,-91,-77,-87,-87,-82,-76,-71,-87,108,96,-91,-77,-87,-83,-91,-78,-85,-87,-85,-77,-87,96,-74,-75,-81,-92,-91,-82,96,113,121,121,116,96,-88,-75,-75,-83,-91,-85,-95,-75,-80,-80,-95,-95,-82,96,-84,-87,-87,-76,-76,-71,-82,-91,-87,-92,-91,-82,96,-123,-77,-80,-81,-81,-82,96,-76,-95,-80,-95,-75,-77,-76,-91,-82,96,-71,-88,-76,-91,-71,-92,-91,-77,-77,124,127};
      k_it->vast1 = {-112,-87,-82,-89,-74,-87,-87,-82,-87};
      k_it->vast2 = {-103,-85,-77,-87,-77,-95,-78,-74,-87,-82,-91,-82};
      k_it->vast3 = {-117,-87,-84,-80,-87,-85,-81,-82,-82,-95};
      k_it->vast4 = {-117,-87,-77,-77,-95};
    }

    if(kountteri == 349) {
      k_it->k_luku = 72;
      k_it->kysym = {-107,-79,-77,-124,104,-69,-83,-67,-70,-87,-87,-66,-79,-69,-68,-87,104,-87,-79,-74,-83,-79,-69,-68,-87,104,-74,-124,-77,-63,-63,104,-76,-63,-80,-63,-79,-75,-75,-124,-74,104,-87,-78,-87,-74,104,-66,-79,-70,-68,-69,-87,-68,-83,-69,-68,-83,-79,-69,-69,-124,-121};
      k_it->vast1 = {-108,-101,-116};
      k_it->vast2 = {-109,-73,-77,-87,-79,-79,-74,-79};
      k_it->vast3 = {-115,-77,-69,-68,-87,-87,-69,-79};
      k_it->vast4 = {-107,-83,-68,-87,-75,-82,-83,-68,-87,-75,-79,-79,-74,-79};
      k_it->selitys = {121,122,117,122,124,104,-68,-67,-74,-68,-79,-87,116,104,-75,-67,-67,-68,104,-63,-76,-79,104,-77,-87,-77,-69,-79,104,-72,-124,-79,-66,-124,-124};
    }

    if(kountteri == 350) {
      k_it->k_luku = 68;
      k_it->kysym = {-113,-87,-83,-72,-128,100,-104,-71,-74,-71,-78,100,-70,-71,-77,-88,-87,-78,100,118,116,117,123,100,-76,-71,-71,-81,-81,-77,-72,-87,-74,-74,-77,-74,-83,113,-83,-73,-81,-71,-78,100,-72,-87,-81,-83,-82,-128,100,-76,-67,-74,-81,-83,100,-70,-91,-80,-83,-72,-73,-87,-79,-91,-91,-78,100,-71,-84,-74,-83,-81,-73,-87,-87,-78,-125};
      k_it->vast1 = {-110,-91,-83,-73,-83,-91};
      k_it->vast2 = {-113,-74,-83,-73,-72,-83,-72,-72,-67,-82,-128};
      k_it->vast3 = {-116,-77,-79,-77,-73,-87,-81,-73,-71,-91,-91,-80,-87,-82,-91};
      k_it->vast4 = {-104,-71,-74,-71,-78,100,-108,-91,-80,-80,-77,-73,-87,-71,-74,-91,-78,100,-81,-91,-78,-78,-91,-72,-72,-91,-82,-83,-91};
      k_it->luk4 = true;
    }

    if(kountteri == 351) {
      k_it->k_luku = 18;
      k_it->kysym = {95,123,125,78,50,-127,126,123,50,102,-121,-124,-121,-128,50,-120,-121,-127,118,119,-128,50,68,66,67,73,50,-122,119,-124,-124,-127,-124,123,63,123,-123,125,-121,-128,50,-122,119,125,123,124,78,-128,50,125,78,-117,-122,-122,78,127,78,50,115,-123,119,81};
      k_it->vast1 = {93,119,123,-122,-122,123,111,-120,119,123,-122,-123,123};
      k_it->vast2 = {104,123,123,118,115,125,125,-127,-120,119,123,-122,-123,123};
      k_it->vast3 = {95,-127,-124,115,63,-126,-121,-121,125,125,-127};
      k_it->vast4 = {104,78,125,123,-126,-121,-121,125,125,-127};
    }

    if(kountteri == 352) {
      k_it->k_luku = 93;
      k_it->kysym = {-86,-58,-48,-47,-103,125,-79,-46,-49,-46,-53,125,-45,-46,-52,-63,-62,-53,125,-113,-115,-114,-108,125,-51,-46,-46,-56,-52,-47,-46,-48,-58,-48,-56,-46,-53,125,-47,-62,-56,-58,-57,-103,125,-56,-62,-49,-47,-52,-58,125,-56,-46,-46,-55,-46,-48,-47,-62,-55,-46,-58,-48,-48,-66,125,-48,-66,-66,-53,-62,-62,-53,-48,-66,125,-56,-103,-48,-56,-42,-53,125,-47,-52,-47,-62,-46,-47,-47,-66,-66,125,-58,-48,-56,-46,-100};
      k_it->vast1 = {-79,-66,-58,-45,-66,-66,-48,-47,-66};
      k_it->vast2 = {-98,-55,-118,-82,-66,-58,-63,-66,-55,-47,-66};
      k_it->vast3 = {-90,-80,-90,-80,-58,-55,-47,-103};
      k_it->vast4 = {-79,-66,-55,-62,-65,-66,-53,-62,-58,-55,-47,-66};
    }

    if(kountteri == 353) {
      k_it->k_luku = 44;
      k_it->kysym = {121,-107,-102,-105,104,76,-102,-107,-103,-107,-102,-111,-102,76,-101,-104,-107,76,-96,-115,-107,-96,-111,-107,-104,-107,-106,-115,76,-127,-104,-104,-115,76,119,-115,-98,-96,-96,-95,-97,-111,-102,76,-96,-111,-101,-97,88,76,-106,-101,-102,-105,-115,76,-96,-115,-98,-105,-101,-107,-96,-95,-97,76,-101,-104,-107,76,-115,-98,-94,-101,-97,-96,-111,-104,-104,-115,76,-104,-115,-100,-97,-107,-100,-101,-98,-102,-101,-115,88,76,-103,-95,-96,-96,-115,76,-106,-101,-105,-115,76,-107,-96,-97,-111,76,-96,-101,-107,76,-96,-111,-105,-107,-106,104,-104,-104,-111,-111,-102,76,-96,-95,-101,-103,-107,-101,-102,76,-104,-115,-100,-97,-107,-100,-101,-98,-102,-101,-102,76,-108,-115,-104,-104,-95,-97,-97,-115,-100,-107,-112,-101,-97,-96,-115,76,-106,-115,76,-104,-111,-94,-107,-96,-96,104,-103,-107,-97,-111,-97,-96,104,76,-94,-95,-101,-102,-102,-115,76,94,92,92,100,107};
      k_it->vast1 = {122,-111,-107,-96,-97,-91,-96,-108,-95,-101,-98,-115,-105,-107,-98,-105,-105,-101};
      k_it->vast2 = {-126,-107,-96,-96,-95,-100,-115,-97,-105,-115,-103,-101,-97,-105,-111,-107,-106,-115};
      k_it->vast3 = {124,-115,-115,-94,-107,-102,-95,-102,-102,-115,-114,-101,-98,-112,-111,-104,-104,-107};
      k_it->vast4 = {127,-111,-105,-97,-107,-100,-101,-98,-102,-101,-105,-115,-100,-100,-111,-104,-107};
      k_it->selitys = {-128,-95,-101,-103,-107,-101,-96,-115,76,-111,-107,76,-104,-115,-107,-96,-111,-96,-96,-95,76,-96,104,-91,-96,104,-102,-96,-119,-119,-102,76,-96,-111,-105,-107,-106,104,-102,76,-111,-111,-96,-96,-107,-97,-111,-102,76,-103,-101,-96,-107,-107,-94,-107,-102,76,-94,-95,-101,-105,-97,-107,90};
    }

    if(kountteri == 354) {
      k_it->k_luku = 21;
      k_it->kysym = {98,126,-128,81,53,-120,122,-118,-121,118,118,-117,126,-120,-119,118,53,126,-125,-120,-119,126,-119,-118,-118,-119,126,-124,126,-120,-119,118,53,127,81,126,53,-117,-118,-124,-125,-125,118,53,71,69,70,74,53,-128,126,126,-125,-125,126,53,88,-124,-126,126,120,53,104,118,-125,-120,53,66,123,-124,-125,-119,126,-125,53,-128,81,-114,-119,114,-120,-119,81,84};
      k_it->vast1 = {110,-127,126,-124,-123,-123,126,-127,118,-120,-119,-118,-119,-128,126,-125,-119,-124,-127,118,-118,-119,118,-128,-118,-125,-119,118};
      k_it->vast2 = {100,-123,122,-119,-118,-120,66,53,127,118,53,-128,-118,-127,-119,-119,-118,-118,-121,126,-126,126,-125,126,-120,-119,122,-121,126,114};
      k_it->vast3 = {105,118,126,-119,122,122,-125,53,-128,122,-120,-128,-118,-120,-119,-124,126,-126,126,-128,-118,-125,-119,118};
      k_it->vast4 = {96,-124,-119,126,-126,118,126,-120,-119,122,-125,53,-128,126,122,-127,-119,122,-125,53,-128,122,-120,-128,-118,-120};
    }

    if(kountteri == 355) {
      k_it->k_luku = 85;
      k_it->kysym = {-94,-66,-55,-111,117,-55,-74,-57,-64,-60,-66,-55,-55,-74,-74,117,119,-66,-61,-72,-74,-63,-63,119,117,-56,-70,-64,-56,-66,-55,-50,-78,-61,117,-64,-60,-61,-55,-70,-64,-56,-55,-66,-56,-56,-74,-108};
      k_it->vast1 = {-106,-56,-66,-74,-64,-74,-56,117,-62,-70,-61,-70,-70,117,-62,-50,-50,-65,-111,-61,117,-63,-54,-60};
      k_it->vast2 = {-94,-50,-50,-65,-111,117,-56,-74,-74,-59,-54,-54,117,-74,-56,-66,-74,-64,-64,-74,-74,-61,117,-63,-54,-60};
      k_it->vast3 = {-94,-50,-50,-65,-111,117,-56,-60,-66,-55,-55,-74,-74,117,-74,-56,-66,-74,-64,-64,-74,-74,-63,-63,-70};
      k_it->vast4 = {-106,-56,-66,-74,-64,-74,-56,117,-56,-60,-66,-55,-55,-74,-74,117,-62,-50,-50,-65,-111,-63,-63,-70};
    }

    if(kountteri == 356) {
      k_it->k_luku = 92;
      k_it->kysym = {-87,-59,-60,-59,-54,124,-56,-43,-60,-63,-54,-54,-63,124,126,-85,-77,-85,126,124,-46,-59,-59,-48,-48,-67,-67,124,-49,-63,-57,-49,-59,-48,-43,-71,-54,124,-57,-53,-54,-48,-63,-57,-49,-48,-59,-49,-49,-67,-101};
      k_it->vast1 = {-81,-47,-47,-49,-63,-57,-49,-59,-59,-54,124,-59,-56,-55,-67,-54,124,-57,-53,-54,-64,-53,-55,-59,-67};
      k_it->vast2 = {-99,-54,-67,-67,-56,-59,-49,-63,-57,-49,-59,-59,-54};
      k_it->vast3 = {-89,-47,-56,-48,-67,-59,-49,-63,-63,-54,124,-49,-47,-59,-60,-57,-47,-47,-54};
      k_it->vast4 = {-75,-60,-64,-43,-54,-48,-104,-104,-54,124,-57,-53,-54,-64,-53,-55,-59,-54,124,-57,-67,-54,-49,-49,-67};
      k_it->selitys = {-85,-50,-67,-56,124,-77,-59,-48,-60,-85,-47,-48};
    }

    if(kountteri == 357) {
      k_it->k_luku = 47;
      k_it->kysym = {124,-104,-93,107,79,-94,-112,-99,-112,79,81,-105,-108,-99,-93,-112,-104,81,79,-91,-112,-95,-94,-104,-99,-112,-104,-94,-108,-94,-93,-104,79,-93,-112,-95,-102,-98,-104,-93,-93,-112,-112,110};
      k_it->vast1 = {127,-108,-95,-91,-108,-95,-94,-104,-98,-93,-112};
      k_it->vast2 = {123,-98,-99,-102,-108,-95,-98,-112};
      k_it->vast3 = {-120,-105,-109,-88,-99,-93,107,107};
      k_it->vast4 = {-126,-112,-109,-98,-100,-112,-94,-98,-102,-104,-94,-100,-104,-112};
      k_it->selitys = {123,-88,-105,-108,-99,-99,-108,79,-93,-108,-95,-100,-104,-94,-93,107,79,81,-105,-108,-99,-93,-112,-104,79,-94,-108,-104,-88,-98,-102,-92,81,91,79,-94,-108,-102,-94,-92,-112,-112,-101,-104,-99,-108,-99,79,-97,-108,-95,-91,-108,-95,-94,-104,-98};
    }

    if(kountteri == 358) {
      k_it->k_luku = 8;
      k_it->kysym = {85,113,115,68,40,119,116,113,40,90,105,125,117,105,116,116,105,40,124,105,117,117,113,115,125,125,123,123,105,40,57,65,64,65,40,115,105,115,123,113,40,116,125,119,115,115,105,124,119,126,109,122,113,105,105,118,40,113,123,68,118,123,68,40,105,123,109,109,116,116,105,40,105,117,120,125,118,109,109,118,40,57,60,53,126,125,119,124,113,105,105,118,40,120,119,114,105,118,40,117,119,124,113,113,126,113,71};
      k_it->vast1 = {90,109,105,115,124,113,119,40,115,119,125,116,125,115,113,125,123,105,105,117,113,123,109,109,118};
      k_it->vast2 = {90,113,113,124,105,40,126,109,116,115,119,114,109,118,40,120,109,122,113,117,113,123,109,123,124,68};
      k_it->vast3 = {91,115,113,124,123,119,110,122,109,118,113,123,109,124,40,112,105,122,112,105,124};
      k_it->vast4 = {94,105,122,105,123,124,109,124,125,124,40,114,68,68,115,113,109,115,115,119,115,119,122,124,113,124};
    }

    if(kountteri == 359) {
      k_it->k_luku = 46;
      k_it->kysym = {-121,-102,-105,-99,-98,-98,-105,-102,-113,-95,-102,-109,-106,-110,-109,-100,78,-98,106,106,-94,-99,-105,-101,-105,-94,-94,-113,-104,-113,78,-104,-113,78,-94,-99,-105,-101,-105,-94,-94,-113,-104,-113,78,-93,-102,-99,-95,-94,-105,-92,-113,-94,78,-102,-105,-100,-104,-113,91,-113,-93,-94,-99,-95,-95,-113,78,-106,-99,-93,-95,-93,-105,-106,-105,-100,-95,-113,78,-102,-109,-106,-110,-109,-100,78,95,94,94,91,-92,-93,-99,-94,-105,-95,-104,-93,-106,-102,-113,-100,-93,-101,-109,-96,-99,-95,-95,-113,78,-106,-109,-102,-101,-105,-103,-93,-93,-95,-95,-113,78,96,94,95,97,78,-99,-102,-102,-109,-109,-100,78,-96,-109,-98,-99,-96,-94,-113,-113,-95,-105,-100,78,-101,-93,-103,-113,-113,-100,92,78,123,-105,-106,-105,-100,78,-102,-105,-100,-104,-113,91,-113,-93,-94,-99,78,-99,-102,-105,78,-101,-113,-94,-103,-113,-102,-102,-113,109};
      k_it->vast1 = {-126,-93,-96,-103,-93,-93,-100};
      k_it->vast2 = {118,-109,-102,-95,-105,-100,-103,-105,-105,-100};
      k_it->vast3 = {-126,-113,-101,-98,-109,-96,-109,-109,-102,-102,-109};
      k_it->vast4 = {122,-113,-106,-94,-109,-109,-100};
    }

    if(kountteri == 360) {
      k_it->k_luku = 66;
      k_it->kysym = {-113,-85,-74,-89,-80,98,-78,-85,-74,-83,126,98,-79,-82,-85,98,-116,-93,-76,-85,98,-107,-85,-82,-82,-93,-80,-78,126,126,-80,98,-75,-93,-93,-81,-93,98,-74,-73,-79,-81,-85,-79,98,-83,-93,-86,-90,-89,-75,-74,-93,98,-81,-89,-74,-93,-81,-88,-89,-74,-93,-81,-85,-85,-80,-85,-80,98,-83,126,-69,-74,-74,-97,126,98,-83,-79,-75,-83,-89,-80,-89,-89,-75,-74,-93,98,-76,-85,-83,-79,-83,-75,-89,-75,-74,-93,-127};
      k_it->vast1 = {-115,-69,-81,-81,-89,-80,-89,-80,98,-83,-73,-73,-83,-93,-73,-74,-74,-93,98,-89,-86,-90,-79,-82,-82,-85,-75,-74,-93};
      k_it->vast2 = {-115,-73,-73,-75,-85,98,-83,-73,-73,-83,-93,-73,-74,-74,-93,98,-89,-86,-90,-79,-82,-82,-85,-75,-74,-93};
      k_it->vast3 = {-115,-93,-83,-75,-85,98,-83,-73,-73,-83,-93,-73,-74,-74,-93,98,-89,-86,-90,-79,-74,-79,-80,-74,-93};
      k_it->vast4 = {-115,-73,-73,-75,-85,98,-83,-73,-73,-83,-93,-73,-74,-74,-93,98,-89,-86,-90,-79,-74,-79,-80,-74,-93};
    }

    if(kountteri == 361) {
      k_it->k_luku = 29;
      k_it->kysym = {106,-122,-123,-122,-117,61,-113,-110,-110,-118,-122,-122,-117,-116,-112,126,126,-117,61,-123,-110,-110,-118,126,-110,-112,126,-122,-117,-126,61,-116,-117,61,-112,-110,-116,-112,-122,-111,-126,-119,-111,126,-109,126,126,61,-122,-117,-121,-126,-120,-111,-116,-122,-127,126,61,-113,-122,-112,-120,-122,-126,-117,61,-118,-122,-117,-122,-118,-116,-122,-118,-122,-112,-126,-120,-112,-122,92};
      k_it->vast1 = {104,89,-112,-122,-109,126,-113,-111,-126,-126,-117};
      k_it->vast2 = {109,89,89,-117,61,126,-119,-110,-126,-126,-119,-119,-126};
      k_it->vast3 = {111,-126,-122,-111,-126,-126,-117};
      k_it->vast4 = {104,89,-118,-118,-126,-117,-126,-126,-117};
    }

    if(kountteri == 362) {
      k_it->k_luku = 92;
      k_it->kysym = {-89,-47,-59,-54,-57,-67,124,-49,-43,-46,-104,-56,-56,-63,124,-59,-54,-58,-63,-57,-48,-59,-53,-54,-63,-47,-56,-67,124,-57,-67,-54,-54,-67,-48,-48,-67,-67,124,-63,-54,-59,-55,-55,-59,-56,-56,-104,-104,-54,124,-48,-43,-71,-54,-48,-104,-104,-120,124,-57,-47,-54,124,-48,-67,-50,-57,-53,-59,-48,-47,-49,124,-53,-54,124,-46,-59,-63,-64,-104,124,-60,-47,-47,-55,-67,-47,-49,-67,-59,-54,-63,-48,-48,-67,124,-49,-47,-53,-54,-63,-63,-54,-120,124,-55,-47,-48,-48,-67,124,-46,-104,-56,-48,-48,-104,-104,124,-46,-67,-56,-48,-59,-55,-53,-48,-101};
      k_it->vast1 = {-75,-57,-49,-59,124,-49,-63,-54,-48,-48,-59,-55,-63,-48,-50,-59};
      k_it->vast2 = {-89,-67,-57,-49,-59,124,-49,-63,-54,-48,-48,-59,-55,-63,-48,-50,-59,-104};
      k_it->vast3 = {-84,-47,-53,-56,-59,124,-49,-63,-54,-48,-48,-59,-55,-63,-48,-50,-59,-104};
      k_it->vast4 = {-89,-53,-56,-55,-63,124,-49,-63,-54,-48,-48,-59,-55,-63,-48,-50,-59,-104};
    }

    if(kountteri == 363) {
      k_it->k_luku = 32;
      k_it->kysym = {109,-119,-117,92,64,-109,-123,-107,-110,-127,-127,-106,-119,-109,-108,-127,64,-127,-109,-119,-113,-119,-109,-108,-127,64,-123,-119,64,-115,-119,-123,-109,-127,-109,-119,-127,-115,-119,-123,-109,64,104,-123,-114,-110,-103,64,108,-127,-127,-109,-127,-109,-123,-114,64,-115,-107,-117,-127,-127,-114,64,-109,-113,-106,-119,64,-116,-127,-119,-114,-117,-127,-127,-114,64,-114,-127,-119,-109,-123,-116,-116,-123,95};
      k_it->vast1 = {116,-127,-108,-107,-113,-119,-114,-114,-119,-108};
      k_it->vast2 = {97,-123,-110,-113,-126,-119,-125};
      k_it->vast3 = {97,-118,-113,-117,-113,-110,-108,-108,-119};
      k_it->vast4 = {97,-116,-117,-113,-120,-113,-116,-119};
    }

    if(kountteri == 364) {
      k_it->k_luku = 88;
      k_it->kysym = {-91,-63,-58,-61,-108,120,-58,-63,-59,-63,-53,-67,-60,-52,-108,120,-56,-60,-71,-58,-67,-67,-52,-71,-60,-52,-71,120,-57,-60,-63,-50,-71,-52,120,-61,-57,-52,-57,-63,-53,-63,-58,120,-71,-50,-71,-54,-51,-51,-53,-57,-60,-67,-58,-58,-57,-52,-124,120,-62,-57,-52,-61,-71,120,-52,-67,-60,-67,-56,-57,-54,-52,-52,-71,-53,-63,-50,-71,-52,120,-94,-51,-64,-71,-58,120,-71,-66,120,-97,-54,-71,-58,-58,-63,-58,120,-47,-75,-60,-60,-108,120,-51,-60,-57,-53,120,-61,-57,-68,-63,-53,-52,-71,-71,-58,120,-64,-108,-58,-67,-58,120,-57,-60,-60,-67,-53,-53,-71,-71,-58,120,-58,-67,-60,-62,-108,120,-50,-51,-57,-52,-63,-71,-53,-105};
      k_it->vast1 = {-86,-67,-52,-63,-69,-51,-59,-123,-116};
      k_it->vast2 = {-97,-71,-60,-60,-63,-66,-54,-67,-47};
      k_it->vast3 = {-101,-71,-56,-54,-63,-69,-71};
      k_it->vast4 = {-81,-57,-54,-60,-57,-54,-58};
    }

    if(kountteri == 365) {
      k_it->k_luku = 57;
      k_it->kysym = {-122,-94,-92,117,89,-78,-95,-83,-78,-98,89,-88,-83,-98,-83,-83,-94,-94,-89,89,-119,-85,-88,-81,-94,-89,-84,-84,-94,-85,-88,-100,-92,-94,-84,-84,-102,89,106,114,114,113,89,-87,-88,-91,-94,-94,-84,-94,-89,89,-83,-102,-85,-92,-92,-102,-94,-91,-82,-82,-89,101,89,-92,-88,-84,-92,-102,89,-91,-94,-94,-92,-92,-98,-91,-91,117,89,-88,-91,-94,89,-95,-82,-95,-82,-93,-102,89,-92,-94,-85,-92,-92,-88,-93,-102,89,-87,-88,-91,-83,-83,-102,-81,-94,-84,-83,-102,89,-84,-102,-102,-83,-102,-89,-102,-89,-87,-102,-91,-81,-88,-93,-94,-84,-83,-102,120};
      k_it->vast1 = {-127,-126,-122};
      k_it->vast2 = {-128,-88,-102,-83,-90,-88,-88,-89};
      k_it->vast3 = {-115,-95,-78,89,-116,-98,-85,-87,-98,-89,-83};
      k_it->vast4 = {-122,-88,-88,-89,-84,-88,-85,-85,-88,-80};
    }

    if(kountteri == 366) {
      k_it->k_luku = 14;
      k_it->kysym = {91,119,-127,-127,74,46,126,74,119,124,46,100,119,-128,125,111,46,-127,119,120,111,119,-126,-127,119,46,112,119,-126,113,125,119,124,59,123,119,122,120,125,124,74,74,-128,119,46,96,119,-127,-126,125,46,94,119,115,-126,119,122,74,124,46,125,123,119,-127,-126,111,123,111,46,121,111,-128,-126,111,124,125,58,46,120,125,121,111,46,-126,-125,118,125,-125,-126,-125,119,46,-126,-125,122,119,126,111,122,125,-127,-127,111,46,-124,-125,125,124,124,111,46,64,62,63,70,77};
      k_it->vast1 = {100,119,-128,-125,59,92,119,117,-125,122,111,-127,-127,111};
      k_it->vast2 = {90,74,74,124,115,59,86,111,-128,120,-125,-127,-127,111};
      k_it->vast3 = {100,74,119,121,115,59,91,111,111,-128,120,111,-127,-127,111};
      k_it->vast4 = {89,125,118,-126,122,111,59,88,74,-128,-124,115,-127,-127,74};
    }

    if(kountteri == 367) {
      k_it->k_luku = 58;
      k_it->kysym = {-121,-93,-90,-90,-97,90,-91,-87,-94,-82,-97,-97,-90,-90,-97,90,-80,-81,-87,-88,-88,-101,90,107,115,113,114,90,-86,-93,-83,-82,-87,-87,-90,-93,-90,-90,-101,90,-92,-101,90,-86,-81,-81,-91,-87,-90,-90,-101,90,-90,-97,-88,-82,-87,-91,-87,-88,-97,-97,-88,90,-119,-81,-90,-81,103,-126,-97,-90,-83,-93,-88,-91,-93,103,-90,-97,-88,-88,-87,-90,-90,-101,90,-91,-101,-101,-86,-101,-88,-88,-81,-82,90,-89,-93,-97,-83,90,-80,-101,-101,-82,-93,90,-87,-83,-87,-93,-82,-97,-82,-82,-101,-80,-101,-91,-83,-93,90,-90,-81,-88,-88,-101,-83,-80,-101,-101,-82,-93,-89,-81,-91,-83,-93,-83,-83,-101,-101,-88,90,113,111,90,106,106,106,90,-89,-101,-84,-91,-91,-101,-101,121};
      k_it->vast1 = {-115,-119,-115,103,-122,-101,-86,-83,-93,-91,-77,-90,118};
      k_it->vast2 = {-115,-81,-87,-89,-97,-88,90,-113,-120,-125,125,127,-128};
      k_it->vast3 = {-121,-101,-88,-88,-97,-84,-94,-97,-93,-89,-93,-88,90,-122,-101,-83,-82,-97,-88,-83,-81,-87,-92,-97,-90,-81,-90,-93,-93,-82,-87};
      k_it->vast4 = {-122,-93,-87,-88,-83,-91,-90,-81,-100,-93};
      k_it->selitys = {-122,-93,-83,118,-91,-83,-93,90,107,106,106,90,106,106,106,90,-89,-101,-84,-91,-91,-101,-101,90,-123,-101,-81,-88,-93,-101,-90,-101,-88,90,-83,-87,-82,-101,-80,-101,-89,-89,-101,-83,-101,-93,-84,-101,-101,-90,-101,-90,-90,-97,90,-92,-101,90,111,106,106,90,106,106,106,90,-89,-101,-84,-91,-91,-101,-101,90,-87,-89,-101,-90,-90,-97,90,-86,-97,-84,-94,-97,-97,-90,-90,-97,-97,-88};
    }

    if(kountteri == 368) {
      k_it->k_luku = 81;
      k_it->kysym = {-98,-70,-65,-68,-115,113,-63,-58,-64,-67,-58,-74,-74,-65,113,-59,-64,-70,-66,-70,-60,-59,-64,-64,-65,113,-100,-64,-68,-64,-64,-66,-58,-60,-65,-58,-64,-61,-74,-59,113,-67,-115,-71,-74,-59,-59,-70,-57,-115,-59,113,-57,-58,-64,-65,-65,-78,113,-125,-127,-126,-121,113,-73,-64,-67,-70,-64,-71,-78,-59,-58,-65,-112};
      k_it->vast1 = {-100,-61,-70,-60,-59,-70,-67,-67,-70,-60,-75,-74,-66,-64,-68,-61,-78,-78,-59,-59,-70,-74,-65};
      k_it->vast2 = {-100,-74,-60,-68,-58,-60,-59,-78,-65};
      k_it->vast3 = {-95,-74,-61,-58,-60,-60,-58,-64,-66,-78,-67,-78,-70,-60,-59,-74,-65};
      k_it->vast4 = {-89,-70,-71,-61,-74,-70,-75,-74,-65};
      k_it->selitys = {-92,-54,-54,-65,-115,113,-95,-115,-70,-57,-70,113,-93,-115,-60,-115,-60,-74,-65,113,-68,-70,-61,-69,-78,125,113,-69,-64,-68,-78,113,-68,-115,-60,-70,-59,-59,-74,-67,-70,113,-78,-57,-70,-64,-67,-70,-70,-59,-59,-64,-78,127};
    }

    if(kountteri == 369) {
      k_it->k_luku = 43;
      k_it->kysym = {118,-96,-108,-103,-106,-116,75,-104,-102,-103,-97,-116,75,-98,-96,-102,-104,-116,-105,-116,-108,-98,-97,-116,75,-104,-112,-103,-112,-109,-97,-92,-108,75,-95,-96,-102,-113,-112,-103,75,93,91,91,95,75,116,-103,-97,-108,-116,-103,75,-95,-116,-105,-97,-116,-104,-112,-99,-112,-103,75,-97,-98,-96,-103,-116,-104,-108,-98,-98,-116,106};
      k_it->vast1 = {92,98,100};
      k_it->vast2 = {98,100};
      k_it->vast3 = {93,98,100};
      k_it->vast4 = {94,98,100};
    }

    if(kountteri == 370) {
      k_it->k_luku = 24;
      k_it->kysym = {101,-127,-122,-125,84,56,-123,125,-118,-125,-125,-127,-117,125,-124,-124,84,56,-120,-121,-124,-125,-115,-120,-111,117,-118,84,-124,-124,84,56,99,-111,-124,-124,-127,-125,-125,-127,56,107,121,121,-118,-127,56,121,-126,-121,-127,87};
      k_it->vast1 = {104,-121,-128,-126,121,-122,56,99,-118,-115,-115,-122,-115};
      k_it->vast2 = {104,-111,-118,-125,-127,-126,84};
      k_it->vast3 = {90,-127,121,-122,123,-128,-127};
      k_it->vast4 = {96,125,-124,-125,121,-123,121};
    }

    if(kountteri == 371) {
      k_it->k_luku = 53;
      k_it->kysym = {-126,-98,-99,-98,-93,85,-106,-98,-96,-106,-106,-93,85,-85,-86,-92,-103,-102,-88,-87,-106,85,118,-95,-96,-92,-93,85,-94,-82,-82,-93,-87,-98,85,-92,-93,85,-88,-86,-86,-89,-98,-94,-94,-98,-95,-95,-106,-106,-93,116};
      k_it->vast1 = {127,-92,-86,-95,-86,-93,-106};
      k_it->vast2 = {-117,-106,-91,-91,-86,-93,-106};
      k_it->vast3 = {127,-86,-99,-106,-93,-93,-86,-96,-88,-102,-93,-106};
      k_it->vast4 = {-118,-86,-87,-102,-93,-106,85,-85,-86,-92,-93,-93,-106};
    }

    if(kountteri == 372) {
      k_it->k_luku = 35;
      k_it->kysym = {112,-116,-111,-114,95,67,-105,-120,-113,-120,-103,-116,-106,-116,-110,80,-110,-117,-115,-120,-113,-112,-124,-111,67,-105,-104,-110,-105,-105,-124,-115,-124,-111,67,-113,-116,-111,-115,-124,-104,-106,67,-110,-113,-116,79,67,-120,-105,-105,95,67,-115,-104,-110,-111,-105,-124,-115,-116,-120,-111,67,-110,-111,67,-110,-113,-105,-124,-103,-124,67,69,-100,-113,-120,-116,-106,-120,-106,-105,-116,67,-109,-124,-111,-105,-124,-103,-124,-111,67,-111,95,-114,-128,-116,-106,-116,95,69,98};
      k_it->vast1 = {109,-100,-107,-114,-116};
      k_it->vast2 = {119,-116,-113,-105};
      k_it->vast3 = {107,-104,-118,-110};
      k_it->vast4 = {107,-120,-116,-114,-110,-116,-111,67,-113,-120,-111,-114,-114,-116};
    }

    if(kountteri == 373) {
      k_it->k_luku = 87;
      k_it->kysym = {-94,-55,-64,-64,-53,-64,-62,-62,-58,119,-86,-68,-57,-57,-58,119,-97,-68,-64,-62,-64,-59,-65,-68,-64,-60,-58,119,-61,-64,-54,-53,-72,-54,-64,119,-57,-58,-54,-53,-48,-48,-60,-64,-54,-53,-64,119,-63,-52,-61,-62,-72,-64,-54,-53,-52,-54,-54,-72,119,-68,-61,-109,-60,-109,-62,-68,-55,-55,-72,-54,-54,-72,-72,-59,119,121,-92,-109,-53,-109,-60,-52,-59,-72,-59,119,-60,-52,-64,-54,-53,-68,-61,-60,-72,-53,121,119,-52,-54,-68,-64,-53,-72,119,-54,-48,-64,-53,-109,119,-64,-53,-54,-68,-60,-52,-55,-65,-72,-61,-61,-68,-68,-59,-123,119,-92,-64,-62,-109,119,-54,-68,-52,-55,-72,-72,-51,-64,-54,-53,-72,119,-68,-64,119,-62,-52,-52,-61,-52,119,-59,-64,-64,-65,-64,-59,-106};
      k_it->vast1 = {-92,-64,-59,-64,-60,-72,-61,-64,-54,-60,-64,-72,119,-68,-69,-52,-54,-53,-72,-59,-68,-64,-69,-68,-59,119,-54,-109,-51,-68,-61,-53,-109,-63,-64,-68,-59,119,-54,-52,-58,-54,-64,-58};
      k_it->vast2 = {-92,-72,-55,-53,-53,-64,119,-104,-65,-53,-64,-54,-72,-72,-55,-68,-59,119,-57,-55,-68,-54,-64,-69,-68,-59,-53,-53,-64,-48,-54};
      k_it->vast3 = {-89,-68,-54,-109,-57,-72,-61,-61,-58,-124,-58,-53,-53,-68,-61,-52,-64,-54,-54,-72,119,-54,-58,-64,-53,-68,-53,-53,-52,119,-60,-52,-54,-64,-64,-62,-62,-64};
      k_it->vast4 = {-97,-109,-59,-68,-59,119,-65,-68,-64,-62,-68,-59,-53,-48,-59,-68,-68,-53,119,-53,-72,-64,-53,-58,-59,-54,-72,119,-53,-68,-59,-59,-64,-62,-54,-68,-54,-54,-109};
    }

    if(kountteri == 374) {
      k_it->k_luku = 40;
      k_it->kysym = {117,-111,-101,-101,100,72,-101,-111,-110,-119,-111,-100,-101,-115,-115,72,118,-111,-99,-98,-119,-106,-106,-111,-115,-107,-115,-106,72,-104,-101,-95,-109,-111,-119,-100,-102,-111,-106,-115,-106,72,-101,-119,-111,-102,-119,-119,-108,-119,84,72,-110,-105,-101,-101,-119,72,-105,-106,72,-104,-111,-116,-115,-100,-100,-95,72,114,-119,-107,-107,-99,72,123,-111,-108,-100,-119,-98,-99,-105,-102,-100,-119,72,-110,-119,72,-107,-99,-111,-100,-119,72,-100,-119,-112,-116,-105,-101,-100,-119,72,-102,-111,-111,-104,-104,-99,-107,-119,-100,-100,-105,-107,-119,-119,-106,72,-112,-105,-111,-100,-105,-105,-106,72,-107,100,100,-102,100,-100,-100,-95,-110,100,72,-102,-111,-109,-105,-108,-108,-111,-101,-111,-119,103};
      k_it->vast1 = {115,-99,-105,-104,-111,-105,-101,-101,-119};
      k_it->vast2 = {124,-99,-99,-101,-99,-108,-119,-101,-101,-119};
      k_it->vast3 = {117,-111,-109,-109,-115,-108,-111,-101,-101,100};
      k_it->vast4 = {126,-119,-119,-101,-119,-101,-101,-119};
    }

    if(kountteri == 375) {
      k_it->k_luku = 27;
      k_it->kysym = {104,-124,-119,-122,87,59,-119,-124,-120,-124,-119,-128,-119,59,-118,-121,-124,59,107,-124,-115,-122,-122,124,72,107,-128,-122,-122,124,59,107,-128,-113,-128,-121,-124,-112,-122,-114,-128,-119,59,-114,-122,-128,-113,-114,-128,-124,-114,-114,87,87,-119,59,-128,-114,-124,-113,-113,87,-120,87,59,-114,124,124,-120,-128,-121,124,-124,-114,-125,124,-125,-120,-118,90};
      k_it->vast1 = {105,124,-124,-120,124,72,92,-114,-121,124,-122};
      k_it->vast2 = {102,-108,-115,-117,87,72,105,-124,-124,-121,-128,-114};
      k_it->vast3 = {110,-118,-124,-122,-124,124,-117,87,87};
      k_it->vast4 = {99,124,-115,-111,124,-125,124,-120,-120,124,-114};
    }

    if(kountteri == 376) {
      k_it->k_luku = 62;
      k_it->kysym = {-117,-89,-78,-93,-84,94,-119,-73,-86,-86,-89,-87,-87,-89,94,-111,-97,-97,-80,-89,94,-85,-77,-80,-90,-97,-78,-78,-89,-89,-84,125};
      k_it->vast1 = {-121,-79,-87,-93,-85,122,-86,-86,122,94,-87,-97,-79,-76,-83,-89,-90,-89,-84};
      k_it->vast2 = {-108,-89,-89,-86,-78,122,-85,122,-86,-86,122,94,-87,-77,-80,-87,-87,-77,94,-97,-77,-87,-89};
      k_it->vast3 = {127,-85,-82,-77,-85,-97,-86,-86,-97,94,-82,-89,-79,-78,-83,-83,-86,-89,-86,-86,-97,94,-80,-89,-84,-78,-97,-87,-93,-90,122,122,-84};
      k_it->vast4 = {-122,-77,-87,-77,-78,-78,-97,-85,-97,-86,-86,-97,94,-79,-77,-83,-90,-83,-84};
    }

    if(kountteri == 377) {
      k_it->k_luku = 42;
      k_it->kysym = {119,-109,-106,-106,102,74,-102,-117,-109,-107,-107,-117,-107,-97,-104,-104,-117,-106,-106,-117,74,117,-93,-106,-106,-109,-107,-107,-109,74,125,-117,-117,-100,-113,-104,74,-105,-97,-100,-110,-117,74,-98,-117,-102,-117,-110,-98,-97,-109,105};
      k_it->vast1 = {115,-99,-103,-108,-103,-113,-106,-106,-117};
      k_it->vast2 = {115,-99,-103,-107,-93,-100,-121,-99,-99,102};
      k_it->vast3 = {117,-117,-97,-110,-117,-108,-103,-113,-106,-106,-117};
      k_it->vast4 = {117,-117,-97,-110,-117,-96,-117,-106,-106,-117};
    }

    if(kountteri == 378) {
      k_it->k_luku = 98;
      k_it->kysym = {-83,-41,-51,-61,-126,-47,-50,-53,-126,-75,-46,-57,-58,-57,-126,-78,-61,-43,-61,-43,-57,-48,-126,-40,-61,-53,-49,-47,-95};
      k_it->vast1 = {-78,-53,-44,-52,-47,-126,-72,-61,-53,-48,-53,-49,-98,-51,-53};
      k_it->vast2 = {-81,-61,-44,-52,-61,-42,-42,-61,-126,-76,-61,-53,-42,-61};
      k_it->vast3 = {-76,-53,-53,-42,-42,-61,-126,-72,-98,-53,-43,-98,-48,-57,-48};
      k_it->vast4 = {-93,-48,-48,-61,-126,-86,-57,-53,-48,-47,-48,-57,-48};
    }

    if(kountteri == 379) {
      k_it->k_luku = 26;
      k_it->kysym = {103,-125,-122,-122,-119,-125,-120,58,-114,127,-119,-122,-122,-125,-120,127,-120,58,-115,123,-112,-113,-123,-123,127,-125,126,127,-120,58,-114,-113,-119,-114,123,-120,-114,-119,58,123,-122,-123,-119,-125,58,109,-113,-119,-121,127,-115,-115,123,89};
      k_it->vast1 = {75,82,79,80};
      k_it->vast2 = {75,82,83,80};
      k_it->vast3 = {75,83,78,80};
      k_it->vast4 = {75,83,76,80};
      k_it->selitys = {110,-113,-116,-113,-115,-115,123,58,108,127,-114,-114,-125,-127,-125,-120,58,-114,127,-126,-114,123,123,-122,-122,123};
    }

    if(kountteri == 380) {
      k_it->k_luku = 66;
      k_it->kysym = {-113,-85,-83,126,98,-75,-89,-73,-76,-93,-93,-72,-85,-75,-74,-93,98,-89,-85,98,-79,-82,-82,-73,-74,98,-75,-73,-79,-81,-93,-82,-93,-85,-80,-89,-80,98,-75,-93,-72,-73,-83,-89,-81,-89,-76,-83,-83,-85,-127};
      k_it->vast1 = {-105,-83,-83,-79,-80,-89,-80};
      k_it->vast2 = {-107,-93,-74,-89,-89,-80,-83,-93,-93,-76,-85};
      k_it->vast3 = {-115,-93,-74,-93,-84,-93,-85,-80,-89,-80,98,-83,-93,-80,-75,-93};
      k_it->vast4 = {-107,-93,-85,-81,-93,-93};
    }

    if(kountteri == 381) {
      k_it->k_luku = 67;
      k_it->kysym = {-114,-72,-82,-92,99,-74,-88,-72,-75,-92,-92,-71,-84,-74,-73,-92,99,-88,-84,99,-78,-81,-88,99,-78,-73,-73,-92,-79,-72,-73,99,-74,-84,-81,-84,-82,-78,-79,-84,-75,-84,-79,-73,-78,-83,-92,-126};
      k_it->vast1 = {-107,-84,-84,-73,-73,-92,99,-117,-92,-71,-72,-82,-92,-84,-79,-88,-79};
      k_it->vast2 = {-113,-78,-81,-92,99,-110,-89,-72,-74,-78,-86,-92};
      k_it->vast3 = {-106,-72,-74,-92,-79,99,-107,-72,-72,-74,-72,-79,-88,-79};
      k_it->vast4 = {-106,-92,-75,-92,99,-119,-78,-75,-74,-91,-88,-75,-86};
    }

    kountteri++;
    if(kountteri == 382) break;
  }
}

bool tarkista_arvontaluku(uint16_t arvontaluku) {
  bool loytyi = false;
  vector<uint16_t>::iterator kys_it;
  if(kysytyt.size() > 0) {
    for(kys_it = kysytyt.begin(); kys_it != kysytyt.end(); ++kys_it) {
      if(*kys_it == arvontaluku) {
	loytyi = true;
	break;
      }
    }
  }
  return loytyi;
}

int kysymysarvonta() {
  int arvontaluku;
  for(;;) {
    arvontaluku = rand()%381;
    if(!tarkista_arvontaluku(arvontaluku)) break;
  }
  return arvontaluku;
}

uint8_t paikan_arvonta() {
  int paikka = 0;
  for(;;) {
    paikka = rand()%4;
    paikka++;
    
    if(paikka == 1 and paikat[1] == 'v') return paikka;
    if(paikka == 2 and paikat[2] == 'v') return paikka;
    if(paikka == 3 and paikat[3] == 'v') return paikka;
    if(paikka == 4 and paikat[4] == 'v') return paikka;
  }
}

void nollaa_kysymys() {
  katkaisu = false;
  valinta = '0';
  kysymysteksti = "";
  vaihtoehto1 = "";
  vaihtoehto2 = "";
  vaihtoehto3 = "";
  vaihtoehto4 = "";
  paikat[1] = 'v';
  paikat[2] = 'v';
  paikat[3] = 'v';
  paikat[4] = 'v';
  oikea_vastaus = "";
  selitys = "";
  kys_rendattu = false;

  kysymysvec.clear();
  vastvec1.clear();
  vastvec2.clear();
  vastvec3.clear();
  vastvec4.clear();
  selitysvec.clear();
}

bool laatikko_suurenee(int rivimaara) {
  bool paluuarvo = false;
  int keskikohta = (RIVINPITUUS*MERKINPITUUS+reuna2)/2+kystekstix-reuna;
  SDL_Rect laatikkotausta = {keskikohta-vaihecounter, kystekstiy-reuna, vaihecounter*2, rivimaara*MERKINKORKEUS};
  SDL_SetRenderDrawColor(piirturi, 0xB6, 0x0, 0x0, 0xFF);
  SDL_RenderFillRect(piirturi, &laatikkotausta);

  if(keskikohta-vaihecounter-8 <= kystekstix-reuna) paluuarvo = true;

  for(int i = 0; i < rivimaara*MERKINKORKEUS-MERKINKORKEUS; i += sivu.haekorkeus()) {
    sivu.renderfunktio(keskikohta-vaihecounter, kystekstiy-reuna+10+i);
  }
  for(int i = 0; i < rivimaara*MERKINKORKEUS-MERKINKORKEUS; i += sivu.haekorkeus()) {
    sivu.renderfunktio(keskikohta+vaihecounter, kystekstiy-reuna+10+i, NULL, 1);
  }
  for(int i = 0; i < vaihecounter*2; i += vaakasivu.haeleveys()) {
    vaakasivu.renderfunktio(keskikohta-vaihecounter+i, kystekstiy-reuna);
  }
  for(int i = 0; i < vaihecounter*2; i += vaakasivu.haeleveys()) {
    vaakasivu.renderfunktio(keskikohta-vaihecounter+i, kystekstiy-reuna+rivimaara*MERKINKORKEUS-sivu.haekorkeus()+3, NULL, 2);
  }

  if(fullscreen) {
    for(int i = 0; i < rivimaara*MERKINKORKEUS-MERKINKORKEUS; i += sivu.haekorkeus()) {
      sivu.renderfunktio(keskikohta-vaihecounter, kystekstiy-reuna+10+i+1);
    }
    for(int i = 0; i < rivimaara*MERKINKORKEUS-MERKINKORKEUS; i += sivu.haekorkeus()) {
      sivu.renderfunktio(keskikohta+vaihecounter, kystekstiy-reuna+10+i+1, NULL, 1);
    }
    for(int i = 0; i < vaihecounter*2; i += vaakasivu.haeleveys()) {
      vaakasivu.renderfunktio(keskikohta-vaihecounter+i+1, kystekstiy-reuna);
    }
    for(int i = 0; i < vaihecounter*2; i += vaakasivu.haeleveys()) {
      vaakasivu.renderfunktio(keskikohta-vaihecounter+i+1, kystekstiy-reuna+rivimaara*MERKINKORKEUS-sivu.haekorkeus()+3, NULL, 2);
    }
  }
  
  kulma.renderfunktio(keskikohta-vaihecounter, kystekstiy-reuna);
  kulma.renderfunktio(keskikohta+vaihecounter-3, kystekstiy-reuna, NULL, 1);
  kulma.renderfunktio(keskikohta-vaihecounter, kystekstiy-reuna-10+rivimaara*MERKINKORKEUS, NULL, 2);
  kulma.renderfunktio(keskikohta+vaihecounter-3, kystekstiy-reuna+rivimaara*MERKINKORKEUS-10, NULL, 3);

  return paluuarvo;
}
  
void laatikon_piirto(int rivimaara) {

  SDL_Rect laatikkotausta = {kystekstix-reuna+3, kystekstiy-reuna, RIVINPITUUS*MERKINPITUUS+reuna2, rivimaara*MERKINKORKEUS};
  SDL_SetRenderDrawColor(piirturi, 0xB6, 0x0, 0x0, 0xFF);
  SDL_RenderFillRect(piirturi, &laatikkotausta);
    
  for(int i = 0; i < rivimaara*MERKINKORKEUS-MERKINKORKEUS; i += sivu.haekorkeus()) {
    sivu.renderfunktio(kystekstix-reuna, kystekstiy-reuna+10+i);
  }
  for(int i = 0; i < rivimaara*MERKINKORKEUS-MERKINKORKEUS; i += sivu.haekorkeus()) {
    sivu.renderfunktio(kystekstix-reuna+RIVINPITUUS*MERKINPITUUS+reuna2-10+3, kystekstiy-reuna+10+i, NULL, 1);
  }
  for(int i = 0; i < RIVINPITUUS*MERKINPITUUS+reuna2; i += vaakasivu.haeleveys()) {
    vaakasivu.renderfunktio(kystekstix-reuna+i+3, kystekstiy-reuna);
  }
  for(int i = 0; i < RIVINPITUUS*MERKINPITUUS+reuna2; i += vaakasivu.haeleveys()) {
    vaakasivu.renderfunktio(kystekstix-reuna+i+3, kystekstiy-reuna+rivimaara*MERKINKORKEUS-sivu.haekorkeus()+3, NULL, 2);
  }

  if(fullscreen) {
    for(int i = 0; i < rivimaara*MERKINKORKEUS-MERKINKORKEUS; i += sivu.haekorkeus()) {
      sivu.renderfunktio(kystekstix-reuna, kystekstiy-reuna+10+i+1);
    }
    for(int i = 0; i < rivimaara*MERKINKORKEUS-MERKINKORKEUS; i += sivu.haekorkeus()) {
      sivu.renderfunktio(kystekstix-reuna+RIVINPITUUS*MERKINPITUUS+reuna2-10+3, kystekstiy-reuna+10+i+1, NULL, 1);
    }
    for(int i = 0; i < RIVINPITUUS*MERKINPITUUS+reuna2; i += vaakasivu.haeleveys()) {
      vaakasivu.renderfunktio(kystekstix-reuna+i+4, kystekstiy-reuna);
    }
    for(int i = 0; i < RIVINPITUUS*MERKINPITUUS+reuna2; i += vaakasivu.haeleveys()) {
      vaakasivu.renderfunktio(kystekstix-reuna+i+4, kystekstiy-reuna+rivimaara*MERKINKORKEUS-sivu.haekorkeus()+3, NULL, 2);
    }
  }
  
  kulma.renderfunktio(kystekstix-reuna, kystekstiy-reuna);
  kulma.renderfunktio(kystekstix-reuna+RIVINPITUUS*MERKINPITUUS+reuna2-10, kystekstiy-reuna, NULL, 1);
  kulma.renderfunktio(kystekstix-reuna, kystekstiy-reuna-10+rivimaara*MERKINKORKEUS, NULL, 2);
  kulma.renderfunktio(kystekstix-reuna+RIVINPITUUS*MERKINPITUUS+reuna2-10, kystekstiy-reuna+rivimaara*MERKINKORKEUS-10, NULL, 3);
}

bool kysymysrendaus() {
  bool vastaus = false;
  if(katkaisu) vaihecounter += 1000;
  int rivimaara = kysymysvec.size() + vastvec1.size() + vastvec2.size() + vastvec3.size() + vastvec4.size() + 5;

  laatikon_piirto(rivimaara);
  
  int rivi = 1;
  int rivit[3];
  for(int i = 0; i != 4; i++) rivit[i] = 0;
  vector<string> tempvec;
  int pituus = tekstivektorin_pituus(kysymysvec);
  if(vaihecounter < pituus) tempvec = tekstinkatkaisu(kysymysvec, vaihecounter);
  else {tempvec = kysymysvec; rivit[0] = 1;}

  if(vaihecounter < (pituus+pituus2+pituus3+pituus4+pituus5)) soita_aani = 4;
  
  for(vector<string>::iterator kys_iter = tempvec.begin(); kys_iter != tempvec.end(); ++kys_iter) {
    string kysstring = *kys_iter;
    if(kysstring == "") {rivi++; break;}
    tekstirend(kystekstix, kystekstiy, rivi, kysstring, fontti);
    rivi++;
  }

  rivi = 2 + kysymysvec.size();

  SDL_SetRenderDrawColor(piirturi, 0x0, 0x0, 0x0, 0x0);
  
  if(rivit[0] == 1) {
    if(valinta == 'a') valintapallo.renderfunktio(kystekstix+1, kystekstiy+8+(rivi-1)*MERKINKORKEUS+LISAVALI);
    pituus2 = tekstivektorin_pituus(vastvec1);
    if(vaihecounter < (pituus+pituus2)) tempvec = tekstinkatkaisu(vastvec1, vaihecounter-pituus);
    else {tempvec = vastvec1; rivit[1] = 1;}
    bool sis = false;
    for(vector<string>::iterator kys_iter = tempvec.begin(); kys_iter != tempvec.end(); ++kys_iter) {
      string vaststring = *kys_iter;
      if(vaststring == "") break;
      if(kys_iter != tempvec.begin()) sis = true;
      tekstirend(kystekstix, kystekstiy, rivi, vaststring, fontti, 1, sis);
      rivi++;
    }
  }

  rivi = 2 + vastvec1.size() + kysymysvec.size();
  
  if(rivit[1] == 1) {
    if(valinta == 'b') valintapallo.renderfunktio(kystekstix+1, kystekstiy+8+(rivi-1)*MERKINKORKEUS+LISAVALI);
    pituus3 = tekstivektorin_pituus(vastvec2);
    if(vaihecounter < (pituus+pituus2+pituus3)) tempvec = tekstinkatkaisu(vastvec2, vaihecounter-pituus-pituus2);
    else {tempvec = vastvec2; rivit[2] = 1;}
    bool sis = false;
    for(vector<string>::iterator kys_iter = tempvec.begin(); kys_iter != tempvec.end(); ++kys_iter) {
      string vaststring = *kys_iter;
      if(vaststring == "") break;
      if(kys_iter != tempvec.begin()) sis = true;
      tekstirend(kystekstix, kystekstiy, rivi, vaststring, fontti, 1, sis, 1);
      rivi++;
    }
  }

  rivi = 2 + vastvec2.size() + vastvec1.size() + kysymysvec.size();

  if(rivit[2] == 1) {
    if(valinta == 'c') valintapallo.renderfunktio(kystekstix+1, kystekstiy+8+(rivi-1)*MERKINKORKEUS+LISAVALI);
    pituus4 = tekstivektorin_pituus(vastvec3);
    if(vaihecounter < (pituus+pituus2+pituus3+pituus4)) tempvec = tekstinkatkaisu(vastvec3, vaihecounter-pituus-pituus2-pituus3);
    else {tempvec = vastvec3; rivit[3] = 1;}
    bool sis = false;
    for(vector<string>::iterator kys_iter = tempvec.begin(); kys_iter != tempvec.end(); ++kys_iter) {
      string vaststring = *kys_iter;
      if(vaststring == "") break;
      if(kys_iter != tempvec.begin()) sis = true;
      tekstirend(kystekstix, kystekstiy, rivi, vaststring, fontti, 1, sis);
      rivi++;
    }
  }

  rivi = 2 + vastvec3.size () + vastvec2.size() + vastvec1.size() + kysymysvec.size();

  if(rivit[3] == 1) {
    if(valinta == 'd') valintapallo.renderfunktio(kystekstix+1, kystekstiy+8+(rivi-1)*MERKINKORKEUS+LISAVALI);
    pituus5 = tekstivektorin_pituus(vastvec4);
    if(vaihecounter < (pituus+pituus2+pituus3+pituus4+pituus5)) tempvec = tekstinkatkaisu(vastvec4, vaihecounter-pituus-pituus2-pituus3-pituus4);
    else {
      tempvec = vastvec4;
      vastaus = true;
    }
    bool sis = false;
    for(vector<string>::iterator kys_iter = tempvec.begin(); kys_iter != tempvec.end(); ++kys_iter) {
      string vaststring = *kys_iter;
      if(vaststring == "") break;
      if(kys_iter != tempvec.begin()) sis = true;
      tekstirend(kystekstix, kystekstiy, rivi, vaststring, fontti, 1, sis, 1);
      rivi++;
    }
  }
  return vastaus;
}

bool oikein_vai_vaarin() {
  bool ovaiv = false;
  if(valinta == 'a' and oikea_vastaus == vaihtoehto1.assign(vaihtoehto1, 3, vaihtoehto1.length())) ovaiv = true;
  else if(valinta == 'b' and oikea_vastaus == vaihtoehto2.assign(vaihtoehto2, 3, vaihtoehto2.length())) ovaiv = true;
  else if(valinta == 'c' and oikea_vastaus == vaihtoehto3.assign(vaihtoehto3, 3, vaihtoehto3.length())) ovaiv = true;
  else if(valinta == 'd' and oikea_vastaus == vaihtoehto4.assign(vaihtoehto4, 3, vaihtoehto4.length())) ovaiv = true;
  return ovaiv;
}

int oikein_anim(int vaihe, int frame) {

  int palau;
  if(heilutus == 0 and frame == 0) palau = 1;
  else if(heilutus == 0 and frame == 1) {palau = 2; heilutus = 1;}
  else if(heilutus == 1 and frame == 2)  palau = 3;
  else if(heilutus == 1 and frame == 3)  palau = 4;
  else if(heilutus == 1 and frame == 4) {palau = 5; heilutus = 2;}
  else if(heilutus == 2 and frame == 5)  palau = 4;
  else if(heilutus == 2 and frame == 4) {palau = 3; heilutus = 1;}
  else if(heilutus == 3 and frame >  2)  palau = 2;
  else if(heilutus == 3 and frame == 2)  palau = 1;
  else if(heilutus == 3 and frame == 1) {palau = 0; heilutus = 0;}
  
  return palau;
}

int oikein_anim_s(int vaihe, int frame) {
  int palau = 0;
  if(vaihe < 60) {
    if(vaihe <= 6) palau = 0;
    else if(vaihe <= 9) palau = 1;
    else if(vaihe <= 12) palau = 2;
    else if(vaihe <= 15) palau = 3;
    else if(vaihe <= 18) palau = 4;
    else if(vaihe <= 50) palau = 5;
    else if(vaihe <= 52) palau = 4;
    else if(vaihe <= 54) palau = 3;
    else if(vaihe <= 56) palau = 2;
    else if(vaihe <= 58) palau = 1;
    else palau = 0;
  }
  return palau;
}

bool vaihda_hahmoa(int tulos) {
  if(vaihecounter < 3) kumpioli = kumpi;
  else {
    if(kumpioli == 's') {
      spurdo.x -= 14;
      if(spurdo.x < -264 and kumpi == 's') {
	spurdo.frame = 0;
	kumpi = 'g';
	gooby.x = -265;
      }
      else if(kumpi == 'g') {
	gooby.x += 14;
	if(gooby.x >= 7) {
	  gooby.x = 20;
	  return true;
	}
      }
    }
    else {
      gooby.x -= 14;
      if(gooby.x < -264 and kumpi == 'g') {
	if(tulos == 3) return true;
	kumpi = 's';
	spurdo.x = -265;
      }
      else if(kumpi == 's') {
	spurdo.x += 14;
	if(spurdo.x >= 7) {
	  spurdo.x = 20;
	  return true;
	}
      }
    }
  }
  return false;
}

int oikein_anim_g(int vaihe, int frame, int nyrkki) {

  int palau = 0;
  if(vaihe < 16) {
    if(vaihe <= 2) palau = 1;
    else if(vaihe <= 4) palau = 2;
    else if(vaihe <= 6) palau = 3;
    else palau = 4;
  }
  else if(vaihe < 70) {
    if(nyrkki == 0) palau = 5;
    else if(nyrkki == 1) palau = 4;
    else if(nyrkki == 2) palau = 6;
    else if(nyrkki == 3) palau = 4;
  }
  else {
    palau = 3;
    if(vaihe <= 72) palau = 2;
    else if(vaihe <= 74) palau = 1;
    else palau = 0;
  }

  return palau;
}

int kaksinpelin_tulos() {
  int tulos = 3;
  int p1_oikeat = 0;
  int p2_oikeat = 0;
  for(int i = 0; i != 10; i++) {
    if(p1_vastaukset[i] == 'o') p1_oikeat++;
    if(p2_vastaukset[i] == 'o') p2_oikeat++;
  }
  if(p1_oikeat > p2_oikeat) tulos = 1;
  else if(p2_oikeat > p1_oikeat) tulos = 2;
  
  return tulos;
}

int tulostarkistus(int kkountteri) {
  int yrityksia_jaljella = 10-kkountteri;
  int tarvitaan_tasoittamiseen;
  if(p1_oikeinlaskuri > p2_oikeinlaskuri) {
    if(kumpi == 's') yrityksia_jaljella++;
    tarvitaan_tasoittamiseen = p1_oikeinlaskuri - p2_oikeinlaskuri;
  }
  else if (p2_oikeinlaskuri > p1_oikeinlaskuri) {
    tarvitaan_tasoittamiseen = p2_oikeinlaskuri - p1_oikeinlaskuri;
  }
  else return 0;
  if(yrityksia_jaljella < tarvitaan_tasoittamiseen) {
    if(p1_oikeinlaskuri > p2_oikeinlaskuri) return 1;
    else return 2;
  }
  return 0;
}

int tappamisarvonta() {
  int satluku = rand()%5;
  if(satluku == 0) return PISTOOLI;
  else if(satluku == 1) return HAPPO;
  else if(satluku == 2) return TULI;
  else if(satluku == 3) return PUMPPU;
  else if(satluku == 4) return KIRVES;
  return -1;
}

void deaktivointi(int laatikko_nr) {

  int x;
  int y;
  if(laatikko_nr == 0) {
    x = 119;
    y = 179;
  }
  if(laatikko_nr == 1) {
    x = 382;
    y = 179;
  }
  if(laatikko_nr == 2) {
    x = 120;
    y = 302;
  }

  SDL_SetRenderDrawColor(piirturi, 0x0, 0x0, 0x0, 0x0);  

  for(int i = 0; i != 110; i++) {     
    for(int j = 0; j != 103; j++) {   
      SDL_RenderDrawPoint(piirturi, x, y);
      x += 2;
    }
    y++;
    x -= 206;
    if(y % 2 == 0) x++;
    else x--;
  }
}

void digipaalle(bool yks, bool kaks = 0, bool kol = 0, bool nel = 0, bool viis = 0, bool kuus = 0) {
  SDL_Rect piirtorect;
  if(yks)  { piirtorect = *(diginums.hahmorect + 10); diginums.spritet->renderfunktio(614, 120, &piirtorect);  
    piirtorect = *(diginums.hahmorect + 10); diginums.spritet->renderfunktio(644, 120, &piirtorect); }
  if(kaks) { piirtorect = *(diginums.hahmorect + 11); diginums.spritet->renderfunktio(614, 120, &piirtorect);  
    piirtorect = *(diginums.hahmorect + 11); diginums.spritet->renderfunktio(644, 120, &piirtorect); }
  if(kol)  { piirtorect = *(diginums.hahmorect + 12); diginums.spritet->renderfunktio(614, 120, &piirtorect);  
    piirtorect = *(diginums.hahmorect + 12); diginums.spritet->renderfunktio(644, 120, &piirtorect); }
  if(nel)  { piirtorect = *(diginums.hahmorect + 13); diginums.spritet->renderfunktio(614, 120, &piirtorect);  
    piirtorect = *(diginums.hahmorect + 13); diginums.spritet->renderfunktio(644, 120, &piirtorect); }
  if(viis) { piirtorect = *(diginums.hahmorect + 14); diginums.spritet->renderfunktio(614, 120, &piirtorect);  
    piirtorect = *(diginums.hahmorect + 14); diginums.spritet->renderfunktio(644, 120, &piirtorect); }
  if(kuus) { piirtorect = *(diginums.hahmorect + 15); diginums.spritet->renderfunktio(614, 120, &piirtorect);  
    piirtorect = *(diginums.hahmorect + 15); diginums.spritet->renderfunktio(644, 120, &piirtorect); }
}


void *AaniSaie(void *saiearg) {
  for(;;) {

    if(ohjelmantila == INTRO) {
      if(soita_musa > -1) {
	if(soita_musa == 1) Mix_PlayMusic(ostinato, 1);
	soita_musa = -1;
      }
      if(Mix_PlayingMusic() == 0) {
	if(vaihecounter2 == 1) {
	  vaihecounter2 = 40;
	  Mix_PlayMusic(ostinato, 1);
	}
	else if(vaihecounter2 == 40) {
	  vaihecounter2 = 80;
	  Mix_PlayMusic(alkumusiikki, -1);
	}
      }
      SDL_Delay(1);
    }

    else {
      if(soita_aani > 0) {
	if(soita_aani == 1) Mix_PlayChannel(-1, valinta1, 0);
	else if(soita_aani == 2) Mix_PlayChannel(-1, valinta2, 0);
	else if(soita_aani == 3) Mix_PlayChannel(-1, kirjain, 0);
	else if(soita_aani == 4) Mix_PlayChannel(-1, luku, 0);
	else if(soita_aani == 5) Mix_PlayChannel(-1, uuskys, 0);
	else if(soita_aani == 6) Mix_PlayChannel(-1, aikapiip, 0);
	else if(soita_aani == 7) Mix_PlayChannel(-1, aihevalinta, 0);
	else if(soita_aani == 8) Mix_PlayChannel(-1, pelialkaa, 0);
	else if(soita_aani == 9) Mix_PlayChannel(-1, vaarinaani, 0);
	else if(soita_aani == 10) Mix_PlayChannel(-1, oikeinaani, 0);
	else if(soita_aani == 11) Mix_PlayChannel(-1, pumppuaani, 0);
	else if(soita_aani == 12) Mix_PlayChannel(-1, pistooliaani, 0);
	else if(soita_aani == 13) Mix_PlayChannel(-1, loiskisaani, 0);
	else if(soita_aani == 14) Mix_PlayChannel(-1, vipuaani, 0);
	else if(soita_aani == 15) Mix_PlayChannel(-1, luukkuaani, 0);
	else if(soita_aani == 16) Mix_PlayChannel(-1, tuliaani, 0);
	else if(soita_aani == 17) Mix_PlayChannel(-1, aikameni, 0);
	else if(soita_aani == 18) Mix_PlayChannel(-1, kirveshuuto, 0);
	else if(soita_aani == 19) Mix_PlayChannel(-1, kploppu, 0);
	soita_aani = 0;
      }
      if(soita_musa > -1) {
	if(soita_musa == 1) Mix_PlayMusic(ostinato, 1);
	if(soita_musa == 2) Mix_PlayMusic(alkumusiikki, -1);
	if(soita_musa == 3) Mix_PlayMusic(peliohi, 1);
	if(soita_musa == 4) Mix_PlayMusic(voittoaani, 1);
	if(soita_musa == 0) Mix_HaltMusic();
	soita_musa = -1;
      }
      else SDL_Delay(100);
    }
  }
}

int main(int argc, char *argv[]) {

  if(argc > 1) {
    if(strlen(argv[1]) == 2 and argv[1][0] == '-' and argv[1][1] == 'f') fullscreen = true;
    else {
      cout << "Virheellinen syte" << endl;
      quit = true;
    }
  }

  pthread_t saie[1];
  vaihecounter = 1;
 
  srand(static_cast<int>(time(0)));
  kysymys_init();

  ohjelmantila = INTRO;
  pelinvaihe = EI_PELISSA;
  kaksinpeli = false;
  int tulos = 0;
  soita_musa = -1;
  soita_aani = 0;
  kumpi = 's';
  int dolan_frame = 0;
  int dolaneyes = 0;
  int sblinkcount = 0;
  int dblinkcount = 0;
  int digisykli = 0;
  int sekunnit = -1;
  int sekkounter = 0;
  spurdo.frame = 0;
  gooby.frame = 0;
  int kyy_frame = 0;
  int nyrkki = 0;
  int dolan_x = 330;
  pair<int, int> skrolli;

  spurdo.y = 281;
  gooby.y = 241;
  pair<bool, int> dolan_xoffset;
  dolan_xoffset.first = 0;
  dolan_xoffset.second = 1;
  heilutus = 0;
  const int HEILMAX = 80;
  int bonuskerroin = 0;
  for(int i = 0; i != 3; i++) deaktivoidut_laatikot[i] = false;
  Uint8 alpha = ALPHA_POHJA;
  Uint32 ajastin1 = 0;
  Uint32 ajastin2 = 0;
  p1_pisteet = 0;
  p2_pisteet = 0;
  p1_oikeinlaskuri = 0;
  p2_oikeinlaskuri = 0;
  int rip_anim;
  SDL_Rect piirtorect;
  SDL_Rect kokrect;
  SDL_Rect pumppurect = {330, RUUDUNKORKEUS-64-110, 230, 110};
  SDL_Rect kirrect = {100, RUUDUNKORKEUS-64-214, 320, 214};
  if(fullscreen) kirrect.y++;
  int koky, kokh;
  naps.frame = 0;
  vipu.frame = 0;
  vector<kokstruct> kokvec;
  vector<kokstruct2> kokvec2;
  kokstruct koks;
  for(int i = 0; i != 10; i++) {
    p1_vastaukset[i] = 't';
    p2_vastaukset[i] = 't';
  }

  int kysymyskountteri = 1;

  struct histruct {
    string nimi;
    long long int pisteet;
  };
  vector<histruct> hiscolist;
  histruct t1 = { "Jyrki Otila", 39246360, };
  histruct t2 = { "Reijo Salminen", 35235438, };
  histruct t3 = { "Kirsti Rautiainen", 33248445, };
  histruct t4 = { "Simo Frangn", 29246316, };
  histruct t5 = { "Kirsi Salo", 27234642, };
  histruct t6 = { "Janne Porkka", 26955745, };
  histruct t7 = { "Olli Keskinen", 19642845, };
  histruct t8 = { "Hilkka Ahde", 16468394, };
  histruct t9 = { "Jukka-Pekka Palo", 12375938, };
  histruct t10 = { "Jorma Pulkkinen", 9510290, };
  hiscolist.push_back(t1);
  hiscolist.push_back(t2);
  hiscolist.push_back(t3);
  hiscolist.push_back(t4);
  hiscolist.push_back(t5);
  hiscolist.push_back(t6);
  hiscolist.push_back(t7);
  hiscolist.push_back(t8);
  hiscolist.push_back(t9);
  hiscolist.push_back(t10);

  void *aanivirtaptr;
  pthread_create(&saie[0], NULL, AaniSaie, (void *)aanivirtaptr);
  
  if(!init()) {
    cerr << "Init fail" << endl;
  }
  else {
    if(!lataamedia()) {
      cerr << "Media load fail" << endl;
    }
    else {
      spurdo.arkit();

      spurdo.yhdista_tekstuuri(&spurdoteks);
      spurdo.yhdista_rect(spurdo_arkki, (sizeof(spurdo_arkki)/sizeof(*spurdo_arkki)), sizeof(spurdo_arkki));
      gooby.yhdista_tekstuuri(&goobyteks);
      gooby.yhdista_rect(gooby_arkki, (sizeof(gooby_arkki)/sizeof(*gooby_arkki)), sizeof(gooby_arkki));
      dolan.yhdista_tekstuuri(&dolanteks);
      dolan.yhdista_rect(dolan_arkki, (sizeof(dolan_arkki)/sizeof(*dolan_arkki)), sizeof(dolan_arkki));
      pistooli.yhdista_tekstuuri(&pistooliteks);
      pistooli.yhdista_rect(pistooliarkki, (sizeof(pistooliarkki)/sizeof(*pistooliarkki)), sizeof(pistooliarkki));
      pumppu.yhdista_tekstuuri(&pumpputeks);
      pumppu.yhdista_rect(pumppuarkki, (sizeof(pumppuarkki)/sizeof(*pumppuarkki)), sizeof(pumppuarkki));
      kirves.yhdista_tekstuuri(&kirvesteks);
      kirves.yhdista_rect(kirvesarkki, (sizeof(kirvesarkki)/sizeof(*kirvesarkki)), sizeof(kirvesarkki));
      vipu.yhdista_tekstuuri(&viputeks);
      vipu.yhdista_rect(vipuarkki, (sizeof(vipuarkki)/sizeof(*vipuarkki)), sizeof(vipuarkki));

      deyes.yhdista_tekstuuri(&doleyes);
      deyes.yhdista_rect(deyes_arkki, (sizeof(deyes_arkki)/sizeof(*deyes_arkki)), sizeof(deyes_arkki));
      dolblink.yhdista_tekstuuri(&dolblinkteks);
      dolblink.yhdista_rect(dolblink_arkki, (sizeof(dolblink_arkki)/sizeof(*dolblink_arkki)), sizeof(dolblink_arkki));
      spblink.yhdista_tekstuuri(&spblinkteks);
      spblink.yhdista_rect(spblink_arkki, (sizeof(spblink_arkki)/sizeof(*spblink_arkki)), sizeof(spblink_arkki));
      diginums.yhdista_tekstuuri(&diginumteks);
      diginums.yhdista_rect(diginum_arkki, (sizeof(diginum_arkki)/sizeof(*diginum_arkki)), sizeof(diginum_arkki));
      kyy.yhdista_tekstuuri(&kyyteks);
      kyy.yhdista_rect(kyy_arkki, (sizeof(kyy_arkki)/sizeof(*kyy_arkki)), sizeof(kyy_arkki));
      naps.yhdista_tekstuuri(&napsteks);
      naps.yhdista_rect(naps_arkki, (sizeof(naps_arkki)/sizeof(*naps_arkki)), sizeof(naps_arkki));
      splash.yhdista_tekstuuri(&splashteks);
      splash.yhdista_rect(splash_arkki, (sizeof(splash_arkki)/sizeof(*splash_arkki)), sizeof(splash_arkki));
      hurme.yhdista_tekstuuri(&hurmeteks);
      hurme.yhdista_rect(hurme_arkki, (sizeof(hurme_arkki)/sizeof(*hurme_arkki)), sizeof(hurme_arkki));
      hurme2.yhdista_tekstuuri(&hurme2teks);
      hurme2.yhdista_rect(hurme2_arkki, (sizeof(hurme2_arkki)/sizeof(*hurme2_arkki)), sizeof(hurme2_arkki));
      aspurdo.yhdista_tekstuuri(&aspurdoteks);
      aspurdo.yhdista_rect(aspurdo_arkki, (sizeof(aspurdo_arkki)/sizeof(*aspurdo_arkki)), sizeof(aspurdo_arkki));
      adolan.yhdista_tekstuuri(&adolanteks);
      adolan.yhdista_rect(adolan_arkki, (sizeof(adolan_arkki)/sizeof(*adolan_arkki)), sizeof(adolan_arkki));

      spurdo.x = 20;
      gooby.x = 20;
      
      taustakuva = kysymystausta;

      SDL_Event tapahtuma;

      cout << "Koitan ladata fontteja" << endl;
      fontti = TTF_OpenFont("./fontti.ttf", 15);
      fontti2 = TTF_OpenFont("./fontti.ttf", 18);
      cout << "Fontit ladattu" << endl;
      SDL_Surface *oikeinteksti_s = TTF_RenderText_Solid(fontti, "OIGEIN!", tekstivari);
      SDL_Surface *vaarinteksti_s = TTF_RenderText_Solid(fontti, "VRIN!", tekstivari);
      SDL_Surface *voittoteksti_s = TTF_RenderText_Solid(fontti, "EBIN SUORIDUS :DDD", tekstivari);
      SDL_Surface *aikateksti_s = TTF_RenderText_Solid(fontti, "AIGA LOBBUI!", tekstivari);
      SDL_Surface *bonusteksti_s = TTF_RenderText_Solid(fontti, "BONUSx:", tekstivari);
      SDL_Surface *loppuiteksti_s = TTF_RenderText_Solid(fontti, "B E L I  O H I Z E", tekstivari);
      SDL_Surface *loppuiteksti2_s = TTF_RenderText_Solid(fontti, "Nin gvi dll gerdaa", tekstivari);
      SDL_Surface *tasateksti_s = TTF_RenderText_Solid(fontti, "BELI MENI DASAN!", tekstivari);
      SDL_Surface *enem1_teksti_s = TTF_RenderText_Solid(fontti, "Belaaja 1 sai dosin enemmn bointseja", tekstivari);
      SDL_Surface *enem2_teksti_s = TTF_RenderText_Solid(fontti, "Belaaja 2 sai dosin enemmn bointseja", tekstivari);
      SDL_Surface *loppukehotus_s = TTF_RenderText_Solid(fontti, "Uusi beli? Baina [G]yll tai [E]i?", tekstivari);
      SDL_Surface *kakpellopteksti_s = TTF_RenderText_Solid(fontti, "Girvelev tabbio", tekstivari);
      SDL_Surface *painateksti_s = TTF_RenderText_Solid(fontti, "Baina", tekstivari);
      SDL_Surface *entteriateksti_s = TTF_RenderText_Solid(fontti, "endderii", tekstivari);
      oikeinteksti = SDL_CreateTextureFromSurface(piirturi, oikeinteksti_s);
      vaarinteksti = SDL_CreateTextureFromSurface(piirturi, vaarinteksti_s);
      loppuiteksti = SDL_CreateTextureFromSurface(piirturi, loppuiteksti_s);
      loppuiteksti2 = SDL_CreateTextureFromSurface(piirturi, loppuiteksti2_s);
      loppukehotus = SDL_CreateTextureFromSurface(piirturi, loppukehotus_s);
      tasateksti = SDL_CreateTextureFromSurface(piirturi, tasateksti_s);
      enem1_teksti = SDL_CreateTextureFromSurface(piirturi, enem1_teksti_s);
      enem2_teksti = SDL_CreateTextureFromSurface(piirturi, enem2_teksti_s);
      aikateksti = SDL_CreateTextureFromSurface(piirturi, aikateksti_s);
      voittoteksti = SDL_CreateTextureFromSurface(piirturi, voittoteksti_s);
      kakpellopteksti = SDL_CreateTextureFromSurface(piirturi, kakpellopteksti_s);
      painateksti = SDL_CreateTextureFromSurface(piirturi, painateksti_s);
      entteriateksti = SDL_CreateTextureFromSurface(piirturi, entteriateksti_s);
      SDL_Texture *bonusteksti = SDL_CreateTextureFromSurface(piirturi, bonusteksti_s);
      SDL_Rect bonusnelio = {542, 79, MERKINPITUUS*6, MERKINKORKEUS};
      SDL_Rect painarect = {318, 436, 45, 21};
      SDL_Rect entteriarect = {304, 454, 72, 21};
      SDL_FreeSurface(bonusteksti_s);
      SDL_FreeSurface(oikeinteksti_s);
      SDL_FreeSurface(vaarinteksti_s);
      SDL_FreeSurface(loppuiteksti_s);
      SDL_FreeSurface(loppuiteksti2_s);
      SDL_FreeSurface(loppukehotus_s);
      SDL_FreeSurface(aikateksti_s);
      SDL_FreeSurface(kakpellopteksti_s);
      SDL_FreeSurface(tasateksti_s);
      SDL_FreeSurface(enem1_teksti_s);
      SDL_FreeSurface(enem2_teksti_s);
      SDL_FreeSurface(painateksti_s);
      SDL_FreeSurface(entteriateksti_s);

      int pelaaja1_l = 0;
      int pelaaja2_l = 0;

      SDL_Rect pelaaja1_n = {20+(MERKINPITUUS*(25-static_cast<int>(pelaaja1.length()))/2), 10, pelaaja1_l, MERKINKORKEUS};
      SDL_Rect pelaaja2_n = {20+(MERKINPITUUS*(25-static_cast<int>(pelaaja2.length()))/2), RUUDUNKORKEUS-36-MERKINKORKEUS, pelaaja2_l, MERKINKORKEUS};
      
      while(!quit) {
	ajastin1 = SDL_GetTicks();

	SDL_SetRenderDrawColor(piirturi, 0x0, 0x0, 0x0, 0x0);
	SDL_RenderClear(piirturi);
	SDL_SetRenderDrawColor(piirturi, 0xFF, 0xFF, 0xFF, 0xFF);

	if(taustakuva.tekstuuri != NULL) {
	  taustakuva.renderfunktio(0, 0, NULL);
	}

	if(pelinvaihe == SEURAAVA_KYSYMYS) {
	  string monesko;
	  string pisteet;
	  switch(kysymyskountteri) {
	  case 1: monesko = "Ensimminen gysymys"; pisteet = "Darjolla 10 bointsia"; break;
	  case 2: monesko = "Doinen gysymys"; pisteet = "Darjolla 50 bointsia"; break;
	  case 3: monesko = "Golmas gysymys"; pisteet = "Darjolla 100 bointsia"; break;
	  case 4: monesko = "Neljs gysymys"; pisteet = "Darjolla 200 bointsia"; break;
	  case 5: monesko = "Viides gysymys"; pisteet = "Darjolla 500 bointsia"; break;
	  case 6: monesko = "Guudes gysymys"; pisteet = "Darjolla 600 bointsia"; break;
	  case 7: monesko = "Seidsems gysymys"; pisteet = "Darjolla 650 bointsia"; break;
	  case 8: monesko = "Gahdegsas gysymys"; pisteet = "Darjolla 700 bointsia"; break;
	  case 9: monesko = "Yhdegss gysymys"; pisteet = "Darjolla 800 bointsia"; break;
	  case 10: monesko = "Gymmenes gysymys"; pisteet = "Darjolla 1000 bointsia"; break;
	  }
	  sk_laatikko.renderfunktio(60, 90);

	  bonuskerroin = rand()%10000;
	  
	  if(kaksinpeli) {
	    if(kumpi == 's') tekstirend(136, 116, 0, "Pelaaja 1", fontti);
	    else tekstirend(136, 116, 0, "Pelaaja 2", fontti);
	    tekstirend(106, 134, 0, monesko, fontti);
	    tekstirend(106, 164, 0, pisteet, fontti);
	  }
	  else {
	    tekstirend(104, 124, 0, monesko, fontti);
	    tekstirend(104, 154, 0, pisteet, fontti);
	  }

	  SDL_RenderCopy(piirturi, pelaaja1_t, NULL, &pelaaja1_n);
	  if(katkaisu) pelinvaihe = KYSYMYKSEN_LUONTI;
	}
	
	if(pelinvaihe == KYSYMYKSEN_LUONTI) {
	  
	  nollaa_kysymys();

	  uint16_t kysymysnro = kysymysarvonta();
	  kysytyt.push_back(kysymysnro);

	  k_iter = kysymystietokantavec.begin()+kysymysnro;
	  k_luku = k_iter->k_luku;
	  if(k_iter->oikea == 1) oikea_vastaus = kr(k_iter->vast1);
	  else if(k_iter->oikea == 2) oikea_vastaus = kr(k_iter->vast2);
	  else if(k_iter->oikea == 3) oikea_vastaus = kr(k_iter->vast3);
	  else if(k_iter->oikea == 4) oikea_vastaus = kr(k_iter->vast4);

	  if(kr(k_iter->vast4) == "") paikat[4] = 't';
	  if(kr(k_iter->vast3) == "") paikat[3] = 't';

	  if(k_iter->luk1 == true) {paikat[1] = 'l'; vaihtoehto1 = kr(k_iter->vast1);}
	  if(k_iter->luk2 == true) {paikat[2] = 'l'; vaihtoehto2 = kr(k_iter->vast2);}
	  if(k_iter->luk3 == true) {paikat[3] = 'l'; vaihtoehto3 = kr(k_iter->vast3);}
	  if(k_iter->luk4 == true) {paikat[4] = 'l'; vaihtoehto4 = kr(k_iter->vast4);}

	  uint8_t kysymyspaikka = 0;
	  kysymyspaikka = paikan_arvonta();
	  if(kysymyspaikka == 1) {vaihtoehto1 = kr(k_iter->vast1); paikat[1] = 'k';}
	  else if(kysymyspaikka == 2) {vaihtoehto2 = kr(k_iter->vast1); paikat[2] = 'k';}
	  else if(kysymyspaikka == 3) {vaihtoehto3 = kr(k_iter->vast1); paikat[3] = 'k';}
	  else if(kysymyspaikka == 4) {vaihtoehto4 = kr(k_iter->vast1); paikat[4] = 'k';}

	  kysymyspaikka = paikan_arvonta();
	  if(kysymyspaikka == 1) {vaihtoehto1 = kr(k_iter->vast2); paikat[1] = 'k';}
	  else if(kysymyspaikka == 2) {vaihtoehto2 = kr(k_iter->vast2); paikat[2] = 'k';}
	  else if(kysymyspaikka == 3) {vaihtoehto3 = kr(k_iter->vast2); paikat[3] = 'k';}
	  else if(kysymyspaikka == 4) {vaihtoehto4 = kr(k_iter->vast2); paikat[4] = 'k';}
	  if(paikat[3] != 't') {
	    kysymyspaikka = paikan_arvonta();
	    if(kysymyspaikka == 1) {vaihtoehto1 = kr(k_iter->vast3); paikat[1] = 'k';}
	    else if(kysymyspaikka == 2) {vaihtoehto2 = kr(k_iter->vast3); paikat[2] = 'k';}
	    else if(kysymyspaikka == 3) {vaihtoehto3 = kr(k_iter->vast3); paikat[3] = 'k';}
	    else if(kysymyspaikka == 4) {vaihtoehto4 = kr(k_iter->vast3); paikat[4] = 'k';}
	  }

	  if(paikat[4] != 't' and paikat[4] != 'l') {
	    kysymyspaikka = paikan_arvonta();
	    if(kysymyspaikka == 1) {vaihtoehto1 = kr(k_iter->vast4); paikat[1] = 'k';}
	    else if(kysymyspaikka == 2) {vaihtoehto2 = kr(k_iter->vast4); paikat[2] = 'k';}
	    else if(kysymyspaikka == 3) {vaihtoehto3 = kr(k_iter->vast4); paikat[3] = 'k';}
	    else if(kysymyspaikka == 4) {vaihtoehto4 = kr(k_iter->vast4); paikat[4] = 'k';}
	  }

	  vaihtoehto1 = "a) " + vaihtoehto1;
	  vaihtoehto2 = "b) " + vaihtoehto2;
	  vaihtoehto3 = "c) " + vaihtoehto3;
	  vaihtoehto4 = "d) " + vaihtoehto4;

	  kysymysvec = autowrap(RIVINPITUUS, kr(k_iter->kysym));

	  vastvec1 = autowrap(RIVINPITUUS, vaihtoehto1);

	  vastvec2 = autowrap(RIVINPITUUS, vaihtoehto2);
	  if(kr(k_iter->vast3) != "") vastvec3 = autowrap(RIVINPITUUS, vaihtoehto3);
	  if(kr(k_iter->vast4) != "") vastvec4 = autowrap(RIVINPITUUS, vaihtoehto4);
	  if(kr(k_iter->selitys) != "") selitysvec = autowrap(RIVINPITUUS, kr(k_iter->selitys));
	  pelinvaihe = LAATIKKO_ISONTUU;
	  vaihecounter = 1;
	}

	if(pelinvaihe == KYSYMYKSEN_RENDAUS) {
	  if(kys_rendattu) {
	    vaihecounter = 10000;
	    pelinvaihe = KYSYMYKSEN_KYSYMINEN;
	    sekunnit = 20;
	    sekkounter = 0;
	    katkaisu = false;
	  }
	}
	
	if(pelinvaihe == OIKEIN) {
	  laatikon_piirto(6+selitysvec.size());
	  int leveys;

	  int erotus = vaihecounter - vaihecounter2;
	  if(erotus < 10) {
	    SDL_QueryTexture(oikeinteksti, NULL, NULL, &leveys, NULL);
	    SDL_Rect oikeinnelio = {kystekstix+120, kystekstiy+6, leveys+50, MERKINKORKEUS+10};
	    SDL_RenderCopy(piirturi, oikeinteksti, NULL, &oikeinnelio);
	  }
	  else if(erotus > 14) vaihecounter2 = vaihecounter;
	 
	  int selsize = selitysvec.size();
	  if(selsize > 0) {
	    if(selsize > 1) {
	      int rivi = 0;
	      for(vector<string>::iterator sel_iter = selitysvec.begin(); sel_iter != selitysvec.end(); ++sel_iter) {
		string selstring = *sel_iter;
		if(selstring == "") break;
		tekstirend(kystekstix+10, kystekstiy+60, rivi, selstring, fontti);
		rivi++;
	      }
	    }
	    else {
	      vector<string>::iterator sel_iter = selitysvec.begin();
	      string selstring = *sel_iter;
	      int tekstinalku = ((RIVINPITUUS-selstring.length())*MERKINPITUUS)/2;
	      tekstirend(kystekstix+tekstinalku, kystekstiy+60, 0, selstring, fontti);
	    }
	  }

	  if(vaihecounter > HEILMAX) {
	    vaihecounter = 0;
	    spurdo.frame = 0;
	    gooby.frame = 0;

	    if(!kaksinpeli) {
	      if(kysymyskountteri == 10) pelinvaihe = VOITTO;
	      else {
		pelinvaihe = SEURAAVA_KYSYMYS;
		soita_aani = 5;
		kysymyskountteri++;
		vaihecounter = 1;
		katkaisu = false;
	      }
	    }

	    else { 
	      if(kysymyskountteri == 10 and kumpi == 'g') {
		tulos = kaksinpelin_tulos();
		vaihecounter = 1;
		if(tulos == 2 or tulos == 3) pelinvaihe = HAHMONVAIHTO;
		else pelinvaihe = KILPAILIJAN_TAPPAMINEN;
	      }
	      else {
		tulos = tulostarkistus(kysymyskountteri);
		if(tulos > 0) {
		  if((tulos == 1 and kumpi == 's') or (tulos == 2 and kumpi == 'g')) pelinvaihe = HAHMONVAIHTO;
		  else if((tulos == 1 and kumpi == 'g') or (tulos == 2 and kumpi == 's')) {
		    pelinvaihe = KILPAILIJAN_TAPPAMINEN;
		    ilmeet = false;
		  }
		}
		else pelinvaihe = HAHMONVAIHTO;
		vaihecounter = 1;
		if(kumpi == 'g' and kysymyskountteri != 10) kysymyskountteri++;
		katkaisu = false;
	      }
	    }
	    if(pelinvaihe == VOITTO) {
	      kokh = 0;
	      koky = 64;
	      vaihecounter = 1;
	      vaihecounter2 = 0;
	      kokvec.empty();
	      kokvec2.empty();
	    }
	  }
	}

	if(pelinvaihe == VAARIN or pelinvaihe == KILPAILIJAN_TAPPAMINEN) {
	  laatikon_piirto(6);
	  int leveys;
	  if(tulos > 0 and kysymyskountteri >= 10) {
	      if(kumpi == 's') tekstirend(kystekstix+120, 106, 0, "Pelaaja 1", fontti);
	      else tekstirend(kystekstix+120, 106, 0, "Pelaaja 2", fontti);
	  }
	  else if(tulos > 0) {
	      if(kumpi == 's') tekstirend(kystekstix+60, 106, 0, "Belaaja 1 meneddi jo belin", fontti);
	      else tekstirend(kystekstix+60, 106, 0, "Belaaja 2 meneddi jo belin", fontti);
	  }
	  
	  int erotus = vaihecounter - vaihecounter2;
	  if(erotus < 10 or vaihecounter > 50) {
	    if(sekunnit == -2 and tulos == 0) {
	      SDL_QueryTexture(aikateksti, NULL, NULL, &leveys, NULL);
	      SDL_Rect aikanelio = {kystekstix+90, kystekstiy+6, leveys+50, MERKINKORKEUS+10};
	      SDL_RenderCopy(piirturi, aikateksti, NULL, &aikanelio);
	    }
	    else if(tulos > 0) {
	      if(vaihecounter == 2) {
		soita_aani = 9;
		if(pelinvaihe == KILPAILIJAN_TAPPAMINEN) {
		  ilmeet = true;
		  int st = 0;
		  int gt = 0;
		  for(int i = 0; i != 10; i++) {
		    if(p1_vastaukset[i] == 't') st++;
		    if(p2_vastaukset[i] == 't') gt++;
		  }
		  if(st > 0 or gt > 0) {
		    if(gt > st and tulos == 2) soita_aani = 0;
		    else if(gt == st and tulos == 1) soita_aani = 0;
		  }
		}
	      }
	      SDL_QueryTexture(kakpellopteksti, NULL, NULL, &leveys, NULL);
	      SDL_Rect kakpelnelio = {kystekstix+70, kystekstiy+6, leveys+50, MERKINKORKEUS+10};
	      SDL_RenderCopy(piirturi, kakpellopteksti, NULL, &kakpelnelio);
	    }
	    else {
	      SDL_QueryTexture(vaarinteksti, NULL, NULL, &leveys, NULL);
	      SDL_Rect vaarinnelio = {kystekstix+100, kystekstiy+6, leveys+50, MERKINKORKEUS+10};
	      SDL_RenderCopy(piirturi, vaarinteksti, NULL, &vaarinnelio);
	    }
	  }
	  else if(erotus > 14) vaihecounter2 = vaihecounter;
	 
	  if(!kaksinpeli and vaihecounter > 190) {
	    vaihecounter = 0;
	    vaihecounter2 = 0;
	    nollaa_kysymys();
	    rip_anim = TYHJA;
	    pelinvaihe = PELI_LOPPUI;
	    soita_musa = 3;
	  }
	  else if(kaksinpeli and vaihecounter > 70 and pelinvaihe == VAARIN and tulos == 0) {
	    vaihecounter = 0;
	    vaihecounter2 = 0;
	    nollaa_kysymys();
	    if(kysymyskountteri == 10 and kumpi == 'g') {
	      tulos = kaksinpelin_tulos();
	      vaihecounter = 1;
	      if(tulos == 2) pelinvaihe = HAHMONVAIHTO;
	      else if(tulos == 3) pelinvaihe = HAHMONVAIHTO;
	      else {
		pelinvaihe = KILPAILIJAN_TAPPAMINEN;
		rip_anim = tappamisarvonta();
	      }
	    }
	    else {
	      tulos = tulostarkistus(kysymyskountteri);
	      if(tulos > 0) {
		if((tulos == 1 and kumpi == 's') or (tulos == 2 and kumpi == 'g')) pelinvaihe = HAHMONVAIHTO;
		else ilmeet = false;
	      }
	      else {
		pelinvaihe = HAHMONVAIHTO;
	      }
	      vaihecounter = 1;
	      if(kumpi == 'g' and tulos == 0) kysymyskountteri++;
	    }
	  }
	  else if((kaksinpeli and vaihecounter > 190 and tulos > 0 and pelinvaihe != VAARIN)
		  or kaksinpeli and tulos > 0 and pelinvaihe == VAARIN and vaihecounter > 90) {
	    vaihecounter = 1;
	    if(pelinvaihe == KILPAILIJAN_TAPPAMINEN) pelinvaihe = HAHMONVAIHTO;
	    else if((tulos == 1 and kumpi == 's') or (tulos == 2 and kumpi == 'g')) pelinvaihe = HAHMONVAIHTO;
	    else if((tulos == 1 and kumpi == 'g') or (tulos == 2 and kumpi == 's')) {
	      pelinvaihe = KILPAILIJAN_TAPPAMINEN;
	      rip_anim = tappamisarvonta();
	    }
	  }
	}

	while(SDL_PollEvent(&tapahtuma)!=0) {
	  if(tapahtuma.type == SDL_QUIT) quit = true;
	  if(tapahtuma.type == SDL_KEYDOWN) {
	    
	    switch(tapahtuma.key.keysym.sym) {

	    case SDLK_RETURN:
	      if(ohjelmantila == ALKURUUTU) {
		ohjelmantila = VALINTARUUTU;
		soita_musa = 0;
	      }
	      else if(ohjelmantila == INTRO or pelinvaihe == KYSYMYKSEN_RENDAUS or pelinvaihe == SEURAAVA_KYSYMYS or pelinvaihe == PELI_ALKAA) katkaisu = true;
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 != 5) {
		katkaisu = true;
		if(vaihecounter2 == 0 and (valinta == '1' or valinta == '2')) soita_aani = 2;
	      }
	      else if(pelinvaihe == KYSYMYKSEN_KYSYMINEN and valinta != '0') {
		if(oikein_vai_vaarin()) {
		  pelinvaihe = OIKEIN;
		  soita_aani = 10;
		  sekunnit = -1;
		  if(kumpi == 's') p1_oikeinlaskuri++;
		  else p2_oikeinlaskuri++;
		  vaihecounter = 1;
		  vaihecounter2 = 0;
		  if(kumpi == 's') {
		    if(kaksinpeli) p1_vastaukset[kysymyskountteri-1] = 'o';
		    switch(kysymyskountteri) {
		    case 1: p1_pisteet += 10*bonuskerroin; break;
		    case 2: p1_pisteet += 50*bonuskerroin; break;
		    case 3: p1_pisteet += 100*bonuskerroin; break;
		    case 4: p1_pisteet += 200*bonuskerroin; break;
		    case 5: p1_pisteet += 500*bonuskerroin; break;
		    case 6: p1_pisteet += 600*bonuskerroin; break;
		    case 7: p1_pisteet += 650*bonuskerroin; break;
		    case 8: p1_pisteet += 700*bonuskerroin; break;
		    case 9: p1_pisteet += 800*bonuskerroin; break;
		    case 10: p1_pisteet += 1000*bonuskerroin; break;
		    }
		  }
		    else {
		      p2_vastaukset[kysymyskountteri-1] = 'o';
		      switch(kysymyskountteri) {
		      case 1: p2_pisteet += 10*bonuskerroin; break;
		      case 2: p2_pisteet += 50*bonuskerroin; break;
		      case 3: p2_pisteet += 100*bonuskerroin; break;
		      case 4: p2_pisteet += 200*bonuskerroin; break;
		      case 5: p2_pisteet += 500*bonuskerroin; break;
		      case 6: p2_pisteet += 600*bonuskerroin; break;
		      case 7: p2_pisteet += 650*bonuskerroin; break;
		      case 8: p2_pisteet += 700*bonuskerroin; break;
		      case 9: p2_pisteet += 800*bonuskerroin; break;
		      case 10: p2_pisteet += 1000*bonuskerroin; break;
		      }
		    }
		}
		else {
		  soita_aani = 9;
		  vaihecounter = 1;
		  if(kaksinpeli) {
		    pelinvaihe = VAARIN;
		    sekunnit = -1;
		    if(kumpi == 's') p1_vastaukset[kysymyskountteri-1] = 'v';
		    else p2_vastaukset[kysymyskountteri-1] = 'v';
		  }
		  else {
		    pelinvaihe = KILPAILIJAN_TAPPAMINEN;
		    sekunnit = -1;
		    rip_anim = tappamisarvonta();
		  }
		}
	      }
	      break;
	    case SDLK_1:
	      if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "1";
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "1";
	      else if(ohjelmantila == VALINTARUUTU) {valinta = '1'; soita_aani = 1;}
	      break;
	    case SDLK_2:
	      if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "2";
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "2";
	      else if(ohjelmantila == VALINTARUUTU) {valinta = '2'; soita_aani = 1;}
	      break;
	    case SDLK_3:
	      if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "3";
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "3";
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 >= 4) {valinta = '3'; soita_aani = 1;}
	      break;
	    case SDLK_4:
	      if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "4";
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "4";
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 >= 4) {valinta = '4'; soita_aani = 1;}
	      break;
	    case SDLK_5:
	      if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "5";
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "5";
	      break;
	    case SDLK_6:
	      if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "6";
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "6";
	      break;
	    case SDLK_7:
	      if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "7";
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "7";
	      break;
	    case SDLK_8:
	      if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "8";
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "8";
	      break;
	    case SDLK_9:
	      if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "9";
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "9";
	      break;
	    case SDLK_0:
	      if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "0";
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "0";
	      break;
	    case SDLK_SPACE:
	      if(ohjelmantila == INTRO or pelinvaihe == KYSYMYKSEN_RENDAUS or pelinvaihe == SEURAAVA_KYSYMYS) katkaisu = true;
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += " ";
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += " ";
	      break;

	    case SDLK_a:
	      if((SDL_GetModState() & KMOD_RSHIFT) or SDL_GetModState() & KMOD_LSHIFT ) {
	        if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "A";
	        else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "A";
		break;
	      }
	      if(pelinvaihe == KYSYMYKSEN_KYSYMINEN) {valinta = 'a'; soita_aani = 1;}
	      else if(ohjelmantila == HISCORE) {
		vaihecounter = 0;
		ohjelmantila = TAKAISIN_ALKURUUTUUN;
		pelinvaihe = PELI_LOPPUI;
	      }
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "a";
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "a";
	      break;
	      
	    case SDLK_b:
	      if((SDL_GetModState() & KMOD_RSHIFT) or SDL_GetModState() & KMOD_LSHIFT ) {
	        if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "B";
	        else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "B";
		break;
	      }
	      if(pelinvaihe == KYSYMYKSEN_KYSYMINEN) {valinta = 'b'; soita_aani = 1;}
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "b";
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "b";
	      break;
	    case SDLK_c:
	      if((SDL_GetModState() & KMOD_RSHIFT) or SDL_GetModState() & KMOD_LSHIFT ) {
	        if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "C";
	        else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "C";
		break;
	      }
	      if(pelinvaihe == KYSYMYKSEN_KYSYMINEN) {valinta = 'c'; soita_aani = 1;}
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "c";
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "c";
	      break;
	    case SDLK_d:
	      if((SDL_GetModState() & KMOD_RSHIFT) or SDL_GetModState() & KMOD_LSHIFT ) {
	        if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "D";
	        else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "D";
		break;
	      }
	      if(pelinvaihe == KYSYMYKSEN_KYSYMINEN) {valinta = 'd'; soita_aani = 1;}
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "d";
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "d";
	      break;
	    case SDLK_e:
	      if((SDL_GetModState() & KMOD_RSHIFT) or SDL_GetModState() & KMOD_LSHIFT ) {
	        if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "E";
	        else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "E";
		break;
	      }
	      if(pelinvaihe == PELI_LOPPUI) quit = true;
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "e";
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "e";
	      break;
	    case SDLK_f:
	      if((SDL_GetModState() & KMOD_RSHIFT) or SDL_GetModState() & KMOD_LSHIFT ) {
	        if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "F";
	        else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "F";
		break;
	      }
	      if(pelinvaihe == PELI_LOPPUI) quit = true;
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "f";
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "f";
	      break;
	    case SDLK_g:
	      if((SDL_GetModState() & KMOD_RSHIFT) or SDL_GetModState() & KMOD_LSHIFT ) {
	        if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "G";
	        else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "G";
		break;
	      }
	      if(pelinvaihe == PELI_LOPPUI) {
		vaihecounter = 0;
		ohjelmantila = TAKAISIN_ALKURUUTUUN;
	      }
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "g";
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "g";
	      break;
	    case SDLK_h:
	      if((SDL_GetModState() & KMOD_RSHIFT) or SDL_GetModState() & KMOD_LSHIFT ) {
		if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "H";
	        else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "H";
		break;
	      }
	      if(pelinvaihe == PELI_LOPPUI) quit = true;
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "h";
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "h";
	      break;
	    case SDLK_i:
	      if((SDL_GetModState() & KMOD_RSHIFT) or SDL_GetModState() & KMOD_LSHIFT ) {
		if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "I";
	        else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "I";
		break;
	      }
	      if(pelinvaihe == PELI_LOPPUI) quit = true;
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "i";
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "i";
	      break;
	    case SDLK_j:
	      if((SDL_GetModState() & KMOD_RSHIFT) or SDL_GetModState() & KMOD_LSHIFT ) {
		if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "J";
	        else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "J";
		break;
	      }
	      if(pelinvaihe == PELI_LOPPUI) quit = true;
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "j";
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "j";
	      break;
	    case SDLK_k:
	      if((SDL_GetModState() & KMOD_RSHIFT) or SDL_GetModState() & KMOD_LSHIFT ) {
		if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "K";
	        else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "K";
		break;
	      }
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "k";
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "k";
	      break;
	    case SDLK_l:
	      if((SDL_GetModState() & KMOD_RSHIFT) or SDL_GetModState() & KMOD_LSHIFT ) {
		if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "L";
	        else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "L";
		break;
	      }
	      if(ohjelmantila == HISCORE) quit = true;
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "l";
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "l";
	      break;
	    case SDLK_m:
	      if((SDL_GetModState() & KMOD_RSHIFT) or SDL_GetModState() & KMOD_LSHIFT ) {
		if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "M";
	        else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "M";
		break;
	      }
	      if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "m";
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "m";
	      break;
	    case SDLK_n:
	      if((SDL_GetModState() & KMOD_RSHIFT) or SDL_GetModState() & KMOD_LSHIFT ) {
		if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "N";
	        else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "N";
		break;
	      }
	      if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "n";
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "n";
	      break;
	    case SDLK_o:
	      if((SDL_GetModState() & KMOD_RSHIFT) or SDL_GetModState() & KMOD_LSHIFT ) {
		if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "O";
	        else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "O";
		break;
	      }
	      if((SDL_GetModState() & KMOD_RSHIFT) or SDL_GetModState() & KMOD_LSHIFT ) {
		if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "O";
	        else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "O";
		break;
	      }
	      if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "o";
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "o";
	      break;
	    case SDLK_p:
	      if((SDL_GetModState() & KMOD_RSHIFT) or SDL_GetModState() & KMOD_LSHIFT ) {
		if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "P";
	        else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "P";
		break;
	      }
	      if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "p";
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "p";
	      break;
	    case SDLK_q:
	      if((SDL_GetModState() & KMOD_RSHIFT) or SDL_GetModState() & KMOD_LSHIFT ) {
		if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "Q";
	        else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "Q";
		break;
	      }
	      if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "q";
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "q";
	      break;
	    case SDLK_r:
	      if((SDL_GetModState() & KMOD_RSHIFT) or SDL_GetModState() & KMOD_LSHIFT ) {
		if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "R";
	        else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "R";
		break;
	      }
	      if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "r";
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "r";
	      break;
	    case SDLK_s:
	      if((SDL_GetModState() & KMOD_RSHIFT) or SDL_GetModState() & KMOD_LSHIFT ) {
		if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "S";
	        else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "S";
		break;
	      }
	      if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "s";
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "s";
	      break;
	    case SDLK_t:
	      if((SDL_GetModState() & KMOD_RSHIFT) or SDL_GetModState() & KMOD_LSHIFT ) {
		if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "T";
	        else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "T";
		break;
	      }
	      if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "t";
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "t";
	      break;
	    case SDLK_u:
	      if((SDL_GetModState() & KMOD_RSHIFT) or SDL_GetModState() & KMOD_LSHIFT ) {
		if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "U";
	        else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "U";
		break;
	      }
	      if(pelinvaihe == PELI_LOPPUI) {
		ohjelmantila = TAKAISIN_ALKURUUTUUN;
		vaihecounter = 0;
	      }
	      if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "u";
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "u";
	      break;
	    case SDLK_v:
	      if((SDL_GetModState() & KMOD_RSHIFT) or SDL_GetModState() & KMOD_LSHIFT ) {
		if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "V";
	        else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "V";
		break;
	      }
	      if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "v";
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "v";
	      break;
	    case SDLK_w:
	      if((SDL_GetModState() & KMOD_RSHIFT) or SDL_GetModState() & KMOD_LSHIFT ) {
		if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "W";
	        else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "W";
		break;
	      }
	      if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "w";
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "w";
	      break;
	    case SDLK_x:
	      if((SDL_GetModState() & KMOD_RSHIFT) or SDL_GetModState() & KMOD_LSHIFT ) {
		if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "X";
	        else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "X";
		break;
	      }
	      if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "x";
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "x";
	      break;
	    case SDLK_y:
	      if((SDL_GetModState() & KMOD_RSHIFT) or SDL_GetModState() & KMOD_LSHIFT ) {
		if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "Y";
	        else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "Y";
		break;
	      }
	      if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "y";
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "y";
	      break;
	    case SDLK_z:
	      if((SDL_GetModState() & KMOD_RSHIFT) or SDL_GetModState() & KMOD_LSHIFT ) {
		if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "Z";
	        else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "Z";
		break;
	      }
	      if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "z";
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "z";
	      break;
	    case 45:
	      if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "-";
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "-";
	      break;
	    case 228:
	      if((SDL_GetModState() & KMOD_RSHIFT) or SDL_GetModState() & KMOD_LSHIFT ) {
		if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "";
	        else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "";
		break;
	      }
	      if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "";
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "";
	      break;
	    case 246:
	      if((SDL_GetModState() & KMOD_RSHIFT) or SDL_GetModState() & KMOD_LSHIFT ) {
		if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "";
	        else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "";
		break;
	      }
	      if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "";
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "";
	      break;
	    case 229:
	      if((SDL_GetModState() & KMOD_RSHIFT) or SDL_GetModState() & KMOD_LSHIFT ) {
		if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "";
	        else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "";
		break;
	      }
	      if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) pelaaja1 += "";
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) pelaaja2 += "";
	      break;
	    case 8:
	      if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 1) {
		if(pelaaja1.length() > 0) pelaaja1.erase(pelaaja1.length()-1, 1);
	      }
	      else if(ohjelmantila == VALINTARUUTU and vaihecounter2 == 2) {
		if(pelaaja2.length() > 0) pelaaja2.erase(pelaaja2.length()-1, 1);
	      }
	      break;
	    }
	    if(ohjelmantila == VALINTARUUTU and (vaihecounter2 == 1 or vaihecounter2 == 2)
	       and ((tapahtuma.key.keysym.sym <= 122 and tapahtuma.key.keysym.sym >= 97) or tapahtuma.key.keysym.sym == 108
		    or tapahtuma.key.keysym.sym == 8 or tapahtuma.key.keysym.sym == 246 or tapahtuma.key.keysym.sym == 112
		    or tapahtuma.key.keysym.sym == 32 or tapahtuma.key.keysym.sym == 228 or tapahtuma.key.keysym.sym == 229
		    or tapahtuma.key.keysym.sym >= 48 and tapahtuma.key.keysym.sym <= 57) and soita_aani != 1)
	      soita_aani = 3;
	  }
	}
	if(ohjelmantila == INTRO) {
	  if(katkaisu) {
	    if(vaihecounter2 == 1) vaihecounter2 = 40;
	    else if(vaihecounter2 == 40) vaihecounter2 = 80;
	    katkaisu = false;
	  }
	  if(vaihecounter == 1 and vaihecounter2 == 0) {
	    taustakuva = biojate;
	    soita_musa = 1;
	    vaihecounter2 = 1;
	  }
	  if(vaihecounter2 == 40) {
	    taustakuva = es;
	    vaihecounter = 1;
	  }
	  if(vaihecounter2 == 80) {
	    ohjelmantila = ALKURUUTU;
	    vaihecounter = 1;
	    taustakuva = alkutausta;
	    soita_musa = 2;
	    vaihecounter2 = 0;
	  }
	}

	else if(ohjelmantila == ALKURUUTU or ohjelmantila == TAKAISIN_ALKURUUTUUN) {
	  
	  if(ohjelmantila == TAKAISIN_ALKURUUTUUN) {
	    for(int i = 0; i != 3; i++) deaktivoidut_laatikot[i] = false;
	    ohjelmantila = ALKURUUTU;
	    pelinvaihe = EI_PELISSA;
	    vaihecounter = 1;
	    vaihecounter2 = 0;
	    taustakuva = alkutausta;
	    nollaa_kysymys();
	    soita_musa = 2;
	  }
	  
	  int y;
	  if(vaihecounter < 280) {
	    y = RUUDUNKORKEUS+200 - vaihecounter;
	  }
	  else y = 401;
	  alusta.renderfunktio(80, y);
	  alusta.renderfunktio(450, y);

	  if(vaihecounter < 280) tekstilogo.renderfunktio(220, -160+vaihecounter*0.6);
	  else tekstilogo.renderfunktio(220, 7);
	  
	  if(vaihecounter > 290) {
	    if(vaihecounter < 340) {
	      SDL_Rect peiterect = {224, 174, 0+(vaihecounter-290)*6, 22};
	      SDL_RenderSetClipRect(piirturi, &peiterect);
	      aarteks.renderfunktio(224, 174);

	      SDL_RenderSetClipRect(piirturi, NULL);
	    }
	    else {
	      aarteks.renderfunktio(224, 174);
	    }
	  }

	  if((vaihecounter >= 400 and vaihecounter >  450) or
	     (vaihecounter >= 400 and vaihecounter <= 405) or
	     (vaihecounter >= 410 and vaihecounter <= 415) or
	     (vaihecounter >= 420 and vaihecounter <= 425) or
	     (vaihecounter >= 430 and vaihecounter <= 435) or
	     (vaihecounter >= 440 and vaihecounter <= 445)) {
	    SDL_RenderCopy(piirturi, painateksti, NULL, &painarect);
	    SDL_RenderCopy(piirturi, entteriateksti, NULL, &entteriarect);
	  }

	  if(vaihecounter % 2 == 0) adolan.x++;
	  if(adolan.x == 6) adolan.x = 0;
	  if(adolan.x == 0) adolan.frame = 0;
	  if(adolan.x == 1) adolan.frame = 1;
	  if(adolan.x == 2) adolan.frame = 2;
	  if(adolan.x == 3) adolan.frame = 3;
	  if(adolan.x == 4) adolan.frame = 2;
	  if(adolan.x == 5) adolan.frame = 1;
	  aspurdo.x++;
	  if(aspurdo.x == 80) aspurdo.x = 0;
	  if(aspurdo.x <= 1) aspurdo.frame = 0;
	  else if(aspurdo.x == 2) aspurdo.frame = 1;
	  else if(aspurdo.x <= 4) aspurdo.frame = 2;
	  else if(aspurdo.x == 5) aspurdo.frame = 3;
	  else if(aspurdo.x <= 7) aspurdo.frame = 4;
	  else if(aspurdo.x == 8) aspurdo.frame = 5;
	  else if(aspurdo.x <= 10) aspurdo.frame = 6;
	  else if(aspurdo.x == 11) aspurdo.frame = 7;
	  else if(aspurdo.x <= 13) aspurdo.frame = 8;
	  else if(aspurdo.x == 12) aspurdo.frame = 9;
	  else if(aspurdo.x <= 14) aspurdo.frame = 10;
	  else if(aspurdo.x == 15) aspurdo.frame = 11;
	  else if(aspurdo.x <= 17) aspurdo.frame = 12;
	  else if(aspurdo.x <= 50) aspurdo.frame = 13;
	  else if(aspurdo.x == 51) aspurdo.frame = 11;
	  else if(aspurdo.x == 52) aspurdo.frame = 10;
	  else if(aspurdo.x == 53) aspurdo.frame = 8;
	  else if(aspurdo.x == 54) aspurdo.frame = 6;
	  else if(aspurdo.x == 55) aspurdo.frame = 5;
	  else if(aspurdo.x == 56) aspurdo.frame = 4;
	  else if(aspurdo.x == 57) aspurdo.frame = 3;
	  else if(aspurdo.x == 58) aspurdo.frame = 1;
	  else aspurdo.frame = 0;
	  
	  piirtorect = *(aspurdo.hahmorect + aspurdo.frame);
	  aspurdo.spritet->renderfunktio(100, y-196, &piirtorect);
	  piirtorect = *(adolan.hahmorect + adolan.frame);
	  adolan.spritet->renderfunktio(446, y-170, &piirtorect);
	  if(katkaisu) {
	    ohjelmantila = VALINTARUUTU;
	    soita_musa = 0;
	    skrolli.first = 0;
	    skrolli.second = 0;
	  }
	}

	else if(ohjelmantila == VALINTARUUTU) {

	  skrolli.first++;
	  skrolli.second++;
	  for(int i = -1; i != 7; i++) {
	    for(int j = -1; j != 7; j++) {
	      valintatausta.renderfunktio(j*400-skrolli.first/3, i*133-skrolli.second/3);
	    }
	  }
	  if(skrolli.first == 1200) skrolli.first = 0;
	  if(skrolli.second == 399) skrolli.second = 0;

	  
	  if(vaihecounter2 < 3) {
	    valintaruutu3.renderfunktio(0, 0, NULL, 0);
	    if(valinta == '1') {
	      led.renderfunktio(334, 132, NULL, 0);
	    }
	    else if(valinta == '2') {
	      led.renderfunktio(334, 255, NULL, 0);
	    }
	  }
	  if(vaihecounter2 == 0) {
	    tekstirend(132, 70, 0, "Validse bainamalla 1 dai 2 ja endder", fontti2);
	    if(katkaisu) {
	      if(valinta == '1' or valinta == '2') {
		if(valinta == '1') kaksinpeli = false;
		else if(valinta == '2') kaksinpeli = true;
		vaihecounter2 = 1;
		katkaisu = false;
		valinta = '0';
	      }
	      katkaisu = false;
	    }
	  }
	  else {
	    if(vaihecounter2 == 1) {
	      if(!kaksinpeli) {
		tekstirend(120, 70, 0, "Girjoida belaajan nimi ja baina endder", fontti2);
	      }
	      else {
		tekstirend(100, 70, 0, "Girjoida belaajan 1 nimi ja baina endder", fontti2);
	      }
	      if(pelaaja1.length() > 16) pelaaja1.erase(pelaaja1.length()-1, 1);
	      tekstirend(75, 427, 0, pelaaja1 + "_", fontti);
	      if(katkaisu) {
		if(pelaaja1 != "") {
		  if(kaksinpeli) vaihecounter2 = 2;
		  else vaihecounter2 = 4;
		  soita_aani = 2;
		}
		katkaisu = false;
	      }
	    }
	    else if(vaihecounter2 == 2) {
	      tekstirend(100, 70, 0, "Girjoida belaajan 2 nimi ja baina endder", fontti);
	      if(pelaaja2.length() > 16) pelaaja2.erase(pelaaja2.length()-1, 1);
	      tekstirend(75, 427, 0, pelaaja2 + "_", fontti);
	      if(katkaisu) {
		if(pelaaja2 != "") {
		  vaihecounter2 = 4;
		  soita_aani = 2;
		}
		katkaisu = false;
	      }
	    }
	    if(vaihecounter2 >= 4) {
	      valintaruutu4.renderfunktio(0, 0, NULL, 0);
	      tekstirend(72, 86, 0, "Validse gysymygset bainamalla 1-4 ja endder.", fontti2);

	      if(deaktivoidut_laatikot[0] == true) deaktivointi(0);
	      if(deaktivoidut_laatikot[1] == true) deaktivointi(1);
	      if(deaktivoidut_laatikot[2] == true) deaktivointi(2);

	      if(valinta == '1') {
		led.renderfunktio(74, 179, NULL, 0);
	      }
	      else if(valinta == '2') {
		led.renderfunktio(337, 179, NULL, 0);
	      }
	      else if(valinta == '3') {
		led.renderfunktio(74, 302, NULL, 0);
	      }
	      else if(valinta == '4') {
		led.renderfunktio(337, 302, NULL, 0);
	      }
	      if(katkaisu and vaihecounter2 == 4) {
		if(valinta == '1' and deaktivoidut_laatikot[0] == false) {
		  kysymysvec = autowrap(RIVINPITUUS, "Aihepiirin topologia kysymykset saadaankin mukaan vasta Spurdo 2100 -lislevykkeell. Sori siit.");
		  vaihecounter2 = 5;
		  vaihecounter = 1;
		}
		else if(valinta == '2' and deaktivoidut_laatikot[1] == false) {
		  kysymysvec = autowrap(RIVINPITUUS, "Jkltuntemuksen kysymysten laatimisesta vastaava opiskelukaverimme lhti pari viikkoa sitten Patvinsuon kansallispuistoon eik hnest ole kuulunut sen jlkeen mitn. Palaamme asiaan, kun hnet saadaan tavoitettua.");
		  vaihecounter2 = 5;
		  vaihecounter = 1;
		}
		else if(valinta == '3' and deaktivoidut_laatikot[2] == false) {
		  kysymysvec = autowrap(RIVINPITUUS, "Semiotiikkaa koskevien kysymysten suhteen on yh epselv, mihin ne varsinaisesti viittaavat. Niiden sislt on selvsti intentionaalinen, mutta niiden referentti ja intepretantti odottavat viel emergoitumistaan.");
		  vaihecounter2 = 5;
		  vaihecounter = 1;
		}
		katkaisu = false;
		if(valinta == '4') {
		  vaihecounter2 = 7;
		  vaihecounter = 1;
		  valinta = '0';
		  soita_aani = 7; 
		}
	      }
	      if(vaihecounter2 == 5) {
		kys_rendattu = kysymysrendaus();
		if(kys_rendattu) {
		  vaihecounter = 10000;
		  vaihecounter2 = 6;
		  katkaisu = false;
		}
	      }
	      else if(vaihecounter2 == 6) {
		kysymysrendaus();
		if(katkaisu) {
		  vaihecounter = 0;
		  vaihecounter2 = 4;
		  if(valinta == '1') deaktivoidut_laatikot[0] = true;
		  else if(valinta == '2') deaktivoidut_laatikot[1] = true;
		  else if(valinta == '3') deaktivoidut_laatikot[2] = true;
		  valinta = '0';
		  kys_rendattu = false;
		  katkaisu = false;
		}
	      }
	      else if(vaihecounter2 == 7) {
		if(vaihecounter <= 5 or
		   (vaihecounter >= 10 and vaihecounter <= 12) or
		   (vaihecounter >= 16 and vaihecounter <= 18) or
		   (vaihecounter >= 22 and vaihecounter <= 24) or
		   (vaihecounter >= 28 and vaihecounter <= 30) or
		   (vaihecounter >= 34 and vaihecounter <= 36)) led.renderfunktio(337, 302, NULL, 0);
		if(vaihecounter == 40) {
		  ohjelmantila = SIIRRYTAAN_PELIIN;
		  vaihecounter = 0;
		  vaihecounter2 = 0;
		}
	      }
	    }
	  }
	}
	
	else if(ohjelmantila == HISCORE) {
	  if(alpha == 255) alpha = ALPHA_POHJA;
	  skrolli.first++;
	  skrolli.second++;
	  for(int i = -1; i != 7; i++) {
	    for(int j = -1; j != 7; j++) {
	      valintatausta.renderfunktio(j*400-skrolli.first/3, i*133-skrolli.second/3);
	    }
	  }
	  if(skrolli.first == 1200) skrolli.first = 0;
	  if(skrolli.second == 399) skrolli.second = 0;

	  hiscokuva.renderfunktio(0, 0);

	  tekstirend(230, 112, 0, "********************", fontti);
	  tekstirend(230, 124, 0, "* Korkeapistetaulu *", fontti);
	  tekstirend(230, 140, 0, "********************", fontti);
	  
	  int rowcounter = 0;
	  for(vector<histruct>::iterator hi_iter = hiscolist.begin(); hi_iter != hiscolist.end(); ++hi_iter) {
	    string pisteet2 = to_string(hi_iter->pisteet);
	    int pituus = 33-hi_iter->nimi.length();
	    string pisteet3 = "";
	    for(int i = 0; i != pituus; i++) pisteet3 += ".";
	    for(;;) {
	      if(pisteet2.length() < 16) pisteet2 = "." + pisteet2;
	      else break;
	    }
	    tekstirend(110, 172, rowcounter, hi_iter->nimi, fontti);
	    tekstirend(110+MERKINPITUUS*hi_iter->nimi.length(), 172, rowcounter, pisteet3, fontti);
	    tekstirend(406, 172, rowcounter, pisteet2, fontti);
	    rowcounter++;
	  }
	  tekstirend(200, RUUDUNKORKEUS-46, 0, "Baina [a]lguruudu dai [l]obeda", fontti);
	  SDL_RenderPresent(piirturi);
	}

	if(ohjelmantila == SIIRRYTAAN_PELIIN) {

	  if(vaihecounter == 0) {

	    heilutus = 0;
	    naps.frame = 0;
	    vipu.frame = 0;
	    valinta = '0';
	    vaihtoehto1 = "";
	    vaihtoehto2 = "";
	    vaihtoehto3 = "";
	    vaihtoehto4 = "";
	    for(int i = 0; i != 5; i++) paikat[i] = 'v';
	    kystekstix = 44;
	    kystekstiy = 110;
	    kumpi = 's';
	    kirjainkountteri = 0;
	    ilmeet = true;
	    katkaisu = false;
	    p1_pisteet = 0;
	    p2_pisteet = 0;
	    p1_oikeinlaskuri = 0;
	    p2_oikeinlaskuri = 0;
	    for(int i = 0; i != 10; i++) {
	      p1_vastaukset[i] = 't';
	      p2_vastaukset[i] = 't';
	    }
	    if(kysytyt.size() > 150) kysytyt.clear();
	    tulos = 0;
	    dolan_frame = 0;
	    dolaneyes = 0;
	    sblinkcount = 0;
	    dblinkcount = 0;
	    spurdo.frame = 0;
	    gooby.frame = 0;
	    kyy_frame = 0;
	    nyrkki = 0;
	    dolan_x = 330;
	    spurdo.y = 281;
	    gooby.y = 241;
	    spurdo.x = 20;
	    gooby.x = 20;
	    dolan_xoffset.first = 0;
	    dolan_xoffset.second = 1;
	    heilutus = 0;
	    kysymysvec.clear();
	    vastvec1.clear();
	    vastvec2.clear();
	    vastvec3.clear();
	    vastvec4.clear();
	    selitysvec.clear();
	    kokvec.clear();
	    kokvec2.clear();
	    kysymyskountteri = 1;
	    rip_anim = TYHJA;
	    SDL_SetTextureColorMod(spurdoteks.tekstuuri, 255, 255, 255);
	    SDL_SetTextureColorMod(goobyteks.tekstuuri, 255, 255, 255);

	    pelaaja1_s = TTF_RenderText_Solid(fontti, pelaaja1.c_str(), tekstivari);
	    pelaaja1_l = pelaaja1_s->w;
	    pelaaja1_t = SDL_CreateTextureFromSurface(piirturi, pelaaja1_s);
	    SDL_FreeSurface(pelaaja1_s);
	    pelaaja1_n = {20+(MERKINPITUUS*(25-static_cast<int>(pelaaja1.length()))/2), 10, pelaaja1_l, MERKINKORKEUS};
	    if(kaksinpeli) {
	      pelaaja2_s = TTF_RenderText_Solid(fontti, pelaaja2.c_str(), tekstivari);
	      pelaaja2_l = pelaaja2_s->w;
	      pelaaja2_t = SDL_CreateTextureFromSurface(piirturi, pelaaja2_s);
	      SDL_FreeSurface(pelaaja2_s);
	      pelaaja2_n = {20+(MERKINPITUUS*(25-static_cast<int>(pelaaja2.length()))/2), RUUDUNKORKEUS-36-MERKINKORKEUS, pelaaja2_l, MERKINKORKEUS};
	    }
	    taustakuva = pimee;
	  }
	  if(vaihecounter == 0) vaihecounter = 1;
	  else if(vaihecounter == 20) {
	    taustakuva = kysymystausta;
	    ohjelmantila = PELI;
	    pelinvaihe = PELI_ALKAA;
	    vaihecounter = 1;
	    vaihecounter2 = 0;
	    katkaisu = false;
	    soita_aani = 8;

	    if(!kaksinpeli) kysymysvec = autowrap(RIVINPITUUS, "Spurdo 2000 -kamppailu alkaa! Ota rennosti. Mikli vastaat vrin, sinun ei tarvitse krsi kauaa.");
	    else kysymysvec = autowrap(RIVINPITUUS, "Spurdo 2000 -kamppailu alkaa! Muistakaa, ett vain voittaja poistuu studiosta omin jaloin.");
	  }
	}

	
	else if(ohjelmantila == PELI) {
	  if(pelinvaihe == PELI_ALKAA) {
	    if(vaihecounter > 30 and vaihecounter2 == 0) {
	      vaihecounter = 1;
	      vaihecounter2 = 1;
	    }
	    if(vaihecounter2 == 1 or vaihecounter2 == 2) {
	      laatikon_piirto(6+selitysvec.size());
	      kys_rendattu = kysymysrendaus();
	      if(kys_rendattu and vaihecounter2 != 2) {
		vaihecounter = 10000;
		katkaisu = false;
		vaihecounter2 = 2;
	      }
	      if(katkaisu and vaihecounter2 == 2) {
		vaihecounter = 1;
		vaihecounter2 = 3;
	      }
	    }
	    if(vaihecounter2 == 3) {
	      if(vaihecounter > 20) {
		pelinvaihe = SEURAAVA_KYSYMYS;
		soita_aani = 5;
		katkaisu = false;
		vaihecounter = 0;
		vaihecounter2 = 0;
	      }
	    }
	  }

	  piirtorect = *(vipu.hahmorect + vipu.frame);
	  vipu.spritet->renderfunktio(RUUDUNLEVEYS-131, RUUDUNKORKEUS-64-60, &piirtorect);
	  
	  if(pelinvaihe == VOITTO) {
	    if(vaihecounter == 2) soita_musa = 4;
	  
	    laatikon_piirto(6);
	    int leveys;
	    if(vaihecounter2 < 6 or vaihecounter > 80) {
	      SDL_QueryTexture(voittoteksti, NULL, NULL, &leveys, NULL);
	      SDL_Rect voittonelio = {kystekstix+90, kystekstiy+6, leveys+50, MERKINKORKEUS+10};
	      SDL_RenderCopy(piirturi, voittoteksti, NULL, &voittonelio);
	    }
	    if(kaksinpeli) {
	      if(kumpi == 's') tekstirend(kystekstix+120, 106, 0, "Pelaaja 1", fontti);
	      else tekstirend(kystekstix+120, 106, 0, "Pelaaja 2", fontti);
	    }


	    if(kumpi == 's') {
	      if(vaihecounter >= 14) {
		if(vaihecounter2 >= 0 and vaihecounter2 <= 2) spurdo.frame = 12;
		else if(vaihecounter2 >= 3 and vaihecounter2 <= 5) spurdo.frame = 13;
		else if(vaihecounter2 >= 6 and vaihecounter2 <= 8) spurdo.frame = 14;
		vaihecounter2++;
		if(vaihecounter2 == 9) vaihecounter2 = 0;
	      }
	      else {
		spurdo.frame = 15;
		spurdo.frame += vaihecounter/2;
	      }
	      piirtorect = *(spurdo.hahmorect + spurdo.frame);
	      spurdo.spritet->renderfunktio(spurdo.x-32, 281, &piirtorect);
	    }
	    else {
	      if(vaihecounter >= 14 and vaihecounter <= 30) {
		if(vaihecounter >= 14 and vaihecounter <= 15) gooby.frame = 9;
		else if(vaihecounter >= 16 and vaihecounter <= 17) gooby.frame = 10;
		else if(vaihecounter >= 18 and vaihecounter <= 19) gooby.frame = 11;
		else if(vaihecounter >= 20 and vaihecounter <= 21) gooby.frame = 12;
		else if(vaihecounter >= 22 and vaihecounter <= 23) gooby.frame = 13;
		else if(vaihecounter >= 24 and vaihecounter <= 25) gooby.frame = 14;
		else if(vaihecounter >= 26 and vaihecounter <= 27) gooby.frame = 15;
		else if(vaihecounter >= 28 and vaihecounter <= 29) gooby.frame = 16;
	      }
	      else if(vaihecounter < 14) gooby.frame = 0;
	      else {
		if(vaihecounter2 == 0 or vaihecounter == 1) gooby.frame = 17;
		else if(vaihecounter2 == 2 or vaihecounter == 3) gooby.frame = 18;
		else if(vaihecounter2 == 4 or vaihecounter2 == 5) gooby.frame = 19;
		else if(vaihecounter2 == 6 or vaihecounter == 7) gooby.frame = 18;
		vaihecounter2++;
		if(vaihecounter2 == 8) vaihecounter2 = 0;
	      }
	      piirtorect = *(gooby.hahmorect + gooby.frame);
	      if(gooby.frame == 0) gooby.spritet->renderfunktio(gooby.x, gooby.y, &piirtorect);
	      else gooby.spritet->renderfunktio(gooby.x-12, gooby.y, &piirtorect);
	    }

	    if(vaihecounter > 10) {
	      kokrect = {155, koky, 22, kokh};
	      if(kokh < 230 and koky < 65) kokh += 10;
	      else if(koky < 280 and vaihecounter > 70) {
		koky += 10;
		kokh -= 10;
	      }
	      else if(kokh > 0) kokh -= 10;
	      SDL_SetRenderDrawColor(piirturi, 0xFA, 0xFA, 0xFA, 0xFF);

	      if(kokh > 0) {
		SDL_RenderFillRect(piirturi, &kokrect);
		for(int i = 0; i != 60; i++) {
		  int x = 136 + rand()%54;
		  int y = koky + rand()%kokh;
		  SDL_RenderDrawPoint(piirturi, x, y);
		}
	      }
	      if(vaihecounter > 33) {
		if(kokh > 0) {
		  for(int i = 0; i != 6; i++) {
		    kokstruct2 koks2;

		    if(kumpi == 's') {
		      koks2.x = 126 + rand()%80;
		      koks2.y = 287 + rand()%20;
		    }
		    else {
		      koks2.x = 134 + rand()%76;
		      koks2.y = 299 + rand()%20;
		    }
		    if(kumpi == 's') { 
		      if((pow(koks2.x - 166, 2)/pow(40, 2)) + (pow(koks2.y - 297, 2)/pow(10, 2)) < 1) {
			kokvec2.push_back(koks2);
		      }
		    }
		    else {
		      if((pow(koks2.x - 172, 2)/pow(40, 2)) + (pow(koks2.y - 309, 2)/pow(10, 2)) < 1) {
			kokvec2.push_back(koks2);
		      }
		    }
		  }
		}
		for(vector<kokstruct2>::iterator kokiter = kokvec2.begin(); kokiter != kokvec2.end(); ++kokiter) {
		  SDL_RenderDrawPoint(piirturi, kokiter->x, kokiter->y);
		}
	      }
	    
	    }
	    if(vaihecounter > 33) {
	      if(vaihecounter2%10 == 1 and kokh > 0) {
		kokvec.push_back(koks);
	      }
	      for(vector<kokstruct>::iterator kokiter = kokvec.begin(); kokiter != kokvec.end(); ++kokiter) {
		double y = 270.0+10+((pow((+0.2*(kokiter->kerroin)),2.15)+(-0.25*(kokiter->kerroin))-1));
		kok.renderfunktio(138+kokiter->counter*2, y);
		kok.renderfunktio(138-kokiter->counter*2, y);
		kokiter->counter += 2;
		kokiter->kerroin += 2;
		if(y > RUUDUNKORKEUS) {
		  kokvec.erase(kokiter);
		  kokiter--;
		}
	      }
	    }
	    if(vaihecounter > 200) {
	      if(kaksinpeli) {
		pelinvaihe = PELI_LOPPUI;
		spurdo.x -= 32;
		gooby.x -= 12;
	      }
	      else {
		for(vector<histruct>::iterator hi_iter = hiscolist.begin(); hi_iter != hiscolist.end(); ++hi_iter) {
		  if(p1_pisteet > hi_iter->pisteet) {
		    histruct newscore = { pelaaja1, p1_pisteet, };
		    hiscolist.insert(hi_iter, newscore);
		    hiscolist.erase(hiscolist.end()-1);
		    break;
		  }
		}
		ohjelmantila = HISCORE;
		alpha = 255;
	      }
	    }
	  }
	
	  else if(pelinvaihe == KILPAILIJAN_TAPPAMINEN) {
	    if(rip_anim == PISTOOLI) {
	      if(kumpi == 's' and ilmeet) {
		if(vaihecounter < 3 and spurdo.frame != 7) spurdo.frame = 6;
		else if(vaihecounter < 76) spurdo.frame = 7;
		else if(vaihecounter >= 76 and vaihecounter < 120)  spurdo.frame = 8;
		else {
		  spurdo.frame = 9;
		  spurdo.x -= 4;
		  spurdo.y += 12;
		}
	      }

	      int y;
	      int gunhasrisen = 74;
	      int gunrises = 60;
	      if(vaihecounter >= gunhasrisen and vaihecounter < 130) y = 315;
	      else if(vaihecounter < gunhasrisen) y = RUUDUNKORKEUS-64;
	      int gunframe = 0;
	      if(vaihecounter > gunrises) {
		if(dolaneyes == 0 and vaihecounter < 130) dolaneyes = 1;
		if(vaihecounter < gunhasrisen) {y -= (vaihecounter-40)*3;}
		else if(vaihecounter > 110 and vaihecounter <= 130) {
		  gunframe = vaihecounter-111;
		  gunframe /= 2;
		}
		if(vaihecounter == 117) soita_aani = 12;
		else if(vaihecounter > 130) {
		  y += 3;
		  if(vaihecounter > 150 and dolaneyes == 5) dolaneyes = 6;
		}
		piirtorect = *(pistooli.hahmorect + gunframe);
		pistooli.spritet->renderfunktio(dolan_x-73, y, &piirtorect);
	      }
	    }
	    if(kumpi == 'g' and rip_anim == PISTOOLI) {
	      if(vaihecounter < 20) {
		gooby.frame = 0;
		kyy_frame = -1;
	      }
	      if(vaihecounter >= 20 and vaihecounter <= 39) kyy_frame++;
	      else if(vaihecounter == 40) kyy_frame = -1;
	      else if(vaihecounter == 89) kyy_frame = 0;
	      else if(vaihecounter >= 90 and vaihecounter <= 119) kyy_frame++;
	      else if(vaihecounter > 110) kyy_frame = -1;
	      
	      if(vaihecounter > 120) {
		  gooby.frame = 7;
		  gooby.x -= 4;
		  gooby.y += 12;
	      }
	    }

	    if(rip_anim == HAPPO) {
	      if(vaihecounter == 70) dolaneyes = 1;
	      else if(vaihecounter == 150) dolaneyes = 6;

	      if(vaihecounter == 2) {
		if(kumpi == 'g') kyy_frame = -1;
		vipu.frame = 1;

	      }
	      if(vaihecounter == 26) soita_aani = 14;
	      else if(vaihecounter == 30) soita_aani = 15;
	      if(vaihecounter >= 3 and vaihecounter <= 33) {
	          if(vaihecounter % 2 == 0) vipu.frame++;
	      }
	      else if(vaihecounter >= 44 and vaihecounter <= 58) {
		if(vaihecounter % 2 == 0) vipu.frame++;
	      }
	      else if(vaihecounter == 79) {
		if(kumpi == 's') spurdo.frame = 8;
	      }
	      else if(vaihecounter >= 90 and vaihecounter <= 99) {
		if(kumpi == 's') spurdo.y += 20;
		else gooby.y += 20;
	      }
	      if(vaihecounter >= 100 and vaihecounter <= 107) {
		if(vaihecounter == 100) {
		  soita_aani = 13;
		  splash.x = 20;
		  splash.y = 480;
		  splash.frame = 0;
		}
		if(vaihecounter >= 100 and vaihecounter <= 107) {
		  splash.y -= 23;
		}
		else if(vaihecounter >= 105 and vaihecounter <= 107) {
		  splash.frame = 1;
		}
		piirtorect = *(splash.hahmorect + splash.frame);
		splash.spritet->renderfunktio(splash.x, splash.y, &piirtorect);
	      }
	    }
	  }
	  if((rip_anim == HAPPO) and kumpi == 'g') {
	    if(vaihecounter < 20) {
	      gooby.frame = 0;
	      kyy_frame = -1;
	    }
	    if(vaihecounter >= 20 and vaihecounter <= 39) kyy_frame++;
	    else if(vaihecounter == 40) kyy_frame = -1;
	  }

	  if(rip_anim == TULI) {

	    if(vaihecounter >= 3 and vaihecounter <= 35) {
	      if(vaihecounter % 2 == 0) vipu.frame++;
	    }
	    else if(vaihecounter >= 160 and vaihecounter <= 190) {
	      if(vaihecounter % 2 == 0) vipu.frame--;
	    }
	    if(vaihecounter == 2 and kumpi == 'g') kyy_frame = -1;

	    if(vaihecounter == 28) soita_aani = 14;
	    else if(vaihecounter == 40) soita_aani = 16;
	    else if(vaihecounter == 160) soita_aani = 14;

	    if(kumpi == 's') {
	      if(vaihecounter < 3 and ilmeet and spurdo.frame != 7) spurdo.frame = 6;
	      else if(vaihecounter < 26 and ilmeet) spurdo.frame = 7;
	      else if(vaihecounter == 40) {
		if(kumpi == 's') spurdo.frame = 8;
	      }
	    }

	    if(kumpi == 's') {
	      if(vaihecounter >= 49 and vaihecounter <= 68) {
		SDL_SetTextureColorMod(spurdoteks.tekstuuri, 160, 160, 160);
	      }
	      else if(vaihecounter >= 69 and vaihecounter <= 88) {
		SDL_SetTextureColorMod(spurdoteks.tekstuuri, 130, 130, 130);
	      }
	      else if(vaihecounter >= 89 and vaihecounter <= 108) {
		SDL_SetTextureColorMod(spurdoteks.tekstuuri, 100, 100, 100);
	      }
	      else if(vaihecounter >= 109 and vaihecounter <= 129) {
		SDL_SetTextureColorMod(spurdoteks.tekstuuri, 80, 80, 80);
	      }
	      else if(vaihecounter >= 130) {
		SDL_SetTextureColorMod(spurdoteks.tekstuuri, 20, 20, 20);
	      }
	    }
	    else {
	      if(vaihecounter >= 49 and vaihecounter <= 68) {
		SDL_SetTextureColorMod(goobyteks.tekstuuri, 160, 160, 160);
	      }
	      else if(vaihecounter >= 69 and vaihecounter <= 88) {
		SDL_SetTextureColorMod(goobyteks.tekstuuri, 130, 130, 130);
	      }
	      else if(vaihecounter >= 89 and vaihecounter <= 108) {
		SDL_SetTextureColorMod(goobyteks.tekstuuri, 100, 100, 100);
	      }
	      else if(vaihecounter >= 109 and vaihecounter <= 129) {
		SDL_SetTextureColorMod(goobyteks.tekstuuri, 80, 80, 80);
	      }
	      else if(vaihecounter >= 130) {
		SDL_SetTextureColorMod(goobyteks.tekstuuri, 20, 20, 20);
	      }
	    }

	    if(vaihecounter > 170) {
	      if(kumpi == 's') {
		if(vaihecounter > 179) spurdo.y += 16;
		if(vaihecounter < 176) spurdo.frame = 22;
		else if(vaihecounter < 180) spurdo.frame = 23;
		else if(vaihecounter < 184) spurdo.frame = 24;
		else if(vaihecounter < 188) spurdo.frame = 25;
		else spurdo.frame = 26;
	      }
	      else {
		if(vaihecounter > 179) gooby.y += 16;
		if(vaihecounter < 176) gooby.frame = 21;
		else if(vaihecounter < 180) gooby.frame = 22;
		else if(vaihecounter < 184) gooby.frame = 23;
		else if(vaihecounter < 188) gooby.frame = 24;
		else gooby.frame = 25;
	      }
	    }
	  }

	  else if(pelinvaihe == VAARIN) {

	    int st = 0;
	    int gt = 0;
	    bool poikkeus = false;
	    for(int i = 0; i != 10; i++) {
	      if(p1_vastaukset[i] == 't') st++;
	      if(p2_vastaukset[i] == 't') gt++;
	    }
	    if(tulos == 1 and st == gt) poikkeus = true;
	    
	    if(kumpi == 's' and ilmeet) {
	      if(vaihecounter < 3) spurdo.frame = 6;
	      else if(vaihecounter < 76) spurdo.frame = 7;
	      else if(vaihecounter >= 76 and vaihecounter < 120)  spurdo.frame = 8;
	    }
	    else {
	      if(vaihecounter >= 20 and vaihecounter <= 39) kyy_frame++;
	      else if(vaihecounter == 40) kyy_frame = -1;
	      else if(!poikkeus and vaihecounter == 89) kyy_frame = 0;
	      
	      else if(!poikkeus and vaihecounter >= 90 and vaihecounter <= 119) kyy_frame++;

	      else if(vaihecounter > 110) kyy_frame = -1;
	    }
	  }
	  
	  else if(pelinvaihe == OIKEIN) {
	    if(vaihecounter % 2 == 0) {
	      dolan_frame = oikein_anim(vaihecounter, dolan_frame);
	      if(kumpi == 's') spurdo.frame = oikein_anim_s(vaihecounter, spurdo.frame);
	      else {
		gooby.frame = oikein_anim_g(vaihecounter, gooby.frame, nyrkki);
		if(vaihecounter % 3 == 0 or vaihecounter % 2 == 0) nyrkki++;
		if(nyrkki == 4) nyrkki = 0;

	      }
	    }
	    if(vaihecounter == HEILMAX-6) heilutus = 3;
	    if(vaihecounter == HEILMAX) dolan_frame = 0;
	    if(dolan_xoffset.first) dolan_xoffset.second++;
	    else dolan_xoffset.second--;
	    if(dolan_xoffset.second == 10 or dolan_xoffset.second == -10) dolan_xoffset.first = !dolan_xoffset.first;
	  }
	  piirtorect = *(dolan.hahmorect + dolan_frame);
	  dolan.spritet->renderfunktio(dolan_x+dolan_xoffset.second, 201, &piirtorect);

	  if(dolaneyes > 0) {
	    if(dolaneyes >= 1 and dolaneyes <= 4) {
	      piirtorect = *(deyes.hahmorect + 1);
	      dolaneyes++;

	    }
	    else if(dolaneyes == 5) {
	      piirtorect = *(deyes.hahmorect + 0);
	    }
	    else if(dolaneyes >= 6 and dolaneyes <= 9) {	
	      piirtorect = *(deyes.hahmorect + 1);
	      dolaneyes++;
	    }
	    if(dolaneyes == 10) dolaneyes = 0;
	    else deyes.spritet->renderfunktio(dolan_x+121, 313, &piirtorect);
	  }

	  if(pelinvaihe != VOITTO) {
	    if(kumpi == 's') {
	      piirtorect = *(spurdo.hahmorect + spurdo.frame);
	      spurdo.spritet->renderfunktio(spurdo.x, spurdo.y, &piirtorect);
	    }
	    else {

	      piirtorect = *(gooby.hahmorect + gooby.frame);
	      gooby.spritet->renderfunktio(gooby.x, gooby.y, &piirtorect);
	    }
	  }

	  if(pelinvaihe == KYSYMYKSEN_KYSYMINEN or pelinvaihe == SEURAAVA_KYSYMYS or pelinvaihe == PELI_ALKAA) {
	    if(sblinkcount == 0) {
	      sblinkcount = 200 + rand()%15*24;
	    }
	    else sblinkcount--;
	    if(sblinkcount >= 4 and sblinkcount <= 6) {
	      if(kumpi == 's') {
		piirtorect = *(spblink.hahmorect + 0);
		spblink.spritet->renderfunktio(spurdo.x+139, spurdo.y+34, &piirtorect);
	      }
	      else gblinkteks.renderfunktio(gooby.x+150, gooby.y+66);
	    }
	    else if(sblinkcount >= 1 and sblinkcount <= 3) {
	      if(kumpi == 's') {
		piirtorect = *(spblink.hahmorect + 1);
		spblink.spritet->renderfunktio(spurdo.x+139, spurdo.y+34, &piirtorect);
	      }
	      else gblinkteks.renderfunktio(gooby.x+150, gooby.y+66);
	    }

	    if(dblinkcount == 0) {
	      dblinkcount = 200 + rand()%15*24;
	    }
	    else dblinkcount--;

	    if(dblinkcount >= 4 and dblinkcount <= 6) {
	      piirtorect = *(dolblink.hahmorect + 0);
	      dolblink.spritet->renderfunktio(dolan_x+123, 201+112, &piirtorect);
	    }
	    else if(dblinkcount >= 1 and dblinkcount <= 3) {
	      piirtorect = *(dolblink.hahmorect + 1);
	      dolblink.spritet->renderfunktio(dolan_x+123, 201+112, &piirtorect);
	    }
	  }

	  else if(pelinvaihe == LAATIKKO_ISONTUU) {
	    if(laatikko_suurenee(kysymysvec.size() + vastvec1.size() + vastvec2.size() + vastvec3.size() + vastvec4.size() + 5)) {
	      pelinvaihe = KYSYMYKSEN_RENDAUS;
	      vaihecounter = 1;
	      katkaisu = false;
	    }
	  }

	  if(pelinvaihe == PELI_LOPPUI) {
	    if(tulos == 3) t_laatikko.renderfunktio(160, 150);
	    else v_laatikko.renderfunktio(160, 150);


	    if(tulos == 3) {

	      int leveys;
	      SDL_QueryTexture(tasateksti, NULL, NULL, &leveys, NULL);
	      SDL_Rect tasanelio = {250, 160, leveys+50, MERKINKORKEUS+10};
	      SDL_RenderCopy(piirturi, tasateksti, NULL, &tasanelio);

	      int leveys2;
	      SDL_QueryTexture(enem1_teksti, NULL, NULL, &leveys2, NULL);
	      SDL_Rect enemnelio = {184, 200, leveys2, MERKINKORKEUS};
	      if(p1_pisteet > p2_pisteet) {
		SDL_RenderCopy(piirturi, enem1_teksti, NULL, &enemnelio);
	      }
	      else if(p1_pisteet != p2_pisteet) {
		SDL_RenderCopy(piirturi, enem2_teksti, NULL, &enemnelio);
	      }
	    }
	    else {
	      int leveys;
	      if(kaksinpeli) {
		if(vaihecounter2 != 444) {
		  soita_aani = 19;
		  vaihecounter2 = 444;
		}
		SDL_QueryTexture(loppuiteksti2, NULL, NULL, &leveys, NULL);
		SDL_Rect loppuinelio = {220, 155, leveys+50, MERKINKORKEUS+10};
		SDL_RenderCopy(piirturi, loppuiteksti2, NULL, &loppuinelio);
	      }
	      else {
		SDL_QueryTexture(loppuiteksti, NULL, NULL, &leveys, NULL);
		SDL_Rect loppuinelio = {220, 155, leveys+50, MERKINKORKEUS+10};
		SDL_RenderCopy(piirturi, loppuiteksti, NULL, &loppuinelio);
	      }

	      for(vector<kokstruct2>::iterator kokiter = kokvec2.begin(); kokiter != kokvec2.end(); ++kokiter) {
		SDL_RenderDrawPoint(piirturi, kokiter->x, kokiter->y);
	      }
	    }

	    int leveys;
	    SDL_QueryTexture(loppukehotus, NULL, NULL, &leveys, NULL);
	    SDL_Rect kehotusnelio = {200, (tulos == 3 ? 205+MERKINKORKEUS+10 : 195), leveys, MERKINKORKEUS};
	    SDL_RenderCopy(piirturi, loppukehotus, NULL, &kehotusnelio);

	  }
	
	  if(pelinvaihe == KYSYMYKSEN_RENDAUS or pelinvaihe == KYSYMYKSEN_KYSYMINEN) kys_rendattu = kysymysrendaus();
	  blaatikko.renderfunktio(RUUDUNLEVEYS-171, 64);
	  palkki2.renderfunktio(0, 0);
	  SDL_RenderCopy(piirturi, bonusteksti, NULL, &bonusnelio);
	  palkki.renderfunktio(0, RUUDUNKORKEUS - 64);

	  if(!kaksinpeli and p1_oikeinlaskuri > 0) {
	    for(int i = 0, x = 266; i != p1_oikeinlaskuri; i++) {
	      lehti.renderfunktio(x+2, 14);
	      x += 40;
	    }
	  }
	  else if(kaksinpeli) {
	    for(int i = 0, x = 266; i != kysymyskountteri; i++) {
	      if(p1_vastaukset[i] == 'o') lehti.renderfunktio(x+2, 14);
	      else if(p1_vastaukset[i] == 'v') tyhjalehti.renderfunktio(x+2, 14);
	      if(kumpi == 's' and i == kysymyskountteri-1 and tulos == 0) continue;
	      if(p2_vastaukset[i] == 'o') lehti.renderfunktio(x+2, RUUDUNKORKEUS-48);
	      else if(p2_vastaukset[i] == 'v') tyhjalehti.renderfunktio(x, RUUDUNKORKEUS-48);
	      x += 40;
	    }
	  }

	  if(pelinvaihe == KYSYMYKSEN_KYSYMINEN) {
	    if(sekunnit == 20) {
	      piirtorect = *(diginums.hahmorect + 2);
	      diginums.spritet->renderfunktio(614, 120, &piirtorect);
	      piirtorect = *(diginums.hahmorect + 0);
	      diginums.spritet->renderfunktio(644, 120, &piirtorect);
	    }
	    else if(sekunnit >= 10 and sekunnit <= 19) {
	      piirtorect = *(diginums.hahmorect + 1);
	      diginums.spritet->renderfunktio(614, 120, &piirtorect);
	    }
	    else if(sekunnit <= 9) {
	      piirtorect = *(diginums.hahmorect + 0);
	      diginums.spritet->renderfunktio(614, 120, &piirtorect);
	    }
	    if(sekunnit > 9) piirtorect = *(diginums.hahmorect + sekunnit-10);
	    else piirtorect = *(diginums.hahmorect + sekunnit);
	    diginums.spritet->renderfunktio(644, 120, &piirtorect);

	    if(sekunnit == -1) {
	      sekunnit = -2;
	      vaihecounter = 1;
	      soita_aani = 9;
	      if(kaksinpeli) {
		pelinvaihe = VAARIN;
		if(kumpi == 's') p1_vastaukset[kysymyskountteri-1] = 'v';
		else p2_vastaukset[kysymyskountteri-1] = 'v';
	      }
	      else {
		pelinvaihe = KILPAILIJAN_TAPPAMINEN;
		rip_anim = tappamisarvonta();
	      }
	    }
	  }

	  if(pelinvaihe == OIKEIN and (digisykli != 5 or vaihecounter < 70)) {
	    if(digisykli == 0 or digisykli == 1 or digisykli == 2) digipaalle(1, 2);
	    else if(digisykli == 3 or digisykli == 4 or digisykli == 5) digipaalle(1, 0, 0, 0, 0, 6);
	    if(vaihecounter % 5 == 0) digisykli++;
	    if(digisykli == 6) digisykli = 0;
	  }
	  else if((pelinvaihe == VAARIN or pelinvaihe == KILPAILIJAN_TAPPAMINEN) and (digisykli != 5 or vaihecounter < 50)
		  and !(kaksinpeli and pelinvaihe == KILPAILIJAN_TAPPAMINEN and kysymyskountteri == 10)
		  and !(pelinvaihe == KILPAILIJAN_TAPPAMINEN and ((kumpi == 'g' and tulos == 1) or (kumpi =='s' and tulos == 2))))
	    {
	    if(digisykli == 0 or digisykli == 1 or digisykli == 2) digipaalle(1, 2, 3, 4, 5, 6);
	    if(vaihecounter % 2 == 0) digisykli++;
	    if(digisykli == 6) digisykli = 0;
	  }
	  else if(pelinvaihe == VOITTO and (digisykli != 5 or vaihecounter < 200)) {
	    if(digisykli == 0) digipaalle(1);
	    else if(digisykli == 1) digipaalle(0, 1);
	    else if(digisykli == 2) digipaalle(0, 0, 1);
	    else if(digisykli == 3) digipaalle(0, 0, 0, 1);
	    else if(digisykli == 4) digipaalle(0, 0, 0, 0, 1);
	    else if(digisykli == 5) digipaalle(0, 0, 0, 0, 0, 1);
	    if(vaihecounter % 4 == 0) digisykli++;
	    if(digisykli == 6) digisykli = 0;
	  }


	  if(pelinvaihe == HAHMONVAIHTO) {
	    rip_anim = TYHJA;
	    if(vaihda_hahmoa(tulos)) {
	      if(tulos == 3) {
		pelinvaihe = PELI_LOPPUI;
		soita_musa = 3;
	      }
	      else if(tulos > 0) {
		if(kumpi == 's' and tulos == 1) pelinvaihe = VOITTO;
		else if(kumpi == 's' and tulos == 2) pelinvaihe = KILPAILIJAN_TAPPAMINEN;
		else if(kumpi == 'g' and tulos == 2) pelinvaihe = VOITTO;
		else if(kumpi == 'g' and tulos == 1) pelinvaihe = KILPAILIJAN_TAPPAMINEN;
		if(pelinvaihe == KILPAILIJAN_TAPPAMINEN) rip_anim = tappamisarvonta();
		else if(pelinvaihe == VOITTO) {
		    kokh = 0;
		    koky = 64;
		    kokvec.empty();
		    kokvec2.empty();
		  }
		vaihecounter = 1;
		vaihecounter2 = 0;
	      }
	      else {
		pelinvaihe = SEURAAVA_KYSYMYS;
		soita_aani = 5;
	      }
	    }
	  }

	  tekstirend(596, 92, 0, to_string(bonuskerroin), fontti);
	  tekstirend(20+(MERKINPITUUS*(25-to_string(p1_pisteet).length())/2), 48, 0, to_string(p1_pisteet), fontti);
	  if(kaksinpeli) {
	    SDL_RenderCopy(piirturi, pelaaja2_t, NULL, &pelaaja2_n);
	    tekstirend(20+(MERKINPITUUS*(25-to_string(p2_pisteet).length())/2), RUUDUNKORKEUS-16, 0, to_string(p2_pisteet), fontti);
	  }
	  else {
	    tekstirend(60, RUUDUNKORKEUS-42, 0, "Peliss mukana", fontti);
	    tekstirend(74, RUUDUNKORKEUS-16, 0, "Euroshopper", fontti);
	  }
	  SDL_RenderCopy(piirturi, pelaaja1_t, NULL, &pelaaja1_n);

	  if((pelinvaihe == VAARIN and kumpi == 'g' and vaihecounter > 19 and kyy_frame >= 0)
	     or (kumpi == 'g' and pelinvaihe == KILPAILIJAN_TAPPAMINEN and kyy_frame >= 0)) {
	    piirtorect = *(kyy.hahmorect + kyy_frame/2);
	    kyy.spritet->renderfunktio(gooby.x+159, gooby.y+78, &piirtorect);
	  }
	}

	if(pelinvaihe == KILPAILIJAN_TAPPAMINEN) {

	  if(rip_anim == KIRVES) {
	    if(dolaneyes == 0 and vaihecounter > 30 and vaihecounter < 100) dolaneyes = 1;
	    else if(vaihecounter > 120 and dolaneyes == 5) dolaneyes = 6;
	    if(vaihecounter > 30 and vaihecounter <= 60) dolan_x -= 2;
	    if(kumpi == 's' and ilmeet) {
	      if(vaihecounter < 3 and spurdo.frame != 7) spurdo.frame = 6;
	      else if(vaihecounter < 86) spurdo.frame = 7;
	      else if(vaihecounter >= 86 and vaihecounter < 106)  spurdo.frame = 8;
	      else {
		spurdo.frame = 9;
		spurdo.x -= 4;
		spurdo.y += 12;
	      }
	    }

	    int axframe = 0;
	    int axx = 186;
	    int y = RUUDUNKORKEUS-64;
	    if(vaihecounter >= 60 and vaihecounter <= 90) {
	      y -= (vaihecounter-60)*5;
	      if(y < 255) y = 255;
	    }
	    else if (vaihecounter >= 90) y = 255;

	    if(vaihecounter == 101)  axframe = 1;
	    else if(vaihecounter == 102) axframe = 2;
	    else if(vaihecounter == 103) axframe = 3;
	    else if(vaihecounter == 104) axframe = 4;
	    else if(vaihecounter == 105) axframe = 5;
	    else if(vaihecounter >= 106 and vaihecounter <= 116) {axframe = 6; y -= 15;}
	    else if(vaihecounter >= 117 and vaihecounter <= 147) {axframe = 6;
	      y += (vaihecounter-116)*3-15;
	      dolan_x += 2;
	      axx += (vaihecounter-116)*6;
	    }
	    
	    if(vaihecounter > 60 and vaihecounter <= 147) {
	      piirtorect = *(kirves.hahmorect + axframe);
	      SDL_RenderSetClipRect(piirturi, &kirrect);
	      kirves.spritet->renderfunktio(axx, y, &piirtorect);
	      SDL_RenderSetClipRect(piirturi, NULL);
	    }

	    
	  }

	  if(rip_anim == KIRVES) {
	    if(kumpi == 'g') {
	      if(vaihecounter < 50) {
		gooby.frame = 0;
		kyy_frame = -1;
	      }
	      if(vaihecounter >= 50 and vaihecounter <= 69) kyy_frame++;
	      else if(vaihecounter == 70) kyy_frame = -1;
	      else if(vaihecounter == 119) kyy_frame = 0;
	      else if(vaihecounter >= 120 and vaihecounter <= 149) kyy_frame++;
	      else if(vaihecounter > 140) kyy_frame = -1;

	      if(vaihecounter > 106) {
		gooby.frame = 7;
		gooby.x -= 4;
		gooby.y += 12;
	      }
	    }

	    if(vaihecounter == 106) soita_aani = 18;
	    
	    if(vaihecounter >= 106 and vaihecounter <= 109) {
	      if(vaihecounter == 106) piirtorect = *(hurme.hahmorect + 0);
	      else if(vaihecounter == 107) piirtorect = *(hurme.hahmorect + 1);
	      else if(vaihecounter == 108) piirtorect = *(hurme.hahmorect + 2);
	      else if(vaihecounter == 109) piirtorect = *(hurme.hahmorect + 3);
	      hurme.spritet->renderfunktio(155, 319, &piirtorect);
	    }
	  }

	  if(rip_anim == TULI and vaihecounter > 40 and vaihecounter < 170) {
	    if(vaihecounter % 2 == 0) {
	      tuli.renderfunktio(3, 344);
	      tuli.renderfunktio(39, 344);
	      tuli.renderfunktio(75, 344);
	      tuli.renderfunktio(111, 344);
	      tuli.renderfunktio(147, 344);
	      tuli.renderfunktio(183, 344);
	      tuli.renderfunktio(219, 344);
	      tuli.renderfunktio(255, 344);
	    }
	    else {
	      tuli.renderfunktio(3, 344, NULL, 1);
	      tuli.renderfunktio(39, 344, NULL, 1);
	      tuli.renderfunktio(75, 344, NULL, 1);
	      tuli.renderfunktio(111, 344, NULL, 1);
	      tuli.renderfunktio(147, 344, NULL, 1);
	      tuli.renderfunktio(183, 344, NULL, 1);
	      tuli.renderfunktio(219, 344, NULL, 1);
	      tuli.renderfunktio(255, 344, NULL, 1);
	    }
	  }

	  if(rip_anim == HAPPO and vaihecounter >= 108) {

	    if(vaihecounter >= 108 and vaihecounter <= 110) {
	      splash.frame = 2;
	    }
	    else if(vaihecounter >= 111 and vaihecounter <= 113) {
	      splash.frame = 3;
	    }
	    else if(vaihecounter >= 114 and vaihecounter <= 116) {
	      splash.frame = 4;
	    }
	    else if(vaihecounter >= 117 and vaihecounter <= 119) {
	      splash.y += 5;
	    }
	    else if(vaihecounter == 120) {
	      splash.y += 76;
	      splash.frame = 5;
	    }
	    else if(vaihecounter == 123) {
	      splash.frame = 6;
	    }
	    else if(vaihecounter >= 125 and vaihecounter <= 136) {
	      splash.y += 12;
	    }

	    piirtorect = *(splash.hahmorect + splash.frame);
	    splash.spritet->renderfunktio(splash.x, splash.y, &piirtorect);
	  }
	
	  else if(rip_anim == PUMPPU) {
	    if(kumpi == 's' and ilmeet) {
	      if(vaihecounter < 3 and spurdo.frame != 7) spurdo.frame = 6;
	      else if(vaihecounter < 76 ) spurdo.frame = 7;
	      else if(vaihecounter >= 76 and vaihecounter < 120)  spurdo.frame = 8;
	      else {
		spurdo.frame = 9;
		spurdo.x -= 4;
		spurdo.y += 12;
	      }
	    }
 
	    int y;
	    int gunhasrisen = 74;
	    int gunrises = 24;

	    if(vaihecounter == 117) soita_aani = 11;
	    if(vaihecounter >= gunhasrisen and vaihecounter < 160) y = 315;
	    else if(vaihecounter < gunhasrisen) y = RUUDUNKORKEUS-64;
	    int gunframe = 0;
	    if(vaihecounter > gunrises) {
	      if(dolaneyes == 0 and vaihecounter < 130) dolaneyes = 1;
	      if(vaihecounter < gunhasrisen) {y -= (vaihecounter-40)*3;}
	      else if(vaihecounter > 110 and vaihecounter <= 136) {

		gunframe = vaihecounter-111;

		gunframe /= 2;

	      }
	      else if(vaihecounter >= 137 and vaihecounter <= 138) gunframe = 11;
	      else if(vaihecounter >= 139 and vaihecounter <= 140) gunframe = 10;
	      else if(vaihecounter > 140) {
		gunframe = 0;
		if(vaihecounter > 150 and dolaneyes == 5) dolaneyes = 6;
	      }
	      y += 12;
	      SDL_RenderSetClipRect(piirturi, &pumppurect);
	      piirtorect = *(pumppu.hahmorect + gunframe);
	      pumppu.spritet->renderfunktio(dolan_x, y, &piirtorect);
	      SDL_RenderSetClipRect(piirturi, NULL);
	    }
	  }
	  if(kumpi == 'g' and rip_anim == PUMPPU) {
	    if(vaihecounter < 20) {
	      gooby.frame = 0;
	      kyy_frame = -1;
	    }
	    if(vaihecounter >= 20 and vaihecounter <= 39) kyy_frame++;
	    else if(vaihecounter == 40) kyy_frame = -1;
	    else if(vaihecounter == 89) kyy_frame = 0;
	    else if(vaihecounter >= 90 and vaihecounter <= 119) kyy_frame++;
	    else if(vaihecounter > 110) kyy_frame = -1;

	    if(vaihecounter > 120) {
	      gooby.frame = 7;
	      gooby.x -= 4;
	      gooby.y += 12;
	    }
	  }

	  if(rip_anim == PISTOOLI or rip_anim == PUMPPU) {

	    if(kumpi == 'g' and rip_anim == PISTOOLI) {
	      if((vaihecounter == 117 or vaihecounter == 118) and kumpi == 'g') {
		piirtorect = *(pistooli.hahmorect + 3);
		SDL_Rect peiterect2 = { dolan_x-73, 315, 40, 70 };
		SDL_RenderSetClipRect(piirturi, &peiterect2);
		pistooli.spritet->renderfunktio(dolan_x-73, 315, &piirtorect);
		SDL_RenderSetClipRect(piirturi, NULL);
	      }
	    }
	    
	    if(vaihecounter >= 121 and vaihecounter <= 129) {
	      int x = 127;
	      int y = 358+(vaihecounter-121)*6;
	      if(kumpi == 's') {
		if(rip_anim == PISTOOLI) y += 26;
		else y -= 20;
		x += 30;
	      }
	      if(vaihecounter <= 122) piirtorect = *(hurme2.hahmorect + 0);
	      else if(vaihecounter <= 123) piirtorect = *(hurme2.hahmorect + 1);
	      else if(vaihecounter <= 124) piirtorect = *(hurme2.hahmorect + 2);
	      else if(vaihecounter <= 125) piirtorect = *(hurme2.hahmorect + 3);
	      else if(vaihecounter <= 126) piirtorect = *(hurme2.hahmorect + 4);
	      else if(vaihecounter <= 127) piirtorect = *(hurme2.hahmorect + 5);
	      else if(vaihecounter <= 128) piirtorect = *(hurme2.hahmorect + 6);
	      else if(vaihecounter <= 129) piirtorect = *(hurme2.hahmorect + 7);

	      if(rip_anim == PISTOOLI) piirtorect.w = piirtorect.w*3;
	      hurme2.spritet->renderfunktio(x, 362+(vaihecounter-123)*7, &piirtorect);
	      if(rip_anim == PUMPPU) {
		hurme2.spritet->renderfunktio(x-15, y-14, &piirtorect);
		piirtorect.w = piirtorect.w*2;
		hurme2.spritet->renderfunktio(x-10, y+14, &piirtorect);
	      }
	    }
	  }
	}

	if(fullscreen and ohjelmantila == PELI and !(rip_anim == HAPPO and (vaihecounter >= 105 and vaihecounter <= 125))) {
	  SDL_SetRenderDrawColor(piirturi, 0x0, 0x0, 0x0, 0xFF);
	  SDL_RenderDrawLine(piirturi, 0, RUUDUNKORKEUS-65, RUUDUNLEVEYS, RUUDUNKORKEUS-65);
	}
	
	SDL_RenderPresent(piirturi);
	         
	if(vaihecounter > 0) {
	    if(pelinvaihe == LAATIKKO_ISONTUU) vaihecounter += 8;
	    else if(pelinvaihe == KYSYMYKSEN_KYSYMINEN) ;
	    else vaihecounter++;
	    if(pelinvaihe == KYSYMYKSEN_RENDAUS and (vaihecounter % 3 == 0 or vaihecounter % 2 == 0)) vaihecounter++;
	    if(vaihecounter > 1000000) vaihecounter = 10000;
	  }

	if(quit) sammutus();

	if(sekunnit > -1) {
	  ajastin2 = (SDL_GetTicks() - ajastin1);
	  if(ajastin2 < 40) {
	    SDL_Delay(40 - ajastin2);
	    sekkounter += 40-ajastin2;
	  }
	  else sekkounter += ajastin2;

	  if(sekkounter >= 1000) {
	    sekunnit--;
	    if(sekunnit == 0) soita_aani = 17;
	    else if(sekunnit > 0) soita_aani = 6;
	    sekkounter -= 1000;
	  }
	}
	else {
	  ajastin2 = (SDL_GetTicks() - ajastin1);
	  if(ajastin2 < 40) SDL_Delay(40 - ajastin2);
	}
      }
    }
  }
  sammutus();
  return 0;
}
