/*
 * Decompiled with CFR 0.152.
 */
package processing.sound;

import com.jsyn.data.FloatSample;
import com.jsyn.data.SequentialData;
import com.jsyn.unitgen.FixedRateMonoWriter;
import com.softsynth.math.FourierMath;
import java.util.Arrays;

class JSynFFT
extends FixedRateMonoWriter {
    private FloatSample buffer;
    private double[] real;
    private double[] imaginary;
    private double[] magnitude;

    protected JSynFFT(int n) {
        this.buffer = new FloatSample(n);
        this.real = new double[n];
        this.imaginary = new double[n];
        this.magnitude = new double[n / 2];
        this.dataQueue.queueLoop((SequentialData)this.buffer);
    }

    protected void calculateMagnitudes(float[] fArray) {
        int n;
        int n2 = (int)this.dataQueue.getFrameCount() % this.buffer.getNumFrames();
        for (n = 0; n < this.buffer.getNumFrames(); ++n) {
            this.real[n] = this.buffer.readDouble((n2 + n) % this.buffer.getNumFrames());
        }
        Arrays.fill(this.imaginary, 0.0);
        FourierMath.fft((int)this.real.length, (double[])this.real, (double[])this.imaginary);
        FourierMath.calculateMagnitudes((double[])this.real, (double[])this.imaginary, (double[])this.magnitude);
        for (n = 0; n < fArray.length; ++n) {
            fArray[n] = (float)(2.0 * this.magnitude[n]);
        }
    }
}

