/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.util;

public class NumericOutput {
    static char digitToChar(int n) {
        if (n > 9) {
            return (char)(65 + n - 10);
        }
        return (char)(48 + n);
    }

    public static String integerToString(int n, int n2, boolean bl) {
        return NumericOutput.integerToString(n, n2, bl, 10);
    }

    public static String integerToString(int n, int n2) {
        return NumericOutput.integerToString(n, n2, false, 10);
    }

    public static String integerToString(int n, int n2, boolean bl, int n3) {
        int n4;
        if (n2 > 32) {
            n2 = 32;
        }
        StringBuffer stringBuffer = new StringBuffer();
        long l = n;
        boolean bl2 = false;
        if (n3 != 10) {
            l &= 0xFFFFFFFFL;
        } else if (l < 0L) {
            bl2 = true;
            l = -l;
        }
        if (l == 0L) {
            stringBuffer.append('0');
        } else {
            while (l > 0L) {
                n4 = (int)(l % (long)n3);
                stringBuffer.append(NumericOutput.digitToChar(n4));
                l /= (long)n3;
            }
        }
        if (bl) {
            n4 = n2;
            if (bl2) {
                --n4;
            }
            for (int i = stringBuffer.length(); i < n4; ++i) {
                stringBuffer.append('0');
            }
        }
        if (bl2) {
            stringBuffer.append('-');
        }
        for (n4 = stringBuffer.length(); n4 < n2; ++n4) {
            stringBuffer.append(' ');
        }
        stringBuffer.reverse();
        return stringBuffer.toString();
    }

    public static String doubleToString(double d, int n, int n2) {
        return NumericOutput.doubleToString(d, n, n2, false);
    }

    public static String doubleToString(double d, int n, int n2, boolean bl) {
        if (n > 32) {
            n = 32;
        }
        if (n2 > 16) {
            n2 = 16;
        }
        boolean bl2 = false;
        if (d < 0.0) {
            bl2 = true;
            d = -d;
        }
        int n3 = (int)Math.floor(d += 0.5 * Math.pow(10.0, 0 - n2));
        int n4 = (int)((d - Math.floor(d)) * Math.pow(10.0, n2));
        String string = "";
        string = string + NumericOutput.integerToString(n3, 0, false, 10);
        string = string + ".";
        string = string + NumericOutput.integerToString(n4, n2, true, 10);
        if (bl) {
            int n5 = n;
            if (bl2) {
                --n5;
            }
            while (string.length() < n5) {
                string = "0" + string;
            }
            if (bl2) {
                string = "-" + string;
            }
        } else {
            if (bl2) {
                string = "-" + string;
            }
            while (string.length() < n) {
                string = " " + string;
            }
        }
        return string;
    }

    static void testInteger(int n) {
        System.out.println("Test " + n + ", 0x" + Integer.toHexString(n) + ", %" + Integer.toBinaryString(n));
        System.out.println("  +,8,t,10 = " + NumericOutput.integerToString(n, 8, true, 10));
        System.out.println("  +,8,f,10 = " + NumericOutput.integerToString(n, 8, false, 10));
        System.out.println("  -,8,t,10 = " + NumericOutput.integerToString(-n, 8, true, 10));
        System.out.println("  -,8,f,10 = " + NumericOutput.integerToString(-n, 8, false, 10));
        System.out.println("  +,8,t,16 = " + NumericOutput.integerToString(n, 8, true, 16));
        System.out.println("  +,8,f,16 = " + NumericOutput.integerToString(n, 8, false, 16));
        System.out.println("  -,8,t,16 = " + NumericOutput.integerToString(-n, 8, true, 16));
        System.out.println("  -,8,f,16 = " + NumericOutput.integerToString(-n, 8, false, 16));
        System.out.println("  +,8,t, 2 = " + NumericOutput.integerToString(n, 8, true, 2));
        System.out.println("  +,8,f, 2 = " + NumericOutput.integerToString(n, 8, false, 2));
    }

    static void testDouble(double d) {
        System.out.println("Test " + d);
        System.out.println("  +,5,1 = " + NumericOutput.doubleToString(d, 5, 1));
        System.out.println("  -,5,1 = " + NumericOutput.doubleToString(-d, 5, 1));
        System.out.println("  +,14,3 = " + NumericOutput.doubleToString(d, 14, 3));
        System.out.println("  -,14,3 = " + NumericOutput.doubleToString(-d, 14, 3));
        System.out.println("  +,6,2,true = " + NumericOutput.doubleToString(d, 6, 2, true));
        System.out.println("  -,6,2,true = " + NumericOutput.doubleToString(-d, 6, 2, true));
    }

    public static void main(String[] stringArray) {
        System.out.println("Test NumericOutput");
        NumericOutput.testInteger(0);
        NumericOutput.testInteger(1);
        NumericOutput.testInteger(16);
        NumericOutput.testInteger(23456);
        NumericOutput.testInteger(144470);
        NumericOutput.testInteger(563900);
        NumericOutput.testDouble(0.0);
        NumericOutput.testDouble(0.0678);
        NumericOutput.testDouble(0.1234567);
        NumericOutput.testDouble(1.234567);
        NumericOutput.testDouble(12.34567);
        NumericOutput.testDouble(123.4567);
        NumericOutput.testDouble(1234.5678);
    }
}

