/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.io;

import com.jsyn.io.AudioInputStream;
import com.jsyn.io.AudioOutputStream;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class AudioFifo
implements AudioInputStream,
AudioOutputStream {
    private volatile int readIndex;
    private volatile int writeIndex;
    private volatile double[] buffer;
    private int accessMask;
    private int sizeMask;
    private boolean writeWaitEnabled = true;
    private boolean readWaitEnabled = true;
    final Lock lock = new ReentrantLock();
    final Condition notFull = this.lock.newCondition();
    final Condition notEmpty = this.lock.newCondition();

    public void allocate(int n) {
        if (!AudioFifo.isPowerOfTwo(n)) {
            throw new IllegalArgumentException("Size must be a power of two.");
        }
        this.buffer = new double[n];
        this.accessMask = n - 1;
        this.sizeMask = n * 2 - 1;
    }

    public int size() {
        return this.buffer.length;
    }

    public static boolean isPowerOfTwo(int n) {
        return (n & n - 1) == 0;
    }

    @Override
    public int available() {
        return this.writeIndex - this.readIndex & this.sizeMask;
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double read() {
        double d = Double.NaN;
        if (this.readWaitEnabled) {
            this.lock.lock();
            try {
                while (this.available() < 1) {
                    try {
                        this.notEmpty.await();
                    }
                    catch (InterruptedException interruptedException) {
                        double d2 = Double.NaN;
                        this.lock.unlock();
                        return d2;
                    }
                }
                d = this.readOneInternal();
            }
            finally {
                this.lock.unlock();
            }
        } else if (this.readIndex != this.writeIndex) {
            d = this.readOneInternal();
        }
        if (this.writeWaitEnabled) {
            this.lock.lock();
            this.notFull.signal();
            this.lock.unlock();
        }
        return d;
    }

    private double readOneInternal() {
        double d = this.buffer[this.readIndex & this.accessMask];
        this.readIndex = this.readIndex + 1 & this.sizeMask;
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(double d) {
        if (this.writeWaitEnabled) {
            this.lock.lock();
            try {
                while (this.available() == this.buffer.length) {
                    try {
                        this.notFull.await();
                    }
                    catch (InterruptedException interruptedException) {
                        this.lock.unlock();
                        return;
                    }
                }
                this.writeOneInternal(d);
            }
            finally {
                this.lock.unlock();
            }
        } else if (this.available() != this.buffer.length) {
            this.writeOneInternal(d);
        }
        if (this.readWaitEnabled) {
            this.lock.lock();
            this.notEmpty.signal();
            this.lock.unlock();
        }
    }

    private void writeOneInternal(double d) {
        this.buffer[this.writeIndex & this.accessMask] = d;
        this.writeIndex = this.writeIndex + 1 & this.sizeMask;
    }

    @Override
    public int read(double[] dArray) {
        return this.read(dArray, 0, dArray.length);
    }

    @Override
    public int read(double[] dArray, int n, int n2) {
        if (this.readWaitEnabled) {
            for (int i = 0; i < n2; ++i) {
                dArray[i + n] = this.read();
            }
        } else if (this.available() < n2) {
            n2 = this.available();
        } else {
            for (int i = 0; i < n2; ++i) {
                dArray[i + n] = this.read();
            }
        }
        return n2;
    }

    @Override
    public void write(double[] dArray) {
        this.write(dArray, 0, dArray.length);
    }

    @Override
    public void write(double[] dArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.write(dArray[i + n]);
        }
    }

    public void setWriteWaitEnabled(boolean bl) {
        this.writeWaitEnabled = bl;
    }

    public void setReadWaitEnabled(boolean bl) {
        this.readWaitEnabled = bl;
    }

    public boolean isWriteWaitEnabled() {
        return this.writeWaitEnabled;
    }

    public boolean isReadWaitEnabled() {
        return this.readWaitEnabled;
    }
}

