#version 330 core

layout(location = 0) in vec3 vertexPosition;
layout(location = 1) in vec2 vertexTexCoord;
layout(location = 2) in vec3 vertexNormal;
layout(location = 3) in vec4 vertexColor;

out vec2 texCoord;


uniform mat4 mvp;
uniform mat4 view;
uniform mat4 model;
uniform mat4 projection;
uniform float time = 1.0f;
uniform float targettime = 10.0;
uniform vec2 seedx = vec2(0.5,0.4);
uniform vec2 seedy = vec2(0.25,0.4535);
uniform vec2 seedz = vec2(0.12,0.72);
uniform float Sync3 = 0.1;
float rand(vec2 co){
    return 0.5-fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

void main(void)
{
int vertexNumber=gl_VertexID;

   vec4 position = vec4(vertexPosition, 1.0);

	vec4 posWorld=projection * view * model * position;
	if(posWorld.x>3)
	{

	posWorld.z=11.0;
	
	gl_Position=posWorld;
	}
	else
	{
	gl_Position = projection * view * model * position;
	}
    texCoord = vertexTexCoord;
} 
