const Confusion = function () {
    PartBase.call(this);

    //POSTPROCESSING
    this.setEdgeDetection();
    this.setBloom(1.0);

    this.scene.fog = new THREE.Fog(0x5D478B, 100, 500);
    const light = new THREE.HemisphereLight(0xffccaa, 0x080820, 1);
    this.scene.add(light);
    const sky = this.createSky();
    this.scene.add(sky);

    this.maaTexture = TDEMO.TEXTURES.getTextures().maa;
    const ground = this.createHeightMap(this.maaTexture);
    this.scene.add(ground);

    [this.muodot1, this.muodot2] = this.createShapes();
    this.scene.add(this.muodot1);
    this.scene.add(this.muodot2);

    this.kaaret = this.createArches();
    this.scene.add(this.kaaret);

    this.viivat = this.createLines();
    this.scene.add(this.viivat);

    this.sprite = this.createSprite();
    this.sprite.scale.set(70, 70, 1);
    this.sprite.position.y = 20;
    this.scene.add(this.sprite);
};

Confusion.prototype = PartBase.prototype.inheritance();

const rotateObject = (obj, rot) => {
    obj.rotation.x = rot.x;
    obj.rotation.y = rot.y;
    obj.rotation.z = rot.z;
};

const translateObject = (obj, pos) => {
    obj.position.x = pos.x;
    obj.position.y = pos.y;
    obj.position.z = pos.z;
}

Confusion.prototype.animate = function (elapsedTime, delta) {
    PartBase.prototype.animate.call(this, elapsedTime, delta, true);

    const pos = TDEMO.SYNC.getObjPosition();
    const rot = TDEMO.SYNC.getObjRotation();
    const hb = TDEMO.SYNC.getHeartBeat();
    translateObject(this.muodot1, pos);
    translateObject(this.muodot2, {x: -pos.x, y: pos.y, z: pos.z});

    this.muodot1.children.forEach((muoto, index) => {
        rotateObject(muoto, rot);
        muoto.position.y = 2.0*Math.sin(hb*10.+index*10.0);
    });
    this.muodot2.children.forEach((muoto, index) => {
        rotateObject(muoto, {x:-rot.x, y:-rot.y, z:-rot.z});
        muoto.position.y = 2.0*Math.cos(hb*10.+index*10.0)
    });

    this.viivat.children.forEach((viiva, index) => {
        rotateObject(viiva, rot);
        viiva.rotation.x = (index === 0) ? rot.x : -rot.x;
    });

    this.kaaret.children.forEach((kaari, index) => {
        kaari.rotation.z = (index % 2 === 0) ? hb : -hb;
    });

    /*this.maaTexture.offset.x = hb*0.5;
    this.maaTexture.offset.y = hb;
    this.maaTexture.needsUpdate = true;*/

    const visible = TDEMO.SYNC.getSymbol();
    if(visible === 1 && !this.sprite.visible){
        this.sprite.visible = true;
        this.sprite.needsUpdate = true;
    }
    else if(visible === 0 && this.sprite.visible){
        this.sprite.visible = false;
        this.sprite.needsUpdate = true;
    }

    const edges = TDEMO.SYNC.getEdges();
    this.edge.enabled = edges;
};

Confusion.prototype.createShapes = function () {
    const obj = new THREE.Object3D();
    const obj2 = new THREE.Object3D();
    const material = new THREE.MeshToonMaterial({ color: 0xffffbb, emissive: 0xFF00FF });

    let lastZ = 200;
    let lastX = 80;
    for( let i = 0; i < 30; ++i){
        const geometry = new THREE.IcosahedronGeometry(8, 0);
        const object = new THREE.Mesh(geometry, material);
        object.position.x = -lastX;
        lastX = object.position.x;
        object.position.z = lastZ;
        obj.add(object);

        const geometry2 = new THREE.TetrahedronGeometry(8, 0);
        const object2 = new THREE.Mesh(geometry2, material);
        object2.position.x = -lastX;

        object2.position.z = lastZ;
        obj2.add(object2);

        lastZ -= 20;
    }

    return [obj, obj2];
}

Confusion.prototype.createSky = function () {

    const material = new THREE.MeshBasicMaterial({ color: 0x00FFFF, side: THREE.DoubleSide });
    const skySphere = new THREE.Mesh(new THREE.SphereGeometry(300, 64, 64), material);
    skySphere.rotation.x = -Math.PI / 2;
    return skySphere;
};

Confusion.prototype.createHeightMap = function(texture){
    let seed = Math.PI / 4;
    const random = function () {
        const x = Math.sin( seed ++ ) * 1000;
        return x - Math.floor( x );
    }
    const geometry = new THREE.PlaneGeometry(1200, 1200, 180, 180);
    geometry.rotateX(-Math.PI/2);
    const material = new THREE.MeshToonMaterial({
        color : 0x5D478B,
        emissive : 0x00FFFFF,
        emissiveIntensity : 0.5,
        side : THREE.DoubleSide,
        //map : texture
    });

    const vertices = geometry.attributes.position.array;

    for( let i = 0; i < vertices.length; i +=3 ){

        vertices[i+1] = Math.sin(random())*10.0 + Math.sin(random())*20.0;
    }
    
    const ground = new THREE.Mesh( geometry, material );
    ground.position.y = -40.;
    
    return ground;
};

Confusion.prototype.createArches = function () {

    const textures = TDEMO.TEXTURES.getTextures();
    const kaaret = new THREE.Object3D();

    let lastZ = -180;
    const colors = [0x000666, 0x666000, 0x066600];
    const textureArray = [textures.yksi, textures.kaksi, textures.penta,
        textures.kolme, textures.nelja, textures.viisi];

    let k = 0;
    for(let i = 0; i < 3; ++i){
        for(let j = 0; j < 2; ++j){
            const kaari = this.createParticles(colors[i], textureArray[k], 180, 20);
            kaari.position.z = lastZ;
            lastZ += 40;

            kaaret.add(kaari);
            ++k;
        }
    }

    return kaaret;
}


Confusion.prototype.createParticles = function(color, texture, radius, tube){
    
    const  material = new THREE.PointsMaterial({ 
        color: color,
        map : texture,
        size : 30,
        //sizeAttenuation: false,
        blending: THREE.AdditiveBlending,
        //depthTest: false,
        transparent: true,
        opacity: 0.8
    });
    const geometry = new THREE.TorusGeometry( radius, tube, 20, 80);
    const points = new THREE.Points(geometry, material);
    return points;
};

Confusion.prototype.createLines = function(){
    const lsystem = new LSYSTEM();
    lsystem.interpret(9, 60, 
        "FrFrFruFuFuFulFlFl","FuFrFFtFrFlF", 3);
    lsystem.moveToCenter();

    const lines = new THREE.Object3D();
    const lineMaterial = new THREE.LineBasicMaterial({
        color: 0xAA00FF,
        linewidth: 3
    });
    const lineMaterial2 = new THREE.LineBasicMaterial({
        color: 0x00FFAA,
        linewidth: 3
    });

    const line = lsystem.createLine(lineMaterial);
    line.material.opacity = 0.25;
    line.material.transparent = true;
    line.position.z = -20;
    line.position.x = 70;
    lines.add(line);

    const line2 = lsystem.createLine(lineMaterial2);
    line2.material.opacity = 0.5;
    line2.material.transparent = true;
    line2.position.z = 20;
    line2.position.x = -70;
    lines.add(line2);

    return lines;
};

Confusion.prototype.createSprite = function(){
    const texture = TDEMO.TEXTURES.getTextures().devil;
    const material = new THREE.SpriteMaterial({
        map : texture,
        color: 0xFF0000,
        transparent: true,
        opacity: 0.8,
        blending: THREE.AdditiveBlending,
    });

    const sprite = new THREE.Sprite(material);
    return sprite;
}