/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0006J'\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 \u00a2\u0006\u0002\u0010!J\b\u0010\"\u001a\u00020\u0003H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006#"}, d2={"LTeletextFont;", "", "pngFile", "", "(Ljava/lang/String;)V", "charH", "", "getCharH", "()I", "charW", "getCharW", "chars", "", "LTeletextCharKey;", "Ljava/awt/image/BufferedImage;", "getChars", "()Ljava/util/Map;", "colors", "", "Ljava/awt/Color;", "getColors", "()Ljava/util/List;", "createImage", "w", "h", "renderTeletextPackets", "", "g", "Ljava/awt/Graphics2D;", "buf", "", "elapsed", "", "(Ljava/awt/Graphics2D;[BLjava/lang/Double;)V", "toString", "teletext-tools"})
public final class TeletextFont {
    @NotNull
    private final List<Color> colors;
    @NotNull
    private final Map<TeletextCharKey, BufferedImage> chars;
    private final int charW;
    private final int charH;

    /*
     * WARNING - void declaration
     */
    public TeletextFont(@NotNull String pngFile) {
        int rgb;
        Intrinsics.checkNotNullParameter(pngFile, "pngFile");
        this.colors = new ArrayList();
        this.chars = new LinkedHashMap();
        BufferedImage img = ImageIO.read(new File(pngFile));
        int y = img.getHeight() - 1 - 7;
        int n = img.getHeight() - 1;
        if (y <= n) {
            while (true) {
                this.colors.add(new Color(img.getRGB(img.getWidth() - 1, y)));
                if (y == n) break;
                ++y;
            }
        }
        List colunmXs = new ArrayList();
        List rowYs = new ArrayList();
        int lastRgb = img.getRGB(0, 0);
        int lastW = 1;
        int n2 = img.getWidth();
        for (int x = 0; x < n2; ++x) {
            rgb = img.getRGB(x, 0);
            if ((rgb & 0xFFFFFF) == 0) continue;
            if (rgb != lastRgb) {
                colunmXs.add(x);
                lastW = 1;
            } else {
                ++lastW;
            }
            lastRgb = rgb;
        }
        lastRgb = img.getRGB(0, 0);
        int lastH = 1;
        rgb = img.getHeight();
        for (int y2 = 0; y2 < rgb; ++y2) {
            int rgb2 = img.getRGB(0, y2);
            if ((rgb2 & 0xFFFFFF) == 0) continue;
            if (rgb2 != lastRgb) {
                rowYs.add(y2);
                lastRgb = rgb2;
                lastH = 1;
                continue;
            }
            ++lastH;
        }
        this.charW = lastW;
        this.charH = lastH;
        Iterable $this$forEachIndexed$iv = rowYs;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int n3;
            if ((n3 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n4 = ((Number)item$iv).intValue();
            int yIndex = n3;
            boolean bl = false;
            Iterable $this$forEachIndexed$iv2 = colunmXs;
            boolean $i$f$forEachIndexed2 = false;
            int index$iv2 = 0;
            for (Object item$iv2 : $this$forEachIndexed$iv2) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Object object;
                Object item$iv$iv2;
                void $this$mapTo$iv$iv2;
                int n5;
                if ((n5 = index$iv2++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int n6 = ((Number)item$iv2).intValue();
                int xIndex = n5;
                boolean bl2 = false;
                int code = 32 + yIndex * 16 + xIndex;
                Iterable $this$map$iv2 = this.colors;
                boolean $i$f$map22 = false;
                Iterable iterable = $this$map$iv2;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    Color color = (Color)item$iv$iv2;
                    object = destination$iv$iv;
                    boolean bl3 = false;
                    object.add(new BufferedImage(this.charW, this.charH, 2));
                }
                List charImages = (List)destination$iv$iv;
                Ref.ObjectRef charGs = new Ref.ObjectRef();
                Iterable $i$f$map22 = charImages;
                object = charGs;
                int $i$f$map = 0;
                destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo2 = false;
                item$iv$iv2 = $this$mapTo$iv$iv.iterator();
                while (item$iv$iv2.hasNext()) {
                    void img2;
                    Object item$iv$iv3 = item$iv$iv2.next();
                    BufferedImage bl3 = (BufferedImage)item$iv$iv3;
                    Collection collection = destination$iv$iv2;
                    boolean bl4 = false;
                    collection.add(img2.createGraphics());
                }
                ((Ref.ObjectRef)object).element = (List)destination$iv$iv2;
                $i$f$map = this.charW;
                for (int charX = 0; charX < $i$f$map; ++charX) {
                    int n7 = this.charH;
                    for (int charY = 0; charY < n7; ++charY) {
                        void y3;
                        void x;
                        boolean white;
                        boolean bl5 = white = (img.getRGB((int)(x + charX), (int)(y3 + charY)) & 0xFFFFFF) == 0xFFFFFF;
                        if (!white) continue;
                        Iterable $this$forEachIndexed$iv3 = this.colors;
                        boolean $i$f$forEachIndexed3 = false;
                        int index$iv3 = 0;
                        for (Object item$iv3 : $this$forEachIndexed$iv3) {
                            void color;
                            int n8;
                            if ((n8 = index$iv3++) < 0) {
                                CollectionsKt.throwIndexOverflow();
                            }
                            Color color2 = (Color)item$iv3;
                            int colorIndex = n8;
                            boolean bl6 = false;
                            ((Graphics2D)((List)charGs.element).get(colorIndex)).setColor((Color)color);
                            ((Graphics2D)((List)charGs.element).get(colorIndex)).fillRect(charX, charY, 1, 1);
                        }
                    }
                }
                Iterable $this$forEachIndexed$iv4 = this.colors;
                boolean $i$f$forEachIndexed4 = false;
                int index$iv4 = 0;
                for (Object item$iv4 : $this$forEachIndexed$iv4) {
                    int n9;
                    if ((n9 = index$iv4++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Color $i$f$forEachIndexed3 = (Color)item$iv4;
                    int colorIndex = n9;
                    boolean bl7 = false;
                    this.chars.put(new TeletextCharKey(code, colorIndex), (BufferedImage)charImages.get(colorIndex));
                }
            }
        }
    }

    @NotNull
    public final List<Color> getColors() {
        return this.colors;
    }

    @NotNull
    public final Map<TeletextCharKey, BufferedImage> getChars() {
        return this.chars;
    }

    public final int getCharW() {
        return this.charW;
    }

    public final int getCharH() {
        return this.charH;
    }

    public final void renderTeletextPackets(@NotNull Graphics2D g, @NotNull byte[] buf, @Nullable Double elapsed) {
        Intrinsics.checkNotNullParameter(g, "g");
        Intrinsics.checkNotNullParameter(buf, "buf");
        boolean raw = buf.length % 42 == 0;
        int stride = raw ? 42 : 40;
        int lines = buf.length / stride;
        int pos = buf.length - stride;
        while (pos >= 0) {
            int linePos = pos;
            pos -= stride;
            int y = 0;
            if (raw) {
                int b0 = BuffersAndEncodingKt.unham(buf[linePos++]);
                int b1 = BuffersAndEncodingKt.unham(buf[linePos++]);
                int mpag = b1 << 4 | b0;
                int mag = mpag & 7;
                int adr = (mpag & 0xF8) >> 3;
                y = adr * this.charH;
            } else {
                y = --lines * this.charH;
            }
            int backgroundColorIndex = 0;
            int foregroundColorIndex = this.colors.size() - 1;
            boolean gfxMode = false;
            boolean doubleHeight = false;
            boolean holdGfx = false;
            int lastGfxChar = 32;
            int nextForegroundColorIndex = foregroundColorIndex;
            int skipChars = raw && y == 0 ? 8 : 0;
            boolean blink = false;
            boolean splitGraphics = false;
            for (int column = 0; column < 40; ++column) {
                int x = column * this.charW;
                byte b = buf[linePos++];
                int code = b & 0x7F;
                if (y == 0 && column < 8) {
                    code = "  P100      ".charAt(column);
                    --skipChars;
                } else if (skipChars-- > 0) {
                    code = 46;
                }
                boolean drawChar = false;
                switch (code) {
                    case 0: {
                        gfxMode = false;
                        nextForegroundColorIndex = 0;
                        break;
                    }
                    case 1: {
                        gfxMode = false;
                        nextForegroundColorIndex = 1;
                        break;
                    }
                    case 2: {
                        gfxMode = false;
                        nextForegroundColorIndex = 2;
                        break;
                    }
                    case 3: {
                        gfxMode = false;
                        nextForegroundColorIndex = 3;
                        break;
                    }
                    case 4: {
                        gfxMode = false;
                        nextForegroundColorIndex = 4;
                        break;
                    }
                    case 5: {
                        gfxMode = false;
                        nextForegroundColorIndex = 5;
                        break;
                    }
                    case 6: {
                        gfxMode = false;
                        nextForegroundColorIndex = 6;
                        break;
                    }
                    case 7: {
                        gfxMode = false;
                        nextForegroundColorIndex = 7;
                        break;
                    }
                    case 8: {
                        blink = true;
                        break;
                    }
                    case 9: {
                        blink = false;
                        break;
                    }
                    case 16: {
                        gfxMode = true;
                        nextForegroundColorIndex = 0;
                        break;
                    }
                    case 17: {
                        gfxMode = true;
                        nextForegroundColorIndex = 1;
                        break;
                    }
                    case 18: {
                        gfxMode = true;
                        nextForegroundColorIndex = 2;
                        break;
                    }
                    case 19: {
                        gfxMode = true;
                        nextForegroundColorIndex = 3;
                        break;
                    }
                    case 20: {
                        gfxMode = true;
                        nextForegroundColorIndex = 4;
                        break;
                    }
                    case 21: {
                        gfxMode = true;
                        nextForegroundColorIndex = 5;
                        break;
                    }
                    case 22: {
                        gfxMode = true;
                        nextForegroundColorIndex = 6;
                        break;
                    }
                    case 23: {
                        gfxMode = true;
                        nextForegroundColorIndex = 7;
                        break;
                    }
                    case 29: {
                        backgroundColorIndex = foregroundColorIndex;
                        break;
                    }
                    case 28: {
                        backgroundColorIndex = 0;
                        break;
                    }
                    case 25: {
                        splitGraphics = false;
                        break;
                    }
                    case 26: {
                        splitGraphics = true;
                        break;
                    }
                    case 12: {
                        doubleHeight = false;
                        break;
                    }
                    case 13: {
                        doubleHeight = true;
                        break;
                    }
                    case 30: {
                        holdGfx = true;
                        break;
                    }
                    case 31: {
                        break;
                    }
                    default: {
                        drawChar = true;
                    }
                }
                int useForeground = 0;
                if (holdGfx && !drawChar && gfxMode) {
                    drawChar = true;
                    code = lastGfxChar;
                }
                if (code == 31) {
                    holdGfx = false;
                }
                useForeground = foregroundColorIndex;
                if (blink && elapsed != null && elapsed % 1.0 < 0.5) {
                    drawChar = false;
                }
                int height = doubleHeight ? this.charH * 2 : this.charH;
                g.setColor(this.colors.get(backgroundColorIndex));
                g.fillRect(x, y, this.charW, height);
                if (drawChar) {
                    if (gfxMode) {
                        lastGfxChar = code;
                        code += 96;
                    }
                    if (this.chars.get(new TeletextCharKey(code, useForeground)) != null) {
                        BufferedImage bufferedImage;
                        boolean bl = false;
                        g.drawImage(bufferedImage, x, y, this.charW, height, null);
                    }
                    if (blink && elapsed == null) {
                        g.setColor(Color.WHITE);
                        int blinkPadX = 4;
                        int blinkPadY = 6;
                        g.drawLine(x + blinkPadX, y + blinkPadY, x + this.charW - 1 - blinkPadX, y + this.charH - 1 - blinkPadY);
                        g.drawLine(x + this.charW - 1 - blinkPadX, y + blinkPadY, x + blinkPadX, y + this.charH - 1 - blinkPadY);
                        g.drawLine(x + blinkPadX, y + this.charH / 2, x + this.charW - 1 - blinkPadX, y + this.charH / 2);
                    }
                    if (splitGraphics) {
                        Object element$iv;
                        g.setColor(this.colors.get(backgroundColorIndex));
                        int gridThick = 2;
                        Integer[] blinkPadY = new Integer[]{0, this.charW / 2 - gridThick + 1, this.charW - gridThick};
                        Object $this$forEach$iv = (Integer[])CollectionsKt.listOf(blinkPadY);
                        boolean $i$f$forEach = false;
                        Iterator iterator2 = $this$forEach$iv.iterator();
                        while (iterator2.hasNext()) {
                            element$iv = iterator2.next();
                            int charX = ((Number)element$iv).intValue();
                            boolean bl = false;
                            g.fillRect(x + charX, y, gridThick, height);
                        }
                        $this$forEach$iv = new Integer[]{0, height / 3 - gridThick, height * 2 / 3 - gridThick + 1, height - gridThick};
                        $this$forEach$iv = CollectionsKt.listOf($this$forEach$iv);
                        $i$f$forEach = false;
                        iterator2 = $this$forEach$iv.iterator();
                        while (iterator2.hasNext()) {
                            element$iv = iterator2.next();
                            int charY = ((Number)element$iv).intValue();
                            boolean bl = false;
                            g.fillRect(x, y + charY, this.charW, gridThick);
                        }
                    }
                }
                foregroundColorIndex = nextForegroundColorIndex;
            }
        }
    }

    public static /* synthetic */ void renderTeletextPackets$default(TeletextFont teletextFont, Graphics2D graphics2D, byte[] byArray, Double d, int n, Object object) {
        if ((n & 4) != 0) {
            d = null;
        }
        teletextFont.renderTeletextPackets(graphics2D, byArray, d);
    }

    @NotNull
    public final BufferedImage createImage(int w, int h) {
        return new BufferedImage(this.charW * w, this.charH * h, 1);
    }

    @NotNull
    public String toString() {
        return "TeletextFont(" + this.charW + '*' + this.charH + ')';
    }
}

