/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import parti.NewSPH;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010.\u001a\u00020/H\u0016J\u0018\u00100\u001a\u00020/2\u0006\u00101\u001a\u00020)2\u0006\u00102\u001a\u00020\u001bH\u0016J\u0018\u00103\u001a\u00020/2\u0006\u00104\u001a\u00020\u001b2\u0006\u00105\u001a\u00020\u0004H\u0002J\u0018\u00106\u001a\u00020/2\b\b\u0002\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\u001bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0019\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001d\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010(\u001a\u00020)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-\u00a8\u0006:"}, d2={"LFlowEffect;", "LEffect;", "()V", "fadePic", "Ljava/awt/image/BufferedImage;", "getFadePic", "()Ljava/awt/image/BufferedImage;", "fadePicG", "Ljava/awt/Graphics2D;", "kotlin.jvm.PlatformType", "getFadePicG", "()Ljava/awt/Graphics2D;", "page", "LTeletextPage;", "getPage", "()LTeletextPage;", "setPage", "(LTeletextPage;)V", "sph", "Lparti/NewSPH;", "getSph", "()Lparti/NewSPH;", "setSph", "(Lparti/NewSPH;)V", "startByState", "", "LFlowState;", "", "getStartByState", "()Ljava/util/Map;", "state", "getState", "()LFlowState;", "setState", "(LFlowState;)V", "stateStart", "getStateStart", "()D", "setStateStart", "(D)V", "stateTicks", "", "getStateTicks", "()I", "setStateTicks", "(I)V", "doReset", "", "doTick", "ticks", "elapsed", "drawFaded", "T", "image", "renderFlow", "move", "", "fadedOut", "teletext-tools"})
public final class FlowEffect
extends Effect {
    @NotNull
    private TeletextPage page = new TeletextPage(null, 1, null);
    @NotNull
    private FlowState state = ArraysKt.first(FlowState.values());
    private int stateTicks;
    private double stateStart;
    @NotNull
    private final Map<FlowState, Double> startByState = new LinkedHashMap();
    @Nullable
    private NewSPH sph;
    @NotNull
    private final BufferedImage fadePic = new BufferedImage(78, 72, 1);
    private final Graphics2D fadePicG = this.fadePic.createGraphics();

    public FlowEffect() {
        super("Flow");
        this.doReset();
    }

    @NotNull
    public final TeletextPage getPage() {
        return this.page;
    }

    public final void setPage(@NotNull TeletextPage teletextPage) {
        Intrinsics.checkNotNullParameter(teletextPage, "<set-?>");
        this.page = teletextPage;
    }

    @NotNull
    public final FlowState getState() {
        return this.state;
    }

    public final void setState(@NotNull FlowState flowState) {
        Intrinsics.checkNotNullParameter((Object)flowState, "<set-?>");
        this.state = flowState;
    }

    public final int getStateTicks() {
        return this.stateTicks;
    }

    public final void setStateTicks(int n) {
        this.stateTicks = n;
    }

    public final double getStateStart() {
        return this.stateStart;
    }

    public final void setStateStart(double d) {
        this.stateStart = d;
    }

    @NotNull
    public final Map<FlowState, Double> getStartByState() {
        return this.startByState;
    }

    @Nullable
    public final NewSPH getSph() {
        return this.sph;
    }

    public final void setSph(@Nullable NewSPH newSPH) {
        this.sph = newSPH;
    }

    @NotNull
    public final BufferedImage getFadePic() {
        return this.fadePic;
    }

    public final Graphics2D getFadePicG() {
        return this.fadePicG;
    }

    @Override
    public void doReset() {
        this.sph = new NewSPH(false);
        this.stateTicks = 0;
        this.stateStart = 0.0;
        this.state = ArraysKt.first(FlowState.values());
        this.startByState.clear();
    }

    @Override
    public void doTick(int ticks, double elapsed) {
        int n = this.stateTicks;
        this.stateTicks = n + 1;
        FlowState newState = FlowState.Companion.getStateByElapsedTime(elapsed);
        if (newState != this.state) {
            this.state = newState;
            this.stateTicks = 0;
            this.stateStart = elapsed;
            Double d = elapsed;
            this.startByState.put(newState, d);
        }
        double stateT = (elapsed - this.stateStart) / newState.getDuration();
        switch (WhenMappings.$EnumSwitchMapping$0[newState.ordinal()]) {
            case 1: {
                this.renderFlow(false, 1.0 - stateT);
                break;
            }
            case 2: {
                this.renderFlow(false, 0.0);
                break;
            }
            case 3: {
                this.renderFlow(true, 0.0);
                break;
            }
            case 4: {
                this.renderFlow(true, stateT);
                break;
            }
            case 5: {
                this.page.fill(32);
                break;
            }
            case 6: {
                this.page.fill(32);
            }
        }
        BuffersAndEncodingKt.formatAsPage(this.page.getData(), 256, this.getBuf());
    }

    public final void renderFlow(boolean move, double fadedOut) {
        NewSPH newSPH = this.sph;
        BufferedImage bufferedImage = newSPH != null ? newSPH.renderImage() : null;
        if (bufferedImage == null) {
            return;
        }
        BufferedImage img = bufferedImage;
        if (move) {
            NewSPH newSPH2 = this.sph;
            if (newSPH2 != null) {
                newSPH2.move();
            }
        }
        byte[] flowBytes = ImageUtilsKt.convertImage$default(img, 0, 0, 0, null, false, 30, null);
        this.drawFaded(fadedOut, img);
        for (int y = 1; y < 24; ++y) {
            this.page.set(0, y, 20);
        }
    }

    public static /* synthetic */ void renderFlow$default(FlowEffect flowEffect, boolean bl, double d, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        flowEffect.renderFlow(bl, d);
    }

    private final void drawFaded(double T, BufferedImage image) {
        this.fadePicG.drawImage((Image)image, 0, 0, null);
        this.fadePicG.setColor(new Color(255, 255, 255, RangesKt.coerceIn(MathKt.roundToInt(GlobalsKt.lerp(T, 0.0, 255.0)), new IntRange(0, 255))));
        this.fadePicG.fillRect(0, 0, this.fadePic.getWidth(), this.fadePic.getHeight());
        this.page.takeDataFrom(ImageUtilsKt.convertImage$default(DitherKt.dither$default(this.fadePic, false, 2, null), 0, 0, 0, null, false, 62, null));
        for (int x = 0; x < 40; ++x) {
            this.page.set(x, 0, 32);
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FlowState.values().length];
            nArray[FlowState.FLOW_IN.ordinal()] = 1;
            nArray[FlowState.FLOW_KEEP.ordinal()] = 2;
            nArray[FlowState.FLOW_LIQUIFY.ordinal()] = 3;
            nArray[FlowState.FLOW_OUT.ordinal()] = 4;
            nArray[FlowState.BLACK.ordinal()] = 5;
            nArray[FlowState.BLACK0.ordinal()] = 6;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

