/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0019\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020*2\u0006\u0010.\u001a\u00020\u0005H\u0002J\u0010\u0010/\u001a\u00020*2\u0006\u0010.\u001a\u00020\u0005H\u0016R\u001a\u0010\u0007\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000bR\u0014\u0010\u000f\u001a\u00020\u0010X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0010X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u001a\u0010\u0015\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\t\"\u0004\b\u0017\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\t\"\u0004\b\u001c\u0010\u000bR\u0014\u0010\u001d\u001a\u00020\u0010X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0012R\u001a\u0010\u001f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\t\"\u0004\b!\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\tR\u001a\u0010#\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\t\"\u0004\b%\u0010\u000bR\u001a\u0010&\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\t\"\u0004\b(\u0010\u000b\u00a8\u00060"}, d2={"LDotFromCenter;", "LMovingThing;", "img", "Ljava/awt/image/BufferedImage;", "speed", "", "(Ljava/awt/image/BufferedImage;D)V", "angle", "getAngle", "()D", "setAngle", "(D)V", "angleSkew", "getAngleSkew", "setAngleSkew", "centerX", "", "getCenterX", "()I", "centerY", "getCenterY", "currentSpeed", "getCurrentSpeed", "setCurrentSpeed", "getImg", "()Ljava/awt/image/BufferedImage;", "lastStart", "getLastStart", "setLastStart", "maxLen", "getMaxLen", "pos", "getPos", "setPos", "getSpeed", "x", "getX", "setX", "y", "getY", "setY", "draw", "", "g", "Ljava/awt/Graphics2D;", "restart", "elapsed", "tick", "teletext-tools"})
public final class DotFromCenter
implements MovingThing {
    @NotNull
    private final BufferedImage img;
    private final double speed;
    private double pos;
    private double angle;
    private double x;
    private double y;
    private double currentSpeed;
    private double lastStart;
    private double angleSkew;
    private final int centerX;
    private final int centerY;
    private final int maxLen;

    public DotFromCenter(@NotNull BufferedImage img, double speed) {
        Intrinsics.checkNotNullParameter(img, "img");
        this.img = img;
        this.currentSpeed = this.speed = speed;
        this.centerX = 78;
        this.centerY = 48;
        this.maxLen = 156;
        this.restart(0.0);
    }

    @NotNull
    public final BufferedImage getImg() {
        return this.img;
    }

    public final double getSpeed() {
        return this.speed;
    }

    public final double getPos() {
        return this.pos;
    }

    public final void setPos(double d) {
        this.pos = d;
    }

    public final double getAngle() {
        return this.angle;
    }

    public final void setAngle(double d) {
        this.angle = d;
    }

    public final double getX() {
        return this.x;
    }

    public final void setX(double d) {
        this.x = d;
    }

    public final double getY() {
        return this.y;
    }

    public final void setY(double d) {
        this.y = d;
    }

    public final double getCurrentSpeed() {
        return this.currentSpeed;
    }

    public final void setCurrentSpeed(double d) {
        this.currentSpeed = d;
    }

    public final double getLastStart() {
        return this.lastStart;
    }

    public final void setLastStart(double d) {
        this.lastStart = d;
    }

    public final double getAngleSkew() {
        return this.angleSkew;
    }

    public final void setAngleSkew(double d) {
        this.angleSkew = d;
    }

    public final int getCenterX() {
        return this.centerX;
    }

    public final int getCenterY() {
        return this.centerY;
    }

    public final int getMaxLen() {
        return this.maxLen;
    }

    private final void restart(double elapsed) {
        this.pos = 0.0;
        this.angle = PlasmaKt.getSineRND().nextDouble(Math.PI * 2);
        this.currentSpeed = this.speed * PlasmaKt.getSineRND().nextDouble(0.8, 1.2);
        this.lastStart = elapsed;
        this.x = 0.0;
        this.y = 0.0;
        this.angleSkew = PlasmaKt.getSineRND().nextDouble(-0.5, 0.5);
    }

    @Override
    public void tick(double elapsed) {
        double dotElapsed = elapsed - this.lastStart;
        this.pos = dotElapsed * this.currentSpeed;
        if (this.pos > 1.0) {
            this.restart(elapsed);
        }
        this.x = (double)this.centerX + Math.sin(this.angle + this.angleSkew * dotElapsed) * this.pos * (double)this.maxLen;
        this.y = (double)this.centerY + Math.cos(this.angle + this.angleSkew * dotElapsed) * this.pos * (double)this.maxLen;
    }

    @Override
    public void draw(@NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter(g, "g");
        double sizeW = GlobalsKt.lerp(this.pos, 40.0, (double)this.img.getWidth() * 1.2);
        double sizeH = sizeW * 2.0 / 3.0;
        double drawX = this.x - sizeW / 2.0;
        double drawY = this.y - sizeH / 2.0;
        g.drawImage(this.img, MathKt.roundToInt(drawX), MathKt.roundToInt(drawY), MathKt.roundToInt(sizeW), MathKt.roundToInt(sizeH), null);
    }
}

