     1                                  %define T                       data
     2                                  %define XX                      data+4
     3                                  %define YY                      data+8
     4                                  
     5                                  %define LENGTH                  0x500
     6                                  
     7                                  org 100h
     8                                  s:
     9 00000000 B81211                      mov ax, 0x1112
    10 00000003 CD10                        int 0x10
    11                                  
    12 00000005 B800B8                      mov ax, 0xb800
    13 00000008 6650                        push eax
    14 0000000A 07                          pop es
    15                                  
    16                                  top:
    17 0000000B A1[FF00]                    mov ax, [T]
    18 0000000E 83E00F                      and ax, 0xf
    19 00000011 752C                        jne skip
    20                                  
    21                                      ; clear screen
    22 00000013 BF0000                      mov di, 0
    23 00000016 B9401F                      mov cx, 2*80*50
    24 00000019 FC                          cld
    25 0000001A B82008                      mov ax, 0x0820
    26 0000001D F3AB                        rep stosw
    27                                  
    28                                      ; TMDC
    29 0000001F BB0A1E                      mov      bx,2*80*48 + 10
    30 00000022 26C707540F                  mov      word [es:bx], 0x0f54
    31 00000027 26C747044D0F                mov      word [es:bx+4], 0x0f4d
    32 0000002D 26C74708440F                mov      word [es:bx+8], 0x0f44
    33 00000033 26C7470C430F                mov      word [es:bx+12], 0x0f43
    34 00000039 26C747100304                mov      word [es:bx+16], 0x0403
    35                                  
    36                                  skip:
    37                                  
    38 0000003F D906[F100]                  fld     dword [p1]        ; p1
    39 00000043 DA0E[FF00]                  fimul   dword [T]         ; p1*t
    40 00000047 D9C0                        fld     st0               ; a1 a1=p1*t
    41                                  
    42 00000049 D906[F500]                  fld     dword [p2]        ; p2 a1 a1
    43 0000004D DA0E[FF00]                  fimul   dword [T]         ; b1=p2*t a1 a1
    44 00000051 D9C0                        fld     st0               ; b1 b1 a1 a1
    45                                  
    46                                  ; Loop
    47 00000053 B90005                      mov  cx, LENGTH
    48                                  
    49                                      ; Init c1 = 0
    50 00000056 D9EE                        fldz                      ; 0 b1 b1 a1 a1
    51                                  
    52                                  draw:
    53                                      
    54 00000058 D806[F900]                  fadd     dword [p3]       ; c1+p3 b1 b1 a1 a1
    55 0000005C D9C9                        fxch     st1              ; b1 c1+p3 b1 a1 a1
    56 0000005E D9FF                        fcos                      ; c(b1) c1+p3 b1 a1 a1
    57 00000060 D9C9                        fxch     st1              ; c1+p3 c(b1) b1 a1 a1
    58 00000062 D9C0                        fld      st0              ; c1+p3 c1+p3 c(b1) b1 a1 a1
    59 00000064 D9FB                        fsincos                   ; c(c1) s(c1) c1+p3 c(b1) b1 a1 a1
    60                                  
    61 00000066 DECB                        fmulp    st3, st0         ; s(c1) c1+p3 c(c1)*c(b1) b1 a1 a1
    62 00000068 D9CA                        fxch     st2              ; c(c1)*c(b1) c1+p3 s(c1) b1 a1 a1
    63 0000006A DE0E[FD00]                  fimul    word [height]    ; H*c(b1)*c(c1) c1+p3 s(c1) b1 a1 a1
    64 0000006E D9FC                        frndint                   ; (int) H*c(b1)*c(c1) c1+p3 s(c1) b1 a1 a1
    65 00000070 DE06[FD00]                  fiadd    word [height]    ; H + (int) H*c(b1)*c(c1) c1+p3 s(c1) b1 a1 a1
    66 00000074 DF1E[0701]                  fistp    word [YY]        ; c1+p3 s(c1) b1 a1 a1
    67                                  
    68 00000078 D9CB                        fxch     st3              ; a1 s(c1) b1 c1+p3 a1
    69 0000007A D9FE                        fsin                      ; s(a1) s(c1) b1 c1+p3 a1
    70 0000007C DEC9                        fmul                      ; s(a1)*s(c1) b1 c1+p3 a1
    71 0000007E DE0E[8F00]                  fimul    word [width+1]   ; W*s(a1)*s(c1) b1 c1+p3 a1
    72 00000082 D9FC                        frndint                   ; (int) W*s(a1)*s(c1) b1 c1+p3 a1
    73 00000084 DF1E[0301]                  fistp    word [XX]        ; b1 c1 a1
    74                                  
    75                                      ; (YY & 0xfe) * W + ((XX + W) & 0xfe)
    76 00000088 8126[0701]FE00              and      word [YY], 0xfe
    77                                  
    78                                  width:
    79 0000008E B85000                      mov      ax, 80           ; this 80 is used up there
    80                                  
    81 00000091 F726[0701]                  mul      word [YY]
    82 00000095 93                          xchg     bx, ax
    83                                  
    84 00000096 A1[0301]                    mov      ax, word [XX]
    85 00000099 83C050                      add      ax, 80
    86 0000009C 25FE00                      and      ax, 0xfe
    87 0000009F 01D8                        add      ax, bx
    88 000000A1 89C3                        mov      bx, ax
    89                                  
    90 000000A3 2666C7470403072007          mov      dword [es:bx+4], 0x07200703 ; 20 -> fa -> f9 -> 7
    91 000000AC 26885F02                    mov      byte [es:bx+2], bl
    92 000000B0 26884F04                    mov      byte [es:bx+4], cl
    93                                  
    94 000000B4 89C8                        mov      ax, cx
    95 000000B6 250001                      and      ax, 0x100
    96 000000B9 C1C808                      ror      ax, 8
    97 000000BC 7403                        jz       skip2
    98 000000BE B80F00                      mov      ax, 0xf
    99                                  
   100                                  skip2:
   101 000000C1 26884701                    mov      byte [es:bx+1], al
   102 000000C5 26884705                    mov      byte [es:bx+5], al
   103                                  
   104                                  
   105 000000C9 D9C2                         fld      st2           ; a1 b1 c1
   106 000000CB D806[F100]                   fadd     dword [p1]    ; a1+p1 b1 c1
   107 000000CF D9C0                         fld      st0           ; a1+p1 a1+p1 b1 c1
   108 000000D1 D9CA                         fxch     st2           ; b1 a1+p1 a1+p1 c1
   109 000000D3 D806[F500]                   fadd     dword [p2]    ; b1+p2 a1+p1 a1+p1 c1
   110 000000D7 D9C0                         fld      st0           ; b1+p2 b1+p2 a1+p1 a1+p1 c1
   111                                  
   112 000000D9 D9C4                         fld      st4           ; c1 b1 b1 a1 a1
   113                                  
   114 000000DB 83E901                      sub cx, 1
   115 000000DE 0F8576FF                    jnz draw
   116                                  
   117 000000E2 668306[FF00]01              add dword [T], 1
   118                                  
   119 000000E8 E460                    	in al, 0x60
   120 000000EA FEC8                        dec al
   121                                  
   122                                  ; return to top of loop if AL != 1
   123 000000EC 0F851BFF                	jnz top
   124 000000F0 C3                          ret
   125                                      
   126                                  ; ----------------------------------------------------
   127                                  ; Constants
   128                                  ; ----------------------------------------------------
   129                                  p1:
   130 000000F1 124B4A3C                    dd 0.012347
   131                                  p2:
   132 000000F5 21B15D3C                    dd 0.013531
   133                                  p3:
   134 000000F9 7DD8203B                     dd 0.00245431 ; (3.1415169 / LENGTH)
   135                                  height:
   136 000000FD 3200                        dw 50
   137                                  ; ----------------------------------------------------
   138                                  ; Vars
   139                                  ; ----------------------------------------------------
   140                                  data:
