#version 130

uniform sampler2D currentTexture; 
uniform sampler2D bgTexture;
uniform float xOffset;
uniform float yOffset;

void main (void)
{
    vec2 uv = gl_TexCoord[0].st;
    vec4 color = texture2D(currentTexture, uv).rgba;
    vec4 bgColor = texture2D(bgTexture, vec2(uv.x + xOffset, uv.y + yOffset)).rgba;    

    if(color.a > 0) {
        if(color.r == 1 && color.g == 1 && color.b == 1) {
            color = bgColor;
        }
    }


    gl_FragColor = color;
}
