#version 450 core

// inputs 
in vec2 texCoord;

// outputs
out vec4 fragColor;

// uniforms
uniform float       g_time;
uniform vec3        g_resolution;
uniform int         g_type;
uniform float       g_typeMix;
uniform float       g_typeScale;
uniform float       g_typeBias;
uniform sampler2D   t_texture0;

void main() {
	vec2 uv = (2.*texCoord-1.)*0.4*mix(1., .4, sin(g_time*0.3))*vec2(g_resolution.x/g_resolution.y , 1.);
    vec3 outColor  = texture(t_texture0, texCoord).rgb;
    vec3 outScaled = (outColor + vec3(g_typeBias))*g_typeScale;

	switch(g_type) {
	case 1:
		outColor = smoothstep(vec3(.5-g_typeMix), vec3(.5+g_typeMix), vec3(dot(outScaled, vec3(.2126, .7152, .0722))));
		break;
		
	case 2:
		outColor = smoothstep(vec3(.5-g_typeMix), vec3(.5+g_typeMix), outScaled);
		break;
	
	default:
		break;
	}

    outColor *= mix(vec3(1.0), vec3(
    				 uv.y*sin(uv.x*uv.y*52.0+g_time*1.39)*cos(length(uv)*25.0),
                     uv.y*sin(uv.x*uv.y*42.0+g_time*1.41)*cos(length(uv)*72.0),
                     uv.y*sin(uv.x*uv.y*47.0+g_time*1.34)*cos(length(uv)*85.0)
                    ), .15);
    fragColor = vec4(outColor*vec3(0.6, 1.,1), 1.);
}



