#version 450 core

// varying inputs
in vec2 texCoord;

// outputs
out vec4 outColor;

// uniforms
uniform sampler2D t_color;          // dof'ed input: rgb - color, a - coc size
uniform sampler2D t_depth;

uniform vec2  g_srcResolution;
uniform vec2  g_dstResolution;

// dof uniforms
uniform vec2  g_pixelSize;          // practically (1.0/g_srcResolution)

// samples used in propagation step
const int samples = 3;
const float PI = 3.141592653589793238;

vec2 toUnitDisk(vec2 a) {
	float r, phi;
	if (a.x > -a.y) {
		if (a.x > a.y) {
			r = a.x;
			phi = PI/4 * (a.y/a.x);
		} else {
			r = a.y;
			phi = PI/4 * (2 - (a.x/a.y));
		}
	} else {
		if (a.x < a.y) {
			r = -a.x;
			phi = PI/4 * (4 + (a.y/a.x));
		} else {
			r = -a.y;
			phi = a.y == 0 ? 0 : PI/4 * (6 - (a.x/a.y));
		}
	}
	
	return vec2(r*cos(phi), r*sin(phi));
}

void main() {
    vec4 centerColor = texture(t_color, texCoord);
    for (float y = -1.0; y <= 1.0; y += (2.0/(samples - 1))) {
        for (float x = -1.0; x <= 1.0; x += (2.0/(samples - 1))) {
            centerColor.rgb = 
                max(centerColor.rgb,
                    texture(t_color, texCoord + toUnitDisk(vec2(x,y))*g_pixelSize*centerColor.a*0.3).rgb);
        }
    }

    outColor = centerColor;
}


