// basically a tuned http://tuxedolabs.blogspot.com/2018/05/bokeh-depth-of-field-in-single-pass.html 
#version 450 core

// varying inputs
in vec2 texCoord;

// outputs
out vec4 outColor;

// uniforms
uniform sampler2D t_color;
uniform sampler2D t_depth;

uniform vec2  g_srcResolution;
uniform vec2  g_dstResolution;

uniform vec2  g_projPlanes;     // x - near, y - far

// dof uniforms
uniform vec2  g_pixelSize;      // practically (1.0/g_srcResolution)

// these vars are not entirely physical correct but allow to easily and
// artistically adjust dof parameters. you know :)
uniform float g_maxRadius;          // max CoC size in pixels (that is, 20.0 covers 40 pixels)
uniform float g_oneOverFocusPoint;  // (1.0 / focusPoint), focusPoint = [0.0, 1.0]
uniform float g_focusScale;         // controls how strong DOF would appear (think of something like aperture size)

float linearizeDepth(float depth) {
    // skip NDC stage, work with [0..1] already
    return ((g_projPlanes.x*g_projPlanes.y) / (g_projPlanes.y + depth * (g_projPlanes.x - g_projPlanes.y)));
}

float getBlurSize(float depth)
{
    float coc = clamp((g_oneOverFocusPoint - (1.0 / depth)) * g_focusScale, -1.0, 1.0);
    return abs(coc) * g_maxRadius;
}

void main() {
    float depth = texture(t_depth, texCoord).r;
    float coc = getBlurSize(linearizeDepth(depth));
    outColor = vec4(texture(t_color, texCoord).rgb, coc);
}
