; UPKR promo final linker

	DEVICE	ZXSPECTRUM48

	org	#4000
	INCBIN	"a000.C"	
	
	org	24525

begin:	equ	$

	jp	launch

data1:	INCBIN "041-norm.scr.rcs.zx0"        
data2:	INCBIN "teeray.bin.zx0"

launch:	di
	ld	sp,#ffff
	xor	a
	out	(#fe),a
;---------------------------------------------------------------
delay:	ld	a,22
wait:	ld	h,d
	ld	l,e
	lddr
	dec	a
	jr	nz,wait
;---------------------------------------------------------------
	xor	a
	ld	h,#5b
cls:	dec	hl
	ld	(hl),a
	or	(hl)
	jr	z,cls
;---------------------------------------------------------------
	ld	hl,data1
	ld	de,#4000
	call	dzx0_standard
;---------------------------------------------------------------
	ld	hl,data2
	ld	de,#5b00
	call	dzx0_standard

	call	#fba7	;call RCS	

	jp	#f969	;unpacked data start

;---------------------------------------------------------------
; ZX0 decoder by Einar Saukas & Urusergi
; "Standard" version (68 bytes only)
;---------------------------------------------------------------
; Parameters:
;   HL: source address (compressed data)
;   DE: destination address (decompressing)
;---------------------------------------------------------------

dzx0_standard:
        ld      bc, $ffff               ; preserve default offset 1
        push    bc
        inc     bc
        ld      a, $80
dzx0s_literals:
        call    dzx0s_elias             ; obtain length
        ldir                            ; copy literals
        add     a, a                    ; copy from last offset or new offset?
        jr      c, dzx0s_new_offset
        call    dzx0s_elias             ; obtain length
dzx0s_copy:
        ex      (sp), hl                ; preserve source, restore offset
        push    hl                      ; preserve offset
        add     hl, de                  ; calculate destination - offset
        ldir                            ; copy from offset
        pop     hl                      ; restore offset
        ex      (sp), hl                ; preserve offset, restore source
        add     a, a                    ; copy from literals or new offset?
        jr      nc, dzx0s_literals
dzx0s_new_offset:
        pop     bc                      ; discard last offset
        ld      c, $fe                  ; prepare negative offset
        call    dzx0s_elias_loop        ; obtain offset MSB
        inc     c
        ret     z                       ; check end marker
        ld      b, c
        ld      c, (hl)                 ; obtain offset LSB
        inc     hl
        rr      b                       ; last offset bit becomes first length bit
        rr      c
        push    bc                      ; preserve new offset
        ld      bc, 1                   ; obtain length
        call    nc, dzx0s_elias_backtrack
        inc     bc
        jr      dzx0s_copy
dzx0s_elias:
        inc     c                       ; interlaced Elias gamma coding
dzx0s_elias_loop:
        add     a, a
        jr      nz, dzx0s_elias_skip
        ld      a, (hl)                 ; load another group of 8 bits
        inc     hl
        rla
dzx0s_elias_skip:
        ret     c
dzx0s_elias_backtrack:
        add     a, a
        rl      c
        rl      b
        jr	dzx0s_elias_loop
;---------------------------------------------------------------
fin:
;-----comment this for Pasmo or uncomment for SjAsm-------------
	SAVESNA	"upkrdata.sna", begin
	SAVEBIN	"upkrdata", begin,fin-begin
;	EMPTYTRD "upkrpromo.trd","UPKR"
;	SAVETRD	"upkrpromo.trd","upkrdata.C",begin,fin-begin
;	EMPTYTAP "upkrpromo.tap"
;	SAVETAP	 "upkrpromo.tap",CODE,"upkrdata.C",begin,fin-begin
	display "addr: ",/A,launch
;-------=RMDA=---------------------------------------------[eof]