.import source "common.iasm"
.import source "vic.iasm"
.import source "demo_constants.iasm"

.const TOP_COLOR = $06
.const BOTTOM_COLOR = $09

.label fetch_tables = $bc00 //$c000-272*3
.label bitmap = $c000 // pre-loaded
.label blank_sprite = $e000-$40
.label layout = $e000 // pre-loaded
.label sprites = $e400

.label POSITION_REGISTER = $d000
.label OFFSET_REGISTER = $e3f8

.label RASTERCOLOR_REGISTER = $d021

.const ZP_SINPOS_X = AllocateZP( "ZP_SINPOS_X" )
.const ZP_SINPOS_Y = AllocateZP( "ZP_SINPOS_Y" )
.const ZP_BASE_YPOS = AllocateZP( "ZP_BASE_YPOS" )
.const ZP_SPRITE_DEST_0 = AllocateZP( "ZP_SPRITE_DEST_0" )
.const ZP_SPRITE_DEST_1 = AllocateZP( "ZP_SPRITE_DEST_1" )
.const ZP_SPRITE_DEST_2 = AllocateZP( "ZP_SPRITE_DEST_2" )
.const ZP_CACHE = AllocateWordZP( "ZP_CACHE" )
.const ZP_CACHE_X = ZP_CACHE+0
.const ZP_CACHE_Y = ZP_CACHE+1

.import source "line-twist-scroll/diagonal.iasm"
.import source "line-twist-scroll/rasters.iasm"

.pc = FIRST_SOURCE_LOCATION
   .if ( GENERATE_CODE_FOR_TEST == true )
   {
      lda #(>FRAME_TWISTSCROLLER_START)
      jsr FORWARD_TO_FRAME

      jsr test_init_routine
   }
   else 
   {
      WaitForSignal( SIGNAL_FISH_TANK_FINISHED )
   }
   InitSignal()
   lda #SpriteIndex( blank_sprite )
   sta OFFSET_REGISTER
   FillMem( fetch_tables, 0, 272*3 )
   lda #PP_RAM_ONLY
   sta PROCESSOR_PORT
   FillMem( blank_sprite, 0, 64 )
   lda #PP_VIC_ONLY
   sta PROCESSOR_PORT
   FillMem( sprites, 0, 13*8*64 )
   lax #0
!loop:
   sta $d000,x
   inx
   cpx #$11
   bne !loop-
   lda #$01
   sta SPRITES_VISIBLE_REGISTER
   sta SPRITES_MULTICOLOR_ENABLED
   sta SPRITES_PRIORITY_REGISTER
   sta SPRITES_STRETCHX_ENABLED
   lda #0
   sta SPRITES_STRETCHY_ENABLED
   lda #$05
   sta $d025
   lda #$03
   sta $d027
   lda #$01
   sta $d026

   lda #SPRITE_POSY_TOP+15-20
   sta ZP_BASE_YPOS

.const ZP_CURRENT_LINE = AllocateZP( "ZP_CURRENT_LINE" )
.const ZP_CURRENT_INDEX = AllocateZP( "ZP_CURRENT_INDEX" )
   lda #21
   sta ZP_CURRENT_LINE
   lda #SpriteIndex(sprites)
   sta ZP_CURRENT_INDEX
.const ZP_WINDOW_FETCH_POS = AllocateZP( "ZP_WINDOW_FETCH_POS" )
.const ZP_WINDOW_STORE_POS = AllocateZP( "ZP_WINDOW_STORE_POS" )
.const ZP_TEXT_PTR = AllocateWordZP( "ZP_TEXT_PTR" )
.const ZP_FONT_FETCH_PTR = AllocateWordZP( "ZP_FONT_FETCH_PTR" )
.const ZP_FONT_LINE_INDEX = AllocateZP( "ZP_FONT_LINE_INDEX" )
   lda #0
   sta ZP_FONT_LINE_INDEX
   lda #<font_data
   sta ZP_FONT_FETCH_PTR
   lda #>font_data
   sta ZP_FONT_FETCH_PTR+1
   lda #<scrolltext
   sta ZP_TEXT_PTR
   lda #>scrolltext
   sta ZP_TEXT_PTR+1
.const ZP_SPRITE_DEST_PTR = AllocateWordZP( "ZP_SPRITE_DEST_PTR" )
.const ZP_SPRITE_DEST_INDEX = AllocateZP( "ZP_SPRITE_DEST_INDEX" )
.const ZP_SPRITE_DEST_LINE = AllocateZP( "ZP_SPRITE_DEST_LINE" )
   lda #0
   sta ZP_WINDOW_FETCH_POS
   sta ZP_WINDOW_STORE_POS
   lda #1
   sta ZP_SPRITE_DEST_INDEX
   lda #<(sprites+13*64)
   sta ZP_SPRITE_DEST_PTR
   lda #>(sprites+13*64)
   sta ZP_SPRITE_DEST_PTR+1
   lda #0
   sta ZP_SPRITE_DEST_LINE
!initial_window:
   jsr update_window
   lda ZP_WINDOW_STORE_POS
   bne !initial_window-
   
   WaitForFrame( FRAME_TWISTSCROLLER_START )
   
   SetNewIRQFromMain( irq, RASTERLINE_FIRST_ONSCREEN+14 )
mainloop:
   lda ZP_WINDOW_STORE_POS
!wait:
   cmp ZP_WINDOW_FETCH_POS
   beq !wait-
   jsr update_window
   bcc mainloop
   SetSignal( SIGNAL_PART_FINISHED )
   WaitForSignal( SIGNAL_PART_COMPLETED )
   lda #0
   sta SPRITES_VISIBLE_REGISTER
   jmp LOAD_AND_RUN

update_window:
   ldy ZP_FONT_LINE_INDEX
   ldx ZP_WINDOW_STORE_POS
   lda (ZP_FONT_FETCH_PTR),y
   sta fetch_tables+272*0,x
   cpx #15
   bcs !skip+
   sta fetch_tables+272*0+256,x
!skip:
   iny
   lda (ZP_FONT_FETCH_PTR),y
   sta fetch_tables+272*1,x
   cpx #15
   bcs !skip+
   sta fetch_tables+272*1+256,x
!skip:
   iny
   lda (ZP_FONT_FETCH_PTR),y
   sta fetch_tables+272*2,x
   cpx #15
   bcs !skip+
   sta fetch_tables+272*2+256,x
!skip:
   iny
   cpy #3*33
   bne !skip+
   ldy #0
!check_letter:
   lda (ZP_TEXT_PTR),y
   cmp #$ff
   bne !not_finished+
   sec
   rts
!not_finished:
   tax
   lda font_lookup_lo,x
   sta ZP_FONT_FETCH_PTR
   lda font_lookup_hi,x
   sta ZP_FONT_FETCH_PTR+1
   IncWord( ZP_TEXT_PTR )
!skip:
   sty ZP_FONT_LINE_INDEX
   inc ZP_WINDOW_STORE_POS
   clc
   rts
.var inject_line = List(168)
.var inject_offset = List(168)
.var inject_position = List(168)

.align $100
.pc = * "irq code"
irq:
   inc $d012
   StoreAXY( irq_return )
   lda #irq_stable
   sta IRQ_JMP_LO
   tsx
   cli
   jmp NOP_FOREVER
irq_stable:
   txs
   // start
   lda ZP_BASE_YPOS
   clc
   adc #21
   sta $d001
   // end : 11 cycles
   // start
   // end : 6 cycles
   :DelayFor( 13 ) //51 - 11 - 28 - 6 +11

   // start
.eval inject_line.set(0,*+1)
   lda #SpriteIndex(sprites)
   clc
.eval inject_offset.set(0,*+1)
   adc #0
   sta OFFSET_REGISTER
.eval inject_line.set(1,*+1)
   lda #SpriteIndex(sprites)
   sta inject_line.get(0)
   clc
.eval inject_offset.set(1,*+1)
   adc #0
   tax
.eval inject_position.set(0,*+1)
   lda #$18+65
   sta POSITION_REGISTER
   // end: 28 cycles

   ldy #raster_colors.get(0)

   nop
   nop
   lda RASTERLINE_REGISTER
   //ldy RASTERLINE_REGISTER
   //sty $d020
   cmp RASTERLINE_REGISTER
   sty RASTERCOLOR_REGISTER
   stx OFFSET_REGISTER
   beq *+2

.eval inject_position.set(1,*+1)
   lda #$18+65
   sta POSITION_REGISTER
   lda #raster_colors.get(1)
   sta RASTERCOLOR_REGISTER
   DelayFor( 28-6-6+2+3-4 )
   clc
   ldx ZP_SINPOS_X
   ldy ZP_SINPOS_Y
.const HEIGHT = 168

.var DO_LINE = 0
.var DO_UPDATE = 0

.macro do_line()
{
   .if ( DO_LINE == HEIGHT )
   {
      .error "Too many lines in update_line"
   }
.eval inject_line.set(DO_LINE,*+1)
   lda #SpriteIndex(sprites)
   sta inject_line.get(DO_LINE-1)
.eval inject_offset.set(DO_LINE,*+1)
   adc #0
   sta OFFSET_REGISTER
.eval inject_position.set(DO_LINE,*+1)
   lda #$18+65
   sta POSITION_REGISTER
   lda #raster_colors.get(DO_LINE)
   sta RASTERCOLOR_REGISTER
.eval DO_LINE = DO_LINE+1
}

.macro do_badline()
{
.eval inject_line.set(DO_LINE,*+1)
   lda #SpriteIndex(sprites)
   sta inject_line.get(DO_LINE-1)
.eval inject_offset.set(DO_LINE,*+1)
   adc #0
   sta OFFSET_REGISTER
.eval inject_position.set(DO_LINE,*+1)
   lda #$18+65
   sta POSITION_REGISTER
   lda #raster_colors.get(DO_LINE)
   sta RASTERCOLOR_REGISTER
.eval DO_LINE = DO_LINE+1   
}

.macro do_badline_special()
{
.eval inject_line.set(DO_LINE,*+1)
   lda #SpriteIndex(sprites)
   sta inject_line.get(DO_LINE-1)
.eval inject_offset.set(DO_LINE,*+1)
   adc #0
   sta OFFSET_REGISTER
.eval inject_position.set(DO_LINE,*+1)
   lda #$18+65
   sta POSITION_REGISTER
.eval DO_LINE = DO_LINE+1   
}

.macro move_sprite( line )
{
   lda ZP_BASE_YPOS
   adc #21*line
   sta $d001
}

.const ZP_COS_CACHE = AllocateRangeZP( 168, "ZP_COS_CACHE" )

.macro update_line()
{
   .if ( DO_UPDATE == HEIGHT )
   {
      .error "Too many lines in update_line"
   }
   // start 
   lda sinus_table,x
   adc sinus_table,y
   // 10
   //ror
   sta inject_position.get(DO_UPDATE)
   // 6
   lda cosin_table2,x
   adc cosin_table1,y
   // 10
   //ror
   sta ZP_COS_CACHE+DO_UPDATE
   // 6
   inx
   inx
   dey
   // 6
   .eval DO_UPDATE = DO_UPDATE+1
}

.macro update_line_partial0() // 14 cycles
{
   lda sinus_table,x
   adc sinus_table,y
   sta inject_position.get(DO_UPDATE)
}

.macro update_line_partial1() // 14 cycles
{
   lda cosin_table2,x
   adc cosin_table1,y
   sta ZP_COS_CACHE+DO_UPDATE   
}

.macro update_line_partial2() // 6 cycles
{
   inx
   inx
   dey
   .eval DO_UPDATE = DO_UPDATE+1
}

.eval DO_LINE = 2
.eval DO_UPDATE = 0

   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )

   do_badline()
   do_line(); DelayFor( 26 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )

   do_badline()
   do_line(); DelayFor( 26 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); DelayFor( 25 ); move_sprite( 2 );
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_badline()
   do_line(); DelayFor( 26 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_badline()
   do_line(); DelayFor( 26 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_badline()
   do_line(); DelayFor( 17 ); move_sprite( 3 );
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )

   do_badline()
   do_line(); DelayFor( 26 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_badline()
   do_line(); DelayFor( 26 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); DelayFor( 25 ); move_sprite( 4 )
   do_line(); update_line(); DelayFor( 5 )
   do_badline()
   do_line(); DelayFor( 26 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_badline()
   do_line(); DelayFor( 26 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_badline()
   do_line(); DelayFor( 26 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); DelayFor( 25 ); move_sprite( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_badline()
   do_line(); DelayFor( 26 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_badline()
   do_line(); DelayFor( 26 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); DelayFor( 16 )
   stx ZP_CACHE_X
   sty ZP_CACHE_Y
   lda ZP_BASE_YPOS
   clc
   adc #21*6
   tay
   // do_badline()
.eval inject_line.set(DO_LINE,*+1)
   lda #SpriteIndex(sprites)
   sta inject_line.get(DO_LINE-1)
.eval inject_offset.set(DO_LINE,*+1)
   adc #0
   sta OFFSET_REGISTER
.eval inject_position.set(DO_LINE,*+1)
   lda #$18+65
   sta POSITION_REGISTER
   ldx #raster_colors.get(DO_LINE)
.eval DO_LINE = DO_LINE+1   

   sty $d001
   stx RASTERCOLOR_REGISTER

   do_line(); ldx ZP_CACHE_X; ldy ZP_CACHE_Y; DelayFor( 19 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_badline()
   do_line(); DelayFor( 26 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_badline()
   do_line(); DelayFor( 26 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); DelayFor( 25 ); move_sprite( 7 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_badline()
   do_line(); DelayFor( 26 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_badline()
   do_line(); DelayFor( 26 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_badline()
   do_line(); DelayFor( 26 )
   do_line(); DelayFor( 25 ); move_sprite( 8 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_badline()
   do_line(); DelayFor( 26 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_badline()
   do_line(); DelayFor( 26 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )
   do_line(); update_line(); DelayFor( 5 )

   lda #SpriteIndex( blank_sprite )
   sta OFFSET_REGISTER
   DelayFor(11)
   lda #BOTTOM_COLOR
   sta RASTERCOLOR_REGISTER

   lda ZP_BASE_YPOS
   sec
   sbc #1
   cmp #SPRITE_POSY_TOP+15-21
   bne !skip+
   lda #SPRITE_POSY_TOP+15
!skip:
   sta ZP_BASE_YPOS
   sta $d001

.while ( DO_UPDATE < HEIGHT )
{
   update_line()
}
   lda ZP_CURRENT_INDEX
   sta inject_line.get(167)
   dec ZP_CURRENT_LINE
   bne !skip+
   lda #21
   sta ZP_CURRENT_LINE
   lda ZP_CURRENT_INDEX
   clc
   adc #13
   cmp #13*8+SpriteIndex(sprites)
   bne !skip2+
   lda #SpriteIndex(sprites)
!skip2:
   sta ZP_CURRENT_INDEX

!skip:

   ldx ZP_SINPOS_X
   ldy ZP_SINPOS_Y
.for ( var row = 0; row < HEIGHT; row++ )
{
   ldx ZP_COS_CACHE+row
   lda lookup_table_y,x
   sta inject_offset.get(row)
}
   dec ZP_SINPOS_X
   lda ZP_SINPOS_Y
   clc
   adc #$fe
   sta ZP_SINPOS_Y
   jsr update_sprite

   lda #TOP_COLOR
   sta RASTERCOLOR_REGISTER

//skip_everything:
   lda #irq
   sta IRQ_JMP_LO
   lda #RASTERLINE_FIRST_ONSCREEN+14
   sta $d012

   jsr FRAMEWORK_PERIODICAL

   CheckSignal( SIGNAL_PART_FINISHED )
   beq irq_return
   lda #0
   sta $d011
   NextInterrupt( FRAMEWORK_IRQ, RASTERLINE_FIRST_OFFSCREEN )
   SetSignal( SIGNAL_PART_COMPLETED )
irq_return:
   RestoreAXY()
   asl $d019
   rti

sprite_lookup_table:
   .fill 8, <(sprites+$40*13*i)
   .fill 8, >(sprites+$40*13*i)
   .fill 8, SpriteIndex(sprites)+13*i

.const ZP_CACHE_VALUE = AllocateZP( "ZP_CACHE_VALUE" )
.pc = * "offline update sprite"
update_sprite:
   ldx ZP_WINDOW_FETCH_POS
   ldy ZP_SPRITE_DEST_LINE
.for ( var sprite = 0; sprite < 13; sprite++ )
{
 .for ( var column = 0; column < 3; column++ )
 {
   .if ( column != 0 ) iny
   .for ( var pixel = 0; pixel < 4; pixel++ )
   {
      lda fetch_tables+272*column+11-diagonal_table.get(sprite).get(4*column+pixel),x
      and #$c0>>(2*pixel)
      .if ( pixel != 0 ) ora ZP_CACHE_VALUE
      .if ( pixel == 3 ) sta (ZP_SPRITE_DEST_PTR),y
      else sta ZP_CACHE_VALUE
   }
 }
   lda fetch_tables
 .if ( sprite == 12 )
 {
   lda ZP_SPRITE_DEST_PTR+1
   sec
   sbc #3
   sta ZP_SPRITE_DEST_PTR+1
 }
 else
 {
   .if ( (sprite&3) == 3 )
   {
      inc ZP_SPRITE_DEST_PTR+1
      ldy ZP_SPRITE_DEST_LINE
   }
   else
   {
      tya
      clc
      adc #$3e
      tay
   }
 }
}
   inc ZP_WINDOW_FETCH_POS
   lda ZP_SPRITE_DEST_LINE
   clc
   adc #3
   cmp #$3f
   bne !skip+
   ldx ZP_SPRITE_DEST_INDEX
   lda sprite_lookup_table,x
   sta ZP_SPRITE_DEST_PTR
   lda sprite_lookup_table+8,x
   sta ZP_SPRITE_DEST_PTR+1
   inx
   cpx #8
   bne !skip2+
   ldx #0
!skip2:
   stx ZP_SPRITE_DEST_INDEX
   lda #0
!skip:
   sta ZP_SPRITE_DEST_LINE
   rts

.pc = * "font data"
font_data:
   .import binary "line-twist-scroll/scroll.fnt"

.pc = * "text"
scrolltext:
   .import binary "line-twist-scroll/scroll.txt"
   .fill 5, 0
   .byte $ff

.pc = * "lookup_tables"
font_lookup_lo:
   .fill 32, <(font_data+33*3*i)
font_lookup_hi:
   .fill 32, >(font_data+33*3*i)
   
.pc = * "lookup tables"
lookup_table_y:
   .fill 9, 0
   .fill 10, 1
   .fill 10, 2
   .fill 10, 3
   .fill 10, 4
   .fill 10, 5
   .fill 10, 6
   .fill 10, 7
   .fill 10, 8
   .fill 10, 9
   .fill 10, 10
   .fill 10, 11
   .fill 9, 12
.if ( *-lookup_table_y != 128 ) .error "incorrect table size"

.align $100
.pc = * "sinus tables"
sinus_table: // curve table
   //.fill 256, ($18+65+165.9*(1+sin(i*PI/128))/2)/2
   //.fill 256, 200
   .fill 256, ($18+41+190.9*(1+sin(i*PI/128))/2)/2
   //.fill 256, ($18+65+141.9*(1+sin(i*PI/128))/2)/2
cosin_table2: // derived table
   //.fill 256, 170.9/4
   .fill 256, (170.9*(1-cos(i*PI/128))/2)/2
cosin_table1: // derived table
   // possible optimalization is to read from cosin_table2 and lsr
   //.fill 256, 84.9/4
   .fill 256, (84.9*(1+cos(i*PI/128))/2)/2

.pc = * "init code for test"
test_init_routine:
.if ( GENERATE_CODE_FOR_TEST )
{
   lda #$09
   sta $d021
   lda #$06
   sta $d020
   lda #$80
   sta $d018
   lda #VIC_BANK_C000
   sta VIC_BANK_SELECT_REGISTER
   lda #SCRY_DEFAULT_MODE_BM
   sta SCREEN_CONTROL_REGISTER_Y
   lda #SCRX_DEFAULT_MODE_MC
   sta SCREEN_CONTROL_REGISTER_X
   CopyMem( koala_colors, $d800, 1000 )
   CopyMem( layout_source, layout, 1000 )

   lda #PP_RAM_ONLY
   sta PROCESSOR_PORT
   CopyMem( bitmap_source, bitmap, 8000 )
   lda #PP_VIC_ONLY
   sta PROCESSOR_PORT
   rts

koala_colors:
   .import binary "line-twist-scroll/image.col"
bitmap_source:
   //.fill 8000, 0
   .import binary "line-twist-scroll/image.dat"

layout_source:
   .import binary "line-twist-scroll/image.lay"
}
