#version 430
layout(location = 0) uniform vec4 iResolution;
layout(location = 1) uniform int iFrame;
#define pi (acos(-1.))

const int matDiffuse=0;
const int matMirror=1;
const int matBlack=2;
const int matLiquid=3;
const int matFloor=4;
const int matLight=5;
const int matPlastic=6;
const int matBound=7;
const int matPipe=8;
const vec3 lightpos=vec3(19.,12.,-23.);
#define Epsilon 1.000001
#define pixelRadius 0.0001

float stupid = 0;

//A single iteration of Bob Jenkins' One-At-A-Time hashing algorithm.
uint hash( uint x ) {
    x += ( x << 10u );
    x ^= ( x >>  6u );
    x += ( x <<  3u );
    x ^= ( x >> 11u );
    x += ( x << 15u );
    return x;
}

//float seed;
//float hash() {
//	float p=fract((seed++)*.1031);
//	p+=(p*(p+19.19))*3.;
//	return fract((p+p)*p);
//}
//
//vec2 hash2() {
//    return vec2(hash(),hash());
//}

// Construct a float with half-open range [0:1] using low 23 bits.
// All zeroes yields 0.0, all ones yields the next smallest representable value below 1.0.
float floatConstruct( uint m ) {
    const uint ieeeMantissa = 0x007FFFFFu; // binary32 mantissa bitmask
    const uint ieeeOne      = 0x3F800000u; // 1.0 in IEEE binary32

    m &= ieeeMantissa;                     // Keep only mantissa bits (fractional part)
    m |= ieeeOne;                          // Add fractional part to 1.0

    float  f = uintBitsToFloat( m );       // Range [1:2]
    return f - 1.0;                        // Range [0:1]
}

// Pseudo-random value in half-open range [0:1].
vec2 random( uvec2  v ) {stupid++; return vec2(floatConstruct(hash( v.x ^ hash(v.y))),floatConstruct(hash( v.y ^ hash(v.x))));}

vec2 uv;
vec2 rotate(vec2 a, float b)
{
    float c = cos(b);
    float s = sin(b);
    return vec2(
        a.x * c - a.y * s,
        a.x * s + a.y * c
    );
}

float fOpUnionRound(float a, float b, float r) {
	vec2 u = max(vec2(r - a,r - b), vec2(0));
	return max(r, min (a, b)) - length(u);
}

    /// Returns a point on a sphere, r is in 0..1 range
vec3 pointOnSphere(vec2 r) {
    r=vec2(6.283185*r.x,2.*r.y-1.);
    return vec3(sqrt(Epsilon-r.y*r.y)*vec2(cos(r.x),sin(r.x)),r.y); // 1.001 required to avoid NaN
}
 
    /// Returns a cosine weighted sample
vec3 lambertSample(vec3 n,vec2 r) {
    return normalize(n*Epsilon+pointOnSphere(r)); // 1.001 required to avoid NaN
}

vec4 iCylinderInverse( in vec3 ro, in vec3 rd, 
                in vec3 cb, in vec3 ca, float ra ) // extreme a, extreme b, radius
{
    vec3  oc = ro - cb;
    
    float card = dot(ca,rd);
    float caoc = dot(ca,oc);
    
    float k2 = 1.            - card*card;
    float k1 = dot(oc,rd) - caoc*card;
    float k0 = dot(oc,oc) - caoc*caoc - ra*ra;
    
    float h = k1*k1 - k2*k0;
    if( h<0.0 ) return vec4(-1.0);
    h = sqrt(h);
    float t = (-k1+h)/k2;

    // body
    float y = caoc + t*card;
    return vec4( t, (oc+t*rd - ca*y)/-ra );
}

float iCylinder( in vec3 ro, in vec3 rd, 
                in vec3 cb, in vec3 ca, float ra ) // extreme a, extreme b, radius
{
    vec3  oc = ro - cb;
    
    float card = dot(ca,rd);
    float caoc = dot(ca,oc);
    
    float k2 = 1.            - card*card;
    float k1 = dot(oc,rd) - caoc*card;
    float k0 = dot(oc,oc) - caoc*caoc - ra*ra;
    
    float h = k1*k1 - k2*k0;
    if( h<0.0 ) return -1.0;
    h = sqrt(h);
    return (-k1-h)/k2;
}

// plane degined by p (p.xyz must be normalized)
float plaIntersect( in vec3 ro, in vec3 rd, in vec4 p )
{
    return -(dot(ro,p.xyz)+p.w)/dot(rd,p.xyz);
}

// sphere of size ra centered at point ce
vec4 sphIntersect( in vec3 ro, in vec3 rd, in vec3 ce, float ra )
{
    vec3 oc = ro - ce;
    float b = dot( oc, rd );
    float c = dot( oc, oc ) - ra*ra;
    float h = b*b - c;
    if( h<0.0 ) return vec4(-1.0); // no intersection
    h = sqrt( h );
    float t = (-b-h);
    return vec4( t, (oc+t*rd)/ra );
}

float sdRoundBox( vec3 p, vec3 b, float r )
{
  vec3 q = abs(p) - b;
  return length(max(q,0.0)) + min(max(q.x,max(q.y,q.z)),0.0) - r;
}

float sdSphere( vec3 p, float s )
{
  return length(p)-s;
}

float sdRoundedCylinder( vec3 p, float ra, float rb, float h )
{
  vec2 d = vec2( length(p.xz)-2.0*ra+rb, abs(p.y) - h );
  return min(max(d.x,d.y),0.0) + length(max(d,0.0)) - rb;
}

float sdCylinder( vec3 p, float c )
{
  return length(p.xz)-c;
}

vec2 hash2( float p ) {
	vec3 p3 = fract(vec3(p) * vec3(.1031, .1030, .0973));
	p3 += dot(p3, p3.yzx + 33.33);
    return fract((p3.xx+p3.yz)*p3.zy);
}

// Plane with normal n (n is normalized) at some distance from the origin
float fPlane(vec3 p, vec3 n, float distanceFromOrigin) {
	return dot(p, n) + distanceFromOrigin;
}

vec3 opCheapBend(in vec3 p )
{
    const float k = 10.0; // or some other amount
    float  c = cos(k*p.z);
    float  s = sin(k*p.z);
    mat2   m = mat2(c,-s,s,c);
    return vec3(m*p.zx,p.y).yzx;
}

// hacky parameter to control the size
float T=4.;

int mat;
float inv;

// distance function
float sdScene(vec3 p)
{
    mat = matBlack;
    float d = 1e9;
    
    //d = min(d,sdSphere(p,T));
    
    float top = sdRoundedCylinder(p-vec3(0,10.7,0), 0.3*T, 0.1*T, 0.35*T);
    top = fOpUnionRound(top,sdRoundedCylinder(p-vec3(0,12.5,0), 0.25*T, 0.05*T, 0.15*T),0.2);
    top = fOpUnionRound(top,sdRoundedCylinder(p-vec3(0,15,0), 0.08*T, 0.05*T, 0.6*T),0.2);
    top = fOpUnionRound(top,sdRoundedCylinder(p-vec3(0,16.2,0), 0.1*T, 0.05*T, 0.25*T),0.2);
    top = fOpUnionRound(top,sdRoundedCylinder(p-vec3(0,16.7,0), 0.23*T, 0.15*T, 0.01),0.2);
    top = fOpUnionRound(top,sdRoundedCylinder(p.xzy-vec3(0,2.5,17.-p.z*p.z*0.03), 0.06*T, 0.05*T, 0.5*T),0.2);    
    
    float glass = min( 
    max(
    sdRoundedCylinder(p, 0.85*T, 0.2*T, 0.75*T),
    -sdSphere(p+vec3(0,6.7*T,0),6.0*T)),
    max(
    sdSphere(p*vec3(1.0,3.6/T,1.0)-vec3(0,0.75*3.6,0),1.7*T),
    2.0-p.y)
    );
    
    float tube = sdCylinder(p+vec3(0.,0.,sin(p.y/4.)-0.9), 0.15*T);
    //if (max(tube,glass) < d) {mat = matPipe;}  

    top = max(top,-glass);   
    glass = fOpUnionRound(glass,top,0.2);
    top = max(top,-glass);
    glass = max(glass,-tube);
    
    if (top < d) {mat = matPlastic;}
    d=min(d,top);
    
    if (glass < d) {
    /*if (abs(p.y)<2.7) mat = matPlastic;
    else mat = matLiquid;*/
        if (tube > glass) {
            mat = matLiquid;
        } else {
        if (p.y > 8.) {
            mat = matPlastic;
        } else {
            mat = matPipe;
        }
        }
    }
    d = min(d, glass);
    //vec3 q = opCheapBend(p);

    //d = min(d,max(tube,glass));

    /*float top = min(
    sdRoundedCylinder(p, 0.85*T, 0.2*T, 0.75*T),
    );*/
    
    float fl= fPlane(p,vec3(0,1,0),4.);
       if (fl < 1e9) {mat = matDiffuse;}
    d=min(1e9,fl);
    
    return inv*d;
}

// intersection function
vec4 iScene(vec3 ro, vec3 rd)
{
    mat = matBound;
    float innerScene = iCylinder(ro,rd,vec3(0.),vec3(0.,1.,0.),1.7*T);
    if (innerScene > 0. && (ro+rd*innerScene).y >= -4.) return vec4(innerScene,0.,0.,0.);
    mat = matLight;
    vec4 light = sphIntersect(ro,rd,lightpos,2.);
    if (light.x > 0.) return light;
    mat = matDiffuse;
    float plane = plaIntersect(ro, rd, vec4(0,1,0,4));
    if (plane > 0. && (ro+rd*plane).x >= -10.) return vec4(plane, 0.,1.,0.);
    vec4 curve = iCylinderInverse(ro,rd, vec3(-10.,11.,0.), vec3(0.,0.,1.),15.);
    if (curve.x > 0. && ro.x+rd.x*curve.x <= -10.) return curve;
}

float sceneAndLight(vec3 p)
{
    float d = inv*sdScene(p);
    float l = sdSphere(p-lightpos,1.);
    if (l < d) {mat = matLight;}
    d=min(d,l);
    return inv*d;
}

float err(float dist){
    dist = dist/100.0;
    return min(0.01, dist*dist);
}

vec3 dr(vec3 origin, vec3 direction, vec3 position){
    const int iterations = 3;
    for(int i = 0; i < iterations; i++){
        position = position + direction * (sdScene(position) - err(distance(origin, position)));
    }
    return position;
}

vec2 rv2;
vec2 rva[20];
int truebounce;
int bounce;

vec3 trace(vec3 cam, vec3 dir)
{
    const vec3 lightdir = normalize(vec3(.7,.4,-1));
    
    const float THRESHOLD = .02;

    //for (int i = 0; i < 20; i++) {
    //    rv2=random(uvec2(abs(rv2*2000.)));
    //    rva[i] = rv2;
    //}

    vec3 accum = vec3(1);
    bool didBounce=false;
    bool inside = false;
    bool boundBreak = false;
    truebounce = 0;
    for(bounce=0;bounce<3;++bounce)
    {
        float t;
        float k;
        vec3 n;
        vec3 h;
        bool hit = false;
        //rv2 = rva[abs(bounce)];
        if (bounce > truebounce) {
            rv2 = random(uvec2(abs(rv2*2000.)));
        }
        truebounce = bounce;
        boundBreak = false;
 
        if (length(cam.xz) > 1.7*T+THRESHOLD) {
            vec4 scene = iScene(cam,dir);
            if (scene.x > 0.) 
            {
                t = scene.x;
                n = scene.yzw;
                h = cam+dir*t;
                k = THRESHOLD;
            }
        } else {
            inv = inside ? -1. : 1.;
            t = 0.;
            k = 0.;
            for(int i=0;i<80;++i)
            {
                k = sdScene(cam+dir*t);
                if (abs(k) < THRESHOLD) {
                    h = dr(cam,dir,cam+dir*t);
                    vec2 o = vec2(.001, 0);
                    n = normalize(vec3(
                    sdScene(h+o.xyy)-sdScene(h-o.xyy),
                    sdScene(h+o.yxy)-sdScene(h-o.yxy),
                    sdScene(h+o.yyx)-sdScene(h-o.yyx)
                    ));
                }
                t += k;
                vec3 pos = cam+dir*t;
                if (length((pos).xz) > 1.7*T+THRESHOLD) {
                    k = THRESHOLD;
                    mat = matBound;
                    h = cam+dir*t;
                    break;
                }
                if (pos.y > 25.) {
                return vec3(0);
                }
            }
            //if (boundBreak) continue;
        }
        

        
        if (abs(k)<=THRESHOLD) {
            // if we hit something

            float fresnel = pow(1.-dot(-dir,n),5.);
            fresnel*=1.-step(.99,fresnel);
            
            // debug normals visualization
            //if (mat != matBound)
            //return (n*.5+.5) * (.7+.3*step(1.4,length(step(.1,fract(h.xz-.5)))));

            if (mat == matBound) {
                cam = h;// + dir * THRESHOLD;
                bounce--;
                boundBreak = true;
                continue;
            }
            else if (mat == matDiffuse)
            {
                // bounce the ray in a random direction
                dir = lambertSample(n,rv2);
                accum *= dot(dir,n);
            }
            else if (mat == matLight)
            {
                return accum * vec3(10.,11.,12.) * 6. * step(.8,dot(dir,lightdir));
            }
            else if (mat == matBlack)
            {
                accum *= fresnel*.99+.01;
                dir = reflect(dir,n);
            }
            else if (mat == matPlastic)
            {
                if (rv2.y < 0.02) {
              dir = reflect(dir, n);
                 } else {
                 dir = lambertSample(n, rv2.yx);
                 }
              accum *= fresnel*.1+.9;
              accum *= dot(dir,n);
            }
            else if (mat == matMirror)
            {
                n += sin(h*4.).bgr*.001;
                n += sin(h*3.77).bgr*.001;
                n += sin(h*.737).bgr*.001;
                
                accum *= fresnel*.7+.3;
                dir = reflect(dir,n);
            }
            else if (mat == matFloor)
            {
                // grid lines
                float gridscale=2.;
                vec3 a = 1.-step(.49,abs(fract(h*gridscale)-.5));
                float f=min(a.z,a.x);
            
                // checkerboard
                gridscale=.25;
                h.xz++;
                f*=.8-step(.0,(fract(h.x*gridscale)-.5)*(fract(h.z*gridscale)-.5))*.3;
            
                dir = lambertSample(n,rv2);
            	accum *= f;
            }
            else if (mat == matLiquid || mat == matPipe)
            {     
               /* if (abs(h.y)<2.7) {
            
                                // Find reflection angle, accounting for surface roughness
                    vec3 dir = normalize( // Ray dir must be normalised
                          mix( // Mix between...
                              reflect(dir, n), // the reflected angle
                              lambertSample(n, rv2), // and a random angle projected into the surface
                              0.02 // based on how smooth the glass surface is
                              )
                          );
                          accum *= fresnel*.7+.3;
                          }*/
                          
    
                // Randomly reflect or refract, probability based on fresnel term
                // If non-fresnel, refract
                if (rv2.x > fresnel) {
                    // refraction
                    // Index of refraction
                    float ior = mat == matLiquid ? inside ? 1.364 : 1./1.364: inside ? 1.460/1.364 : 1.364/1.460;
        
                    // Find refraction angle, accounting for surface roughness
                    vec3 rayDir = normalize( // Ray dir must be normalised
                          mix( // Mix between...
                              refract(dir, n, ior), // the refracted angle
                              lambertSample(-n, rv2), // and a random angle projected into the surface
                              mat == matLiquid ? 0.01 : 0.05 // based on how smooth the glass surface is
                              )
                          );
        
                    // Test for total internal reflection
                    if(dot(n, dir) < 0.0) {
                        // Not TIR, we're OK to refract
            
                        // Set the ray direction
                        dir=rayDir;
            
                        // Flip the inside value as we pass through the surface
                        inside=!inside;
                        bounce--;
                        cam = h + dir * 2. * max(THRESHOLD * 4.,abs(k));

                        didBounce=inside;
                        if (!inside) {
                        accum *= vec3(1.) - t * vec3(0.,0., mat == matLiquid ? 0.01 : 0.02);
                        }
                        continue;
                    }
                }
    
                // Ray failed to refract, therefore reflection
                accum *= fresnel*.7+.3;
                dir = reflect(dir,n);
            }
            
            cam = h + dir * THRESHOLD * 1.1 / dot(dir,n);

			didBounce=true;
        }
        else break;
    }
    /*dir = normalize(lightpos-cam);
    
    inv = inside ? -1. : 1.;
    omega = 1.;
    t = 0.;
    candidate_error = 1e9;
    candidate_t = t;
    previousRadius = 0.;
    stepLength = 0.;
    for(int i=0;i<150;++i)
    {
        float signedRadius = sceneAndLight(dir*t + cam);
        float radius = abs(signedRadius);
        bool sorFail = omega > 1. &&
        (radius + previousRadius) < stepLength;
        if(sorFail) {
        stepLength -= omega*stepLength;
        omega = 1.;
        }else{
        stepLength = signedRadius*omega;
        }
        
        previousRadius = radius;
        float error = radius / t;
        if(!sorFail && error < candidate_error) {
        candidate_t = t;
        candidate_error = error;
        }
        
        if(!sorFail && error < pixelRadius || t > 100000.)
        break;
        t += stepLength;
    }
    
     if(abs(stepLength)<THRESHOLD && t <= 1e6 && candidate_error < pixelRadius && mat == matLight)
        {
        //return vec3(1.,0.,0.);
        accum *= 200.;
        }*/
    
    
    if(!didBounce) {
        vec3 background = 0.5 + 0.5*cos(uv.xyx+vec3(0,2,4));
        if (accum == vec3(1.)) {
            accum = background;
        } else {
        accum *= background;
        }
        }
    
    //float light = 2.5*step(.7,dot(dir,lightdir));
    return vec3(0.);// accum/10.;// * light;
}

vec2 ringDof(vec2 seed)
{
    seed=fract(seed);
    if (seed.y>seed.x)
        seed=1.-seed;
    float r=seed.x;
    float a=(seed.y/seed.x)*pi*2.;
    return vec2(cos(a),sin(a))*r;
}

void main()
{
    // grab the previous color so we can iteratively render.
    // in the actual executable I just rendered additively to a single framebuffer instead
   	// fragColor = texture(iChannel0,fragCoord/iResolution.xy);
    
    uv = gl_FragCoord.xy/iResolution.xy-.5;

    // random function borrowed from I can't remember where
    float seed = float(((int(iFrame*73856093))^int(gl_FragCoord.x)*19349663^int(gl_FragCoord.y)*83492791)%38069);
	rv2 = hash2( 24.4316544311+iFrame+seed );
    //rv2 = random(uvec2(normalize(abs(vec2(seed, 24.4316544311+iFrame+seed)))*20000.0));

    
    // jitter camera for antialiasing
    uv += (rv2-.5)/iResolution.xy;
    
    // correct UVs for aspect ratio
    uv.x*=iResolution.x/iResolution.y;
    
    // make a camera
	vec3 cam = vec3(1.,5.,-80.);
    vec3 dir = normalize(vec3(uv,2.5));

    // slight jitter for dof
    //const float dofScale = .05 ;
    //const float dofDist = 10.;
    //vec2 dofJitter = ringDof(rv2);
    //cam.xy += dofJitter*dofScale;
    //dir.xy -= dofJitter*dofScale/dofDist;

    // spin it to an isometric angle
    cam.yz = rotate(cam.yz, pi/16.);
    dir.yz = rotate(dir.yz, pi/16.);
    
    // debug camera rotation
    //if (iMouse.z > 0.) {
    //    float a = .8-2.*(iMouse.y/iResolution.y);
    //	cam.yz = rotate(cam.yz, a);
    //	dir.yz = rotate(dir.yz, a);
    //}

    // spin it to an isometric angle
    cam.xz = rotate(cam.xz, pi/2.);
    dir.xz = rotate(dir.xz, pi/2.);
    
    // debug camera rotation
    //if (iMouse.z > 0.) {
    //    float a = 1.-4.*(iMouse.x/iResolution.x);
    //	cam.xz = rotate(cam.xz, a);
    //	dir.xz = rotate(dir.xz, a);
    //}
    
    // compute the pixel color
    vec3 pixel = vec3(0);
    for (int i = 0; i < 8; i++) {
        pixel += trace(cam,dir);
        //trace(cam,dir);
        //pixel += vec3(stupid)/8.;
        //stupid = 0;
    }
    pixel /= 8.;
   
    // reset buffer if we're clicking
    // if (iMouse.z > 0.) gl_FragColor *= .1;

    // accumulate the pixel
    if(pixel.r >= 0.)
    gl_FragColor += vec4(pixel,1);
    
    //gl_FragColor = vec4(random(uvec2(abs(uv*1000.))),1.0,1.0);
}