#version 330 core
out vec4 FragColor;

in vec3 ourColor;
in vec2 TexCoord;

uniform vec2 u_resolution;
uniform float u_time;

// texture sampler
uniform sampler2D texture15;

#define PI 3.14159265359

float plot(vec2 st, float pct) 
{
 return smoothstep( abs(cos(u_time / PI)), sqrt(sin(PI / pct + st.y)) 
 + ceil( st.y * PI / pct), pow( PI * -4.0, pct)) - smoothstep(st.y, pct * PI, st.x + abs(cos(st.y / u_time)));
}

void main()
{
	//vec2 st = gl_FragCoord.xy/u_resolution;
	// same as:
	vec2 st = gl_FragCoord.xy/vec2(u_resolution.y / PI, u_resolution.x - PI );
	
	float y = pow((sin(st.x - st.y)), 0.5 * abs(cos(u_time)));
	
	vec3 color = vec3( st.x, st.y - 0.1, abs(cos(u_time - PI - st.x)));
	
	float pct = plot(st, gl_FragCoord.y + abs(cos(u_time)));
	
	color = (st.x + pct / PI * 2.0f) * (st.y / color.z) * (abs(PI * color.y)) * vec3(0.7, 0.7, 0.7);
	
	//color = color - (pct / u_time); 
	
	gl_FragColor = texture(texture15, TexCoord) * vec4(color, 1.0);
}
//FragColor = texture14(texture1, TexCoord);