#version 330 core
out vec4 FragColor;

uniform vec2 u_resolution;
uniform float u_time;

#define PI 3.14159265359

float plot(vec2 st, float pct) 
{
 return smoothstep( abs(tan(u_time / PI)), sqrt(sin(pct)) 
 + log( st.y * PI), sign( PI * -20.0 + pct)) - smoothstep(st.y, pct * PI, st.x + abs(cos(st.x * u_time)));
}

void main()
{
	vec2 st = gl_FragCoord.xy/u_resolution;
	
	float y = pow((sin(st.x - st.y)), 0.5 * abs(cos(u_time)));
	
	vec3 color = vec3( st.x, st.y, abs(cos(u_time - PI - st.x)));
	
	float pct = plot(st, gl_FragCoord.y + abs(cos(u_time)));
	
	color = (st.x + pct) * color * (abs(PI * st.x)) * vec3(0.7, 0.7, 0.3);
	
	gl_FragColor = vec4(color, 1.0);
}
