	.title fractal
	.sbttl (C) 2021 Stanislav Maslovski <stanislav.maslovski@gmail.com>, all rights reserved.
	.psect text
	.=.+1000
	mov     #2*400+330, r0
	mov	r0, @#177664			; set scroll reg
	mtps	r0				; also mask interrupts
	mov	#11.*400, @#177662		; set pallete
	mov     #^b0001111100000000, @#177716   ; set system reg
;************************************************************
; Fixpoint squares up to approx. 8.0^2, 11 significant bits
; operand-index: 0000XXX.X XXXXXXX0
; result:        0XXXXXX.X XXXXXXX0
; In this scale, 1.0 decimal = 1000 octal
;************************************************************
r6	=	%6
sqr	=	20000		; table base
;************************************************************
	clr	r0		; 7 lower bits in high byte
	clr	r1		; higher 11+1 bits
	clr	r2		; operand-index
	mov	#sqr, r4	; for lower half-table
	mov	r4, r5		; for upper half-table
fsqr:
	mov	r1, (r5)+	; to upper half tbl
	inc	r2		; R2 = x + 2^-9
	mov	r2, -(r6)
	asl	r2		; R2 = 2*x + 2^-8
	swab	r2		; LLLLLL00 00HHHHHH
	movb	r2, r3		; 00000000 00HHHHHH
	add	r2, r0		; add up lower bits
	adc	r1		; add carry to r1
	add	r3, r1		; R1:R0 = x^2 + 2^-8*x + 2^-16
	mov	r1, -(r4)	; to lower half tbl
	mov	(r6)+, r2
	bcs	mdlbrt		; exit on overflow
	inc	r2
	br	fsqr
;************************************************************
niter	=	7
max2	=	4000		; 4.0
dx	=	-14*3
dy	=	6*3
x0	=	-76*dx
mx	=	12*dx		; x move
sf4	=	664/4		; sf/4
;************************************************************
mdlbrt:
	mov	#100000, r0	; last screen address
	mov	#max2+4, r6	; set stack and the limit
	mov	dya, r5
	swab	r5
	asr	r5		; r5 = 200*dy = b
loop0:
x0a	=	.+2
	mov	#x0, r4		; r4 = a
loop1:
	mov	r0, -(r6)	; push address on stack
	clr	r1		; clear
	inc	r1		;   pixels
loop2:
	mov	r1, -(r6)	; push mask on stack
	add	dxa, r4		; update a
nitera	=	.+2
	mov	#niter, r2	; max iter. count
	mov	r4, r0		; r0 = x = a
	mov	r5, r1		; r1 = y = b
1$:
	mov	sqr(r1), r3	; r3 = y^2
	add	r0, r1		; r1 = x+y
	mov	sqr(r0), r0	; r0 = x^2
	add	r3, r0		; r0 = x^2+y^2
	cmp	r0, r6		; if r0 >= 4.0 then
	bge	2$		; overflow
	mov	sqr(r1), r1	; r1 = (x+y)^2
	sub	r0, r1		; r1 = (x+y)^2-x^2-y^2 = 2*x*y
	add	r5, r1		; r1 = 2*x*y+b, updated y
	sub	r3, r0		; r0 = x^2
	sub	r3, r0		; r0 = x^2-y^2
	add	r4, r0		; r0 = x^2-y^2+a, updated x
	sob	r2, 1$		; to next iteration
2$:
	mov	(r6)+, r1	; pop mask from stack
	asl	r1		; shift
	asl	r1		;   left
	asl	r1		; shift
	asl	r1		;   left
	bic	#177770, r2	; get 3 bits of color
	beq	3$
patt	=	.+2
	bisb	pat0(r2), r1	; OR the pattern
3$:
	bcc	loop2		; to next pixel
	mov	(r6)+, r0	; pop addr from stack
	mov	r1, -(r0)	; update addr, write to screen
	mov	#^b0011111111000000, r2
	xor	r0, r2		; r2 = address in the top half
	mov	r1, (r2)	; write to screen
	bic	#177700, r2
	bne	loop1		; if not first word in line
	movb	@patt, r1
	add	r1, patt	; switch patterns
	sub	dya, r5		; update b
	bgt	loop0		; continue while b > 0

	add	mxa, x0a	; shift x0

	; scale the params
	mov	#3, r0
	mov	#dxa, r1
4$:
	mov	(r1), r2		; x
	mov	sqr+sf4(r2), (r1)	; (x + sf/4)^2
	sub	sqr-sf4(r2), (r1)+ 	; (x + sf/4)^2 - (x - sf/4)^2 = x*sf
	sob	r0, 4$

	inc	nitera	; increase the iteration count
	br	mdlbrt
;************************************************************
dxa:	.word	dx
dya:	.word	dy
mxa:	.word	mx
pat0:	.byte	10,1,2,3,16,5,12,17
pat1:	.byte	-10,4,10,14,4,5,12,17
	.end
