; [ HerbaKaif ] 512-byte intro :: PC x86 / DOS
; (c) 2021 Jin X (t.me/jinxonik · jin_x@list.ru)
; Main code include file (DOS versions)

; fasm 1.73.11+
; Requires Floating-Point Instruction Bytecode Generator & Recompiler (fpb.inc)

;-----------------------------------------------------------------------------------------------------------------------------------------------;
; I don't smoke and don't advise you too!!! Я не курю и вам не советую!!!                                                                       ;
;-----------------------------------------------------------------------------------------------------------------------------------------------;
; Author does not call anybody for any illegal actions, including the use and distribution of substances prohibited by law!                     ;
; Remember that smoking and use of alcohol and drugs is harmful to health and may violate the law of your country!                              ;
; Image generated but this program is only a demonstration of Floating-Point Instruction Bytecode Generator & Recompiler.                       ;
;-----------------------------------------------------------------------------------------------------------------------------------------------;
; Автор ни в коем случае не призывает к каким-либо противоправным действиям, в т.ч. употреблению и распространению запрещённых законом веществ! ;
; Помните, что курение и употребление алкоголя и наркотических веществ вредно для здоровья и может нарушать законодательство вашей страны!      ;
; Изображение, генерируемое программой, является лишь демонстрацией работы генератора и рекомпилятора байткода инструкций FPU.                  ;
;-----------------------------------------------------------------------------------------------------------------------------------------------;

;-- INTERNAL SETTINGS --------------------------------------------------------------------------------------------------

include 'xmac16s.mac'				; useful macros

unidos		=	0
dosbox		=	1
mbr		=	2

pcspk		=	0
covox		=	1
sb		=	2

ifdo version = dosbox, \
  <support_check = support_check and 2>

; FPB settings
define	fpb_copy_support 0			; disable native code copier support
define	fpb_var_support 1			; enable variable support
define	fpb_before_ret sti			; one-byte native instruction before 'ret' in recompiled function
;fpb_data_offset =	vars-consts		; offset of constants and variables (see comments in 'fpb.inc')

include 'fpb.inc'				; include fpb generator & recompiler
fpb_check_version 1,0,0				; check fpb module version

@soft_error_msg_if version = mbr, "This include file is not for MBR version!"

; Declare fpb bytecode instructions
declare_fpb	+, faddp
declare_fpb	-, fsubp
declare_fpb	*, fmulp
declare_fpb	/, fdivp
declare_fpb	x2, fadd st0,st0
declare_fpb	^2, fmul st0,st0
declare_fpb	abs, fabs
declare_fpb	sqrt, fsqrt
declare_fpb	sin, fsin
declare_fpb	cos, fcos
declare_fpb	arctg, fpatan

; Error message code and jumps
error_msg_present = 0
macro		check_error_msg msg*
{
  if ~ error_msg_present
		jz	@F
    ifdo error_msg, \
		<mov	dx,msg>
	.error:
    ifdo error_msg, \
		<xchg	ax,bp>, \
		<int	$21>
		ret
	@@:
    error_msg_present = 1
  else ; error_msg_present
    ifdo error_msg, \
		<mov	dl,msg and $FF>
		jnz	.error
  end if ; ...error_msg_present...
} ; error_msg!

;-- MAIN CODE ----------------------------------------------------------------------------------------------------------

org	$100

		; Assume: ax = bx = 0, dx = cs, si = $100, bp = $9??, cs = ds = es = ss
		; (not used: cx = $FF, di = sp = $FFFE, cf = 0)

		; Prepare to set unreal mode (this code must be placed here, ax = 0)
		; byte at offset $105 must be one of the following: $92, $93, $B2, $B3, $D2, $D3, $F2, $F3
		; byte at offset $106 must be one of the following: $8x, $9x, $Cx, $Dx, $Ax, $Bx, $Ex, $Fx (where x is high nibble of memory limit, should be $F for non-DOSBox systems)
if version = unidos
		mov	di,bp			; [opcode = $EF89 - descriptor $20 starts here]
		pusha				; [GDT descriptor base address doesn't matter]
		mov	edx,ss			; [last byte = $D2; offset = $105: GDT descriptor flags ('P|DPL|S|Type' byte: present, DPL=2 (doesn't matter), code/data, read/write)]
		lahf				; [opcode = $9F; offset = $106: GDT descriptor flags ('G|D/B|L|AVL|HiSegLimit' byte: 4kb granularity, 16-bit, limit hi-nibble=$F {limit = $F[EF89]FFF})]
		shl	edx,4			; segment -> linear address
		mov	[si+8],edx		; write GDT address [value at $106 = $669F - enough limit for GDT :)]
		mov	si,-fpb_nibbles
else ; version = dosbox
		pusha				; [opcode = $60 - descriptor $20 starts here]
;		shl	edx,4			; linear address of code segment [1st byte of opcode = $66; rest of opcode: GDT descriptor base address doesn't matter]
;		db	$93			; [xchg ax,bx; offset = $105: GDT descriptor flags ('P|DPL|S|Type' byte: present, DPL=0 (doesn't matter), code/data, read/write accessed)]
		mov	si,-fpb_nibbles		; [opcode = $BE; offset = $106 (if version = dosbox): GDT descriptor flags ('G|D/B|L|AVL|HiSegLimit' byte: 4kb granularity, 16-bit, limit hi-nibble=$E {limit = $E[6660]FFF})]
		mov	di,bp
;		mov	[bx+$53],edx		; write GDT address [value at $51 = $CB21 - enough limit for GDT :)]
end if ; version...

		; Recompile bytecode to native x86 function (ds = es = cs)
		fpb_recompile! fpb_nibbles, nosi, rcaddr=bx=0 ; insert recompiler code here (doesn't require 'call'), recompile from ds:fpb_nibbles to es:di, don't initialize si (returns cx = 0, bx = 22, al = 1, cf = 1)

		; Enable A20 line
ifdo version = unidos, \
		<inc	ax>, \			; al = 2
		<out	$92,al>			; enable A20 line

		; Check VESA mode support
		mov	ax,$4F01
		mov	cx,$4105		; 1024x768, 256 colors (with LFB access)
		int	$10			; get video mode info to es:di (es:bp + fpb_recompiled_code_size)
ifdo support_check and 4, < \
  ifelif vesa_resolution = 1, \
		<cmp	word [di+$12],1024>, \	; check resolution (width)
         vesa_resolution = 2, \
		<add	ah,byte [di+$12]>, \	; check low byte of width only (and also VESA support)
         else,	<test	ah,ah>>			; check only VESA support (ax = $4F)
		popa
if support_check and 4
		check_error_msg error_mode	; error(?): VESA mode is not supported
end if ; support_check and 4

		; Check V86
@al_zero = 1
ifdo version = unidos, < \
  ifelif opt_level = 0 | opt_level = 1 | opt_level = 2 | support_check and 1, \
	<_	<mov	eax,cr0>, \		; bit 0 = V86 mode
		<@al_zero = 0>>, \
    opt_level = 3, \
		<cwde>>
if support_check and 1
		test	al,1
		check_error_msg error_v86	; error(?): V86 mode
end if ; support_check and 1

		; Set unreal mode (eax = cr0 (ah = 0), bx = 0, si = $100)
ifel version = unidos, \
		<lgdt	[si+6]>;, \		; load GDT table
;		<lgdt	[bx+$51]>		; load GDT table

ifdo version = unidos, \
	<@@:	xor	al,1>, \		; flip bit 0
		<mov	cr0,eax>, \		; switch mode: bit 0 = 1 - protected mode (1st pass), 0 - (un)real mode (2nd pass)
		<xor	bx,si>			; descriptor $20 (1st pass) / 0 (2nd pass)
		mov	es,bx
ifdo version = unidos, \
		<jnz	@B>			; 2nd pass

		; Check memory size and set buffer address (cx = $00FF)
		mov	edi,$180000		; $180000 - buffer address
if support_check and 2
  if frame_count = 8
		mov	[es:edi+edi*4],cx
		xor	cx,[es:edi+edi*4]	; cx = 0 if ok
  else if frame_count = 16
		mov	[es:edi+edi*8],cx
		xor	cx,[es:edi+edi*8]	; cx = 0 if ok
  else
		imul	eax,edi,frame_count/2+1
		mov	[es:eax],cx
		xor	cx,[es:eax]		; cx = 0 if ok
		@al_zero = 1
  end if ; frame_count
		check_error_msg error_mem	; error(?): not enough memory is in the system (word in memory hasn't changed)
end if ; support_check and 2

ifelif sound_align = 0, \
		<mov	word [bx],bx>, \
  sound_align <> -1, \
		<mov	word [bx],sound_align>
		
		; Draw progress bar (ah/ax = 0, bh = 0, ch = 0)
if center_progress
  ifelif frame_count > 40, <mov al,3>, \	; ax = 3
    @al_zero,	<inc	ax>, \			; ax = 1
    else,	<mov	al,1>
		int	$10			; text mode 80x25 or 40x25 (for progress bar)

		mov	ah,2
  ifel frame_count > 40, \
		<mov	dx,$0C28-frame_count/2>, \
		<mov	dx,$0C14-frame_count/2>
		int	$10			; set cursor position to screen center (shifted left)
end if ; center_progress

		mov	ax,$9DB
		mov	bl,$78			; color
		mov	cl,frame_count
		int	$10			; draw bar

if play_sound
		; Intercept timer interrupt and turn timer frequency
		mov	ax,$2500+sound_int
		mov	dx,timer_int
		int	$21			; run sound player

		mov	al,$14			; set lower byte only
		out	$43,al
  ifel version = dosbox | sound_exact_freq, \
		<mov	al,1193182/8000>, \	; ~ 8000 Hz
		<lodsb>				; al = $89 (~ 8709 Hz)
		out	$40,al			; set timer frequency
end if ; play_sound

		; Generate images (es:edi = buffer, cx = frame_count, si = $100 or $101)
ifdo version = unidos, \
		<fninit>
		mov	bx,consts-fpb_data_offset ; constant and variable arrays (with offset correction)
	.nextframe:
		xor	edx,edx			; pixel number
		mov	[bx-(consts-fpb_data_offset)+@fpb_int_i],cx ; i
	.pixel:
		mov	ax,dx
		and	ax,1024-1		; x
		mov	[bx-(consts-fpb_data_offset)+@fpb_int_x],ax
		shld	eax,edx,32-10		; y (cf = 0)
		mov	[bx-(consts-fpb_data_offset)+@fpb_int_y],ax
		call	bp			; call recompiled function
		ftst
		fistp	word [si]		; round and store result
		fnstsw	ax
		salc				; al = 0
		sahf
		jb	.black			; al = 0 if f < 0
		mov	al,[si]			; get result
		cmp	al,63-brightness
		jl	@F
		mov	al,63-brightness	; al = 63-brightness if f > 63-brightness
	@@:	add	al,brightness
	.black:
		stos	byte [es:edi]		; put pixel
		inc	edx
		cmp	edx,1024*768
		jb	.pixel

if break_precalc
		mov	ah,1
		int	$16
		jnz	.reboot			; a key is pressed
  ifdo version = unidos, \
		<salc>
end if ; break_precalc

		int	$29			; increase position of progress bar
		loop	.nextframe

		; Set video mode
		mov	ax,$4F02
		mov	bx,$4105		; 1024x768, 256 colors (with LFB access)
		int	$10			; set video mode (returns ax = $4F)

		; Set palette (cx = 0, dx = 0)
		xchg	ax,dx			; al = 0
		mov	dx,$3C8
		out	dx,al
		inc	dx			; $3C9
	@@:	out	dx,al
		xchg	ax,cx
		out	dx,al			; green
		xchg	ax,cx
		out	dx,al
ifel opt_level <= 2, \
		<inc	cl>, \
		<inc	cx>
		jns	@B

		; Draw images (frames, edi = buffer end, ax = 0, cx = 0)
	.mainloop1:
		mov	esi,$180000
		mov	bx,frame_count
	.mainloop2:
		mov	edi,[bp+fpb_recompiled_code_size+$28] ; edi = LFB address
ifel opt_level <= 3, \
		<push	(1024*768/4) shr 16>, \
		<push	(1024*768/2) shr 16>
		push	es
		pop	ecx			; ecx = 1024*768/4

if frame_sync
		mov	dl,0xDA			; dx = $3DA
	@@:	in	al,dx
		test	al,8			; vertical retrace
		jz	@B
end if ; frame_sync

ifel opt_level <= 3, \
		<rep movs dword [es:edi],[es:esi]>, \
		<rep movs word [es:edi],[es:esi]>

		; Delay and check keyboard (ah = 0, cx = 0, di = 0)
if delay
  if play_sound
	@@:	test	word [si],$80 shl (delay + sound_dbl_len) - 1 - sound_dbl_len ; delay
		jnz	@B
  else ; ~ play_sound
		times delay hlt			; delay
  end if ; play_sound
end if ; delay

		mov	ah,1
		int	$16
		jnz	.reboot			; a key is pressed
		dec	bx
		jnz	.mainloop2
		jmp	.mainloop1
	.reboot:
ifelif version = dosbox, \
		<int	$19>, \			; DOSBox reboot
  version = unidos & opt_level <= 1, \
		<jmp	$F000:$FFF0>, \		; reboot
  else, <_	<mov	al,1>, \
		<out	$92,al>>		; reboot

if play_sound
		; Sound player (timer interrupt handler)


sss:;		dd	$A000

timer_int:
		pusha
  ifdo sound_dev = sb, \
		<mov	dx,$22C>, \
		<mov	al,$10>, \
		<out	dx,al>

		; Calculate sample
		xor	si,si
  ifdo version = unidos, cs
		mov	di,[si]
  ifdo version = unidos, cs
		mov	ax,[si+2]
  ifel sound_dbl_len, \
		<scasw>, \
		<inc	di>
		test	di,sound_pattern and not sound_dbl_len
		jnz	@F
  ifel sound_alt, \
		<salc>, \
		<xor	ax,ax>
	@@:	dec	ah
		jns	.play
		add	al,0x82
		mov	ah,al
		and	ah,0x7F
	.play:
  ifdo version = unidos, cs
		mov	[si],di
  ifdo version = unidos, cs
		mov	[si+2],ax

		; Play sample
  ifdo sound_dev = pcspk & opt_level = 0, \
		<shr	al,6>, \
		<and	al,2>
  ifelif sound_dev = pcspk, \
		<out	$61,al>, \
    sound_dev = covox, \
	<_	<mov	dx,$378>, \
		<out	dx,al>>, \
    sound_dev = sb, \
		<out	dx,al>

  ifdo sound_int = 8, \
		<mov	al,$20>, \
		<out	$20,al>			; send EOI
		popa
		iret
end if ; play_sound

		; Messages
if error_msg
  messages:
  if support_check and 1
    msg_last = $
    ifel error_msg = 1, \
      <error_v86 db	'V86$'>, \
      <error_v86 db	"Can't run in V86!",13,10,'$'>
  end if ; support_check and 1
  if support_check and 2
    msg_last = $
    ifel error_msg = 1, \
      <error_mem db	'LowMem$'>, \
      <error_mem db	'Low memory in system!',13,10,'$'>
  end if ; support_check and 2
  if support_check and 4
    msg_last = $
    ifel error_msg = 1, \
      <error_mode db	'VesaErr$'>, \
      <error_mode db	"VESA mode isn't supported!",13,10,'$'>
  end if ; support_check and 4
  assert ~ defined msg_last | messages shr 8 = msg_last shr 8 ; move this block up or down if assertion failed
end if ; error_msg

		; Floating-point instruction bytecode
fpb_nibbles:
		; Author of original formula is Sukhinov Anton
		; a = arctg(cx - x, y - cy) + sin(i*pi/(frame_count/2)) / 3.5
		; r = sqrt((cx - x)^2 + (y - cy)^2) * scale  ; radius
		; r403 = r^4 * 0.3
		; cosa35mr403 = cos(a*3.5 - r403)
		; cosap7mr403 = cos((a+pi)*7 - r403)
		; arccos_cos = arccos(cosap7mr403)
		; sina2 = sin(a/2)
		;; f1 = 1 / (abs(cosa35mr403) + 0.005/r)  ; outline
		;; f2 = ( sin(a*3.5)^2 / (r^2*10/sina2^2+1) ) / ( abs(sin((r-(arccos_cos+r*arccos_cos^2*2)*0.05)*pi*8)) + 0.1 + cosa35mr403^2 ) * 8  ; spikes
		;; f3 = 3 / ((r*100)^2+0.1)  ; center
		;; f4 = abs(sina2) - r^2  ; very important coefficient :)
		;; f5 = abs(sina2) * (sin(i*in_sin_coef*3)/3+pi/2)  ; thickness of leaf (the smaller, the more lush)
		;; f6 = 0.01 / ((sin(r*cos(a)*100+cos(r*sin(a)*40)*10) + sin(r*sin(a)*100+sin(r*cos(a)*40)*10))^2 + 0.01) + 1  ; this should add some texture on leafs but there're no visible changes here :(
		;; f7 = (r+0.2) * 0.0002 / ((a-r*0.1)^2 + 0.0001)  ; stalk
		;; f = ((f1 + f2 + f3) * f4 - f5) * f6 + f7
		; f = ( (1 / (abs(cosa35mr403) + 0.005/r) + ( sin(a*3.5)^2 / (r^2*10/sina2^2+1) ) / ( abs(sin((r-(arccos_cos+r*arccos_cos^2*2)*0.05)*pi*8)) + 0.1 + cosa35mr403^2 ) * 8 + 3 / ((r*100)^2+0.1)) * (abs(sina2) - r^2) - abs(sina2) * (sin(i*in_sin_coef*3)/3+pi/2) ) * ( 0.01 / ((sin(r*cos(a)*100+cos(r*sin(a)*40)*10) + sin(r*sin(a)*100+sin(r*cos(a)*40)*10))^2 + 0.01) + 1 ) + (r+0.2) * 0.0002 / ((a-r*0.1)^2 + 0.0001)
		; f(f6=1) = (1 / (abs(cosa35mr403) + 0.005/r) + ( sin(a*3.5)^2 / (r^2*10/sina2^2+1) ) / ( abs(sin((r-(arccos_cos+r*arccos_cos^2*2)*0.05)*pi*8)) + 0.1 + cosa35mr403^2 ) * 8 + 3 / ((r*100)^2+0.1)) * (abs(sina2) - r^2) - abs(sina2) * (sin(i*in_sin_coef*3)/3+pi/2) + (r+0.2) * 0.0002 / ((a-r*0.1)^2 + 0.0001)
	fpb_start	consts
		; a = arctg(cx - x, y - cy) + sin(i*in_sin_coef) / 3.5; in_sin_coef = pi/(frame_count/2)
		fpb	cx x - y cy - arctg
		fpb	i in_sin_coef * sin 3.5 / +
		fpb	=a
		; r = sqrt((cx - x)^2 + (y - cy)^2) * scale
		fpb	cx x - ^2 y cy - ^2 + sqrt scale * =r
		; r403 = r^4 * 0.3
		fpb	r ^2 ^2 3 * 0.1 * =r403
		; cosa35mr403 = cos(a*3.5 - r403)
		fpb	a 3.5 * r403 - cos =cosa35mr403
		; cosap7mr403 = cos((a+pi) * 7 - r403)
		fpb	a pi + 3.5 x2 * r403 - cos =cosap7mr403
		; arccos_cos = arccos(cosap7mr403) | arccos(x) = arctg(sqrt(1-x^2), x)
		fpb	1 cosap7mr403 ^2 - sqrt cosap7mr403 arctg =arccos_cos
		; sina2 = sin(a/2)
		fpb	a 1 x2 / sin =sina2

		; f = (1 / (abs(cosa35mr403) + 0.005/r) + ( sin(a*3.5)^2 / (r^2*10/sina2^2+1) ) / ( abs(sin((r-(arccos_cos+r*arccos_cos^2*2)*0.05)*pi*8)) + 0.1 + cosa35mr403^2 ) * 8 + 3 / ((r*100)^2+0.1)) * (abs(sina2) - r^2) - abs(sina2)...
		fpb	1 cosa35mr403 abs 0.005 r / + / a 3.5 * sin ^2 r ^2 10 * sina2 ^2 / 1 + / r arccos_cos r arccos_cos ^2 * x2 + 0.005 * 10 * - pi * 8 * sin abs 0.1 + cosa35mr403 ^2 + / 8 * + 3 r 10 ^2 * ^2 0.1 + / + sina2 abs r ^2 - * sina2 abs
		fpb	i in_sin_coef * 3 * sin 3 / pi 1 x2 / + * ; ... * (sin(i*in_sin_coef*3)/3+pi/2)
		fpb	-			; this minus is for: abs(sina2) * (sin(i*in_sin_coef*3)/3+pi/2)
ifdo full_formula, \ ; f *= 0.01 / ((sin(r*cos(a)*100+cos(r*sin(a)*40)*10) + sin(r*sin(a)*100+sin(r*cos(a)*40)*10))^2 + 0.01) + 1
		<fpb	0.005 x2 r a cos * 10 ^2 * r a sin * 10 x2 x2 * cos 10 * + sin sin r a sin * 10 ^2 * sin r a cos * 10 x2 x2 * 10 * + + ^2 0.005 x2 + / 1 + *>
		; f += (r+0.2) * 0.0002 / ((a-r*0.1)^2 + 0.0001)
		fpb	r 0.1 x2 + 0.0001 x2 * a r 0.1 * - ^2 0.0001 + / +
	fpb_end

		; Constant and variable array (variables address is consts + fpb_data_offset)
	consts = $
		fpb_int	1
		fpb_flt 3.5			; this value must be quite exact (therefore placed here)
		fpb_int	3
		fpb_int	8
		fpb_int	10
		fpb_flt scale, 0.0021
		fpb_flt 0.0001
		fpb_flt 0.005
		fpb_flt 0.1
ifelif frame_count = 8,  <fpb_flt in_sin_coef, 0.7853981633974>, \ ; in_sin_coef = pi/(frame_count/2)
       frame_count = 10, <fpb_flt in_sin_coef, 0.628318530718>, \
       frame_count = 12, <fpb_flt in_sin_coef, 0.5235987755983>, \
       frame_count = 14, <fpb_flt in_sin_coef, 0.4487989505128>, \
       frame_count = 16, <fpb_flt in_sin_coef, 0.3926990816987>, \
       frame_count = 18, <fpb_flt in_sin_coef, 0.3490658503989>, \
       frame_count = 20, <fpb_flt in_sin_coef, 0.314159265359>, \
       frame_count = 24, <fpb_flt in_sin_coef, 0.2617993877991>, \
       frame_count = 28, <fpb_flt in_sin_coef, 0.2243994752564>, \
       frame_count = 32, <fpb_flt in_sin_coef, 0.1963495408494>, \
       frame_count = 36, <fpb_flt in_sin_coef, 0.1745329251994>, \
       frame_count = 40, <fpb_flt in_sin_coef, 0.1570796326795>, \
       frame_count = 48, <fpb_flt in_sin_coef, 0.1308996938996>, \
       frame_count = 56, <fpb_flt in_sin_coef, 0.1121997376282>, \
       frame_count = 64, <fpb_flt in_sin_coef, 0.09817477042468>, \
       frame_count = 72, <fpb_flt in_sin_coef, 0.08726646259972>, \
       frame_count = 80, <fpb_flt in_sin_coef, 0.07853981633974>, \
       else, <_ \
         <display 10,"Wrong value of 'frame_count'!">, \
         <display 10,"-----------------------------">, \
         <err>>
		fpb_flt	pi, 3.14159265359
		fpb_flt cx, 511.5		; (1024-1) / 2
		@fpb_flt_cy = @fpb_flt_cx
		fpb_int i, ?
		fpb_int x, ?
		fpb_int y, ?
ifdo fpb_data_offset = 0, \
		<rw	1>			; alignment of variables
	vars = $
		fpb_var	a
		fpb_var	r
		fpb_var	r403
		fpb_var	cosa35mr403
		fpb_var	cosap7mr403
		fpb_var	arccos_cos
		fpb_var	sina2

;-----------------------------------------------------------------------------------------------------------------------

; ┌─── ───────── ───────────────────────── ────────── -··
; │ ┌─── ───────── ───────────────────── ────────── ────┐
; │ │ ┌─── ───────── ───────────────── ▄▄▄▄▄▄▄▄▄─ ────┐ │
; │ │ │ ┌─── ───────── ───────────── ▄▀      ▄▀ ────┐ │ │
; │ │ │ │ ┌─── ▄▄▄▄▄▄▄▄▄ ────────  ▄▀      ▄▀ ────┐ │ │ │
; │ │ │ │ │     ▀▄      ▀▄       ▄▀      ▄▀     : │ │ │ │
; │ │ │ │ │       ▀       ▀▄   ▄▀      ▄▀       │ │ │ │ │
; │ │ │ │ │  ████████████▀  ▀▄▀ ▄██▀ ▄▀   ▄███  │ │ │ │ │
; │ │ │ │ │         ▄██▀      ▄██▀ ▄▀   ▄██▀██  │ │ │ │ │
; │ │ │ │ │       ▄██▀  ▀▄  ▄██▀ ▄▀   ▄██▀  ██  │ │ │ │ │
; │ │ │ │ │     ▄██▀   ▄▀ ▄██▀    ▀ ▄██▀    ██  │ │ │ │ │
; │ │ │ │ │   ▄██▀   ▄▀ ▄██▀ ▄    ▄██▀      ██  │ │ │ │ │
; │ │ │ │ │  ▀▀▀   ▄▀  ▀▀▀ ▄▀ ▀▄ ▀▀▀  ▀▄    ▀▀  │ │ │ │ │
; │ │ │ │ :      ▄▀      ▄▀     ▀▄      ▀▄      │ │ │ │ │
; │ │ │ └───── ▄▀      ▄▀ ─────── ▀▀▀▀▀▀▀▀▀ ────┘ │ │ │ │
; │ │ └───── ▄▀      ▄▀ ─────────── ───────── ────┘ │ │ │
; │ └───── ─▀▀▀▀▀▀▀▀▀ ─────────────── ───────── ────┘ │ │
; └───── ────────── ─────────────────── ───────── ────┘ │
; ··-— ────────── ─────────────────────── ───────── ────┘

; ====================[ Greetings to... ]====================
; HellMood^DESiRE  TomCat^Abaddon  superogue^Marquee Design
; Řrřola  Digimind  g0blinish  frag^fsqrt  Baudsurfer^RSi
; sensenstahl  Kuemmel  iONic^Astroidea  Georgy Lomsadze
; wbcbz7^sibCrew  DArt^Fenomen  Adam Bazaroff^Excess Team
; Dolphin Soft  bfox^insiders  TmK^deMarche  Manwe^SandS
; baze^3SC  ryg^Farbrausch  provod^jetlag … all sizecoders!
; ===========================================================

; .------------< Welcome to sizecoding chats!!! >-----------.
; | https://discord.gg/NeCSgBTZmh • https://t.me/sizecoders |
; '---------------------------------------------------------'
