#version 410 core

uniform float fGlobalTime; // in seconds
uniform vec2 v2Resolution; // viewport resolution (in pixels)
uniform float fFrameTime; // duration of the last frame, in seconds

uniform sampler1D texFFT; // towards 0.0 is bass / lower freq, towards 1.0 is higher / treble freq
uniform sampler1D texFFTSmoothed; // this one has longer falloff and less harsh transients
uniform sampler1D texFFTIntegrated; // this is continually increasing
uniform sampler2D texPreviousFrame; // screenshot of the previous frame


layout(location = 0) out vec4 out_color;


float BlackCircle(vec2 uv, vec2 p, float r, float blur) {

    float d = length(uv - p);
    float c = smoothstep(r - blur, r, d);
    
    return c;
}

float RoundLine(vec2 uv, vec2 p, float r, float thickness) {
    float c = BlackCircle(uv, p, r, 0.);
    c += 1. - BlackCircle(uv, p, r - thickness, 0.);
    
    return c;
}

float PatternedCircle(vec2 uv, vec2 p, float r, float thickness, float gap) {
    
    float c = RoundLine(uv, p, r, thickness);
    
    float new_r = r - (thickness + gap);
    for(new_r; new_r > 0.; new_r -= (thickness+gap)) {
    
        c *= RoundLine(uv, p, new_r, thickness);
    
    }
    return c;
}

void main(void)
{
    vec2 fv = vec2(gl_FragCoord.x / v2Resolution.x, gl_FragCoord.y / v2Resolution.y);
    vec2 uv = vec2(gl_FragCoord.x / v2Resolution.x, gl_FragCoord.y / v2Resolution.y);
    uv -= 0.5;
    uv /= vec2(v2Resolution.y / v2Resolution.x, 1);
    uv *= 5;
    
    vec2 p = vec2(0.);
    
    vec2 gv = fract(uv) - .5;
    
    float iTime = fGlobalTime;
    float radius = 0.3*abs(sin(iTime*0.1)) + 0.5;
    float thickness = abs(3.*sin(iTime*0.1)*0.01) + .005;
    float gap = abs(3.*cos(iTime*0.1)*0.01) + .005;
    
    float c = PatternedCircle(gv, p, radius, thickness, gap);
    
    // paint background into a particular color      
    vec3 col = 0.5 + 0.5*cos(iTime+fv.xyx+vec3(0,2,4));
  
    col *= c;
    
    //col += vec3(abs(cos(iTime)),abs(sin(iTime)), abs(sin(iTime + 3.1415/4)));  
  
    // Output to screen
    out_color = vec4(col, 1.);
}
