
#version 450 core

// inputs 
in vec2 texCoord;

// outputs
out vec4 fragColor;

// uniforms
uniform sampler2D   t_texture0;
uniform float 	    g_exposure;

vec3 ACESFilm(vec3 x)
{
    float a = 2.51f;
    float b = 0.03f;
    float c = 2.43f;
    float d = 0.59f;
    float e = 0.14f;
    return clamp((x*(a*x+b))/(x*(c*x+d)+e), 0., 1.);
}

void main(void) {
    fragColor = vec4(pow(ACESFilm(texture(t_texture0, texCoord).rgb*g_exposure),vec3(1./2.2)), 1.0); 
}
