#version 450 core

// varying inputs
in vec2 texCoord;

// outputs
out vec4 outColor;

// uniforms
uniform sampler2D t_source;
uniform sampler2D t_bloomtex;
uniform sampler2D t_blur1;		// last layer
uniform sampler2D t_blur2;		// 2nd last layer

uniform bool  g_bloomTexture;
uniform vec2  g_dstResolution;
uniform vec3  g_tintColor;
uniform float g_intensity;

void main() {
	vec3 color = texture(t_source, texCoord).rgb;
	vec3 bloomColor = pow(g_intensity, 1.5)*texture(t_blur1, texCoord).rgb;
	bloomColor += g_intensity*texture(t_blur2, texCoord).rgb;
	if (g_bloomTexture) bloomColor *= texture(t_bloomtex, texCoord).rgb;

	outColor = vec4(color + bloomColor*g_tintColor, 1.0);	// DO NOT CLAMP!
	//outColor = vec4(texture(t_bloomtex, texCoord).rgb, 1.0);	// DO NOT CLAMP!
};
