#version 450 core

// inputs
layout (location = 0) in vec4 vPos0;
layout (location = 1) in vec4 vPos1;
layout (location = 2) in vec4 vPos2;
layout (location = 3) in vec4 vPos3;

layout (location = 4) in vec4 vColor0;
layout (location = 5) in vec4 vColor1;
layout (location = 6) in vec4 vColor2;
layout (location = 7) in vec4 vColor3;

uniform vec4    g_layerWeights;
uniform float   g_time;
uniform mat4    m_proj;
uniform mat4    m_rotate;

// outputs
out vec4 color;

float rand(vec2 co){
    return fract(sin(dot(co, vec2(12.9898, 78.233))) * 43758.5453)-.5;
}

void main(){
    vec2 blendPos = (vPos0 * g_layerWeights.x + vPos1 * g_layerWeights.y +
         vPos2 * g_layerWeights.z + vPos3 * g_layerWeights.w).xy;


    gl_Position = m_proj * m_rotate * vec4(
        blendPos +
         // add instanced displacement here
         12.3*(vec2(rand(vec2(gl_InstanceID)), rand(vec2((gl_InstanceID*4.))))),
         -1.6 * (gl_InstanceID) + 1.6 * g_time,
        1.0
    );
    color =
        (vColor0 * g_layerWeights.x + vColor1 * g_layerWeights.y +
         vColor2 * g_layerWeights.z + vColor3 * g_layerWeights.w);
    
}
