/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.unitgen.FilterBiquad;

public abstract class FilterBiquadShelf
extends FilterBiquad {
    protected static final double MINIMUM_SLOPE = 1.0E-5;
    public UnitInputPort gain = new UnitInputPort("Gain", 1.0);
    public UnitInputPort slope;
    private double prevGain;
    private double prevSlope;
    private double beta;
    protected double alpha;
    protected double factorA;
    protected double AP1;
    protected double AM1;
    protected double beta_sn;
    protected double AP1cs;
    protected double AM1cs;

    public FilterBiquadShelf() {
        this.addPort(this.gain);
        this.slope = new UnitInputPort("Slope", 1.0);
        this.addPort(this.slope);
    }

    public abstract void updateCoefficients();

    @Override
    public void recalculate() {
        double d;
        double d2;
        double d3 = this.frequency.getValues()[0];
        if (d3 < 1.0E-5) {
            d3 = 1.0E-5;
        }
        if ((d2 = this.gain.getValues()[0]) < 1.0E-5) {
            d2 = 1.0E-5;
        }
        if ((d = this.slope.getValues()[0]) < 1.0E-5) {
            d = 1.0E-5;
        }
        if (d3 != this.previousFrequency || d2 != this.prevGain || d != this.prevSlope) {
            this.previousFrequency = d3;
            this.prevGain = d2;
            this.prevSlope = d;
            double d4 = d3 * this.getFramePeriod();
            this.calculateOmega(d4);
            this.factorA = Math.sqrt(d2);
            this.AP1 = this.factorA + 1.0;
            this.AM1 = this.factorA - 1.0;
            double d5 = (d2 + 1.0) / d - this.AM1 * this.AM1;
            this.beta = d5 < 0.0 ? 0.0 : Math.sqrt(d5);
            this.beta_sn = this.beta * this.sin_omega;
            this.AP1cs = this.AP1 * this.cos_omega;
            this.AM1cs = this.AM1 * this.cos_omega;
            this.updateCoefficients();
        }
    }
}

