/*
 * Decompiled with CFR 0.152.
 */
import processing.core.PApplet;
import processing.core.PFont;
import processing.sound.SoundFile;

public class OneSceneJM2
extends PApplet {
    int numBalls = 200;
    float spring = 0.1f;
    float gravity = 0.03f;
    float friction = -0.5f;
    int counter = 1;
    Ball[] balls = new Ball[this.numBalls];
    float tx;
    float ty;
    float startTime;
    PFont font;
    SoundFile music;

    public void settings() {
        this.size(1920, 1080);
    }

    public void setup() {
        int i = 0;
        while (i < this.numBalls) {
            this.balls[i] = new Ball(this.random(this.width), this.random(this.height), this.random(20.0f, 80.0f), i, this.balls);
            ++i;
        }
        this.noStroke();
        this.noCursor();
        this.surface.setResizable(true);
        this.fill(255.0f, 231.0f, 235.0f);
        this.font = this.createFont("animaletters.medium.ttf", 50.0f);
        this.music = new SoundFile((PApplet)this, "Taustamusa.wav");
        this.music.loop();
        this.startTime = this.millis();
    }

    public void draw() {
        this.background(255.0f, 196.0f, 205.0f);
        Ball[] ballArray = this.balls;
        int n = this.balls.length;
        int n2 = 0;
        while (n2 < n) {
            Ball ball = ballArray[n2];
            ball.collide();
            ball.move();
            ball.display();
            ++n2;
        }
        float elapsedTime = (float)this.millis() - this.startTime;
        this.text("UWU", this.tx, this.ty);
        this.textFont(this.font, 80.0f);
        if (elapsedTime / 1000.0f > (float)this.counter) {
            ++this.counter;
            this.textF();
        }
        if (elapsedTime / 1000.0f > 23.0f) {
            this.exit();
        }
    }

    public void textF() {
        this.tx = this.random(this.width);
        this.ty = this.random(this.height);
    }

    public void keyPressed() {
        if (this.keyCode == 27) {
            this.exit();
        }
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"OneSceneJM2"};
        if (passedArgs != null) {
            PApplet.main((String[])OneSceneJM2.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class Ball {
        float x;
        float y;
        float diameter;
        float vx = 0.0f;
        float vy = 0.0f;
        int id;
        Ball[] others;

        Ball(float xin, float yin, float din, int idin, Ball[] oin) {
            this.x = xin;
            this.y = yin;
            this.diameter = din;
            this.id = idin;
            this.others = oin;
        }

        public void collide() {
            int i = this.id + 1;
            while (i < OneSceneJM2.this.numBalls) {
                float minDist;
                float dx = this.others[i].x - this.x;
                float dy = this.others[i].y - this.y;
                float distance = OneSceneJM2.sqrt((float)(dx * dx + dy * dy));
                if (distance < (minDist = this.others[i].diameter / 2.0f + this.diameter / 2.0f)) {
                    float angle = OneSceneJM2.atan2((float)dy, (float)dx);
                    float targetX = this.x + OneSceneJM2.cos((float)angle) * minDist;
                    float targetY = this.y + OneSceneJM2.sin((float)angle) * minDist;
                    float ax = (targetX - this.others[i].x) * OneSceneJM2.this.spring;
                    float ay = (targetY - this.others[i].y) * OneSceneJM2.this.spring;
                    this.vx -= ax;
                    this.vy -= ay;
                    this.others[i].vx += ax;
                    this.others[i].vy += ay;
                }
                ++i;
            }
        }

        public void move() {
            this.vy += OneSceneJM2.this.gravity;
            this.x += this.vx;
            this.y += this.vy;
            if (this.x + this.diameter / 2.0f > (float)OneSceneJM2.this.width) {
                this.x = (float)OneSceneJM2.this.width - this.diameter / 2.0f;
                this.vx *= OneSceneJM2.this.friction;
            } else if (this.x - this.diameter / 2.0f < 0.0f) {
                this.x = this.diameter / 2.0f;
                this.vx *= OneSceneJM2.this.friction;
            }
            if (this.y + this.diameter / 2.0f > (float)OneSceneJM2.this.height) {
                this.y = (float)OneSceneJM2.this.height - this.diameter / 2.0f;
                this.vy *= OneSceneJM2.this.friction;
            } else if (this.y - this.diameter / 2.0f < 0.0f) {
                this.y = this.diameter / 2.0f;
                this.vy *= OneSceneJM2.this.friction;
            }
        }

        public void display() {
            OneSceneJM2.this.ellipse(this.x, this.y, this.diameter, this.diameter);
        }
    }
}

