#version 430
uniform float fGlobalTime; // in seconds
uniform vec2 v2Resolution; // viewport resolution (in pixels)
vec2 resolution = v2Resolution;

uniform sampler2D texChecker;
uniform sampler2D texNoise;
uniform sampler2D texTex1;
uniform sampler2D texTex2;
uniform sampler2D texTex3;
uniform sampler2D texTex4;

layout(location = 0) out vec4 out_color; // out_color must be written in order to see anything
float time = fGlobalTime;
float Pi = 3.1415296;

vec3 rotatex(in vec3 p, float ang) { return vec3(p.x, p.y*cos(ang) - p.z*sin(ang), p.y*sin(ang) + p.z*cos(ang)); }

vec3 rotatey(in vec3 p, float ang) { return vec3(p.x*cos(ang) - p.z*sin(ang), p.y, p.x*sin(ang) + p.z*cos(ang)); }

vec3 rotatez(in vec3 p, float ang) { return vec3(p.x*cos(ang) - p.y*sin(ang), p.x*sin(ang) + p.y*cos(ang), p.z); }


float opS( float d1, float d2 )
{
    return max(-d2,d1);
}

float opU( float d1, float d2 )
{
	return (d1<d2) ? d1 : d2;
}

vec3 opRep( vec3 p, vec3 c )
{
    return mod(p,c)-0.5*c;
}

vec3 opTwist( vec3 p )
{
    float  c = cos(10.0*p.y+10.0);
    float  s = sin(10.0*p.y+10.0);
    mat2   m = mat2(c,-s,s,c);
    return vec3(m*p.xz,p.y);
}


float scene(vec3 p)
{
  p = rotatex(p, 0.18*time - 2.0);
  p = rotatez(p, 0.20*time - 2.0);
  p = rotatey(p, 0.22*time);

  float r = texture(texNoise,p.xy).x;
 
  r+=time*0.025;
        
	float d0 = length(max(abs(p) - 0.5, 0.0))- 0.01 + clamp(sin((p.x+p.y+mix(p.z,r,0.015))*20.0)*0.03, 0.0, 1.0); 
  float d1 = length(p) - 0.57; 	
	float cage = opS(d0,d1);
	
	
 p = rotatex(p, 0.28*time - 2.0);
  p = rotatez(p, 0.20*time - 2.0);
  p = rotatey(p, 0.22*time);

	float d4 = length(max(abs(p) - 0.6, 0.0))- 0.01 + clamp(sin((p.x+p.y+p.y)*10.0)*0.03, 0.0, 1.0); 
	float d2 = length(p) - 0.4;
	float ball = opS(d2,d4);
  return opU(cage,ball); 
}

vec3 get_normal(vec3 p)
{
	vec3 eps = vec3(0.01, 0.0, 0.0); 
	float nx = scene(p + eps.xyy) - scene(p - eps.xyy); 
	float ny = scene(p + eps.yxy) - scene(p - eps.yxy); 
	float nz = scene(p + eps.yyx) - scene(p - eps.yyx); 
	return normalize(vec3(nx,ny,nz)); 
}

float hex(vec2 p) {
  p.x *= 0.57735*2.0;
	p.y += mod(floor(p.x), 2.0)*0.5;
	p = abs((mod(p, 1.0) - 0.5));
	return abs(max(p.x*1.5 + p.y, p.y*2.0) - 1.0);
}

vec2 noise(vec2 t)
{
return t=vec2(dot(t,vec2(127.1,311.7)),dot(t,vec2(269.5,183.3))),fract(sin(t)*43758.5);
}
float voronoi(vec2 v)
	{
	vec2 r=floor(v),e=fract(v);
	float f=8.;
	for(float u=-1.;u<=1.;u++)
	for(float m=-1.;m<=1.;m++)
	{
	vec2 g=vec2(m,u),d=noise(r+g);
	d=.1+.5*sin(time+4.2831*d);
	vec2 s=g+d-e;
	float o=dot(s,s);
	f=min(f,o);
	}
	return f;
}


float getBorder( in vec2 p )
{
    float dis = voronoi( p );
    
    return 1.0 - smoothstep( 0.0, .26, dis );
}

void main( void ) 
{
	vec2 p = 2.0 * gl_FragCoord.xy / resolution - 1.0; 
	p.x *= resolution.x / resolution.y; 
	 vec2 sp=gl_FragCoord.rg/resolution.rg;
	vec3 ro = vec3(0.0, 0.0, 1.7); 
	vec3 rd = normalize(vec3(p.x, p.y, -1.4)); 
	vec3 color = vec3(0.0);   
	vec3 pos = ro; 
	float dist = 0.0; 

	
	for (int i = 0; i < 32; i++) 
	{
		float d = scene(pos); 
		pos += rd*d; 
		dist += d; 
	}
	
	if (dist < 4.0) 
	{
		vec3 n = get_normal(pos);
		vec3 r = reflect(normalize(pos - ro),n); 
		vec3 h = -normalize(n + pos - ro ); 
		float diff  = 1.0*clamp(dot(n, normalize(vec3(1,1,1))), 0.0, 1.0); 
		float diff2 = 0.2*clamp(dot(n, normalize(vec3(0.7,-1,0.5))), 0.0, 1.0); 
		float diff3 = 0.1*clamp(dot(n, normalize(vec3(-0.7,-0.4,0.7))), 0.0, 1.0); 
		float spec = pow(clamp(dot(r, normalize(vec3(1,1,1))), 0.0, 1.0), 50.0); 
		float amb = 0.2 + pos.y; 
    vec3 rf = texture(texTex1, r.xy*0.5).xyz;
    vec3 tex2 = texture(texTex2,r.xy*1.0).xyz;
    float x=getBorder(2.*sp);
    vec4 color2=(x+1.0)*vec4(.1,.3,.5,0.0);
		color = diff*vec3(.1,.3,.5) + diff2*vec3(.1,.3,.5)+rf+tex2  + diff3*vec3(.1,.3,.5)*color2.rgb + spec*vec3(1,1,1)  + amb*color2.rgb; 
		color /= dist;
	}
	else
	{
	      
    float f=1-hex(sp*8.);
    float voron = getBorder(1.8*sp)*sin(f);
    vec4 color=(f*voron)*vec4(232./255.,157./255.,26./255.,0.0);
    out_color=vec4(color);
	  return;
	}
	out_color = vec4(color, 1.0); 
}