"use strict";

class Scene9Controller extends BaseSceneController {

    _secondLineVisible;
    _flowerTemplate;
    _flowers = [];
    _flowerIndex = 0;
    _screenWidth;
    _screenHeight;

    initialize() {
        this.showText("FLower flower flower");

        this.screenWidth = this.getVisibleWidth();
        this.screenHeight = this.getVisibleHeight();

        var flower = this.spriteManager.get("flower");
        this._flowerTemplate = flower.children[0];
    }

    update(time) {
        if (time > 1900 && !this._secondLineVisible) {
            this.showText("flower flowerbed");
            this._secondLineVisible = true;
        }

        if (this._flowerIndex < 3 && time > this._flowerIndex * 1900 / 3) {
            var flower = this.createFlower();
            flower.scale.setScalar(3.5);
            var index = this._flowerIndex - 1;
            flower.position.set(
                -this.screenWidth / 4 + index * this.screenWidth / 4,
                0,
                0.0005);
        }

        if (time > 1900 + (this._flowerIndex - 3) * 20) {
            var color = new THREE.Color();
            color.setHSL(THREE.MathUtils.randFloat(0, 1), 0.8, 0.8);
            var flower = this.createFlower(color);
            flower.scale.setScalar(2);
            flower.position.set(
                THREE.MathUtils.randFloat(-this.screenWidth / 2, this.screenWidth / 2),
                THREE.MathUtils.randFloat(-this.screenHeight / 2, this.screenHeight / 2),
                0.0004);
        }

        this._flowerTemplate.material.rotation += 0.03;
    }

    createFlower(color) {
        var flower = this._flowerTemplate.clone();
        if (color) {
            flower.material = flower.material.clone();
            flower.material.color = color;
        }
        var flowerWrapper = new THREE.Group();
        flowerWrapper.rotation.set(0, 0, THREE.MathUtils.randFloat(0, Math.PI * 2));
        flowerWrapper.add(flower);
        this._flowers.push(flowerWrapper);
        this.scene.add(flowerWrapper);
        this._flowerIndex++;
        
        return flowerWrapper;
    }
}