"use strict";

class Scene6Controller extends BaseSceneController {

    _face;
    _faceMaterial;
    _whiteColor = new THREE.Color(1, 1, 1);
    _blueColor = new THREE.Color(0.4, 0.4, 1);
    _redColor = new THREE.Color(0.9, 0.4, 0.1);

    initialize() {
        this.showText("his face turned blue and red");

        this._face = this.spriteManager.get("face");
        this._faceMaterial = this._face.children[0].material
        this._face.scale.setScalar(2);
        this.scene.add(this._face);
    }

    update(time) {
        this._face.scale.setScalar(1.5 + time / 500);
        this._faceMaterial.rotation = -1 + time / 1000;
        var faceColor;
        if (time < 200) {
            faceColor = this._whiteColor.clone();
        }
        else if (time < 700) {
            faceColor = this._whiteColor.clone().lerp(this._blueColor, (time - 200) / 500);
        }
        else if (time < 1200) {
            faceColor = this._blueColor.clone().lerp(this._redColor, (time - 700) / 500);
        }
        else
            faceColor = this._redColor;
        this._faceMaterial.color = faceColor;
    }
}