"use strict";

class Scene3Controller extends BaseSceneController {
    _lava = {};
    _lavaUniforms = {};
    _startPosition;

    initialize() {
        this.showText("I put him in the lava");

        var lavaMaterial = this.materialManager.get("lava");
        this._lavaUniforms = lavaMaterial.uniforms;
        this._lavaUniforms["time"] = { value: 1.0 };
        this._lavaUniforms["texture1"] = { value: this.textureManager.get("noise") };
        this._lavaUniforms["texture2"] = { value: this.textureManager.get("lava") };

        var lavaSize = Math.max(this.getVisibleHeight(-0.0001), this.getVisibleWidth(0.0001));
        var lava = new THREE.Mesh( new THREE.PlaneGeometry( lavaSize, lavaSize ), lavaMaterial);
        lava.position.set(0, -10, -0.0001);
        this._startPosition = lava.position;
        this._lava = lava;
        this.scene.add(lava);
    }

    update(localTime, globalTime) {
        this._lavaUniforms["time"].value = globalTime / 1000;

        var targetPosition = new THREE.Vector3(0, 0, -0.0001);
        var position = this._startPosition.clone().lerp(targetPosition, Math.min(localTime / 2000, 1));
        this._lava.position.copy(position);
    }
}