"use strict";

class Scene10Controller extends BaseSceneController {

    _secondLineVisible;
    _flowerTemplate;
    _flowers = [];
    _flowerIndex = 0;
    _screenWidth;
    _screenHeight;
    _face;
    _faceMaterial;


    initialize() {
        this.showText("FLower flower flower");

        this._screenWidth = this.getVisibleWidth();
        this._screenHeight = this.getVisibleHeight();

        var flower = this.spriteManager.get("flower");
        this._flowerTemplate = flower.children[0];

        this._face = this.spriteManager.get("dead");
        this._faceMaterial = this._face.children[0].material
        this._face.scale.setScalar(1.5);
        this._face.position.set(0, -1000, 0);
        this.scene.add(this._face);        
    }

    update(time) {
        if (time > 1800 && !this._secondLineVisible) {
            this.showText("Angry Tim was dead");
            this._secondLineVisible = true;
        }

        if (this._flowerIndex < 3 && time > this._flowerIndex * 1800 / 3) {
            var flower = this.createFlower();
            flower.scale.setScalar(3.5);
            var index = this._flowerIndex - 1;
            flower.position.set(
                -this._screenWidth / 4 + index * this._screenWidth / 4,
                0,
                -0.0001);
        }        

        this._flowerTemplate.material.rotation += 0.03;

        if (time > 1800) {
            this._face.scale.setScalar(1.1 + time / 500);
            this._faceMaterial.rotation = -1 + time / 3000;
            this._face.position.set(0, 0, 0);
        }

    }

    createFlower(color) {
        var flower = this._flowerTemplate.clone();
        if (color) {
            flower.material = flower.material.clone();
            flower.material.color = color;
        }
        var flowerWrapper = new THREE.Group();
        flowerWrapper.rotation.set(0, 0, THREE.MathUtils.randFloat(0, Math.PI * 2));
        flowerWrapper.add(flower);
        this._flowers.push(flowerWrapper);
        this.scene.add(flowerWrapper);
        this._flowerIndex++;
        
        return flowerWrapper;
    }    
}