"use strict";

class BaseSceneController {
    scene;
    camera;
    spriteManager;
    textManager;
    textureManager;
    materialManager;

    constructor(scene, camera, context) {
        this.scene = scene;
        this.camera = camera;
        this.spriteManager = context.spriteManager;
        this.textureManager = context.textureManager;
        this.materialManager = context.materialManager;
        this.textManager = context.textManager;    
    }

    initialize() {
        // Override in descendants
    }

    update(localTime, globalTime) {
        // Override in descendants
    }

    clear() {
        var scene = this.scene;
        while (scene.children.length > 0) {
            scene.remove(scene.children[0]);
        }
    }

    showText(text) {
        var x = this.getVisibleWidth() / 2 - 2.4;
        var y = this.getVisibleHeight() / 2 - 0.8;
        this.textManager.showLine(x, y, text);
    }

    getVisibleWidth(z) {
        var height = this.getVisibleHeight(z); 
        return height * this.camera.aspect;
    }

    getVisibleHeight(z) {
        z = z || 0;
        var distance = this.camera.position.z - z;
        var vFOV = THREE.MathUtils.degToRad( this.camera.fov );
        return 2 * Math.tan( vFOV / 2 ) * distance;
    }
}