"use strict";

class SpriteManager {
    _sprites = {};

    load(name, path) {
        var me = this;
        return new Promise((resolve) => {
            new THREE.TextureLoader().load(path, (spriteMap) => {
                var spriteMaterial = new THREE.SpriteMaterial({ map: spriteMap });
                var sprite = new THREE.Sprite(spriteMaterial);
                // Scale respecting aspect ratio of source image
                var scaleX = 1;
                var scaleY = 1;
                var factor = spriteMap.image.width / spriteMap.image.height;
                if (factor > 1)
                    scaleX *= factor;
                else
                    scaleY /= factor;
                sprite.scale.set(scaleX, scaleY, 1);
                // wrap in a group so we can properly set the scale
                var spriteWrapper = new THREE.Group();
                spriteWrapper.add(sprite);
                me._sprites[name] = spriteWrapper;
                resolve();
            });
        });
    }

    get(spriteName) {
        return this._sprites[spriteName];
    }
}