# -*- coding: utf-8 -*-
"""
Created on Fri Jan 3 9:36:00 2020

@author: Ct
"""
import random, pygame
BLACK = (0, 0, 0)
WHITE = (255, 255, 255)
#fuck data structures.  all we need is lists
LOC = 0
T_OFF = 1
BRT = 2
FACNT = 3
MAT = 4
INDX = 5

def FindFactor(primes, num):
    # start with the first prime and go up until you find something that divides the number.
    # must divide by 2 or more, 1 isn't a factor.  right side might be prime (that will be caught in UpdateMatrix)
    for i in range(1,len(primes)): #must start with second item in the list in order to skip 1
        divisor_candidate = primes[i]
        if num%divisor_candidate == 0:
            dividend = int(num / divisor_candidate) #the other side. no idea if this is the right word
            #print (str(num) + " = " + str(divisor_candidate) + " x " + str(dividend))
            return [divisor_candidate, dividend]

def UpdateMatrix(primes, matrix, factor_count):
    #it's assumed that the matrix has been initialized with its number in its first row, which has already been printed
    #it's also assumed that the matrix is not currently fully factored.  Matrices for prime numbers get caught before
    #they get to this point.  Finally, it's assumed that the remainder of the last line isn't prime.  if it is, it
    #gets eaten when that line is first generated.
    width = len(matrix[0])
    length = len(matrix)
    lastrow = matrix[length-1]
    remainder_index = lastrow.index(2)  #the index of the chunk of the line that isn't prime
    remainder = width - remainder_index  #the number that is
    [prime,newremainder] = FindFactor(primes,remainder)  #get the factors
    newrow = [0]*width #make a new row
    newrow[:remainder_index] = lastrow[:remainder_index]  #previously factored part of the cascade is preserved
    newrow[remainder_index:remainder_index+prime+1] = [1]*prime #newly found prime is put in place
    newrow[width - newremainder] = 2  #mark the start of the new remainder with a 2
    newrow[width - (newremainder - 1):] = [1]*(newremainder - 1)  #fill in the rest with 1s
    matrix = matrix + [newrow]
    if newremainder in primes:
        done = True
        factor_count = factor_count + 2
    else:
        done = False
        factor_count = factor_count + 1
    #print(newrow)
    return [matrix, factor_count, done]

def PrintMatrixRow(screen, offset_x,offset_y, boxwidth, boxheight, matrix, rownum, color):
    #print at (offset_x, offset_y + blockheight*rownum)
    width = len(matrix[0])
    row = matrix[rownum]
    for i in range(width):
        if row[i] > 0:
            pygame.draw.rect(screen, color, (offset_x + i*boxwidth, offset_y + boxheight*rownum, boxwidth, boxheight))


def PrintMatrix(screen, offset_x, offset_y, boxwidth, boxheight, matrix, color):
    #print all of the rows at once do if fully factored.
    for i in range(len(matrix)):
        PrintMatrixRow(screen, offset_x, offset_y, boxwidth, boxheight, matrix, i, color)


def PrintPercentBox(screen, OddCount, EvenCount, WINWIDTH, WINHEIGHT):
    #print the scorebox
    total = OddCount + EvenCount
    if OddCount > EvenCount:
        percentOdd = OddCount / total
        red = 50 + int(200 * percentOdd)
        color = (red,40,40)
    elif EvenCount > OddCount:
        percentEven = EvenCount/total
        green = 50 + int(200 * percentEven)
        color = (40, green, 40)
    else:
        color = BLACK
    pygame.draw.rect(screen, BLACK, (0, 0, WINWIDTH, WINHEIGHT), 82)
    pygame.draw.rect(screen, color, (0, 0, WINWIDTH, WINHEIGHT), 80)


#main loop
def main(primes, clock, WINWIDTH, WINHEIGHT, WINCENTX, WINCENTY, screen):
    very_done = False
    boxwidth = 2
    boxheight = 15
    MAX_Y = WINHEIGHT - 3*boxheight
    pygame.Surface.fill(screen, BLACK)
    pygame.display.flip()

    # pick the number, it's gotta be less than int(MAX_X/boxwidth)
    THE_NUMBER = int(WINWIDTH/boxwidth) - 60

    # give them x-offset and y-offset, offset in time, brightness, factor counter, and a matrix stub (list of lists [[]])
    # initialize their factor counter to 0
    Boxes = []
    for i in range(1,THE_NUMBER):
        MAX_X = WINWIDTH - i*boxwidth
        # [[x,y],t-offset,brightness, factor_count, matrix, index]
        newbox = [[random.randint(0, MAX_X), random.randint(0, MAX_Y)], random.randint(0,int(THE_NUMBER/6)), random.randint(40, 255),0,[[]], i]
        Boxes += [newbox]

    left_to_factor = THE_NUMBER
    EvenCount = 0
    OddCount = 0
    t = 0

    while (len(Boxes) > 0) and not very_done:
        #clock update, check on events to keep in sync.
        clock.tick(50)
        for event in pygame.event.get():
            if event.type == pygame.KEYDOWN:
                very_done = True
            break

        kill_list = []
        for i in range(len(Boxes)):
            cbox = Boxes[i]
            done = False

            if t == cbox[T_OFF]:  #happy birthday box!
            # on the first hit, initialize: print the row and check if it's prime (if it is, do the done stuff below)
                index = cbox[INDX]
                cbox[MAT] = [[2] + (index-1)*[1]]
                color = (cbox[BRT],cbox[BRT],cbox[BRT])
                PrintMatrixRow(screen, cbox[LOC][0], cbox[LOC][1], boxwidth, boxheight, cbox[MAT], 0, color)
                if index in primes:
                    cbox[FACNT] = 1
                    #print("singleton prime box, length " + str(index) + ": " + str(cbox[MAT]))
                    done = True


            elif t > cbox[T_OFF]:  #age a day
                color = (cbox[BRT], cbox[BRT], cbox[BRT])
                [new_matrix, new_factor_count, done] = UpdateMatrix(primes, cbox[MAT], cbox[FACNT])
                cbox[MAT] = new_matrix
                cbox[FACNT] = new_factor_count
                PrintMatrixRow(screen,cbox[LOC][0],cbox[LOC][1],boxwidth, boxheight, cbox[MAT], len(cbox[MAT])-1, color )

            if done == True:  #say goodbye box
                #check parity on factor count and set color, then print box, and update either odd count or even count
                if cbox[FACNT]%2 == 0: #even
                    color = (0,cbox[BRT],0)
                    EvenCount = EvenCount + 1
                else: #odd
                    color = (cbox[BRT],0,0)
                    OddCount = OddCount + 1
                PrintMatrix(screen, cbox[LOC][0], cbox[LOC][1], boxwidth, boxheight, cbox[MAT], color)
                kill_list = kill_list + [cbox]
                left_to_factor = left_to_factor - 1

            #print the scorebox
            PrintPercentBox(screen, OddCount, EvenCount, WINWIDTH, WINHEIGHT)
            pygame.display.flip()

        for cbox in kill_list:
            Boxes.remove(cbox)
        t = t + 1  # update time

    #go to mars on a smallrobot and eat six bananas on tuesdays
    ready = False
    while not ready and not very_done:
        clock.tick(50)
        for event in pygame.event.get():
            if event.type == pygame.KEYDOWN:
                ready = True
    ready = False

    return very_done