# -*- coding: utf-8 -*-
"""
Created on Sun Jan 13 17:50:30 2019

@author: Ct
"""
import random, pygame
BLACK = (0, 0, 0)
WHITE = (255, 255, 255)

def CollatzUpdate(val):
    if val%2 == 0:
        val = val/2
    elif val != 1:
        val = 3*val + 1
    return val

def MoveBox(loc, color, screen):
    (oldx, oldy) = loc
    (x, y) = (CollatzUpdate(oldx), CollatzUpdate(oldy))
    pygame.draw.line(screen, color, (oldx, oldy), (x, y))
    return (x, y)

#main loop
def main(BOXCOUNT, slowfreq, clock, MAX_X, MAX_Y, screen):
    very_done = False

    LOC = 0 #objects are for losers.  all caps array indices is where its at
    BRT = 1

    # [[x,y],brightness].  Four bursts of boxes, from quick and small to large and slow
    Bits1 = [[[random.randint(0, MAX_X), random.randint(0, MAX_Y)], random.randint(0, 255)] for i in
             range(BOXCOUNT * 1)]
    Bits2 = [[[random.randint(0, MAX_X), random.randint(0, MAX_Y)], random.randint(0, 255)] for i in
             range(BOXCOUNT * 2)]
    Bits3 = [[[random.randint(0, MAX_X), random.randint(0, MAX_Y)], random.randint(0, 255)] for i in
             range(BOXCOUNT * 3)]
    Bits4 = [[[random.randint(0, MAX_X), random.randint(0, MAX_Y)], random.randint(0, 255)] for i in
             range(BOXCOUNT * 4)]

    pygame.Surface.fill(screen, BLACK)
    pygame.display.flip()

    #------------------------------Big Loop-------------------------------
    slower = 0

    while slower < 1240 and not very_done:
        clock.tick(50)
        slower = slower + 1

        for event in pygame.event.get():
            if event.type == pygame.KEYDOWN:
                very_done = True
                break


        # Collatz Box 4 Update Code-----------------------------
        if slower % (4 * slowfreq) == 0:
            for i in range(len(Bits4)):  # inefficient-ish
                Bits4[i][LOC] = MoveBox(Bits4[i][LOC], (Bits4[i][BRT], Bits4[i][BRT], 255), screen)

        # Collatz Box 3 Update Code-----------------------------
        if slower % (3 * slowfreq) == 0:
            for i in range(len(Bits3)):  # inefficient-ish
                Bits3[i][LOC] = MoveBox(Bits3[i][LOC], (Bits3[i][BRT], 185, Bits3[i][BRT]), screen)

        # Collatz Box 2 Update Code-----------------------------
        if slower % (2 * slowfreq) == 0:
            for i in range(len(Bits2)):
                Bits2[i][LOC] = MoveBox(Bits2[i][LOC], (255, 255, Bits2[i][BRT]), screen)

        # Collatz Box 1 Update Code-----------------------------
        if slower % slowfreq == 0:
            for i in range(len(Bits1)):
                Bits1[i][LOC] = MoveBox(Bits1[i][LOC], (255, Bits1[i][BRT], Bits1[i][BRT]), screen)

        pygame.display.flip()

    return very_done