;QB LOVE - 256b intro by Abaddon
;code: TomCat
;music: ern0

DEBUG EQU 0
maxvol EQU 0

SIZE EQU 192
Divider EQU 67

ORG 256

 DW 127                 ; constant 127 -> amplitude for sinus table
 DW 3C00H               ; constant 1/128 -> calculating PI/128 for sinus table

if maxvol=1
 MOV BH,080H
 MOV GS,BX
 MOV [GS:BX],BX
end if

 MOV AL,13H             ; set video mode 320x200
.1:
if DEBUG=0
 INT 10H                ; call VGA Bios
end if
 IMUL CX,BX,64
 IMUL DX,CX,2
 AND CX,01F00H
 MOV AX,1010H           ; set one color by the VGA BIOS
 DEC BL                 ; DH/CH/CL->R/G/B
 JS .2
 XCHG CL,DH
.2:
 JNZ .1

 MOV BH,0A0H
 PUSH BX
 MOV BP,SP              ; BP: -4
@@:
 FLDPI                  ; PI
 FMUL DWORD [SI]        ; PI/128
 FIMUL WORD [DI]        ; counter*PI/128
 FSIN                   ; SIN(counter*PI/128)
 FIMUL WORD [SI]        ; 127*SIN(counter*PI/128)
 FISTP WORD [BX]        ; -
 INC BX
 DEC BYTE [DI]          ; loop 256x
 JNZ @B                 ; BX = sinus table

 DEC BX
 DEC CX
 XCHG CL,DH
 INT 10H                ; set last color to yellow for logo

 MOV DX,BB
 MOV AH,9
 INT 21H

 POP DS
 POP BX                 ; BX:0
.0:
 INC DI                 ; DI:-1
 PUSH BX                ; put normal vectors to the stack
 PUSH BX
 PUSH DI                ; [SP]: 0 0 -1
 PUSH BX
 PUSH DI
 PUSH BX                ; [SP]: 0 -1 0
 PUSH DI
 PUSH BX
 PUSH BX                ; [SP]: -1 0 0
 INC DI
 JZ .0                  ; loop 2x

 MOV DI,90*320-80-36
 XCHG CX,AX
copy:                   ; copy text to backbuffer
 LODSB
 AAA
 JZ .1
 ADD AL,240
.1:
 STOSW                  ; 3x enlargment
 STOSB
 LOOP copy

 PUSH DS
 MOV AX,3508H
 INT 21H
 PUSH CS
 POP DS
 XCHG AX,DX
 XCHG BX,AX
 MOV [BX+20],AX         ; backup int8 handler
 MOV [BX+22],ES
 POP ES

 MOV DX,IRQ
 MOV AL,90H
 OUT 43H,AL
 SUB AL,90H-Divider
 CALL init

nextframe:
 MOV SI,640H;470H
 FILD DWORD [BX-BB+IRQ.COUNTER]
 FIDIV WORD [BX-BB+SPEED]
 FIADD DWORD [BX-BB+SYNC]
 FLD ST0                ; alpha
 FADD ST0,ST0           ; 2alpha alpha

.1:
 MOV DI,SP              ; DI: normal vectors
.2:
 ADD SI,16
 FILD WORD [DI+2]       ; NY 2a a
 FILD WORD [DI]         ; NZ NY 2a a
 FILD WORD [DI+4]       ; NX NZ NY 2a a
.3:
 FLD ST3                ; 2a NX NZ NY 2a a
 FSINCOS                ; cos sin NX NZ NY 2a a
 FLD ST3                ; NZ cos sin NX NZ NY 2a a
 FMUL ST0,ST1           ; cosNZ cos sin NX NZ NY 2a a
 FXCH ST4               ; NZ cos sin NX cosNZ NY 2a a
 FMUL ST0,ST2           ; sinNZ cos sin NX cosNZ NY 2a a
 FXCH ST3               ; NX cos sin sinNZ cosNZ NY 2a a
 FMUL ST2,ST0           ; NX cos sinNX sinNZ cosNZ NY 2a a
 FMULP ST1,ST0          ; cosNX sinNX sinNZ cosNZ NY 2a a
 FSUBRP ST2,ST0         ; sinNX cosNX-sinNZ cosNZ NY 2a a
 FADDP ST2,ST0          ; cosNX-sinNZ sinNX+cosNZ NY 2a a
 FSTP DWORD [SI+BP]     ; sin*NX+cosNZ NY 2a a
 NEG BP
 JNS .3                 ; loop 2x (next axis)
 FSTP DWORD [SI]        ; 2a a
 ADD DI,6
 JNZ .2                 ; loop 6x (next side)
 FXCH                   ; a 2a
 NEG AX
 JS .1                  ; loop 2x (next cube)
 FUCOMPP                ; -

 NEG CX
nextpixel:
 PUSHA                  ; 36: AX CX DX BX SP BP SI DI

 MOV [BX+13],SI
 XOR DH,DL              ; clever test for the middle of the screen
 JS logo2               ; skip pixels on the sides
FIX4:
 PUSHA
 MOV SI,BX
 MOV DH,CL
 MOV AX,400             ; logo zoom constant
 SUB AX,[IRQ.COUNTER+1]
 CMP AX,SIZE
 JG .2
 MOV AX,SIZE
.2:
 CALL DrawLogo
 POPA
;JMP oklogo
logo2:
 LEA AX,[DI-100*320-80]
 CWD
 XOR AX,DX
 CMP AX,10*320
FIX0:
 JMP oklogo
 XOR DL,[DI]            ; test logo in backbuffer
 JPE oklogo
 MOV [BX+12],SP         ; [BX+13]: 255 (yellow color)
oklogo:

 FILD WORD [BX-BB+CUBE] ; c (cube size)
 CALL TraceCube
 FSTP DWORD [BX+4]      ; -
 JCXZ missed1
 FLD1                   ; 1
FIX5:
 JL shade
 DEC CX
 XCHG DX,AX

 FIMUL WORD [BX-BB+CUBE]; c
FIX9:
 CALL TraceCube-1
FIX2:
 FSTP DWORD [BX+8]      ; -
 FLD1                   ; 1
 JCXZ SKIP
FIX6:
 JL shade

SKIP:
 MOV BYTE [BX],31
 FCHS                   ; -1
 JCXZ back

 XCHG DI,AX
 CMP [BX+11],CH
FIX7:
 JL shade

back:
 MOV DI,DX
 CMP [BX+7],CH
FIX8:
 JL shade
 FSTP ST0

missed1:
 POPA
 MOV AL,DL
 CBW
 XOR AH,AL
 SHL AH,1
 ADD AH,[IRQ.SAMPLE-1]
 SHR AX,11;2
 JMP plot

shade:
 CMP [DI+11],CH
FIX3:
 JMP @F
 MOV [BX+13],CH
@@:

 FLD DWORD [DI]
 FSUB DWORD [DI+BP]
 FSUB DWORD [DI+4]      ; N.S
 FMULP
 FLDZ                   ; 0 N.S
 FUCOMI ST0,ST1         ; 0 N.S
 FCMOVB ST0,ST1         ; max N.S
 FSTP ST1               ; max

 FIMUL WORD [BX-BB+MAXCOLOR]
 FISTP WORD [BP+4-36-2]
 POPA
 ADD AL,[BX]
plot:
 OR AL,[BX+13]
 STOSB
 INC DX
 CMP DX,160
nextline:
 JNE nextpixel
 NEG DX
 DEC CX
 CMP CX,-100
 JNE nextline

 IN AL,60H
 DAS
 JC nextframe

 LDS DX,[BX+20]
 SALC

init:
 OUT 61H,AL
 OUT 40H,AL
 SALC
 OUT 40H,AL
 MOV AX,2508H
 INT 21H

missed:
 FUCOMPP                ; c
RETN                    ; return to DOS prompt

TraceCube:              ; SI-4: transformed normal vectors
 FLDZ                   ; 0 c
 FILD DWORD [BX-BB+CUBE]; BIG 0 c
 FSUB ST1,ST0           ; BIG -BIG c

 MOV CX,6               ; number of normal vectors
nextside:
 CMP [SI+7],CH          ; Nz=0?
 JZ skip                ; no intersection (eye&normal vectors perpendicular)

 FLD DWORD [SI+4]       ; Nz min max c
 FLD ST3                ; c Nz min max c
 FMUL ST0,ST1           ; c*Nz Nz min max c

 FLD ST4                ; c c*Nz Nz min max c
 FMUL DWORD [SI+BP]     ; c*Nx c*Nz Nz min max c
 FISUBR WORD [BP+4-36-6]; Px-c*Nx c*Nz Nz min max c
 FMUL DWORD [SI+BP]     ; Nx*(Px-c*Nx) c*Nz Nz min max c

 FLD ST5                ; c Nx*(Px-c*Nx) c*Nz Nz min max c
 FMUL DWORD [SI]        ; c*Ny Nx*(Px-c*Nx) c*Nz Nz min max c
 FISUBR WORD [BP+4-36-4]; Py-c*Ny Nx*(Px-c*Nx) c*Nz Nz min max c
 FMUL DWORD [SI]        ; Ny*(Py-c*Ny) Nx*(Px-c*Nx) c*Nz Nz min max c

 FADDP ST1,ST0          ; Nx*(Px-c*Nx)+Ny*(Py-c*Ny) c*Nz Nz min max c

 FDIVRP ST2,ST0         ; c*Nz (Nx*(Px-c*Nx)+Ny*(Py-c*Ny))/Nz min max c
 FSUBRP ST1,ST0         ; c*Nz-(Nx*(Px-c*Nx)+Ny*(Py-c*Ny))/Nz min max c
 FST DWORD [SI+8]       ; Iz (z-coord of the intersection point)
 JL front               ; Nz is negative -> front face intersected

 FUCOMI ST0,ST1         ; Iz min max c
 FCMOVNB ST0,ST1        ; Iz min max c
 FSTP ST1               ; min max c
 CMOVB AX,SI            ; new min distance for back faces
 JMP skip

front:
 FUCOMI ST0,ST2         ; Iz min max c
 FCMOVB ST0,ST2         ; Iz min max c
 FSTP ST2               ; min max c
 CMOVNB DI,SI           ; new max distance for front faces

skip:
 SUB SI,16              ; next face
 LOOP nextside          ; loop 6x

 FUCOMI ST0,ST1         ; min max c
FIX1:                   ; JBE:76H, JA:77H, JS:78H / JB:72H, JAE:73H, JZ:74H
 JAE missed             ; if min(back) > max(front) then cube missed
 INC CX                 ; CX is a marker, that we hit the cube

 FMUL ST0,ST0           ; min2 max c
 FXCH ST2               ; c max min2
 FMUL ST0,ST0           ; c2 max min2
 FMUL DWORD [BX-BB+HOLE]

 FILD WORD [BP+4-36-6]  ; Px 2c2 max min2
 FMUL ST0,ST0           ; Px2 2c2 max min2
 FILD WORD [BP+4-36-4]  ; Py Px2 2c2 max min2
 FMUL ST0,ST0           ; Py2 Px2 2c2 max min2
 FADDP ST1,ST0          ; Py2+Px2 2c2 max min2
 FSUBP ST1,ST0          ; 2c2-Py2-Px2 max min2
 FSUBR ST2,ST0          ; 2c2-Py2-Px2 max 2c2-Py2-Px2-min2
 FXCH ST1               ; max 2c2-Py2-Px2 2c2-Py2-Px2-min2
 FMUL ST0,ST0           ; max2 2c2-Py2-Px2 2c2-Py2-Px2-min2
 FSUBP ST1,ST0          ; 2c2-Py2-Px2-max2 2c2-Py2-Px2-min2
 FSTP DWORD [BX]        ; 2c2-Py2-Px2-min2
 MOV BYTE [BX],159
 CMP [BX+3],CH
RETN

DrawLogo:
 IMUL BP,AX,-3*2
 IMUL CX,AX,3*10
 MOV [SI],BP
 IMUL DI,AX,2*4
 NEG WORD [SI]
 CALL DrawBar
 SUB BP,BP
 IMUL CX,AX,3*8
 IMUL DI,AX,2*14
 CALL DrawBar
 IMUL BP,AX,-3*7
 IMUL CX,AX,3*1
 CALL DrawBar
;IMUL BP,AX,3*7
 NEG BP

DrawBar:
; BX:angle, DL:dX, DH:dY, CL:color, CH:width1
; BP:offset1, DI:offset2
 MOV BX,ES
 MOV BL,AL
.0:
 PUSHA
.1:
 MOV AL,[BX]
 IMUL DH
 ADD BP,AX
 ADD BL,64
 MOV AL,[BX]
 IMUL DL
 ADD AX,BP
 JNS .2
 NEG AX
.2:
 CMP AX,CX
 JA .3
 ADD BL,-64+64-10
 MOV BP,DI
 CMP CX,[SI]
 MOV CX,[SI]
 JNE .1
 MOV [SI+12],SP
.3:
 POPA
 XOR BL,128
 NEG AX
 JS .0
 IMUL BX,AX,2*2
 SUB DI,BX
RETN

; ---------------------------- music please ! -------------------------------
INCLUDE "NOTES.INC"

BA EQU NOTE1            ; base address to index

NOTE1:                  ; Theme notes (mask: %11011011)
 DB F_4,Gs4
 DB Cs4,F_4
 DB Ds4,G_4
 DB D_4,F_4

 DB F_4,Gs4
 DB F_4,As4
 DB Ds4,G_4
 DB D_4,F_4

 DB Gs4,C_5
 DB F_4,Gs4
 DB Ds4,G_4
 DB D_4,F_4

NOTE2:                  ; Bass notes
 DB F_3,F_4,C_4,Ds4
 DB Cs3,Cs4,Gs3,H_3
 DB Ds3,Ds4,As3,Cs4
 DB As2,As3,F_3,Gs3

LINKS:
 DB PART1 AND 255
 DB PART2 AND 255
 DB PART3 AND 255
 DB PART4 AND 255
 DB PART5 AND 255
 DB PART6 AND 255
 DB PART7 AND 255
 DB PART8 AND 255
 DB PART9 AND 255
 DB PART10 AND 255
 DB PART11 AND 255
 DB PART12 AND 255
 DB PART13 AND 255
;DB PART14 AND 255
 DB PART15 AND 255

IRQ:
 PUSHA
 MOV AL,2
.SAMPLE:

 MOV BP,BA              ; BP: base pointer to CS (SS in real)
 SHR AL,1               ; zero means pause (no sound)
 JZ .SKIP
.F1:
 OUT 42H,AL             ; out the 6bit sample
.SKIP:
 INC DWORD [BP-BA+IRQ.COUNTER]
.SKIP2:

 DB 66H,68H             ; PUSH DWORD 000000001H
.COUNTER:               ; timer counter
 DB 1,0,0               ; (default 1)
.SUM:                   ; sample sum
 DB 0                   ; (default 0)

 POP SI                 ; SI=timer counter
 POP BX                 ; BL=pattern, BH=volume

 SHR BL,1
 JC DRUMS
 TEST SI,SI
 JNE DRUMS

 PUSH DS
 PUSH ES
 PUSH CS
 PUSH CS
 POP ES
 POP DS

 MOV AX,[BX+LINKS-1]
 MOV DX,257*(PART1 SHR 8)
 XCHG DL,AH
 XCHG SI,AX
PATCH:
 CMP SI,DX
 JZ .1
 LODSW
 XCHG DI,AX
 MOVSB
 JMP PATCH
.1:

 POP ES
 POP DS
 SUB SI,SI

DRUMS:
 RCL BL,1

SEED:
 MOV AX,1

HIHAT:
 IMUL AX,AX,65521       ; constant recommended by Vuk
 MOV WORD [BP-BA+SEED+1],AX
 MUL SI
 XCHG AX,DX
 AND AX,32
 SHRD CX,SI,16+6+1
 TEST CL,32
 JZ SNARE
 AND CX,31
 INC CX
 CWD
 DIV CX
 JMP KICKDRUM.1

SNARE:
 XCHG CX,AX
 MOV AH,0D0H
 OR AX,SI
 IMUL AX
 TEST DH,DH
 JNZ .1
 XCHG AX,CX
 MUL DL
 ADD BH,AH
.1:

KICKDRUM:
 MOV AX,16128
 CWD
 MOV CX,8191
 AND CX,SI
 INC CX
 DIV CX
 AND AL,64
.1:
 ADD BH,AL

THEME:
; DI(=AX): note selector [0..15]
; CL: theme mask index [0..7]

; - theme notes: 4 bits <- BX[2,1,0]+SI[15]
; - theme mask: 3 bits <- SI[13,12,11]
; - bass notes: 4 bits <- BX[0]+SI[15,12,11]

;      Ŀ     Ŀ
;       THEME NOTES      MASKINDEX
;           
;       Ŀ       Ŀ
; Ŀ
; B03B02B01B00S15S14S13S12S11
; 
;                          
;                
;                   BASS NOTES    
;                
 MOV AL,BL
 SHLD AX,SI,5
 MOV CX,10110110B*256+7
 AND CL,AL
 SHL AX,4
 SHL AL,2
 SHR AX,6

 CMP AL,16*4
 JB DONE;BASS
.F1:
 PUSH AX
;JMP .2; BASS DEBUG (SKIP THEME)
 AND AL,15*4
 CMP AL,12*4
 JNB .2
 SHL CH,CL
 JNC .2
 SHR AX,1
 MOV CX,31
 CALL AddNote
 INC DI
 CALL AddNote.1
.2:
 POP AX

BASS:
;JMP DONE; THEME DEBUG (SKIP BASS)
 AND AL,3               ; 3/7/15 -> 4/8/16 notes
.F1:
 ADD AL,NOTE2-NOTE1     ; table offset
.F2:
 MOV CX,63
 CALL AddNote

DONE:

 MOV AL,173             ; vol 201 -> vol 135/2 (vol 67)
 MUL BH                 ; mastering

 JMP .1;.2
.F1:

 SHRD SI,BX,1
 NEG SI
 MUL SI
 SHR SI,10
 MOV [BP-BA+CUBE],SI
 XCHG AX,DX

.1:
 MOV [BP-BA+IRQ.SAMPLE-1],AH

if maxvol=1
;MOV AH,BH
 CMP [GS:8000H],AH
 JAE @F
 MOV [GS:8000H],AH
@@:
end if

.2:
 MOV  AL,20H
 OUT  20H,AL
 POPA
IRET

PART1:
 DW THEME.F1-1
 DB BASS-THEME.F1
 DW FIX1
 DB 72H
 DW FIX3
 DB 7DH
PART2:
 DW BASS.F1-1
 DB 15
 DW FIX4-2
 DB 0EBH
 DW FIX5
 DB 07FH
 DW FIX8
 DB 07FH
PART3:
 DW FIX8
 DB 07CH
PART4:
 DW FIX5
 DB 07CH
PART5:
 DW FIX2-2
 DB TraceCube-FIX2
PART6:
 DW FIX9-1
 DB CUBE2-BB
PART7:
 DW BASS.F1-1
 DB 7
 DW BASS.F2-1
 DB NOTE2-NOTE1+4
 DW FIX1
 DB 78H
 DW FIX2-2
 DB TraceCube-1-FIX2
PART8:
 DW BASS.F1-1
 DB 15
 DW BASS.F2-1
 DB NOTE2-NOTE1
 DW FIX1
 DB 72H
 DW FIX2-2
 DB TraceCube-FIX2
 DW FIX6
 DB 07FH
 DW FIX7
 DB 07FH
PART9:
 DW FIX5
 DB 07FH
 DW FIX8
 DB 07FH
PART10:
 DW FIX6
 DB 07CH
 DW FIX7
 DB 07CH
 DW FIX8
 DB 07CH
PART11:
 DW BASS.F1-1
 DB 7
 DW BASS.F2-1
 DB NOTE2-NOTE1+4
 DW FIX5
 DB 07CH
 DW FIX1
 DB 78H
PART12:
 DW DONE.F1-1
 DB 0
 DW FIX1
 DB 72H
 DW FIX0
 DB 77H
PART13:
PART14:
 DW IRQ.F1-1
 DB IRQ.SKIP2-IRQ.F1
PART15:

AddNote:
 XCHG DI,AX
.1:
 SALC
 MOV AH,[BP+DI+NOTE1-BA]; get note
 MUL SI                 ; converting to freq
 AND DX,CX              ; sawtooth wave
 IMUL AX,SI,-32         ; volume env
 MUL DX                 ; DL: sample
 ADD BH,DL
RETN
; --------------------------- feel the beat ! -------------------------------

CUBE: DB 64,0
HOLE:;DD 1.75
CUBE2: DB 38,0,224,63

MAXCOLOR: DB 56;,0
SYNC: DB 0,0,16;,0
SPEED: DB 0,50H

BB:
DB 'ABADDON$'

