INCLUDE gba_common.ld

__text_start  = ORIGIN(ewram);

SECTIONS {
    /* VMA LAYOUT:
     *
     * IWRAM:
     * * fast code
     * * fast rodata
     * * fast data
     * * fast bss
     * * STACK
     * EWRAM:
     * * boot code
     * * slow code
     * * rodata
     * * code
     * * ewram rodata
     * * data
     * * bss
     * * HEAP
     */

    /* EWRAM stuff */

    . = ORIGIN(ewram);
    __text_start = .;
    .text.crt0 :
    {
        . = ALIGN(4);
        KEEP (*(.text.crt0 .text.startup))
    } >ewram =0xff

    .text.slow :
    {
        . = ALIGN(4);
        *(.text.rom .text.slow .text.unlikely)
    } >ewram =0xff

    .rodata :
    {
        . = ALIGN(4);
        *(.rodata.rom .rodata)
    } >ewram =0xff
    __romrep_end = . /*__text_start + SIZEOF(.text.crt0) + SIZEOF(.text.slow)
                                + SIZEOF(.rodata)*/;

    /* IWRAM stuff */

    __iwram_lma = .;
    .iwram ORIGIN(iwram) : AT (__iwram_lma)
    {
        __iwram_startv = ABSOLUTE(.);
        . = ALIGN(2);
        *(.text.isr .text.iwram .text.hot .text.arm)
        *(.iwram*)
        *(.rodata.iwram)
    } >iwram = 0xff

    __iwdata_lma = __iwram_lma + SIZEOF(.iwram);
    .data.iwram ALIGN(4) : AT (__iwdata_lma)
    {
        *(.data.iwram)
    } >iwram =0xff

    __iwram_endl = __iwdata_lma + SIZEOF(.data.iwram);
    __iwram_endv = ABSOLUTE(.); /*ORIGIN(iwram) + SIZEOF(.iwram) + SIZEOF(.data.iwram);*/

    .bss.iwram ALIGN(4) (NOLOAD) :
    {
        PROVIDE(__iwbss_start = ABSOLUTE(.));
        *(.bss.iwram* .sbss*)
    } AT>iwram

    .stack ALIGN(4) (NOLOAD) :
    {
        __sp_max = ABSOLUTE(.);
        ASSERT(__sp_max < __sp_sys - __min_stack_size, "No space left for stack!");
    } AT>iwram

    /* EWRAM stuff */

    __ewram_lma = __iwdata_lma + SIZEOF(.data.iwram);
    .ewram __romrep_end : AT (__ewram_lma)
    {
        __ewram_startv = ABSOLUTE(.);
        . = ALIGN(2);
        *(.text.ewram .text .text.thumb)
        *(.ewram)
        *(.rodata.ewram)
    } >ewram =0xff

    __ewdata_lma = __ewram_lma + SIZEOF(.ewram);
    .data ALIGN(2) : AT(__ewdata_lma)
    {
        *(.data .data.ewram)
    } >ewram =0xff

    __ewram_endl = __ewdata_lma + SIZEOF(.data);
    __ewram_endv = ABSOLUTE(.); /*ORIGIN(ewram) + SIZEOF(.ewram) + SIZEOF(.data);*/

    .bss ALIGN(2) (NOLOAD) :
    {
        PROVIDE(__ewbss_start = ABSOLUTE(.));
        *(.bss .bss.ewram)
    } AT>ewram

    .heap ALIGN(4) (NOLOAD) :
    {
        __heap_start = ABSOLUTE(.);
        PROVIDE(__heap_start = __heap_start);
        /*. = __heap_end;*/
        ASSERT(__heap_start < __heap_end - __min_heap_size, "No space left for heap!");
    }

    __rom_end = __ewdata_lma + SIZEOF(.data);
}

